#
# identification section
#
qcnic_identification = {
   "name"            : "qcnic",
   "module type"     : "device driver",
   "binary compat"   : "yes",
   "summary"         : "QLogic E3 Common Interface driver",
   "description"     : "QLogic E3 Common Interface driver",
# Versioning:
# Major no. to represent OS 1: ESX55, 2: ESX60
# Sub Major no. to represent FW Version
# Minor no. to represent driver release
# Sub Monor no. to represent driver patch release
   "version"         : "1.0.26.0",
   "license"         : "QLogic_Proprietary",
   "vendor"          : "QLogic",
   "vendor_code"     : "QLC",
   "vendor_email"    : "support@qlogic.com",
}

#
# Build the Driver Module
#
module_def = {
   "identification"  : qcnic_identification,
   "source files"    : [
			 "qcnic.c",
			 "qcnic_vmk.c",
		       ],
   "cc flags"	     : [
			 "-Wno-unused-variable",
			 "-Wno-unused-function",
			 "-DCNIC_STORAGE_IF",
		       ],
   "cc defs"         : [
			 # For vmk_ScsiSchedCommandCompletion.
			 # Remove when PR 956728 is fixed.
			 #"VMK_DEVKIT_HAS_API_VMKAPI_MPP",
			 # Macro for ESX DDK version
			 "CNIC_ISCSI_OOO_SUPPORT=1",
			 "VMWARE_ESX_DDK_VERSION=60000",
			 "Wall"
		       ],
}
qcnic_module = defineKernelModule(module_def)

#
# Build the Driver's Device Definition
#
device_def = {
	"identification"	: qcnic_identification,
	"device spec"		: "qcnic_devices.py",
}
qcnic_device_def = defineDeviceSpec(device_def)

#
# Build the VIB
#
qcnic_vib_def = {
   "identification"  : qcnic_identification,
   "payload"         : [ qcnic_module,
			 qcnic_device_def,
		       ],
   "vib properties"  : {
      "urls"                    : [ ],
      "provides"                : [	],
      "depends"                 : [ ],
      "maintenance-mode"        : True,
      "live-install-allowed"    : False,
      "live-remove-allowed"     : True,
      "stateless-ready"         : True,
      "acceptance-level"        : 'certified',
   }
}
qcnic_vib =  defineModuleVib(qcnic_vib_def)

#
# Build the Offline Bundle
#
qcnic_bulletin_def = {
   "identification" : qcnic_identification,
   "vib"            : qcnic_vib,
   "bulletin" : {
      # These elements show the default values for the corresponding items in bulletin.xml file
      # Uncomment a line if you need to use a different value
      #'severity'    : 'general',
      #'category'    : 'Enhancement',
      #'releaseType' : 'extension',
      #'urgency'     : 'Important',

      'kbUrl'       : 'http://kb.vmware.com/kb/example.html',

      # 1. At least one target platform needs to be specified with 'productLineID'
      # 2. The product version number may be specified explicitly, like 7.8.9,
      # or, when it's None or skipped, be a default one for the devkit
      # 3. 'locale' element is optional
      'platforms'   : [ {'productLineID':'ESXi'},
      #                 {'productLineID':'ESXi', 'version':"7.8.9", 'locale':''}
		      ]
   }
}
qcnic_bundle =  defineOfflineBundle(qcnic_bulletin_def)
