/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef _CNIC_VMK_H
#define _CNIC_VMK_H

#include <vmkapi.h>

#define INIT_STRUCT_FIELD(field, value) .field = value
#if !defined(ARRAY_SIZE)
#define ARRAY_SIZE(arr) (sizeof(arr) / sizeof(arr[0]))
#endif

#if !defined(CONFIG_CNIC_SRIOV)
#define IS_PF(cdev) true
#define IS_VF(cdev) false
#endif

#define trace_printk(fmt, arg ...)	\
do {					\
	;			  	\
} while(0)

struct ql_msix_entry {
	int have_irq;
	vmk_IntrCookie vector;
	vmk_uint16 entry;
//	struct rsp_que *rsp;
	vmk_IntrCookie intr_cookie;
	void *handler;
};

/* Errors/Catastrophic Events */
#define ql_vmk_pr_err(fmt, arg...) \
	vmk_AlertMessage("[%s:%d]" fmt"\n", __func__, __LINE__, ##arg)
/* Warning, something that might lead to Errors/Catastrophic Events */
#define ql_vmk_pr_notice(fmt, arg...) \
	vmk_WarningMessage("[%s:%d]" fmt"\n", __func__, __LINE__, ##arg)
/* Informational Events */
#define ql_vmk_pr(fmt, arg...) \
	vmk_LogMessage("[%s:%d]" fmt"\n", __func__, __LINE__, ##arg)
/* Informational Events, relevant for debug VMware builds only */
#define ql_vmk_dbg_pr(fmt, arg...) \
	vmk_LogDebugMessage("[%s:%d]" fmt"\n", __func__, __LINE__, ##arg)

#define ETH_HLEN        14              /* Total octets in header.  */

typedef enum {
	LOCK_RANK_LOWEST = 1,
	LOCK_RANK_MEDIUM,
	LOCK_RANK_HIGHEST,
} ql_vmk_lock_rank;

#define ql_vmk_list_each_entry(entryPtr, headerPtr, fieldInContainer, containerType) \
	for (entryPtr = VMK_LIST_ENTRY(vmk_ListFirst(headerPtr), containerType, fieldInContainer); \
		!vmk_ListIsAtEnd((headerPtr), &(entryPtr->fieldInContainer)); \
		entryPtr = VMK_LIST_ENTRY(vmk_ListNext(&entryPtr->fieldInContainer), containerType, fieldInContainer)) \

#define ql_vmk_list_each_entry_safe(entryPtr, nextPtr, headerPtr, fieldInContainer, containerType) \
	for (entryPtr = VMK_LIST_ENTRY(vmk_ListFirst(headerPtr), containerType, fieldInContainer), \
		nextPtr = VMK_LIST_ENTRY(vmk_ListNext(vmk_ListFirst(headerPtr)), containerType, fieldInContainer); \
		!vmk_ListIsAtEnd((headerPtr), &(entryPtr->fieldInContainer)); \
		entryPtr = nextPtr, nextPtr = VMK_LIST_ENTRY(vmk_ListNext(&nextPtr->fieldInContainer), containerType, fieldInContainer)) \

#define QL_VMK_ROUNDUP_POW_OF_TWO(n) VMK_UTIL_ROUNDUP(n, 2)

/*
 * VMware supported architectures are all little endian.
 * All cpu to le(16/32) conversions are no-op.
 */
#define QL_CPU_TO_LE8(x) (x)
#define QL_CPU_TO_LE16(x) (x)
#define QL_CPU_TO_LE32(x) (x)
#define QL_CPU_TO_LE64(x) (x)

#define QL_LE16_TO_CPU(x) (x)
#define QL_LE32_TO_CPU(x) (x)
#define QL_LE64_TO_CPU(x) (x)

#define QL_CPU_TO_LE32P(x) ((vmk_uint32 )*x)

#define QL_CONSTANT_CPU_TO_LE16(x) (x)
#define QL_CONSTANT_CPU_TO_LE32(x) (x)
#define QL_CONSTANT_CPU_TO_LE64(x) (x)

#define RD_REG_BYTE(addr)               *((volatile vmk_uint8 *) (addr))
#define RD_REG_WORD(addr)               *((volatile vmk_uint16 *) (addr))
#define RD_REG_DWORD(addr)              *((volatile vmk_uint32 *) (addr))
#define RD_REG_QWORD(addr)              *((volatile vmk_uint64 *) (addr))
#define WRT_REG_BYTE(data, addr)        *((volatile vmk_uint8 *)(addr)) = (data)
#define WRT_REG_WORD(data, addr)        *((volatile vmk_uint16 *)(addr)) = (data)
#define WRT_REG_DWORD(data, addr)       *((volatile vmk_uint32 *)(addr)) = (data)
#define WRT_REG_QWORD(data, addr)       *((volatile vmk_uint64 *)(addr)) = (data)

#ifndef BUILD_BUG_ON
#define BUILD_BUG_ON(condition) 0
#endif

#define MODERN_VLAN	1

#define PCI_VENDOR_ID	0x00
#define PCI_DEVICE_ID	0x02

/* DMA related Data Strucuture */
struct ql_vmk_dma_meta {
	vmk_SgArray *MachSg;
};

struct ql_vmk_cmpl {
	vmk_uint16		cmpl_event;
	vmk_uint16		cmpl_done;
	vmk_Lock		cmpl_lock;
};

#define GET_DMA_ADDR(x) ((vmk_uint64)(x).MachSg->elem[0].ioAddr)

typedef void (*ql_vmk_singlethread_workhandler_t) (void *);

typedef struct singlethread_workitem {
	vmk_ListLinks links;
	ql_vmk_singlethread_workhandler_t handler;
	void *data;
#define INACTIVE 0
#define ACTIVE	1
#define DELAY_ACTIVE 2
	int workitem_state;
} ql_vmk_singlethread_workitem_t;

typedef struct ql_vmk_singlethread_workqueue {
	vmk_WorldID world_id;
	void *data;
	vmk_Lock lock;
	vmk_ListLinks work_items;
	ql_vmk_singlethread_workitem_t tasklet_item;
	char name[40];
} ql_vmk_singlethread_workqueue_t;

typedef struct ql_vmk_tasklet {
	vmk_WorldID world_id;
	void (*func)(void *);
	void *data;
	char name[40];
} ql_vmk_tasklet_t;

#define QL_TRACE_BUFFER_SIZE	4096

typedef struct ql_alloc_trace_buffer_entry {
	vmk_uint64 address;
	vmk_uint32 size;
	vmk_TimeVal tv;
} ql_alloc_trace_buffer_entry_t;

typedef struct ql_alloc_trace_buffer {
	vmk_uint32 in_ptr;
	vmk_uint32 wrap_cnt;
	ql_alloc_trace_buffer_entry_t entry[QL_TRACE_BUFFER_SIZE];
} ql_alloc_trace_buffer_t;


extern void qed_msix_sp_int(void *tasklet, vmk_IntrCookie irq);

extern struct cnic_dev *cdev;
/* Prototypes */
void *ql_vmk_alloc(vmk_uint32 size);
inline void ql_vmk_free(void *buffer);
VMK_ReturnStatus ql_vmk_ack_int(void *client_data, vmk_IntrCookie intr_cookie);
VMK_ReturnStatus ql_vmk_lock_domain_create(vmk_LockDomainID *domain);
VMK_ReturnStatus ql_vmk_spin_lock_init(vmk_Lock *lock,
	ql_vmk_lock_rank lock_rank);
int ql_vmk_dma_map(struct cnic_dev *cdev, void *virtaddr, vmk_IOA *physaddr,
	vmk_uint32 size);
void ql_vmk_dma_unmap(struct cnic_dev *cdev, void *virtaddr, vmk_uint32 size);
void *ql_vmk_dma_alloc(struct cnic_dev *cdev, vmk_IOA *physaddr,
	vmk_uint32 size);
void ql_vmk_dma_free(struct cnic_dev *cdev, void *virtaddr, vmk_uint32 size);
void * ql_vmk_dma_slab_alloc(struct cnic_dev *cdev, vmk_SlabID slab_id,
	vmk_IOA *buffer, vmk_uint32 size);
void ql_vmk_dma_slab_free(struct cnic_dev *cdev, vmk_SlabID slab_id,
	void *virtaddr, vmk_uint32 size);
VMK_ReturnStatus ql_vmk_do_singlethread_work(void *data);
void ql_vmk_init_singlethread_workitem(ql_vmk_singlethread_workitem_t *item,
	ql_vmk_singlethread_workhandler_t handler, void *data);
void ql_vmk_singlethread_queue_work(ql_vmk_singlethread_workqueue_t *wq,
	ql_vmk_singlethread_workitem_t *item);
ql_vmk_singlethread_workqueue_t *ql_vmk_create_singlethread_workqueue(
	const char *name, vmk_WorldSchedClass prio);
void ql_vmk_destroy_singlethread_workqueue(ql_vmk_singlethread_workqueue_t *wq);
VMK_ReturnStatus ql_vmk_do_tasklet(void *data);
VMK_ReturnStatus ql_vmk_tasklet_init(ql_vmk_tasklet_t *tasklet,
	void (*func)(long unsigned int), void *data);
void ql_vmk_tasklet_schedule(ql_vmk_tasklet_t *tasklet);
void ql_vmk_tasklet_disable(ql_vmk_tasklet_t *tasklet);

extern struct qed_hwfn *hwfn;
extern struct qed_vf_info *vf;
extern struct qed_filter_ucast *params;

vmk_uint32 ql_vmk_bar_size(struct cnic_dev *cdev, vmk_uint8 bar_id);
int ql_vmk_vf_handle_bulletin(struct qed_hwfn *hwfn);
int ql_vmk_pci_find_ext_capability(struct cnic_dev *cdev, int cap);
void ql_vmk_iov_post_start_vport(struct qed_hwfn *hwfn, struct qed_vf_info *vf_info);
vmk_uint32 ql_vmk_iov_chk_ucast(struct qed_hwfn *hwfn, struct qed_vf_info *vf,
	struct qed_filter_ucast *params);
int ql_vmk_pf_vf_msg(struct qed_hwfn *hwfn, vmk_uint8 relative_vfid);

void ql_vmk_ref_init(vmk_atomic64 *refcount);
vmk_uint16 ql_vmk_ref_get(vmk_atomic64 *refcount);
vmk_uint16 ql_vmk_ref_put(vmk_atomic64 *refcount,
	void (*release)(vmk_atomic64 *refcount));
void ql_vmk_world_wakeup(struct ql_vmk_cmpl *cmpl);
VMK_ReturnStatus ql_vmk_wait_for_completion(struct ql_vmk_cmpl *cmpl, vmk_uint32 wait_time);
void ql_vmk_init_completion(struct ql_vmk_cmpl *cmpl);
void ql_vmk_dump_buffer(vmk_uint8 *b, vmk_uint32 size);
void ql_vmk_list_splice_tail_init(vmk_ListLinks *list, vmk_ListLinks *head);

int ql_vmk_request_irq(struct cnic_dev *cdev, vmk_IntrCookie intr_cookie,
	vmk_IntrHandler handler, const char *name, void *dev,
	vmk_IntrAcknowledge ack);
void ql_vmk_free_irq(struct cnic_dev *cdev, vmk_IntrCookie intr_cookie,
	void *handlerData);

/* SV: From qed_vmk_2.h */

typedef struct ql_vmk_singlethread_delayed_workitem {
	ql_vmk_singlethread_workitem_t work;
	vmk_Timer timer;
	ql_vmk_singlethread_workqueue_t *wq;
} ql_vmk_singlethread_delayed_workitem_t;

extern VMK_ReturnStatus ql_vmk_flush_singlethread_workqueue(ql_vmk_singlethread_workqueue_t *);

/* SV: new apis --start */
void ql_vmk_init_singlethread_delayed_workitem(
	ql_vmk_singlethread_delayed_workitem_t *);
VMK_ReturnStatus ql_vmk_queue_delayed_work(vmk_TimerQueue,
	ql_vmk_singlethread_workqueue_t *,
	ql_vmk_singlethread_delayed_workitem_t *,
	void *, void *, unsigned long);
void ql_vmk_handle_tmo(ql_vmk_singlethread_delayed_workitem_t *);
VMK_ReturnStatus ql_vmk_cancel_delayed_work(ql_vmk_singlethread_delayed_workitem_t *);
VMK_ReturnStatus ql_vmk_cancel_delayed_work_sync(ql_vmk_singlethread_delayed_workitem_t *);

void ql_vmk_mod_timer(vmk_Timer *, void *, void *, unsigned long, vmk_Bool);
void ql_vmk_reset_l2_l3_hdr(vmk_PktHandle *);
vmk_EthHdr *ql_vmk_get_l2_hdr(vmk_PktHandle *);
VMK_ReturnStatus ql_vmk_is_valid_ether_addr(vmk_uint8 *);
/* SV: new apis  --end */

extern void ql_vmk_ref_init(vmk_atomic64 *);
extern vmk_uint16 ql_vmk_ref_get(vmk_atomic64 *);
extern vmk_uint16 ql_vmk_ref_put(vmk_atomic64 *, void (*release)(vmk_atomic64 *));


/* included for some sriov defines */
#define CNIC_ETH_VF_NUM_VLAN_FILTERS 2

#define CNIC_ETH_MAX_VF_NUM_VLAN_FILTERS	\
	(MAX_NUM_VFS * CNIC_ETH_VF_NUM_VLAN_FILTERS)

#endif
