/*******************************************************************************
 * The information contained in this file is confidential and proprietary to
 * QLogic Corporation.  No part of this file may be reproduced or
 * distributed, in any form or by any means for any purpose, without the
 * express written permission of QLogic Corporation.
 *
 * (c) COPYRIGHT 2015 QLogic Corporation, ALL RIGHTS RESERVED.
 *******************************************************************************/
/* **********************************************************
 * Copyright 2015 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * qfle3_dcbx.h --
 *
 *      Header file for native qfle3 driver.
 */

#ifndef _QFLE3_DCBX_H_
#define _QFLE3_DCBX_H_

void qfle3_dcbx_start(struct qfle3_adapter *adapter);
void qfle3_dcbx_set_params(struct qfle3_adapter *adapter, vmk_uint32 state);
void qfle3_dcbx_pmf_update(struct qfle3_adapter *adapter);

typedef vmk_uint8 u8;
typedef vmk_uint16 u16;
typedef vmk_uint32 u32;

#define POWER_OF_2(x)	((0 != x) && (0 == (x & (x-1))))

#define DCBX_ILLEGAL_PG				(0xFF)
#define DCBX_PFC_PRI_MASK			(0xFF)
#define DCBX_STRICT_PRIORITY			(15)
#define DCBX_INVALID_COS_BW			(0xFFFFFFFF)
#define DCBX_COS_MAX_NUM_E2	ELINK_DCBX_E2E3_MAX_NUM_COS
#define DCBX_PFC_PRI_NON_PAUSE_MASK(adapter)		\
			((adapter)->dcbx_sb.port_params.pfc.priority_non_pauseable_mask)
#define DCBX_PFC_PRI_PAUSE_MASK(adapter)		\
					((u8)~DCBX_PFC_PRI_NON_PAUSE_MASK(adapter))
#define DCBX_PFC_PRI_GET_PAUSE(adapter, pg_pri)	\
				((pg_pri) & (DCBX_PFC_PRI_PAUSE_MASK(adapter)))
#define DCBX_PFC_PRI_GET_NON_PAUSE(adapter, pg_pri)	\
			(DCBX_PFC_PRI_NON_PAUSE_MASK(adapter) & (pg_pri))
#define DCBX_IS_PFC_PRI_SOME_PAUSE(adapter, pg_pri)	\
			(0 != DCBX_PFC_PRI_GET_PAUSE(adapter, pg_pri))
#define IS_DCBX_PFC_PRI_ONLY_PAUSE(adapter, pg_pri)	\
			(pg_pri == DCBX_PFC_PRI_GET_PAUSE((adapter), (pg_pri)))
#define IS_DCBX_PFC_PRI_ONLY_NON_PAUSE(adapter, pg_pri)\
			((pg_pri) == DCBX_PFC_PRI_GET_NON_PAUSE((adapter), (pg_pri)))
#define IS_DCBX_PFC_PRI_MIX_PAUSE(adapter, pg_pri)	\
			(!(IS_DCBX_PFC_PRI_ONLY_NON_PAUSE((adapter), (pg_pri)) || \
			 IS_DCBX_PFC_PRI_ONLY_PAUSE((adapter), (pg_pri))))

#define TCP_PORT_ISCSI		(0xCBC)
#define QFLE3_MAX_COS_SUPPORT   3
#define DCBX_COS_MAX_NUM_E3B0   QFLE3_MAX_COS_SUPPORT
#define DCBX_COS_MAX_NUM        QFLE3_MAX_COS_SUPPORT
#define LLFC_DRIVER_TRAFFIC_TYPE_MAX 3 /* NW, iSCSI, FCoE */

#define DCBX_LOCAL_MIB_MAX_TRY_READ		(100)

#define QFLE3_DCBX_FCOE_TX_COUNT 1
#define QFLE3_DCBX_FCOE_RX_COUNT 1

#if 0
struct qfle3_admin_priority_app_table {
		vmk_uint32 valid;
		vmk_uint32 priority;
#define INVALID_TRAFFIC_TYPE_PRIORITY	(0xFFFFFFFF)
		vmk_uint32 traffic_type;
#define TRAFFIC_TYPE_ETH		0
#define TRAFFIC_TYPE_PORT		1
		vmk_uint32 app_id;
};
#endif

enum {
	DCBX_READ_LOCAL_MIB,
	DCBX_READ_REMOTE_MIB
};

enum {
	QFLE3_DCBX_STATE_NEG_RECEIVED = 0x1,
	QFLE3_DCBX_STATE_TX_PAUSED,
	QFLE3_DCBX_STATE_TX_RELEASED
};

struct cos_entry_help_data {
	vmk_uint32 pri_join_mask;
	vmk_uint32 cos_bw;
	vmk_uint8 strict;
	vmk_Bool pausable;
};

struct cos_help_data {
	struct cos_entry_help_data	data[DCBX_COS_MAX_NUM];
	vmk_uint8 num_of_cos;
};


struct pg_entry_help_data {
	vmk_uint8 num_of_dif_pri;
	vmk_uint8 pg;
	vmk_uint32 pg_priority;
};

struct pg_help_data {
	struct pg_entry_help_data	data[LLFC_DRIVER_TRAFFIC_TYPE_MAX];
	vmk_uint8 num_of_pg;
};


struct qfle3_dcbx_app_params {
	vmk_uint32 enabled;
	vmk_uint32 traffic_type_priority[LLFC_DRIVER_TRAFFIC_TYPE_MAX];
};

struct qfle3_dcbx_cos_params {
        vmk_uint32     bw_tbl;
        vmk_uint32     pri_bitmask;
        /*
         * strict priority: valid values are 0..5; 0 is highest priority.
         * There can't be two COSes with the same priority.
         */
        vmk_uint8      strict;
#define QFLE3_DCBX_STRICT_INVALID                       DCBX_COS_MAX_NUM
#define QFLE3_DCBX_STRICT_COS_HIGHEST                   0
#define QFLE3_DCBX_STRICT_COS_NEXT_LOWER_PRI(sp)        ((sp) + 1)
        vmk_uint8      pauseable;
};

struct qfle3_dcbx_pg_params {
	vmk_uint32 enabled;
	vmk_uint8 num_of_cos; /* valid COS entries */
	struct qfle3_dcbx_cos_params	cos_params[DCBX_COS_MAX_NUM];
};

struct qfle3_dcbx_pfc_params {
	vmk_uint32 enabled;
	vmk_uint32 priority_non_pauseable_mask;
};

struct qfle3_dcbx_port_params {
	struct qfle3_dcbx_pfc_params pfc;
	struct qfle3_dcbx_pg_params  ets;
	struct qfle3_dcbx_app_params app;
};

struct qfle3_dcbx_sb {
   /* Enable / Disable DCBX */
   vmk_uint32 enabled;

   vmk_uint32 state;
   vmk_uint8 dcb_version;

   /* DCBX Negotiation results */
   struct dcbx_features local_feat; /*ecore*/
   vmk_uint32 dcbx_error;
   struct qfle3_dcbx_port_params port_params;
   vmk_uint8 prio_to_cos[8]; /* priority to cos mapping */

   vmk_Helper dcbx_task;

   /* FCoE queue specific data */
   vmk_UplinkQueueID fcoe_txq_id;
   vmk_UplinkQueueID fcoe_rxq_id;
};
#endif
