/*******************************************************************************
 * The information contained in this file is confidential and proprietary to
 * QLogic Corporation.  No part of this file may be reproduced or
 * distributed, in any form or by any means for any purpose, without the
 * express written permission of QLogic Corporation.
 *
 * (c) COPYRIGHT 2016 QLogic Corporation, ALL RIGHTS RESERVED.
 *******************************************************************************/


#ifndef __QFLE3_ECORE_REG_H__
#define __QFLE3_ECORE_REG_H__
 

#define ATC_REG_ATC_NUM_SETS                                                                                               0x110000UL //ACCESS:RW  DataWidth:0x2  Description: Defines the number of sets - 3 - 256 ;2- 128; 1- 64; 0- 32
#define ATC_REG_ATC_1_WAY                                                                                                  0x110004UL //ACCESS:RW  DataWidth:0x1  Description: If set the ATC will use only one way per set
#define ATC_REG_ATC_FULL_REG                                                                                               0x110008UL //ACCESS:R  DataWidth:0x8  Description: SPA Done FIFO full bit; RCPL FIFO full bit; TCPL FIFO full bit; IREQ full bit; PLKP FIFO full bit; MLKP FIFO full bit; OTB full bit; OIB full bit
#define ATC_REG_ATC_EMPTY_REG                                                                                              0x11000cUL //ACCESS:R  DataWidth:0x8  Description: SPA Done FIFO empty bit; RCPL FIFO empty bit; TCPL FIFO empty bit; IREQ empty bit; PLKP FIFO empty bit; MLKP FIFO empty bit; OTB empty bit; OIB empty bit
#define ATC_REG_ATC_WAIT_IF_MISS                                                                                           0x110010UL //ACCESS:RW  DataWidth:0x1  Description: WaitIfMiss configuration bit
#define ATC_REG_ATC_WAIT_IF_PENDING                                                                                        0x110014UL //ACCESS:RW  DataWidth:0x1  Description: WaitTransPending cofiguration bit
#define ATC_REG_ATC_STALL_SEQ_0                                                                                            0x110018UL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_STALL_SEQ_1                                                                                            0x11001cUL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_STALL_SEQ_2                                                                                            0x110020UL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_STALL_SEQ_3                                                                                            0x110024UL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_STALL_SEQ_4                                                                                            0x110028UL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_STALL_SEQ_5                                                                                            0x11002cUL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_SET_STALL_SEQ_0                                                                                        0x110030UL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall in case of 2 consecutive accesses to the same set (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y to the same set; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_SET_STALL_SEQ_1                                                                                        0x110034UL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall in case of 2 consecutive accesses to the same set (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y to the same set; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_SET_STALL_SEQ_2                                                                                        0x110038UL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall in case of 2 consecutive accesses to the same set (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y to the same set; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_SET_STALL_SEQ_3                                                                                        0x11003cUL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall in case of 2 consecutive accesses to the same set (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y to the same set; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_SET_STALL_SEQ_4                                                                                        0x110040UL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall in case of 2 consecutive accesses to the same set (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y to the same set; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_SET_STALL_SEQ_5                                                                                        0x110044UL //ACCESS:RW  DataWidth:0x6  Description: Indicates the B2B event sequnece which will cause stall in case of 2 consecutive accesses to the same set (on the second event). The order of the vectors is 0-Mlkp;1-Plkp;2-Ireq;3-Tcpl;4-SPA-Done;5-Rcpl. The order of the bits inside the vector is the same. Stall is taking place when there is a sequence of two events X and than Y to the same set; and atc_stall_seq[X][Y] is set to 1. Comment for E2: stall is not available for lookups due to the bounded latency restriction
#define ATC_REG_ATC_DISABLE_BYPASS                                                                                         0x110048UL //ACCESS:RW  DataWidth:0x1  Description: disables the bypass on the GPA table
#define ATC_REG_ATC_ISSUE_4_CYCLES                                                                                         0x11004cUL //ACCESS:RW  DataWidth:0x1  Description: Issue event once in four cycles (instead of 2)
#define ATC_REG_ATC_IREQ_FIFO_SIZE                                                                                         0x110050UL //ACCESS:RW  DataWidth:0x8  Description: defines the size of the IREQ fifo
#define ATC_REG_ATC_IREQ_ALMOST_FULL_THR                                                                                   0x110054UL //ACCESS:RW  DataWidth:0x8  Description: Debug only: defines the IFIFO almost full threshold. Its size can't be bigger than the Ireq FIFO size
#define ATC_REG_ATC_PIGGYBACKED_TREQ_EN                                                                                    0x110058UL //ACCESS:RW  DataWidth:0x1  Description: Piggybacked treq issue enabled
#define ATC_REG_ATC_WAIT_RESP                                                                                              0x11005cUL //ACCESS:RW  DataWidth:0x1  Description: Allows the ATC to return Wait response
#define ATC_REG_ATC_TREQ_CREDITS                                                                                           0x110060UL //ACCESS:RW  DataWidth:0x6  Description: Number of credits for the treq interface
#define ATC_REG_ATC_ARBITER_PRIO_MLKP                                                                                      0x110064UL //ACCESS:RW  DataWidth:0x2  Description: MLKP prio
#define ATC_REG_ATC_ARBITER_PRIO_PLKP                                                                                      0x110068UL //ACCESS:RW  DataWidth:0x2  Description: PLKP prio
#define ATC_REG_ATC_ARBITER_PRIO_IREQ                                                                                      0x11006cUL //ACCESS:RW  DataWidth:0x2  Description: IREQ prio
#define ATC_REG_ATC_ARBITER_PRIO_TCPL                                                                                      0x110070UL //ACCESS:RW  DataWidth:0x2  Description: TCPL prio
#define ATC_REG_ATC_ARBITER_PRIO_SPAD                                                                                      0x110074UL //ACCESS:RW  DataWidth:0x2  Description: SPAD prio
#define ATC_REG_ATC_ARBITER_PRIO_RCPL                                                                                      0x110078UL //ACCESS:RW  DataWidth:0x2  Description: RCPL prio
#define ATC_REG_ATC_OTB_MAX_ENTRY                                                                                          0x11007cUL //ACCESS:RW  DataWidth:0x5  Description: Defines the number of entries in the OTB when 31 indicates 32 entries (entries count begins in 0)
#define ATC_REG_ATC_CHECK_TAGS                                                                                             0x110080UL //ACCESS:RW  DataWidth:0x1  Description: CheckTags configuration bit - when set the available NPH credits is checked before issuing TREQ
#define ATC_REG_ATC_TAG_THR                                                                                                0x110084UL //ACCESS:RW  DataWidth:0x8  Description: TAG threshold - for the checkTags feature
#define ATC_REG_ATC_ICPL_CREDIT                                                                                            0x110088UL //ACCESS:RW  DataWidth:0x3  Description: Credit value for the ICPL interface
#define ATC_REG_ATC_DIS_MLKP                                                                                               0x11008cUL //ACCESS:RW  DataWidth:0x1  Description: Disables the main lookup interface
#define ATC_REG_ATC_DIS_PLKP                                                                                               0x110090UL //ACCESS:RW  DataWidth:0x1  Description: Disables the pre lookup interface
#define ATC_REG_ATC_DIS_IREQ                                                                                               0x110094UL //ACCESS:RW  DataWidth:0x1  Description: Disables the invalidation request interface
#define ATC_REG_ATC_DIS_TCPL                                                                                               0x110098UL //ACCESS:RW  DataWidth:0x1  Description: Disables the translation completion interface
#define ATC_REG_ATC_DIS_SPAD                                                                                               0x11009cUL //ACCESS:RW  DataWidth:0x1  Description: Disables the spa done interface
#define ATC_REG_ATC_DIS_RCPL                                                                                               0x1100a0UL //ACCESS:RW  DataWidth:0x1  Description: Disables the Read Completion interface
#define ATC_REG_ATC_DIS_LKPRES                                                                                             0x1100a4UL //ACCESS:RW  DataWidth:0x1  Description: Disables the lookup response interface
#define ATC_REG_ATC_DIS_TREQ                                                                                               0x1100a8UL //ACCESS:RW  DataWidth:0x1  Description: Disables the translation request interface
#define ATC_REG_ATC_DIS_ICPL                                                                                               0x1100acUL //ACCESS:RW  DataWidth:0x1  Description: Disables the invalidation completion interface
#define ATC_REG_ATC_SCRUB_CYC                                                                                              0x1100b0UL //ACCESS:RW  DataWidth:0x8  Description: Number of cycles between one scrub event to another
#define ATC_REG_ATC_SCRUB_DIS                                                                                              0x1100b4UL //ACCESS:RW  DataWidth:0x1  Description: Disable bit for the scrubbing event of the GPA table
#define ATC_REG_ATC_INIT_ARRAY                                                                                             0x1100b8UL //ACCESS:RW  DataWidth:0x1  Description: Initiate the ATC array - reset all the valid bits
#define ATC_REG_ATC_INIT_DONE                                                                                              0x1100bcUL //ACCESS:R  DataWidth:0x1  Description: ATC initalization done
#define ATC_REG_ATC_STAT_MLKP_HITS                                                                                         0x1100c0UL //ACCESS:ST  DataWidth:0x20  Description: Number of hits for Main-lookups in the ATC
#define ATC_REG_ATC_STAT_MLKP_NUM                                                                                          0x1100c4UL //ACCESS:ST  DataWidth:0x20  Description: Number of Main lookups in the ATC
#define ATC_REG_ATC_STAT_PLKP_TREQ                                                                                         0x1100c8UL //ACCESS:ST  DataWidth:0x20  Description: Number of treqs issued due to pre-lookup
#define ATC_REG_ATC_STAT_PLKP_NUM                                                                                          0x1100ccUL //ACCESS:ST  DataWidth:0x20  Description: Number of Pre Lookps in the ATC
#define ATC_REG_ATC_STAT_EVICT_NUM                                                                                         0x1100d0UL //ACCESS:ST  DataWidth:0x20  Description: Number of evictions out of the ATC
#define ATC_REG_ATC_STAT_INV_NUM                                                                                           0x1100d4UL //ACCESS:ST  DataWidth:0x20  Description: Number of invalidations handled by the ATC
#define ATC_REG_ATC_STAT_TREQ_NUM                                                                                          0x1100d8UL //ACCESS:ST  DataWidth:0x20  Description: Number of translation requests issued by the ATC
#define ATC_REG_ATC_STAT_ACTIVE                                                                                            0x1100dcUL //ACCESS:RW  DataWidth:0x1  Description: When this signal is set the statistics count is on
#define ATC_REG_ATC_STAT_USDM_LKP_NUM                                                                                      0x1100e0UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_USDM_HIT_NUM                                                                                      0x1100e4UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_CSDM_LKP_NUM                                                                                      0x1100e8UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_CSDM_HIT_NUM                                                                                      0x1100ecUL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_XSDM_LKP_NUM                                                                                      0x1100f0UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_XSDM_HIT_NUM                                                                                      0x1100f4UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_TSDM_LKP_NUM                                                                                      0x1100f8UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_TSDM_HIT_NUM                                                                                      0x1100fcUL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_PBF_LKP_NUM                                                                                       0x110100UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_PBF_HIT_NUM                                                                                       0x110104UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_QM_LKP_NUM                                                                                        0x110108UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_QM_HIT_NUM                                                                                        0x11010cUL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_TM_LKP_NUM                                                                                        0x110110UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_TM_HIT_NUM                                                                                        0x110114UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_SRC_LKP_NUM                                                                                       0x110118UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_SRC_HIT_NUM                                                                                       0x11011cUL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_CDURD_LKP_NUM                                                                                     0x110120UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_CDURD_HIT_NUM                                                                                     0x110124UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_DMAE_LKP_NUM                                                                                      0x110128UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_DMAE_HIT_NUM                                                                                      0x11012cUL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_USDM_DP_LKP_NUM                                                                                   0x110130UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_USDM_DP_HIT_NUM                                                                                   0x110134UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_HC_LKP_NUM                                                                                        0x110138UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_HC_HIT_NUM                                                                                        0x11013cUL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_CDUWR_LKP_NUM                                                                                     0x110140UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_CDUWR_HIT_NUM                                                                                     0x110144UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_DBG_LKP_NUM                                                                                       0x110148UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_DBG_HIT_NUM                                                                                       0x11014cUL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_L2P_LKP_NUM                                                                                       0x110150UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_STAT_L2P_HIT_NUM                                                                                       0x110154UL //ACCESS:ST  DataWidth:0x20  Description: Count lookups and hit for the different clients
#define ATC_REG_ATC_GPA_HASH_EN                                                                                            0x110158UL //ACCESS:RW  DataWidth:0x1  Description: enable the use of a hash function for the GPA table; instead of the lsb bits of the address
#define ATC_REG_ATC_GPA_HASH_CRC                                                                                           0x11015cUL //ACCESS:RW  DataWidth:0x1  Description: relevant only if hash_en is set. selects the CRC as hash function for the GPA table; If reset use xor of the FID LS bits with the relevant bits out of the GPA as hash function 
#define ATC_REG_ATC_TCPL_LOG_ON_ERROR                                                                                      0x110160UL //ACCESS:RW  DataWidth:0x5  Description: In case of TCPL with error log the relevant data. The seperation for the different errors is: BME clear [0]; Unsupported request [1]; Completer abort/completion timeout [2]; Both R & W bits are reset [3]; Other [4]
#define ATC_REG_ATC_TCPL_DIS_ON_ERROR                                                                                      0x110164UL //ACCESS:RW  DataWidth:0x5  Description: In case of TCPL with error disable the ATC.  The seperation for the different errors is: BME clear [0]; Unsupported request [1]; Completer abort/completion timeout [2]; Both R & W bits are reset [3]; Other [4]
#define ATC_REG_ATC_TCPL_ERR_LOG                                                                                           0x110168UL //ACCESS:R  DataWidth:0x16  Description: Data belongs to an erroneous TCPL: [9:0] Func (VF_Valid;VFID;PFID);[10] U bit; [11] W bit; [12] R bit; [13] NS bit; [18:14] OTBEntryID;[21:19] Error code          
#define ATC_REG_ATC_TCPL_ERR_ADDR_LSB                                                                                      0x11016cUL //ACCESS:R  DataWidth:0x20  Description: Data belongs to an erroneous TCPL: [31:0]-bits [31:0] of the address
#define ATC_REG_ATC_TCPL_ERR_ADDR_MSB                                                                                      0x110170UL //ACCESS:R  DataWidth:0x14  Description: Data belongs to an erroneous TCPL: [19:0]-bits [51:32] of the address
#define ATC_REG_ATC_TCPL_ERR_LOG_VALID                                                                                     0x110174UL //ACCESS:R  DataWidth:0x1  Description: Indicates valid data at the tcpl error log registers
#define ATC_REG_ATC_ARRAY_ACCESS_ENABLE                                                                                    0x110178UL //ACCESS:RW  DataWidth:0x1  Description: Allows GRC access to the GPA and SPA table
#define ATC_REG_ATC_DURING_FLI                                                                                             0x11017cUL //ACCESS:R  DataWidth:0x1  Description: Indication that the ATC currently handles FLI
#define ATC_REG_ATC_DURING_INV                                                                                             0x110180UL //ACCESS:R  DataWidth:0x1  Description: Indication that the ATC currently handles Any type of invalidation
#define ATC_REG_ATC_FLI_DONE_VF_31_0                                                                                       0x110184UL //ACCESS:R  DataWidth:0x20  Description: Indicates the end of FLI flow for VF 31-0
#define ATC_REG_ATC_FLI_DONE_VF_63_32                                                                                      0x110188UL //ACCESS:R  DataWidth:0x20  Description: Indicates the end of FLI flow for VF 63-32
#define ATC_REG_ATC_FLI_DONE_PF_7_0                                                                                        0x11018cUL //ACCESS:R  DataWidth:0x8  Description: Indicates the end of FLI flow for PF 7-0
#define ATC_REG_ATC_FLI_DONE_CLR_VF_31_0                                                                                   0x110190UL //ACCESS:RW  DataWidth:0x20  Description: Clears the FLI done indication for VF bits 31-0 accordingly
#define ATC_REG_ATC_FLI_DONE_CLR_VF_63_32                                                                                  0x110194UL //ACCESS:RW  DataWidth:0x20  Description: Clears the FLI done indication for VFbits 63-32 accordingly
#define ATC_REG_ATC_FLI_DONE_CLR_PF_7_0                                                                                    0x110198UL //ACCESS:RW  DataWidth:0x8  Description: Clears the FLI done indication for PF bits 7-0 accordingly
#define ATC_REG_DBG_SELECT                                                                                                 0x11019cUL //ACCESS:RW  DataWidth:0x8  Description: Debug only: For dbgmux usage (debug data that goes from PXP to the DBG block) - for selecting a line to output to the DBG block.
#define ATC_REG_DBG_BYTE_ENABLE                                                                                            0x1101a0UL //ACCESS:RW  DataWidth:0x8  Description: Debug only: For dbgmux usage (debug data that goes from PXP to the DBG block) - for enabling bytes in the selected line (after the select and before the shift)
#define ATC_REG_DBG_SHIFT                                                                                                  0x1101a4UL //ACCESS:RW  DataWidth:0x3  Description: Debug only: For dbgmux usage (debug data that goes from PXP to the DBG block) - for circular right shifting of the selected line (after the enabling)
#define ATC_REG_DBGSYN_ALMOST_FULL_THR                                                                                     0x1101a8UL //ACCESS:RW  DataWidth:0x4  Description: Debug only: If more than this Number of entries are occupied in the dbgsyn clock synchronization FIFO; it does not enable writing to the fifo. This value is based on implementation and should not be changed. Its value can't be bigger than the set dbg FIFO size
#define ATC_REG_ATC_ALLOW_LOW_REP_HIGH                                                                                     0x1101acUL //ACCESS:RW  DataWidth:0x1  Description: When set low priority lookup can replace high priority entry; iff the set is full with high prio entries
#define ATC_REG_ATC_DIS_IREQ_EVENT                                                                                         0x1101b0UL //ACCESS:RW  DataWidth:0x1  Description: When set Ireq event won't be selected by the ATC arbiter
#define ATC_REG_ATC_ECO_RESERVED                                                                                           0x1101b4UL //ACCESS:RW  DataWidth:0x1  Description: For future ECOs implementation
#define ATC_REG_ATC_TM                                                                                                     0x1101b8UL //ACCESS:RW  DataWidth:0x1e  Multi Field Register		
	#define ATC_ATC_TM_REG_ATC_SPA_TABLE_TM                                                                                (0x1f<<0)
	#define ATC_ATC_TM_REG_ATC_SPA_TABLE_TM_SIZE                                                                           0		
	#define ATC_ATC_TM_REG_ATC_GPA_DATA_W0_TM                                                                              (0x1f<<5)
	#define ATC_ATC_TM_REG_ATC_GPA_DATA_W0_TM_SIZE                                                                         5		
	#define ATC_ATC_TM_REG_ATC_GPA_DATA_W1_TM                                                                              (0x1f<<10)
	#define ATC_ATC_TM_REG_ATC_GPA_DATA_W1_TM_SIZE                                                                         10		
	#define ATC_ATC_TM_REG_ATC_GPA_DATA_W2_TM                                                                              (0x1f<<15)
	#define ATC_ATC_TM_REG_ATC_GPA_DATA_W2_TM_SIZE                                                                         15		
	#define ATC_ATC_TM_REG_ATC_GPA_DATA_W3_TM                                                                              (0x1f<<20)
	#define ATC_ATC_TM_REG_ATC_GPA_DATA_W3_TM_SIZE                                                                         20		
	#define ATC_ATC_TM_REG_ATC_GPA_STATE_TM                                                                                (0x1f<<25)
	#define ATC_ATC_TM_REG_ATC_GPA_STATE_TM_SIZE                                                                           25
#define ATC_REG_ATC_INT_STS                                                                                                0x1101bcUL //ACCESS:R  DataWidth:0x6  Description: Interrupt register #0 read		
	#define ATC_ATC_INT_STS_REG_ADDRESS_ERROR                                                                              (0x1<<0)
	#define ATC_ATC_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                         0		
	#define ATC_ATC_INT_STS_REG_ATC_TCPL_TO_NOT_PEND                                                                       (0x1<<1)
	#define ATC_ATC_INT_STS_REG_ATC_TCPL_TO_NOT_PEND_SIZE                                                                  1		
	#define ATC_ATC_INT_STS_REG_ATC_GPA_MULTIPLE_HITS                                                                      (0x1<<2)
	#define ATC_ATC_INT_STS_REG_ATC_GPA_MULTIPLE_HITS_SIZE                                                                 2		
	#define ATC_ATC_INT_STS_REG_ATC_RCPL_TO_EMPTY_CNT                                                                      (0x1<<3)
	#define ATC_ATC_INT_STS_REG_ATC_RCPL_TO_EMPTY_CNT_SIZE                                                                 3		
	#define ATC_ATC_INT_STS_REG_ATC_TCPL_ERROR                                                                             (0x1<<4)
	#define ATC_ATC_INT_STS_REG_ATC_TCPL_ERROR_SIZE                                                                        4		
	#define ATC_ATC_INT_STS_REG_ATC_IREQ_LESS_THAN_STU                                                                     (0x1<<5)
	#define ATC_ATC_INT_STS_REG_ATC_IREQ_LESS_THAN_STU_SIZE                                                                5
#define ATC_REG_ATC_INT_STS_CLR                                                                                            0x1101c0UL //ACCESS:RC  DataWidth:0x6  Description: Interrupt register #0 read clear		
	#define ATC_ATC_INT_STS_CLR_REG_ADDRESS_ERROR                                                                          (0x1<<0)
	#define ATC_ATC_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                     0		
	#define ATC_ATC_INT_STS_CLR_REG_ATC_TCPL_TO_NOT_PEND                                                                   (0x1<<1)
	#define ATC_ATC_INT_STS_CLR_REG_ATC_TCPL_TO_NOT_PEND_SIZE                                                              1		
	#define ATC_ATC_INT_STS_CLR_REG_ATC_GPA_MULTIPLE_HITS                                                                  (0x1<<2)
	#define ATC_ATC_INT_STS_CLR_REG_ATC_GPA_MULTIPLE_HITS_SIZE                                                             2		
	#define ATC_ATC_INT_STS_CLR_REG_ATC_RCPL_TO_EMPTY_CNT                                                                  (0x1<<3)
	#define ATC_ATC_INT_STS_CLR_REG_ATC_RCPL_TO_EMPTY_CNT_SIZE                                                             3		
	#define ATC_ATC_INT_STS_CLR_REG_ATC_TCPL_ERROR                                                                         (0x1<<4)
	#define ATC_ATC_INT_STS_CLR_REG_ATC_TCPL_ERROR_SIZE                                                                    4		
	#define ATC_ATC_INT_STS_CLR_REG_ATC_IREQ_LESS_THAN_STU                                                                 (0x1<<5)
	#define ATC_ATC_INT_STS_CLR_REG_ATC_IREQ_LESS_THAN_STU_SIZE                                                            5
#define ATC_REG_ATC_INT_STS_WR                                                                                             0x1101c4UL //ACCESS:WR  DataWidth:0x6  Description: Interrupt register #0 bit set or clear		
	#define ATC_ATC_INT_STS_WR_REG_ADDRESS_ERROR                                                                           (0x1<<0)
	#define ATC_ATC_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                      0		
	#define ATC_ATC_INT_STS_WR_REG_ATC_TCPL_TO_NOT_PEND                                                                    (0x1<<1)
	#define ATC_ATC_INT_STS_WR_REG_ATC_TCPL_TO_NOT_PEND_SIZE                                                               1		
	#define ATC_ATC_INT_STS_WR_REG_ATC_GPA_MULTIPLE_HITS                                                                   (0x1<<2)
	#define ATC_ATC_INT_STS_WR_REG_ATC_GPA_MULTIPLE_HITS_SIZE                                                              2		
	#define ATC_ATC_INT_STS_WR_REG_ATC_RCPL_TO_EMPTY_CNT                                                                   (0x1<<3)
	#define ATC_ATC_INT_STS_WR_REG_ATC_RCPL_TO_EMPTY_CNT_SIZE                                                              3		
	#define ATC_ATC_INT_STS_WR_REG_ATC_TCPL_ERROR                                                                          (0x1<<4)
	#define ATC_ATC_INT_STS_WR_REG_ATC_TCPL_ERROR_SIZE                                                                     4		
	#define ATC_ATC_INT_STS_WR_REG_ATC_IREQ_LESS_THAN_STU                                                                  (0x1<<5)
	#define ATC_ATC_INT_STS_WR_REG_ATC_IREQ_LESS_THAN_STU_SIZE                                                             5
#define ATC_REG_ATC_INT_MASK                                                                                               0x1101c8UL //ACCESS:RW  DataWidth:0x6  Description: Interrupt mask register #0 read/write		
	#define ATC_ATC_INT_MASK_REG_ADDRESS_ERROR                                                                             (0x1<<0)
	#define ATC_ATC_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                        0		
	#define ATC_ATC_INT_MASK_REG_ATC_TCPL_TO_NOT_PEND                                                                      (0x1<<1)
	#define ATC_ATC_INT_MASK_REG_ATC_TCPL_TO_NOT_PEND_SIZE                                                                 1		
	#define ATC_ATC_INT_MASK_REG_ATC_GPA_MULTIPLE_HITS                                                                     (0x1<<2)
	#define ATC_ATC_INT_MASK_REG_ATC_GPA_MULTIPLE_HITS_SIZE                                                                2		
	#define ATC_ATC_INT_MASK_REG_ATC_RCPL_TO_EMPTY_CNT                                                                     (0x1<<3)
	#define ATC_ATC_INT_MASK_REG_ATC_RCPL_TO_EMPTY_CNT_SIZE                                                                3		
	#define ATC_ATC_INT_MASK_REG_ATC_TCPL_ERROR                                                                            (0x1<<4)
	#define ATC_ATC_INT_MASK_REG_ATC_TCPL_ERROR_SIZE                                                                       4		
	#define ATC_ATC_INT_MASK_REG_ATC_IREQ_LESS_THAN_STU                                                                    (0x1<<5)
	#define ATC_ATC_INT_MASK_REG_ATC_IREQ_LESS_THAN_STU_SIZE                                                               5
#define ATC_REG_ATC_PRTY_STS                                                                                               0x1101ccUL //ACCESS:R  DataWidth:0x5  Description: Parity register #0 read		
	#define ATC_ATC_PRTY_STS_REG_PARITY                                                                                    (0x1<<0)
	#define ATC_ATC_PRTY_STS_REG_PARITY_SIZE                                                                               0		
	#define ATC_ATC_PRTY_STS_REG_GPA_TABLE                                                                                 (0x1<<1)
	#define ATC_ATC_PRTY_STS_REG_GPA_TABLE_SIZE                                                                            1		
	#define ATC_ATC_PRTY_STS_REG_IREQ_FIFO                                                                                 (0x1<<2)
	#define ATC_ATC_PRTY_STS_REG_IREQ_FIFO_SIZE                                                                            2		
	#define ATC_ATC_PRTY_STS_REG_SPA_TABLE                                                                                 (0x1<<3)
	#define ATC_ATC_PRTY_STS_REG_SPA_TABLE_SIZE                                                                            3		
	#define ATC_ATC_PRTY_STS_REG_TCPL_FIFO                                                                                 (0x1<<4)
	#define ATC_ATC_PRTY_STS_REG_TCPL_FIFO_SIZE                                                                            4
#define ATC_REG_ATC_PRTY_STS_CLR                                                                                           0x1101d0UL //ACCESS:RC  DataWidth:0x5  Description: Parity register #0 read clear		
	#define ATC_ATC_PRTY_STS_CLR_REG_PARITY                                                                                (0x1<<0)
	#define ATC_ATC_PRTY_STS_CLR_REG_PARITY_SIZE                                                                           0		
	#define ATC_ATC_PRTY_STS_CLR_REG_GPA_TABLE                                                                             (0x1<<1)
	#define ATC_ATC_PRTY_STS_CLR_REG_GPA_TABLE_SIZE                                                                        1		
	#define ATC_ATC_PRTY_STS_CLR_REG_IREQ_FIFO                                                                             (0x1<<2)
	#define ATC_ATC_PRTY_STS_CLR_REG_IREQ_FIFO_SIZE                                                                        2		
	#define ATC_ATC_PRTY_STS_CLR_REG_SPA_TABLE                                                                             (0x1<<3)
	#define ATC_ATC_PRTY_STS_CLR_REG_SPA_TABLE_SIZE                                                                        3		
	#define ATC_ATC_PRTY_STS_CLR_REG_TCPL_FIFO                                                                             (0x1<<4)
	#define ATC_ATC_PRTY_STS_CLR_REG_TCPL_FIFO_SIZE                                                                        4
#define ATC_REG_ATC_PRTY_STS_WR                                                                                            0x1101d4UL //ACCESS:WR  DataWidth:0x5  Description: Parity register #0 bit set or clear		
	#define ATC_ATC_PRTY_STS_WR_REG_PARITY                                                                                 (0x1<<0)
	#define ATC_ATC_PRTY_STS_WR_REG_PARITY_SIZE                                                                            0		
	#define ATC_ATC_PRTY_STS_WR_REG_GPA_TABLE                                                                              (0x1<<1)
	#define ATC_ATC_PRTY_STS_WR_REG_GPA_TABLE_SIZE                                                                         1		
	#define ATC_ATC_PRTY_STS_WR_REG_IREQ_FIFO                                                                              (0x1<<2)
	#define ATC_ATC_PRTY_STS_WR_REG_IREQ_FIFO_SIZE                                                                         2		
	#define ATC_ATC_PRTY_STS_WR_REG_SPA_TABLE                                                                              (0x1<<3)
	#define ATC_ATC_PRTY_STS_WR_REG_SPA_TABLE_SIZE                                                                         3		
	#define ATC_ATC_PRTY_STS_WR_REG_TCPL_FIFO                                                                              (0x1<<4)
	#define ATC_ATC_PRTY_STS_WR_REG_TCPL_FIFO_SIZE                                                                         4
#define ATC_REG_ATC_PRTY_MASK                                                                                              0x1101d8UL //ACCESS:RW  DataWidth:0x5  Description: Parity mask register #0 read/write		
	#define ATC_ATC_PRTY_MASK_REG_PARITY                                                                                   (0x1<<0)
	#define ATC_ATC_PRTY_MASK_REG_PARITY_SIZE                                                                              0		
	#define ATC_ATC_PRTY_MASK_REG_GPA_TABLE                                                                                (0x1<<1)
	#define ATC_ATC_PRTY_MASK_REG_GPA_TABLE_SIZE                                                                           1		
	#define ATC_ATC_PRTY_MASK_REG_IREQ_FIFO                                                                                (0x1<<2)
	#define ATC_ATC_PRTY_MASK_REG_IREQ_FIFO_SIZE                                                                           2		
	#define ATC_ATC_PRTY_MASK_REG_SPA_TABLE                                                                                (0x1<<3)
	#define ATC_ATC_PRTY_MASK_REG_SPA_TABLE_SIZE                                                                           3		
	#define ATC_ATC_PRTY_MASK_REG_TCPL_FIFO                                                                                (0x1<<4)
	#define ATC_ATC_PRTY_MASK_REG_TCPL_FIFO_SIZE                                                                           4
#define ATC_REG_ATC_IREQ_FIFO_TM                                                                                           0x1101dcUL //ACCESS:RW  DataWidth:0x8  Description: TM bits of GPA state array
#define ATC_REG_DBG_OUT_DATA_LSB                                                                                           0x110200UL //ACCESS:R  DataWidth:0x20  Description: Debug only: For dbgmux usage (debug data that goes from QM to the DBG block) - The 32 lsb data that goes to the DBG block.
#define ATC_REG_DBG_OUT_DATA_LSB_SIZE                                                                                      1
#define ATC_REG_DBG_OUT_DATA_MSB                                                                                           0x110204UL //ACCESS:R  DataWidth:0x20  Description: Debug only: For dbgmux usage (debug data that goes from QM to the DBG block) - The 32 msb data that goes to the DBG block.
#define ATC_REG_DBG_OUT_DATA_MSB_SIZE                                                                                      1
#define ATC_REG_DBG_OUT_FRAME                                                                                              0x110208UL //ACCESS:R  DataWidth:0x4  Description: Debug only: For dbgmux usage (debug data that goes from QM to the DBG block) - The 4 frame bits that goes to the DBG block. Bit0 is the frame of data byte0; Bit1 is the frame of data byte1; Bit2 is the frame of data byte2; Bit3 is the frame of data byte4
#define ATC_REG_DBG_OUT_FRAME_SIZE                                                                                         1
#define ATC_REG_DBG_OUT_VALID                                                                                              0x11020cUL //ACCESS:R  DataWidth:0x4  Description: Debug only: For dbgmux usage (debug data that goes from QM to the DBG block) - The 4 valid bits that goes to the DBG block. Bit0 validtes data byte0; Bit1 validates data byte1; Bit2 validates data byte2; Bit3 validates data byte4
#define ATC_REG_DBG_OUT_VALID_SIZE                                                                                         1
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_STATE                                                                                 0x110800UL //ACCESS:WB  DataWidth:0x34  Description: Access the state fields of the GPA table; format is: W3 - {par - [51]; NS bit - [50]; W bit - [49]; R bit - [48]; U bit - [47]; Priority bit - [46]; PLRU - [45];  R-counter - [44:42]; transpend bit - [41]; invpend bit [40]; valid bit[39]}; W2 - {par - [38]; NS bit - [37]; W bit - [36]; R bit - [35]; U bit - [34]; Priority bit - [33]; PLRU - [32];  R-counter - [31:29]; transpend bit - [28]; invpend bit [27]; valid bit[26]}; W1 -  {par - [25]; NS bit - [24]; W bit - [23]; R bit - [22]; U bit - [21]; Priority bit - [20]; PLRU - [19];  R-counter - [18:16]; transpend bit - [15]; invpend bit [14]; valid bit[13]}; W0 -  {par - [12]; NS bit - [11]; W bit - [10]; R bit - [9]; U bit - [8]; Priority bit - [7]; PLRU - [6];  R-counter - [5:3]; transpend bit - [2]; invpend bit [1]; valid bit[0]}
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_STATE_SIZE                                                                            512
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_W0                                                                                    0x111000UL //ACCESS:WB  DataWidth:0x3e  Description: Access the GPA table way 0; format is: GPA - [51:0]; VF_Valid-[52]; VFID-[58:53]; PFID-[61:59];Parity[62]
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_W0_SIZE                                                                               512
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_W1                                                                                    0x111800UL //ACCESS:WB  DataWidth:0x3e  Description: Access the GPA table way 1; format is: GPA - [51:0]; VF_Valid-[52]; VFID-[58:53]; PFID-[61:59];Parity[62]
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_W1_SIZE                                                                               512
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_W2                                                                                    0x112000UL //ACCESS:WB  DataWidth:0x3e  Description: Access the GPA table way 2; format is: GPA - [51:0]; VF_Valid-[52]; VFID-[58:53]; PFID-[61:59];Parity[62]
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_W2_SIZE                                                                               512
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_W3                                                                                    0x112800UL //ACCESS:WB  DataWidth:0x3e  Description: Access the GPA table way 3; format is: GPA - [51:0]; VF_Valid-[52]; VFID-[58:53]; PFID-[61:59];Parity[62]
#define ATC_REG_ATC_GPA_ARRAY_ACCESS_W3_SIZE                                                                               512
#define ATC_REG_ATC_SPA_ARRAY_ACCESS                                                                                       0x114000UL //ACCESS:WB  DataWidth:0x34  Description: Debug access to the SPA array
#define ATC_REG_ATC_SPA_ARRAY_ACCESS_SIZE                                                                                  2048
#define ATC_REG_ATC_UNUSED_EMPTY_0                                                                                         0x1101e0UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define ATC_REG_ATC_UNUSED_EMPTY_0_SIZE                                                                                    8
#define ATC_REG_ATC_UNUSED_EMPTY_1                                                                                         0x110210UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define ATC_REG_ATC_UNUSED_EMPTY_1_SIZE                                                                                    380
#define ATC_REG_ATC_UNUSED_EMPTY_2                                                                                         0x113000UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define ATC_REG_ATC_UNUSED_EMPTY_2_SIZE                                                                                    1024
#define ATC_REG_ATC_UNUSED_EMPTY_3                                                                                         0x116000UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define ATC_REG_ATC_UNUSED_EMPTY_3_SIZE                                                                                    2048
#define BRB1_REG_HEADER_SIZE                                                                                               0x60000UL //ACCESS:RW  DataWidth:0x8  Description: Number of bytes after which new packet message is sent.
#define BRB1_REG_READ_FREE_BLOCK_ERROR_0                                                                                   0x60004UL //ACCESS:RC  DataWidth:0x1  Description: Read client 0: attempt to read from free block.
#define BRB1_REG_READ_FREE_BLOCK_ERROR_10                                                                                  0x60008UL //ACCESS:RC  DataWidth:0x1  Description: Read client 10: attempt to read from free block.
#define BRB1_REG_READ_FREE_BLOCK_ERROR_11                                                                                  0x6000cUL //ACCESS:RC  DataWidth:0x1  Description: Read client 11: attempt to read from free block.
#define BRB1_REG_READ_FREE_BLOCK_ERROR_12                                                                                  0x60010UL //ACCESS:RC  DataWidth:0x1  Description: Read client 12: attempt to read from free block.
#define BRB1_REG_READ_FREE_BLOCK_ERROR_13                                                                                  0x60014UL //ACCESS:RC  DataWidth:0x1  Description: Read client 13: attempt to read from free block.
#define BRB1_REG_READ_FREE_BLOCK_ERROR_14                                                                                  0x60018UL //ACCESS:RC  DataWidth:0x1  Description: Read client 14: attempt to read from free block.
#define BRB1_REG_READ_FREE_BLOCK_ERROR_2                                                                                   0x6001cUL //ACCESS:RC  DataWidth:0x1  Description: Read client 2: attempt to read from free block.
#define BRB1_REG_READ_FREE_BLOCK_ERROR_3                                                                                   0x60020UL //ACCESS:RC  DataWidth:0x1  Description: Read client 3: attempt to read from free block.
#define BRB1_REG_READ_FREE_BLOCK_ERROR_4                                                                                   0x60024UL //ACCESS:RC  DataWidth:0x1  Description: Read client 4: attempt to read from free block.
#define BRB1_REG_READ_LENGTH_ERROR_0                                                                                       0x60028UL //ACCESS:RC  DataWidth:0x1  Description: Read client 0: attempt to read more data than in packet.
#define BRB1_REG_READ_LENGTH_ERROR_10                                                                                      0x6002cUL //ACCESS:RC  DataWidth:0x1  Description: Read client 10: attempt to read more data than in packet.
#define BRB1_REG_READ_LENGTH_ERROR_11                                                                                      0x60030UL //ACCESS:RC  DataWidth:0x1  Description: Read client 11: attempt to read more data than in packet.
#define BRB1_REG_READ_LENGTH_ERROR_12                                                                                      0x60034UL //ACCESS:RC  DataWidth:0x1  Description: Read client 12: attempt to read more data than in packet.
#define BRB1_REG_READ_LENGTH_ERROR_13                                                                                      0x60038UL //ACCESS:RC  DataWidth:0x1  Description: Read client 13: attempt to read more data than in packet.
#define BRB1_REG_READ_LENGTH_ERROR_14                                                                                      0x6003cUL //ACCESS:RC  DataWidth:0x1  Description: Read client 14: attempt to read more data than in packet.
#define BRB1_REG_READ_LENGTH_ERROR_2                                                                                       0x60040UL //ACCESS:RC  DataWidth:0x1  Description: Read client 2: attempt to read more data than in packet.
#define BRB1_REG_READ_LENGTH_ERROR_3                                                                                       0x60044UL //ACCESS:RC  DataWidth:0x1  Description: Read client 3: attempt to read more data than in packet.
#define BRB1_REG_READ_LENGTH_ERROR_4                                                                                       0x60048UL //ACCESS:RC  DataWidth:0x1  Description: Read client 4: attempt to read more data than in packet.
#define BRB1_REG_STOP_INTERFACE_ON_READ_FREE_BLOCK_ERROR                                                                   0x6004cUL //ACCESS:RW  DataWidth:0x9  Description: stop interface on read from free block. Bit 0 (LSB) for client 0. Bit 1 for client 1 logical 0. Bit 2 for client 1 logical 1. Bit 3 for client 1 logical 2. Bit 4 for client 1 logical 3. Bit 5 for client 1 logical 4. Bit 6 for client 2. Bit 7 for client 3. Bit 8 for client 4.
#define BRB1_REG_STOP_INTERFACE_ON_READ_LENGTH_ERROR                                                                       0x60050UL //ACCESS:RW  DataWidth:0x9  Description: stop interface on read more data than in packet. Bit 0 (LSB) for client 0. Bit 1 for client 1 logical 0. Bit 2 for client 1 logical 1. Bit 3 for client 1 logical 2. Bit 4 for client 1 logical 3. Bit 5 for client 1 logical 4. Bit 6 for client 2. Bit 7 for client 3. Bit 8 for client 4.
#define BRB1_REG_READ_PRIORITY_0                                                                                           0x60054UL //ACCESS:RW  DataWidth:0x3  Description: Read client 0: Read priority 
#define BRB1_REG_READ_PRIORITY_1                                                                                           0x60058UL //ACCESS:RW  DataWidth:0x3  Description: Read client 1: Read priority 
#define BRB1_REG_READ_PRIORITY_2                                                                                           0x6005cUL //ACCESS:RW  DataWidth:0x3  Description: Read client 2: Read priority 
#define BRB1_REG_READ_PRIORITY_3                                                                                           0x60060UL //ACCESS:RW  DataWidth:0x3  Description: Read client 3: Read priority 
#define BRB1_REG_READ_PRIORITY_4                                                                                           0x60064UL //ACCESS:RW  DataWidth:0x3  Description: Read client 4: Read priority
#define BRB1_REG_PAUSE_LOW_THRESHOLD_0                                                                                     0x60068UL //ACCESS:RW  DataWidth:0xa  Description: Write client 0: Assert pause threshold. Not Functional
#define BRB1_REG_PAUSE_LOW_THRESHOLD_1                                                                                     0x6006cUL //ACCESS:RW  DataWidth:0xa  Description: Write client 0: Assert pause threshold. Not Functional
#define BRB1_REG_PAUSE_LOW_THRESHOLD_2                                                                                     0x60070UL //ACCESS:RW  DataWidth:0xa  Description: Write client 0: Assert pause threshold. Not Functional
#define BRB1_REG_PAUSE_LOW_THRESHOLD_3                                                                                     0x60074UL //ACCESS:RW  DataWidth:0xa  Description: Write client 0: Assert pause threshold. Not Functional
#define BRB1_REG_PAUSE_HIGH_THRESHOLD_0                                                                                    0x60078UL //ACCESS:RW  DataWidth:0xa  Description: Write client 0: De-assert pause threshold. Not Functional
#define BRB1_REG_PAUSE_HIGH_THRESHOLD_1                                                                                    0x6007cUL //ACCESS:RW  DataWidth:0xa  Description: Write client 0: De-assert pause threshold. Not Functional
#define BRB1_REG_PAUSE_HIGH_THRESHOLD_2                                                                                    0x60080UL //ACCESS:RW  DataWidth:0xa  Description: Write client 0: De-assert pause threshold. Not Functional
#define BRB1_REG_PAUSE_HIGH_THRESHOLD_3                                                                                    0x60084UL //ACCESS:RW  DataWidth:0xa  Description: Write client 0: De-assert pause threshold. Not Functional
#define BRB1_REG_BIG_RAM_INDIRECT                                                                                          0x60088UL //ACCESS:RW  DataWidth:0x2  Description: Indirect memory address
#define BRB1_REG_NUM_OF_FREE_BLOCKS                                                                                        0x6008cUL //ACCESS:R  DataWidth:0x18  Description: The number of free 256-byte blocks.
#define BRB1_REG_NUM_OF_FULL_BLOCKS                                                                                        0x60090UL //ACCESS:R  DataWidth:0x18  Description: The number of full blocks.
#define BRB1_REG_PORT_NUM_OCC_BLOCKS_0                                                                                     0x60094UL //ACCESS:R  DataWidth:0x18  Description: The number of full blocks occpied by port.
#define BRB1_REG_PORT_NUM_OCC_BLOCKS_1                                                                                     0x60098UL //ACCESS:R  DataWidth:0x18  Description: The number of full blocks occpied by port.
#define BRB1_REG_PORT_NUM_OCC_BLOCKS_2                                                                                     0x6009cUL //ACCESS:R  DataWidth:0x18  Description: The number of full blocks occpied by port.
#define BRB1_REG_PORT_NUM_OCC_BLOCKS_3                                                                                     0x600a0UL //ACCESS:R  DataWidth:0x18  Description: The number of full blocks occpied by port.
#define BRB1_REG_PORT_NUM_OCC_BLOCKS_4                                                                                     0x600a4UL //ACCESS:R  DataWidth:0x18  Description: The number of full blocks occpied by port.
#define BRB1_REG_FULL_WRC_RC                                                                                               0x600a8UL //ACCESS:R  DataWidth:0xf  Description: Full on read clients USDM_DP USDM_CTRL TSDM WRC4 WRC1 WRC0. See remark 5.
#define BRB1_REG_PRS_CRDT                                                                                                  0x600acUL //ACCESS:R  DataWidth:0xb  Description: Parser credit
#define BRB1_REG_PEND_REQ                                                                                                  0x600b0UL //ACCESS:R  DataWidth:0x12  Description: Pending requests. 2 bits per each client. Order is from msb to lsb USDM_DP; USDM_CTRL; TSDM_CTRL; CAC; PRS.
#define BRB1_REG_MAXIMUM_NUMBER_OF_FULL_BLOCKS                                                                             0x600b4UL //ACCESS:RC  DataWidth:0xb  Description: The maximum number of occupied block in the time interval between two RBC reads. This field is cleared-on-read.
#define BRB1_REG_NUM_OF_PAUSE_CYCLES_0                                                                                     0x600b8UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the pause signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_PAUSE_CYCLES_1                                                                                     0x600bcUL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the pause signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_PAUSE_CYCLES_2                                                                                     0x600c0UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the pause signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_PAUSE_CYCLES_3                                                                                     0x600c4UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the pause signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_FULL_CYCLES_0                                                                                      0x600c8UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the write_full signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_FULL_CYCLES_1                                                                                      0x600ccUL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the write_full signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_FULL_CYCLES_2                                                                                      0x600d0UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the write_full signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_FULL_CYCLES_3                                                                                      0x600d4UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the write_full signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_FULL_CYCLES_4                                                                                      0x600d8UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the write_full signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_SOFT_RESET                                                                                                0x600dcUL //ACCESS:RW  DataWidth:0x1  Description: Reset the design by software.
#define BRB1_REG_PORT_0_GUARANTIED                                                                                         0x600e0UL //ACCESS:RW  DataWidth:0xa  Description: The number of blocks guarantied for port 0. Not Functional
#define BRB1_REG_PORT_1_GUARANTIED                                                                                         0x600e4UL //ACCESS:RW  DataWidth:0xa  Description: The number of blocks guarantied for port 1. Not Functional
#define BRB1_REG_PORT_2_GUARANTIED                                                                                         0x600e8UL //ACCESS:RW  DataWidth:0xa  Description: The number of blocks guarantied for port 2. Not Functional
#define BRB1_REG_PORT_3_GUARANTIED                                                                                         0x600ecUL //ACCESS:RW  DataWidth:0xa  Description: The number of blocks guarantied for port 3. Not Functional
#define BRB1_REG_PORT_4_GUARANTIED                                                                                         0x600f0UL //ACCESS:RW  DataWidth:0xa  Description: The number of blocks guarantied for port 4. Not Functional
#define BRB1_REG_BRB_SIZE                                                                                                  0x600f4UL //ACCESS:RW  DataWidth:0xb  Description: The number of blocks in the BRB. Not Functional
#define BRB1_REG_DELTA                                                                                                     0x600f8UL //ACCESS:RW  DataWidth:0xa  Description: The histeresis value. Not Functional
#define BRB1_REG_INPUT_BUFFER_ALMOST_FULL                                                                                  0x600fcUL //ACCESS:RW  DataWidth:0x4  Description: Number of free entries in the buffer of each write port.
#define BRB1_REG_M_SP_RAM_BL_TM                                                                                            0x60100UL //ACCESS:RW  DataWidth:0x5  Description: TM bits of BL RAM memory
#define BRB1_REG_M_SP_RAM_BR_TM                                                                                            0x60104UL //ACCESS:RW  DataWidth:0x5  Description: TM bits of BR RAM memory
#define BRB1_REG_LRAM_TMA                                                                                                  0x60108UL //ACCESS:RW  DataWidth:0x5  Description: TMA port register
#define BRB1_REG_LRAM_TMB                                                                                                  0x6010cUL //ACCESS:RW  DataWidth:0x5  Description: TMB port register
#define BRB1_REG_DBG_SELECT                                                                                                0x60110UL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from BRB1 to the DBG block) - for selecting a line to output to the DBG block
#define BRB1_REG_DBG_BYTE_ENABLE                                                                                           0x60114UL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from BRB1 to the DBG block) - for enabling bytes in the selected line (after the select before the shift).
#define BRB1_REG_DBG_SHIFT                                                                                                 0x60118UL //ACCESS:RW  DataWidth:0x3  Description: Debug only. For dbgmux usage (debug data that goes from BRB1 to the DBG block) - for circular right shifting of the selected line (after the enabling).
#define BRB1_REG_BRB1_INT_STS                                                                                              0x6011cUL //ACCESS:R  DataWidth:0x13  Description: Interrupt register #0 read		
	#define BRB1_BRB1_INT_STS_REG_ADDRESS_ERROR                                                                            (0x1<<0)
	#define BRB1_BRB1_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                       0		
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_0                                                                        (0x1<<1)
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_0_SIZE                                                                   1		
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_10                                                                       (0x1<<2)
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_10_SIZE                                                                  2		
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_11                                                                       (0x1<<3)
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_11_SIZE                                                                  3		
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_12                                                                       (0x1<<4)
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_12_SIZE                                                                  4		
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_13                                                                       (0x1<<5)
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_13_SIZE                                                                  5		
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_14                                                                       (0x1<<6)
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_14_SIZE                                                                  6		
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_2                                                                        (0x1<<7)
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_2_SIZE                                                                   7		
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_3                                                                        (0x1<<8)
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_3_SIZE                                                                   8		
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_4                                                                        (0x1<<9)
	#define BRB1_BRB1_INT_STS_REG_RD_FREE_BLK_ERR_4_SIZE                                                                   9		
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_0                                                                             (0x1<<10)
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_0_SIZE                                                                        10		
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_10                                                                            (0x1<<11)
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_10_SIZE                                                                       11		
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_11                                                                            (0x1<<12)
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_11_SIZE                                                                       12		
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_12                                                                            (0x1<<13)
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_12_SIZE                                                                       13		
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_13                                                                            (0x1<<14)
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_13_SIZE                                                                       14		
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_14                                                                            (0x1<<15)
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_14_SIZE                                                                       15		
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_2                                                                             (0x1<<16)
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_2_SIZE                                                                        16		
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_3                                                                             (0x1<<17)
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_3_SIZE                                                                        17		
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_4                                                                             (0x1<<18)
	#define BRB1_BRB1_INT_STS_REG_RD_LEN_ERR_4_SIZE                                                                        18
#define BRB1_REG_BRB1_INT_STS_CLR                                                                                          0x60120UL //ACCESS:RC  DataWidth:0x13  Description: Interrupt register #0 read clear		
	#define BRB1_BRB1_INT_STS_CLR_REG_ADDRESS_ERROR                                                                        (0x1<<0)
	#define BRB1_BRB1_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                   0		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_0                                                                    (0x1<<1)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_0_SIZE                                                               1		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_10                                                                   (0x1<<2)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_10_SIZE                                                              2		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_11                                                                   (0x1<<3)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_11_SIZE                                                              3		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_12                                                                   (0x1<<4)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_12_SIZE                                                              4		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_13                                                                   (0x1<<5)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_13_SIZE                                                              5		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_14                                                                   (0x1<<6)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_14_SIZE                                                              6		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_2                                                                    (0x1<<7)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_2_SIZE                                                               7		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_3                                                                    (0x1<<8)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_3_SIZE                                                               8		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_4                                                                    (0x1<<9)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_FREE_BLK_ERR_4_SIZE                                                               9		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_0                                                                         (0x1<<10)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_0_SIZE                                                                    10		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_10                                                                        (0x1<<11)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_10_SIZE                                                                   11		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_11                                                                        (0x1<<12)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_11_SIZE                                                                   12		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_12                                                                        (0x1<<13)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_12_SIZE                                                                   13		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_13                                                                        (0x1<<14)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_13_SIZE                                                                   14		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_14                                                                        (0x1<<15)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_14_SIZE                                                                   15		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_2                                                                         (0x1<<16)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_2_SIZE                                                                    16		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_3                                                                         (0x1<<17)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_3_SIZE                                                                    17		
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_4                                                                         (0x1<<18)
	#define BRB1_BRB1_INT_STS_CLR_REG_RD_LEN_ERR_4_SIZE                                                                    18
#define BRB1_REG_BRB1_INT_STS_WR                                                                                           0x60124UL //ACCESS:WR  DataWidth:0x13  Description: Interrupt register #0 bit set or clear		
	#define BRB1_BRB1_INT_STS_WR_REG_ADDRESS_ERROR                                                                         (0x1<<0)
	#define BRB1_BRB1_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                    0		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_0                                                                     (0x1<<1)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_0_SIZE                                                                1		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_10                                                                    (0x1<<2)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_10_SIZE                                                               2		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_11                                                                    (0x1<<3)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_11_SIZE                                                               3		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_12                                                                    (0x1<<4)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_12_SIZE                                                               4		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_13                                                                    (0x1<<5)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_13_SIZE                                                               5		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_14                                                                    (0x1<<6)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_14_SIZE                                                               6		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_2                                                                     (0x1<<7)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_2_SIZE                                                                7		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_3                                                                     (0x1<<8)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_3_SIZE                                                                8		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_4                                                                     (0x1<<9)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_FREE_BLK_ERR_4_SIZE                                                                9		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_0                                                                          (0x1<<10)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_0_SIZE                                                                     10		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_10                                                                         (0x1<<11)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_10_SIZE                                                                    11		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_11                                                                         (0x1<<12)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_11_SIZE                                                                    12		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_12                                                                         (0x1<<13)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_12_SIZE                                                                    13		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_13                                                                         (0x1<<14)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_13_SIZE                                                                    14		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_14                                                                         (0x1<<15)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_14_SIZE                                                                    15		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_2                                                                          (0x1<<16)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_2_SIZE                                                                     16		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_3                                                                          (0x1<<17)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_3_SIZE                                                                     17		
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_4                                                                          (0x1<<18)
	#define BRB1_BRB1_INT_STS_WR_REG_RD_LEN_ERR_4_SIZE                                                                     18
#define BRB1_REG_BRB1_INT_MASK                                                                                             0x60128UL //ACCESS:RW  DataWidth:0x13  Description: Interrupt mask register #0 read/write		
	#define BRB1_BRB1_INT_MASK_REG_ADDRESS_ERROR                                                                           (0x1<<0)
	#define BRB1_BRB1_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                      0		
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_0                                                                       (0x1<<1)
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_0_SIZE                                                                  1		
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_10                                                                      (0x1<<2)
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_10_SIZE                                                                 2		
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_11                                                                      (0x1<<3)
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_11_SIZE                                                                 3		
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_12                                                                      (0x1<<4)
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_12_SIZE                                                                 4		
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_13                                                                      (0x1<<5)
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_13_SIZE                                                                 5		
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_14                                                                      (0x1<<6)
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_14_SIZE                                                                 6		
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_2                                                                       (0x1<<7)
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_2_SIZE                                                                  7		
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_3                                                                       (0x1<<8)
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_3_SIZE                                                                  8		
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_4                                                                       (0x1<<9)
	#define BRB1_BRB1_INT_MASK_REG_RD_FREE_BLK_ERR_4_SIZE                                                                  9		
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_0                                                                            (0x1<<10)
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_0_SIZE                                                                       10		
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_10                                                                           (0x1<<11)
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_10_SIZE                                                                      11		
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_11                                                                           (0x1<<12)
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_11_SIZE                                                                      12		
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_12                                                                           (0x1<<13)
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_12_SIZE                                                                      13		
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_13                                                                           (0x1<<14)
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_13_SIZE                                                                      14		
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_14                                                                           (0x1<<15)
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_14_SIZE                                                                      15		
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_2                                                                            (0x1<<16)
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_2_SIZE                                                                       16		
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_3                                                                            (0x1<<17)
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_3_SIZE                                                                       17		
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_4                                                                            (0x1<<18)
	#define BRB1_BRB1_INT_MASK_REG_RD_LEN_ERR_4_SIZE                                                                       18
#define BRB1_REG_BRB1_PRTY_STS                                                                                             0x6012cUL //ACCESS:R  DataWidth:0x4  Description: Parity register #0 read		
	#define BRB1_BRB1_PRTY_STS_REG_PARITY                                                                                  (0x1<<0)
	#define BRB1_BRB1_PRTY_STS_REG_PARITY_SIZE                                                                             0		
	#define BRB1_BRB1_PRTY_STS_REG_BRAM_BL                                                                                 (0x1<<1)
	#define BRB1_BRB1_PRTY_STS_REG_BRAM_BL_SIZE                                                                            1		
	#define BRB1_BRB1_PRTY_STS_REG_BRAM_BR                                                                                 (0x1<<2)
	#define BRB1_BRB1_PRTY_STS_REG_BRAM_BR_SIZE                                                                            2		
	#define BRB1_BRB1_PRTY_STS_REG_LRAM                                                                                    (0x1<<3)
	#define BRB1_BRB1_PRTY_STS_REG_LRAM_SIZE                                                                               3
#define BRB1_REG_BRB1_PRTY_STS_CLR                                                                                         0x60130UL //ACCESS:RC  DataWidth:0x4  Description: Parity register #0 read clear		
	#define BRB1_BRB1_PRTY_STS_CLR_REG_PARITY                                                                              (0x1<<0)
	#define BRB1_BRB1_PRTY_STS_CLR_REG_PARITY_SIZE                                                                         0		
	#define BRB1_BRB1_PRTY_STS_CLR_REG_BRAM_BL                                                                             (0x1<<1)
	#define BRB1_BRB1_PRTY_STS_CLR_REG_BRAM_BL_SIZE                                                                        1		
	#define BRB1_BRB1_PRTY_STS_CLR_REG_BRAM_BR                                                                             (0x1<<2)
	#define BRB1_BRB1_PRTY_STS_CLR_REG_BRAM_BR_SIZE                                                                        2		
	#define BRB1_BRB1_PRTY_STS_CLR_REG_LRAM                                                                                (0x1<<3)
	#define BRB1_BRB1_PRTY_STS_CLR_REG_LRAM_SIZE                                                                           3
#define BRB1_REG_BRB1_PRTY_STS_WR                                                                                          0x60134UL //ACCESS:WR  DataWidth:0x4  Description: Parity register #0 bit set or clear		
	#define BRB1_BRB1_PRTY_STS_WR_REG_PARITY                                                                               (0x1<<0)
	#define BRB1_BRB1_PRTY_STS_WR_REG_PARITY_SIZE                                                                          0		
	#define BRB1_BRB1_PRTY_STS_WR_REG_BRAM_BL                                                                              (0x1<<1)
	#define BRB1_BRB1_PRTY_STS_WR_REG_BRAM_BL_SIZE                                                                         1		
	#define BRB1_BRB1_PRTY_STS_WR_REG_BRAM_BR                                                                              (0x1<<2)
	#define BRB1_BRB1_PRTY_STS_WR_REG_BRAM_BR_SIZE                                                                         2		
	#define BRB1_BRB1_PRTY_STS_WR_REG_LRAM                                                                                 (0x1<<3)
	#define BRB1_BRB1_PRTY_STS_WR_REG_LRAM_SIZE                                                                            3
#define BRB1_REG_BRB1_PRTY_MASK                                                                                            0x60138UL //ACCESS:RW  DataWidth:0x4  Description: Parity mask register #0 read/write		
	#define BRB1_BRB1_PRTY_MASK_REG_PARITY                                                                                 (0x1<<0)
	#define BRB1_BRB1_PRTY_MASK_REG_PARITY_SIZE                                                                            0		
	#define BRB1_BRB1_PRTY_MASK_REG_BRAM_BL                                                                                (0x1<<1)
	#define BRB1_BRB1_PRTY_MASK_REG_BRAM_BL_SIZE                                                                           1		
	#define BRB1_BRB1_PRTY_MASK_REG_BRAM_BR                                                                                (0x1<<2)
	#define BRB1_BRB1_PRTY_MASK_REG_BRAM_BR_SIZE                                                                           2		
	#define BRB1_BRB1_PRTY_MASK_REG_LRAM                                                                                   (0x1<<3)
	#define BRB1_BRB1_PRTY_MASK_REG_LRAM_SIZE                                                                              3
#define BRB1_REG_HIGH_LLFC_LOW_THRESHOLD_0                                                                                 0x6013cUL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks below which the High_llfc signal to interface #n is asserted. Not Functional
#define BRB1_REG_HIGH_LLFC_LOW_THRESHOLD_1                                                                                 0x60140UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks below which the High_llfc signal to interface #n is asserted. Not Functional
#define BRB1_REG_HIGH_LLFC_LOW_THRESHOLD_2                                                                                 0x60144UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks below which the High_llfc signal to interface #n is asserted. Not Functional
#define BRB1_REG_HIGH_LLFC_LOW_THRESHOLD_3                                                                                 0x60148UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks below which the High_llfc signal to interface #n is asserted. Not Functional
#define BRB1_REG_HIGH_LLFC_HIGH_THRESHOLD_0                                                                                0x6014cUL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks above which the High_llfc signal to interface #n is de-asserted. Not Functional
#define BRB1_REG_HIGH_LLFC_HIGH_THRESHOLD_1                                                                                0x60150UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks above which the High_llfc signal to interface #n is de-asserted. Not Functional
#define BRB1_REG_HIGH_LLFC_HIGH_THRESHOLD_2                                                                                0x60154UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks above which the High_llfc signal to interface #n is de-asserted. Not Functional
#define BRB1_REG_HIGH_LLFC_HIGH_THRESHOLD_3                                                                                0x60158UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks above which the High_llfc signal to interface #n is de-asserted. Not Functional
#define BRB1_REG_LOW_LLFC_LOW_THRESHOLD_0                                                                                  0x6015cUL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks below which the Low_llfc signal to interface #n is asserted. Not Functional
#define BRB1_REG_LOW_LLFC_LOW_THRESHOLD_1                                                                                  0x60160UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks below which the Low_llfc signal to interface #n is asserted. Not Functional
#define BRB1_REG_LOW_LLFC_LOW_THRESHOLD_2                                                                                  0x60164UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks below which the Low_llfc signal to interface #n is asserted. Not Functional
#define BRB1_REG_LOW_LLFC_LOW_THRESHOLD_3                                                                                  0x60168UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks below which the Low_llfc signal to interface #n is asserted. Not Functional
#define BRB1_REG_LOW_LLFC_HIGH_THRESHOLD_0                                                                                 0x6016cUL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks above which the Low_llfc signal to interface #n is de-asserted. Not Functional
#define BRB1_REG_LOW_LLFC_HIGH_THRESHOLD_1                                                                                 0x60170UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks above which the Low_llfc signal to interface #n is de-asserted. Not Functional
#define BRB1_REG_LOW_LLFC_HIGH_THRESHOLD_2                                                                                 0x60174UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks above which the Low_llfc signal to interface #n is de-asserted. Not Functional
#define BRB1_REG_LOW_LLFC_HIGH_THRESHOLD_3                                                                                 0x60178UL //ACCESS:RW  DataWidth:0xa  Description: The number of free blocks above which the Low_llfc signal to interface #n is de-asserted. Not Functional
#define BRB1_REG_NUM_OF_LLFC_HIGH_CYCLES_0                                                                                 0x6017cUL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the llfc high signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_LLFC_HIGH_CYCLES_1                                                                                 0x60180UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the llfc high signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_LLFC_HIGH_CYCLES_2                                                                                 0x60184UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the llfc high signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_LLFC_HIGH_CYCLES_3                                                                                 0x60188UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the llfc high signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_LLFC_LOW_CYCLES_0                                                                                  0x6018cUL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the llfc low signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_LLFC_LOW_CYCLES_1                                                                                  0x60190UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the llfc low signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_LLFC_LOW_CYCLES_2                                                                                  0x60194UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the llfc low signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_NUM_OF_LLFC_LOW_CYCLES_3                                                                                  0x60198UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the llfc low signal towards MAC #0 was asserted. Not Functional
#define BRB1_REG_M_SP_RAM_BM_TM                                                                                            0x6019cUL //ACCESS:RW  DataWidth:0x5  Description: TM bits of BM RAM memory
#define BRB1_REG_ECO_RESERVED                                                                                              0x601a0UL //ACCESS:RW  DataWidth:0x8  Description: Reserved bits for ECO; when bit equal to 1: b0 -disable for parser IF bug 1 fix; b1- enable  for state machine bug 1 fix; b2- disable for  SDM Ifs bug1 fix; b3 - disable for bug2 fix
#define BRB1_REG_NUM_OF_PAUSE_0_CYCLES_0                                                                                   0x601acUL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the pause signal towards MAC port class 0 was asserted.
#define BRB1_REG_NUM_OF_PAUSE_1_CYCLES_0                                                                                   0x601b0UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the pause signal towards MAC port class 1 was asserted.
#define BRB1_REG_NUM_OF_FULL_0_CYCLES_0                                                                                    0x601b4UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the full signal towards MAC port class 0 was asserted.
#define BRB1_REG_NUM_OF_FULL_1_CYCLES_0                                                                                    0x601b8UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the full signal towards MAC port class 1 was asserted.
#define BRB1_REG_NUM_OF_FULL_LB_CYCLES                                                                                     0x601bcUL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the full signal towards LB port was asserted.
#define BRB1_REG_PAUSE_0_XOFF_THRESHOLD_0                                                                                  0x601c0UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks below which the pause signal to class 0 is asserted
#define BRB1_REG_PAUSE_0_XON_THRESHOLD_0                                                                                   0x601c4UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the pause signal to class 0 is de-asserted
#define BRB1_REG_PAUSE_1_XOFF_THRESHOLD_0                                                                                  0x601c8UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks below which the pause signal to class 1 is asserted
#define BRB1_REG_PAUSE_1_XON_THRESHOLD_0                                                                                   0x601ccUL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the pause signal to class 1 is de-asserted
#define BRB1_REG_FULL_0_XOFF_THRESHOLD_0                                                                                   0x601d0UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks below which the full signal to class 0 is asserted
#define BRB1_REG_FULL_0_XON_THRESHOLD_0                                                                                    0x601d4UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the full signal to class 0 is de-asserted
#define BRB1_REG_FULL_1_XOFF_THRESHOLD_0                                                                                   0x601d8UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks below which the full signal to class 1 is asserted
#define BRB1_REG_FULL_1_XON_THRESHOLD_0                                                                                    0x601dcUL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the full signal to class 1 is de-asserted
#define BRB1_REG_FULL_LB_XOFF_THRESHOLD                                                                                    0x601e0UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks below which the full signal to the LB port is asserted
#define BRB1_REG_FULL_LB_XON_THRESHOLD                                                                                     0x601e4UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the full signal to the LB port is de-asserted
#define BRB1_REG_MAC_GUARANTIED_0                                                                                          0x601e8UL //ACCESS:RW  DataWidth:0xb  Description: The number of blocks guarantied for the MAC port. The register is applicable only when per_class_guaranty_mode  is reset.
#define BRB1_REG_LB_GUARANTIED                                                                                             0x601ecUL //ACCESS:RW  DataWidth:0xb  Description: The number of blocks guarantied for the LB port
#define BRB1_REG_BRB_EMPTY_THRESHOLD                                                                                       0x601f0UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the brb_empty signal to TSEMI is asserted
#define BRB1_REG_NUM_OF_PAUSE_0_CYCLES_1                                                                                   0x60210UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the pause signal towards MAC port class 0 was asserted.
#define BRB1_REG_NUM_OF_PAUSE_1_CYCLES_1                                                                                   0x60214UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the pause signal towards MAC port class 1 was asserted.
#define BRB1_REG_NUM_OF_FULL_0_CYCLES_1                                                                                    0x60218UL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the full signal towards MAC port class 0 was asserted.
#define BRB1_REG_NUM_OF_FULL_1_CYCLES_1                                                                                    0x6021cUL //ACCESS:ST  DataWidth:0x20  Description: The number of cycles that the full signal towards MAC port class 1 was asserted.
#define BRB1_REG_PAUSE_0_XOFF_THRESHOLD_1                                                                                  0x60220UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks below which the pause signal to class 0 is asserted
#define BRB1_REG_PAUSE_0_XON_THRESHOLD_1                                                                                   0x60224UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the pause signal to class 0 is de-asserted
#define BRB1_REG_PAUSE_1_XOFF_THRESHOLD_1                                                                                  0x60228UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks below which the pause signal to class 1 is asserted
#define BRB1_REG_PAUSE_1_XON_THRESHOLD_1                                                                                   0x6022cUL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the pause signal to class 1 is de-asserted
#define BRB1_REG_FULL_0_XOFF_THRESHOLD_1                                                                                   0x60230UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks below which the full signal to class 0 is asserted
#define BRB1_REG_FULL_0_XON_THRESHOLD_1                                                                                    0x60234UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the full signal to class 0 is de-asserted
#define BRB1_REG_FULL_1_XOFF_THRESHOLD_1                                                                                   0x60238UL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks below which the full signal to class 1 is asserted
#define BRB1_REG_FULL_1_XON_THRESHOLD_1                                                                                    0x6023cUL //ACCESS:RW  DataWidth:0xb  Description: The number of free blocks above which the full signal to class 1 is de-asserted
#define BRB1_REG_MAC_GUARANTIED_1                                                                                          0x60240UL //ACCESS:RW  DataWidth:0xb  Description: The number of blocks guarantied for the MAC port. The register is applicable only when per_class_guaranty_mode  is reset.
#define BRB1_REG_MAC_0_CLASS_0_GUARANTIED                                                                                  0x60244UL //ACCESS:RW  DataWidth:0xb  Description: The number of blocks guarantied for class 0 in MAC 0. The register is applicable only when per_class_guaranty_mode is set. 
#define BRB1_REG_MAC_0_CLASS_1_GUARANTIED                                                                                  0x60248UL //ACCESS:RW  DataWidth:0xb  Description: The number of blocks guarantied for class 1 in MAC 0. The register is applicable only when per_class_guaranty_mode is set. 
#define BRB1_REG_MAC_1_CLASS_0_GUARANTIED                                                                                  0x6024cUL //ACCESS:RW  DataWidth:0xb  Description: The number of blocks guarantied for class 0in MAC1.The register is applicable only when per_class_guaranty_mode is set. 
#define BRB1_REG_MAC_1_CLASS_1_GUARANTIED                                                                                  0x60250UL //ACCESS:RW  DataWidth:0xb  Description: The number of blocks guarantied for class 1 in MAC 1. The register is applicable only when per_class_guaranty_mode is set. 
#define BRB1_REG_MAC_0_CLASS_0_GUARANTIED_HYST                                                                             0x60254UL //ACCESS:RW  DataWidth:0xb  Description: The hysteresis on the guarantied buffer space for class 0 in MAC 1 before signaling XON. The register is applicable only when per_class_guaranty_mode is set. 
#define BRB1_REG_MAC_0_CLASS_1_GUARANTIED_HYST                                                                             0x60258UL //ACCESS:RW  DataWidth:0xb  Description: The hysteresis on the guarantied buffer space for class 1in MAC 0 before signaling XON. The register is applicable only when per_class_guaranty_mode is set. 
#define BRB1_REG_MAC_1_CLASS_0_GUARANTIED_HYST                                                                             0x6025cUL //ACCESS:RW  DataWidth:0xb  Description: The hysteresis on the guarantied buffer space for class 0 in MAC 1 before signaling XON. The register is applicable only when per_class_guaranty_mode is set. 
#define BRB1_REG_MAC_1_CLASS_1_GUARANTIED_HYST                                                                             0x60260UL //ACCESS:RW  DataWidth:0xb  Description: The hysteresis on the guarantied buffer space for class 1 in MAC 1 before signaling XON. The register is applicable only when per_class_guaranty_mode is set. 
#define BRB1_REG_LB_GUARANTIED_HYST                                                                                        0x60264UL //ACCESS:RW  DataWidth:0xb  Description: The hysteresis on the guarantied buffer space for the Lb port before signaling XON. 
#define BRB1_REG_PER_CLASS_GUARANTY_MODE                                                                                   0x60268UL //ACCESS:RW  DataWidth:0x1  Description: Indicates if to use per-class guaranty mode (new mode) or per-MAC guaranty mode (backwards-compatible mode). 0=per-MAC guaranty mode (BC mode). 1=per-class guaranty mode (new mode).  
#define BRB1_REG_EMPTY_BACKWARD_MODE                                                                                       0x6027cUL //ACCESS:RW  DataWidth:0x1  Description: When reset then brb_empty signal will be set according to new E3_B0 formula. When set it will be used an old formula
#define BRB1_REG_SF_MODE_EN                                                                                                0x60280UL //ACCESS:RW  DataWidth:0x5  Description: Store and forward enable mode per port (b0 - mac port 0; b1 - mac port 1; b4 - LB port ). When it is set then NPM notification to parser will be transmitted after EOP inputs to BRB. When it is reset then it will be transmitted after header_size bytes or EOP inputs to BRTB.
#define BRB1_REG_FREE_LIST_PRS_CRDT                                                                                        0x60200UL //ACCESS:RW  DataWidth:0xb  Description: At address BRB1_IND_FREE_LIST_PRS_CRDT initialize free head. At address BRB1_IND_FREE_LIST_PRS_CRDT+1 initialize free tail. At address BRB1_IND_FREE_LIST_PRS_CRDT+2 initialize parser initial credit. Warning - following reset the first rbc access to this reg must be write; there can be no more rbc writes after the first one; there can be any number of rbc read following the first write; rbc access not following these rules will result in hang condition.
#define BRB1_REG_FREE_LIST_PRS_CRDT_SIZE                                                                                   3
#define BRB1_REG_PORT_0_CLASS_0_NUM_OCC_BLOCKS                                                                             0x6026cUL //ACCESS:R  DataWidth:0xb  Description: The number of full blocks occpied by port0 class0 .
#define BRB1_REG_PORT_0_CLASS_0_NUM_OCC_BLOCKS_SIZE                                                                        1
#define BRB1_REG_PORT_0_CLASS_1_NUM_OCC_BLOCKS                                                                             0x60270UL //ACCESS:R  DataWidth:0xb  Description: The number of full blocks occpied by port0 class0 .
#define BRB1_REG_PORT_0_CLASS_1_NUM_OCC_BLOCKS_SIZE                                                                        1
#define BRB1_REG_PORT_1_CLASS_0_NUM_OCC_BLOCKS                                                                             0x60274UL //ACCESS:R  DataWidth:0xb  Description: The number of full blocks occpied by port0 class0 .
#define BRB1_REG_PORT_1_CLASS_0_NUM_OCC_BLOCKS_SIZE                                                                        1
#define BRB1_REG_PORT_1_CLASS_1_NUM_OCC_BLOCKS                                                                             0x60278UL //ACCESS:R  DataWidth:0xb  Description: The number of full blocks occpied by port0 class0 .
#define BRB1_REG_PORT_1_CLASS_1_NUM_OCC_BLOCKS_SIZE                                                                        1
#define BRB1_REG_LL_RAM                                                                                                    0x61000UL //ACCESS:RW  DataWidth:0x18  Description: LL RAM data.
#define BRB1_REG_LL_RAM_SIZE                                                                                               1024
#define BRB1_REG_BIG_RAM                                                                                                   0x70000UL //ACCESS:WB  DataWidth:0x100  Description: Big RAM data; addressing uses 2 IND bits in item 33 as most significant bits.
#define BRB1_REG_BIG_RAM_SIZE                                                                                              16384
#define BRB1_REG_BRB1_UNUSED_EMPTY_0                                                                                       0x601a4UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define BRB1_REG_BRB1_UNUSED_EMPTY_0_SIZE                                                                                  2
#define BRB1_REG_BRB1_UNUSED_EMPTY_1                                                                                       0x601f4UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define BRB1_REG_BRB1_UNUSED_EMPTY_1_SIZE                                                                                  3
#define BRB1_REG_BRB1_UNUSED_EMPTY_2                                                                                       0x60284UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define BRB1_REG_BRB1_UNUSED_EMPTY_2_SIZE                                                                                  863
#define BRB1_REG_BRB1_UNUSED_EMPTY_3                                                                                       0x62000UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define BRB1_REG_BRB1_UNUSED_EMPTY_3_SIZE                                                                                  14336
#define CCM_REG_INIT                                                                                                       0xd0000UL //ACCESS:RW  DataWidth:0x1  Description: Debug only. Initialises specific states and statuses. To initialise the state - write 1 into register; to enable working after that - write 0. For debug purposes only.
#define CCM_REG_CCM_STORM0_IFEN                                                                                            0xd0004UL //ACCESS:RW  DataWidth:0x1  Description: CM - STORM 0 Interface enable. If 0 - the acknowledge input is disregarded; valid is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_CCM_STORM1_IFEN                                                                                            0xd0008UL //ACCESS:RW  DataWidth:0x1  Description: CM - STORM 1 Interface enable. If 0 - the acknowledge input is disregarded; valid is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_CCM_CQM_IFEN                                                                                               0xd000cUL //ACCESS:RW  DataWidth:0x1  Description: CM - QM Interface enable. If 0 - the acknowledge input is disregarded; valid is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_STORM_CCM_IFEN                                                                                             0xd0010UL //ACCESS:RW  DataWidth:0x1  Description: STORM - CM Interface enable. If 0 - the valid input is disregarded; acknowledge output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_CQM_CCM_IFEN                                                                                               0xd0014UL //ACCESS:RW  DataWidth:0x1  Description: QM - CM Interface enable. If 0 - the valid input is disregarded; acknowledge output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_CSDM_IFEN                                                                                                  0xd0018UL //ACCESS:RW  DataWidth:0x1  Description: Input SDM Interface enable. If 0 - the valid input is disregarded; acknowledge output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_TSEM_IFEN                                                                                                  0xd001cUL //ACCESS:RW  DataWidth:0x1  Description: Input tsem Interface enable. If 0 - the valid input is disregarded; acknowledge output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_XSEM_IFEN                                                                                                  0xd0020UL //ACCESS:RW  DataWidth:0x1  Description: Input xsem Interface enable. If 0 - the valid input is disregarded; acknowledge output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_USEM_IFEN                                                                                                  0xd0024UL //ACCESS:RW  DataWidth:0x1  Description: Input usem Interface enable. If 0 - the valid input is disregarded; acknowledge output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_PBF_IFEN                                                                                                   0xd0028UL //ACCESS:RW  DataWidth:0x1  Description: Input pbf Interface enable. If 0 - the valid input is disregarded; acknowledge output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_CDU_AG_WR_IFEN                                                                                             0xd002cUL //ACCESS:RW  DataWidth:0x1  Description: CDU AG write Interface enable. If 0 - the request and valid input are disregarded; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_CDU_AG_RD_IFEN                                                                                             0xd0030UL //ACCESS:RW  DataWidth:0x1  Description: CDU AG read Interface enable. If 0 - the request input is disregarded; valid output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_CDU_SM_WR_IFEN                                                                                             0xd0034UL //ACCESS:RW  DataWidth:0x1  Description: CDU STORM write Interface enable. If 0 - the request and valid input is disregarded; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_CDU_SM_RD_IFEN                                                                                             0xd0038UL //ACCESS:RW  DataWidth:0x1  Description: CDU STORM read Interface enable. If 0 - the request input is disregarded; valid output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_CCM_CFC_IFEN                                                                                               0xd003cUL //ACCESS:RW  DataWidth:0x1  Description: CM - CFC Interface enable. If 0 - the valid input is disregarded; acknowledge output is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define CCM_REG_XX_MAX_LL_SZ                                                                                               0xd0040UL //ACCESS:RW  DataWidth:0x6  Description: Maximum link list size per connection in the XX protection.
#define CCM_REG_XX_OVFL_EVNT_ID                                                                                            0xd0044UL //ACCESS:RW  DataWidth:0x8  Description: The Event ID; sent to the STORM in case of XX overflow.
#define CCM_REG_XX_MAX_NUM                                                                                                 0xd0048UL //ACCESS:RW  DataWidth:0x5  Description: The maximum number of connections in the XX protection.
#define CCM_REG_N_SM_CTX_LD_0                                                                                              0xd004cUL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_1                                                                                              0xd0050UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_2                                                                                              0xd0054UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_3                                                                                              0xd0058UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_4                                                                                              0xd005cUL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_5                                                                                              0xd0060UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_6                                                                                              0xd0064UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_7                                                                                              0xd0068UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_8                                                                                              0xd006cUL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_9                                                                                              0xd0070UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_10                                                                                             0xd0074UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_11                                                                                             0xd0078UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_12                                                                                             0xd007cUL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_13                                                                                             0xd0080UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_14                                                                                             0xd0084UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_N_SM_CTX_LD_15                                                                                             0xd0088UL //ACCESS:RW  DataWidth:0x4  Description: The number of double REG-pairs(128 bits); loaded from the STORM context and sent to STORM; for a specific connection type. The double REG-pairs are used in order to align to STORM context row size of 128 bits. The offset of these data in the STORM context is always 0. Index _(0..15) stands for the connection type (one of 16).
#define CCM_REG_CQM_CCM_HDR_P                                                                                              0xd008cUL //ACCESS:RW  DataWidth:0x1c  Description: The CM header value for QM request (primary).
#define CCM_REG_CQM_CCM_HDR_S                                                                                              0xd0090UL //ACCESS:RW  DataWidth:0x1c  Description: The CM header value for QM request (secondary).
#define CCM_REG_ERR_CCM_HDR                                                                                                0xd0094UL //ACCESS:RW  DataWidth:0x1c  Description: The CM header for QM formatting in case of an error in the QM inputs.
#define CCM_REG_ERR_EVNT_ID                                                                                                0xd0098UL //ACCESS:RW  DataWidth:0x8  Description: The Event ID in case the input message ErrorFlg is set.
#define CCM_REG_STORM_WEIGHT                                                                                               0xd009cUL //ACCESS:RW  DataWidth:0x3  Description: The weight of the STORM input in the WRR (Weighted Round robin) mechanism. 0 stands for weight 8 (the most prioritised); 1 stands for weight 1(least prioritised); 2 stands for weight 2 (more prioritised);etc.
#define CCM_REG_TSEM_WEIGHT                                                                                                0xd00a0UL //ACCESS:RW  DataWidth:0x3  Description: The weight of the input tsem in the WRR mechanism. 0 stands for weight 8 (the most prioritised); 1 stands for weight 1(least prioritised); 2 stands for weight 2;etc.
#define CCM_REG_XSEM_WEIGHT                                                                                                0xd00a4UL //ACCESS:RW  DataWidth:0x3  Description: The weight of the input xsem in the WRR mechanism. 0 stands for weight 8 (the most prioritised); 1 stands for weight 1(least prioritised); 2 stands for weight 2;etc.
#define CCM_REG_USEM_WEIGHT                                                                                                0xd00a8UL //ACCESS:RW  DataWidth:0x3  Description: The weight of the input usem in the WRR mechanism. 0 stands for weight 8 (the most prioritised); 1 stands for weight 1(least prioritised); 2 stands for weight 2;etc.
#define CCM_REG_PBF_WEIGHT                                                                                                 0xd00acUL //ACCESS:RW  DataWidth:0x3  Description: The weight of the input pbf in the WRR mechanism. 0 stands for weight 8 (the most prioritised); 1 stands for weight 1(least prioritised); 2 stands for weight 2;etc.
#define CCM_REG_CP_WEIGHT                                                                                                  0xd00b0UL //ACCESS:RW  DataWidth:0x3  Description: The weight of the CP input in the WRR mechanism. 0 stands for weight 8 (the most prioritised); 1 stands for weight 1(least prioritised); 2 stands for weight 2;etc.
#define CCM_REG_CSDM_WEIGHT                                                                                                0xd00b4UL //ACCESS:RW  DataWidth:0x3  Description: The weight of the SDM input in the WRR mechanism. 0 stands for weight 8 (the most prioritised); 1 stands for weight 1(least prioritised); 2 stands for weight 2;etc.
#define CCM_REG_CQM_P_WEIGHT                                                                                               0xd00b8UL //ACCESS:RW  DataWidth:0x3  Description: The weight of the QM (primary) input in the WRR mechanism. 0 stands for weight 8 (the most prioritised); 1 stands for weight 1(least prioritised); 2 stands for weight 2;etc.
#define CCM_REG_CQM_S_WEIGHT                                                                                               0xd00bcUL //ACCESS:RW  DataWidth:0x3  Description: The weight of the QM (secondary) input in the WRR mechanism. 0 stands for weight 8 (the most prioritised); 1 stands for weight 1(least prioritised); 2 stands for weight 2;etc.
#define CCM_REG_CCM_CQM_USE_Q                                                                                              0xd00c0UL //ACCESS:RW  DataWidth:0x1  Description: If set the Q index; received from the QM is inserted to event ID. Otherwise 0 is inserted.
#define CCM_REG_CCM_REG0_SZ                                                                                                0xd00c4UL //ACCESS:RW  DataWidth:0x3  Description: The size of AG context region 0 in REG-pairs. Designates the MS REG-pair number (e.g. if region 0 is 6 REG-pairs; the value should be 5). Is used to determine the number of the AG context REG-pairs written back; when the input message Reg1WbFlg isn't set.
#define CCM_REG_CNT_AUX1_Q                                                                                                 0xd00c8UL //ACCESS:RW  DataWidth:0x2  Description: Auxillary counter flag Q number 1.
#define CCM_REG_CNT_AUX2_Q                                                                                                 0xd00ccUL //ACCESS:RW  DataWidth:0x2  Description: Auxillary counter flag Q number 2.
#define CCM_REG_CNT_AUX3_Q                                                                                                 0xd00d0UL //ACCESS:RW  DataWidth:0x2  Description: Auxillary counter flag Q number 3.
#define CCM_REG_CNT_AUX4_Q                                                                                                 0xd00d4UL //ACCESS:RW  DataWidth:0x2  Description: Auxillary counter flag Q number 4.
#define CCM_REG_CNT_AUX5_Q                                                                                                 0xd00d8UL //ACCESS:RW  DataWidth:0x2  Description: Auxillary counter flag Q number 5.
#define CCM_REG_CNT_AUX6_Q                                                                                                 0xd00dcUL //ACCESS:RW  DataWidth:0x2  Description: Auxillary counter flag Q number 6.
#define CCM_REG_SLOW_PATH_INV_CNT_FLG_Q                                                                                    0xd00e0UL //ACCESS:RW  DataWidth:0x2  Description: Slow path invalid counter flag Q number.
#define CCM_REG_RST_RCVD_FLG_Q                                                                                             0xd00e4UL //ACCESS:RW  DataWidth:0x2  Description: RST received flag Q number.
#define CCM_REG_AUX1_FLG_Q                                                                                                 0xd00e8UL //ACCESS:RW  DataWidth:0x2  Description: Aux 1 flag Q number.
#define CCM_REG_AUX2_FLG_Q                                                                                                 0xd00ecUL //ACCESS:RW  DataWidth:0x2  Description: Aux 2 flag Q number.
#define CCM_REG_URSE_CNT_FLG_Q                                                                                             0xd00f0UL //ACCESS:RW  DataWidth:0x2  Description: ULP Rx SE counter flag.
#define CCM_REG_URINV_CNT_FLG_Q                                                                                            0xd00f4UL //ACCESS:RW  DataWidth:0x2  Description: ULP Rx Invalide counter flag.
#define CCM_REG_REL_SEQ_Q                                                                                                  0xd00f8UL //ACCESS:RW  DataWidth:0x2  Description: Release sequence decision Q index.
#define CCM_REG_HQ_PROD_Q                                                                                                  0xd00fcUL //ACCESS:RW  DataWidth:0x2  Description: HQ producer index.
#define CCM_REG_ORQ_UR_CONS_Q                                                                                              0xd0100UL //ACCESS:RW  DataWidth:0x2  Description: ORQ ULP Rx consumer index.
#define CCM_REG_RQ_UR_CONS_Q                                                                                               0xd0104UL //ACCESS:RW  DataWidth:0x2  Description: RQ consumer updated by ULP Rx index.
#define CCM_REG_INV_DONE_Q                                                                                                 0xd0108UL //ACCESS:RW  DataWidth:0x2  Description: General flags index.
#define CCM_REG_AUX1_Q                                                                                                     0xd010cUL //ACCESS:RW  DataWidth:0x2  Description: Auxillary flag Q number 1 index.
#define CCM_REG_AUX2_Q                                                                                                     0xd0110UL //ACCESS:RW  DataWidth:0x2  Description: Auxillary flag Q number 2 index.
#define CCM_REG_SM_CTX0_TM                                                                                                 0xd014cUL //ACCESS:RW  DataWidth:0x5  Description: Debug only. TM bits of STORM context.LSB.
#define CCM_REG_AG_CTX0_TM                                                                                                 0xd0150UL //ACCESS:RW  DataWidth:0x5  Description: Debug only. TM bits of AG context.
#define CCM_REG_AG_CTX1_TM                                                                                                 0xd0154UL //ACCESS:RW  DataWidth:0x5  Description: Debug only. TM bits of AG context.
#define CCM_REG_AG_CTX2_TM                                                                                                 0xd0158UL //ACCESS:RW  DataWidth:0x5  Description: Debug only. TM bits of AG context.
#define CCM_REG_GR_ARB_TYPE                                                                                                0xd015cUL //ACCESS:RW  DataWidth:0x1  Description: Arbitration between Input Arbiter groups: 0 - fair Round-Robin; 1 - strict priority defined by ~ccm_registers_gr_ag_pr.gr_ag_pr; ~ccm_registers_gr_ld0_pr.gr_ld0_pr and ~ccm_registers_gr_ld1_pr.gr_ld1_pr. Groups are according to channels and outputs to STORM: aggregation; load FIC0; load FIC1 and store.
#define CCM_REG_GR_AG_PR                                                                                                   0xd0160UL //ACCESS:RW  DataWidth:0x2  Description: Aggregation channel group priority. The lowest priority is 0; the highest priority is 3. It is supposed; that the Store channel priority is the compliment to 4 of the rest priorities - Aggregation channel; Load (FIC0) channel and Load (FIC1).
#define CCM_REG_GR_LD0_PR                                                                                                  0xd0164UL //ACCESS:RW  DataWidth:0x2  Description: Load (FIC0) channel group priority. The lowest priority is 0; the highest priority is 3. It is supposed; that the Store channel priority is the compliment to 4 of the rest priorities - Aggregation channel; Load (FIC0) channel and Load (FIC1).
#define CCM_REG_GR_LD1_PR                                                                                                  0xd0168UL //ACCESS:RW  DataWidth:0x2  Description: Load (FIC1) channel group priority. The lowest priority is 0; the highest priority is 3. It is supposed; that the Store channel priority is the compliment to 4 of the rest priorities - Aggregation channel; Load (FIC0) channel and Load (FIC1).
#define CCM_REG_STORM_LENGTH_MIS                                                                                           0xd016cUL //ACCESS:RC  DataWidth:0x1  Description: Set when the message length mismatch (relative to last indication) at the STORM interface is detected.
#define CCM_REG_CSDM_LENGTH_MIS                                                                                            0xd0170UL //ACCESS:RC  DataWidth:0x1  Description: Set when the message length mismatch (relative to last indication) at the SDM interface is detected.
#define CCM_REG_TSEM_LENGTH_MIS                                                                                            0xd0174UL //ACCESS:RC  DataWidth:0x1  Description: Set when the message length mismatch (relative to last indication) at the tsem interface is detected.
#define CCM_REG_XSEM_LENGTH_MIS                                                                                            0xd0178UL //ACCESS:RC  DataWidth:0x1  Description: Set when the message length mismatch (relative to last indication) at the xsem interface is detected.
#define CCM_REG_USEM_LENGTH_MIS                                                                                            0xd017cUL //ACCESS:RC  DataWidth:0x1  Description: Set when message length mismatch (relative to last indication) at the usem interface is detected.
#define CCM_REG_PBF_LENGTH_MIS                                                                                             0xd0180UL //ACCESS:RC  DataWidth:0x1  Description: Set when the message length mismatch (relative to last indication) at the pbf interface is detected.
#define CCM_REG_XX_FREE                                                                                                    0xd0184UL //ACCESS:R  DataWidth:0x7  Description: Used to read the value of XX protection Free counter.
#define CCM_REG_CAM_OCCUP                                                                                                  0xd0188UL //ACCESS:R  DataWidth:0x5  Description: Used to read the value of the XX protection CAM occupancy counter.
#define CCM_REG_UNLOCK_MISS                                                                                                0xd018cUL //ACCESS:RC  DataWidth:0x1  Description: Error; indicating the LCID to be unlocked from XX protection doesn't exist in LCID CAM.
#define CCM_REG_CQM_GLB_USE_CNTR                                                                                           0xd0190UL //ACCESS:R  DataWidth:0x1a  Description: Used to read the QM global usage counter - the counter of QM requests still pending in the QM.
#define CCM_REG_CP_BUF_EMPTY                                                                                               0xd0194UL //ACCESS:R  DataWidth:0x1  Description: Indication of CP buffer is empty.
#define CCM_REG_CP_BUF_STATUS                                                                                              0xd0198UL //ACCESS:R  DataWidth:0x5  Description: CP buffer status.
#define CCM_REG_XX_OVFL_CNTR                                                                                               0xd019cUL //ACCESS:ST  DataWidth:0x10  Description: Counter of XX 0verflow occurencies.
#define CCM_REG_STORM_MSG_CNTR                                                                                             0xd01a0UL //ACCESS:ST  DataWidth:0x18  Description: Counter of the input messages at the STORM input.
#define CCM_REG_CSDM_MSG_CNTR                                                                                              0xd01a4UL //ACCESS:ST  DataWidth:0x18  Description: Counter of the input messages at the input SDM.
#define CCM_REG_TSEM_MSG_CNTR                                                                                              0xd01a8UL //ACCESS:ST  DataWidth:0x18  Description: Counter of the input messages at the input tsem.
#define CCM_REG_XSEM_MSG_CNTR                                                                                              0xd01acUL //ACCESS:ST  DataWidth:0x18  Description: Counter of the input messages at the input xsem.
#define CCM_REG_USEM_MSG_CNTR                                                                                              0xd01b0UL //ACCESS:ST  DataWidth:0x18  Description: Counter of the input messages at the input usem.
#define CCM_REG_PBF_MSG_CNTR                                                                                               0xd01b4UL //ACCESS:ST  DataWidth:0x18  Description: Counter of the input messages at the input pbf.
#define CCM_REG_CP_MSG_CNTR                                                                                                0xd01b8UL //ACCESS:ST  DataWidth:0x18  Description: Counter of the input messages at the CP input.
#define CCM_REG_CQM_P_MSG_CNTR                                                                                             0xd01bcUL //ACCESS:ST  DataWidth:0x18  Description: Counter of the input messages at the QM input (primary).
#define CCM_REG_CQM_S_MSG_CNTR                                                                                             0xd01c0UL //ACCESS:ST  DataWidth:0x18  Description: Counter of the input messages at the QM input (secondary).
#define CCM_REG_STORM_OUT_CNTR                                                                                             0xd01c4UL //ACCESS:ST  DataWidth:0x18  Description: Counter of the output messages at FIC0 and FIC1 interfaces.
#define CCM_REG_CQM_OUT_CNTR                                                                                               0xd01c8UL //ACCESS:ST  DataWidth:0x18  Description: Counter of the output QM commands.
#define CCM_REG_DBG_SELECT                                                                                                 0xd01ccUL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from CCM to the DBG block) - for selecting a line to output to the DBG block.
#define CCM_REG_DBG_BYTE_ENABLE                                                                                            0xd01d0UL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from CCM to the DBG block) - for enabling bytes in the selected line (after the select; before the shift).
#define CCM_REG_DBG_SHIFT                                                                                                  0xd01d4UL //ACCESS:RW  DataWidth:0x3  Description: Debug only. For dbgmux usage (debug data that goes from CCM to the DBG block) - for circular right shifting of the selected line (after the enabling).
#define CCM_REG_CCM_INT_STS                                                                                                0xd01d8UL //ACCESS:R  DataWidth:0xb  Description: Interrupt register #0 read		
	#define CCM_CCM_INT_STS_REG_ADDRESS_ERROR                                                                              (0x1<<0)
	#define CCM_CCM_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                         0		
	#define CCM_CCM_INT_STS_REG_XX_UQ_ERR                                                                                  (0x1<<1)
	#define CCM_CCM_INT_STS_REG_XX_UQ_ERR_SIZE                                                                             1		
	#define CCM_CCM_INT_STS_REG_STORM_ERR                                                                                  (0x1<<2)
	#define CCM_CCM_INT_STS_REG_STORM_ERR_SIZE                                                                             2		
	#define CCM_CCM_INT_STS_REG_CSDM_ERR                                                                                   (0x1<<3)
	#define CCM_CCM_INT_STS_REG_CSDM_ERR_SIZE                                                                              3		
	#define CCM_CCM_INT_STS_REG_TSEM_ERR                                                                                   (0x1<<4)
	#define CCM_CCM_INT_STS_REG_TSEM_ERR_SIZE                                                                              4		
	#define CCM_CCM_INT_STS_REG_XSEM_ERR                                                                                   (0x1<<5)
	#define CCM_CCM_INT_STS_REG_XSEM_ERR_SIZE                                                                              5		
	#define CCM_CCM_INT_STS_REG_USEM_ERR                                                                                   (0x1<<6)
	#define CCM_CCM_INT_STS_REG_USEM_ERR_SIZE                                                                              6		
	#define CCM_CCM_INT_STS_REG_PBF_ERR                                                                                    (0x1<<7)
	#define CCM_CCM_INT_STS_REG_PBF_ERR_SIZE                                                                               7		
	#define CCM_CCM_INT_STS_REG_CP0_ERR                                                                                    (0x1<<8)
	#define CCM_CCM_INT_STS_REG_CP0_ERR_SIZE                                                                               8		
	#define CCM_CCM_INT_STS_REG_CP1_ERR                                                                                    (0x1<<9)
	#define CCM_CCM_INT_STS_REG_CP1_ERR_SIZE                                                                               9		
	#define CCM_CCM_INT_STS_REG_UM_ERR                                                                                     (0x1<<10)
	#define CCM_CCM_INT_STS_REG_UM_ERR_SIZE                                                                                10
#define CCM_REG_CCM_INT_STS_CLR                                                                                            0xd01dcUL //ACCESS:RC  DataWidth:0xb  Description: Interrupt register #0 read clear		
	#define CCM_CCM_INT_STS_CLR_REG_ADDRESS_ERROR                                                                          (0x1<<0)
	#define CCM_CCM_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                     0		
	#define CCM_CCM_INT_STS_CLR_REG_XX_UQ_ERR                                                                              (0x1<<1)
	#define CCM_CCM_INT_STS_CLR_REG_XX_UQ_ERR_SIZE                                                                         1		
	#define CCM_CCM_INT_STS_CLR_REG_STORM_ERR                                                                              (0x1<<2)
	#define CCM_CCM_INT_STS_CLR_REG_STORM_ERR_SIZE                                                                         2		
	#define CCM_CCM_INT_STS_CLR_REG_CSDM_ERR                                                                               (0x1<<3)
	#define CCM_CCM_INT_STS_CLR_REG_CSDM_ERR_SIZE                                                                          3		
	#define CCM_CCM_INT_STS_CLR_REG_TSEM_ERR                                                                               (0x1<<4)
	#define CCM_CCM_INT_STS_CLR_REG_TSEM_ERR_SIZE                                                                          4		
	#define CCM_CCM_INT_STS_CLR_REG_XSEM_ERR                                                                               (0x1<<5)
	#define CCM_CCM_INT_STS_CLR_REG_XSEM_ERR_SIZE                                                                          5		
	#define CCM_CCM_INT_STS_CLR_REG_USEM_ERR                                                                               (0x1<<6)
	#define CCM_CCM_INT_STS_CLR_REG_USEM_ERR_SIZE                                                                          6		
	#define CCM_CCM_INT_STS_CLR_REG_PBF_ERR                                                                                (0x1<<7)
	#define CCM_CCM_INT_STS_CLR_REG_PBF_ERR_SIZE                                                                           7		
	#define CCM_CCM_INT_STS_CLR_REG_CP0_ERR                                                                                (0x1<<8)
	#define CCM_CCM_INT_STS_CLR_REG_CP0_ERR_SIZE                                                                           8		
	#define CCM_CCM_INT_STS_CLR_REG_CP1_ERR                                                                                (0x1<<9)
	#define CCM_CCM_INT_STS_CLR_REG_CP1_ERR_SIZE                                                                           9		
	#define CCM_CCM_INT_STS_CLR_REG_UM_ERR                                                                                 (0x1<<10)
	#define CCM_CCM_INT_STS_CLR_REG_UM_ERR_SIZE                                                                            10
#define CCM_REG_CCM_INT_STS_WR                                                                                             0xd01e0UL //ACCESS:WR  DataWidth:0xb  Description: Interrupt register #0 bit set or clear		
	#define CCM_CCM_INT_STS_WR_REG_ADDRESS_ERROR                                                                           (0x1<<0)
	#define CCM_CCM_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                      0		
	#define CCM_CCM_INT_STS_WR_REG_XX_UQ_ERR                                                                               (0x1<<1)
	#define CCM_CCM_INT_STS_WR_REG_XX_UQ_ERR_SIZE                                                                          1		
	#define CCM_CCM_INT_STS_WR_REG_STORM_ERR                                                                               (0x1<<2)
	#define CCM_CCM_INT_STS_WR_REG_STORM_ERR_SIZE                                                                          2		
	#define CCM_CCM_INT_STS_WR_REG_CSDM_ERR                                                                                (0x1<<3)
	#define CCM_CCM_INT_STS_WR_REG_CSDM_ERR_SIZE                                                                           3		
	#define CCM_CCM_INT_STS_WR_REG_TSEM_ERR                                                                                (0x1<<4)
	#define CCM_CCM_INT_STS_WR_REG_TSEM_ERR_SIZE                                                                           4		
	#define CCM_CCM_INT_STS_WR_REG_XSEM_ERR                                                                                (0x1<<5)
	#define CCM_CCM_INT_STS_WR_REG_XSEM_ERR_SIZE                                                                           5		
	#define CCM_CCM_INT_STS_WR_REG_USEM_ERR                                                                                (0x1<<6)
	#define CCM_CCM_INT_STS_WR_REG_USEM_ERR_SIZE                                                                           6		
	#define CCM_CCM_INT_STS_WR_REG_PBF_ERR                                                                                 (0x1<<7)
	#define CCM_CCM_INT_STS_WR_REG_PBF_ERR_SIZE                                                                            7		
	#define CCM_CCM_INT_STS_WR_REG_CP0_ERR                                                                                 (0x1<<8)
	#define CCM_CCM_INT_STS_WR_REG_CP0_ERR_SIZE                                                                            8		
	#define CCM_CCM_INT_STS_WR_REG_CP1_ERR                                                                                 (0x1<<9)
	#define CCM_CCM_INT_STS_WR_REG_CP1_ERR_SIZE                                                                            9		
	#define CCM_CCM_INT_STS_WR_REG_UM_ERR                                                                                  (0x1<<10)
	#define CCM_CCM_INT_STS_WR_REG_UM_ERR_SIZE                                                                             10
#define CCM_REG_CCM_INT_MASK                                                                                               0xd01e4UL //ACCESS:RW  DataWidth:0xb  Description: Interrupt mask register #0 read/write		
	#define CCM_CCM_INT_MASK_REG_ADDRESS_ERROR                                                                             (0x1<<0)
	#define CCM_CCM_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                        0		
	#define CCM_CCM_INT_MASK_REG_XX_UQ_ERR                                                                                 (0x1<<1)
	#define CCM_CCM_INT_MASK_REG_XX_UQ_ERR_SIZE                                                                            1		
	#define CCM_CCM_INT_MASK_REG_STORM_ERR                                                                                 (0x1<<2)
	#define CCM_CCM_INT_MASK_REG_STORM_ERR_SIZE                                                                            2		
	#define CCM_CCM_INT_MASK_REG_CSDM_ERR                                                                                  (0x1<<3)
	#define CCM_CCM_INT_MASK_REG_CSDM_ERR_SIZE                                                                             3		
	#define CCM_CCM_INT_MASK_REG_TSEM_ERR                                                                                  (0x1<<4)
	#define CCM_CCM_INT_MASK_REG_TSEM_ERR_SIZE                                                                             4		
	#define CCM_CCM_INT_MASK_REG_XSEM_ERR                                                                                  (0x1<<5)
	#define CCM_CCM_INT_MASK_REG_XSEM_ERR_SIZE                                                                             5		
	#define CCM_CCM_INT_MASK_REG_USEM_ERR                                                                                  (0x1<<6)
	#define CCM_CCM_INT_MASK_REG_USEM_ERR_SIZE                                                                             6		
	#define CCM_CCM_INT_MASK_REG_PBF_ERR                                                                                   (0x1<<7)
	#define CCM_CCM_INT_MASK_REG_PBF_ERR_SIZE                                                                              7		
	#define CCM_CCM_INT_MASK_REG_CP0_ERR                                                                                   (0x1<<8)
	#define CCM_CCM_INT_MASK_REG_CP0_ERR_SIZE                                                                              8		
	#define CCM_CCM_INT_MASK_REG_CP1_ERR                                                                                   (0x1<<9)
	#define CCM_CCM_INT_MASK_REG_CP1_ERR_SIZE                                                                              9		
	#define CCM_CCM_INT_MASK_REG_UM_ERR                                                                                    (0x1<<10)
	#define CCM_CCM_INT_MASK_REG_UM_ERR_SIZE                                                                               10
#define CCM_REG_CCM_PRTY_STS                                                                                               0xd01e8UL //ACCESS:R  DataWidth:0x1b  Description: Parity register #0 read		
	#define CCM_CCM_PRTY_STS_REG_PARITY                                                                                    (0x1<<0)
	#define CCM_CCM_PRTY_STS_REG_PARITY_SIZE                                                                               0		
	#define CCM_CCM_PRTY_STS_REG_XT_PRTY                                                                                   (0x1<<1)
	#define CCM_CCM_PRTY_STS_REG_XT_PRTY_SIZE                                                                              1		
	#define CCM_CCM_PRTY_STS_REG_DT_PRTY                                                                                   (0x1<<2)
	#define CCM_CCM_PRTY_STS_REG_DT_PRTY_SIZE                                                                              2		
	#define CCM_CCM_PRTY_STS_REG_PM_PRTY0                                                                                  (0x1<<3)
	#define CCM_CCM_PRTY_STS_REG_PM_PRTY0_SIZE                                                                             3		
	#define CCM_CCM_PRTY_STS_REG_PM_PRTY1                                                                                  (0x1<<4)
	#define CCM_CCM_PRTY_STS_REG_PM_PRTY1_SIZE                                                                             4		
	#define CCM_CCM_PRTY_STS_REG_UQ_PRTY                                                                                   (0x1<<5)
	#define CCM_CCM_PRTY_STS_REG_UQ_PRTY_SIZE                                                                              5		
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY0                                                                                  (0x1<<6)
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY0_SIZE                                                                             6		
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY1                                                                                  (0x1<<7)
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY1_SIZE                                                                             7		
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY2                                                                                  (0x1<<8)
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY2_SIZE                                                                             8		
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY3                                                                                  (0x1<<9)
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY3_SIZE                                                                             9		
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY4                                                                                  (0x1<<10)
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY4_SIZE                                                                             10		
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY5                                                                                  (0x1<<11)
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY5_SIZE                                                                             11		
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY6                                                                                  (0x1<<12)
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY6_SIZE                                                                             12		
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY7                                                                                  (0x1<<13)
	#define CCM_CCM_PRTY_STS_REG_AG_PRTY7_SIZE                                                                             13		
	#define CCM_CCM_PRTY_STS_REG_SM_PRTY0                                                                                  (0x1<<14)
	#define CCM_CCM_PRTY_STS_REG_SM_PRTY0_SIZE                                                                             14		
	#define CCM_CCM_PRTY_STS_REG_SM_PRTY1                                                                                  (0x1<<15)
	#define CCM_CCM_PRTY_STS_REG_SM_PRTY1_SIZE                                                                             15		
	#define CCM_CCM_PRTY_STS_REG_SM_PRTY2                                                                                  (0x1<<16)
	#define CCM_CCM_PRTY_STS_REG_SM_PRTY2_SIZE                                                                             16		
	#define CCM_CCM_PRTY_STS_REG_SM_PRTY3                                                                                  (0x1<<17)
	#define CCM_CCM_PRTY_STS_REG_SM_PRTY3_SIZE                                                                             17		
	#define CCM_CCM_PRTY_STS_REG_STORM_PRTY                                                                                (0x1<<18)
	#define CCM_CCM_PRTY_STS_REG_STORM_PRTY_SIZE                                                                           18		
	#define CCM_CCM_PRTY_STS_REG_CSDM_PRTY                                                                                 (0x1<<19)
	#define CCM_CCM_PRTY_STS_REG_CSDM_PRTY_SIZE                                                                            19		
	#define CCM_CCM_PRTY_STS_REG_TSEM_PRTY                                                                                 (0x1<<20)
	#define CCM_CCM_PRTY_STS_REG_TSEM_PRTY_SIZE                                                                            20		
	#define CCM_CCM_PRTY_STS_REG_XSEM_PRTY                                                                                 (0x1<<21)
	#define CCM_CCM_PRTY_STS_REG_XSEM_PRTY_SIZE                                                                            21		
	#define CCM_CCM_PRTY_STS_REG_USEM_PRTY                                                                                 (0x1<<22)
	#define CCM_CCM_PRTY_STS_REG_USEM_PRTY_SIZE                                                                            22		
	#define CCM_CCM_PRTY_STS_REG_PBF_PRTY                                                                                  (0x1<<23)
	#define CCM_CCM_PRTY_STS_REG_PBF_PRTY_SIZE                                                                             23		
	#define CCM_CCM_PRTY_STS_REG_CP0_PRTY                                                                                  (0x1<<24)
	#define CCM_CCM_PRTY_STS_REG_CP0_PRTY_SIZE                                                                             24		
	#define CCM_CCM_PRTY_STS_REG_CP1_PRTY                                                                                  (0x1<<25)
	#define CCM_CCM_PRTY_STS_REG_CP1_PRTY_SIZE                                                                             25		
	#define CCM_CCM_PRTY_STS_REG_UM_PRTY                                                                                   (0x1<<26)
	#define CCM_CCM_PRTY_STS_REG_UM_PRTY_SIZE                                                                              26
#define CCM_REG_CCM_PRTY_STS_CLR                                                                                           0xd01ecUL //ACCESS:RC  DataWidth:0x1b  Description: Parity register #0 read clear		
	#define CCM_CCM_PRTY_STS_CLR_REG_PARITY                                                                                (0x1<<0)
	#define CCM_CCM_PRTY_STS_CLR_REG_PARITY_SIZE                                                                           0		
	#define CCM_CCM_PRTY_STS_CLR_REG_XT_PRTY                                                                               (0x1<<1)
	#define CCM_CCM_PRTY_STS_CLR_REG_XT_PRTY_SIZE                                                                          1		
	#define CCM_CCM_PRTY_STS_CLR_REG_DT_PRTY                                                                               (0x1<<2)
	#define CCM_CCM_PRTY_STS_CLR_REG_DT_PRTY_SIZE                                                                          2		
	#define CCM_CCM_PRTY_STS_CLR_REG_PM_PRTY0                                                                              (0x1<<3)
	#define CCM_CCM_PRTY_STS_CLR_REG_PM_PRTY0_SIZE                                                                         3		
	#define CCM_CCM_PRTY_STS_CLR_REG_PM_PRTY1                                                                              (0x1<<4)
	#define CCM_CCM_PRTY_STS_CLR_REG_PM_PRTY1_SIZE                                                                         4		
	#define CCM_CCM_PRTY_STS_CLR_REG_UQ_PRTY                                                                               (0x1<<5)
	#define CCM_CCM_PRTY_STS_CLR_REG_UQ_PRTY_SIZE                                                                          5		
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY0                                                                              (0x1<<6)
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY0_SIZE                                                                         6		
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY1                                                                              (0x1<<7)
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY1_SIZE                                                                         7		
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY2                                                                              (0x1<<8)
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY2_SIZE                                                                         8		
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY3                                                                              (0x1<<9)
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY3_SIZE                                                                         9		
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY4                                                                              (0x1<<10)
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY4_SIZE                                                                         10		
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY5                                                                              (0x1<<11)
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY5_SIZE                                                                         11		
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY6                                                                              (0x1<<12)
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY6_SIZE                                                                         12		
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY7                                                                              (0x1<<13)
	#define CCM_CCM_PRTY_STS_CLR_REG_AG_PRTY7_SIZE                                                                         13		
	#define CCM_CCM_PRTY_STS_CLR_REG_SM_PRTY0                                                                              (0x1<<14)
	#define CCM_CCM_PRTY_STS_CLR_REG_SM_PRTY0_SIZE                                                                         14		
	#define CCM_CCM_PRTY_STS_CLR_REG_SM_PRTY1                                                                              (0x1<<15)
	#define CCM_CCM_PRTY_STS_CLR_REG_SM_PRTY1_SIZE                                                                         15		
	#define CCM_CCM_PRTY_STS_CLR_REG_SM_PRTY2                                                                              (0x1<<16)
	#define CCM_CCM_PRTY_STS_CLR_REG_SM_PRTY2_SIZE                                                                         16		
	#define CCM_CCM_PRTY_STS_CLR_REG_SM_PRTY3                                                                              (0x1<<17)
	#define CCM_CCM_PRTY_STS_CLR_REG_SM_PRTY3_SIZE                                                                         17		
	#define CCM_CCM_PRTY_STS_CLR_REG_STORM_PRTY                                                                            (0x1<<18)
	#define CCM_CCM_PRTY_STS_CLR_REG_STORM_PRTY_SIZE                                                                       18		
	#define CCM_CCM_PRTY_STS_CLR_REG_CSDM_PRTY                                                                             (0x1<<19)
	#define CCM_CCM_PRTY_STS_CLR_REG_CSDM_PRTY_SIZE                                                                        19		
	#define CCM_CCM_PRTY_STS_CLR_REG_TSEM_PRTY                                                                             (0x1<<20)
	#define CCM_CCM_PRTY_STS_CLR_REG_TSEM_PRTY_SIZE                                                                        20		
	#define CCM_CCM_PRTY_STS_CLR_REG_XSEM_PRTY                                                                             (0x1<<21)
	#define CCM_CCM_PRTY_STS_CLR_REG_XSEM_PRTY_SIZE                                                                        21		
	#define CCM_CCM_PRTY_STS_CLR_REG_USEM_PRTY                                                                             (0x1<<22)
	#define CCM_CCM_PRTY_STS_CLR_REG_USEM_PRTY_SIZE                                                                        22		
	#define CCM_CCM_PRTY_STS_CLR_REG_PBF_PRTY                                                                              (0x1<<23)
	#define CCM_CCM_PRTY_STS_CLR_REG_PBF_PRTY_SIZE                                                                         23		
	#define CCM_CCM_PRTY_STS_CLR_REG_CP0_PRTY                                                                              (0x1<<24)
	#define CCM_CCM_PRTY_STS_CLR_REG_CP0_PRTY_SIZE                                                                         24		
	#define CCM_CCM_PRTY_STS_CLR_REG_CP1_PRTY                                                                              (0x1<<25)
	#define CCM_CCM_PRTY_STS_CLR_REG_CP1_PRTY_SIZE                                                                         25		
	#define CCM_CCM_PRTY_STS_CLR_REG_UM_PRTY                                                                               (0x1<<26)
	#define CCM_CCM_PRTY_STS_CLR_REG_UM_PRTY_SIZE                                                                          26
#define CCM_REG_CCM_PRTY_STS_WR                                                                                            0xd01f0UL //ACCESS:WR  DataWidth:0x1b  Description: Parity register #0 bit set or clear		
	#define CCM_CCM_PRTY_STS_WR_REG_PARITY                                                                                 (0x1<<0)
	#define CCM_CCM_PRTY_STS_WR_REG_PARITY_SIZE                                                                            0		
	#define CCM_CCM_PRTY_STS_WR_REG_XT_PRTY                                                                                (0x1<<1)
	#define CCM_CCM_PRTY_STS_WR_REG_XT_PRTY_SIZE                                                                           1		
	#define CCM_CCM_PRTY_STS_WR_REG_DT_PRTY                                                                                (0x1<<2)
	#define CCM_CCM_PRTY_STS_WR_REG_DT_PRTY_SIZE                                                                           2		
	#define CCM_CCM_PRTY_STS_WR_REG_PM_PRTY0                                                                               (0x1<<3)
	#define CCM_CCM_PRTY_STS_WR_REG_PM_PRTY0_SIZE                                                                          3		
	#define CCM_CCM_PRTY_STS_WR_REG_PM_PRTY1                                                                               (0x1<<4)
	#define CCM_CCM_PRTY_STS_WR_REG_PM_PRTY1_SIZE                                                                          4		
	#define CCM_CCM_PRTY_STS_WR_REG_UQ_PRTY                                                                                (0x1<<5)
	#define CCM_CCM_PRTY_STS_WR_REG_UQ_PRTY_SIZE                                                                           5		
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY0                                                                               (0x1<<6)
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY0_SIZE                                                                          6		
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY1                                                                               (0x1<<7)
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY1_SIZE                                                                          7		
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY2                                                                               (0x1<<8)
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY2_SIZE                                                                          8		
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY3                                                                               (0x1<<9)
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY3_SIZE                                                                          9		
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY4                                                                               (0x1<<10)
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY4_SIZE                                                                          10		
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY5                                                                               (0x1<<11)
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY5_SIZE                                                                          11		
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY6                                                                               (0x1<<12)
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY6_SIZE                                                                          12		
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY7                                                                               (0x1<<13)
	#define CCM_CCM_PRTY_STS_WR_REG_AG_PRTY7_SIZE                                                                          13		
	#define CCM_CCM_PRTY_STS_WR_REG_SM_PRTY0                                                                               (0x1<<14)
	#define CCM_CCM_PRTY_STS_WR_REG_SM_PRTY0_SIZE                                                                          14		
	#define CCM_CCM_PRTY_STS_WR_REG_SM_PRTY1                                                                               (0x1<<15)
	#define CCM_CCM_PRTY_STS_WR_REG_SM_PRTY1_SIZE                                                                          15		
	#define CCM_CCM_PRTY_STS_WR_REG_SM_PRTY2                                                                               (0x1<<16)
	#define CCM_CCM_PRTY_STS_WR_REG_SM_PRTY2_SIZE                                                                          16		
	#define CCM_CCM_PRTY_STS_WR_REG_SM_PRTY3                                                                               (0x1<<17)
	#define CCM_CCM_PRTY_STS_WR_REG_SM_PRTY3_SIZE                                                                          17		
	#define CCM_CCM_PRTY_STS_WR_REG_STORM_PRTY                                                                             (0x1<<18)
	#define CCM_CCM_PRTY_STS_WR_REG_STORM_PRTY_SIZE                                                                        18		
	#define CCM_CCM_PRTY_STS_WR_REG_CSDM_PRTY                                                                              (0x1<<19)
	#define CCM_CCM_PRTY_STS_WR_REG_CSDM_PRTY_SIZE                                                                         19		
	#define CCM_CCM_PRTY_STS_WR_REG_TSEM_PRTY                                                                              (0x1<<20)
	#define CCM_CCM_PRTY_STS_WR_REG_TSEM_PRTY_SIZE                                                                         20		
	#define CCM_CCM_PRTY_STS_WR_REG_XSEM_PRTY                                                                              (0x1<<21)
	#define CCM_CCM_PRTY_STS_WR_REG_XSEM_PRTY_SIZE                                                                         21		
	#define CCM_CCM_PRTY_STS_WR_REG_USEM_PRTY                                                                              (0x1<<22)
	#define CCM_CCM_PRTY_STS_WR_REG_USEM_PRTY_SIZE                                                                         22		
	#define CCM_CCM_PRTY_STS_WR_REG_PBF_PRTY                                                                               (0x1<<23)
	#define CCM_CCM_PRTY_STS_WR_REG_PBF_PRTY_SIZE                                                                          23		
	#define CCM_CCM_PRTY_STS_WR_REG_CP0_PRTY                                                                               (0x1<<24)
	#define CCM_CCM_PRTY_STS_WR_REG_CP0_PRTY_SIZE                                                                          24		
	#define CCM_CCM_PRTY_STS_WR_REG_CP1_PRTY                                                                               (0x1<<25)
	#define CCM_CCM_PRTY_STS_WR_REG_CP1_PRTY_SIZE                                                                          25		
	#define CCM_CCM_PRTY_STS_WR_REG_UM_PRTY                                                                                (0x1<<26)
	#define CCM_CCM_PRTY_STS_WR_REG_UM_PRTY_SIZE                                                                           26
#define CCM_REG_CCM_PRTY_MASK                                                                                              0xd01f4UL //ACCESS:RW  DataWidth:0x1b  Description: Parity mask register #0 read/write		
	#define CCM_CCM_PRTY_MASK_REG_PARITY                                                                                   (0x1<<0)
	#define CCM_CCM_PRTY_MASK_REG_PARITY_SIZE                                                                              0		
	#define CCM_CCM_PRTY_MASK_REG_XT_PRTY                                                                                  (0x1<<1)
	#define CCM_CCM_PRTY_MASK_REG_XT_PRTY_SIZE                                                                             1		
	#define CCM_CCM_PRTY_MASK_REG_DT_PRTY                                                                                  (0x1<<2)
	#define CCM_CCM_PRTY_MASK_REG_DT_PRTY_SIZE                                                                             2		
	#define CCM_CCM_PRTY_MASK_REG_PM_PRTY0                                                                                 (0x1<<3)
	#define CCM_CCM_PRTY_MASK_REG_PM_PRTY0_SIZE                                                                            3		
	#define CCM_CCM_PRTY_MASK_REG_PM_PRTY1                                                                                 (0x1<<4)
	#define CCM_CCM_PRTY_MASK_REG_PM_PRTY1_SIZE                                                                            4		
	#define CCM_CCM_PRTY_MASK_REG_UQ_PRTY                                                                                  (0x1<<5)
	#define CCM_CCM_PRTY_MASK_REG_UQ_PRTY_SIZE                                                                             5		
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY0                                                                                 (0x1<<6)
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY0_SIZE                                                                            6		
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY1                                                                                 (0x1<<7)
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY1_SIZE                                                                            7		
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY2                                                                                 (0x1<<8)
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY2_SIZE                                                                            8		
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY3                                                                                 (0x1<<9)
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY3_SIZE                                                                            9		
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY4                                                                                 (0x1<<10)
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY4_SIZE                                                                            10		
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY5                                                                                 (0x1<<11)
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY5_SIZE                                                                            11		
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY6                                                                                 (0x1<<12)
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY6_SIZE                                                                            12		
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY7                                                                                 (0x1<<13)
	#define CCM_CCM_PRTY_MASK_REG_AG_PRTY7_SIZE                                                                            13		
	#define CCM_CCM_PRTY_MASK_REG_SM_PRTY0                                                                                 (0x1<<14)
	#define CCM_CCM_PRTY_MASK_REG_SM_PRTY0_SIZE                                                                            14		
	#define CCM_CCM_PRTY_MASK_REG_SM_PRTY1                                                                                 (0x1<<15)
	#define CCM_CCM_PRTY_MASK_REG_SM_PRTY1_SIZE                                                                            15		
	#define CCM_CCM_PRTY_MASK_REG_SM_PRTY2                                                                                 (0x1<<16)
	#define CCM_CCM_PRTY_MASK_REG_SM_PRTY2_SIZE                                                                            16		
	#define CCM_CCM_PRTY_MASK_REG_SM_PRTY3                                                                                 (0x1<<17)
	#define CCM_CCM_PRTY_MASK_REG_SM_PRTY3_SIZE                                                                            17		
	#define CCM_CCM_PRTY_MASK_REG_STORM_PRTY                                                                               (0x1<<18)
	#define CCM_CCM_PRTY_MASK_REG_STORM_PRTY_SIZE                                                                          18		
	#define CCM_CCM_PRTY_MASK_REG_CSDM_PRTY                                                                                (0x1<<19)
	#define CCM_CCM_PRTY_MASK_REG_CSDM_PRTY_SIZE                                                                           19		
	#define CCM_CCM_PRTY_MASK_REG_TSEM_PRTY                                                                                (0x1<<20)
	#define CCM_CCM_PRTY_MASK_REG_TSEM_PRTY_SIZE                                                                           20		
	#define CCM_CCM_PRTY_MASK_REG_XSEM_PRTY                                                                                (0x1<<21)
	#define CCM_CCM_PRTY_MASK_REG_XSEM_PRTY_SIZE                                                                           21		
	#define CCM_CCM_PRTY_MASK_REG_USEM_PRTY                                                                                (0x1<<22)
	#define CCM_CCM_PRTY_MASK_REG_USEM_PRTY_SIZE                                                                           22		
	#define CCM_CCM_PRTY_MASK_REG_PBF_PRTY                                                                                 (0x1<<23)
	#define CCM_CCM_PRTY_MASK_REG_PBF_PRTY_SIZE                                                                            23		
	#define CCM_CCM_PRTY_MASK_REG_CP0_PRTY                                                                                 (0x1<<24)
	#define CCM_CCM_PRTY_MASK_REG_CP0_PRTY_SIZE                                                                            24		
	#define CCM_CCM_PRTY_MASK_REG_CP1_PRTY                                                                                 (0x1<<25)
	#define CCM_CCM_PRTY_MASK_REG_CP1_PRTY_SIZE                                                                            25		
	#define CCM_CCM_PRTY_MASK_REG_UM_PRTY                                                                                  (0x1<<26)
	#define CCM_CCM_PRTY_MASK_REG_UM_PRTY_SIZE                                                                             26
#define CCM_REG_SM_CTX1_TM                                                                                                 0xd01f8UL //ACCESS:RW  DataWidth:0x5  Description: Debug only. TM bits of STORM context. MSB.
#define CCM_REG_ECO_RESERVED                                                                                               0xd01fcUL //ACCESS:RW  DataWidth:0x8  Description: chicken bits
#define CCM_REG_IS_UM_TM                                                                                                   0xd0800UL //ACCESS:RW  DataWidth:0x2  Description: Debug only. TM bits of input stage UM buffer.
#define CCM_REG_IS_STORM_TM                                                                                                0xd0804UL //ACCESS:RW  DataWidth:0x2  Description: Debug only. TM bits of input stage STORM buffer.
#define CCM_REG_PM_RAM_TM                                                                                                  0xd0808UL //ACCESS:RW  DataWidth:0x2  Description: Debug only. TM bits of Pending Messages RAM.
#define CCM_REG_IS_USEM_TM                                                                                                 0xd080cUL //ACCESS:RW  DataWidth:0x2  Description: Debug only. TM bits of USEM input stage..
#define CCM_REG_UM_FIC1_FORCE                                                                                              0xd0818UL //ACCESS:RW  DataWidth:0x1  Description: 0-messages unlocked from Pending messages RAM go to the FIC for which they were designated in input message; 1-messages unlocked from Pending messages RAM are forced to FIC1 whether they were destined to FIC0 or FIC1 in original message.
#define CCM_REG_QOS_PHYS_QNUM0_0                                                                                           0xd0114UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 0 with QOS equal 0 port index 0.
#define CCM_REG_QOS_PHYS_QNUM0_0_SIZE                                                                                      1
#define CCM_REG_QOS_PHYS_QNUM0_1                                                                                           0xd0118UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 0 with QOS equal 0 port index 1.
#define CCM_REG_QOS_PHYS_QNUM0_1_SIZE                                                                                      1
#define CCM_REG_QOS_PHYS_QNUM1_0                                                                                           0xd011cUL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 0 with QOS equal 1 port index 0.
#define CCM_REG_QOS_PHYS_QNUM1_0_SIZE                                                                                      1
#define CCM_REG_QOS_PHYS_QNUM1_1                                                                                           0xd0120UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 0 with QOS equal 1 per port index 1.
#define CCM_REG_QOS_PHYS_QNUM1_1_SIZE                                                                                      1
#define CCM_REG_QOS_PHYS_QNUM2_0                                                                                           0xd0124UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 0 with QOS equal 2 port index 0.
#define CCM_REG_QOS_PHYS_QNUM2_0_SIZE                                                                                      1
#define CCM_REG_QOS_PHYS_QNUM2_1                                                                                           0xd0128UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 0 with QOS equal 2 port index 1.
#define CCM_REG_QOS_PHYS_QNUM2_1_SIZE                                                                                      1
#define CCM_REG_QOS_PHYS_QNUM3_0                                                                                           0xd012cUL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 0 with QOS equal 3 port index 0.
#define CCM_REG_QOS_PHYS_QNUM3_0_SIZE                                                                                      1
#define CCM_REG_QOS_PHYS_QNUM3_1                                                                                           0xd0130UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 0 with QOS equal 3 port index 1.
#define CCM_REG_QOS_PHYS_QNUM3_1_SIZE                                                                                      1
#define CCM_REG_PHYS_QNUM1_0                                                                                               0xd0134UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 1 per port index.
#define CCM_REG_PHYS_QNUM1_0_SIZE                                                                                          1
#define CCM_REG_PHYS_QNUM1_1                                                                                               0xd0138UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 1 per port index.
#define CCM_REG_PHYS_QNUM1_1_SIZE                                                                                          1
#define CCM_REG_PHYS_QNUM2_0                                                                                               0xd013cUL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 2 per port index.
#define CCM_REG_PHYS_QNUM2_0_SIZE                                                                                          1
#define CCM_REG_PHYS_QNUM2_1                                                                                               0xd0140UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 2 per port index.
#define CCM_REG_PHYS_QNUM2_1_SIZE                                                                                          1
#define CCM_REG_PHYS_QNUM3_0                                                                                               0xd0144UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 3 per port index.
#define CCM_REG_PHYS_QNUM3_0_SIZE                                                                                          1
#define CCM_REG_PHYS_QNUM3_1                                                                                               0xd0148UL //ACCESS:RW  DataWidth:0x7  SPLIT:4  Description: The physical queue number of queue number 3 per port index.
#define CCM_REG_PHYS_QNUM3_1_SIZE                                                                                          1
#define CCM_REG_CAM_OCCUP_ST                                                                                               0xd0200UL //ACCESS:RW  DataWidth:0x5  Description: XX protection LCID CAM occupancy sticky status. The write to the register is performed by the XX internal circuitry.
#define CCM_REG_CAM_OCCUP_ST_SIZE                                                                                          1
#define CCM_REG_CFC_INIT_CRD                                                                                               0xd0204UL //ACCESS:RW  DataWidth:0x4  Description: CFC output initial credit. Max credit available - 15.Write writes the initial credit value; read returns the current value of the credit counter. Must be initialized to 1 at start-up.
#define CCM_REG_CFC_INIT_CRD_SIZE                                                                                          1
#define CCM_REG_CP_MSG                                                                                                     0xd0208UL //ACCESS:W  DataWidth:0x20  Description: Indirect access to write the CP message.
#define CCM_REG_CP_MSG_SIZE                                                                                                1
#define CCM_REG_CQM_INIT_CRD                                                                                               0xd020cUL //ACCESS:RW  DataWidth:0x6  Description: QM output initial credit. Max credit available - 32. Write writes the initial credit value; read returns the current value of the credit counter. Must be initialized to 32 at start-up.
#define CCM_REG_CQM_INIT_CRD_SIZE                                                                                          1
#define CCM_REG_FIC0_INIT_CRD                                                                                              0xd0210UL //ACCESS:RW  DataWidth:0x8  Description: FIC0 output initial credit. Max credit available - 255. Write writes the initial credit value; read returns the current value of the credit counter. Must be initialized to 64 at start-up.
#define CCM_REG_FIC0_INIT_CRD_SIZE                                                                                         1
#define CCM_REG_FIC1_INIT_CRD                                                                                              0xd0214UL //ACCESS:RW  DataWidth:0x8  Description: FIC1 output initial credit. Max credit available - 255.Write writes the initial credit value; read returns the current value of the credit counter. Must be initialized to 64 at start-up.
#define CCM_REG_FIC1_INIT_CRD_SIZE                                                                                         1
#define CCM_REG_GLB_CNT_STICKY                                                                                             0xd0218UL //ACCESS:RW  DataWidth:0x1a  Description: QM global usage counter maximum sticky value.
#define CCM_REG_GLB_CNT_STICKY_SIZE                                                                                        1
#define CCM_REG_LL_SZ_STICKY                                                                                               0xd021cUL //ACCESS:RW  DataWidth:0x6  Description: XX protection Link List maximum value ever reached sticky value for any connection. The write to the register is performed by the XX internal circuitry.
#define CCM_REG_LL_SZ_STICKY_SIZE                                                                                          1
#define CCM_REG_XX_INIT_CRD                                                                                                0xd0220UL //ACCESS:RW  DataWidth:0x6  Description: Initial value for the credit counter; responsible for fulfilling of the Input Stage XX protection buffer by the XX protection pending messages. Max credit available - 127. Write writes the initial credit value; read returns the current value of the credit counter. Must be initialized to maximum XX protected message size - 2 at start-up.
#define CCM_REG_XX_INIT_CRD_SIZE                                                                                           1
#define CCM_REG_XX_MSG_NUM                                                                                                 0xd0224UL //ACCESS:RW  DataWidth:0x7  Description: The maximum number of pending messages; which may be stored in XX protection. At write the ~ccm_registers_xx_free.xx_free counter is also written.
#define CCM_REG_XX_MSG_NUM_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_0                                                                                                 0xd0228UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_0_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_1                                                                                                 0xd022cUL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_1_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_2                                                                                                 0xd0230UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_2_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_3                                                                                                 0xd0234UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_3_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_4                                                                                                 0xd0238UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_4_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_5                                                                                                 0xd023cUL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_5_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_6                                                                                                 0xd0240UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_6_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_7                                                                                                 0xd0244UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_7_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_8                                                                                                 0xd0248UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_8_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_9                                                                                                 0xd024cUL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_9_SIZE                                                                                            1
#define CCM_REG_LCID_CAM_10                                                                                                0xd0250UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_10_SIZE                                                                                           1
#define CCM_REG_LCID_CAM_11                                                                                                0xd0254UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_11_SIZE                                                                                           1
#define CCM_REG_LCID_CAM_12                                                                                                0xd0258UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_12_SIZE                                                                                           1
#define CCM_REG_LCID_CAM_13                                                                                                0xd025cUL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_13_SIZE                                                                                           1
#define CCM_REG_LCID_CAM_14                                                                                                0xd0260UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_14_SIZE                                                                                           1
#define CCM_REG_LCID_CAM_15                                                                                                0xd0264UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_15_SIZE                                                                                           1
#define CCM_REG_LCID_CAM_16                                                                                                0xd0268UL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_16_SIZE                                                                                           1
#define CCM_REG_LCID_CAM_17                                                                                                0xd026cUL //ACCESS:R  DataWidth:0x9  Description: Debug only. Read access to LCID CAM in XX protection mechanism.
#define CCM_REG_LCID_CAM_17_SIZE                                                                                           1
#define CCM_REG_XX_TABLE                                                                                                   0xd0280UL //ACCESS:RW  DataWidth:0x12  Description: Indirect access to the XX table of the XX protection mechanism. The fields are: [5:0] - tail pointer;[11:6] - Link List size;[17:12] - header pointer.
#define CCM_REG_XX_TABLE_SIZE                                                                                              18
#define CCM_REG_XX_DESCR_TABLE                                                                                             0xd0300UL //ACCESS:RW  DataWidth:0x13  Description: Indirect access to the descriptor table of the XX protection mechanism. The fields are: [5:0] - message length; [12:6] - message pointer;[18:13] - next pointer.
#define CCM_REG_XX_DESCR_TABLE_SIZE                                                                                        24
#define CCM_REG_XX_PEND_MSG                                                                                                0xd0400UL //ACCESS:RW  DataWidth:0x20  Description: Debug only. Indirect access to the Pending messages RAM of the XX protection mechanism. Bits [7:1] stand for row number; bit [0] stand for one of 2 REGs in the row.
#define CCM_REG_XX_PEND_MSG_SIZE                                                                                           144
#define CCM_REG_AG_CTX                                                                                                     0xd4000UL //ACCESS:RW  DataWidth:0x20  Description: Indirect access to AG context with 32-bits granularity. The bits [11:8] of the address should be the offset within the accessed LCID context; the bits [7:0] are the accessed LCID.Example: to write to REG3 LCID100. The RBC address should be 12'h364.
#define CCM_REG_AG_CTX_SIZE                                                                                                2560
#define CCM_REG_STORM_CTX                                                                                                  0xd8000UL //ACCESS:RW  DataWidth:0x20  Description: Indirect access to STORM context with 32-bits granularity. The bits [12:8] of the address should be the offset within the accessed LCID context; the bits [7:0] are the accessed LCID.Example: to write to REG10 LCID100. The RBC address should be 13'ha64.
#define CCM_REG_STORM_CTX_SIZE                                                                                             8192
#define CCM_REG_DT_TM                                                                                                      0xd0810UL //ACCESS:R  DataWidth:0x2  Description: Debug only. TM bits of Descriptor table.
#define CCM_REG_DT_TM_SIZE                                                                                                 2
#define CCM_REG_CCM_UNUSED_EMPTY_0                                                                                         0xd0270UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CCM_REG_CCM_UNUSED_EMPTY_0_SIZE                                                                                    4
#define CCM_REG_CCM_UNUSED_EMPTY_1                                                                                         0xd081cUL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CCM_REG_CCM_UNUSED_EMPTY_1_SIZE                                                                                    3577
#define CDU_REG_CDU_CHK_MASK0                                                                                              0x101000UL //ACCESS:RW  DataWidth:0x18  Multi Field Register		
	#define CDU_CDU_CHK_MASK0_REG_CHECK_EN0                                                                                (0x3f<<0)
	#define CDU_CDU_CHK_MASK0_REG_CHECK_EN0_SIZE                                                                           0		
	#define CDU_CDU_CHK_MASK0_REG_CHECK_EN1                                                                                (0x3f<<6)
	#define CDU_CDU_CHK_MASK0_REG_CHECK_EN1_SIZE                                                                           6		
	#define CDU_CDU_CHK_MASK0_REG_CHECK_EN2                                                                                (0x3f<<12)
	#define CDU_CDU_CHK_MASK0_REG_CHECK_EN2_SIZE                                                                           12		
	#define CDU_CDU_CHK_MASK0_REG_CHECK_EN3                                                                                (0x3f<<18)
	#define CDU_CDU_CHK_MASK0_REG_CHECK_EN3_SIZE                                                                           18
#define CDU_REG_CDU_CHK_MASK1                                                                                              0x101004UL //ACCESS:RW  DataWidth:0x18  Multi Field Register		
	#define CDU_CDU_CHK_MASK1_REG_CHECK_EN4                                                                                (0x3f<<0)
	#define CDU_CDU_CHK_MASK1_REG_CHECK_EN4_SIZE                                                                           0		
	#define CDU_CDU_CHK_MASK1_REG_CHECK_EN5                                                                                (0x3f<<6)
	#define CDU_CDU_CHK_MASK1_REG_CHECK_EN5_SIZE                                                                           6		
	#define CDU_CDU_CHK_MASK1_REG_CHECK_EN6                                                                                (0x3f<<12)
	#define CDU_CDU_CHK_MASK1_REG_CHECK_EN6_SIZE                                                                           12		
	#define CDU_CDU_CHK_MASK1_REG_CHECK_EN7                                                                                (0x3f<<18)
	#define CDU_CDU_CHK_MASK1_REG_CHECK_EN7_SIZE                                                                           18
#define CDU_REG_CDU_CONTROL0                                                                                               0x101008UL //ACCESS:RW  DataWidth:0x9  Multi Field Register		
	#define CDU_CDU_CONTROL0_REG_PXP_ACTIVE                                                                                (0x1<<0)
	#define CDU_CDU_CONTROL0_REG_PXP_ACTIVE_SIZE                                                                           0		
	#define CDU_CDU_CONTROL0_REG_L1TT_SP                                                                                   (0x1<<1)
	#define CDU_CDU_CONTROL0_REG_L1TT_SP_SIZE                                                                              1		
	#define CDU_CDU_CONTROL0_REG_MATT_SP                                                                                   (0x1<<2)
	#define CDU_CDU_CONTROL0_REG_MATT_SP_SIZE                                                                              2		
	#define CDU_CDU_CONTROL0_REG_DISABLE_DIVIDER                                                                           (0x1<<3)
	#define CDU_CDU_CONTROL0_REG_DISABLE_DIVIDER_SIZE                                                                      3		
	#define CDU_CDU_CONTROL0_REG_MASK_ECC                                                                                  (0x1<<4)
	#define CDU_CDU_CONTROL0_REG_MASK_ECC_SIZE                                                                             4		
	#define CDU_CDU_CONTROL0_REG_LDRESP_ADDR_DIS                                                                           (0x1<<5)
	#define CDU_CDU_CONTROL0_REG_LDRESP_ADDR_DIS_SIZE                                                                      5		
	#define CDU_CDU_CONTROL0_REG_DISABLE_INPUTS                                                                            (0x1<<6)
	#define CDU_CDU_CONTROL0_REG_DISABLE_INPUTS_SIZE                                                                       6		
	#define CDU_CDU_CONTROL0_REG_DISABLE_OUTPUTS                                                                           (0x1<<7)
	#define CDU_CDU_CONTROL0_REG_DISABLE_OUTPUTS_SIZE                                                                      7		
	#define CDU_CDU_CONTROL0_REG_MASK_PCIE                                                                                 (0x1<<8)
	#define CDU_CDU_CONTROL0_REG_MASK_PCIE_SIZE                                                                            8
#define CDU_REG_CDU_CONTROL1                                                                                               0x10100cUL //ACCESS:RW  DataWidth:0x1b  Multi Field Register		
	#define CDU_CDU_CONTROL1_REG_LDBUF_THRESH                                                                              (0x1f<<0)
	#define CDU_CDU_CONTROL1_REG_LDBUF_THRESH_SIZE                                                                         0		
	#define CDU_CDU_CONTROL1_REG_WBBUF_THRESH                                                                              (0x1f<<5)
	#define CDU_CDU_CONTROL1_REG_WBBUF_THRESH_SIZE                                                                         5		
	#define CDU_CDU_CONTROL1_REG_WBDP_RDTHRESH                                                                             (0x1f<<10)
	#define CDU_CDU_CONTROL1_REG_WBDP_RDTHRESH_SIZE                                                                        10		
	#define CDU_CDU_CONTROL1_REG_LDDPRELAX                                                                                 (0x1<<15)
	#define CDU_CDU_CONTROL1_REG_LDDPRELAX_SIZE                                                                            15		
	#define CDU_CDU_CONTROL1_REG_LDL1REQ_INTERGAP                                                                          (0x1f<<16)
	#define CDU_CDU_CONTROL1_REG_LDL1REQ_INTERGAP_SIZE                                                                     16		
	#define CDU_CDU_CONTROL1_REG_WBDPRELAX                                                                                 (0x1<<21)
	#define CDU_CDU_CONTROL1_REG_WBDPRELAX_SIZE                                                                            21		
	#define CDU_CDU_CONTROL1_REG_WBL1REQ_INTERGAP                                                                          (0x1f<<22)
	#define CDU_CDU_CONTROL1_REG_WBL1REQ_INTERGAP_SIZE                                                                     22
#define CDU_REG_CDU_DEBUG                                                                                                  0x101010UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define CDU_CDU_DEBUG_REG_MASK_LD_EOP_ERR                                                                              (0x1<<0)
	#define CDU_CDU_DEBUG_REG_MASK_LD_EOP_ERR_SIZE                                                                         0		
	#define CDU_CDU_DEBUG_REG_DISABLE_MERGE                                                                                (0x1<<1)
	#define CDU_CDU_DEBUG_REG_DISABLE_MERGE_SIZE                                                                           1		
	#define CDU_CDU_DEBUG_REG_PXP_INIT_LDCREDIT                                                                            (0x7<<2)
	#define CDU_CDU_DEBUG_REG_PXP_INIT_LDCREDIT_SIZE                                                                       2		
	#define CDU_CDU_DEBUG_REG_PXP_INIT_LDCREDIT_SET                                                                        (0x1<<5)
	#define CDU_CDU_DEBUG_REG_PXP_INIT_LDCREDIT_SET_SIZE                                                                   5		
	#define CDU_CDU_DEBUG_REG_PXP_INIT_WBCREDIT                                                                            (0x7<<6)
	#define CDU_CDU_DEBUG_REG_PXP_INIT_WBCREDIT_SIZE                                                                       6		
	#define CDU_CDU_DEBUG_REG_PXP_INIT_WBCREDIT_SET                                                                        (0x1<<9)
	#define CDU_CDU_DEBUG_REG_PXP_INIT_WBCREDIT_SET_SIZE                                                                   9
#define CDU_REG_LD_L1_NUM_ERROR_DATA                                                                                       0x101018UL //ACCESS:RC  DataWidth:0x14  Description: logging of error data in case of a CDU load error:{iqcc_l1_regions;iqcc_l1_type;iqcc_l1_lcid}
#define CDU_REG_WB_L1_NUM_ERROR_DATA                                                                                       0x10101cUL //ACCESS:RC  DataWidth:0x14  Description: logging of error data in case of a CDU load error:{iqcc_l1_regions;iqcc_l1_type;iqcc_l1_lcid}
#define CDU_REG_CDU_GLOBAL_PARAMS                                                                                          0x101020UL //ACCESS:RW  DataWidth:0x20  Multi Field Register		
	#define CDU_CDU_GLOBAL_PARAMS_REG_CONTEXT_SIZE                                                                         (0xfff<<0)
	#define CDU_CDU_GLOBAL_PARAMS_REG_CONTEXT_SIZE_SIZE                                                                    0		
	#define CDU_CDU_GLOBAL_PARAMS_REG_BLOCK_WASTE                                                                          (0xfff<<12)
	#define CDU_CDU_GLOBAL_PARAMS_REG_BLOCK_WASTE_SIZE                                                                     12		
	#define CDU_CDU_GLOBAL_PARAMS_REG_NCIB                                                                                 (0xff<<24)
	#define CDU_CDU_GLOBAL_PARAMS_REG_NCIB_SIZE                                                                            24
#define CDU_REG_DBG_SELECT                                                                                                 0x101024UL //ACCESS:RW  DataWidth:0x8  Description: For dbgmux usage (debug data that goes from CDU to the DBG block) - for selecting a line to output to the DBG block
#define CDU_REG_DBG_BYTE_ENABLE                                                                                            0x101028UL //ACCESS:RW  DataWidth:0x8  Description: For dbgmux usage (debug data that goes from CDU to the DBG block) - for enabling bytes in the selected line (after the select and before the shift)
#define CDU_REG_DBG_SHIFT                                                                                                  0x10102cUL //ACCESS:RW  DataWidth:0x3  Description: For dbgmux usage (debug data that goes from CDU to the DBG block) - for circular right shifting of the selected line (after the enabling)
#define CDU_REG_CDU_INT_STS                                                                                                0x101030UL //ACCESS:R  DataWidth:0x7  Description: Interrupt register #0 read		
	#define CDU_CDU_INT_STS_REG_ADDRESS_ERROR                                                                              (0x1<<0)
	#define CDU_CDU_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                         0		
	#define CDU_CDU_INT_STS_REG_EOP_ERROR                                                                                  (0x1<<1)
	#define CDU_CDU_INT_STS_REG_EOP_ERROR_SIZE                                                                             1		
	#define CDU_CDU_INT_STS_REG_LD_L1_NUM_ERROR                                                                            (0x1<<2)
	#define CDU_CDU_INT_STS_REG_LD_L1_NUM_ERROR_SIZE                                                                       2		
	#define CDU_CDU_INT_STS_REG_WB_L1_NUM_ERROR                                                                            (0x1<<3)
	#define CDU_CDU_INT_STS_REG_WB_L1_NUM_ERROR_SIZE                                                                       3		
	#define CDU_CDU_INT_STS_REG_BVALID_ERROR                                                                               (0x1<<4)
	#define CDU_CDU_INT_STS_REG_BVALID_ERROR_SIZE                                                                          4		
	#define CDU_CDU_INT_STS_REG_LDOFFSET_ERROR                                                                             (0x1<<5)
	#define CDU_CDU_INT_STS_REG_LDOFFSET_ERROR_SIZE                                                                        5		
	#define CDU_CDU_INT_STS_REG_WBOFFSET_ERROR                                                                             (0x1<<6)
	#define CDU_CDU_INT_STS_REG_WBOFFSET_ERROR_SIZE                                                                        6
#define CDU_REG_CDU_INT_STS_CLR                                                                                            0x101034UL //ACCESS:RC  DataWidth:0x7  Description: Interrupt register #0 read clear		
	#define CDU_CDU_INT_STS_CLR_REG_ADDRESS_ERROR                                                                          (0x1<<0)
	#define CDU_CDU_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                     0		
	#define CDU_CDU_INT_STS_CLR_REG_EOP_ERROR                                                                              (0x1<<1)
	#define CDU_CDU_INT_STS_CLR_REG_EOP_ERROR_SIZE                                                                         1		
	#define CDU_CDU_INT_STS_CLR_REG_LD_L1_NUM_ERROR                                                                        (0x1<<2)
	#define CDU_CDU_INT_STS_CLR_REG_LD_L1_NUM_ERROR_SIZE                                                                   2		
	#define CDU_CDU_INT_STS_CLR_REG_WB_L1_NUM_ERROR                                                                        (0x1<<3)
	#define CDU_CDU_INT_STS_CLR_REG_WB_L1_NUM_ERROR_SIZE                                                                   3		
	#define CDU_CDU_INT_STS_CLR_REG_BVALID_ERROR                                                                           (0x1<<4)
	#define CDU_CDU_INT_STS_CLR_REG_BVALID_ERROR_SIZE                                                                      4		
	#define CDU_CDU_INT_STS_CLR_REG_LDOFFSET_ERROR                                                                         (0x1<<5)
	#define CDU_CDU_INT_STS_CLR_REG_LDOFFSET_ERROR_SIZE                                                                    5		
	#define CDU_CDU_INT_STS_CLR_REG_WBOFFSET_ERROR                                                                         (0x1<<6)
	#define CDU_CDU_INT_STS_CLR_REG_WBOFFSET_ERROR_SIZE                                                                    6
#define CDU_REG_CDU_INT_STS_WR                                                                                             0x101038UL //ACCESS:WR  DataWidth:0x7  Description: Interrupt register #0 bit set or clear		
	#define CDU_CDU_INT_STS_WR_REG_ADDRESS_ERROR                                                                           (0x1<<0)
	#define CDU_CDU_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                      0		
	#define CDU_CDU_INT_STS_WR_REG_EOP_ERROR                                                                               (0x1<<1)
	#define CDU_CDU_INT_STS_WR_REG_EOP_ERROR_SIZE                                                                          1		
	#define CDU_CDU_INT_STS_WR_REG_LD_L1_NUM_ERROR                                                                         (0x1<<2)
	#define CDU_CDU_INT_STS_WR_REG_LD_L1_NUM_ERROR_SIZE                                                                    2		
	#define CDU_CDU_INT_STS_WR_REG_WB_L1_NUM_ERROR                                                                         (0x1<<3)
	#define CDU_CDU_INT_STS_WR_REG_WB_L1_NUM_ERROR_SIZE                                                                    3		
	#define CDU_CDU_INT_STS_WR_REG_BVALID_ERROR                                                                            (0x1<<4)
	#define CDU_CDU_INT_STS_WR_REG_BVALID_ERROR_SIZE                                                                       4		
	#define CDU_CDU_INT_STS_WR_REG_LDOFFSET_ERROR                                                                          (0x1<<5)
	#define CDU_CDU_INT_STS_WR_REG_LDOFFSET_ERROR_SIZE                                                                     5		
	#define CDU_CDU_INT_STS_WR_REG_WBOFFSET_ERROR                                                                          (0x1<<6)
	#define CDU_CDU_INT_STS_WR_REG_WBOFFSET_ERROR_SIZE                                                                     6
#define CDU_REG_CDU_INT_MASK                                                                                               0x10103cUL //ACCESS:RW  DataWidth:0x7  Description: Interrupt mask register #0 read/write		
	#define CDU_CDU_INT_MASK_REG_ADDRESS_ERROR                                                                             (0x1<<0)
	#define CDU_CDU_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                        0		
	#define CDU_CDU_INT_MASK_REG_EOP_ERROR                                                                                 (0x1<<1)
	#define CDU_CDU_INT_MASK_REG_EOP_ERROR_SIZE                                                                            1		
	#define CDU_CDU_INT_MASK_REG_LD_L1_NUM_ERROR                                                                           (0x1<<2)
	#define CDU_CDU_INT_MASK_REG_LD_L1_NUM_ERROR_SIZE                                                                      2		
	#define CDU_CDU_INT_MASK_REG_WB_L1_NUM_ERROR                                                                           (0x1<<3)
	#define CDU_CDU_INT_MASK_REG_WB_L1_NUM_ERROR_SIZE                                                                      3		
	#define CDU_CDU_INT_MASK_REG_BVALID_ERROR                                                                              (0x1<<4)
	#define CDU_CDU_INT_MASK_REG_BVALID_ERROR_SIZE                                                                         4		
	#define CDU_CDU_INT_MASK_REG_LDOFFSET_ERROR                                                                            (0x1<<5)
	#define CDU_CDU_INT_MASK_REG_LDOFFSET_ERROR_SIZE                                                                       5		
	#define CDU_CDU_INT_MASK_REG_WBOFFSET_ERROR                                                                            (0x1<<6)
	#define CDU_CDU_INT_MASK_REG_WBOFFSET_ERROR_SIZE                                                                       6
#define CDU_REG_CDU_PRTY_STS                                                                                               0x101040UL //ACCESS:R  DataWidth:0x5  Description: Parity register #0 read		
	#define CDU_CDU_PRTY_STS_REG_PARITY                                                                                    (0x1<<0)
	#define CDU_CDU_PRTY_STS_REG_PARITY_SIZE                                                                               0		
	#define CDU_CDU_PRTY_STS_REG_CDUWBBUF_PAR_ERR                                                                          (0x1<<1)
	#define CDU_CDU_PRTY_STS_REG_CDUWBBUF_PAR_ERR_SIZE                                                                     1		
	#define CDU_CDU_PRTY_STS_REG_CDULDBUF_PAR_ERR                                                                          (0x1<<2)
	#define CDU_CDU_PRTY_STS_REG_CDULDBUF_PAR_ERR_SIZE                                                                     2		
	#define CDU_CDU_PRTY_STS_REG_MATT_PAR_ERR                                                                              (0x1<<3)
	#define CDU_CDU_PRTY_STS_REG_MATT_PAR_ERR_SIZE                                                                         3		
	#define CDU_CDU_PRTY_STS_REG_L1TT_PAR_ERR                                                                              (0x1<<4)
	#define CDU_CDU_PRTY_STS_REG_L1TT_PAR_ERR_SIZE                                                                         4
#define CDU_REG_CDU_PRTY_STS_CLR                                                                                           0x101044UL //ACCESS:RC  DataWidth:0x5  Description: Parity register #0 read clear		
	#define CDU_CDU_PRTY_STS_CLR_REG_PARITY                                                                                (0x1<<0)
	#define CDU_CDU_PRTY_STS_CLR_REG_PARITY_SIZE                                                                           0		
	#define CDU_CDU_PRTY_STS_CLR_REG_CDUWBBUF_PAR_ERR                                                                      (0x1<<1)
	#define CDU_CDU_PRTY_STS_CLR_REG_CDUWBBUF_PAR_ERR_SIZE                                                                 1		
	#define CDU_CDU_PRTY_STS_CLR_REG_CDULDBUF_PAR_ERR                                                                      (0x1<<2)
	#define CDU_CDU_PRTY_STS_CLR_REG_CDULDBUF_PAR_ERR_SIZE                                                                 2		
	#define CDU_CDU_PRTY_STS_CLR_REG_MATT_PAR_ERR                                                                          (0x1<<3)
	#define CDU_CDU_PRTY_STS_CLR_REG_MATT_PAR_ERR_SIZE                                                                     3		
	#define CDU_CDU_PRTY_STS_CLR_REG_L1TT_PAR_ERR                                                                          (0x1<<4)
	#define CDU_CDU_PRTY_STS_CLR_REG_L1TT_PAR_ERR_SIZE                                                                     4
#define CDU_REG_CDU_PRTY_STS_WR                                                                                            0x101048UL //ACCESS:WR  DataWidth:0x5  Description: Parity register #0 bit set or clear		
	#define CDU_CDU_PRTY_STS_WR_REG_PARITY                                                                                 (0x1<<0)
	#define CDU_CDU_PRTY_STS_WR_REG_PARITY_SIZE                                                                            0		
	#define CDU_CDU_PRTY_STS_WR_REG_CDUWBBUF_PAR_ERR                                                                       (0x1<<1)
	#define CDU_CDU_PRTY_STS_WR_REG_CDUWBBUF_PAR_ERR_SIZE                                                                  1		
	#define CDU_CDU_PRTY_STS_WR_REG_CDULDBUF_PAR_ERR                                                                       (0x1<<2)
	#define CDU_CDU_PRTY_STS_WR_REG_CDULDBUF_PAR_ERR_SIZE                                                                  2		
	#define CDU_CDU_PRTY_STS_WR_REG_MATT_PAR_ERR                                                                           (0x1<<3)
	#define CDU_CDU_PRTY_STS_WR_REG_MATT_PAR_ERR_SIZE                                                                      3		
	#define CDU_CDU_PRTY_STS_WR_REG_L1TT_PAR_ERR                                                                           (0x1<<4)
	#define CDU_CDU_PRTY_STS_WR_REG_L1TT_PAR_ERR_SIZE                                                                      4
#define CDU_REG_CDU_PRTY_MASK                                                                                              0x10104cUL //ACCESS:RW  DataWidth:0x5  Description: Parity mask register #0 read/write		
	#define CDU_CDU_PRTY_MASK_REG_PARITY                                                                                   (0x1<<0)
	#define CDU_CDU_PRTY_MASK_REG_PARITY_SIZE                                                                              0		
	#define CDU_CDU_PRTY_MASK_REG_CDUWBBUF_PAR_ERR                                                                         (0x1<<1)
	#define CDU_CDU_PRTY_MASK_REG_CDUWBBUF_PAR_ERR_SIZE                                                                    1		
	#define CDU_CDU_PRTY_MASK_REG_CDULDBUF_PAR_ERR                                                                         (0x1<<2)
	#define CDU_CDU_PRTY_MASK_REG_CDULDBUF_PAR_ERR_SIZE                                                                    2		
	#define CDU_CDU_PRTY_MASK_REG_MATT_PAR_ERR                                                                             (0x1<<3)
	#define CDU_CDU_PRTY_MASK_REG_MATT_PAR_ERR_SIZE                                                                        3		
	#define CDU_CDU_PRTY_MASK_REG_L1TT_PAR_ERR                                                                             (0x1<<4)
	#define CDU_CDU_PRTY_MASK_REG_L1TT_PAR_ERR_SIZE                                                                        4
#define CDU_REG_MF_MODE                                                                                                    0x101050UL //ACCESS:RW  DataWidth:0x1  Description: when this bit is set the CDU operates in multifunction mode
#define CDU_REG_MEM_TM_PORTS                                                                                               0x101054UL //ACCESS:RW  DataWidth:0xa  Description: TM Bits of memories: matt bits 1:0; l1tt_low0 bits 3:2; l1tt_low1 bits 5:4; l1tt_high0 bits 7:6; l1tt_high1 bits 9:8
#define CDU_REG_ECO_RESERVED                                                                                               0x101058UL //ACCESS:RW  DataWidth:0x8  Description: eco reserved register
#define CDU_REG_CDU_ATC_FLAGS                                                                                              0x10105cUL //ACCESS:RW  DataWidth:0x6  Multi Field Register		
	#define CDU_CDU_ATC_FLAGS_REG_ATC_FLAGS_WB                                                                             (0x7<<0)
	#define CDU_CDU_ATC_FLAGS_REG_ATC_FLAGS_WB_SIZE                                                                        0		
	#define CDU_CDU_ATC_FLAGS_REG_ATC_FLAGS_LD                                                                             (0x7<<3)
	#define CDU_CDU_ATC_FLAGS_REG_ATC_FLAGS_LD_SIZE                                                                        3
#define CDU_REG_ERROR_DATA                                                                                                 0x101014UL //ACCESS:RW  DataWidth:0x20  Description: logging of error data in case of a CDU load error: {expected_cid[15:0];expected_type[2:0];expected_region[2:0];active_error;type_error;actual_active;actual_compressed_context}; 
#define CDU_REG_ERROR_DATA_SIZE                                                                                            1
#define CDU_REG_MATT                                                                                                       0x101100UL //ACCESS:WB  DataWidth:0x18  Description: MATT ram access. each entry has the following format:{RegionLength[11:0];RegionOffset[11:0]}
#define CDU_REG_MATT_SIZE                                                                                                  64
#define CDU_REG_L1TT                                                                                                       0x101800UL //ACCESS:WB  DataWidth:0xd8  Description: L1TT ram access. each entry has the following format : {mrege_regions[7:0];offset12[5:0]...offset0[5:0];length12[5:0]...length0[5:0];id12[3:0]...id0[3:0]}
#define CDU_REG_L1TT_SIZE                                                                                                  512
#define CDU_REG_CDU_UNUSED_EMPTY_0                                                                                         0x101060UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CDU_REG_CDU_UNUSED_EMPTY_0_SIZE                                                                                    40
#define CDU_REG_CDU_UNUSED_EMPTY_1                                                                                         0x101200UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CDU_REG_CDU_UNUSED_EMPTY_1_SIZE                                                                                    384
#define CFC_REG_NUM_LCIDS_EMPTY                                                                                            0x104000UL //ACCESS:R  DataWidth:0x9  Description: Number of Empty LCIDs in Link List Block (not allocated)
#define CFC_REG_NUM_LCIDS_ARRIVING                                                                                         0x104004UL //ACCESS:R  DataWidth:0x9  Description: Number of Arriving LCIDs in Link List Block
#define CFC_REG_NUM_LCIDS_INSIDE                                                                                           0x104008UL //ACCESS:R  DataWidth:0x9  Description: Number of Inside LCIDs in Link List Block
#define CFC_REG_NUM_LCIDS_INA                                                                                              0x10400cUL //ACCESS:R  DataWidth:0x9  Description: Number of Inside not active LCIDs in Link List Block
#define CFC_REG_NUM_LCIDS_INAS                                                                                             0x104010UL //ACCESS:R  DataWidth:0x9  Description: Number of Inside not active latency sensitive LCIDs in Link List Block
#define CFC_REG_NUM_LCIDS_INANS                                                                                            0x104014UL //ACCESS:R  DataWidth:0x9  Description: Number of Inside not active not sensitive LCIDs in Link List Block
#define CFC_REG_NUM_LCIDS_LEAVING                                                                                          0x104018UL //ACCESS:R  DataWidth:0x9  Description: Number of Leaving LCIDs in Link List Block
#define CFC_REG_NUM_LCIDS_IO                                                                                               0x10401cUL //ACCESS:R  DataWidth:0x9  Description: Number of Inside and Outside LCIDs in Link List Block
#define CFC_REG_NUM_LCIDS_ALLOC                                                                                            0x104020UL //ACCESS:R  DataWidth:0x9  Description: Number of allocated LCIDs which are at empty state
#define CFC_REG_LC_BLOCKED                                                                                                 0x104024UL //ACCESS:ST  DataWidth:0x20  Description: statistics register that counts cycles in which load context requests were blocked
#define CFC_REG_CONTROL0                                                                                                   0x104028UL //ACCESS:RW  DataWidth:0xf  Multi Field Register		
	#define CFC_CONTROL0_REG_WB_THRESHOLD                                                                                  (0xff<<0)
	#define CFC_CONTROL0_REG_WB_THRESHOLD_SIZE                                                                             0		
	#define CFC_CONTROL0_REG_STRING_CAM_DISABLE                                                                            (0x1<<8)
	#define CFC_CONTROL0_REG_STRING_CAM_DISABLE_SIZE                                                                       8		
	#define CFC_CONTROL0_REG_CID_CAM_DISABLE                                                                               (0x1<<9)
	#define CFC_CONTROL0_REG_CID_CAM_DISABLE_SIZE                                                                          9		
	#define CFC_CONTROL0_REG_NLOE                                                                                          (0x1<<10)
	#define CFC_CONTROL0_REG_NLOE_SIZE                                                                                     10		
	#define CFC_CONTROL0_REG_SCAM_SCRUB_HIT_EN                                                                             (0x1<<11)
	#define CFC_CONTROL0_REG_SCAM_SCRUB_HIT_EN_SIZE                                                                        11		
	#define CFC_CONTROL0_REG_SCAM_SCRUB_MISS_EN                                                                            (0x1<<12)
	#define CFC_CONTROL0_REG_SCAM_SCRUB_MISS_EN_SIZE                                                                       12		
	#define CFC_CONTROL0_REG_CCAM_SCRUB_HIT_EN                                                                             (0x1<<13)
	#define CFC_CONTROL0_REG_CCAM_SCRUB_HIT_EN_SIZE                                                                        13		
	#define CFC_CONTROL0_REG_CCAM_SCRUB_MISS_EN                                                                            (0x1<<14)
	#define CFC_CONTROL0_REG_CCAM_SCRUB_MISS_EN_SIZE                                                                       14
#define CFC_REG_MASK_REQUESTS                                                                                              0x10402cUL //ACCESS:RW  DataWidth:0x7  Multi Field Register		
	#define CFC_MASK_REQUESTS_REG_MASK_LCREQ                                                                               (0x1<<0)
	#define CFC_MASK_REQUESTS_REG_MASK_LCREQ_SIZE                                                                          0		
	#define CFC_MASK_REQUESTS_REG_MASK_SEARCH                                                                              (0x1<<1)
	#define CFC_MASK_REQUESTS_REG_MASK_SEARCH_SIZE                                                                         1		
	#define CFC_MASK_REQUESTS_REG_MASK_UPDATE                                                                              (0x1<<2)
	#define CFC_MASK_REQUESTS_REG_MASK_UPDATE_SIZE                                                                         2		
	#define CFC_MASK_REQUESTS_REG_MASK_WB                                                                                  (0x1<<3)
	#define CFC_MASK_REQUESTS_REG_MASK_WB_SIZE                                                                             3		
	#define CFC_MASK_REQUESTS_REG_MASK_INACTIVATE                                                                          (0x1<<4)
	#define CFC_MASK_REQUESTS_REG_MASK_INACTIVATE_SIZE                                                                     4		
	#define CFC_MASK_REQUESTS_REG_MASK_CDULDRESP                                                                           (0x1<<5)
	#define CFC_MASK_REQUESTS_REG_MASK_CDULDRESP_SIZE                                                                      5		
	#define CFC_MASK_REQUESTS_REG_MASK_CDUWBRESP                                                                           (0x1<<6)
	#define CFC_MASK_REQUESTS_REG_MASK_CDUWBRESP_SIZE                                                                      6
#define CFC_REG_ERROR_DATA1                                                                                                0x104030UL //ACCESS:R  DataWidth:0x19  Description: when the CFC detects an internal error it updates these fields. {error_id[4:0];req_incval[3:0];ac_error_client[3:0];ac_error_lcid;error_id[3:0]}
#define CFC_REG_ERROR_DATA2                                                                                                0x104034UL //ACCESS:R  DataWidth:0x20  Description: {req_cid;req_taskid[7:4];req_type}
#define CFC_REG_ERROR_DATA3                                                                                                0x104038UL //ACCESS:R  DataWidth:0x20  Description: when the CFC detects an internal error it updates these fields. {req_regions;req_lcid;curr_lcid;ac_lcid}
#define CFC_REG_ERROR_VECTOR                                                                                               0x10403cUL //ACCESS:R  DataWidth:0x10  Description: CFC error vector. when the CFC detects an internal error it will set one of these bits. the bit description can be found in CFC specifications
#define CFC_REG_ERROR_MASK                                                                                                 0x104040UL //ACCESS:RW  DataWidth:0x10  Description: masking for error logging. if a bit in this field is set then the corresponding bit in #cfc_registers_cfc_error_vector.error_vector will not be set
#define CFC_REG_DISABLE_ON_ERROR                                                                                           0x104044UL //ACCESS:RW  DataWidth:0x10  Description: indicates per error (in #cfc_registers_cfc_error_vector.cfc_error vector) whether the cfc should be disabled upon it
#define CFC_REG_ARBITERS_REG                                                                                               0x104048UL //ACCESS:RW  DataWidth:0x6  Multi Field Register		
	#define CFC_ARBITERS_REG_REG_SP_MARB_RR1                                                                               (0x1<<0)
	#define CFC_ARBITERS_REG_REG_SP_MARB_RR1_SIZE                                                                          0		
	#define CFC_ARBITERS_REG_REG_SP_LCARB                                                                                  (0x1<<1)
	#define CFC_ARBITERS_REG_REG_SP_LCARB_SIZE                                                                             1		
	#define CFC_ARBITERS_REG_REG_SP_MARB_RR2                                                                               (0x1<<2)
	#define CFC_ARBITERS_REG_REG_SP_MARB_RR2_SIZE                                                                          2		
	#define CFC_ARBITERS_REG_REG_SP_MARB_RR3                                                                               (0x1<<3)
	#define CFC_ARBITERS_REG_REG_SP_MARB_RR3_SIZE                                                                          3		
	#define CFC_ARBITERS_REG_REG_SP_AC_DEC                                                                                 (0x1<<4)
	#define CFC_ARBITERS_REG_REG_SP_AC_DEC_SIZE                                                                            4		
	#define CFC_ARBITERS_REG_REG_SP_AC_INC                                                                                 (0x1<<5)
	#define CFC_ARBITERS_REG_REG_SP_AC_INC_SIZE                                                                            5
#define CFC_REG_INIT_REG                                                                                                   0x10404cUL //ACCESS:RW  DataWidth:0xb  Multi Field Register		
	#define CFC_INIT_REG_REG_AC_INIT                                                                                       (0x1<<0)
	#define CFC_INIT_REG_REG_AC_INIT_SIZE                                                                                  0		
	#define CFC_INIT_REG_REG_LL_INIT_LAST_LCID                                                                             (0xff<<1)
	#define CFC_INIT_REG_REG_LL_INIT_LAST_LCID_SIZE                                                                        1		
	#define CFC_INIT_REG_REG_LL_INIT                                                                                       (0x1<<9)
	#define CFC_INIT_REG_REG_LL_INIT_SIZE                                                                                  9		
	#define CFC_INIT_REG_REG_CAM_INIT                                                                                      (0x1<<10)
	#define CFC_INIT_REG_REG_CAM_INIT_SIZE                                                                                 10
#define CFC_REG_DEBUG0                                                                                                     0x104050UL //ACCESS:RW  DataWidth:0x1e  Multi Field Register		
	#define CFC_DEBUG0_REG_DISABLE_INPUTS                                                                                  (0x1<<0)
	#define CFC_DEBUG0_REG_DISABLE_INPUTS_SIZE                                                                             0		
	#define CFC_DEBUG0_REG_DISABLE_OUTPUTS                                                                                 (0x1<<1)
	#define CFC_DEBUG0_REG_DISABLE_OUTPUTS_SIZE                                                                            1		
	#define CFC_DEBUG0_REG_AC_COUNTER_ZERO                                                                                 (0xff<<2)
	#define CFC_DEBUG0_REG_AC_COUNTER_ZERO_SIZE                                                                            2		
	#define CFC_DEBUG0_REG_DELAY_CAM_RESP                                                                                  (0x1<<10)
	#define CFC_DEBUG0_REG_DELAY_CAM_RESP_SIZE                                                                             10		
	#define CFC_DEBUG0_REG_AC_GRANT_PERIOD                                                                                 (0xf<<11)
	#define CFC_DEBUG0_REG_AC_GRANT_PERIOD_SIZE                                                                            11		
	#define CFC_DEBUG0_REG_E_THRESHOLD                                                                                     (0x7<<15)
	#define CFC_DEBUG0_REG_E_THRESHOLD_SIZE                                                                                15		
	#define CFC_DEBUG0_REG_INA_THRESHOLD                                                                                   (0x7<<18)
	#define CFC_DEBUG0_REG_INA_THRESHOLD_SIZE                                                                              18		
	#define CFC_DEBUG0_REG_INANS_THRESHOLD                                                                                 (0x7<<21)
	#define CFC_DEBUG0_REG_INANS_THRESHOLD_SIZE                                                                            21		
	#define CFC_DEBUG0_REG_INAS_THRESHOLD                                                                                  (0x7<<24)
	#define CFC_DEBUG0_REG_INAS_THRESHOLD_SIZE                                                                             24		
	#define CFC_DEBUG0_REG_IO_THRESHOLD                                                                                    (0x7<<27)
	#define CFC_DEBUG0_REG_IO_THRESHOLD_SIZE                                                                               27
#define CFC_REG_DEBUG1                                                                                                     0x104054UL //ACCESS:RW  DataWidth:0xd  Multi Field Register		
	#define CFC_DEBUG1_REG_MARB_THRESHOLD                                                                                  (0xf<<0)
	#define CFC_DEBUG1_REG_MARB_THRESHOLD_SIZE                                                                             0		
	#define CFC_DEBUG1_REG_WRITE_AC                                                                                        (0x1<<4)
	#define CFC_DEBUG1_REG_WRITE_AC_SIZE                                                                                   4		
	#define CFC_DEBUG1_REG_MY_VAL_AC                                                                                       (0x1<<5)
	#define CFC_DEBUG1_REG_MY_VAL_AC_SIZE                                                                                  5		
	#define CFC_DEBUG1_REG_WVAL_AC                                                                                         (0x3<<6)
	#define CFC_DEBUG1_REG_WVAL_AC_SIZE                                                                                    6		
	#define CFC_DEBUG1_REG_TYPE_FROM_REQ1                                                                                  (0x1<<8)
	#define CFC_DEBUG1_REG_TYPE_FROM_REQ1_SIZE                                                                             8		
	#define CFC_DEBUG1_REG_TYPE_FROM_REQ2                                                                                  (0x1<<9)
	#define CFC_DEBUG1_REG_TYPE_FROM_REQ2_SIZE                                                                             9		
	#define CFC_DEBUG1_REG_SW_RESET                                                                                        (0x1<<10)
	#define CFC_DEBUG1_REG_SW_RESET_SIZE                                                                                   10		
	#define CFC_DEBUG1_REG_EN_ON_INT_CLR                                                                                   (0x1<<11)
	#define CFC_DEBUG1_REG_EN_ON_INT_CLR_SIZE                                                                              11		
	#define CFC_DEBUG1_REG_UPD_CANCEL_DIS                                                                                  (0x1<<12)
	#define CFC_DEBUG1_REG_UPD_CANCEL_DIS_SIZE                                                                             12
#define CFC_REG_INTERFACES                                                                                                 0x104058UL //ACCESS:RW  DataWidth:0x1a  Multi Field Register		
	#define CFC_INTERFACES_REG_LRESP_CREDIT                                                                                (0x7<<0)
	#define CFC_INTERFACES_REG_LRESP_CREDIT_SIZE                                                                           0		
	#define CFC_INTERFACES_REG_LRESP_CREDIT_SET                                                                            (0x1<<3)
	#define CFC_INTERFACES_REG_LRESP_CREDIT_SET_SIZE                                                                       3		
	#define CFC_INTERFACES_REG_PRSRESP_CREDIT                                                                              (0x7<<4)
	#define CFC_INTERFACES_REG_PRSRESP_CREDIT_SIZE                                                                         4		
	#define CFC_INTERFACES_REG_PRSRESP_CREDIT_SET                                                                          (0x1<<7)
	#define CFC_INTERFACES_REG_PRSRESP_CREDIT_SET_SIZE                                                                     7		
	#define CFC_INTERFACES_REG_SEARCH_CREDIT                                                                               (0x7<<8)
	#define CFC_INTERFACES_REG_SEARCH_CREDIT_SIZE                                                                          8		
	#define CFC_INTERFACES_REG_SEARCH_CREDIT_SET                                                                           (0x1<<11)
	#define CFC_INTERFACES_REG_SEARCH_CREDIT_SET_SIZE                                                                      11		
	#define CFC_INTERFACES_REG_CDULD_CREDIT                                                                                (0xf<<12)
	#define CFC_INTERFACES_REG_CDULD_CREDIT_SIZE                                                                           12		
	#define CFC_INTERFACES_REG_CDULD_CREDIT_SET                                                                            (0x1<<16)
	#define CFC_INTERFACES_REG_CDULD_CREDIT_SET_SIZE                                                                       16		
	#define CFC_INTERFACES_REG_CDUWB_CREDIT                                                                                (0xf<<17)
	#define CFC_INTERFACES_REG_CDUWB_CREDIT_SIZE                                                                           17		
	#define CFC_INTERFACES_REG_CDUWB_CREDIT_SET                                                                            (0x1<<21)
	#define CFC_INTERFACES_REG_CDUWB_CREDIT_SET_SIZE                                                                       21		
	#define CFC_INTERFACES_REG_LRESP6_CREDIT                                                                               (0x7<<22)
	#define CFC_INTERFACES_REG_LRESP6_CREDIT_SIZE                                                                          22		
	#define CFC_INTERFACES_REG_LRESP6_CREDIT_SET                                                                           (0x1<<25)
	#define CFC_INTERFACES_REG_LRESP6_CREDIT_SET_SIZE                                                                      25
#define CFC_REG_CID_CAM_CONTROL                                                                                            0x10405cUL //ACCESS:RW  DataWidth:0x16  Multi Field Register		
	#define CFC_CID_CAM_CONTROL_REG_CCAM_MASK_VECTOR                                                                       (0xfffff<<0)
	#define CFC_CID_CAM_CONTROL_REG_CCAM_MASK_VECTOR_SIZE                                                                  0		
	#define CFC_CID_CAM_CONTROL_REG_CCAM_SEARCH                                                                            (0x1<<20)
	#define CFC_CID_CAM_CONTROL_REG_CCAM_SEARCH_SIZE                                                                       20		
	#define CFC_CID_CAM_CONTROL_REG_CAM_125MHZ                                                                             (0x1<<21)
	#define CFC_CID_CAM_CONTROL_REG_CAM_125MHZ_SIZE                                                                        21
#define CFC_REG_SCAM_MASK_VECTOR0                                                                                          0x104060UL //ACCESS:RW  DataWidth:0x20  Description: string cam mask[31:0]. this mask is used for searches. 0 means ignore corresponding bit in search. 
#define CFC_REG_SCAM_MASK_VECTOR1                                                                                          0x104064UL //ACCESS:RW  DataWidth:0x20  Description: string cam mask[63:32]. this mask is used for searches. 0 means ignore corresponding bit in search. 
#define CFC_REG_SCAM_MASK_VECTOR2                                                                                          0x104068UL //ACCESS:RW  DataWidth:0x20  Description: string cam mask[95:64]. this mask is used for searches. 0 means ignore corresponding bit in search. 
#define CFC_REG_SCAM_SEARCH                                                                                                0x10406cUL //ACCESS:RW  DataWidth:0x1  Description: when this bit is set writing to the scam will cause a search operation on the written item (written using ~cfc_registers_lcid_string_cam.string_cam interface. the write can be to any address
#define CFC_REG_SEARCH_RESULT                                                                                              0x104070UL //ACCESS:R  DataWidth:0x9  Description: {HIT;LCID}. HIT - if set then previous CAM seach item (either CCAM or SCAM) was found. LCID contains the result in case CAM search item (either CCAM or SCAM) was found
#define CFC_REG_LL_INIT_DONE                                                                                               0x104074UL //ACCESS:R  DataWidth:0x1  Description: indication the initializing the link list by the hardware was done.
#define CFC_REG_AC_INIT_DONE                                                                                               0x104078UL //ACCESS:R  DataWidth:0x1  Description: indication the initializing the activity counter by the hardware was done.
#define CFC_REG_CAM_INIT_DONE                                                                                              0x10407cUL //ACCESS:R  DataWidth:0x1  Description: indication the initializing the cams by the hardware was done.
#define CFC_REG_TASK_COUNTER                                                                                               0x104080UL //ACCESS:ST  DataWidth:0x20  Description: counts number of tasks done by the cfc
#define CFC_REG_LCREQ_WEIGHTS                                                                                              0x104084UL //ACCESS:RW  DataWidth:0x18  Description: {weight_load_client7[2:0] to weight_load_client0[2:0]}. this field allows changing the priorities of the weighted-round-robin arbiter which selects which CFC load client should be served next
#define CFC_REG_LOAD_CONTEXT_HITS_0                                                                                        0x104088UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context hits
#define CFC_REG_LOAD_CONTEXT_HITS_1                                                                                        0x10408cUL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context hits
#define CFC_REG_LOAD_CONTEXT_HITS_2                                                                                        0x104090UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context hits
#define CFC_REG_LOAD_CONTEXT_HITS_3                                                                                        0x104094UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context hits
#define CFC_REG_LOAD_CONTEXT_HITS_4                                                                                        0x104098UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context hits
#define CFC_REG_LOAD_CONTEXT_HITS_5                                                                                        0x10409cUL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context hits
#define CFC_REG_LOAD_CONTEXT_HITS_6                                                                                        0x1040a0UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context hits
#define CFC_REG_LOAD_CONTEXT_HITS_7                                                                                        0x1040a4UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context hits
#define CFC_REG_LOAD_CONTEXT_MISSES_0                                                                                      0x1040a8UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context misses
#define CFC_REG_LOAD_CONTEXT_MISSES_1                                                                                      0x1040acUL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context misses
#define CFC_REG_LOAD_CONTEXT_MISSES_2                                                                                      0x1040b0UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context misses
#define CFC_REG_LOAD_CONTEXT_MISSES_3                                                                                      0x1040b4UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context misses
#define CFC_REG_LOAD_CONTEXT_MISSES_4                                                                                      0x1040b8UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context misses
#define CFC_REG_LOAD_CONTEXT_MISSES_5                                                                                      0x1040bcUL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context misses
#define CFC_REG_LOAD_CONTEXT_MISSES_6                                                                                      0x1040c0UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context misses
#define CFC_REG_LOAD_CONTEXT_MISSES_7                                                                                      0x1040c4UL //ACCESS:ST  DataWidth:0x20  Description: counts for each client the number of load context misses
#define CFC_REG_RFE_SEARCH_HITS                                                                                            0x1040c8UL //ACCESS:ST  DataWidth:0x20  Description: counts the number of RFE serach hits
#define CFC_REG_RFE_SEARCH_MISSES                                                                                          0x1040ccUL //ACCESS:ST  DataWidth:0x20  Description: counts the number of RFE serach misses
#define CFC_REG_CDU_WRITE_BACKS                                                                                            0x1040d0UL //ACCESS:ST  DataWidth:0x20  Description: counts the number of CDU write backs submitted by CFC
#define CFC_REG_CID_CAM_TM                                                                                                 0x1040d4UL //ACCESS:RW  DataWidth:0xe  Description: TM bits of  cid cam memory
#define CFC_REG_STRING_CAM_TM                                                                                              0x1040d8UL //ACCESS:RW  DataWidth:0xe  Description: TM bits of string cam memory
#define CFC_REG_LRAM_TM                                                                                                    0x1040dcUL //ACCESS:RW  DataWidth:0x5  Description: TM bits of LCID ram memory
#define CFC_REG_LL1_TM                                                                                                     0x1040e0UL //ACCESS:RW  DataWidth:0x5  Description: TM bits of LinkList1 memory
#define CFC_REG_LL2_TM                                                                                                     0x1040e4UL //ACCESS:RW  DataWidth:0x5  Description: TM bits of LinkList2 memory
#define CFC_REG_DBG_SELECT                                                                                                 0x1040e8UL //ACCESS:RW  DataWidth:0x8  Description: For dbgmux usage (debug data that goes from CFC to the DBG block) - for selecting a line to output to the DBG block
#define CFC_REG_DBG_BYTE_ENABLE                                                                                            0x1040ecUL //ACCESS:RW  DataWidth:0x8  Description: For dbgmux usage (debug data that goes from CFC to the DBG block) - for enabling bytes in the selected line (after the select and before the shift)
#define CFC_REG_DBG_SHIFT                                                                                                  0x1040f0UL //ACCESS:RW  DataWidth:0x3  Description: For dbgmux usage (debug data that goes from CFC to the DBG block) - for circular right shifting of the selected line (after the enabling)
#define CFC_REG_CCAM_BIST_EN                                                                                               0x1040f4UL //ACCESS:RW  DataWidth:0x1  Description: CID CAM BIST
#define CFC_REG_SCAM_BIST_EN                                                                                               0x1040f8UL //ACCESS:RW  DataWidth:0x1  Description: STRING CAM BIST
#define CFC_REG_CFC_INT_STS                                                                                                0x1040fcUL //ACCESS:R  DataWidth:0x2  Description: Interrupt register #0 read		
	#define CFC_CFC_INT_STS_REG_ADDRESS_ERROR                                                                              (0x1<<0)
	#define CFC_CFC_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                         0		
	#define CFC_CFC_INT_STS_REG_EXE_ERROR                                                                                  (0x1<<1)
	#define CFC_CFC_INT_STS_REG_EXE_ERROR_SIZE                                                                             1
#define CFC_REG_CFC_INT_STS_CLR                                                                                            0x104100UL //ACCESS:RC  DataWidth:0x2  Description: Interrupt register #0 read clear		
	#define CFC_CFC_INT_STS_CLR_REG_ADDRESS_ERROR                                                                          (0x1<<0)
	#define CFC_CFC_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                     0		
	#define CFC_CFC_INT_STS_CLR_REG_EXE_ERROR                                                                              (0x1<<1)
	#define CFC_CFC_INT_STS_CLR_REG_EXE_ERROR_SIZE                                                                         1
#define CFC_REG_CFC_INT_STS_WR                                                                                             0x104104UL //ACCESS:WR  DataWidth:0x2  Description: Interrupt register #0 bit set or clear		
	#define CFC_CFC_INT_STS_WR_REG_ADDRESS_ERROR                                                                           (0x1<<0)
	#define CFC_CFC_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                      0		
	#define CFC_CFC_INT_STS_WR_REG_EXE_ERROR                                                                               (0x1<<1)
	#define CFC_CFC_INT_STS_WR_REG_EXE_ERROR_SIZE                                                                          1
#define CFC_REG_CFC_INT_MASK                                                                                               0x104108UL //ACCESS:RW  DataWidth:0x2  Description: Interrupt mask register #0 read/write		
	#define CFC_CFC_INT_MASK_REG_ADDRESS_ERROR                                                                             (0x1<<0)
	#define CFC_CFC_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                        0		
	#define CFC_CFC_INT_MASK_REG_EXE_ERROR                                                                                 (0x1<<1)
	#define CFC_CFC_INT_MASK_REG_EXE_ERROR_SIZE                                                                            1
#define CFC_REG_CFC_PRTY_STS                                                                                               0x10410cUL //ACCESS:R  DataWidth:0x6  Description: Parity register #0 read		
	#define CFC_CFC_PRTY_STS_REG_PARITY                                                                                    (0x1<<0)
	#define CFC_CFC_PRTY_STS_REG_PARITY_SIZE                                                                               0		
	#define CFC_CFC_PRTY_STS_REG_LL_PAR_ERR                                                                                (0x1<<1)
	#define CFC_CFC_PRTY_STS_REG_LL_PAR_ERR_SIZE                                                                           1		
	#define CFC_CFC_PRTY_STS_REG_INFORAM_PAR_ERR                                                                           (0x1<<2)
	#define CFC_CFC_PRTY_STS_REG_INFORAM_PAR_ERR_SIZE                                                                      2		
	#define CFC_CFC_PRTY_STS_REG_AC_PAR_ERR                                                                                (0x1<<3)
	#define CFC_CFC_PRTY_STS_REG_AC_PAR_ERR_SIZE                                                                           3		
	#define CFC_CFC_PRTY_STS_REG_CCAM_PAR_ERR                                                                              (0x1<<4)
	#define CFC_CFC_PRTY_STS_REG_CCAM_PAR_ERR_SIZE                                                                         4		
	#define CFC_CFC_PRTY_STS_REG_SCAM_PAR_ERR                                                                              (0x1<<5)
	#define CFC_CFC_PRTY_STS_REG_SCAM_PAR_ERR_SIZE                                                                         5
#define CFC_REG_CFC_PRTY_STS_CLR                                                                                           0x104110UL //ACCESS:RC  DataWidth:0x6  Description: Parity register #0 read clear		
	#define CFC_CFC_PRTY_STS_CLR_REG_PARITY                                                                                (0x1<<0)
	#define CFC_CFC_PRTY_STS_CLR_REG_PARITY_SIZE                                                                           0		
	#define CFC_CFC_PRTY_STS_CLR_REG_LL_PAR_ERR                                                                            (0x1<<1)
	#define CFC_CFC_PRTY_STS_CLR_REG_LL_PAR_ERR_SIZE                                                                       1		
	#define CFC_CFC_PRTY_STS_CLR_REG_INFORAM_PAR_ERR                                                                       (0x1<<2)
	#define CFC_CFC_PRTY_STS_CLR_REG_INFORAM_PAR_ERR_SIZE                                                                  2		
	#define CFC_CFC_PRTY_STS_CLR_REG_AC_PAR_ERR                                                                            (0x1<<3)
	#define CFC_CFC_PRTY_STS_CLR_REG_AC_PAR_ERR_SIZE                                                                       3		
	#define CFC_CFC_PRTY_STS_CLR_REG_CCAM_PAR_ERR                                                                          (0x1<<4)
	#define CFC_CFC_PRTY_STS_CLR_REG_CCAM_PAR_ERR_SIZE                                                                     4		
	#define CFC_CFC_PRTY_STS_CLR_REG_SCAM_PAR_ERR                                                                          (0x1<<5)
	#define CFC_CFC_PRTY_STS_CLR_REG_SCAM_PAR_ERR_SIZE                                                                     5
#define CFC_REG_CFC_PRTY_STS_WR                                                                                            0x104114UL //ACCESS:WR  DataWidth:0x6  Description: Parity register #0 bit set or clear		
	#define CFC_CFC_PRTY_STS_WR_REG_PARITY                                                                                 (0x1<<0)
	#define CFC_CFC_PRTY_STS_WR_REG_PARITY_SIZE                                                                            0		
	#define CFC_CFC_PRTY_STS_WR_REG_LL_PAR_ERR                                                                             (0x1<<1)
	#define CFC_CFC_PRTY_STS_WR_REG_LL_PAR_ERR_SIZE                                                                        1		
	#define CFC_CFC_PRTY_STS_WR_REG_INFORAM_PAR_ERR                                                                        (0x1<<2)
	#define CFC_CFC_PRTY_STS_WR_REG_INFORAM_PAR_ERR_SIZE                                                                   2		
	#define CFC_CFC_PRTY_STS_WR_REG_AC_PAR_ERR                                                                             (0x1<<3)
	#define CFC_CFC_PRTY_STS_WR_REG_AC_PAR_ERR_SIZE                                                                        3		
	#define CFC_CFC_PRTY_STS_WR_REG_CCAM_PAR_ERR                                                                           (0x1<<4)
	#define CFC_CFC_PRTY_STS_WR_REG_CCAM_PAR_ERR_SIZE                                                                      4		
	#define CFC_CFC_PRTY_STS_WR_REG_SCAM_PAR_ERR                                                                           (0x1<<5)
	#define CFC_CFC_PRTY_STS_WR_REG_SCAM_PAR_ERR_SIZE                                                                      5
#define CFC_REG_CFC_PRTY_MASK                                                                                              0x104118UL //ACCESS:RW  DataWidth:0x6  Description: Parity mask register #0 read/write		
	#define CFC_CFC_PRTY_MASK_REG_PARITY                                                                                   (0x1<<0)
	#define CFC_CFC_PRTY_MASK_REG_PARITY_SIZE                                                                              0		
	#define CFC_CFC_PRTY_MASK_REG_LL_PAR_ERR                                                                               (0x1<<1)
	#define CFC_CFC_PRTY_MASK_REG_LL_PAR_ERR_SIZE                                                                          1		
	#define CFC_CFC_PRTY_MASK_REG_INFORAM_PAR_ERR                                                                          (0x1<<2)
	#define CFC_CFC_PRTY_MASK_REG_INFORAM_PAR_ERR_SIZE                                                                     2		
	#define CFC_CFC_PRTY_MASK_REG_AC_PAR_ERR                                                                               (0x1<<3)
	#define CFC_CFC_PRTY_MASK_REG_AC_PAR_ERR_SIZE                                                                          3		
	#define CFC_CFC_PRTY_MASK_REG_CCAM_PAR_ERR                                                                             (0x1<<4)
	#define CFC_CFC_PRTY_MASK_REG_CCAM_PAR_ERR_SIZE                                                                        4		
	#define CFC_CFC_PRTY_MASK_REG_SCAM_PAR_ERR                                                                             (0x1<<5)
	#define CFC_CFC_PRTY_MASK_REG_SCAM_PAR_ERR_SIZE                                                                        5
#define CFC_REG_EXEC_ERROR_PF                                                                                              0x10412cUL //ACCESS:R  DataWidth:0x3  Description: Debug Only. The PF that generated the last execution error.
#define CFC_REG_TM_AC                                                                                                      0x107000UL //ACCESS:RW  DataWidth:0x2  Description: tm bits for ram_256x14
#define CFC_REG_ECO_RESERVED                                                                                               0x107004UL //ACCESS:RW  DataWidth:0x8  Description: eco reserved.  bit0: when set use new equation for last_free_lcid using threshold values. Bit1: when clear (default) use the LL_IO pop PFID to recover the correct Not-Empty PF counter.
#define CFC_REG_TM_LL_RAM_PREV                                                                                             0x107008UL //ACCESS:RW  DataWidth:0x2  Description: tm bits for ll_ram_prev
#define CFC_REG_TM_LL_RAM_NEXT                                                                                             0x10700cUL //ACCESS:RW  DataWidth:0x2  Description: tm bits for rll_ram_next
#define CFC_REG_DORQ_MASK_VALERR                                                                                           0x107010UL //ACCESS:RW  DataWidth:0x1  Description: Indicates if DORQ Validation Error (CDU Error#2) is masked (independent of cfc_error_mask)
#define CFC_REG_DORQ_MASK_PCIERR                                                                                           0x107014UL //ACCESS:RW  DataWidth:0x1  Description: Indicates if DORQ PCIe Error (CDU Error#1) is masked (independent of cfc_error_mask)
#define CFC_REG_SCAM_MASK_VECTOR3                                                                                          0x107018UL //ACCESS:RW  DataWidth:0xf  Description: string cam mask[110:96]. this mask is used for searches. 0 means ignore corresponding bit in search. (110:99 - Vlan; 98:96-pfid)
#define CFC_REG_INTERFACES2                                                                                                0x10701cUL //ACCESS:RW  DataWidth:0xb  Multi Field Register		
	#define CFC_INTERFACES2_REG_LRESP8_CREDIT                                                                              (0xf<<0)
	#define CFC_INTERFACES2_REG_LRESP8_CREDIT_SIZE                                                                         0		
	#define CFC_INTERFACES2_REG_LRESP8_CREDIT_SET                                                                          (0x1<<4)
	#define CFC_INTERFACES2_REG_LRESP8_CREDIT_SET_SIZE                                                                     4		
	#define CFC_INTERFACES2_REG_CDULD_CREDIT_E3                                                                            (0x1f<<5)
	#define CFC_INTERFACES2_REG_CDULD_CREDIT_E3_SIZE                                                                       5		
	#define CFC_INTERFACES2_REG_CDULD_CREDIT_SET_E3                                                                        (0x1<<10)
	#define CFC_INTERFACES2_REG_CDULD_CREDIT_SET_E3_SIZE                                                                   10
#define CFC_REG_NEMPTY_SIZE_PF                                                                                             0x10411cUL //ACCESS:RW  DataWidth:0x9  SPLIT:8  Description: the size of the Not Empty Link List is set accordingly per PF
#define CFC_REG_NEMPTY_SIZE_PF_SIZE                                                                                        1
#define CFC_REG_NUM_LCIDS_INSIDE_PF                                                                                        0x104120UL //ACCESS:RW  DataWidth:0x9  SPLIT:8  Description: Number of Inside LCIDs in Link List Block per PF
#define CFC_REG_NUM_LCIDS_INSIDE_PF_SIZE                                                                                   1
#define CFC_REG_WEAK_ENABLE_PF                                                                                             0x104124UL //ACCESS:RW  DataWidth:0x1  SPLIT:8  Description: This bit when clear will cause a load-cancel response to a load request for PF and set an execution error. Set processes load requests normally.
#define CFC_REG_WEAK_ENABLE_PF_SIZE                                                                                        1
#define CFC_REG_STRONG_ENABLE_PF                                                                                           0x104128UL //ACCESS:RW  DataWidth:0x1  SPLIT:8  Description: This bit when clear will cause a CFC execution error (weak_enable will override to force load-cancel) to a search or load request for PF. The PFID that caused the execution error will be stored (exec_error_pf)
#define CFC_REG_STRONG_ENABLE_PF_SIZE                                                                                      1
#define CFC_REG_SREQ_FULL_STICKY                                                                                           0x104130UL //ACCESS:RW  DataWidth:0x1  Description: The Interface to Searcher Request Queue has reached the maximum value (4)
#define CFC_REG_SREQ_FULL_STICKY_SIZE                                                                                      1
#define CFC_REG_PRSRESP_FULL_STICKY                                                                                        0x104134UL //ACCESS:RW  DataWidth:0x1  Description: The Interface to Parser Response Queue has reached the maximum value (6)
#define CFC_REG_PRSRESP_FULL_STICKY_SIZE                                                                                   1
#define CFC_REG_DISABLE_ROBUSTWB_PF                                                                                        0x104138UL //ACCESS:RW  DataWidth:0x1  SPLIT:8  Description: Disable Robust WB change: When an inactivate request is processed do not move the LCID to Inactive state if any of the regions are in error state
#define CFC_REG_DISABLE_ROBUSTWB_PF_SIZE                                                                                   1
#define CFC_REG_CCAM_BIST_DBG_SEL                                                                                          0x10413cUL //ACCESS:RW  DataWidth:0x8  Description: This registers selects the type of data present on bist_status bus 
#define CFC_REG_CCAM_BIST_DBG_SEL_SIZE                                                                                     1
#define CFC_REG_CCAM_BIST_STATUS                                                                                           0x104140UL //ACCESS:R  DataWidth:0x20  Description: Bist status from CAM
#define CFC_REG_CCAM_BIST_STATUS_SIZE                                                                                      1
#define CFC_REG_SCAM_BIST_DBG_SEL                                                                                          0x104144UL //ACCESS:RW  DataWidth:0x8  Description: This registers selects the type of data present on bist_status bus 
#define CFC_REG_SCAM_BIST_DBG_SEL_SIZE                                                                                     1
#define CFC_REG_SCAM_BIST_STATUS                                                                                           0x104148UL //ACCESS:R  DataWidth:0x20  Description: Bist status from CAM
#define CFC_REG_SCAM_BIST_STATUS_SIZE                                                                                      1
#define CFC_REG_DBG_OUT_DATA_LSB                                                                                           0x10414cUL //ACCESS:R  DataWidth:0x20  Description: Debug only: For dbgmux usage (debug data that goes from CFC to the DBG block) - The 32 lsb data that goes to the DBG block.
#define CFC_REG_DBG_OUT_DATA_LSB_SIZE                                                                                      1
#define CFC_REG_DBG_OUT_DATA_MSB                                                                                           0x104150UL //ACCESS:R  DataWidth:0x20  Description: Debug only: For dbgmux usage (debug data that goes from CFC to the DBG block) - The 32 msb data that goes to the DBG block.
#define CFC_REG_DBG_OUT_DATA_MSB_SIZE                                                                                      1
#define CFC_REG_DBG_OUT_FRAME                                                                                              0x104154UL //ACCESS:R  DataWidth:0x4  Description: Debug only: For dbgmux usage (debug data that goes from CFC to the DBG block) - The 4 frame bits that goes to the DBG block. Bit0 is the frame of data byte0; Bit1 is the frame of  data byte1; Bit2 is the frame of data byte2; Bit3 is the frame of  data byte4
#define CFC_REG_DBG_OUT_FRAME_SIZE                                                                                         1
#define CFC_REG_DBG_OUT_VALID                                                                                              0x104158UL //ACCESS:R  DataWidth:0x4  Description: Debug only: For dbgmux usage (debug data that goes from CFC to the DBG block) - The 4 valid bits that goes to the DBG block. Bit0 validtes data byte0; Bit1 validates data byte1; Bit2 validates data byte2; Bit3 validates data byte4
#define CFC_REG_DBG_OUT_VALID_SIZE                                                                                         1
#define CFC_REG_CCAM_BIST_DONE                                                                                             0x104200UL //ACCESS:R  DataWidth:0x1  Description: CID CAM BIST
#define CFC_REG_CCAM_BIST_DONE_SIZE                                                                                        1
#define CFC_REG_CCAM_BIST_GO                                                                                               0x104204UL //ACCESS:R  DataWidth:0x1  Description: CID CAM BIST
#define CFC_REG_CCAM_BIST_GO_SIZE                                                                                          1
#define CFC_REG_CCAM_S2_STATUS                                                                                             0x104208UL //ACCESS:R  DataWidth:0x20  Description: CID CAM BIST
#define CFC_REG_CCAM_S2_STATUS_SIZE                                                                                        1
#define CFC_REG_CCAM_S3_STATUS                                                                                             0x10420cUL //ACCESS:R  DataWidth:0x20  Description: CID CAM BIST
#define CFC_REG_CCAM_S3_STATUS_SIZE                                                                                        1
#define CFC_REG_CCAM_S5_STATUS                                                                                             0x104210UL //ACCESS:R  DataWidth:0x20  Description: CID CAM BIST
#define CFC_REG_CCAM_S5_STATUS_SIZE                                                                                        1
#define CFC_REG_CCAM_S6_STATUS                                                                                             0x104214UL //ACCESS:R  DataWidth:0x20  Description: CID CAM BIST
#define CFC_REG_CCAM_S6_STATUS_SIZE                                                                                        1
#define CFC_REG_CCAM_S8_STATUS                                                                                             0x104218UL //ACCESS:R  DataWidth:0x20  Description: CID CAM BIST
#define CFC_REG_CCAM_S8_STATUS_SIZE                                                                                        1
#define CFC_REG_EMPTY_HEAD                                                                                                 0x10421cUL //ACCESS:RW  DataWidth:0xb  Description: the head of the empty Link List is set accordingly  pfid;head
#define CFC_REG_EMPTY_HEAD_SIZE                                                                                            1
#define CFC_REG_EMPTY_SIZE                                                                                                 0x104220UL //ACCESS:RW  DataWidth:0x9  Description: the size of the empty Link List is set accordingly
#define CFC_REG_EMPTY_SIZE_SIZE                                                                                            1
#define CFC_REG_EMPTY_TAIL                                                                                                 0x104224UL //ACCESS:RW  DataWidth:0xb  Description: the tail of the empty Link List is set accordingly  pfid;tail
#define CFC_REG_EMPTY_TAIL_SIZE                                                                                            1
#define CFC_REG_SCAM_BIST_DONE                                                                                             0x104228UL //ACCESS:R  DataWidth:0x1  Description: STRING CAM BIST
#define CFC_REG_SCAM_BIST_DONE_SIZE                                                                                        1
#define CFC_REG_SCAM_BIST_GO                                                                                               0x10422cUL //ACCESS:R  DataWidth:0x1  Description: STRING CAM BIST
#define CFC_REG_SCAM_BIST_GO_SIZE                                                                                          1
#define CFC_REG_SCAM_S2_STATUS                                                                                             0x104230UL //ACCESS:R  DataWidth:0x20  Description: STRING CAM BIST
#define CFC_REG_SCAM_S2_STATUS_SIZE                                                                                        1
#define CFC_REG_SCAM_S3_STATUS                                                                                             0x104234UL //ACCESS:R  DataWidth:0x20  Description: STRING CAM BIST
#define CFC_REG_SCAM_S3_STATUS_SIZE                                                                                        1
#define CFC_REG_SCAM_S5_STATUS                                                                                             0x104238UL //ACCESS:R  DataWidth:0x20  Description: STRING CAM BIST
#define CFC_REG_SCAM_S5_STATUS_SIZE                                                                                        1
#define CFC_REG_SCAM_S6_STATUS                                                                                             0x10423cUL //ACCESS:R  DataWidth:0x20  Description: STRING CAM BIST
#define CFC_REG_SCAM_S6_STATUS_SIZE                                                                                        1
#define CFC_REG_SCAM_S8_STATUS                                                                                             0x104240UL //ACCESS:R  DataWidth:0x20  Description: STRING CAM BIST
#define CFC_REG_SCAM_S8_STATUS_SIZE                                                                                        1
#define CFC_REG_ACTIVITY_COUNTER                                                                                           0x104400UL //ACCESS:RW  DataWidth:0xd  Description: activity counter ram access
#define CFC_REG_ACTIVITY_COUNTER_SIZE                                                                                      256
#define CFC_REG_CID_CAM                                                                                                    0x104800UL //ACCESS:RW  DataWidth:0x15  Description: CID cam  access (21:1 - Data;Valid - 0)
#define CFC_REG_CID_CAM_SIZE                                                                                               256
#define CFC_REG_LINK_LIST                                                                                                  0x104c00UL //ACCESS:RW  DataWidth:0x16  Description: Link List ram access; data = {prev_pfid;prev_lcid;next_pfid;next_lcid}
#define CFC_REG_LINK_LIST_SIZE                                                                                             256
#define CFC_REG_INFO_RAM                                                                                                   0x105000UL //ACCESS:WB  DataWidth:0x61  Description: LCID info ram  access = {96-vpf;95:93-pfid;92:89-type;88:85-action;84-paddrv;83:20-paddr;19:4-rstates;3-lsf;2:0-lstate}
#define CFC_REG_INFO_RAM_SIZE                                                                                              1024
#define CFC_REG_STRING_CAM                                                                                                 0x106000UL //ACCESS:WB  DataWidth:0x70  Description: String cam access (111:100 - Vlan; 99:97-pfid; 96:1 - Data; 0 - Valid)
#define CFC_REG_STRING_CAM_SIZE                                                                                            1024
#define CFC_REG_CFC_UNUSED_EMPTY_0                                                                                         0x10415cUL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CFC_REG_CFC_UNUSED_EMPTY_0_SIZE                                                                                    41
#define CFC_REG_CFC_UNUSED_EMPTY_1                                                                                         0x104244UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CFC_REG_CFC_UNUSED_EMPTY_1_SIZE                                                                                    111
#define CFC_REG_CFC_UNUSED_EMPTY_2                                                                                         0x107020UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CFC_REG_CFC_UNUSED_EMPTY_2_SIZE                                                                                    1016
#define CSDM_REG_TIMER_TICK                                                                                                0xc2000UL //ACCESS:RW  DataWidth:0x20  Description: Tick for timer counter. Applicable only when ~csdm_registers_timer_tick_enable.timer_tick_enable =1
#define CSDM_REG_TIMERS_TICK_ENABLE                                                                                        0xc2004UL //ACCESS:RW  DataWidth:0x1  Description: Enable for tick counter.
#define CSDM_REG_CFC_RSP_START_ADDR                                                                                        0xc2008UL //ACCESS:RW  DataWidth:0xe  Description: The start address in the  internal RAM for the cfc_rsp lcid
#define CSDM_REG_CMP_COUNTER_START_ADDR                                                                                    0xc200cUL //ACCESS:RW  DataWidth:0xe  Description: The start address in the internal  RAM for the completion counters.
#define CSDM_REG_Q_COUNTER_START_ADDR                                                                                      0xc2010UL //ACCESS:RW  DataWidth:0xe  Description: The start address in the internal RAM for queue counters
#define CSDM_REG_PCK_END_MSG_START_ADDR                                                                                    0xc2014UL //ACCESS:RW  DataWidth:0xe  Description: The start address in the internal RAM for the packet end message
#define CSDM_REG_COUNTERS_WRAP                                                                                             0xc2018UL //ACCESS:RW  DataWidth:0x1  Description: Indicates if the 204 statistics counters should stop counting when reaching an all-ones value or should wrap-around 0=stop counting 1=wrap-around.
#define CSDM_REG_CMP_COUNTER_MAX0                                                                                          0xc201cUL //ACCESS:RW  DataWidth:0x10  Description: The maximum value of the competion counter #0
#define CSDM_REG_CMP_COUNTER_MAX1                                                                                          0xc2020UL //ACCESS:RW  DataWidth:0x10  Description: The maximum value of the competion counter #1
#define CSDM_REG_CMP_COUNTER_MAX2                                                                                          0xc2024UL //ACCESS:RW  DataWidth:0x10  Description: The maximum value of the competion counter #2
#define CSDM_REG_CMP_COUNTER_MAX3                                                                                          0xc2028UL //ACCESS:RW  DataWidth:0x10  Description: The maximum value of the competion counter #3
#define CSDM_REG_BRB1_ALMOST_FULL                                                                                          0xc202cUL //ACCESS:RW  DataWidth:0x4  Description: Almost full signal for read data from BRB1 in DMA_RSP block
#define CSDM_REG_PXP_ALMOST_FULL                                                                                           0xc2030UL //ACCESS:RW  DataWidth:0x4  Description: Almost full signal for read data from pxp in DMA_RSP block
#define CSDM_REG_PB_ALMOST_FULL                                                                                            0xc2034UL //ACCESS:RW  DataWidth:0x4  Description: Almost full signal for read data from PB in DMA_RSP block
#define CSDM_REG_AGG_INT_EVENT_0                                                                                           0xc2038UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 0
#define CSDM_REG_AGG_INT_EVENT_1                                                                                           0xc203cUL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 1
#define CSDM_REG_AGG_INT_EVENT_2                                                                                           0xc2040UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 2
#define CSDM_REG_AGG_INT_EVENT_3                                                                                           0xc2044UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 3
#define CSDM_REG_AGG_INT_EVENT_4                                                                                           0xc2048UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 4
#define CSDM_REG_AGG_INT_EVENT_5                                                                                           0xc204cUL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 5
#define CSDM_REG_AGG_INT_EVENT_6                                                                                           0xc2050UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 6
#define CSDM_REG_AGG_INT_EVENT_7                                                                                           0xc2054UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 7
#define CSDM_REG_AGG_INT_EVENT_8                                                                                           0xc2058UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 8
#define CSDM_REG_AGG_INT_EVENT_9                                                                                           0xc205cUL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 9
#define CSDM_REG_AGG_INT_EVENT_10                                                                                          0xc2060UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 10
#define CSDM_REG_AGG_INT_EVENT_11                                                                                          0xc2064UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 11
#define CSDM_REG_AGG_INT_EVENT_12                                                                                          0xc2068UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 12
#define CSDM_REG_AGG_INT_EVENT_13                                                                                          0xc206cUL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 13
#define CSDM_REG_AGG_INT_EVENT_14                                                                                          0xc2070UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 14
#define CSDM_REG_AGG_INT_EVENT_15                                                                                          0xc2074UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 15
#define CSDM_REG_AGG_INT_EVENT_16                                                                                          0xc2078UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 16
#define CSDM_REG_AGG_INT_EVENT_17                                                                                          0xc207cUL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 17
#define CSDM_REG_AGG_INT_EVENT_18                                                                                          0xc2080UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 18
#define CSDM_REG_AGG_INT_EVENT_19                                                                                          0xc2084UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 19
#define CSDM_REG_AGG_INT_EVENT_20                                                                                          0xc2088UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 20
#define CSDM_REG_AGG_INT_EVENT_21                                                                                          0xc208cUL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 21
#define CSDM_REG_AGG_INT_EVENT_22                                                                                          0xc2090UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 22
#define CSDM_REG_AGG_INT_EVENT_23                                                                                          0xc2094UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 23
#define CSDM_REG_AGG_INT_EVENT_24                                                                                          0xc2098UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 24
#define CSDM_REG_AGG_INT_EVENT_25                                                                                          0xc209cUL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 25
#define CSDM_REG_AGG_INT_EVENT_26                                                                                          0xc20a0UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 26
#define CSDM_REG_AGG_INT_EVENT_27                                                                                          0xc20a4UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 27
#define CSDM_REG_AGG_INT_EVENT_28                                                                                          0xc20a8UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 28
#define CSDM_REG_AGG_INT_EVENT_29                                                                                          0xc20acUL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 29
#define CSDM_REG_AGG_INT_EVENT_30                                                                                          0xc20b0UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 30
#define CSDM_REG_AGG_INT_EVENT_31                                                                                          0xc20b4UL //ACCESS:RW  DataWidth:0x8  Description: The event id for aggregated interrupt 31
#define CSDM_REG_AGG_INT_T_0                                                                                               0xc20b8UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 0
#define CSDM_REG_AGG_INT_T_1                                                                                               0xc20bcUL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 1
#define CSDM_REG_AGG_INT_T_2                                                                                               0xc20c0UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 2
#define CSDM_REG_AGG_INT_T_3                                                                                               0xc20c4UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 3
#define CSDM_REG_AGG_INT_T_4                                                                                               0xc20c8UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 4
#define CSDM_REG_AGG_INT_T_5                                                                                               0xc20ccUL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 5
#define CSDM_REG_AGG_INT_T_6                                                                                               0xc20d0UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 6
#define CSDM_REG_AGG_INT_T_7                                                                                               0xc20d4UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 7
#define CSDM_REG_AGG_INT_T_8                                                                                               0xc20d8UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 8
#define CSDM_REG_AGG_INT_T_9                                                                                               0xc20dcUL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 9
#define CSDM_REG_AGG_INT_T_10                                                                                              0xc20e0UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 10
#define CSDM_REG_AGG_INT_T_11                                                                                              0xc20e4UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 11
#define CSDM_REG_AGG_INT_T_12                                                                                              0xc20e8UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 12
#define CSDM_REG_AGG_INT_T_13                                                                                              0xc20ecUL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 13
#define CSDM_REG_AGG_INT_T_14                                                                                              0xc20f0UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 14
#define CSDM_REG_AGG_INT_T_15                                                                                              0xc20f4UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 15
#define CSDM_REG_AGG_INT_T_16                                                                                              0xc20f8UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 16
#define CSDM_REG_AGG_INT_T_17                                                                                              0xc20fcUL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 17
#define CSDM_REG_AGG_INT_T_18                                                                                              0xc2100UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 18
#define CSDM_REG_AGG_INT_T_19                                                                                              0xc2104UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 19
#define CSDM_REG_AGG_INT_T_20                                                                                              0xc2108UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 20
#define CSDM_REG_AGG_INT_T_21                                                                                              0xc210cUL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 21
#define CSDM_REG_AGG_INT_T_22                                                                                              0xc2110UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 22
#define CSDM_REG_AGG_INT_T_23                                                                                              0xc2114UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 23
#define CSDM_REG_AGG_INT_T_24                                                                                              0xc2118UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 24
#define CSDM_REG_AGG_INT_T_25                                                                                              0xc211cUL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 25
#define CSDM_REG_AGG_INT_T_26                                                                                              0xc2120UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 26
#define CSDM_REG_AGG_INT_T_27                                                                                              0xc2124UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 27
#define CSDM_REG_AGG_INT_T_28                                                                                              0xc2128UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 28
#define CSDM_REG_AGG_INT_T_29                                                                                              0xc212cUL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 29
#define CSDM_REG_AGG_INT_T_30                                                                                              0xc2130UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 30
#define CSDM_REG_AGG_INT_T_31                                                                                              0xc2134UL //ACCESS:RW  DataWidth:0x1  Description: The T bit for aggregated interrupt 31
#define CSDM_REG_AGG_INT_FIC_0                                                                                             0xc2138UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 0
#define CSDM_REG_AGG_INT_FIC_1                                                                                             0xc213cUL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 1
#define CSDM_REG_AGG_INT_FIC_2                                                                                             0xc2140UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 2
#define CSDM_REG_AGG_INT_FIC_3                                                                                             0xc2144UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 3
#define CSDM_REG_AGG_INT_FIC_4                                                                                             0xc2148UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 4
#define CSDM_REG_AGG_INT_FIC_5                                                                                             0xc214cUL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 5
#define CSDM_REG_AGG_INT_FIC_6                                                                                             0xc2150UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 6
#define CSDM_REG_AGG_INT_FIC_7                                                                                             0xc2154UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 7
#define CSDM_REG_AGG_INT_FIC_8                                                                                             0xc2158UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 8
#define CSDM_REG_AGG_INT_FIC_9                                                                                             0xc215cUL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 9
#define CSDM_REG_AGG_INT_FIC_10                                                                                            0xc2160UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 10
#define CSDM_REG_AGG_INT_FIC_11                                                                                            0xc2164UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 11
#define CSDM_REG_AGG_INT_FIC_12                                                                                            0xc2168UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 12
#define CSDM_REG_AGG_INT_FIC_13                                                                                            0xc216cUL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 13
#define CSDM_REG_AGG_INT_FIC_14                                                                                            0xc2170UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 14
#define CSDM_REG_AGG_INT_FIC_15                                                                                            0xc2174UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 15
#define CSDM_REG_AGG_INT_FIC_16                                                                                            0xc2178UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 16
#define CSDM_REG_AGG_INT_FIC_17                                                                                            0xc217cUL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 17
#define CSDM_REG_AGG_INT_FIC_18                                                                                            0xc2180UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 18
#define CSDM_REG_AGG_INT_FIC_19                                                                                            0xc2184UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 19
#define CSDM_REG_AGG_INT_FIC_20                                                                                            0xc2188UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 20
#define CSDM_REG_AGG_INT_FIC_21                                                                                            0xc218cUL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 21
#define CSDM_REG_AGG_INT_FIC_22                                                                                            0xc2190UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 22
#define CSDM_REG_AGG_INT_FIC_23                                                                                            0xc2194UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 23
#define CSDM_REG_AGG_INT_FIC_24                                                                                            0xc2198UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 24
#define CSDM_REG_AGG_INT_FIC_25                                                                                            0xc219cUL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 25
#define CSDM_REG_AGG_INT_FIC_26                                                                                            0xc21a0UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 26
#define CSDM_REG_AGG_INT_FIC_27                                                                                            0xc21a4UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 27
#define CSDM_REG_AGG_INT_FIC_28                                                                                            0xc21a8UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 28
#define CSDM_REG_AGG_INT_FIC_29                                                                                            0xc21acUL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 29
#define CSDM_REG_AGG_INT_FIC_30                                                                                            0xc21b0UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 30
#define CSDM_REG_AGG_INT_FIC_31                                                                                            0xc21b4UL //ACCESS:RW  DataWidth:0x1  Description: The destination FIC for aggregated interrupt 31
#define CSDM_REG_AGG_INT_MODE_0                                                                                            0xc21b8UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_1                                                                                            0xc21bcUL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_2                                                                                            0xc21c0UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_3                                                                                            0xc21c4UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_4                                                                                            0xc21c8UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_5                                                                                            0xc21ccUL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_6                                                                                            0xc21d0UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_7                                                                                            0xc21d4UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_8                                                                                            0xc21d8UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_9                                                                                            0xc21dcUL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_10                                                                                           0xc21e0UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_11                                                                                           0xc21e4UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_12                                                                                           0xc21e8UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_13                                                                                           0xc21ecUL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_14                                                                                           0xc21f0UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_15                                                                                           0xc21f4UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_16                                                                                           0xc21f8UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (16) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_17                                                                                           0xc21fcUL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (17)
#define CSDM_REG_AGG_INT_MODE_18                                                                                           0xc2200UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_19                                                                                           0xc2204UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_20                                                                                           0xc2208UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_21                                                                                           0xc220cUL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_22                                                                                           0xc2210UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_23                                                                                           0xc2214UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_24                                                                                           0xc2218UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_25                                                                                           0xc221cUL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_26                                                                                           0xc2220UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_27                                                                                           0xc2224UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_28                                                                                           0xc2228UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_29                                                                                           0xc222cUL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_30                                                                                           0xc2230UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_AGG_INT_MODE_31                                                                                           0xc2234UL //ACCESS:RW  DataWidth:0x1  Description: For each aggregated interrupt index whether the mode is normal (0) or auto-mask-mode (1)
#define CSDM_REG_ENABLE_IN1                                                                                                0xc2238UL //ACCESS:RW  DataWidth:0x1b  Multi Field Register		
	#define CSDM_ENABLE_IN1_REG_EXT_STORE_IN_EN                                                                            (0x1<<0)
	#define CSDM_ENABLE_IN1_REG_EXT_STORE_IN_EN_SIZE                                                                       0		
	#define CSDM_ENABLE_IN1_REG_INT_RAM_DATA_IN_EN                                                                         (0x1<<1)
	#define CSDM_ENABLE_IN1_REG_INT_RAM_DATA_IN_EN_SIZE                                                                    1		
	#define CSDM_ENABLE_IN1_REG_INT_RAM_DONE_IN_EN                                                                         (0x1<<2)
	#define CSDM_ENABLE_IN1_REG_INT_RAM_DONE_IN_EN_SIZE                                                                    2		
	#define CSDM_ENABLE_IN1_REG_INT_RAM_FULL_IN_EN                                                                         (0x1<<3)
	#define CSDM_ENABLE_IN1_REG_INT_RAM_FULL_IN_EN_SIZE                                                                    3		
	#define CSDM_ENABLE_IN1_REG_PAS_BUF_DONE_IN_EN                                                                         (0x1<<4)
	#define CSDM_ENABLE_IN1_REG_PAS_BUF_DONE_IN_EN_SIZE                                                                    4		
	#define CSDM_ENABLE_IN1_REG_PAS_BUF_FULL_IN_EN                                                                         (0x1<<5)
	#define CSDM_ENABLE_IN1_REG_PAS_BUF_FULL_IN_EN_SIZE                                                                    5		
	#define CSDM_ENABLE_IN1_REG_PXP_CTRL_DONE_IN_EN                                                                        (0x1<<6)
	#define CSDM_ENABLE_IN1_REG_PXP_CTRL_DONE_IN_EN_SIZE                                                                   6		
	#define CSDM_ENABLE_IN1_REG_PXP_DP_DONE_IN_EN                                                                          (0x1<<7)
	#define CSDM_ENABLE_IN1_REG_PXP_DP_DONE_IN_EN_SIZE                                                                     7		
	#define CSDM_ENABLE_IN1_REG_PXP_CTRL_FULL_IN_EN                                                                        (0x1<<8)
	#define CSDM_ENABLE_IN1_REG_PXP_CTRL_FULL_IN_EN_SIZE                                                                   8		
	#define CSDM_ENABLE_IN1_REG_PXP_DP_FULL_IN_EN                                                                          (0x1<<9)
	#define CSDM_ENABLE_IN1_REG_PXP_DP_FULL_IN_EN_SIZE                                                                     9		
	#define CSDM_ENABLE_IN1_REG_PXP_CTRL_DATA_IN_EN                                                                        (0x1<<10)
	#define CSDM_ENABLE_IN1_REG_PXP_CTRL_DATA_IN_EN_SIZE                                                                   10		
	#define CSDM_ENABLE_IN1_REG_PXP_INT_DONE_IN_EN                                                                         (0x1<<11)
	#define CSDM_ENABLE_IN1_REG_PXP_INT_DONE_IN_EN_SIZE                                                                    11		
	#define CSDM_ENABLE_IN1_REG_PXP_DP_DATA_IN_EN                                                                          (0x1<<12)
	#define CSDM_ENABLE_IN1_REG_PXP_DP_DATA_IN_EN_SIZE                                                                     12		
	#define CSDM_ENABLE_IN1_REG_PXP_CTRL_ACK_IN_EN                                                                         (0x1<<13)
	#define CSDM_ENABLE_IN1_REG_PXP_CTRL_ACK_IN_EN_SIZE                                                                    13		
	#define CSDM_ENABLE_IN1_REG_PXP_DP_ACK_IN_EN                                                                           (0x1<<14)
	#define CSDM_ENABLE_IN1_REG_PXP_DP_ACK_IN_EN_SIZE                                                                      14		
	#define CSDM_ENABLE_IN1_REG_BRB1_CTRL_DATA_IN_EN                                                                       (0x1<<15)
	#define CSDM_ENABLE_IN1_REG_BRB1_CTRL_DATA_IN_EN_SIZE                                                                  15		
	#define CSDM_ENABLE_IN1_REG_BRB1_DP_DATA_IN_EN                                                                         (0x1<<16)
	#define CSDM_ENABLE_IN1_REG_BRB1_DP_DATA_IN_EN_SIZE                                                                    16		
	#define CSDM_ENABLE_IN1_REG_PB_DATA_IN_EN                                                                              (0x1<<17)
	#define CSDM_ENABLE_IN1_REG_PB_DATA_IN_EN_SIZE                                                                         17		
	#define CSDM_ENABLE_IN1_REG_PRS_MSG_IN_EN                                                                              (0x1<<18)
	#define CSDM_ENABLE_IN1_REG_PRS_MSG_IN_EN_SIZE                                                                         18		
	#define CSDM_ENABLE_IN1_REG_SDM_WAKE_IN_EN                                                                             (0x1<<19)
	#define CSDM_ENABLE_IN1_REG_SDM_WAKE_IN_EN_SIZE                                                                        19		
	#define CSDM_ENABLE_IN1_REG_PXP_REQ_IN_EN                                                                              (0x1<<20)
	#define CSDM_ENABLE_IN1_REG_PXP_REQ_IN_EN_SIZE                                                                         20		
	#define CSDM_ENABLE_IN1_REG_CFC_LOAD_ACK_IN_EN                                                                         (0x1<<21)
	#define CSDM_ENABLE_IN1_REG_CFC_LOAD_ACK_IN_EN_SIZE                                                                    21		
	#define CSDM_ENABLE_IN1_REG_CFC_LOAD_RSP_IN_EN                                                                         (0x1<<22)
	#define CSDM_ENABLE_IN1_REG_CFC_LOAD_RSP_IN_EN_SIZE                                                                    22		
	#define CSDM_ENABLE_IN1_REG_CFC_ACINC_ACK_IN_EN                                                                        (0x1<<23)
	#define CSDM_ENABLE_IN1_REG_CFC_ACINC_ACK_IN_EN_SIZE                                                                   23		
	#define CSDM_ENABLE_IN1_REG_CFC_ACDEC_ACK_IN_EN                                                                        (0x1<<24)
	#define CSDM_ENABLE_IN1_REG_CFC_ACDEC_ACK_IN_EN_SIZE                                                                   24		
	#define CSDM_ENABLE_IN1_REG_CFC_PB_ACK_IN_EN                                                                           (0x1<<25)
	#define CSDM_ENABLE_IN1_REG_CFC_PB_ACK_IN_EN_SIZE                                                                      25		
	#define CSDM_ENABLE_IN1_REG_QM_EXT_WR_FULL_IN_EN                                                                       (0x1<<26)
	#define CSDM_ENABLE_IN1_REG_QM_EXT_WR_FULL_IN_EN_SIZE                                                                  26
#define CSDM_REG_ENABLE_IN2                                                                                                0xc223cUL //ACCESS:RW  DataWidth:0x7  Multi Field Register		
	#define CSDM_ENABLE_IN2_REG_SDM_ACK_IN_EN                                                                              (0x1<<0)
	#define CSDM_ENABLE_IN2_REG_SDM_ACK_IN_EN_SIZE                                                                         0		
	#define CSDM_ENABLE_IN2_REG_CM_ACK_IN_EN                                                                               (0x1<<1)
	#define CSDM_ENABLE_IN2_REG_CM_ACK_IN_EN_SIZE                                                                          1		
	#define CSDM_ENABLE_IN2_REG_PB_STATUS_IN_EN                                                                            (0x1<<2)
	#define CSDM_ENABLE_IN2_REG_PB_STATUS_IN_EN_SIZE                                                                       2		
	#define CSDM_ENABLE_IN2_REG_PB_FULL_IN_EN                                                                              (0x1<<3)
	#define CSDM_ENABLE_IN2_REG_PB_FULL_IN_EN_SIZE                                                                         3		
	#define CSDM_ENABLE_IN2_REG_PBF_EXT_WR_FULL_IN_EN                                                                      (0x1<<4)
	#define CSDM_ENABLE_IN2_REG_PBF_EXT_WR_FULL_IN_EN_SIZE                                                                 4		
	#define CSDM_ENABLE_IN2_REG_PB_EXT_WR_FULL_IN_EN                                                                       (0x1<<5)
	#define CSDM_ENABLE_IN2_REG_PB_EXT_WR_FULL_IN_EN_SIZE                                                                  5		
	#define CSDM_ENABLE_IN2_REG_DORQ_REQ_IN_EN                                                                             (0x1<<6)
	#define CSDM_ENABLE_IN2_REG_DORQ_REQ_IN_EN_SIZE                                                                        6
#define CSDM_REG_ENABLE_OUT1                                                                                               0xc2240UL //ACCESS:RW  DataWidth:0x1b  Multi Field Register		
	#define CSDM_ENABLE_OUT1_REG_PXP_INT_OUT_EN                                                                            (0x1<<0)
	#define CSDM_ENABLE_OUT1_REG_PXP_INT_OUT_EN_SIZE                                                                       0		
	#define CSDM_ENABLE_OUT1_REG_THREADREADY_OUT_EN                                                                        (0x1<<1)
	#define CSDM_ENABLE_OUT1_REG_THREADREADY_OUT_EN_SIZE                                                                   1		
	#define CSDM_ENABLE_OUT1_REG_CFC_LOAD_OUT_EN                                                                           (0x1<<2)
	#define CSDM_ENABLE_OUT1_REG_CFC_LOAD_OUT_EN_SIZE                                                                      2		
	#define CSDM_ENABLE_OUT1_REG_CFC_ACINC_OUT_EN                                                                          (0x1<<3)
	#define CSDM_ENABLE_OUT1_REG_CFC_ACINC_OUT_EN_SIZE                                                                     3		
	#define CSDM_ENABLE_OUT1_REG_CFC_ACDEC_OUT_EN                                                                          (0x1<<4)
	#define CSDM_ENABLE_OUT1_REG_CFC_ACDEC_OUT_EN_SIZE                                                                     4		
	#define CSDM_ENABLE_OUT1_REG_CFC_PB_OUT_EN                                                                             (0x1<<5)
	#define CSDM_ENABLE_OUT1_REG_CFC_PB_OUT_EN_SIZE                                                                        5		
	#define CSDM_ENABLE_OUT1_REG_PXP_CTRL_REQ_OUT_EN                                                                       (0x1<<6)
	#define CSDM_ENABLE_OUT1_REG_PXP_CTRL_REQ_OUT_EN_SIZE                                                                  6		
	#define CSDM_ENABLE_OUT1_REG_PXP_DP_REQ_OUT_EN                                                                         (0x1<<7)
	#define CSDM_ENABLE_OUT1_REG_PXP_DP_REQ_OUT_EN_SIZE                                                                    7		
	#define CSDM_ENABLE_OUT1_REG_BRB1_CTRL_REQ_OUT_EN                                                                      (0x1<<8)
	#define CSDM_ENABLE_OUT1_REG_BRB1_CTRL_REQ_OUT_EN_SIZE                                                                 8		
	#define CSDM_ENABLE_OUT1_REG_BRB1_DP_REQ_OUT_EN                                                                        (0x1<<9)
	#define CSDM_ENABLE_OUT1_REG_BRB1_DP_REQ_OUT_EN_SIZE                                                                   9		
	#define CSDM_ENABLE_OUT1_REG_PRS_SYNC_OUT_EN                                                                           (0x1<<10)
	#define CSDM_ENABLE_OUT1_REG_PRS_SYNC_OUT_EN_SIZE                                                                      10		
	#define CSDM_ENABLE_OUT1_REG_PRS_ACK_OUT_EN                                                                            (0x1<<11)
	#define CSDM_ENABLE_OUT1_REG_PRS_ACK_OUT_EN_SIZE                                                                       11		
	#define CSDM_ENABLE_OUT1_REG_INT_RAM_OUT_EN                                                                            (0x1<<12)
	#define CSDM_ENABLE_OUT1_REG_INT_RAM_OUT_EN_SIZE                                                                       12		
	#define CSDM_ENABLE_OUT1_REG_PAS_BUF_OUT_EN                                                                            (0x1<<13)
	#define CSDM_ENABLE_OUT1_REG_PAS_BUF_OUT_EN_SIZE                                                                       13		
	#define CSDM_ENABLE_OUT1_REG_PXP_ASYNC_OUT_EN                                                                          (0x1<<14)
	#define CSDM_ENABLE_OUT1_REG_PXP_ASYNC_OUT_EN_SIZE                                                                     14		
	#define CSDM_ENABLE_OUT1_REG_PXP_CTRL_OUT_EN                                                                           (0x1<<15)
	#define CSDM_ENABLE_OUT1_REG_PXP_CTRL_OUT_EN_SIZE                                                                      15		
	#define CSDM_ENABLE_OUT1_REG_PXP_DP_OUT_EN                                                                             (0x1<<16)
	#define CSDM_ENABLE_OUT1_REG_PXP_DP_OUT_EN_SIZE                                                                        16		
	#define CSDM_ENABLE_OUT1_REG_BRB1_CTRL_FULL_OUT_EN                                                                     (0x1<<17)
	#define CSDM_ENABLE_OUT1_REG_BRB1_CTRL_FULL_OUT_EN_SIZE                                                                17		
	#define CSDM_ENABLE_OUT1_REG_BRB1_DP_FULL_OUT_EN                                                                       (0x1<<18)
	#define CSDM_ENABLE_OUT1_REG_BRB1_DP_FULL_OUT_EN_SIZE                                                                  18		
	#define CSDM_ENABLE_OUT1_REG_PB_FULL_OUT_EN                                                                            (0x1<<19)
	#define CSDM_ENABLE_OUT1_REG_PB_FULL_OUT_EN_SIZE                                                                       19		
	#define CSDM_ENABLE_OUT1_REG_PXP_CTRL_FULL_OUT_EN                                                                      (0x1<<20)
	#define CSDM_ENABLE_OUT1_REG_PXP_CTRL_FULL_OUT_EN_SIZE                                                                 20		
	#define CSDM_ENABLE_OUT1_REG_EXT_FULL_OUT_EN                                                                           (0x1<<21)
	#define CSDM_ENABLE_OUT1_REG_EXT_FULL_OUT_EN_SIZE                                                                      21		
	#define CSDM_ENABLE_OUT1_REG_PXP_REQ_DONE_OUT_EN                                                                       (0x1<<22)
	#define CSDM_ENABLE_OUT1_REG_PXP_REQ_DONE_OUT_EN_SIZE                                                                  22		
	#define CSDM_ENABLE_OUT1_REG_CM_MSG_OUT_EN                                                                             (0x1<<23)
	#define CSDM_ENABLE_OUT1_REG_CM_MSG_OUT_EN_SIZE                                                                        23		
	#define CSDM_ENABLE_OUT1_REG_CFC_SDM_ACK_OUT_EN                                                                        (0x1<<24)
	#define CSDM_ENABLE_OUT1_REG_CFC_SDM_ACK_OUT_EN_SIZE                                                                   24		
	#define CSDM_ENABLE_OUT1_REG_PB_OUT_EN                                                                                 (0x1<<25)
	#define CSDM_ENABLE_OUT1_REG_PB_OUT_EN_SIZE                                                                            25		
	#define CSDM_ENABLE_OUT1_REG_PBF_EXT_WR_OUT_EN                                                                         (0x1<<26)
	#define CSDM_ENABLE_OUT1_REG_PBF_EXT_WR_OUT_EN_SIZE                                                                    26
#define CSDM_REG_ENABLE_OUT2                                                                                               0xc2244UL //ACCESS:RW  DataWidth:0x6  Multi Field Register		
	#define CSDM_ENABLE_OUT2_REG_PB_EXT_WR_OUT_EN                                                                          (0x1<<0)
	#define CSDM_ENABLE_OUT2_REG_PB_EXT_WR_OUT_EN_SIZE                                                                     0		
	#define CSDM_ENABLE_OUT2_REG_DQ_EXT_WR_OUT_EN                                                                          (0x1<<1)
	#define CSDM_ENABLE_OUT2_REG_DQ_EXT_WR_OUT_EN_SIZE                                                                     1		
	#define CSDM_ENABLE_OUT2_REG_QM_EXT_WR_OUT_EN                                                                          (0x1<<2)
	#define CSDM_ENABLE_OUT2_REG_QM_EXT_WR_OUT_EN_SIZE                                                                     2		
	#define CSDM_ENABLE_OUT2_REG_SDM_EXT_WR_OUT_EN                                                                         (0x1<<3)
	#define CSDM_ENABLE_OUT2_REG_SDM_EXT_WR_OUT_EN_SIZE                                                                    3		
	#define CSDM_ENABLE_OUT2_REG_VFPF_ERR_OUT_EN                                                                           (0x1<<4)
	#define CSDM_ENABLE_OUT2_REG_VFPF_ERR_OUT_EN_SIZE                                                                      4		
	#define CSDM_ENABLE_OUT2_REG_DORQ_REQ_DONE_OUT_EN                                                                      (0x1<<5)
	#define CSDM_ENABLE_OUT2_REG_DORQ_REQ_DONE_OUT_EN_SIZE                                                                 5
#define CSDM_REG_NUM_OF_Q0_CMD                                                                                             0xc2248UL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 0
#define CSDM_REG_NUM_OF_Q1_CMD                                                                                             0xc224cUL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 1
#define CSDM_REG_NUM_OF_Q3_CMD                                                                                             0xc2250UL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 3
#define CSDM_REG_NUM_OF_Q4_CMD                                                                                             0xc2254UL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 4
#define CSDM_REG_NUM_OF_Q5_CMD                                                                                             0xc2258UL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 5
#define CSDM_REG_NUM_OF_Q6_CMD                                                                                             0xc225cUL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 6
#define CSDM_REG_NUM_OF_Q7_CMD                                                                                             0xc2260UL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 7
#define CSDM_REG_NUM_OF_Q8_CMD                                                                                             0xc2264UL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 8
#define CSDM_REG_NUM_OF_Q9_CMD                                                                                             0xc2268UL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 9
#define CSDM_REG_NUM_OF_Q10_CMD                                                                                            0xc226cUL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 10
#define CSDM_REG_NUM_OF_Q11_CMD                                                                                            0xc2270UL //ACCESS:ST  DataWidth:0x20  Description: The number of commands received in queue 11
#define CSDM_REG_NUM_OF_PKT_END_MSG                                                                                        0xc2274UL //ACCESS:ST  DataWidth:0x20  Description: The number of packet end messages received from the parser
#define CSDM_REG_NUM_OF_PXP_ASYNC_REQ                                                                                      0xc2278UL //ACCESS:ST  DataWidth:0x20  Description: The number of requests received from the pxp async if
#define CSDM_REG_NUM_OF_ACK_AFTER_PLACE                                                                                    0xc227cUL //ACCESS:ST  DataWidth:0x20  Description: The number of ACK after placement messages received 
#define CSDM_REG_STATISTICS_TM                                                                                             0xc2280UL //ACCESS:RW  DataWidth:0x4  Description: TM bits for statistics sram
#define CSDM_REG_DBG_SELECT                                                                                                0xc2284UL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from CSDM to the DBG block) - for selecting a line to output to the DBG block
#define CSDM_REG_DBG_BYTE_ENABLE                                                                                           0xc2288UL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from CSDM to the DBG block) - for enabling bytes in the selected line (after the select before the shift).
#define CSDM_REG_DBG_SHIFT                                                                                                 0xc228cUL //ACCESS:RW  DataWidth:0x3  Description: Debug only. For dbgmux usage (debug data that goes from CSDM to the DBG block) - for circular right shifting of the selected line (after the enabling).
#define CSDM_REG_CSDM_INT_STS_0                                                                                            0xc2290UL //ACCESS:R  DataWidth:0x20  Description: Interrupt register #0 read		
	#define CSDM_CSDM_INT_STS_0_REG_ADDRESS_ERROR                                                                          (0x1<<0)
	#define CSDM_CSDM_INT_STS_0_REG_ADDRESS_ERROR_SIZE                                                                     0		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE0_ERROR                                                                       (0x1<<1)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE0_ERROR_SIZE                                                                  1		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE1_ERROR                                                                       (0x1<<2)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE1_ERROR_SIZE                                                                  2		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE2_ERROR                                                                       (0x1<<3)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE2_ERROR_SIZE                                                                  3		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE3_ERROR                                                                       (0x1<<4)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE3_ERROR_SIZE                                                                  4		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE4_ERROR                                                                       (0x1<<5)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE4_ERROR_SIZE                                                                  5		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE5_ERROR                                                                       (0x1<<6)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE5_ERROR_SIZE                                                                  6		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE6_ERROR                                                                       (0x1<<7)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE6_ERROR_SIZE                                                                  7		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE7_ERROR                                                                       (0x1<<8)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE7_ERROR_SIZE                                                                  8		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE8_ERROR                                                                       (0x1<<9)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE8_ERROR_SIZE                                                                  9		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE9_ERROR                                                                       (0x1<<10)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE9_ERROR_SIZE                                                                  10		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE10_ERROR                                                                      (0x1<<11)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE10_ERROR_SIZE                                                                 11		
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE11_ERROR                                                                      (0x1<<12)
	#define CSDM_CSDM_INT_STS_0_REG_INP_QUEUE11_ERROR_SIZE                                                                 12		
	#define CSDM_CSDM_INT_STS_0_REG_DELAY_FIFO_ERROR                                                                       (0x1<<13)
	#define CSDM_CSDM_INT_STS_0_REG_DELAY_FIFO_ERROR_SIZE                                                                  13		
	#define CSDM_CSDM_INT_STS_0_REG_ASYNC_HOST_ERROR                                                                       (0x1<<14)
	#define CSDM_CSDM_INT_STS_0_REG_ASYNC_HOST_ERROR_SIZE                                                                  14		
	#define CSDM_CSDM_INT_STS_0_REG_SYNC_PRS_FIFO_ERROR                                                                    (0x1<<15)
	#define CSDM_CSDM_INT_STS_0_REG_SYNC_PRS_FIFO_ERROR_SIZE                                                               15		
	#define CSDM_CSDM_INT_STS_0_REG_SYNC_SER_FIFO_ERROR                                                                    (0x1<<16)
	#define CSDM_CSDM_INT_STS_0_REG_SYNC_SER_FIFO_ERROR_SIZE                                                               16		
	#define CSDM_CSDM_INT_STS_0_REG_CFC_LOAD_RSP_ERROR                                                                     (0x1<<17)
	#define CSDM_CSDM_INT_STS_0_REG_CFC_LOAD_RSP_ERROR_SIZE                                                                17		
	#define CSDM_CSDM_INT_STS_0_REG_CFC_LOAD_PEND_ERROR                                                                    (0x1<<18)
	#define CSDM_CSDM_INT_STS_0_REG_CFC_LOAD_PEND_ERROR_SIZE                                                               18		
	#define CSDM_CSDM_INT_STS_0_REG_DST_INT_RAM_WAIT_ERROR                                                                 (0x1<<19)
	#define CSDM_CSDM_INT_STS_0_REG_DST_INT_RAM_WAIT_ERROR_SIZE                                                            19		
	#define CSDM_CSDM_INT_STS_0_REG_DST_PAS_BUF_WAIT_ERROR                                                                 (0x1<<20)
	#define CSDM_CSDM_INT_STS_0_REG_DST_PAS_BUF_WAIT_ERROR_SIZE                                                            20		
	#define CSDM_CSDM_INT_STS_0_REG_DST_PXP_CTRL_IMMED_ERROR                                                               (0x1<<21)
	#define CSDM_CSDM_INT_STS_0_REG_DST_PXP_CTRL_IMMED_ERROR_SIZE                                                          21		
	#define CSDM_CSDM_INT_STS_0_REG_DST_PB_IMMED_ERROR                                                                     (0x1<<22)
	#define CSDM_CSDM_INT_STS_0_REG_DST_PB_IMMED_ERROR_SIZE                                                                22		
	#define CSDM_CSDM_INT_STS_0_REG_DST_PXP_CTRL_DST_PEND_ERROR                                                            (0x1<<23)
	#define CSDM_CSDM_INT_STS_0_REG_DST_PXP_CTRL_DST_PEND_ERROR_SIZE                                                       23		
	#define CSDM_CSDM_INT_STS_0_REG_DST_PXP_DP_DST_PEND_ERROR                                                              (0x1<<24)
	#define CSDM_CSDM_INT_STS_0_REG_DST_PXP_DP_DST_PEND_ERROR_SIZE                                                         24		
	#define CSDM_CSDM_INT_STS_0_REG_DST_BRB1_SRC_PEND_ERROR                                                                (0x1<<25)
	#define CSDM_CSDM_INT_STS_0_REG_DST_BRB1_SRC_PEND_ERROR_SIZE                                                           25		
	#define CSDM_CSDM_INT_STS_0_REG_DST_BRB1_SRC_ADDR_ERROR                                                                (0x1<<26)
	#define CSDM_CSDM_INT_STS_0_REG_DST_BRB1_SRC_ADDR_ERROR_SIZE                                                           26		
	#define CSDM_CSDM_INT_STS_0_REG_DST_NONE_DP_DST_PEND_ERROR                                                             (0x1<<27)
	#define CSDM_CSDM_INT_STS_0_REG_DST_NONE_DP_DST_PEND_ERROR_SIZE                                                        27		
	#define CSDM_CSDM_INT_STS_0_REG_RSP_BRB1_CTRL_PEND_ERROR                                                               (0x1<<28)
	#define CSDM_CSDM_INT_STS_0_REG_RSP_BRB1_CTRL_PEND_ERROR_SIZE                                                          28		
	#define CSDM_CSDM_INT_STS_0_REG_RSP_BRB1_DP_PEND_ERROR                                                                 (0x1<<29)
	#define CSDM_CSDM_INT_STS_0_REG_RSP_BRB1_DP_PEND_ERROR_SIZE                                                            29		
	#define CSDM_CSDM_INT_STS_0_REG_RSP_BRB1_DP_DST_ERROR                                                                  (0x1<<30)
	#define CSDM_CSDM_INT_STS_0_REG_RSP_BRB1_DP_DST_ERROR_SIZE                                                             30		
	#define CSDM_CSDM_INT_STS_0_REG_RSP_INT_RAM_PEND_ERROR                                                                 (0x1<<31)
	#define CSDM_CSDM_INT_STS_0_REG_RSP_INT_RAM_PEND_ERROR_SIZE                                                            31
#define CSDM_REG_CSDM_INT_STS_CLR_0                                                                                        0xc2294UL //ACCESS:RC  DataWidth:0x20  Description: Interrupt register #0 read clear		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_ADDRESS_ERROR                                                                      (0x1<<0)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_ADDRESS_ERROR_SIZE                                                                 0		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE0_ERROR                                                                   (0x1<<1)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE0_ERROR_SIZE                                                              1		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE1_ERROR                                                                   (0x1<<2)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE1_ERROR_SIZE                                                              2		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE2_ERROR                                                                   (0x1<<3)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE2_ERROR_SIZE                                                              3		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE3_ERROR                                                                   (0x1<<4)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE3_ERROR_SIZE                                                              4		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE4_ERROR                                                                   (0x1<<5)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE4_ERROR_SIZE                                                              5		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE5_ERROR                                                                   (0x1<<6)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE5_ERROR_SIZE                                                              6		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE6_ERROR                                                                   (0x1<<7)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE6_ERROR_SIZE                                                              7		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE7_ERROR                                                                   (0x1<<8)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE7_ERROR_SIZE                                                              8		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE8_ERROR                                                                   (0x1<<9)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE8_ERROR_SIZE                                                              9		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE9_ERROR                                                                   (0x1<<10)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE9_ERROR_SIZE                                                              10		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE10_ERROR                                                                  (0x1<<11)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE10_ERROR_SIZE                                                             11		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE11_ERROR                                                                  (0x1<<12)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_INP_QUEUE11_ERROR_SIZE                                                             12		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DELAY_FIFO_ERROR                                                                   (0x1<<13)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DELAY_FIFO_ERROR_SIZE                                                              13		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_ASYNC_HOST_ERROR                                                                   (0x1<<14)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_ASYNC_HOST_ERROR_SIZE                                                              14		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_SYNC_PRS_FIFO_ERROR                                                                (0x1<<15)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_SYNC_PRS_FIFO_ERROR_SIZE                                                           15		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_SYNC_SER_FIFO_ERROR                                                                (0x1<<16)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_SYNC_SER_FIFO_ERROR_SIZE                                                           16		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_CFC_LOAD_RSP_ERROR                                                                 (0x1<<17)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_CFC_LOAD_RSP_ERROR_SIZE                                                            17		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_CFC_LOAD_PEND_ERROR                                                                (0x1<<18)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_CFC_LOAD_PEND_ERROR_SIZE                                                           18		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_INT_RAM_WAIT_ERROR                                                             (0x1<<19)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_INT_RAM_WAIT_ERROR_SIZE                                                        19		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PAS_BUF_WAIT_ERROR                                                             (0x1<<20)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PAS_BUF_WAIT_ERROR_SIZE                                                        20		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PXP_CTRL_IMMED_ERROR                                                           (0x1<<21)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PXP_CTRL_IMMED_ERROR_SIZE                                                      21		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PB_IMMED_ERROR                                                                 (0x1<<22)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PB_IMMED_ERROR_SIZE                                                            22		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PXP_CTRL_DST_PEND_ERROR                                                        (0x1<<23)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PXP_CTRL_DST_PEND_ERROR_SIZE                                                   23		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PXP_DP_DST_PEND_ERROR                                                          (0x1<<24)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_PXP_DP_DST_PEND_ERROR_SIZE                                                     24		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_BRB1_SRC_PEND_ERROR                                                            (0x1<<25)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_BRB1_SRC_PEND_ERROR_SIZE                                                       25		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_BRB1_SRC_ADDR_ERROR                                                            (0x1<<26)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_BRB1_SRC_ADDR_ERROR_SIZE                                                       26		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_NONE_DP_DST_PEND_ERROR                                                         (0x1<<27)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_DST_NONE_DP_DST_PEND_ERROR_SIZE                                                    27		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_RSP_BRB1_CTRL_PEND_ERROR                                                           (0x1<<28)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_RSP_BRB1_CTRL_PEND_ERROR_SIZE                                                      28		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_RSP_BRB1_DP_PEND_ERROR                                                             (0x1<<29)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_RSP_BRB1_DP_PEND_ERROR_SIZE                                                        29		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_RSP_BRB1_DP_DST_ERROR                                                              (0x1<<30)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_RSP_BRB1_DP_DST_ERROR_SIZE                                                         30		
	#define CSDM_CSDM_INT_STS_CLR_0_REG_RSP_INT_RAM_PEND_ERROR                                                             (0x1<<31)
	#define CSDM_CSDM_INT_STS_CLR_0_REG_RSP_INT_RAM_PEND_ERROR_SIZE                                                        31
#define CSDM_REG_CSDM_INT_STS_WR_0                                                                                         0xc2298UL //ACCESS:WR  DataWidth:0x20  Description: Interrupt register #0 bit set or clear		
	#define CSDM_CSDM_INT_STS_WR_0_REG_ADDRESS_ERROR                                                                       (0x1<<0)
	#define CSDM_CSDM_INT_STS_WR_0_REG_ADDRESS_ERROR_SIZE                                                                  0		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE0_ERROR                                                                    (0x1<<1)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE0_ERROR_SIZE                                                               1		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE1_ERROR                                                                    (0x1<<2)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE1_ERROR_SIZE                                                               2		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE2_ERROR                                                                    (0x1<<3)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE2_ERROR_SIZE                                                               3		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE3_ERROR                                                                    (0x1<<4)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE3_ERROR_SIZE                                                               4		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE4_ERROR                                                                    (0x1<<5)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE4_ERROR_SIZE                                                               5		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE5_ERROR                                                                    (0x1<<6)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE5_ERROR_SIZE                                                               6		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE6_ERROR                                                                    (0x1<<7)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE6_ERROR_SIZE                                                               7		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE7_ERROR                                                                    (0x1<<8)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE7_ERROR_SIZE                                                               8		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE8_ERROR                                                                    (0x1<<9)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE8_ERROR_SIZE                                                               9		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE9_ERROR                                                                    (0x1<<10)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE9_ERROR_SIZE                                                               10		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE10_ERROR                                                                   (0x1<<11)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE10_ERROR_SIZE                                                              11		
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE11_ERROR                                                                   (0x1<<12)
	#define CSDM_CSDM_INT_STS_WR_0_REG_INP_QUEUE11_ERROR_SIZE                                                              12		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DELAY_FIFO_ERROR                                                                    (0x1<<13)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DELAY_FIFO_ERROR_SIZE                                                               13		
	#define CSDM_CSDM_INT_STS_WR_0_REG_ASYNC_HOST_ERROR                                                                    (0x1<<14)
	#define CSDM_CSDM_INT_STS_WR_0_REG_ASYNC_HOST_ERROR_SIZE                                                               14		
	#define CSDM_CSDM_INT_STS_WR_0_REG_SYNC_PRS_FIFO_ERROR                                                                 (0x1<<15)
	#define CSDM_CSDM_INT_STS_WR_0_REG_SYNC_PRS_FIFO_ERROR_SIZE                                                            15		
	#define CSDM_CSDM_INT_STS_WR_0_REG_SYNC_SER_FIFO_ERROR                                                                 (0x1<<16)
	#define CSDM_CSDM_INT_STS_WR_0_REG_SYNC_SER_FIFO_ERROR_SIZE                                                            16		
	#define CSDM_CSDM_INT_STS_WR_0_REG_CFC_LOAD_RSP_ERROR                                                                  (0x1<<17)
	#define CSDM_CSDM_INT_STS_WR_0_REG_CFC_LOAD_RSP_ERROR_SIZE                                                             17		
	#define CSDM_CSDM_INT_STS_WR_0_REG_CFC_LOAD_PEND_ERROR                                                                 (0x1<<18)
	#define CSDM_CSDM_INT_STS_WR_0_REG_CFC_LOAD_PEND_ERROR_SIZE                                                            18		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_INT_RAM_WAIT_ERROR                                                              (0x1<<19)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_INT_RAM_WAIT_ERROR_SIZE                                                         19		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PAS_BUF_WAIT_ERROR                                                              (0x1<<20)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PAS_BUF_WAIT_ERROR_SIZE                                                         20		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PXP_CTRL_IMMED_ERROR                                                            (0x1<<21)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PXP_CTRL_IMMED_ERROR_SIZE                                                       21		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PB_IMMED_ERROR                                                                  (0x1<<22)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PB_IMMED_ERROR_SIZE                                                             22		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PXP_CTRL_DST_PEND_ERROR                                                         (0x1<<23)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PXP_CTRL_DST_PEND_ERROR_SIZE                                                    23		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PXP_DP_DST_PEND_ERROR                                                           (0x1<<24)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_PXP_DP_DST_PEND_ERROR_SIZE                                                      24		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_BRB1_SRC_PEND_ERROR                                                             (0x1<<25)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_BRB1_SRC_PEND_ERROR_SIZE                                                        25		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_BRB1_SRC_ADDR_ERROR                                                             (0x1<<26)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_BRB1_SRC_ADDR_ERROR_SIZE                                                        26		
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_NONE_DP_DST_PEND_ERROR                                                          (0x1<<27)
	#define CSDM_CSDM_INT_STS_WR_0_REG_DST_NONE_DP_DST_PEND_ERROR_SIZE                                                     27		
	#define CSDM_CSDM_INT_STS_WR_0_REG_RSP_BRB1_CTRL_PEND_ERROR                                                            (0x1<<28)
	#define CSDM_CSDM_INT_STS_WR_0_REG_RSP_BRB1_CTRL_PEND_ERROR_SIZE                                                       28		
	#define CSDM_CSDM_INT_STS_WR_0_REG_RSP_BRB1_DP_PEND_ERROR                                                              (0x1<<29)
	#define CSDM_CSDM_INT_STS_WR_0_REG_RSP_BRB1_DP_PEND_ERROR_SIZE                                                         29		
	#define CSDM_CSDM_INT_STS_WR_0_REG_RSP_BRB1_DP_DST_ERROR                                                               (0x1<<30)
	#define CSDM_CSDM_INT_STS_WR_0_REG_RSP_BRB1_DP_DST_ERROR_SIZE                                                          30		
	#define CSDM_CSDM_INT_STS_WR_0_REG_RSP_INT_RAM_PEND_ERROR                                                              (0x1<<31)
	#define CSDM_CSDM_INT_STS_WR_0_REG_RSP_INT_RAM_PEND_ERROR_SIZE                                                         31
#define CSDM_REG_CSDM_INT_MASK_0                                                                                           0xc229cUL //ACCESS:RW  DataWidth:0x20  Description: Interrupt mask register #0 read/write		
	#define CSDM_CSDM_INT_MASK_0_REG_ADDRESS_ERROR                                                                         (0x1<<0)
	#define CSDM_CSDM_INT_MASK_0_REG_ADDRESS_ERROR_SIZE                                                                    0		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE0_ERROR                                                                      (0x1<<1)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE0_ERROR_SIZE                                                                 1		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE1_ERROR                                                                      (0x1<<2)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE1_ERROR_SIZE                                                                 2		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE2_ERROR                                                                      (0x1<<3)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE2_ERROR_SIZE                                                                 3		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE3_ERROR                                                                      (0x1<<4)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE3_ERROR_SIZE                                                                 4		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE4_ERROR                                                                      (0x1<<5)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE4_ERROR_SIZE                                                                 5		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE5_ERROR                                                                      (0x1<<6)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE5_ERROR_SIZE                                                                 6		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE6_ERROR                                                                      (0x1<<7)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE6_ERROR_SIZE                                                                 7		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE7_ERROR                                                                      (0x1<<8)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE7_ERROR_SIZE                                                                 8		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE8_ERROR                                                                      (0x1<<9)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE8_ERROR_SIZE                                                                 9		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE9_ERROR                                                                      (0x1<<10)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE9_ERROR_SIZE                                                                 10		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE10_ERROR                                                                     (0x1<<11)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE10_ERROR_SIZE                                                                11		
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE11_ERROR                                                                     (0x1<<12)
	#define CSDM_CSDM_INT_MASK_0_REG_INP_QUEUE11_ERROR_SIZE                                                                12		
	#define CSDM_CSDM_INT_MASK_0_REG_DELAY_FIFO_ERROR                                                                      (0x1<<13)
	#define CSDM_CSDM_INT_MASK_0_REG_DELAY_FIFO_ERROR_SIZE                                                                 13		
	#define CSDM_CSDM_INT_MASK_0_REG_ASYNC_HOST_ERROR                                                                      (0x1<<14)
	#define CSDM_CSDM_INT_MASK_0_REG_ASYNC_HOST_ERROR_SIZE                                                                 14		
	#define CSDM_CSDM_INT_MASK_0_REG_SYNC_PRS_FIFO_ERROR                                                                   (0x1<<15)
	#define CSDM_CSDM_INT_MASK_0_REG_SYNC_PRS_FIFO_ERROR_SIZE                                                              15		
	#define CSDM_CSDM_INT_MASK_0_REG_SYNC_SER_FIFO_ERROR                                                                   (0x1<<16)
	#define CSDM_CSDM_INT_MASK_0_REG_SYNC_SER_FIFO_ERROR_SIZE                                                              16		
	#define CSDM_CSDM_INT_MASK_0_REG_CFC_LOAD_RSP_ERROR                                                                    (0x1<<17)
	#define CSDM_CSDM_INT_MASK_0_REG_CFC_LOAD_RSP_ERROR_SIZE                                                               17		
	#define CSDM_CSDM_INT_MASK_0_REG_CFC_LOAD_PEND_ERROR                                                                   (0x1<<18)
	#define CSDM_CSDM_INT_MASK_0_REG_CFC_LOAD_PEND_ERROR_SIZE                                                              18		
	#define CSDM_CSDM_INT_MASK_0_REG_DST_INT_RAM_WAIT_ERROR                                                                (0x1<<19)
	#define CSDM_CSDM_INT_MASK_0_REG_DST_INT_RAM_WAIT_ERROR_SIZE                                                           19		
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PAS_BUF_WAIT_ERROR                                                                (0x1<<20)
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PAS_BUF_WAIT_ERROR_SIZE                                                           20		
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PXP_CTRL_IMMED_ERROR                                                              (0x1<<21)
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PXP_CTRL_IMMED_ERROR_SIZE                                                         21		
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PB_IMMED_ERROR                                                                    (0x1<<22)
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PB_IMMED_ERROR_SIZE                                                               22		
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PXP_CTRL_DST_PEND_ERROR                                                           (0x1<<23)
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PXP_CTRL_DST_PEND_ERROR_SIZE                                                      23		
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PXP_DP_DST_PEND_ERROR                                                             (0x1<<24)
	#define CSDM_CSDM_INT_MASK_0_REG_DST_PXP_DP_DST_PEND_ERROR_SIZE                                                        24		
	#define CSDM_CSDM_INT_MASK_0_REG_DST_BRB1_SRC_PEND_ERROR                                                               (0x1<<25)
	#define CSDM_CSDM_INT_MASK_0_REG_DST_BRB1_SRC_PEND_ERROR_SIZE                                                          25		
	#define CSDM_CSDM_INT_MASK_0_REG_DST_BRB1_SRC_ADDR_ERROR                                                               (0x1<<26)
	#define CSDM_CSDM_INT_MASK_0_REG_DST_BRB1_SRC_ADDR_ERROR_SIZE                                                          26		
	#define CSDM_CSDM_INT_MASK_0_REG_DST_NONE_DP_DST_PEND_ERROR                                                            (0x1<<27)
	#define CSDM_CSDM_INT_MASK_0_REG_DST_NONE_DP_DST_PEND_ERROR_SIZE                                                       27		
	#define CSDM_CSDM_INT_MASK_0_REG_RSP_BRB1_CTRL_PEND_ERROR                                                              (0x1<<28)
	#define CSDM_CSDM_INT_MASK_0_REG_RSP_BRB1_CTRL_PEND_ERROR_SIZE                                                         28		
	#define CSDM_CSDM_INT_MASK_0_REG_RSP_BRB1_DP_PEND_ERROR                                                                (0x1<<29)
	#define CSDM_CSDM_INT_MASK_0_REG_RSP_BRB1_DP_PEND_ERROR_SIZE                                                           29		
	#define CSDM_CSDM_INT_MASK_0_REG_RSP_BRB1_DP_DST_ERROR                                                                 (0x1<<30)
	#define CSDM_CSDM_INT_MASK_0_REG_RSP_BRB1_DP_DST_ERROR_SIZE                                                            30		
	#define CSDM_CSDM_INT_MASK_0_REG_RSP_INT_RAM_PEND_ERROR                                                                (0x1<<31)
	#define CSDM_CSDM_INT_MASK_0_REG_RSP_INT_RAM_PEND_ERROR_SIZE                                                           31
#define CSDM_REG_CSDM_INT_STS_1                                                                                            0xc22a0UL //ACCESS:R  DataWidth:0xe  Description: Interrupt register #1 read		
	#define CSDM_CSDM_INT_STS_1_REG_RSP_PB_PEND_ERROR                                                                      (0x1<<0)
	#define CSDM_CSDM_INT_STS_1_REG_RSP_PB_PEND_ERROR_SIZE                                                                 0		
	#define CSDM_CSDM_INT_STS_1_REG_RSP_BRB1_CTRL_RD_DATA_ERROR                                                            (0x1<<1)
	#define CSDM_CSDM_INT_STS_1_REG_RSP_BRB1_CTRL_RD_DATA_ERROR_SIZE                                                       1		
	#define CSDM_CSDM_INT_STS_1_REG_RSP_BRB1_DP_RD_DATA_ERROR                                                              (0x1<<2)
	#define CSDM_CSDM_INT_STS_1_REG_RSP_BRB1_DP_RD_DATA_ERROR_SIZE                                                         2		
	#define CSDM_CSDM_INT_STS_1_REG_RSP_PB_RD_DATA_ERROR                                                                   (0x1<<3)
	#define CSDM_CSDM_INT_STS_1_REG_RSP_PB_RD_DATA_ERROR_SIZE                                                              3		
	#define CSDM_CSDM_INT_STS_1_REG_RSP_INT_RAM_RD_DATA_ERROR                                                              (0x1<<4)
	#define CSDM_CSDM_INT_STS_1_REG_RSP_INT_RAM_RD_DATA_ERROR_SIZE                                                         4		
	#define CSDM_CSDM_INT_STS_1_REG_RSP_PXP_CTRL_RD_DATA_ERROR                                                             (0x1<<5)
	#define CSDM_CSDM_INT_STS_1_REG_RSP_PXP_CTRL_RD_DATA_ERROR_SIZE                                                        5		
	#define CSDM_CSDM_INT_STS_1_REG_CM_DELAY_ERROR                                                                         (0x1<<6)
	#define CSDM_CSDM_INT_STS_1_REG_CM_DELAY_ERROR_SIZE                                                                    6		
	#define CSDM_CSDM_INT_STS_1_REG_PXP_DELAY_ERROR                                                                        (0x1<<7)
	#define CSDM_CSDM_INT_STS_1_REG_PXP_DELAY_ERROR_SIZE                                                                   7		
	#define CSDM_CSDM_INT_STS_1_REG_TIMER_ADDR_ERROR                                                                       (0x1<<8)
	#define CSDM_CSDM_INT_STS_1_REG_TIMER_ADDR_ERROR_SIZE                                                                  8		
	#define CSDM_CSDM_INT_STS_1_REG_TIMER_PEND_ERROR                                                                       (0x1<<9)
	#define CSDM_CSDM_INT_STS_1_REG_TIMER_PEND_ERROR_SIZE                                                                  9		
	#define CSDM_CSDM_INT_STS_1_REG_DORQ_DPM_ERROR                                                                         (0x1<<10)
	#define CSDM_CSDM_INT_STS_1_REG_DORQ_DPM_ERROR_SIZE                                                                    10		
	#define CSDM_CSDM_INT_STS_1_REG_DST_PXP_DP_SRC_DONE_ERROR                                                              (0x1<<11)
	#define CSDM_CSDM_INT_STS_1_REG_DST_PXP_DP_SRC_DONE_ERROR_SIZE                                                         11		
	#define CSDM_CSDM_INT_STS_1_REG_DST_PXP_DP_DST_DONE_ERROR                                                              (0x1<<12)
	#define CSDM_CSDM_INT_STS_1_REG_DST_PXP_DP_DST_DONE_ERROR_SIZE                                                         12		
	#define CSDM_CSDM_INT_STS_1_REG_DST_PXP_CTRL_DONE_ERROR                                                                (0x1<<13)
	#define CSDM_CSDM_INT_STS_1_REG_DST_PXP_CTRL_DONE_ERROR_SIZE                                                           13
#define CSDM_REG_CSDM_INT_STS_CLR_1                                                                                        0xc22a4UL //ACCESS:RC  DataWidth:0xe  Description: Interrupt register #1 read clear		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_PB_PEND_ERROR                                                                  (0x1<<0)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_PB_PEND_ERROR_SIZE                                                             0		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_BRB1_CTRL_RD_DATA_ERROR                                                        (0x1<<1)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_BRB1_CTRL_RD_DATA_ERROR_SIZE                                                   1		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_BRB1_DP_RD_DATA_ERROR                                                          (0x1<<2)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_BRB1_DP_RD_DATA_ERROR_SIZE                                                     2		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_PB_RD_DATA_ERROR                                                               (0x1<<3)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_PB_RD_DATA_ERROR_SIZE                                                          3		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_INT_RAM_RD_DATA_ERROR                                                          (0x1<<4)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_INT_RAM_RD_DATA_ERROR_SIZE                                                     4		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_PXP_CTRL_RD_DATA_ERROR                                                         (0x1<<5)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_RSP_PXP_CTRL_RD_DATA_ERROR_SIZE                                                    5		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_CM_DELAY_ERROR                                                                     (0x1<<6)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_CM_DELAY_ERROR_SIZE                                                                6		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_PXP_DELAY_ERROR                                                                    (0x1<<7)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_PXP_DELAY_ERROR_SIZE                                                               7		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_TIMER_ADDR_ERROR                                                                   (0x1<<8)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_TIMER_ADDR_ERROR_SIZE                                                              8		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_TIMER_PEND_ERROR                                                                   (0x1<<9)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_TIMER_PEND_ERROR_SIZE                                                              9		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_DORQ_DPM_ERROR                                                                     (0x1<<10)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_DORQ_DPM_ERROR_SIZE                                                                10		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_DST_PXP_DP_SRC_DONE_ERROR                                                          (0x1<<11)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_DST_PXP_DP_SRC_DONE_ERROR_SIZE                                                     11		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_DST_PXP_DP_DST_DONE_ERROR                                                          (0x1<<12)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_DST_PXP_DP_DST_DONE_ERROR_SIZE                                                     12		
	#define CSDM_CSDM_INT_STS_CLR_1_REG_DST_PXP_CTRL_DONE_ERROR                                                            (0x1<<13)
	#define CSDM_CSDM_INT_STS_CLR_1_REG_DST_PXP_CTRL_DONE_ERROR_SIZE                                                       13
#define CSDM_REG_CSDM_INT_STS_WR_1                                                                                         0xc22a8UL //ACCESS:WR  DataWidth:0xe  Description: Interrupt register #1 bit set or clear		
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_PB_PEND_ERROR                                                                   (0x1<<0)
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_PB_PEND_ERROR_SIZE                                                              0		
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_BRB1_CTRL_RD_DATA_ERROR                                                         (0x1<<1)
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_BRB1_CTRL_RD_DATA_ERROR_SIZE                                                    1		
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_BRB1_DP_RD_DATA_ERROR                                                           (0x1<<2)
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_BRB1_DP_RD_DATA_ERROR_SIZE                                                      2		
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_PB_RD_DATA_ERROR                                                                (0x1<<3)
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_PB_RD_DATA_ERROR_SIZE                                                           3		
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_INT_RAM_RD_DATA_ERROR                                                           (0x1<<4)
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_INT_RAM_RD_DATA_ERROR_SIZE                                                      4		
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_PXP_CTRL_RD_DATA_ERROR                                                          (0x1<<5)
	#define CSDM_CSDM_INT_STS_WR_1_REG_RSP_PXP_CTRL_RD_DATA_ERROR_SIZE                                                     5		
	#define CSDM_CSDM_INT_STS_WR_1_REG_CM_DELAY_ERROR                                                                      (0x1<<6)
	#define CSDM_CSDM_INT_STS_WR_1_REG_CM_DELAY_ERROR_SIZE                                                                 6		
	#define CSDM_CSDM_INT_STS_WR_1_REG_PXP_DELAY_ERROR                                                                     (0x1<<7)
	#define CSDM_CSDM_INT_STS_WR_1_REG_PXP_DELAY_ERROR_SIZE                                                                7		
	#define CSDM_CSDM_INT_STS_WR_1_REG_TIMER_ADDR_ERROR                                                                    (0x1<<8)
	#define CSDM_CSDM_INT_STS_WR_1_REG_TIMER_ADDR_ERROR_SIZE                                                               8		
	#define CSDM_CSDM_INT_STS_WR_1_REG_TIMER_PEND_ERROR                                                                    (0x1<<9)
	#define CSDM_CSDM_INT_STS_WR_1_REG_TIMER_PEND_ERROR_SIZE                                                               9		
	#define CSDM_CSDM_INT_STS_WR_1_REG_DORQ_DPM_ERROR                                                                      (0x1<<10)
	#define CSDM_CSDM_INT_STS_WR_1_REG_DORQ_DPM_ERROR_SIZE                                                                 10		
	#define CSDM_CSDM_INT_STS_WR_1_REG_DST_PXP_DP_SRC_DONE_ERROR                                                           (0x1<<11)
	#define CSDM_CSDM_INT_STS_WR_1_REG_DST_PXP_DP_SRC_DONE_ERROR_SIZE                                                      11		
	#define CSDM_CSDM_INT_STS_WR_1_REG_DST_PXP_DP_DST_DONE_ERROR                                                           (0x1<<12)
	#define CSDM_CSDM_INT_STS_WR_1_REG_DST_PXP_DP_DST_DONE_ERROR_SIZE                                                      12		
	#define CSDM_CSDM_INT_STS_WR_1_REG_DST_PXP_CTRL_DONE_ERROR                                                             (0x1<<13)
	#define CSDM_CSDM_INT_STS_WR_1_REG_DST_PXP_CTRL_DONE_ERROR_SIZE                                                        13
#define CSDM_REG_CSDM_INT_MASK_1                                                                                           0xc22acUL //ACCESS:RW  DataWidth:0xe  Description: Interrupt mask register #1 read/write		
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_PB_PEND_ERROR                                                                     (0x1<<0)
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_PB_PEND_ERROR_SIZE                                                                0		
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_BRB1_CTRL_RD_DATA_ERROR                                                           (0x1<<1)
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_BRB1_CTRL_RD_DATA_ERROR_SIZE                                                      1		
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_BRB1_DP_RD_DATA_ERROR                                                             (0x1<<2)
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_BRB1_DP_RD_DATA_ERROR_SIZE                                                        2		
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_PB_RD_DATA_ERROR                                                                  (0x1<<3)
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_PB_RD_DATA_ERROR_SIZE                                                             3		
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_INT_RAM_RD_DATA_ERROR                                                             (0x1<<4)
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_INT_RAM_RD_DATA_ERROR_SIZE                                                        4		
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_PXP_CTRL_RD_DATA_ERROR                                                            (0x1<<5)
	#define CSDM_CSDM_INT_MASK_1_REG_RSP_PXP_CTRL_RD_DATA_ERROR_SIZE                                                       5		
	#define CSDM_CSDM_INT_MASK_1_REG_CM_DELAY_ERROR                                                                        (0x1<<6)
	#define CSDM_CSDM_INT_MASK_1_REG_CM_DELAY_ERROR_SIZE                                                                   6		
	#define CSDM_CSDM_INT_MASK_1_REG_PXP_DELAY_ERROR                                                                       (0x1<<7)
	#define CSDM_CSDM_INT_MASK_1_REG_PXP_DELAY_ERROR_SIZE                                                                  7		
	#define CSDM_CSDM_INT_MASK_1_REG_TIMER_ADDR_ERROR                                                                      (0x1<<8)
	#define CSDM_CSDM_INT_MASK_1_REG_TIMER_ADDR_ERROR_SIZE                                                                 8		
	#define CSDM_CSDM_INT_MASK_1_REG_TIMER_PEND_ERROR                                                                      (0x1<<9)
	#define CSDM_CSDM_INT_MASK_1_REG_TIMER_PEND_ERROR_SIZE                                                                 9		
	#define CSDM_CSDM_INT_MASK_1_REG_DORQ_DPM_ERROR                                                                        (0x1<<10)
	#define CSDM_CSDM_INT_MASK_1_REG_DORQ_DPM_ERROR_SIZE                                                                   10		
	#define CSDM_CSDM_INT_MASK_1_REG_DST_PXP_DP_SRC_DONE_ERROR                                                             (0x1<<11)
	#define CSDM_CSDM_INT_MASK_1_REG_DST_PXP_DP_SRC_DONE_ERROR_SIZE                                                        11		
	#define CSDM_CSDM_INT_MASK_1_REG_DST_PXP_DP_DST_DONE_ERROR                                                             (0x1<<12)
	#define CSDM_CSDM_INT_MASK_1_REG_DST_PXP_DP_DST_DONE_ERROR_SIZE                                                        12		
	#define CSDM_CSDM_INT_MASK_1_REG_DST_PXP_CTRL_DONE_ERROR                                                               (0x1<<13)
	#define CSDM_CSDM_INT_MASK_1_REG_DST_PXP_CTRL_DONE_ERROR_SIZE                                                          13
#define CSDM_REG_CSDM_PRTY_STS                                                                                             0xc22b0UL //ACCESS:R  DataWidth:0xb  Description: Parity register #0 read		
	#define CSDM_CSDM_PRTY_STS_REG_PARITY                                                                                  (0x1<<0)
	#define CSDM_CSDM_PRTY_STS_REG_PARITY_SIZE                                                                             0		
	#define CSDM_CSDM_PRTY_STS_REG_TIMERS                                                                                  (0x1<<1)
	#define CSDM_CSDM_PRTY_STS_REG_TIMERS_SIZE                                                                             1		
	#define CSDM_CSDM_PRTY_STS_REG_INP_QUEUE                                                                               (0x1<<2)
	#define CSDM_CSDM_PRTY_STS_REG_INP_QUEUE_SIZE                                                                          2		
	#define CSDM_CSDM_PRTY_STS_REG_ASYNC_RD_DATA                                                                           (0x1<<3)
	#define CSDM_CSDM_PRTY_STS_REG_ASYNC_RD_DATA_SIZE                                                                      3		
	#define CSDM_CSDM_PRTY_STS_REG_BRB1_CTRL_RD_DATA                                                                       (0x1<<4)
	#define CSDM_CSDM_PRTY_STS_REG_BRB1_CTRL_RD_DATA_SIZE                                                                  4		
	#define CSDM_CSDM_PRTY_STS_REG_BRB1_DP_RD_DATA                                                                         (0x1<<5)
	#define CSDM_CSDM_PRTY_STS_REG_BRB1_DP_RD_DATA_SIZE                                                                    5		
	#define CSDM_CSDM_PRTY_STS_REG_PB_RD_DATA                                                                              (0x1<<6)
	#define CSDM_CSDM_PRTY_STS_REG_PB_RD_DATA_SIZE                                                                         6		
	#define CSDM_CSDM_PRTY_STS_REG_PXP_CTRL_RD_DATA                                                                        (0x1<<7)
	#define CSDM_CSDM_PRTY_STS_REG_PXP_CTRL_RD_DATA_SIZE                                                                   7		
	#define CSDM_CSDM_PRTY_STS_REG_INT_RAM_RD_DATA                                                                         (0x1<<8)
	#define CSDM_CSDM_PRTY_STS_REG_INT_RAM_RD_DATA_SIZE                                                                    8		
	#define CSDM_CSDM_PRTY_STS_REG_STAT_RD_DATA                                                                            (0x1<<9)
	#define CSDM_CSDM_PRTY_STS_REG_STAT_RD_DATA_SIZE                                                                       9		
	#define CSDM_CSDM_PRTY_STS_REG_CM_QUEUE_RD_DATA                                                                        (0x1<<10)
	#define CSDM_CSDM_PRTY_STS_REG_CM_QUEUE_RD_DATA_SIZE                                                                   10
#define CSDM_REG_CSDM_PRTY_STS_CLR                                                                                         0xc22b4UL //ACCESS:RC  DataWidth:0xb  Description: Parity register #0 read clear		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_PARITY                                                                              (0x1<<0)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_PARITY_SIZE                                                                         0		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_TIMERS                                                                              (0x1<<1)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_TIMERS_SIZE                                                                         1		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_INP_QUEUE                                                                           (0x1<<2)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_INP_QUEUE_SIZE                                                                      2		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_ASYNC_RD_DATA                                                                       (0x1<<3)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_ASYNC_RD_DATA_SIZE                                                                  3		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_BRB1_CTRL_RD_DATA                                                                   (0x1<<4)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_BRB1_CTRL_RD_DATA_SIZE                                                              4		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_BRB1_DP_RD_DATA                                                                     (0x1<<5)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_BRB1_DP_RD_DATA_SIZE                                                                5		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_PB_RD_DATA                                                                          (0x1<<6)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_PB_RD_DATA_SIZE                                                                     6		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_PXP_CTRL_RD_DATA                                                                    (0x1<<7)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_PXP_CTRL_RD_DATA_SIZE                                                               7		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_INT_RAM_RD_DATA                                                                     (0x1<<8)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_INT_RAM_RD_DATA_SIZE                                                                8		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_STAT_RD_DATA                                                                        (0x1<<9)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_STAT_RD_DATA_SIZE                                                                   9		
	#define CSDM_CSDM_PRTY_STS_CLR_REG_CM_QUEUE_RD_DATA                                                                    (0x1<<10)
	#define CSDM_CSDM_PRTY_STS_CLR_REG_CM_QUEUE_RD_DATA_SIZE                                                               10
#define CSDM_REG_CSDM_PRTY_STS_WR                                                                                          0xc22b8UL //ACCESS:WR  DataWidth:0xb  Description: Parity register #0 bit set or clear		
	#define CSDM_CSDM_PRTY_STS_WR_REG_PARITY                                                                               (0x1<<0)
	#define CSDM_CSDM_PRTY_STS_WR_REG_PARITY_SIZE                                                                          0		
	#define CSDM_CSDM_PRTY_STS_WR_REG_TIMERS                                                                               (0x1<<1)
	#define CSDM_CSDM_PRTY_STS_WR_REG_TIMERS_SIZE                                                                          1		
	#define CSDM_CSDM_PRTY_STS_WR_REG_INP_QUEUE                                                                            (0x1<<2)
	#define CSDM_CSDM_PRTY_STS_WR_REG_INP_QUEUE_SIZE                                                                       2		
	#define CSDM_CSDM_PRTY_STS_WR_REG_ASYNC_RD_DATA                                                                        (0x1<<3)
	#define CSDM_CSDM_PRTY_STS_WR_REG_ASYNC_RD_DATA_SIZE                                                                   3		
	#define CSDM_CSDM_PRTY_STS_WR_REG_BRB1_CTRL_RD_DATA                                                                    (0x1<<4)
	#define CSDM_CSDM_PRTY_STS_WR_REG_BRB1_CTRL_RD_DATA_SIZE                                                               4		
	#define CSDM_CSDM_PRTY_STS_WR_REG_BRB1_DP_RD_DATA                                                                      (0x1<<5)
	#define CSDM_CSDM_PRTY_STS_WR_REG_BRB1_DP_RD_DATA_SIZE                                                                 5		
	#define CSDM_CSDM_PRTY_STS_WR_REG_PB_RD_DATA                                                                           (0x1<<6)
	#define CSDM_CSDM_PRTY_STS_WR_REG_PB_RD_DATA_SIZE                                                                      6		
	#define CSDM_CSDM_PRTY_STS_WR_REG_PXP_CTRL_RD_DATA                                                                     (0x1<<7)
	#define CSDM_CSDM_PRTY_STS_WR_REG_PXP_CTRL_RD_DATA_SIZE                                                                7		
	#define CSDM_CSDM_PRTY_STS_WR_REG_INT_RAM_RD_DATA                                                                      (0x1<<8)
	#define CSDM_CSDM_PRTY_STS_WR_REG_INT_RAM_RD_DATA_SIZE                                                                 8		
	#define CSDM_CSDM_PRTY_STS_WR_REG_STAT_RD_DATA                                                                         (0x1<<9)
	#define CSDM_CSDM_PRTY_STS_WR_REG_STAT_RD_DATA_SIZE                                                                    9		
	#define CSDM_CSDM_PRTY_STS_WR_REG_CM_QUEUE_RD_DATA                                                                     (0x1<<10)
	#define CSDM_CSDM_PRTY_STS_WR_REG_CM_QUEUE_RD_DATA_SIZE                                                                10
#define CSDM_REG_CSDM_PRTY_MASK                                                                                            0xc22bcUL //ACCESS:RW  DataWidth:0xb  Description: Parity mask register #0 read/write		
	#define CSDM_CSDM_PRTY_MASK_REG_PARITY                                                                                 (0x1<<0)
	#define CSDM_CSDM_PRTY_MASK_REG_PARITY_SIZE                                                                            0		
	#define CSDM_CSDM_PRTY_MASK_REG_TIMERS                                                                                 (0x1<<1)
	#define CSDM_CSDM_PRTY_MASK_REG_TIMERS_SIZE                                                                            1		
	#define CSDM_CSDM_PRTY_MASK_REG_INP_QUEUE                                                                              (0x1<<2)
	#define CSDM_CSDM_PRTY_MASK_REG_INP_QUEUE_SIZE                                                                         2		
	#define CSDM_CSDM_PRTY_MASK_REG_ASYNC_RD_DATA                                                                          (0x1<<3)
	#define CSDM_CSDM_PRTY_MASK_REG_ASYNC_RD_DATA_SIZE                                                                     3		
	#define CSDM_CSDM_PRTY_MASK_REG_BRB1_CTRL_RD_DATA                                                                      (0x1<<4)
	#define CSDM_CSDM_PRTY_MASK_REG_BRB1_CTRL_RD_DATA_SIZE                                                                 4		
	#define CSDM_CSDM_PRTY_MASK_REG_BRB1_DP_RD_DATA                                                                        (0x1<<5)
	#define CSDM_CSDM_PRTY_MASK_REG_BRB1_DP_RD_DATA_SIZE                                                                   5		
	#define CSDM_CSDM_PRTY_MASK_REG_PB_RD_DATA                                                                             (0x1<<6)
	#define CSDM_CSDM_PRTY_MASK_REG_PB_RD_DATA_SIZE                                                                        6		
	#define CSDM_CSDM_PRTY_MASK_REG_PXP_CTRL_RD_DATA                                                                       (0x1<<7)
	#define CSDM_CSDM_PRTY_MASK_REG_PXP_CTRL_RD_DATA_SIZE                                                                  7		
	#define CSDM_CSDM_PRTY_MASK_REG_INT_RAM_RD_DATA                                                                        (0x1<<8)
	#define CSDM_CSDM_PRTY_MASK_REG_INT_RAM_RD_DATA_SIZE                                                                   8		
	#define CSDM_CSDM_PRTY_MASK_REG_STAT_RD_DATA                                                                           (0x1<<9)
	#define CSDM_CSDM_PRTY_MASK_REG_STAT_RD_DATA_SIZE                                                                      9		
	#define CSDM_CSDM_PRTY_MASK_REG_CM_QUEUE_RD_DATA                                                                       (0x1<<10)
	#define CSDM_CSDM_PRTY_MASK_REG_CM_QUEUE_RD_DATA_SIZE                                                                  10
#define CSDM_REG_CM_QUEUE_TM                                                                                               0xc22c0UL //ACCESS:RW  DataWidth:0x8  Description: TM bits  CM_QUEUE
#define CSDM_REG_INP_QUEUE_TM                                                                                              0xc22c4UL //ACCESS:RW  DataWidth:0x8  Description: TM bits  INP_QUEUE
#define CSDM_REG_FIFOS_TM                                                                                                  0xc22c8UL //ACCESS:RW  DataWidth:0x2  Description: TM bits  fifos: PXP_CTRL[1:0]
#define CSDM_REG_TIMERS_TM                                                                                                 0xc22ccUL //ACCESS:RW  DataWidth:0x5  Description: TM bits for timers sram
#define CSDM_REG_ECO_RESERVED                                                                                              0xc22d0UL //ACCESS:RW  DataWidth:0x8  Description: Reserved bits for ECO
#define CSDM_REG_CMP_COUNTER_MAX4                                                                                          0xc22d8UL //ACCESS:RW  DataWidth:0x10  Description: The maximum value of the competion counter #4
#define CSDM_REG_CMP_COUNTER_MAX5                                                                                          0xc22dcUL //ACCESS:RW  DataWidth:0x10  Description: The maximum value of the competion counter #5
#define CSDM_REG_CMP_COUNTER_MAX6                                                                                          0xc22e0UL //ACCESS:RW  DataWidth:0x10  Description: The maximum value of the competion counter #6
#define CSDM_REG_CMP_COUNTER_MAX7                                                                                          0xc22e4UL //ACCESS:RW  DataWidth:0x10  Description: The maximum value of the competion counter #7
#define CSDM_REG_AGGREG_INTERRUPT_LSB                                                                                      0xc2400UL //ACCESS:R  DataWidth:0x20  Description: lsb register of aggregated interrupt in sdm_cm block
#define CSDM_REG_AGGREG_INTERRUPT_LSB_SIZE                                                                                 1
#define CSDM_REG_AGGREG_INTERRUPT_MSB                                                                                      0xc2404UL //ACCESS:R  DataWidth:0x20  Description: msb register of aggregated interrupt  in sdm_cm block
#define CSDM_REG_AGGREG_INTERRUPT_MSB_SIZE                                                                                 1
#define CSDM_REG_ASYNC_HOST_EMPTY                                                                                          0xc2408UL //ACCESS:R  DataWidth:0x1  Description: async fifo empty in sdm_async block
#define CSDM_REG_ASYNC_HOST_EMPTY_SIZE                                                                                     1
#define CSDM_REG_ASYNC_HOST_FULL                                                                                           0xc240cUL //ACCESS:R  DataWidth:0x1  Description: async fifo full in sdm_async block
#define CSDM_REG_ASYNC_HOST_FULL_SIZE                                                                                      1
#define CSDM_REG_CFC_LOAD_PEND_EMPTY                                                                                       0xc2410UL //ACCESS:R  DataWidth:0x1  Description: cfc load pending fifo empty in sdm_dma_dst block
#define CSDM_REG_CFC_LOAD_PEND_EMPTY_SIZE                                                                                  1
#define CSDM_REG_CFC_LOAD_PEND_FULL                                                                                        0xc2414UL //ACCESS:R  DataWidth:0x1  Description: cfc load pending fifo full in sdm_cfc block
#define CSDM_REG_CFC_LOAD_PEND_FULL_SIZE                                                                                   1
#define CSDM_REG_CFC_LOAD_RSP_EMPTY                                                                                        0xc2418UL //ACCESS:R  DataWidth:0x1  Description: cfc load rsp fifo empty in sdm_dma_dst block
#define CSDM_REG_CFC_LOAD_RSP_EMPTY_SIZE                                                                                   1
#define CSDM_REG_CFC_LOAD_RSP_FULL                                                                                         0xc241cUL //ACCESS:R  DataWidth:0x1  Description: cfc load rsp fifo full in sdm_cfcblock
#define CSDM_REG_CFC_LOAD_RSP_FULL_SIZE                                                                                    1
#define CSDM_REG_CM_DELAY_EMPTY                                                                                            0xc2420UL //ACCESS:R  DataWidth:0x1  Description: cm delay fifo empty in sdm_dma_dst block
#define CSDM_REG_CM_DELAY_EMPTY_SIZE                                                                                       1
#define CSDM_REG_CM_DELAY_FULL                                                                                             0xc2424UL //ACCESS:R  DataWidth:0x1  Description: cm delay fifo full in sdm_cm block
#define CSDM_REG_CM_DELAY_FULL_SIZE                                                                                        1
#define CSDM_REG_CM_QUEUE_EMPTY                                                                                            0xc2428UL //ACCESS:R  DataWidth:0x1  Description: cm queue fifo empty in sdm_dma_dst block
#define CSDM_REG_CM_QUEUE_EMPTY_SIZE                                                                                       1
#define CSDM_REG_CM_QUEUE_FULL                                                                                             0xc242cUL //ACCESS:R  DataWidth:0x1  Description: cm queue fifo full in sdm_cm block
#define CSDM_REG_CM_QUEUE_FULL_SIZE                                                                                        1
#define CSDM_REG_DELAY_FIFO_EMPTY                                                                                          0xc2430UL //ACCESS:R  DataWidth:0x1  Description: delay FIFO  empty in sdm_inp block
#define CSDM_REG_DELAY_FIFO_EMPTY_SIZE                                                                                     1
#define CSDM_REG_DELAY_FIFO_FULL                                                                                           0xc2434UL //ACCESS:R  DataWidth:0x1  Description: delay FIFO  full in sdm_inp block
#define CSDM_REG_DELAY_FIFO_FULL_SIZE                                                                                      1
#define CSDM_REG_DST_BRB1_CTRL_SRC_ADDR_EMPTY                                                                              0xc2438UL //ACCESS:R  DataWidth:0x1  Description: brb1_ctrl_src address fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_BRB1_CTRL_SRC_ADDR_EMPTY_SIZE                                                                         1
#define CSDM_REG_DST_BRB1_CTRL_SRC_ADDR_FULL                                                                               0xc243cUL //ACCESS:R  DataWidth:0x1  Description: brb1_ctrl_src address fifo full in sdm_dma_dst block
#define CSDM_REG_DST_BRB1_CTRL_SRC_ADDR_FULL_SIZE                                                                          1
#define CSDM_REG_DST_BRB1_CTRL_SRC_PEND_EMPTY                                                                              0xc2440UL //ACCESS:R  DataWidth:0x1  Description: brb1_ctrl_src pending fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_BRB1_CTRL_SRC_PEND_EMPTY_SIZE                                                                         1
#define CSDM_REG_DST_BRB1_CTRL_SRC_PEND_FULL                                                                               0xc2444UL //ACCESS:R  DataWidth:0x1  Description: brb1_ctrl_src pending fifo full in sdm_dma_dst block
#define CSDM_REG_DST_BRB1_CTRL_SRC_PEND_FULL_SIZE                                                                          1
#define CSDM_REG_DST_INT_RAM_IF_FULL                                                                                       0xc2448UL //ACCESS:R  DataWidth:0x1  Description: int_ram if full in sdm_dma_dst block
#define CSDM_REG_DST_INT_RAM_IF_FULL_SIZE                                                                                  1
#define CSDM_REG_DST_INT_RAM_WAIT_EMPTY                                                                                    0xc244cUL //ACCESS:R  DataWidth:0x1  Description: int_ram_wait fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_INT_RAM_WAIT_EMPTY_SIZE                                                                               1
#define CSDM_REG_DST_INT_RAM_WAIT_FULL                                                                                     0xc2450UL //ACCESS:R  DataWidth:0x1  Description: int_ram_wait fifo full in sdm_dma_dst block
#define CSDM_REG_DST_INT_RAM_WAIT_FULL_SIZE                                                                                1
#define CSDM_REG_DST_NONE_PEND_EMPTY                                                                                       0xc2454UL //ACCESS:R  DataWidth:0x1  Description: none pending fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_NONE_PEND_EMPTY_SIZE                                                                                  1
#define CSDM_REG_DST_NONE_PEND_FULL                                                                                        0xc2458UL //ACCESS:R  DataWidth:0x1  Description: none pending fifo full in sdm_dma_dst block
#define CSDM_REG_DST_NONE_PEND_FULL_SIZE                                                                                   1
#define CSDM_REG_DST_PAS_BUF_IF_FULL                                                                                       0xc245cUL //ACCESS:R  DataWidth:0x1  Description: pas_buf if full in sdm_dma_dst block
#define CSDM_REG_DST_PAS_BUF_IF_FULL_SIZE                                                                                  1
#define CSDM_REG_DST_PAS_BUF_WAIT_EMPTY                                                                                    0xc2460UL //ACCESS:R  DataWidth:0x1  Description: pas_buf_wait fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_PAS_BUF_WAIT_EMPTY_SIZE                                                                               1
#define CSDM_REG_DST_PAS_BUF_WAIT_FULL                                                                                     0xc2464UL //ACCESS:R  DataWidth:0x1  Description: pas_buf_wait fifo full in sdm_dma_dst block
#define CSDM_REG_DST_PAS_BUF_WAIT_FULL_SIZE                                                                                1
#define CSDM_REG_DST_PB_IF_FULL                                                                                            0xc2468UL //ACCESS:R  DataWidth:0x1  Description: pb if full in sdm_dma_dst block
#define CSDM_REG_DST_PB_IF_FULL_SIZE                                                                                       1
#define CSDM_REG_DST_PB_IMMED_EMPTY                                                                                        0xc246cUL //ACCESS:R  DataWidth:0x1  Description: pb immediate fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_PB_IMMED_EMPTY_SIZE                                                                                   1
#define CSDM_REG_DST_PB_IMMED_FULL                                                                                         0xc2470UL //ACCESS:R  DataWidth:0x1  Description: pb immediate fifo full in sdm_dma_dst block
#define CSDM_REG_DST_PB_IMMED_FULL_SIZE                                                                                    1
#define CSDM_REG_DST_PXP_CTRL_DST_PEND_EMPTY                                                                               0xc2474UL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl_dst pending fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_PXP_CTRL_DST_PEND_EMPTY_SIZE                                                                          1
#define CSDM_REG_DST_PXP_CTRL_DST_PEND_FULL                                                                                0xc2478UL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl_dst pending fifo full in sdm_dma_dst block
#define CSDM_REG_DST_PXP_CTRL_DST_PEND_FULL_SIZE                                                                           1
#define CSDM_REG_DST_PXP_CTRL_IF_FULL                                                                                      0xc247cUL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl if full in sdm_dma_dst block
#define CSDM_REG_DST_PXP_CTRL_IF_FULL_SIZE                                                                                 1
#define CSDM_REG_DST_PXP_CTRL_IMMED_EMPTY                                                                                  0xc2480UL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl immediate fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_PXP_CTRL_IMMED_EMPTY_SIZE                                                                             1
#define CSDM_REG_DST_PXP_CTRL_IMMED_FULL                                                                                   0xc2484UL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl immediate fifo full in sdm_dma_dst block
#define CSDM_REG_DST_PXP_CTRL_IMMED_FULL_SIZE                                                                              1
#define CSDM_REG_DST_PXP_CTRL_LINK_EMPTY                                                                                   0xc2488UL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl link list empty in sdm_dma_dst block
#define CSDM_REG_DST_PXP_CTRL_LINK_EMPTY_SIZE                                                                              1
#define CSDM_REG_DST_PXP_CTRL_LINK_FULL                                                                                    0xc248cUL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl link list full in sdm_dma_dst block
#define CSDM_REG_DST_PXP_CTRL_LINK_FULL_SIZE                                                                               1
#define CSDM_REG_DST_PXP_CTRL_SRC_PEND_EMPTY                                                                               0xc2490UL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl_src pending fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_PXP_CTRL_SRC_PEND_EMPTY_SIZE                                                                          1
#define CSDM_REG_DST_PXP_CTRL_SRC_PEND_FULL                                                                                0xc2494UL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl_src pending fifo full in sdm_dma_dst block
#define CSDM_REG_DST_PXP_CTRL_SRC_PEND_FULL_SIZE                                                                           1
#define CSDM_REG_DST_PXP_DP_DST_PEND_EMPTY                                                                                 0xc2498UL //ACCESS:R  DataWidth:0x1  Description: pxp_dp_dst pending fifo empty in sdm_dma_dst block
#define CSDM_REG_DST_PXP_DP_DST_PEND_EMPTY_SIZE                                                                            1
#define CSDM_REG_DST_PXP_DP_DST_PEND_FULL                                                                                  0xc249cUL //ACCESS:R  DataWidth:0x1  Description: pxp_dp_dst pending fifo full in sdm_dma_dst block
#define CSDM_REG_DST_PXP_DP_DST_PEND_FULL_SIZE                                                                             1
#define CSDM_REG_DST_PXP_DP_IF_FULL                                                                                        0xc24a0UL //ACCESS:R  DataWidth:0x1  Description: pxp_dp if full in sdm_dma_dst block
#define CSDM_REG_DST_PXP_DP_IF_FULL_SIZE                                                                                   1
#define CSDM_REG_DST_PXP_DP_LINK_EMPTY                                                                                     0xc24a4UL //ACCESS:R  DataWidth:0x1  Description: pxp_dp link list empty in sdm_dma_dst block
#define CSDM_REG_DST_PXP_DP_LINK_EMPTY_SIZE                                                                                1
#define CSDM_REG_DST_PXP_DP_LINK_FULL                                                                                      0xc24a8UL //ACCESS:R  DataWidth:0x1  Description: pxp_dp link list full in sdm_dma_dst block
#define CSDM_REG_DST_PXP_DP_LINK_FULL_SIZE                                                                                 1
#define CSDM_REG_INIT_CREDIT_CFC_ACDEC                                                                                     0xc24acUL //ACCESS:RW  DataWidth:0x4  Description: The initial number of messages that can be sent to the CFC activity counters interface without receiving any ACK
#define CSDM_REG_INIT_CREDIT_CFC_ACDEC_SIZE                                                                                1
#define CSDM_REG_INIT_CREDIT_CFC_ACINC                                                                                     0xc24b0UL //ACCESS:RW  DataWidth:0x4  Description: The initial number of messages that can be sent to the CFC activity counters interface without receiving any ACK.
#define CSDM_REG_INIT_CREDIT_CFC_ACINC_SIZE                                                                                1
#define CSDM_REG_INIT_CREDIT_CFC_LOAD                                                                                      0xc24b4UL //ACCESS:RW  DataWidth:0x4  Description: The initial number of messages that can be sent to the CFC load interface without receiving any ACK.
#define CSDM_REG_INIT_CREDIT_CFC_LOAD_SIZE                                                                                 1
#define CSDM_REG_INIT_CREDIT_CM                                                                                            0xc24b8UL //ACCESS:RW  DataWidth:0x4  Description: The initial number of cycles that can be sent to the CM  interface without receiving any ACK in CM block
#define CSDM_REG_INIT_CREDIT_CM_SIZE                                                                                       1
#define CSDM_REG_INIT_CREDIT_PXP_CTRL                                                                                      0xc24bcUL //ACCESS:RW  DataWidth:0x4  Description: The initial number of messages that can be sent to the pxp control interface without receiving any ACK.
#define CSDM_REG_INIT_CREDIT_PXP_CTRL_SIZE                                                                                 1
#define CSDM_REG_INT_RAM_RR_REQ                                                                                            0xc24c0UL //ACCESS:R  DataWidth:0x6  Description: round robin for int_ram arbiter: b0-pas_buf; b1-int_ram;b2-pxp_dp;b3-pxp_ctrl;b4-brb1_ctrl;b5-brb1_dp;
#define CSDM_REG_INT_RAM_RR_REQ_SIZE                                                                                       1
#define CSDM_REG_OPERATION_GEN                                                                                             0xc24c4UL //ACCESS:W  DataWidth:0x11  Description: Generate an operation after completion; bit-16 is AggVectIdx_valid; bits 15:8 are AggVectIdx; bits 7:5 are the TRIG and bits 4:0 are the T124Param[4:0]
#define CSDM_REG_OPERATION_GEN_SIZE                                                                                        1
#define CSDM_REG_PB_FULL                                                                                                   0xc24c8UL //ACCESS:R  DataWidth:0x1  Description: UPB IF  full in sdm_inp block
#define CSDM_REG_PB_FULL_SIZE                                                                                              1
#define CSDM_REG_PBF_FULL                                                                                                  0xc24ccUL //ACCESS:R  DataWidth:0x1  Description: PBF if  full in sdm_inp block
#define CSDM_REG_PBF_FULL_SIZE                                                                                             1
#define CSDM_REG_PXP_DELAY_EMPTY                                                                                           0xc24d0UL //ACCESS:R  DataWidth:0x1  Description: pxp switch delay fifo empty in sdm_dma_dst block
#define CSDM_REG_PXP_DELAY_EMPTY_SIZE                                                                                      1
#define CSDM_REG_PXP_DELAY_FULL                                                                                            0xc24d4UL //ACCESS:R  DataWidth:0x1  Description: pxp switch delay fifo full in sdm_cm block
#define CSDM_REG_PXP_DELAY_FULL_SIZE                                                                                       1
#define CSDM_REG_QM_FULL                                                                                                   0xc24d8UL //ACCESS:R  DataWidth:0x1  Description: QM IF  full in sdm_inp block
#define CSDM_REG_QM_FULL_SIZE                                                                                              1
#define CSDM_REG_QUEUE_EMPTY                                                                                               0xc24dcUL //ACCESS:R  DataWidth:0xc  Description: Input queue fifo empty in sdm_inp block
#define CSDM_REG_QUEUE_EMPTY_SIZE                                                                                          1
#define CSDM_REG_QUEUE_FULL                                                                                                0xc24e0UL //ACCESS:R  DataWidth:0xc  Description: Input queue fifo full in sdm_inp block
#define CSDM_REG_QUEUE_FULL_SIZE                                                                                           1
#define CSDM_REG_RR_CNT_COUNTERS_STATUS                                                                                    0xc24e4UL //ACCESS:R  DataWidth:0x15  Description: round robin for all completion counters
#define CSDM_REG_RR_CNT_COUNTERS_STATUS_SIZE                                                                               1
#define CSDM_REG_RR_COMPLETE_REQ                                                                                           0xc24e8UL //ACCESS:R  DataWidth:0x7  Description: round robin for all completion requests  in sdm_cm block: b0-async b1-nop;b2-pxp_int; b3-timers;b4-dma;b5-grc;b6-rbc
#define CSDM_REG_RR_COMPLETE_REQ_SIZE                                                                                      1
#define CSDM_REG_RR_PTR_REQ                                                                                                0xc24ecUL //ACCESS:R  DataWidth:0x7  Description: round robin for cm pointer: b0-async; b1-dma_dp; b2 - dma_ctrl; b3-cfc; b4-nop; b5-timers; b6-pxp_int
#define CSDM_REG_RR_PTR_REQ_SIZE                                                                                           1
#define CSDM_REG_RSP_BRB1_CTRL_IF_FULL                                                                                     0xc24f0UL //ACCESS:R  DataWidth:0x1  Description: brb1_ctrl if is  full in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_CTRL_IF_FULL_SIZE                                                                                1
#define CSDM_REG_RSP_BRB1_CTRL_PEND_EMPTY                                                                                  0xc24f4UL //ACCESS:R  DataWidth:0x1  Description: brb1_ctrl pending fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_CTRL_PEND_EMPTY_SIZE                                                                             1
#define CSDM_REG_RSP_BRB1_CTRL_PEND_FULL                                                                                   0xc24f8UL //ACCESS:R  DataWidth:0x1  Description: brb1_ctrl pending fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_CTRL_PEND_FULL_SIZE                                                                              1
#define CSDM_REG_RSP_BRB1_CTRL_RDATA_EMPTY                                                                                 0xc24fcUL //ACCESS:R  DataWidth:0x1  Description: brb1_ctrl rd_data fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_CTRL_RDATA_EMPTY_SIZE                                                                            1
#define CSDM_REG_RSP_BRB1_CTRL_RDATA_FULL                                                                                  0xc2500UL //ACCESS:R  DataWidth:0x1  Description: brb1_ctrl rd_data fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_CTRL_RDATA_FULL_SIZE                                                                             1
#define CSDM_REG_RSP_BRB1_DP_DST_EMPTY                                                                                     0xc2504UL //ACCESS:R  DataWidth:0x1  Description: brb1_dp pending dst fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_DP_DST_EMPTY_SIZE                                                                                1
#define CSDM_REG_RSP_BRB1_DP_DST_FULL                                                                                      0xc2508UL //ACCESS:R  DataWidth:0x1  Description: brb1_dp pending dst fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_DP_DST_FULL_SIZE                                                                                 1
#define CSDM_REG_RSP_BRB1_DP_IF_FULL                                                                                       0xc250cUL //ACCESS:R  DataWidth:0x1  Description: brb1_dp if is  full in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_DP_IF_FULL_SIZE                                                                                  1
#define CSDM_REG_RSP_BRB1_DP_PEND_EMPTY                                                                                    0xc2510UL //ACCESS:R  DataWidth:0x1  Description: brb1_dp pending fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_DP_PEND_EMPTY_SIZE                                                                               1
#define CSDM_REG_RSP_BRB1_DP_PEND_FULL                                                                                     0xc2514UL //ACCESS:R  DataWidth:0x1  Description: brb1_dp pending fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_DP_PEND_FULL_SIZE                                                                                1
#define CSDM_REG_RSP_BRB1_DP_RDATA_EMPTY                                                                                   0xc2518UL //ACCESS:R  DataWidth:0x1  Description: brb1_dp rd_data fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_DP_RDATA_EMPTY_SIZE                                                                              1
#define CSDM_REG_RSP_BRB1_DP_RDATA_FULL                                                                                    0xc251cUL //ACCESS:R  DataWidth:0x1  Description: brb1_dp rd_data fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_BRB1_DP_RDATA_FULL_SIZE                                                                               1
#define CSDM_REG_RSP_INT_RAM_PEND_EMPTY                                                                                    0xc2520UL //ACCESS:R  DataWidth:0x1  Description: int_ram pending fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_INT_RAM_PEND_EMPTY_SIZE                                                                               1
#define CSDM_REG_RSP_INT_RAM_PEND_FULL                                                                                     0xc2524UL //ACCESS:R  DataWidth:0x1  Description: int_ram pending fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_INT_RAM_PEND_FULL_SIZE                                                                                1
#define CSDM_REG_RSP_INT_RAM_RDATA_EMPTY                                                                                   0xc2528UL //ACCESS:R  DataWidth:0x1  Description: int_ram rd_data fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_INT_RAM_RDATA_EMPTY_SIZE                                                                              1
#define CSDM_REG_RSP_INT_RAM_RDATA_FULL                                                                                    0xc252cUL //ACCESS:R  DataWidth:0x1  Description: int_ram rd_data fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_INT_RAM_RDATA_FULL_SIZE                                                                               1
#define CSDM_REG_RSP_PB_IF_FULL                                                                                            0xc2530UL //ACCESS:R  DataWidth:0x1  Description: pb if is  full in sdm_dma_rsp block
#define CSDM_REG_RSP_PB_IF_FULL_SIZE                                                                                       1
#define CSDM_REG_RSP_PB_PEND_EMPTY                                                                                         0xc2534UL //ACCESS:R  DataWidth:0x1  Description: pb pending fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_PB_PEND_EMPTY_SIZE                                                                                    1
#define CSDM_REG_RSP_PB_PEND_FULL                                                                                          0xc2538UL //ACCESS:R  DataWidth:0x1  Description: pb pending fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_PB_PEND_FULL_SIZE                                                                                     1
#define CSDM_REG_RSP_PB_RDATA_EMPTY                                                                                        0xc253cUL //ACCESS:R  DataWidth:0x1  Description: pb rd_data fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_PB_RDATA_EMPTY_SIZE                                                                                   1
#define CSDM_REG_RSP_PB_RDATA_FULL                                                                                         0xc2540UL //ACCESS:R  DataWidth:0x1  Description: pb rd_data fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_PB_RDATA_FULL_SIZE                                                                                    1
#define CSDM_REG_RSP_PXP_CTRL_IF_FULL                                                                                      0xc2544UL //ACCESS:R  DataWidth:0x1  Description: pb if is  full in sdm_dma_rsp block
#define CSDM_REG_RSP_PXP_CTRL_IF_FULL_SIZE                                                                                 1
#define CSDM_REG_RSP_PXP_CTRL_RDATA_EMPTY                                                                                  0xc2548UL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl rd_data fifo  empty in sdm_dma_rsp block
#define CSDM_REG_RSP_PXP_CTRL_RDATA_EMPTY_SIZE                                                                             1
#define CSDM_REG_RSP_PXP_CTRL_RDATA_FULL                                                                                   0xc254cUL //ACCESS:R  DataWidth:0x1  Description: pxp_ctrl rd_data fifo  full in sdm_dma_rsp block
#define CSDM_REG_RSP_PXP_CTRL_RDATA_FULL_SIZE                                                                              1
#define CSDM_REG_SYNC_PARSER_EMPTY                                                                                         0xc2550UL //ACCESS:R  DataWidth:0x1  Description: parser fifo  empty in sdm_sync block
#define CSDM_REG_SYNC_PARSER_EMPTY_SIZE                                                                                    1
#define CSDM_REG_SYNC_PARSER_FULL                                                                                          0xc2554UL //ACCESS:R  DataWidth:0x1  Description: parser fifo  full in sdm_sync block
#define CSDM_REG_SYNC_PARSER_FULL_SIZE                                                                                     1
#define CSDM_REG_SYNC_SYNC_EMPTY                                                                                           0xc2558UL //ACCESS:R  DataWidth:0x1  Description: parser serial fifo  empty in sdm_sync block
#define CSDM_REG_SYNC_SYNC_EMPTY_SIZE                                                                                      1
#define CSDM_REG_SYNC_SYNC_FULL                                                                                            0xc255cUL //ACCESS:R  DataWidth:0x1  Description: parser serial fifo  full in sdm_sync block
#define CSDM_REG_SYNC_SYNC_FULL_SIZE                                                                                       1
#define CSDM_REG_TIMERS_ADDR_EMPTY                                                                                         0xc2560UL //ACCESS:R  DataWidth:0x1  Description: address FIFO  empty in sdm_timers block
#define CSDM_REG_TIMERS_ADDR_EMPTY_SIZE                                                                                    1
#define CSDM_REG_TIMERS_ADDR_FULL                                                                                          0xc2564UL //ACCESS:R  DataWidth:0x1  Description: address FIFO  full in sdm_timers block
#define CSDM_REG_TIMERS_ADDR_FULL_SIZE                                                                                     1
#define CSDM_REG_TIMERS_PEND_EMPTY                                                                                         0xc2568UL //ACCESS:R  DataWidth:0x1  Description: pending FIFO  empty in sdm_timers block
#define CSDM_REG_TIMERS_PEND_EMPTY_SIZE                                                                                    1
#define CSDM_REG_TIMERS_PEND_FULL                                                                                          0xc256cUL //ACCESS:R  DataWidth:0x1  Description: pending FIFO  full in sdm_timers block
#define CSDM_REG_TIMERS_PEND_FULL_SIZE                                                                                     1
#define CSDM_REG_STATISTICS                                                                                                0xc2600UL //ACCESS:RW  DataWidth:0x20  Description: Statistics memory. Each read from RBC resets the corresponding statistic counter
#define CSDM_REG_STATISTICS_SIZE                                                                                           48
#define CSDM_REG_TIMERS                                                                                                    0xc2800UL //ACCESS:WB  DataWidth:0x34  Description: Debug only. Timers memory.
#define CSDM_REG_TIMERS_SIZE                                                                                               380
#define CSDM_REG_CM_QUEUE                                                                                                  0xc3000UL //ACCESS:WB  DataWidth:0x40  Description: Debug only. CM queue memory. 
#define CSDM_REG_CM_QUEUE_SIZE                                                                                             512
#define CSDM_REG_INP_QUEUE                                                                                                 0xc3800UL //ACCESS:WB  DataWidth:0x40  Description: Debug only. Input queue memory.
#define CSDM_REG_INP_QUEUE_SIZE                                                                                            352
#define CSDM_REG_CSDM_UNUSED_EMPTY_0                                                                                       0xc22d4UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSDM_REG_CSDM_UNUSED_EMPTY_0_SIZE                                                                                  1
#define CSDM_REG_CSDM_UNUSED_EMPTY_1                                                                                       0xc22e8UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSDM_REG_CSDM_UNUSED_EMPTY_1_SIZE                                                                                  70
#define CSDM_REG_CSDM_UNUSED_EMPTY_2                                                                                       0xc2570UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSDM_REG_CSDM_UNUSED_EMPTY_2_SIZE                                                                                  36
#define CSDM_REG_CSDM_UNUSED_EMPTY_3                                                                                       0xc2700UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSDM_REG_CSDM_UNUSED_EMPTY_3_SIZE                                                                                  64
#define CSEM_REG_MSG_NUM_FIC0                                                                                              0x200000UL //ACCESS:ST  DataWidth:0x18  Description: Statistics register. The number of messages that entered through FIC0 
#define CSEM_REG_MSG_NUM_FIC1                                                                                              0x200004UL //ACCESS:ST  DataWidth:0x18  Description: Statistics register. The number of messages that entered through FIC1 
#define CSEM_REG_MSG_NUM_FOC0                                                                                              0x200008UL //ACCESS:ST  DataWidth:0x18  Description: Statistics register. The number of messages that were sent to FOC0 
#define CSEM_REG_MSG_NUM_FOC1                                                                                              0x20000cUL //ACCESS:ST  DataWidth:0x18  Description: Statistics register. The number of messages that were sent to FOC1 
#define CSEM_REG_MSG_NUM_FOC2                                                                                              0x200010UL //ACCESS:ST  DataWidth:0x18  Description: Statistics register. The number of messages that were sent to FOC2 
#define CSEM_REG_MSG_NUM_FOC3                                                                                              0x200014UL //ACCESS:ST  DataWidth:0x18  Description: Statistics register. The number of messages that were sent to FOC3
#define CSEM_REG_THREAD_INTER_CNT_ENABLE                                                                                   0x200018UL //ACCESS:RW  DataWidth:0x1  Description: Enable for start count of counter ~csem_registers_thread_inter_cnt.thread_inter_cnt
#define CSEM_REG_THREAD_INTER_CNT                                                                                          0x20001cUL //ACCESS:RW  DataWidth:0x10  Description: Maximum value of threads interrupt counter; when it gets this value then interrupt to will be send if thread active from previous maximum value of this counter. This register may be used only when ~csem_registers_thread_inter_cnt_enable.thread_inter_cnt_enable =1
#define CSEM_REG_ARB_ELEMENT0                                                                                              0x200020UL //ACCESS:RW  DataWidth:0x3  Description: The source that is associated with arbitration element 0. Source decoding is: 0- foc0; 1-fic1; 2-sleeping thread with priority 0; 3- sleeping thread with priority 1; 4- sleeping thread with priority 2
#define CSEM_REG_ARB_ELEMENT1                                                                                              0x200024UL //ACCESS:RW  DataWidth:0x3  Description: The source that is associated with arbitration element 1. Source decoding is: 0- foc0; 1-fic1; 2-sleeping thread with priority 0; 3- sleeping thread with priority 1; 4- sleeping thread with priority 2. Could not be equal to register ~csem_registers_arb_element0.arb_element0
#define CSEM_REG_ARB_ELEMENT2                                                                                              0x200028UL //ACCESS:RW  DataWidth:0x3  Description: The source that is associated with arbitration element 2. Source decoding is: 0- foc0; 1-fic1; 2-sleeping thread with priority 0; 3- sleeping thread with priority 1; 4- sleeping thread with priority 2. Could not be equal to register ~csem_registers_arb_element0.arb_element0 and ~csem_registers_arb_element1.arb_element1
#define CSEM_REG_ARB_ELEMENT3                                                                                              0x20002cUL //ACCESS:RW  DataWidth:0x3  Description: The source that is associated with arbitration element 3. Source decoding is: 0- foc0; 1-fic1; 2-sleeping thread with priority 0; 3- sleeping thread with priority 1; 4- sleeping thread with priority 2.Could not be equal to register ~csem_registers_arb_element0.arb_element0 and ~csem_registers_arb_element1.arb_element1 and ~csem_registers_arb_element2.arb_element2
#define CSEM_REG_ARB_ELEMENT4                                                                                              0x200030UL //ACCESS:RW  DataWidth:0x3  Description: The source that is associated with arbitration element 4. Source decoding is: 0- foc0; 1-fic1; 2-sleeping thread with priority 0; 3- sleeping thread with priority 1; 4- sleeping thread with priority 2. Could not be equal to register ~csem_registers_arb_element0.arb_element0 and ~csem_registers_arb_element1.arb_element1 and ~csem_registers_arb_element2.arb_element2 and ~csem_registers_arb_element3.arb_element3
#define CSEM_REG_ARB_CYCLE_SIZE                                                                                            0x200034UL //ACCESS:RW  DataWidth:0x5  Description: The number of time_slots in the arbitration cycle 
#define CSEM_REG_TS_0_AS                                                                                                   0x200038UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 0
#define CSEM_REG_TS_1_AS                                                                                                   0x20003cUL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 1
#define CSEM_REG_TS_2_AS                                                                                                   0x200040UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 2
#define CSEM_REG_TS_3_AS                                                                                                   0x200044UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 3
#define CSEM_REG_TS_4_AS                                                                                                   0x200048UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 4
#define CSEM_REG_TS_5_AS                                                                                                   0x20004cUL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 5
#define CSEM_REG_TS_6_AS                                                                                                   0x200050UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 6
#define CSEM_REG_TS_7_AS                                                                                                   0x200054UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 7
#define CSEM_REG_TS_8_AS                                                                                                   0x200058UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 8
#define CSEM_REG_TS_9_AS                                                                                                   0x20005cUL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 9
#define CSEM_REG_TS_10_AS                                                                                                  0x200060UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 10
#define CSEM_REG_TS_11_AS                                                                                                  0x200064UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 11
#define CSEM_REG_TS_12_AS                                                                                                  0x200068UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 12
#define CSEM_REG_TS_13_AS                                                                                                  0x20006cUL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 13
#define CSEM_REG_TS_14_AS                                                                                                  0x200070UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 14
#define CSEM_REG_TS_15_AS                                                                                                  0x200074UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 15
#define CSEM_REG_TS_16_AS                                                                                                  0x200078UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 16
#define CSEM_REG_TS_17_AS                                                                                                  0x20007cUL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 17
#define CSEM_REG_TS_18_AS                                                                                                  0x200080UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 18
#define CSEM_REG_TS_19_AS                                                                                                  0x200084UL //ACCESS:RW  DataWidth:0x3  Description: The arbitration scheme of time_slot 19
#define CSEM_REG_FIC0_MIN_MSG_LINES                                                                                        0x200088UL //ACCESS:RW  DataWidth:0x6  Description: The minimum number of cycles in a message from FIC0 interfaces after which the message can be sent to the passive register_file. It must be always equal to 2; other way it may cause to deadlock in a chip.
#define CSEM_REG_FIC1_MIN_MSG_LINES                                                                                        0x20008cUL //ACCESS:RW  DataWidth:0x6  Description: The minimum number of cycles in a message from FIC1 interfaces after which the message can be sent to the passive register_file. It must be always equal to 2; other way it may cause to deadlock in a chip.
#define CSEM_REG_PASSIVE_ALM_FULL                                                                                          0x200090UL //ACCESS:RW  DataWidth:0x5  Description: The number of free entries in the sync FIFO between the external HW and the passive buffer; below which the PassiveFull is asserted 
#define CSEM_REG_SYNC_DRA_WR_ALM_FULL                                                                                      0x200094UL //ACCESS:RW  DataWidth:0x5  Description: Almost full for sync dra_wr fifo (data from DRA to STORM)
#define CSEM_REG_SYNC_RAM_WR_ALM_FULL                                                                                      0x200098UL //ACCESS:RW  DataWidth:0x6  Description: Almost full for sync ram_wr fifo (data from EXT_IF to STORM)
#define CSEM_REG_DBG_ALM_FULL                                                                                              0x20009cUL //ACCESS:RW  DataWidth:0x6  Description: Almost full for slow debug fifo 
#define CSEM_REG_EXCEPTION_INT                                                                                             0x2000a0UL //ACCESS:RW  DataWidth:0xf  Description: The PRAM address for the interrupt in a case the event ID is bigger then the INT table size. This register is always NA; because this feature is removed
#define CSEM_REG_ENABLE_IN                                                                                                 0x2000a4UL //ACCESS:RW  DataWidth:0xf  Multi Field Register		
	#define CSEM_ENABLE_IN_REG_FIC0_ENABLE_IN                                                                              (0x1<<0)
	#define CSEM_ENABLE_IN_REG_FIC0_ENABLE_IN_SIZE                                                                         0		
	#define CSEM_ENABLE_IN_REG_FIC1_ENABLE_IN                                                                              (0x1<<1)
	#define CSEM_ENABLE_IN_REG_FIC1_ENABLE_IN_SIZE                                                                         1		
	#define CSEM_ENABLE_IN_REG_PASSIVE_ENABLE_IN                                                                           (0x1<<2)
	#define CSEM_ENABLE_IN_REG_PASSIVE_ENABLE_IN_SIZE                                                                      2		
	#define CSEM_ENABLE_IN_REG_GENERAL_ENABLE_IN                                                                           (0x1<<3)
	#define CSEM_ENABLE_IN_REG_GENERAL_ENABLE_IN_SIZE                                                                      3		
	#define CSEM_ENABLE_IN_REG_THREAD_RDY_ENABLE_IN                                                                        (0x1<<4)
	#define CSEM_ENABLE_IN_REG_THREAD_RDY_ENABLE_IN_SIZE                                                                   4		
	#define CSEM_ENABLE_IN_REG_EXT_RD_DATA_ENABLE_IN                                                                       (0x1<<5)
	#define CSEM_ENABLE_IN_REG_EXT_RD_DATA_ENABLE_IN_SIZE                                                                  5		
	#define CSEM_ENABLE_IN_REG_EXT_FULL_ENABLE_IN                                                                          (0x1<<6)
	#define CSEM_ENABLE_IN_REG_EXT_FULL_ENABLE_IN_SIZE                                                                     6		
	#define CSEM_ENABLE_IN_REG_RAM0_ENABLE_IN                                                                              (0x1<<7)
	#define CSEM_ENABLE_IN_REG_RAM0_ENABLE_IN_SIZE                                                                         7		
	#define CSEM_ENABLE_IN_REG_RAM1_ENABLE_IN                                                                              (0x1<<8)
	#define CSEM_ENABLE_IN_REG_RAM1_ENABLE_IN_SIZE                                                                         8		
	#define CSEM_ENABLE_IN_REG_FOC0_ACK_ENABLE_IN                                                                          (0x1<<9)
	#define CSEM_ENABLE_IN_REG_FOC0_ACK_ENABLE_IN_SIZE                                                                     9		
	#define CSEM_ENABLE_IN_REG_FOC1_ACK_ENABLE_IN                                                                          (0x1<<10)
	#define CSEM_ENABLE_IN_REG_FOC1_ACK_ENABLE_IN_SIZE                                                                     10		
	#define CSEM_ENABLE_IN_REG_FOC2_ACK_ENABLE_IN                                                                          (0x1<<11)
	#define CSEM_ENABLE_IN_REG_FOC2_ACK_ENABLE_IN_SIZE                                                                     11		
	#define CSEM_ENABLE_IN_REG_FOC3_ACK_ENABLE_IN                                                                          (0x1<<12)
	#define CSEM_ENABLE_IN_REG_FOC3_ACK_ENABLE_IN_SIZE                                                                     12		
	#define CSEM_ENABLE_IN_REG_WAITP_ENABLE_IN                                                                             (0x1<<13)
	#define CSEM_ENABLE_IN_REG_WAITP_ENABLE_IN_SIZE                                                                        13		
	#define CSEM_ENABLE_IN_REG_VFPF_ERROR_ENABLE_IN                                                                        (0x1<<14)
	#define CSEM_ENABLE_IN_REG_VFPF_ERROR_ENABLE_IN_SIZE                                                                   14
#define CSEM_REG_ENABLE_OUT                                                                                                0x2000a8UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define CSEM_ENABLE_OUT_REG_EXT_RD_REQ_ENABLE_OUT                                                                      (0x1<<0)
	#define CSEM_ENABLE_OUT_REG_EXT_RD_REQ_ENABLE_OUT_SIZE                                                                 0		
	#define CSEM_ENABLE_OUT_REG_EXT_WR_REQ_ENABLE_OUT                                                                      (0x1<<1)
	#define CSEM_ENABLE_OUT_REG_EXT_WR_REQ_ENABLE_OUT_SIZE                                                                 1		
	#define CSEM_ENABLE_OUT_REG_FOC0_ENABLE_OUT                                                                            (0x1<<2)
	#define CSEM_ENABLE_OUT_REG_FOC0_ENABLE_OUT_SIZE                                                                       2		
	#define CSEM_ENABLE_OUT_REG_FOC1_ENABLE_OUT                                                                            (0x1<<3)
	#define CSEM_ENABLE_OUT_REG_FOC1_ENABLE_OUT_SIZE                                                                       3		
	#define CSEM_ENABLE_OUT_REG_FOC2_ENABLE_OUT                                                                            (0x1<<4)
	#define CSEM_ENABLE_OUT_REG_FOC2_ENABLE_OUT_SIZE                                                                       4		
	#define CSEM_ENABLE_OUT_REG_FOC3_ENABLE_OUT                                                                            (0x1<<5)
	#define CSEM_ENABLE_OUT_REG_FOC3_ENABLE_OUT_SIZE                                                                       5		
	#define CSEM_ENABLE_OUT_REG_PASSIVE_ENABLE_OUT                                                                         (0x1<<6)
	#define CSEM_ENABLE_OUT_REG_PASSIVE_ENABLE_OUT_SIZE                                                                    6		
	#define CSEM_ENABLE_OUT_REG_RAM0_ENABLE_OUT                                                                            (0x1<<7)
	#define CSEM_ENABLE_OUT_REG_RAM0_ENABLE_OUT_SIZE                                                                       7		
	#define CSEM_ENABLE_OUT_REG_RAM1_ENABLE_OUT                                                                            (0x1<<8)
	#define CSEM_ENABLE_OUT_REG_RAM1_ENABLE_OUT_SIZE                                                                       8		
	#define CSEM_ENABLE_OUT_REG_WAITP_ENABLE_OUT                                                                           (0x1<<9)
	#define CSEM_ENABLE_OUT_REG_WAITP_ENABLE_OUT_SIZE                                                                      9
#define CSEM_REG_STORM0_H_TM                                                                                               0x2000acUL //ACCESS:RW  DataWidth:0x5  Description: TM bits for storm0_h memory instance
#define CSEM_REG_STORM1_H_TM                                                                                               0x2000b0UL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for storm1_h memory instance
#define CSEM_REG_STORM0_L_TM                                                                                               0x2000b4UL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for storm0_l memory instance
#define CSEM_REG_STORM1_L_TM                                                                                               0x2000b8UL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for storm1_l memory instance
#define CSEM_REG_CAM_TM                                                                                                    0x2000bcUL //ACCESS:RW  DataWidth:0xe  Description: TM bits  for cam
#define CSEM_REG_RAM0_TM                                                                                                   0x2000c0UL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for memory ram0_0
#define CSEM_REG_PAS_BUF_LSB_TMA                                                                                           0x2000c4UL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for memory pas_buf_lsb
#define CSEM_REG_PAS_BUF_LSB_TMB                                                                                           0x2000c8UL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for memory pas_buf_lsb
#define CSEM_REG_PAS_BUF_MSB_TMA                                                                                           0x2000ccUL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for memory pas_buf_msb
#define CSEM_REG_PAS_BUF_MSB_TMB                                                                                           0x2000d0UL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for memory pas_buf_msb
#define CSEM_REG_INT_TABLE_TM                                                                                              0x2000d4UL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for memory int_table
#define CSEM_REG_CLEAR_WAITP                                                                                               0x2000d8UL //ACCESS:RW  DataWidth:0x1  Description: Write 1 to this register will disable waitp from this storm to other storms
#define CSEM_REG_SLOW_DBG_MODE                                                                                             0x2000dcUL //ACCESS:RW  DataWidth:0x3  Description: debug mode for slow debug bus. Applicable only when ~csem_registers_slow_dbg_active.slow_dbg_active =1. If mode =0 thread number; pram address and DRA WR data selected; if mode =1 fin command and DRA RD ; if mode =2 pram address and thread number and fin command and released thread from STORM; if mode =3 STORE data to SDM
#define CSEM_REG_SLOW_DBG_ACTIVE                                                                                           0x2000e0UL //ACCESS:RW  DataWidth:0x1  Description: debug mode is active
#define CSEM_REG_DBG_MSG_SRC                                                                                               0x2000e4UL //ACCESS:RW  DataWidth:0x1  Description: Applicable only when ~csem_registers_slow_dbg_mode.slow_dbg_mode =0. If =0only FIC-s output to debug bus; 1=both FIC-s and passive buffer.
#define CSEM_REG_DBG_MODE0_CFG                                                                                             0x2000e8UL //ACCESS:RW  DataWidth:0x1  Description: Applicable only when ~csem_registers_slow_dbg_mode.slow_dbg_mode =0. If =0 all the message output to debug bus; 1=partial message.
#define CSEM_REG_DBG_MODE0_CFG_CYCLE                                                                                       0x2000ecUL //ACCESS:RW  DataWidth:0x5  Description: Applicable only when ~csem_registers_dbg_mode0_cfg.dbg_mode0_cfg =1. If =1 the additional cycles to extract to the debug bus.
#define CSEM_REG_DBG_MODE1_CFG                                                                                             0x2000f0UL //ACCESS:RW  DataWidth:0x1  Description: Applicable only when ~csem_registers_slow_dbg_mode.slow_dbg_mode =1. If=0 output to debug bus without the data; 1=with the data.
#define CSEM_REG_DBG_EACH_CYLE                                                                                             0x2000f4UL //ACCESS:RW  DataWidth:0x1  Description: If=0 output every cycle full indication or thread status; 1= output only when there is a change.
#define CSEM_REG_DBG_SELECT                                                                                                0x2000f8UL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from USEMI to the DBG block) - for selecting a line to output to the DBG block
#define CSEM_REG_DBG_BYTE_ENABLE                                                                                           0x2000fcUL //ACCESS:RW  DataWidth:0x8  Description: Debug only.For dbgmux usage (debug data that goes from USEM to the DBG block) - for enabling bytes in the selected line (after the select before the shift).
#define CSEM_REG_DBG_SHIFT                                                                                                 0x200100UL //ACCESS:RW  DataWidth:0x3  Description: Debug only.For dbgmux usage (debug data that goes from USEM to the DBG block) - for circular right shifting of the selected line (after the enabling).
#define CSEM_REG_CSEM_INT_STS_0                                                                                            0x200104UL //ACCESS:R  DataWidth:0x20  Description: Interrupt register #0 read		
	#define CSEM_CSEM_INT_STS_0_REG_ADDRESS_ERROR                                                                          (0x1<<0)
	#define CSEM_CSEM_INT_STS_0_REG_ADDRESS_ERROR_SIZE                                                                     0		
	#define CSEM_CSEM_INT_STS_0_REG_FIC0_LAST_ERROR                                                                        (0x1<<1)
	#define CSEM_CSEM_INT_STS_0_REG_FIC0_LAST_ERROR_SIZE                                                                   1		
	#define CSEM_CSEM_INT_STS_0_REG_FIC1_LAST_ERROR                                                                        (0x1<<2)
	#define CSEM_CSEM_INT_STS_0_REG_FIC1_LAST_ERROR_SIZE                                                                   2		
	#define CSEM_CSEM_INT_STS_0_REG_FIC0_LENGTH_ERROR                                                                      (0x1<<3)
	#define CSEM_CSEM_INT_STS_0_REG_FIC0_LENGTH_ERROR_SIZE                                                                 3		
	#define CSEM_CSEM_INT_STS_0_REG_FIC1_LENGTH_ERROR                                                                      (0x1<<4)
	#define CSEM_CSEM_INT_STS_0_REG_FIC1_LENGTH_ERROR_SIZE                                                                 4		
	#define CSEM_CSEM_INT_STS_0_REG_FIC0_FIFO_ERROR                                                                        (0x1<<5)
	#define CSEM_CSEM_INT_STS_0_REG_FIC0_FIFO_ERROR_SIZE                                                                   5		
	#define CSEM_CSEM_INT_STS_0_REG_FIC1_FIFO_ERROR                                                                        (0x1<<6)
	#define CSEM_CSEM_INT_STS_0_REG_FIC1_FIFO_ERROR_SIZE                                                                   6		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_INT_PUSH_ERROR                                                                    (0x1<<7)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_INT_PUSH_ERROR_SIZE                                                               7		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_INT_POP_ERROR                                                                     (0x1<<8)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_INT_POP_ERROR_SIZE                                                                8		
	#define CSEM_CSEM_INT_STS_0_REG_PAS_BUF_FIFO_ERROR                                                                     (0x1<<9)
	#define CSEM_CSEM_INT_STS_0_REG_PAS_BUF_FIFO_ERROR_SIZE                                                                9		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_FIN_POP_ERROR                                                                     (0x1<<10)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_FIN_POP_ERROR_SIZE                                                                10		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_DRA_WR_PUSH_ERROR                                                                 (0x1<<11)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_DRA_WR_PUSH_ERROR_SIZE                                                            11		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_DRA_WR_POP_ERROR                                                                  (0x1<<12)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_DRA_WR_POP_ERROR_SIZE                                                             12		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_DRA_RD_PUSH_ERROR                                                                 (0x1<<13)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_DRA_RD_PUSH_ERROR_SIZE                                                            13		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_DRA_RD_POP_ERROR                                                                  (0x1<<14)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_DRA_RD_POP_ERROR_SIZE                                                             14		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_FIN_PUSH_ERROR                                                                    (0x1<<15)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_FIN_PUSH_ERROR_SIZE                                                               15		
	#define CSEM_CSEM_INT_STS_0_REG_MAX_HANDLER_ERROR                                                                      (0x1<<16)
	#define CSEM_CSEM_INT_STS_0_REG_MAX_HANDLER_ERROR_SIZE                                                                 16		
	#define CSEM_CSEM_INT_STS_0_REG_DRA_DATA_WR_ERROR                                                                      (0x1<<17)
	#define CSEM_CSEM_INT_STS_0_REG_DRA_DATA_WR_ERROR_SIZE                                                                 17		
	#define CSEM_CSEM_INT_STS_0_REG_RD_EMPTY_LOAD_FIFO                                                                     (0x1<<18)
	#define CSEM_CSEM_INT_STS_0_REG_RD_EMPTY_LOAD_FIFO_SIZE                                                                18		
	#define CSEM_CSEM_INT_STS_0_REG_WR_FULL_LOAD_FIFO                                                                      (0x1<<19)
	#define CSEM_CSEM_INT_STS_0_REG_WR_FULL_LOAD_FIFO_SIZE                                                                 19		
	#define CSEM_CSEM_INT_STS_0_REG_RD_EMPTY_CAM                                                                           (0x1<<20)
	#define CSEM_CSEM_INT_STS_0_REG_RD_EMPTY_CAM_SIZE                                                                      20		
	#define CSEM_CSEM_INT_STS_0_REG_WR_FULL_CAM                                                                            (0x1<<21)
	#define CSEM_CSEM_INT_STS_0_REG_WR_FULL_CAM_SIZE                                                                       21		
	#define CSEM_CSEM_INT_STS_0_REG_CAM_LSB_INP_FIFO                                                                       (0x1<<22)
	#define CSEM_CSEM_INT_STS_0_REG_CAM_LSB_INP_FIFO_SIZE                                                                  22		
	#define CSEM_CSEM_INT_STS_0_REG_CAM_MSB_INP_FIFO                                                                       (0x1<<23)
	#define CSEM_CSEM_INT_STS_0_REG_CAM_MSB_INP_FIFO_SIZE                                                                  23		
	#define CSEM_CSEM_INT_STS_0_REG_CAM_OUT_FIFO                                                                           (0x1<<24)
	#define CSEM_CSEM_INT_STS_0_REG_CAM_OUT_FIFO_SIZE                                                                      24		
	#define CSEM_CSEM_INT_STS_0_REG_FIN_FIFO                                                                               (0x1<<25)
	#define CSEM_CSEM_INT_STS_0_REG_FIN_FIFO_SIZE                                                                          25		
	#define CSEM_CSEM_INT_STS_0_REG_SET0_THREAD_ERROR                                                                      (0x1<<26)
	#define CSEM_CSEM_INT_STS_0_REG_SET0_THREAD_ERROR_SIZE                                                                 26		
	#define CSEM_CSEM_INT_STS_0_REG_SET1_THREAD_ERROR                                                                      (0x1<<27)
	#define CSEM_CSEM_INT_STS_0_REG_SET1_THREAD_ERROR_SIZE                                                                 27		
	#define CSEM_CSEM_INT_STS_0_REG_THREAD_OVERRUN                                                                         (0x1<<28)
	#define CSEM_CSEM_INT_STS_0_REG_THREAD_OVERRUN_SIZE                                                                    28		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_EXT_STORE_PUSH_ERROR                                                              (0x1<<29)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_EXT_STORE_PUSH_ERROR_SIZE                                                         29		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_EXT_STORE_POP_ERROR                                                               (0x1<<30)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_EXT_STORE_POP_ERROR_SIZE                                                          30		
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_RAM0_RD_PUSH_ERROR                                                                (0x1<<31)
	#define CSEM_CSEM_INT_STS_0_REG_SYNC_RAM0_RD_PUSH_ERROR_SIZE                                                           31
#define CSEM_REG_CSEM_INT_STS_CLR_0                                                                                        0x200108UL //ACCESS:RC  DataWidth:0x20  Description: Interrupt register #0 read clear		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_ADDRESS_ERROR                                                                      (0x1<<0)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_ADDRESS_ERROR_SIZE                                                                 0		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC0_LAST_ERROR                                                                    (0x1<<1)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC0_LAST_ERROR_SIZE                                                               1		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC1_LAST_ERROR                                                                    (0x1<<2)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC1_LAST_ERROR_SIZE                                                               2		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC0_LENGTH_ERROR                                                                  (0x1<<3)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC0_LENGTH_ERROR_SIZE                                                             3		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC1_LENGTH_ERROR                                                                  (0x1<<4)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC1_LENGTH_ERROR_SIZE                                                             4		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC0_FIFO_ERROR                                                                    (0x1<<5)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC0_FIFO_ERROR_SIZE                                                               5		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC1_FIFO_ERROR                                                                    (0x1<<6)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIC1_FIFO_ERROR_SIZE                                                               6		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_INT_PUSH_ERROR                                                                (0x1<<7)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_INT_PUSH_ERROR_SIZE                                                           7		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_INT_POP_ERROR                                                                 (0x1<<8)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_INT_POP_ERROR_SIZE                                                            8		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_PAS_BUF_FIFO_ERROR                                                                 (0x1<<9)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_PAS_BUF_FIFO_ERROR_SIZE                                                            9		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_FIN_POP_ERROR                                                                 (0x1<<10)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_FIN_POP_ERROR_SIZE                                                            10		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_DRA_WR_PUSH_ERROR                                                             (0x1<<11)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_DRA_WR_PUSH_ERROR_SIZE                                                        11		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_DRA_WR_POP_ERROR                                                              (0x1<<12)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_DRA_WR_POP_ERROR_SIZE                                                         12		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_DRA_RD_PUSH_ERROR                                                             (0x1<<13)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_DRA_RD_PUSH_ERROR_SIZE                                                        13		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_DRA_RD_POP_ERROR                                                              (0x1<<14)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_DRA_RD_POP_ERROR_SIZE                                                         14		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_FIN_PUSH_ERROR                                                                (0x1<<15)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_FIN_PUSH_ERROR_SIZE                                                           15		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_MAX_HANDLER_ERROR                                                                  (0x1<<16)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_MAX_HANDLER_ERROR_SIZE                                                             16		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_DRA_DATA_WR_ERROR                                                                  (0x1<<17)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_DRA_DATA_WR_ERROR_SIZE                                                             17		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_RD_EMPTY_LOAD_FIFO                                                                 (0x1<<18)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_RD_EMPTY_LOAD_FIFO_SIZE                                                            18		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_WR_FULL_LOAD_FIFO                                                                  (0x1<<19)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_WR_FULL_LOAD_FIFO_SIZE                                                             19		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_RD_EMPTY_CAM                                                                       (0x1<<20)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_RD_EMPTY_CAM_SIZE                                                                  20		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_WR_FULL_CAM                                                                        (0x1<<21)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_WR_FULL_CAM_SIZE                                                                   21		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_CAM_LSB_INP_FIFO                                                                   (0x1<<22)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_CAM_LSB_INP_FIFO_SIZE                                                              22		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_CAM_MSB_INP_FIFO                                                                   (0x1<<23)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_CAM_MSB_INP_FIFO_SIZE                                                              23		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_CAM_OUT_FIFO                                                                       (0x1<<24)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_CAM_OUT_FIFO_SIZE                                                                  24		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIN_FIFO                                                                           (0x1<<25)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_FIN_FIFO_SIZE                                                                      25		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SET0_THREAD_ERROR                                                                  (0x1<<26)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SET0_THREAD_ERROR_SIZE                                                             26		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SET1_THREAD_ERROR                                                                  (0x1<<27)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SET1_THREAD_ERROR_SIZE                                                             27		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_THREAD_OVERRUN                                                                     (0x1<<28)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_THREAD_OVERRUN_SIZE                                                                28		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_EXT_STORE_PUSH_ERROR                                                          (0x1<<29)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_EXT_STORE_PUSH_ERROR_SIZE                                                     29		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_EXT_STORE_POP_ERROR                                                           (0x1<<30)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_EXT_STORE_POP_ERROR_SIZE                                                      30		
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_RAM0_RD_PUSH_ERROR                                                            (0x1<<31)
	#define CSEM_CSEM_INT_STS_CLR_0_REG_SYNC_RAM0_RD_PUSH_ERROR_SIZE                                                       31
#define CSEM_REG_CSEM_INT_STS_WR_0                                                                                         0x20010cUL //ACCESS:WR  DataWidth:0x20  Description: Interrupt register #0 bit set or clear		
	#define CSEM_CSEM_INT_STS_WR_0_REG_ADDRESS_ERROR                                                                       (0x1<<0)
	#define CSEM_CSEM_INT_STS_WR_0_REG_ADDRESS_ERROR_SIZE                                                                  0		
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC0_LAST_ERROR                                                                     (0x1<<1)
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC0_LAST_ERROR_SIZE                                                                1		
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC1_LAST_ERROR                                                                     (0x1<<2)
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC1_LAST_ERROR_SIZE                                                                2		
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC0_LENGTH_ERROR                                                                   (0x1<<3)
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC0_LENGTH_ERROR_SIZE                                                              3		
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC1_LENGTH_ERROR                                                                   (0x1<<4)
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC1_LENGTH_ERROR_SIZE                                                              4		
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC0_FIFO_ERROR                                                                     (0x1<<5)
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC0_FIFO_ERROR_SIZE                                                                5		
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC1_FIFO_ERROR                                                                     (0x1<<6)
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIC1_FIFO_ERROR_SIZE                                                                6		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_INT_PUSH_ERROR                                                                 (0x1<<7)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_INT_PUSH_ERROR_SIZE                                                            7		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_INT_POP_ERROR                                                                  (0x1<<8)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_INT_POP_ERROR_SIZE                                                             8		
	#define CSEM_CSEM_INT_STS_WR_0_REG_PAS_BUF_FIFO_ERROR                                                                  (0x1<<9)
	#define CSEM_CSEM_INT_STS_WR_0_REG_PAS_BUF_FIFO_ERROR_SIZE                                                             9		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_FIN_POP_ERROR                                                                  (0x1<<10)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_FIN_POP_ERROR_SIZE                                                             10		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_DRA_WR_PUSH_ERROR                                                              (0x1<<11)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_DRA_WR_PUSH_ERROR_SIZE                                                         11		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_DRA_WR_POP_ERROR                                                               (0x1<<12)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_DRA_WR_POP_ERROR_SIZE                                                          12		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_DRA_RD_PUSH_ERROR                                                              (0x1<<13)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_DRA_RD_PUSH_ERROR_SIZE                                                         13		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_DRA_RD_POP_ERROR                                                               (0x1<<14)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_DRA_RD_POP_ERROR_SIZE                                                          14		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_FIN_PUSH_ERROR                                                                 (0x1<<15)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_FIN_PUSH_ERROR_SIZE                                                            15		
	#define CSEM_CSEM_INT_STS_WR_0_REG_MAX_HANDLER_ERROR                                                                   (0x1<<16)
	#define CSEM_CSEM_INT_STS_WR_0_REG_MAX_HANDLER_ERROR_SIZE                                                              16		
	#define CSEM_CSEM_INT_STS_WR_0_REG_DRA_DATA_WR_ERROR                                                                   (0x1<<17)
	#define CSEM_CSEM_INT_STS_WR_0_REG_DRA_DATA_WR_ERROR_SIZE                                                              17		
	#define CSEM_CSEM_INT_STS_WR_0_REG_RD_EMPTY_LOAD_FIFO                                                                  (0x1<<18)
	#define CSEM_CSEM_INT_STS_WR_0_REG_RD_EMPTY_LOAD_FIFO_SIZE                                                             18		
	#define CSEM_CSEM_INT_STS_WR_0_REG_WR_FULL_LOAD_FIFO                                                                   (0x1<<19)
	#define CSEM_CSEM_INT_STS_WR_0_REG_WR_FULL_LOAD_FIFO_SIZE                                                              19		
	#define CSEM_CSEM_INT_STS_WR_0_REG_RD_EMPTY_CAM                                                                        (0x1<<20)
	#define CSEM_CSEM_INT_STS_WR_0_REG_RD_EMPTY_CAM_SIZE                                                                   20		
	#define CSEM_CSEM_INT_STS_WR_0_REG_WR_FULL_CAM                                                                         (0x1<<21)
	#define CSEM_CSEM_INT_STS_WR_0_REG_WR_FULL_CAM_SIZE                                                                    21		
	#define CSEM_CSEM_INT_STS_WR_0_REG_CAM_LSB_INP_FIFO                                                                    (0x1<<22)
	#define CSEM_CSEM_INT_STS_WR_0_REG_CAM_LSB_INP_FIFO_SIZE                                                               22		
	#define CSEM_CSEM_INT_STS_WR_0_REG_CAM_MSB_INP_FIFO                                                                    (0x1<<23)
	#define CSEM_CSEM_INT_STS_WR_0_REG_CAM_MSB_INP_FIFO_SIZE                                                               23		
	#define CSEM_CSEM_INT_STS_WR_0_REG_CAM_OUT_FIFO                                                                        (0x1<<24)
	#define CSEM_CSEM_INT_STS_WR_0_REG_CAM_OUT_FIFO_SIZE                                                                   24		
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIN_FIFO                                                                            (0x1<<25)
	#define CSEM_CSEM_INT_STS_WR_0_REG_FIN_FIFO_SIZE                                                                       25		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SET0_THREAD_ERROR                                                                   (0x1<<26)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SET0_THREAD_ERROR_SIZE                                                              26		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SET1_THREAD_ERROR                                                                   (0x1<<27)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SET1_THREAD_ERROR_SIZE                                                              27		
	#define CSEM_CSEM_INT_STS_WR_0_REG_THREAD_OVERRUN                                                                      (0x1<<28)
	#define CSEM_CSEM_INT_STS_WR_0_REG_THREAD_OVERRUN_SIZE                                                                 28		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_EXT_STORE_PUSH_ERROR                                                           (0x1<<29)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_EXT_STORE_PUSH_ERROR_SIZE                                                      29		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_EXT_STORE_POP_ERROR                                                            (0x1<<30)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_EXT_STORE_POP_ERROR_SIZE                                                       30		
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_RAM0_RD_PUSH_ERROR                                                             (0x1<<31)
	#define CSEM_CSEM_INT_STS_WR_0_REG_SYNC_RAM0_RD_PUSH_ERROR_SIZE                                                        31
#define CSEM_REG_CSEM_INT_MASK_0                                                                                           0x200110UL //ACCESS:RW  DataWidth:0x20  Description: Interrupt mask register #0 read/write		
	#define CSEM_CSEM_INT_MASK_0_REG_ADDRESS_ERROR                                                                         (0x1<<0)
	#define CSEM_CSEM_INT_MASK_0_REG_ADDRESS_ERROR_SIZE                                                                    0		
	#define CSEM_CSEM_INT_MASK_0_REG_FIC0_LAST_ERROR                                                                       (0x1<<1)
	#define CSEM_CSEM_INT_MASK_0_REG_FIC0_LAST_ERROR_SIZE                                                                  1		
	#define CSEM_CSEM_INT_MASK_0_REG_FIC1_LAST_ERROR                                                                       (0x1<<2)
	#define CSEM_CSEM_INT_MASK_0_REG_FIC1_LAST_ERROR_SIZE                                                                  2		
	#define CSEM_CSEM_INT_MASK_0_REG_FIC0_LENGTH_ERROR                                                                     (0x1<<3)
	#define CSEM_CSEM_INT_MASK_0_REG_FIC0_LENGTH_ERROR_SIZE                                                                3		
	#define CSEM_CSEM_INT_MASK_0_REG_FIC1_LENGTH_ERROR                                                                     (0x1<<4)
	#define CSEM_CSEM_INT_MASK_0_REG_FIC1_LENGTH_ERROR_SIZE                                                                4		
	#define CSEM_CSEM_INT_MASK_0_REG_FIC0_FIFO_ERROR                                                                       (0x1<<5)
	#define CSEM_CSEM_INT_MASK_0_REG_FIC0_FIFO_ERROR_SIZE                                                                  5		
	#define CSEM_CSEM_INT_MASK_0_REG_FIC1_FIFO_ERROR                                                                       (0x1<<6)
	#define CSEM_CSEM_INT_MASK_0_REG_FIC1_FIFO_ERROR_SIZE                                                                  6		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_INT_PUSH_ERROR                                                                   (0x1<<7)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_INT_PUSH_ERROR_SIZE                                                              7		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_INT_POP_ERROR                                                                    (0x1<<8)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_INT_POP_ERROR_SIZE                                                               8		
	#define CSEM_CSEM_INT_MASK_0_REG_PAS_BUF_FIFO_ERROR                                                                    (0x1<<9)
	#define CSEM_CSEM_INT_MASK_0_REG_PAS_BUF_FIFO_ERROR_SIZE                                                               9		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_FIN_POP_ERROR                                                                    (0x1<<10)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_FIN_POP_ERROR_SIZE                                                               10		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_DRA_WR_PUSH_ERROR                                                                (0x1<<11)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_DRA_WR_PUSH_ERROR_SIZE                                                           11		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_DRA_WR_POP_ERROR                                                                 (0x1<<12)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_DRA_WR_POP_ERROR_SIZE                                                            12		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_DRA_RD_PUSH_ERROR                                                                (0x1<<13)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_DRA_RD_PUSH_ERROR_SIZE                                                           13		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_DRA_RD_POP_ERROR                                                                 (0x1<<14)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_DRA_RD_POP_ERROR_SIZE                                                            14		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_FIN_PUSH_ERROR                                                                   (0x1<<15)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_FIN_PUSH_ERROR_SIZE                                                              15		
	#define CSEM_CSEM_INT_MASK_0_REG_MAX_HANDLER_ERROR                                                                     (0x1<<16)
	#define CSEM_CSEM_INT_MASK_0_REG_MAX_HANDLER_ERROR_SIZE                                                                16		
	#define CSEM_CSEM_INT_MASK_0_REG_DRA_DATA_WR_ERROR                                                                     (0x1<<17)
	#define CSEM_CSEM_INT_MASK_0_REG_DRA_DATA_WR_ERROR_SIZE                                                                17		
	#define CSEM_CSEM_INT_MASK_0_REG_RD_EMPTY_LOAD_FIFO                                                                    (0x1<<18)
	#define CSEM_CSEM_INT_MASK_0_REG_RD_EMPTY_LOAD_FIFO_SIZE                                                               18		
	#define CSEM_CSEM_INT_MASK_0_REG_WR_FULL_LOAD_FIFO                                                                     (0x1<<19)
	#define CSEM_CSEM_INT_MASK_0_REG_WR_FULL_LOAD_FIFO_SIZE                                                                19		
	#define CSEM_CSEM_INT_MASK_0_REG_RD_EMPTY_CAM                                                                          (0x1<<20)
	#define CSEM_CSEM_INT_MASK_0_REG_RD_EMPTY_CAM_SIZE                                                                     20		
	#define CSEM_CSEM_INT_MASK_0_REG_WR_FULL_CAM                                                                           (0x1<<21)
	#define CSEM_CSEM_INT_MASK_0_REG_WR_FULL_CAM_SIZE                                                                      21		
	#define CSEM_CSEM_INT_MASK_0_REG_CAM_LSB_INP_FIFO                                                                      (0x1<<22)
	#define CSEM_CSEM_INT_MASK_0_REG_CAM_LSB_INP_FIFO_SIZE                                                                 22		
	#define CSEM_CSEM_INT_MASK_0_REG_CAM_MSB_INP_FIFO                                                                      (0x1<<23)
	#define CSEM_CSEM_INT_MASK_0_REG_CAM_MSB_INP_FIFO_SIZE                                                                 23		
	#define CSEM_CSEM_INT_MASK_0_REG_CAM_OUT_FIFO                                                                          (0x1<<24)
	#define CSEM_CSEM_INT_MASK_0_REG_CAM_OUT_FIFO_SIZE                                                                     24		
	#define CSEM_CSEM_INT_MASK_0_REG_FIN_FIFO                                                                              (0x1<<25)
	#define CSEM_CSEM_INT_MASK_0_REG_FIN_FIFO_SIZE                                                                         25		
	#define CSEM_CSEM_INT_MASK_0_REG_SET0_THREAD_ERROR                                                                     (0x1<<26)
	#define CSEM_CSEM_INT_MASK_0_REG_SET0_THREAD_ERROR_SIZE                                                                26		
	#define CSEM_CSEM_INT_MASK_0_REG_SET1_THREAD_ERROR                                                                     (0x1<<27)
	#define CSEM_CSEM_INT_MASK_0_REG_SET1_THREAD_ERROR_SIZE                                                                27		
	#define CSEM_CSEM_INT_MASK_0_REG_THREAD_OVERRUN                                                                        (0x1<<28)
	#define CSEM_CSEM_INT_MASK_0_REG_THREAD_OVERRUN_SIZE                                                                   28		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_EXT_STORE_PUSH_ERROR                                                             (0x1<<29)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_EXT_STORE_PUSH_ERROR_SIZE                                                        29		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_EXT_STORE_POP_ERROR                                                              (0x1<<30)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_EXT_STORE_POP_ERROR_SIZE                                                         30		
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_RAM0_RD_PUSH_ERROR                                                               (0x1<<31)
	#define CSEM_CSEM_INT_MASK_0_REG_SYNC_RAM0_RD_PUSH_ERROR_SIZE                                                          31
#define CSEM_REG_CSEM_INT_STS_1                                                                                            0x200114UL //ACCESS:R  DataWidth:0xb  Description: Interrupt register #1 read		
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM1_RD_PUSH_ERROR                                                                (0x1<<0)
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM1_RD_PUSH_ERROR_SIZE                                                           0		
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM0_RD_POP_ERROR                                                                 (0x1<<1)
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM0_RD_POP_ERROR_SIZE                                                            1		
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM1_RD_POP_ERROR                                                                 (0x1<<2)
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM1_RD_POP_ERROR_SIZE                                                            2		
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM0_WR_POP_ERROR                                                                 (0x1<<3)
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM0_WR_POP_ERROR_SIZE                                                            3		
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM1_WR_POP_ERROR                                                                 (0x1<<4)
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM1_WR_POP_ERROR_SIZE                                                            4		
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM0_WR_PUSH_ERROR                                                                (0x1<<5)
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM0_WR_PUSH_ERROR_SIZE                                                           5		
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM1_WR_PUSH_ERROR                                                                (0x1<<6)
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_RAM1_WR_PUSH_ERROR_SIZE                                                           6		
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_DBG_PUSH_ERROR                                                                    (0x1<<7)
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_DBG_PUSH_ERROR_SIZE                                                               7		
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_DBG_POP_ERROR                                                                     (0x1<<8)
	#define CSEM_CSEM_INT_STS_1_REG_SYNC_DBG_POP_ERROR_SIZE                                                                8		
	#define CSEM_CSEM_INT_STS_1_REG_DBG_FIFO_ERROR                                                                         (0x1<<9)
	#define CSEM_CSEM_INT_STS_1_REG_DBG_FIFO_ERROR_SIZE                                                                    9		
	#define CSEM_CSEM_INT_STS_1_REG_CAM_MSB2_INP_FIFO                                                                      (0x1<<10)
	#define CSEM_CSEM_INT_STS_1_REG_CAM_MSB2_INP_FIFO_SIZE                                                                 10
#define CSEM_REG_CSEM_INT_STS_CLR_1                                                                                        0x200118UL //ACCESS:RC  DataWidth:0xb  Description: Interrupt register #1 read clear		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM1_RD_PUSH_ERROR                                                            (0x1<<0)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM1_RD_PUSH_ERROR_SIZE                                                       0		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM0_RD_POP_ERROR                                                             (0x1<<1)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM0_RD_POP_ERROR_SIZE                                                        1		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM1_RD_POP_ERROR                                                             (0x1<<2)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM1_RD_POP_ERROR_SIZE                                                        2		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM0_WR_POP_ERROR                                                             (0x1<<3)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM0_WR_POP_ERROR_SIZE                                                        3		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM1_WR_POP_ERROR                                                             (0x1<<4)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM1_WR_POP_ERROR_SIZE                                                        4		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM0_WR_PUSH_ERROR                                                            (0x1<<5)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM0_WR_PUSH_ERROR_SIZE                                                       5		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM1_WR_PUSH_ERROR                                                            (0x1<<6)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_RAM1_WR_PUSH_ERROR_SIZE                                                       6		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_DBG_PUSH_ERROR                                                                (0x1<<7)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_DBG_PUSH_ERROR_SIZE                                                           7		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_DBG_POP_ERROR                                                                 (0x1<<8)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_SYNC_DBG_POP_ERROR_SIZE                                                            8		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_DBG_FIFO_ERROR                                                                     (0x1<<9)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_DBG_FIFO_ERROR_SIZE                                                                9		
	#define CSEM_CSEM_INT_STS_CLR_1_REG_CAM_MSB2_INP_FIFO                                                                  (0x1<<10)
	#define CSEM_CSEM_INT_STS_CLR_1_REG_CAM_MSB2_INP_FIFO_SIZE                                                             10
#define CSEM_REG_CSEM_INT_STS_WR_1                                                                                         0x20011cUL //ACCESS:WR  DataWidth:0xb  Description: Interrupt register #1 bit set or clear		
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM1_RD_PUSH_ERROR                                                             (0x1<<0)
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM1_RD_PUSH_ERROR_SIZE                                                        0		
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM0_RD_POP_ERROR                                                              (0x1<<1)
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM0_RD_POP_ERROR_SIZE                                                         1		
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM1_RD_POP_ERROR                                                              (0x1<<2)
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM1_RD_POP_ERROR_SIZE                                                         2		
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM0_WR_POP_ERROR                                                              (0x1<<3)
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM0_WR_POP_ERROR_SIZE                                                         3		
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM1_WR_POP_ERROR                                                              (0x1<<4)
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM1_WR_POP_ERROR_SIZE                                                         4		
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM0_WR_PUSH_ERROR                                                             (0x1<<5)
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM0_WR_PUSH_ERROR_SIZE                                                        5		
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM1_WR_PUSH_ERROR                                                             (0x1<<6)
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_RAM1_WR_PUSH_ERROR_SIZE                                                        6		
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_DBG_PUSH_ERROR                                                                 (0x1<<7)
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_DBG_PUSH_ERROR_SIZE                                                            7		
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_DBG_POP_ERROR                                                                  (0x1<<8)
	#define CSEM_CSEM_INT_STS_WR_1_REG_SYNC_DBG_POP_ERROR_SIZE                                                             8		
	#define CSEM_CSEM_INT_STS_WR_1_REG_DBG_FIFO_ERROR                                                                      (0x1<<9)
	#define CSEM_CSEM_INT_STS_WR_1_REG_DBG_FIFO_ERROR_SIZE                                                                 9		
	#define CSEM_CSEM_INT_STS_WR_1_REG_CAM_MSB2_INP_FIFO                                                                   (0x1<<10)
	#define CSEM_CSEM_INT_STS_WR_1_REG_CAM_MSB2_INP_FIFO_SIZE                                                              10
#define CSEM_REG_CSEM_INT_MASK_1                                                                                           0x200120UL //ACCESS:RW  DataWidth:0xb  Description: Interrupt mask register #1 read/write		
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM1_RD_PUSH_ERROR                                                               (0x1<<0)
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM1_RD_PUSH_ERROR_SIZE                                                          0		
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM0_RD_POP_ERROR                                                                (0x1<<1)
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM0_RD_POP_ERROR_SIZE                                                           1		
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM1_RD_POP_ERROR                                                                (0x1<<2)
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM1_RD_POP_ERROR_SIZE                                                           2		
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM0_WR_POP_ERROR                                                                (0x1<<3)
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM0_WR_POP_ERROR_SIZE                                                           3		
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM1_WR_POP_ERROR                                                                (0x1<<4)
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM1_WR_POP_ERROR_SIZE                                                           4		
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM0_WR_PUSH_ERROR                                                               (0x1<<5)
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM0_WR_PUSH_ERROR_SIZE                                                          5		
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM1_WR_PUSH_ERROR                                                               (0x1<<6)
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_RAM1_WR_PUSH_ERROR_SIZE                                                          6		
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_DBG_PUSH_ERROR                                                                   (0x1<<7)
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_DBG_PUSH_ERROR_SIZE                                                              7		
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_DBG_POP_ERROR                                                                    (0x1<<8)
	#define CSEM_CSEM_INT_MASK_1_REG_SYNC_DBG_POP_ERROR_SIZE                                                               8		
	#define CSEM_CSEM_INT_MASK_1_REG_DBG_FIFO_ERROR                                                                        (0x1<<9)
	#define CSEM_CSEM_INT_MASK_1_REG_DBG_FIFO_ERROR_SIZE                                                                   9		
	#define CSEM_CSEM_INT_MASK_1_REG_CAM_MSB2_INP_FIFO                                                                     (0x1<<10)
	#define CSEM_CSEM_INT_MASK_1_REG_CAM_MSB2_INP_FIFO_SIZE                                                                10
#define CSEM_REG_CSEM_PRTY_STS_0                                                                                           0x200124UL //ACCESS:R  DataWidth:0x20  Description: Parity register #0 read		
	#define CSEM_CSEM_PRTY_STS_0_REG_PARITY                                                                                (0x1<<0)
	#define CSEM_CSEM_PRTY_STS_0_REG_PARITY_SIZE                                                                           0		
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_DRA_WR_FIFO_PARITY                                                               (0x1<<1)
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_DRA_WR_FIFO_PARITY_SIZE                                                          1		
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_DRA_RD_FIFO_PARITY                                                               (0x1<<2)
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_DRA_RD_FIFO_PARITY_SIZE                                                          2		
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_RAM0_RD_FIFO_PARITY                                                              (0x1<<3)
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_RAM0_RD_FIFO_PARITY_SIZE                                                         3		
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_RAM1_RD_FIFO_PARITY                                                              (0x1<<4)
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_RAM1_RD_FIFO_PARITY_SIZE                                                         4		
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_RAM0_WR_FIFO_PARITY                                                              (0x1<<5)
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_RAM0_WR_FIFO_PARITY_SIZE                                                         5		
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_RAM1_WR_FIFO_PARITY                                                              (0x1<<6)
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_RAM1_WR_FIFO_PARITY_SIZE                                                         6		
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_EXT_FIFO_PARITY                                                                  (0x1<<7)
	#define CSEM_CSEM_PRTY_STS_0_REG_SYNC_EXT_FIFO_PARITY_SIZE                                                             7		
	#define CSEM_CSEM_PRTY_STS_0_REG_FIC0_FIFO_PARITY                                                                      (0x1<<8)
	#define CSEM_CSEM_PRTY_STS_0_REG_FIC0_FIFO_PARITY_SIZE                                                                 8		
	#define CSEM_CSEM_PRTY_STS_0_REG_FIC1_FIFO_PARITY                                                                      (0x1<<9)
	#define CSEM_CSEM_PRTY_STS_0_REG_FIC1_FIFO_PARITY_SIZE                                                                 9		
	#define CSEM_CSEM_PRTY_STS_0_REG_PAS_FIFO_PARITY                                                                       (0x1<<10)
	#define CSEM_CSEM_PRTY_STS_0_REG_PAS_FIFO_PARITY_SIZE                                                                  10		
	#define CSEM_CSEM_PRTY_STS_0_REG_PAS_PARITY0                                                                           (0x1<<11)
	#define CSEM_CSEM_PRTY_STS_0_REG_PAS_PARITY0_SIZE                                                                      11		
	#define CSEM_CSEM_PRTY_STS_0_REG_PAS_PARITY1                                                                           (0x1<<12)
	#define CSEM_CSEM_PRTY_STS_0_REG_PAS_PARITY1_SIZE                                                                      12		
	#define CSEM_CSEM_PRTY_STS_0_REG_INT_TABLE_PARITY                                                                      (0x1<<13)
	#define CSEM_CSEM_PRTY_STS_0_REG_INT_TABLE_PARITY_SIZE                                                                 13		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY0                                                                          (0x1<<14)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY0_SIZE                                                                     14		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY1                                                                          (0x1<<15)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY1_SIZE                                                                     15		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY2                                                                          (0x1<<16)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY2_SIZE                                                                     16		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY3                                                                          (0x1<<17)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY3_SIZE                                                                     17		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY4                                                                          (0x1<<18)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY4_SIZE                                                                     18		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY5                                                                          (0x1<<19)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY5_SIZE                                                                     19		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY6                                                                          (0x1<<20)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY6_SIZE                                                                     20		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY7                                                                          (0x1<<21)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM0_PARITY7_SIZE                                                                     21		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY0                                                                          (0x1<<22)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY0_SIZE                                                                     22		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY1                                                                          (0x1<<23)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY1_SIZE                                                                     23		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY2                                                                          (0x1<<24)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY2_SIZE                                                                     24		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY3                                                                          (0x1<<25)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY3_SIZE                                                                     25		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY4                                                                          (0x1<<26)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY4_SIZE                                                                     26		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY5                                                                          (0x1<<27)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY5_SIZE                                                                     27		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY6                                                                          (0x1<<28)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY6_SIZE                                                                     28		
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY7                                                                          (0x1<<29)
	#define CSEM_CSEM_PRTY_STS_0_REG_RAM1_PARITY7_SIZE                                                                     29		
	#define CSEM_CSEM_PRTY_STS_0_REG_PRAM_LOW_PARITY                                                                       (0x1<<30)
	#define CSEM_CSEM_PRTY_STS_0_REG_PRAM_LOW_PARITY_SIZE                                                                  30		
	#define CSEM_CSEM_PRTY_STS_0_REG_PRAM_HIGH_PARITY                                                                      (0x1<<31)
	#define CSEM_CSEM_PRTY_STS_0_REG_PRAM_HIGH_PARITY_SIZE                                                                 31
#define CSEM_REG_CSEM_PRTY_STS_CLR_0                                                                                       0x200128UL //ACCESS:RC  DataWidth:0x20  Description: Parity register #0 read clear		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PARITY                                                                            (0x1<<0)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PARITY_SIZE                                                                       0		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_DRA_WR_FIFO_PARITY                                                           (0x1<<1)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_DRA_WR_FIFO_PARITY_SIZE                                                      1		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_DRA_RD_FIFO_PARITY                                                           (0x1<<2)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_DRA_RD_FIFO_PARITY_SIZE                                                      2		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_RAM0_RD_FIFO_PARITY                                                          (0x1<<3)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_RAM0_RD_FIFO_PARITY_SIZE                                                     3		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_RAM1_RD_FIFO_PARITY                                                          (0x1<<4)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_RAM1_RD_FIFO_PARITY_SIZE                                                     4		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_RAM0_WR_FIFO_PARITY                                                          (0x1<<5)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_RAM0_WR_FIFO_PARITY_SIZE                                                     5		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_RAM1_WR_FIFO_PARITY                                                          (0x1<<6)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_RAM1_WR_FIFO_PARITY_SIZE                                                     6		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_EXT_FIFO_PARITY                                                              (0x1<<7)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_SYNC_EXT_FIFO_PARITY_SIZE                                                         7		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_FIC0_FIFO_PARITY                                                                  (0x1<<8)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_FIC0_FIFO_PARITY_SIZE                                                             8		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_FIC1_FIFO_PARITY                                                                  (0x1<<9)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_FIC1_FIFO_PARITY_SIZE                                                             9		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PAS_FIFO_PARITY                                                                   (0x1<<10)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PAS_FIFO_PARITY_SIZE                                                              10		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PAS_PARITY0                                                                       (0x1<<11)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PAS_PARITY0_SIZE                                                                  11		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PAS_PARITY1                                                                       (0x1<<12)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PAS_PARITY1_SIZE                                                                  12		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_INT_TABLE_PARITY                                                                  (0x1<<13)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_INT_TABLE_PARITY_SIZE                                                             13		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY0                                                                      (0x1<<14)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY0_SIZE                                                                 14		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY1                                                                      (0x1<<15)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY1_SIZE                                                                 15		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY2                                                                      (0x1<<16)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY2_SIZE                                                                 16		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY3                                                                      (0x1<<17)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY3_SIZE                                                                 17		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY4                                                                      (0x1<<18)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY4_SIZE                                                                 18		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY5                                                                      (0x1<<19)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY5_SIZE                                                                 19		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY6                                                                      (0x1<<20)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY6_SIZE                                                                 20		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY7                                                                      (0x1<<21)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM0_PARITY7_SIZE                                                                 21		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY0                                                                      (0x1<<22)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY0_SIZE                                                                 22		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY1                                                                      (0x1<<23)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY1_SIZE                                                                 23		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY2                                                                      (0x1<<24)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY2_SIZE                                                                 24		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY3                                                                      (0x1<<25)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY3_SIZE                                                                 25		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY4                                                                      (0x1<<26)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY4_SIZE                                                                 26		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY5                                                                      (0x1<<27)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY5_SIZE                                                                 27		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY6                                                                      (0x1<<28)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY6_SIZE                                                                 28		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY7                                                                      (0x1<<29)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_RAM1_PARITY7_SIZE                                                                 29		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PRAM_LOW_PARITY                                                                   (0x1<<30)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PRAM_LOW_PARITY_SIZE                                                              30		
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PRAM_HIGH_PARITY                                                                  (0x1<<31)
	#define CSEM_CSEM_PRTY_STS_CLR_0_REG_PRAM_HIGH_PARITY_SIZE                                                             31
#define CSEM_REG_CSEM_PRTY_STS_WR_0                                                                                        0x20012cUL //ACCESS:WR  DataWidth:0x20  Description: Parity register #0 bit set or clear		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PARITY                                                                             (0x1<<0)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PARITY_SIZE                                                                        0		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_DRA_WR_FIFO_PARITY                                                            (0x1<<1)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_DRA_WR_FIFO_PARITY_SIZE                                                       1		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_DRA_RD_FIFO_PARITY                                                            (0x1<<2)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_DRA_RD_FIFO_PARITY_SIZE                                                       2		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_RAM0_RD_FIFO_PARITY                                                           (0x1<<3)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_RAM0_RD_FIFO_PARITY_SIZE                                                      3		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_RAM1_RD_FIFO_PARITY                                                           (0x1<<4)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_RAM1_RD_FIFO_PARITY_SIZE                                                      4		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_RAM0_WR_FIFO_PARITY                                                           (0x1<<5)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_RAM0_WR_FIFO_PARITY_SIZE                                                      5		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_RAM1_WR_FIFO_PARITY                                                           (0x1<<6)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_RAM1_WR_FIFO_PARITY_SIZE                                                      6		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_EXT_FIFO_PARITY                                                               (0x1<<7)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_SYNC_EXT_FIFO_PARITY_SIZE                                                          7		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_FIC0_FIFO_PARITY                                                                   (0x1<<8)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_FIC0_FIFO_PARITY_SIZE                                                              8		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_FIC1_FIFO_PARITY                                                                   (0x1<<9)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_FIC1_FIFO_PARITY_SIZE                                                              9		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PAS_FIFO_PARITY                                                                    (0x1<<10)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PAS_FIFO_PARITY_SIZE                                                               10		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PAS_PARITY0                                                                        (0x1<<11)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PAS_PARITY0_SIZE                                                                   11		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PAS_PARITY1                                                                        (0x1<<12)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PAS_PARITY1_SIZE                                                                   12		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_INT_TABLE_PARITY                                                                   (0x1<<13)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_INT_TABLE_PARITY_SIZE                                                              13		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY0                                                                       (0x1<<14)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY0_SIZE                                                                  14		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY1                                                                       (0x1<<15)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY1_SIZE                                                                  15		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY2                                                                       (0x1<<16)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY2_SIZE                                                                  16		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY3                                                                       (0x1<<17)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY3_SIZE                                                                  17		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY4                                                                       (0x1<<18)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY4_SIZE                                                                  18		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY5                                                                       (0x1<<19)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY5_SIZE                                                                  19		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY6                                                                       (0x1<<20)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY6_SIZE                                                                  20		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY7                                                                       (0x1<<21)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM0_PARITY7_SIZE                                                                  21		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY0                                                                       (0x1<<22)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY0_SIZE                                                                  22		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY1                                                                       (0x1<<23)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY1_SIZE                                                                  23		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY2                                                                       (0x1<<24)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY2_SIZE                                                                  24		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY3                                                                       (0x1<<25)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY3_SIZE                                                                  25		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY4                                                                       (0x1<<26)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY4_SIZE                                                                  26		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY5                                                                       (0x1<<27)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY5_SIZE                                                                  27		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY6                                                                       (0x1<<28)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY6_SIZE                                                                  28		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY7                                                                       (0x1<<29)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_RAM1_PARITY7_SIZE                                                                  29		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PRAM_LOW_PARITY                                                                    (0x1<<30)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PRAM_LOW_PARITY_SIZE                                                               30		
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PRAM_HIGH_PARITY                                                                   (0x1<<31)
	#define CSEM_CSEM_PRTY_STS_WR_0_REG_PRAM_HIGH_PARITY_SIZE                                                              31
#define CSEM_REG_CSEM_PRTY_MASK_0                                                                                          0x200130UL //ACCESS:RW  DataWidth:0x20  Description: Parity mask register #0 read/write		
	#define CSEM_CSEM_PRTY_MASK_0_REG_PARITY                                                                               (0x1<<0)
	#define CSEM_CSEM_PRTY_MASK_0_REG_PARITY_SIZE                                                                          0		
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_DRA_WR_FIFO_PARITY                                                              (0x1<<1)
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_DRA_WR_FIFO_PARITY_SIZE                                                         1		
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_DRA_RD_FIFO_PARITY                                                              (0x1<<2)
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_DRA_RD_FIFO_PARITY_SIZE                                                         2		
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_RAM0_RD_FIFO_PARITY                                                             (0x1<<3)
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_RAM0_RD_FIFO_PARITY_SIZE                                                        3		
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_RAM1_RD_FIFO_PARITY                                                             (0x1<<4)
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_RAM1_RD_FIFO_PARITY_SIZE                                                        4		
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_RAM0_WR_FIFO_PARITY                                                             (0x1<<5)
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_RAM0_WR_FIFO_PARITY_SIZE                                                        5		
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_RAM1_WR_FIFO_PARITY                                                             (0x1<<6)
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_RAM1_WR_FIFO_PARITY_SIZE                                                        6		
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_EXT_FIFO_PARITY                                                                 (0x1<<7)
	#define CSEM_CSEM_PRTY_MASK_0_REG_SYNC_EXT_FIFO_PARITY_SIZE                                                            7		
	#define CSEM_CSEM_PRTY_MASK_0_REG_FIC0_FIFO_PARITY                                                                     (0x1<<8)
	#define CSEM_CSEM_PRTY_MASK_0_REG_FIC0_FIFO_PARITY_SIZE                                                                8		
	#define CSEM_CSEM_PRTY_MASK_0_REG_FIC1_FIFO_PARITY                                                                     (0x1<<9)
	#define CSEM_CSEM_PRTY_MASK_0_REG_FIC1_FIFO_PARITY_SIZE                                                                9		
	#define CSEM_CSEM_PRTY_MASK_0_REG_PAS_FIFO_PARITY                                                                      (0x1<<10)
	#define CSEM_CSEM_PRTY_MASK_0_REG_PAS_FIFO_PARITY_SIZE                                                                 10		
	#define CSEM_CSEM_PRTY_MASK_0_REG_PAS_PARITY0                                                                          (0x1<<11)
	#define CSEM_CSEM_PRTY_MASK_0_REG_PAS_PARITY0_SIZE                                                                     11		
	#define CSEM_CSEM_PRTY_MASK_0_REG_PAS_PARITY1                                                                          (0x1<<12)
	#define CSEM_CSEM_PRTY_MASK_0_REG_PAS_PARITY1_SIZE                                                                     12		
	#define CSEM_CSEM_PRTY_MASK_0_REG_INT_TABLE_PARITY                                                                     (0x1<<13)
	#define CSEM_CSEM_PRTY_MASK_0_REG_INT_TABLE_PARITY_SIZE                                                                13		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY0                                                                         (0x1<<14)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY0_SIZE                                                                    14		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY1                                                                         (0x1<<15)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY1_SIZE                                                                    15		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY2                                                                         (0x1<<16)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY2_SIZE                                                                    16		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY3                                                                         (0x1<<17)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY3_SIZE                                                                    17		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY4                                                                         (0x1<<18)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY4_SIZE                                                                    18		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY5                                                                         (0x1<<19)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY5_SIZE                                                                    19		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY6                                                                         (0x1<<20)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY6_SIZE                                                                    20		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY7                                                                         (0x1<<21)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM0_PARITY7_SIZE                                                                    21		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY0                                                                         (0x1<<22)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY0_SIZE                                                                    22		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY1                                                                         (0x1<<23)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY1_SIZE                                                                    23		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY2                                                                         (0x1<<24)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY2_SIZE                                                                    24		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY3                                                                         (0x1<<25)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY3_SIZE                                                                    25		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY4                                                                         (0x1<<26)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY4_SIZE                                                                    26		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY5                                                                         (0x1<<27)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY5_SIZE                                                                    27		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY6                                                                         (0x1<<28)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY6_SIZE                                                                    28		
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY7                                                                         (0x1<<29)
	#define CSEM_CSEM_PRTY_MASK_0_REG_RAM1_PARITY7_SIZE                                                                    29		
	#define CSEM_CSEM_PRTY_MASK_0_REG_PRAM_LOW_PARITY                                                                      (0x1<<30)
	#define CSEM_CSEM_PRTY_MASK_0_REG_PRAM_LOW_PARITY_SIZE                                                                 30		
	#define CSEM_CSEM_PRTY_MASK_0_REG_PRAM_HIGH_PARITY                                                                     (0x1<<31)
	#define CSEM_CSEM_PRTY_MASK_0_REG_PRAM_HIGH_PARITY_SIZE                                                                31
#define CSEM_REG_CSEM_PRTY_STS_1                                                                                           0x200134UL //ACCESS:R  DataWidth:0x5  Description: Parity register #1 read		
	#define CSEM_CSEM_PRTY_STS_1_REG_SYNC_DBG_PARITY                                                                       (0x1<<0)
	#define CSEM_CSEM_PRTY_STS_1_REG_SYNC_DBG_PARITY_SIZE                                                                  0		
	#define CSEM_CSEM_PRTY_STS_1_REG_SLOW_DBG_PARITY                                                                       (0x1<<1)
	#define CSEM_CSEM_PRTY_STS_1_REG_SLOW_DBG_PARITY_SIZE                                                                  1		
	#define CSEM_CSEM_PRTY_STS_1_REG_CAM_PARITY                                                                            (0x1<<2)
	#define CSEM_CSEM_PRTY_STS_1_REG_CAM_PARITY_SIZE                                                                       2		
	#define CSEM_CSEM_PRTY_STS_1_REG_STORM_RF0_PARITY                                                                      (0x1<<3)
	#define CSEM_CSEM_PRTY_STS_1_REG_STORM_RF0_PARITY_SIZE                                                                 3		
	#define CSEM_CSEM_PRTY_STS_1_REG_STORM_RF1_PARITY                                                                      (0x1<<4)
	#define CSEM_CSEM_PRTY_STS_1_REG_STORM_RF1_PARITY_SIZE                                                                 4
#define CSEM_REG_CSEM_PRTY_STS_CLR_1                                                                                       0x200138UL //ACCESS:RC  DataWidth:0x5  Description: Parity register #1 read clear		
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_SYNC_DBG_PARITY                                                                   (0x1<<0)
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_SYNC_DBG_PARITY_SIZE                                                              0		
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_SLOW_DBG_PARITY                                                                   (0x1<<1)
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_SLOW_DBG_PARITY_SIZE                                                              1		
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_CAM_PARITY                                                                        (0x1<<2)
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_CAM_PARITY_SIZE                                                                   2		
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_STORM_RF0_PARITY                                                                  (0x1<<3)
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_STORM_RF0_PARITY_SIZE                                                             3		
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_STORM_RF1_PARITY                                                                  (0x1<<4)
	#define CSEM_CSEM_PRTY_STS_CLR_1_REG_STORM_RF1_PARITY_SIZE                                                             4
#define CSEM_REG_CSEM_PRTY_STS_WR_1                                                                                        0x20013cUL //ACCESS:WR  DataWidth:0x5  Description: Parity register #1 bit set or clear		
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_SYNC_DBG_PARITY                                                                    (0x1<<0)
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_SYNC_DBG_PARITY_SIZE                                                               0		
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_SLOW_DBG_PARITY                                                                    (0x1<<1)
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_SLOW_DBG_PARITY_SIZE                                                               1		
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_CAM_PARITY                                                                         (0x1<<2)
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_CAM_PARITY_SIZE                                                                    2		
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_STORM_RF0_PARITY                                                                   (0x1<<3)
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_STORM_RF0_PARITY_SIZE                                                              3		
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_STORM_RF1_PARITY                                                                   (0x1<<4)
	#define CSEM_CSEM_PRTY_STS_WR_1_REG_STORM_RF1_PARITY_SIZE                                                              4
#define CSEM_REG_CSEM_PRTY_MASK_1                                                                                          0x200140UL //ACCESS:RW  DataWidth:0x5  Description: Parity mask register #1 read/write		
	#define CSEM_CSEM_PRTY_MASK_1_REG_SYNC_DBG_PARITY                                                                      (0x1<<0)
	#define CSEM_CSEM_PRTY_MASK_1_REG_SYNC_DBG_PARITY_SIZE                                                                 0		
	#define CSEM_CSEM_PRTY_MASK_1_REG_SLOW_DBG_PARITY                                                                      (0x1<<1)
	#define CSEM_CSEM_PRTY_MASK_1_REG_SLOW_DBG_PARITY_SIZE                                                                 1		
	#define CSEM_CSEM_PRTY_MASK_1_REG_CAM_PARITY                                                                           (0x1<<2)
	#define CSEM_CSEM_PRTY_MASK_1_REG_CAM_PARITY_SIZE                                                                      2		
	#define CSEM_CSEM_PRTY_MASK_1_REG_STORM_RF0_PARITY                                                                     (0x1<<3)
	#define CSEM_CSEM_PRTY_MASK_1_REG_STORM_RF0_PARITY_SIZE                                                                3		
	#define CSEM_CSEM_PRTY_MASK_1_REG_STORM_RF1_PARITY                                                                     (0x1<<4)
	#define CSEM_CSEM_PRTY_MASK_1_REG_STORM_RF1_PARITY_SIZE                                                                4
#define CSEM_REG_RAM0_TM1                                                                                                  0x20014cUL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for memory ram0_1
#define CSEM_REG_RAM0_TM2                                                                                                  0x200150UL //ACCESS:RW  DataWidth:0x5  Description: TM bits  for memory ram0_2
#define CSEM_REG_ECO_RESERVED                                                                                              0x2003a8UL //ACCESS:RW  DataWidth:0x8  Description: Reserved bits for ECO
#define CSEM_REG_FIFOS_TM                                                                                                  0x2003acUL //ACCESS:RW  DataWidth:0xe  Description: TM bits  for  FIC0_LSB [1:0]; FIC0_MSB[3:2]; FIC1_LSB[5:4]; FIC1_MSB[7:6]; DBG_LSB[9:8];DBG_MSB[11:10]; EXT_PAS[13:12]
#define CSEM_REG_ARBITER_REQUEST                                                                                           0x200200UL //ACCESS:R  DataWidth:0x5  Description: dra arbiter last request: 0-fic0; 1-fic1; 2-priority0; 3-priority1; 4-priority2
#define CSEM_REG_ARBITER_REQUEST_SIZE                                                                                      1
#define CSEM_REG_ARBITER_SELECT                                                                                            0x200204UL //ACCESS:R  DataWidth:0x5  Description: dra arbiter last selection: 0-fic0; 1-fic1; 2-priority0; 3-priority1; 4-priority2
#define CSEM_REG_ARBITER_SELECT_SIZE                                                                                       1
#define CSEM_REG_ARBITER_SLOT                                                                                              0x200208UL //ACCESS:R  DataWidth:0x5  Description: dra arbiter last slot
#define CSEM_REG_ARBITER_SLOT_SIZE                                                                                         1
#define CSEM_REG_DBG_IF_FULL                                                                                               0x20020cUL //ACCESS:R  DataWidth:0x1  Description: DBG IF is full in sem_slow_ls_dbg
#define CSEM_REG_DBG_IF_FULL_SIZE                                                                                          1
#define CSEM_REG_DRA_EMPTY                                                                                                 0x200210UL //ACCESS:R  DataWidth:0x1  Description: This register is active when FIN FIO  is empty and DRA RD FIFO is empty
#define CSEM_REG_DRA_EMPTY_SIZE                                                                                            1
#define CSEM_REG_EXT_PAS_EMPTY                                                                                             0x200214UL //ACCESS:R  DataWidth:0x1  Description: EXT_PAS FIFO empty in sem_slow
#define CSEM_REG_EXT_PAS_EMPTY_SIZE                                                                                        1
#define CSEM_REG_EXT_PAS_FULL                                                                                              0x200218UL //ACCESS:R  DataWidth:0x1  Description: EXT_PAS FIFO Full in sem_slow
#define CSEM_REG_EXT_PAS_FULL_SIZE                                                                                         1
#define CSEM_REG_EXT_STORE_FREE_ENTRIES                                                                                    0x20021cUL //ACCESS:R  DataWidth:0x6  Description: Number of free entries in the external STORE sync FIFO.
#define CSEM_REG_EXT_STORE_FREE_ENTRIES_SIZE                                                                               1
#define CSEM_REG_EXT_STORE_IF_FULL                                                                                         0x200220UL //ACCESS:R  DataWidth:0x1  Description: EXT_STORE IF is full in sem_slow_ls_ext
#define CSEM_REG_EXT_STORE_IF_FULL_SIZE                                                                                    1
#define CSEM_REG_FIC0_DISABLE                                                                                              0x200224UL //ACCESS:RW  DataWidth:0x1  Description: Disables input messages from FIC0  May be updated during run_time by the microcode 
#define CSEM_REG_FIC0_DISABLE_SIZE                                                                                         1
#define CSEM_REG_FIC0_EMPTY                                                                                                0x200228UL //ACCESS:R  DataWidth:0x1  Description: FIC0 FIFO empty in sem_slow_fic
#define CSEM_REG_FIC0_EMPTY_SIZE                                                                                           1
#define CSEM_REG_FIC0_FULL                                                                                                 0x20022cUL //ACCESS:R  DataWidth:0x1  Description: FIC0 FIFO Full in sem_slow_fic
#define CSEM_REG_FIC0_FULL_SIZE                                                                                            1
#define CSEM_REG_FIC0_LENGTH                                                                                               0x200230UL //ACCESS:R  DataWidth:0x8  Description: Length from FIC0. Active only with ~csem_registers_fic0_length_error.fic0_length_error interrupt
#define CSEM_REG_FIC0_LENGTH_SIZE                                                                                          1
#define CSEM_REG_FIC1_DISABLE                                                                                              0x200234UL //ACCESS:RW  DataWidth:0x1  Description: Disables input messages from FIC1  May be updated during run_time by the microcode 
#define CSEM_REG_FIC1_DISABLE_SIZE                                                                                         1
#define CSEM_REG_FIC1_EMPTY                                                                                                0x200238UL //ACCESS:R  DataWidth:0x1  Description: FIC0 FIFO empty in sem_slow_fic
#define CSEM_REG_FIC1_EMPTY_SIZE                                                                                           1
#define CSEM_REG_FIC1_FULL                                                                                                 0x20023cUL //ACCESS:R  DataWidth:0x1  Description: FIC0 FIFO Full in sem_slow_fic
#define CSEM_REG_FIC1_FULL_SIZE                                                                                            1
#define CSEM_REG_FIC1_LENGTH                                                                                               0x200240UL //ACCESS:R  DataWidth:0x8  Description: Length from FIC1. Active only with ~csem_registers_fic1_length_error.fic1_length_error interrupt
#define CSEM_REG_FIC1_LENGTH_SIZE                                                                                          1
#define CSEM_REG_GPI_DATA                                                                                                  0x200244UL //ACCESS:R  DataWidth:0x18  Description: GPI signals that are inputs to SEMI
#define CSEM_REG_GPI_DATA_SIZE                                                                                             1
#define CSEM_REG_NUM_OF_THREADS                                                                                            0x200248UL //ACCESS:R  DataWidth:0x6  Description: The number of threads currently active 
#define CSEM_REG_NUM_OF_THREADS_SIZE                                                                                       1
#define CSEM_REG_PAS_DISABLE                                                                                               0x20024cUL //ACCESS:RW  DataWidth:0x1  Description: Disables input messages from the passive buffer  May be updated during run_time by the microcode 
#define CSEM_REG_PAS_DISABLE_SIZE                                                                                          1
#define CSEM_REG_PAS_IF_FULL                                                                                               0x200250UL //ACCESS:R  DataWidth:0x1  Description: Full from passive buffer asserted toward SDM
#define CSEM_REG_PAS_IF_FULL_SIZE                                                                                          1
#define CSEM_REG_RAM0_IF_FULL                                                                                              0x200254UL //ACCESS:R  DataWidth:0x1  Description: EXT_RAM0 IF is full in sem_slow_ls_ram
#define CSEM_REG_RAM0_IF_FULL_SIZE                                                                                         1
#define CSEM_REG_RAM1_IF_FULL                                                                                              0x200258UL //ACCESS:R  DataWidth:0x1  Description: EXT_RAM1 IF is full in sem_slow_ls_ram
#define CSEM_REG_RAM1_IF_FULL_SIZE                                                                                         1
#define CSEM_REG_SET0_THREAD_EMPTY                                                                                         0x20025cUL //ACCESS:R  DataWidth:0x1  Description: SET0_THREAD fifo is empty in sem_slow_dra_wr
#define CSEM_REG_SET0_THREAD_EMPTY_SIZE                                                                                    1
#define CSEM_REG_SET0_THREAD_FULL                                                                                          0x200260UL //ACCESS:R  DataWidth:0x1  Description: SET0_THREAD fifo is full in sem_slow_dra_wr
#define CSEM_REG_SET0_THREAD_FULL_SIZE                                                                                     1
#define CSEM_REG_SET1_THREAD_EMPTY                                                                                         0x200264UL //ACCESS:R  DataWidth:0x1  Description: SET1_THREAD fifo is empty in sem_slow_dra_wr
#define CSEM_REG_SET1_THREAD_EMPTY_SIZE                                                                                    1
#define CSEM_REG_SET1_THREAD_FULL                                                                                          0x200268UL //ACCESS:R  DataWidth:0x1  Description: SET1_THREAD fifo is full in sem_slow_dra_wr
#define CSEM_REG_SET1_THREAD_FULL_SIZE                                                                                     1
#define CSEM_REG_SLEEP_THREADS_VALID                                                                                       0x20026cUL //ACCESS:R  DataWidth:0x14  Description: Valid sleeping threads indication have bit per thread
#define CSEM_REG_SLEEP_THREADS_VALID_SIZE                                                                                  1
#define CSEM_REG_SLOW_DBG_ALM_EMPTY                                                                                        0x200270UL //ACCESS:R  DataWidth:0x1  Description: DBG FIFO is almost empty in sem_slow_ls_dbg (31 entry inside fifo)
#define CSEM_REG_SLOW_DBG_ALM_EMPTY_SIZE                                                                                   1
#define CSEM_REG_SLOW_DBG_ALM_FULL                                                                                         0x200274UL //ACCESS:R  DataWidth:0x1  Description: DBG FIFO is almost empty in sem_slow_ls_dbg according to configuration
#define CSEM_REG_SLOW_DBG_ALM_FULL_SIZE                                                                                    1
#define CSEM_REG_SLOW_DBG_EMPTY                                                                                            0x200278UL //ACCESS:R  DataWidth:0x1  Description: DBG FIFO is empty in sem_slow_ls_dbg
#define CSEM_REG_SLOW_DBG_EMPTY_SIZE                                                                                       1
#define CSEM_REG_SLOW_DBG_FULL                                                                                             0x20027cUL //ACCESS:R  DataWidth:0x1  Description: DBG FIFO is full in sem_slow_ls_dbg
#define CSEM_REG_SLOW_DBG_FULL_SIZE                                                                                        1
#define CSEM_REG_SLOW_DRA_FIN_EMPTY                                                                                        0x200280UL //ACCESS:R  DataWidth:0x1  Description: FIN fifo is empty in sem_slow_dra_sync
#define CSEM_REG_SLOW_DRA_FIN_EMPTY_SIZE                                                                                   1
#define CSEM_REG_SLOW_DRA_FIN_FULL                                                                                         0x200284UL //ACCESS:R  DataWidth:0x1  Description: FIN fifo is full in sem_slow_dra_sync (never may be active)
#define CSEM_REG_SLOW_DRA_FIN_FULL_SIZE                                                                                    1
#define CSEM_REG_SLOW_DRA_INT_EMPTY                                                                                        0x200288UL //ACCESS:R  DataWidth:0x1  Description: Interrupt fifo is empty in sem_slow_dra_sync
#define CSEM_REG_SLOW_DRA_INT_EMPTY_SIZE                                                                                   1
#define CSEM_REG_SLOW_DRA_INT_FULL                                                                                         0x20028cUL //ACCESS:R  DataWidth:0x1  Description: Interrupt fifo is full in sem_slow_dra_int
#define CSEM_REG_SLOW_DRA_INT_FULL_SIZE                                                                                    1
#define CSEM_REG_SLOW_DRA_RD_EMPTY                                                                                         0x200290UL //ACCESS:R  DataWidth:0x1  Description: DRA_RD pop fifo is empty in sem_slow_dra_sync
#define CSEM_REG_SLOW_DRA_RD_EMPTY_SIZE                                                                                    1
#define CSEM_REG_SLOW_DRA_RD_FULL                                                                                          0x200294UL //ACCESS:R  DataWidth:0x1  Description: DRA_RD pop fifo is full in sem_slow_dra_sync
#define CSEM_REG_SLOW_DRA_RD_FULL_SIZE                                                                                     1
#define CSEM_REG_SLOW_DRA_WR_EMPTY                                                                                         0x200298UL //ACCESS:R  DataWidth:0x1  Description: DRA_WR push fifo is empty in sem_slow_dra_sync
#define CSEM_REG_SLOW_DRA_WR_EMPTY_SIZE                                                                                    1
#define CSEM_REG_SLOW_DRA_WR_FULL                                                                                          0x20029cUL //ACCESS:R  DataWidth:0x1  Description: DRA_WR push fifo is full in sem_slow_dra_sync
#define CSEM_REG_SLOW_DRA_WR_FULL_SIZE                                                                                     1
#define CSEM_REG_SLOW_EXT_STORE_EMPTY                                                                                      0x2002a0UL //ACCESS:R  DataWidth:0x1  Description: EXT_STORE FIFO is empty in sem_slow_ls_ext
#define CSEM_REG_SLOW_EXT_STORE_EMPTY_SIZE                                                                                 1
#define CSEM_REG_SLOW_EXT_STORE_FULL                                                                                       0x2002a4UL //ACCESS:R  DataWidth:0x1  Description: EXT_STORE FIFO is full in sem_slow_ls_ext
#define CSEM_REG_SLOW_EXT_STORE_FULL_SIZE                                                                                  1
#define CSEM_REG_SLOW_RAM0_RD_EMPTY                                                                                        0x2002a8UL //ACCESS:R  DataWidth:0x1  Description: EXT_RD_RAM0 FIFO is empty in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM0_RD_EMPTY_SIZE                                                                                   1
#define CSEM_REG_SLOW_RAM0_RD_FULL                                                                                         0x2002acUL //ACCESS:R  DataWidth:0x1  Description: EXT_RD_RAM0 FIFO is full in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM0_RD_FULL_SIZE                                                                                    1
#define CSEM_REG_SLOW_RAM0_WR_ALM_FULL                                                                                     0x2002b0UL //ACCESS:R  DataWidth:0x1  Description: EXT_WR_RAM1 FIFO is almost full in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM0_WR_ALM_FULL_SIZE                                                                                1
#define CSEM_REG_SLOW_RAM0_WR_EMPTY                                                                                        0x2002b4UL //ACCESS:R  DataWidth:0x1  Description: EXT_WR_RAM0 FIFO is empty in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM0_WR_EMPTY_SIZE                                                                                   1
#define CSEM_REG_SLOW_RAM0_WR_FULL                                                                                         0x2002b8UL //ACCESS:R  DataWidth:0x1  Description: EXT_WR_RAM0 FIFO is full in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM0_WR_FULL_SIZE                                                                                    1
#define CSEM_REG_SLOW_RAM1_RD_EMPTY                                                                                        0x2002bcUL //ACCESS:R  DataWidth:0x1  Description: EXT_RD_RAM1 FIFO is empty in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM1_RD_EMPTY_SIZE                                                                                   1
#define CSEM_REG_SLOW_RAM1_RD_FULL                                                                                         0x2002c0UL //ACCESS:R  DataWidth:0x1  Description: EXT_RD_RAM1 FIFO is full in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM1_RD_FULL_SIZE                                                                                    1
#define CSEM_REG_SLOW_RAM1_WR_ALM_FULL                                                                                     0x2002c4UL //ACCESS:R  DataWidth:0x1  Description: EXT_WR_RAM1 FIFO is almost full in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM1_WR_ALM_FULL_SIZE                                                                                1
#define CSEM_REG_SLOW_RAM1_WR_EMPTY                                                                                        0x2002c8UL //ACCESS:R  DataWidth:0x1  Description: EXT_WR_RAM1 FIFO is empty in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM1_WR_EMPTY_SIZE                                                                                   1
#define CSEM_REG_SLOW_RAM1_WR_FULL                                                                                         0x2002ccUL //ACCESS:R  DataWidth:0x1  Description: EXT_WR_RAM1 FIFO is full in sem_slow_ls_ext
#define CSEM_REG_SLOW_RAM1_WR_FULL_SIZE                                                                                    1
#define CSEM_REG_SYNC_DBG_EMPTY                                                                                            0x2002d0UL //ACCESS:R  DataWidth:0x1  Description: DBG FAST SYNC FIFO is empty in sem_slow_ls_sync
#define CSEM_REG_SYNC_DBG_EMPTY_SIZE                                                                                       1
#define CSEM_REG_SYNC_DBG_FULL                                                                                             0x2002d4UL //ACCESS:R  DataWidth:0x1  Description: DBG FAST SYNC FIFO is full in sem_slow_ls_sync
#define CSEM_REG_SYNC_DBG_FULL_SIZE                                                                                        1
#define CSEM_REG_THREAD_ERROR                                                                                              0x2002d8UL //ACCESS:R  DataWidth:0x14  Description: Thread error indication have bit per thread
#define CSEM_REG_THREAD_ERROR_SIZE                                                                                         1
#define CSEM_REG_THREAD_OVERRUN_NUM                                                                                        0x2002dcUL //ACCESS:R  DataWidth:0x14  Description: Threads are sleeping in passive buffer more than ~csem_registers_thread_inter_cnt.thread_inter_cnt number of cycles
#define CSEM_REG_THREAD_OVERRUN_NUM_SIZE                                                                                   1
#define CSEM_REG_THREAD_RDY                                                                                                0x2002e0UL //ACCESS:R  DataWidth:0x14  Description: Thread ready indication have bit per thread
#define CSEM_REG_THREAD_RDY_SIZE                                                                                           1
#define CSEM_REG_THREADS_LIST                                                                                              0x2002e4UL //ACCESS:RW  DataWidth:0x14  Description: List of free threads . There is a bit per thread.
#define CSEM_REG_THREADS_LIST_SIZE                                                                                         1
#define CSEM_REG_WB_MSB                                                                                                    0x2002e8UL //ACCESS:R  DataWidth:0x2  Description: Reset value of this register is right when was not read to ~csem_registers_fic0_fifo.fic0_fifo or ~csem_registers_fic1_fifo.fic1_fifo or ~csem_registers_passive_buffer.passive_buffer. For read from ~csem_registers_passive_buffer.passive_buffer :b0- parity0; b1 parity1. For  read from ~csem_registers_fic0_fifo.fic0_fifo and ~csem_registers_fic1_fifo.fic1_fifo :b1=0 data from ~csem_registers_fic0_fifo.fic0_fifo and ~csem_registers_fic1_fifo.fic1_fifo is valid; b1 =1 ~csem_registers_fic0_fifo.fic0_fifo and ~csem_registers_fic1_fifo.fic1_fifo is empty and data from it must be equal to 0; b0 - parity from ~csem_registers_fic0_fifo.fic0_fifo and ~csem_registers_fic1_fifo.fic1_fifo
#define CSEM_REG_WB_MSB_SIZE                                                                                               1
#define CSEM_REG_FIC0_FIFO                                                                                                 0x200300UL //ACCESS:WB_R  DataWidth:0x80  Description: Debug only. FIC0_fifo: b[127:0] data; b128-parity;b129=1- fifo empty;b129=0-data is valid
#define CSEM_REG_FIC0_FIFO_SIZE                                                                                            4
#define CSEM_REG_FIC1_FIFO                                                                                                 0x200320UL //ACCESS:WB_R  DataWidth:0x80  Description: Debug only. FIC1_fifo read for debugging mode; b[127:0] data; b128-parity;
#define CSEM_REG_FIC1_FIFO_SIZE                                                                                            4
#define CSEM_REG_FIN_COMMAND                                                                                               0x200340UL //ACCESS:WB_R  DataWidth:0x6d  Description: last fin command that was read from fifo. Its spelling in ~csem_registers_fin_fifo.fin_fifo register
#define CSEM_REG_FIN_COMMAND_SIZE                                                                                          4
#define CSEM_REG_FIN_FIFO                                                                                                  0x200360UL //ACCESS:WB_R  DataWidth:0x6d  Description: Debug only. FIn FIFO.  [5:0]   start_rp_foc3; [11:6]    start_rp_foc2;  [17:12]   start_rp_foc1; [23:18]   start_rp_foc0;  [29:24]   end_rp_foc3; [35:30]   end_rp_foc2; [41:36]   end_rp_foc1; [47:42]   end_rp_foc0; [53:48]   lowest rp; [59:54]   highest rp; [65:60]   store start rp; [71:66]   store end rp; [77:72]   load start rp; [83:78]   load end rp; [85:84]   priority; [101:86]  pram address; [102] pas; [103] foc3; [104] foc2; [105] foc1; [106] foc0; [107] release; [108] fin; [109]=1- fin fifo is empty; 0 - data[108:0] is valid
#define CSEM_REG_FIN_FIFO_SIZE                                                                                             4
#define CSEM_REG_VFPF_ERR_NUM                                                                                              0x200380UL //ACCESS:W  DataWidth:0x7  Description: VF or PF ID for reset error bit. Values 0-63 reset error bit for 64 VF; values 64-67 reset error for 4 PF; values 68-127 are not valid.
#define CSEM_REG_VFPF_ERR_NUM_SIZE                                                                                         1
#define CSEM_REG_VF_ERR_VECTOR_LSB                                                                                         0x200388UL //ACCESS:R  DataWidth:0x20  Description: VF/PF error bitmap vector [0-31]
#define CSEM_REG_VF_ERR_VECTOR_LSB_SIZE                                                                                    1
#define CSEM_REG_VF_ERR_VECTOR_MSB                                                                                         0x200390UL //ACCESS:R  DataWidth:0x20  Description: VF/PF error bitmap vector [32-63]
#define CSEM_REG_VF_ERR_VECTOR_MSB_SIZE                                                                                    1
#define CSEM_REG_PF_ERR_VECTOR                                                                                             0x200398UL //ACCESS:R  DataWidth:0x8  Description: VF/PF error bitmap vector [0-7]
#define CSEM_REG_PF_ERR_VECTOR_SIZE                                                                                        1
#define CSEM_REG_THREAD_SET_NUM                                                                                            0x2003a0UL //ACCESS:W  DataWidth:0x5  Description: Thread ID. Write thread ID will set ready indication for this thread ID
#define CSEM_REG_THREAD_SET_NUM_SIZE                                                                                       1
#define CSEM_REG_INT_TABLE                                                                                                 0x200400UL //ACCESS:RW  DataWidth:0xf  Description: Interrupt table  Read and write access to it is not possible in the middle of the work
#define CSEM_REG_INT_TABLE_SIZE                                                                                            256
#define CSEM_REG_PASSIVE_BUFFER                                                                                            0x202000UL //ACCESS:WB  DataWidth:0x80  Description: Debug only. Passive buffer memory
#define CSEM_REG_PASSIVE_BUFFER_SIZE                                                                                       2048
#define CSEM_REG_PASSIVE_BUFFER_MSB                                                                                        0x204000UL //ACCESS:WB  DataWidth:0x80  Description: Debug only. Passive buffer memory MSB that starts from row 512 of passive buffer till row 639
#define CSEM_REG_PASSIVE_BUFFER_MSB_SIZE                                                                                   512
#define CSEM_REG_FAST_MEMORY                                                                                               0x220000UL //ACCESS:RW  DataWidth:0x20  Description: This address space contains all registers and memories that are placed in SEM_FAST block. The SEM_FAST registers are described in appendix B. In order to access the SEM_FAST registers the base address CSEM_REGISTERS_FAST_MEMORY (Offset: 0x220000) should be added to each SEM_FAST register offset.
#define CSEM_REG_FAST_MEMORY_SIZE                                                                                          32768
#define CSEM_REG_PRAM                                                                                                      0x240000UL //ACCESS:WB  DataWidth:0x2e  Description: pram memory. B45 is parity; b[44:0] - data.
#define CSEM_REG_PRAM_SIZE                                                                                                 65536
#define CSEM_REG_CSEM_UNUSED_EMPTY_0                                                                                       0x200144UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_0_SIZE                                                                                  2
#define CSEM_REG_CSEM_UNUSED_EMPTY_1                                                                                       0x200154UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_1_SIZE                                                                                  43
#define CSEM_REG_CSEM_UNUSED_EMPTY_2                                                                                       0x2002ecUL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_2_SIZE                                                                                  5
#define CSEM_REG_CSEM_UNUSED_EMPTY_3                                                                                       0x200384UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_3_SIZE                                                                                  1
#define CSEM_REG_CSEM_UNUSED_EMPTY_4                                                                                       0x20038cUL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_4_SIZE                                                                                  1
#define CSEM_REG_CSEM_UNUSED_EMPTY_5                                                                                       0x200394UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_5_SIZE                                                                                  1
#define CSEM_REG_CSEM_UNUSED_EMPTY_6                                                                                       0x20039cUL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_6_SIZE                                                                                  1
#define CSEM_REG_CSEM_UNUSED_EMPTY_7                                                                                       0x2003a4UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_7_SIZE                                                                                  1
#define CSEM_REG_CSEM_UNUSED_EMPTY_8                                                                                       0x2003b0UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_8_SIZE                                                                                  20
#define CSEM_REG_CSEM_UNUSED_EMPTY_9                                                                                       0x200800UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_9_SIZE                                                                                  1536
#define CSEM_REG_CSEM_UNUSED_EMPTY_10                                                                                      0x204800UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define CSEM_REG_CSEM_UNUSED_EMPTY_10_SIZE                                                                                 28160
#define DBG_REG_CLIENT_ENABLE                                                                                              0xc000UL //ACCESS:RW  DataWidth:0x9  Description: debug only:                            These bits are enables to client interfaces as follows: 0b000000001 - rx; 0b000000010 - nm; 0b000000100 - ulp; 0b000001000 - tx; 0b000010000 - cpt; 0b000100000 - usem; 0b001000000 - xsem; 0b010000000 - tsem; 0b100000000 - csem;
#define DBG_REG_OUTPUT_ENABLE                                                                                              0xc004UL //ACCESS:RW  DataWidth:0x3  Multi Field Register		
	#define DBG_OUTPUT_ENABLE_REG_PCI_REQ_ENABLE                                                                           (0x1<<0)
	#define DBG_OUTPUT_ENABLE_REG_PCI_REQ_ENABLE_SIZE                                                                      0		
	#define DBG_OUTPUT_ENABLE_REG_PCI_DATA_ENABLE                                                                          (0x1<<1)
	#define DBG_OUTPUT_ENABLE_REG_PCI_DATA_ENABLE_SIZE                                                                     1		
	#define DBG_OUTPUT_ENABLE_REG_NIG_ENABLE                                                                               (0x1<<2)
	#define DBG_OUTPUT_ENABLE_REG_NIG_ENABLE_SIZE                                                                          2
#define DBG_REG_CALENDAR_SLOT0                                                                                             0xc008UL //ACCESS:RW  DataWidth:0x4  Description: debug only:                            These bits are a client index for slot 0 in calendar as follows: 0b0000      -     rx;          0b0001      -     nm;          0b0010      -     ulp;          0b0011      -     tx;          0b0100      -     cpt;          0b0101      -     usem;          0b0110      -     xsem;          0b0111      -     tsem;          0b1000      -     csem;     0b1001      -     cpu;       0b1010      -     joint HW;      0b1111      -     None;         
#define DBG_REG_CALENDAR_SLOT1                                                                                             0xc00cUL //ACCESS:RW  DataWidth:0x4  Description: debug only:                            These bits are a client index for slot 1 in calendar as follows: 0b0000      -     rx;          0b0001      -     nm;          0b0010      -     ulp;          0b0011      -     tx;          0b0100      -     cpt;          0b0101      -     usem;          0b0110      -     xsem;          0b0111      -     tsem;          0b1000      -     csem;     0b1001      -     cpu;       0b1010      -     joint HW;      0b1111      -     None; 
#define DBG_REG_CALENDAR_SLOT2                                                                                             0xc010UL //ACCESS:RW  DataWidth:0x4  Description: debug only:                            These bits are a client index for slot 2 in calendar as follows: 0b0000      -     rx;          0b0001      -     nm;          0b0010      -     ulp;          0b0011      -     tx;          0b0100      -     cpt;          0b0101      -     usem;          0b0110      -     xsem;          0b0111      -     tsem;          0b1000      -     csem;     0b1001      -     cpu;       0b1010      -     joint HW;      0b1111      -     None; 
#define DBG_REG_CALENDAR_SLOT3                                                                                             0xc014UL //ACCESS:RW  DataWidth:0x4  Description: debug only:                            These bits are a client index for slot 3 in calendar as follows: 0b0000      -     rx;          0b0001      -     nm;          0b0010      -     ulp;          0b0011      -     tx;          0b0100      -     cpt;          0b0101      -     usem;          0b0110      -     xsem;          0b0111      -     tsem;          0b1000      -     csem;     0b1001      -     cpu;       0b1010      -     joint HW;      0b1111      -     None; 
#define DBG_REG_CALENDAR_SLOT4                                                                                             0xc018UL //ACCESS:RW  DataWidth:0x4  Description: debug only:                            These bits are a client index for slot 4 in calendar as follows: 0b0000      -     rx;          0b0001      -     nm;          0b0010      -     ulp;          0b0011      -     tx;          0b0100      -     cpt;          0b0101      -     usem;          0b0110      -     xsem;          0b0111      -     tsem;          0b1000      -     csem;     0b1001      -     cpu;       0b1010      -     joint HW;      0b1111      -     None; 
#define DBG_REG_CALENDAR_SLOT5                                                                                             0xc01cUL //ACCESS:RW  DataWidth:0x4  Description: debug only:                            These bits are a client index for slot 5 in calendar as follows: 0b0000      -     rx;          0b0001      -     nm;          0b0010      -     ulp;          0b0011      -     tx;          0b0100      -     cpt;          0b0101      -     usem;          0b0110      -     xsem;          0b0111      -     tsem;          0b1000      -     csem;     0b1001      -     cpu;       0b1010      -     joint HW;      0b1111      -     None; 
#define DBG_REG_CALENDAR_SLOT6                                                                                             0xc020UL //ACCESS:RW  DataWidth:0x4  Description: debug only:                            These bits are a client index for slot 6 in calendar as follows: 0b0000      -     rx;          0b0001      -     nm;          0b0010      -     ulp;          0b0011      -     tx;          0b0100      -     cpt;          0b0101      -     usem;          0b0110      -     xsem;          0b0111      -     tsem;          0b1000      -     csem;     0b1001      -     cpu;       0b1010      -     joint HW;      0b1111      -     None; 
#define DBG_REG_CALENDAR_SLOT7                                                                                             0xc024UL //ACCESS:RW  DataWidth:0x4  Description: debug only:                            These bits are a client index for slot 7 in calendar as follows: 0b0000      -     rx;          0b0001      -     nm;          0b0010      -     ulp;          0b0011      -     tx;          0b0100      -     cpt;          0b0101      -     usem;          0b0110      -     xsem;          0b0111      -     tsem;          0b1000      -     csem;     0b1001      -     cpu;       0b1010      -     joint HW;      0b1111      -     None; 
#define DBG_REG_CALENDAR_PACE                                                                                              0xc028UL //ACCESS:RW  DataWidth:0x8  Description: debug only:                            This bit indicates the calendar pacing which is the number of cycles the calendar stays on the same slot before moving to the next slot to support lower rates (During the number of cycles configured in the #dbg_registers_calendar_pace only one cycle can be valid)
#define DBG_REG_FRAMING_MODE                                                                                               0xc02cUL //ACCESS:RW  DataWidth:0x2  Description: debug only:                            These bits indicate the framing mode:                           0  -  tdm (32/64) mode;            1  -  64 bits mode;                   2  -  24 bits mode;
#define DBG_REG_DEBUG_TARGET                                                                                               0xc030UL //ACCESS:RW  DataWidth:0x2  Description: debug only:                            These bits indicates the target of the debug data:                    0 - internal buffer;                    1 - NIG;                                  2 - PCI;
#define DBG_REG_FULL_MODE                                                                                                  0xc034UL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            This bit indicates whether data will be wrapped (oldest data is thrown) or overflowed-one shot (newest data is thrown) as follows:                                (a) When ~dbg_registers_debug_target=2/0 (PCI/internal buffer):              1 - wrap;                                 0 - One Shot;                       (b) When ~dbg_registers_debug_target=1 (NIG):                                     1 - constant send;                   0 - One Shot;
#define DBG_REG_ETHERNET_HDR0                                                                                              0xc038UL //ACCESS:RW  DataWidth:0x20  Description: debug only:                            These bits indicate the value of the ethernet header: bytes 0:3; The ethernet header is 14 bytes length which are being added at the beginning of the packet in network order
#define DBG_REG_ETHERNET_HDR1                                                                                              0xc03cUL //ACCESS:RW  DataWidth:0x20  Description: debug only:                            These bits indicate the value of the ethernet header: bytes 4:7; The ethernet header is 14 bytes length which are being added at the beginning of the packet in network order
#define DBG_REG_ETHERNET_HDR2                                                                                              0xc040UL //ACCESS:RW  DataWidth:0x20  Description: debug only:                            These bits indicate the value of the ethernet header: bytes 8:11; The ethernet header is 14 bytes length which are being added at the beginning of the packet in network order
#define DBG_REG_ETHERNET_HDR3                                                                                              0xc044UL //ACCESS:RW  DataWidth:0x10  Description: debug only:                            These bits indicate the value of the ethernet header: bytes 12:13; The ethernet header is 14 bytes length which are being added at the beginning of the packet in network order
#define DBG_REG_PCI_EXT_BUFFER_STRT_ADDR_LSB                                                                               0xc048UL //ACCESS:RW  DataWidth:0x20  Description: debug only:                            LSB of external PCI buffer start address; MUST be configured BEFORE pci_req_credit is configured
#define DBG_REG_PCI_EXT_BUFFER_STRT_ADDR_MSB                                                                               0xc04cUL //ACCESS:RW  DataWidth:0x20  Description: debug only:                            MSB of external PCI buffer start address; MUST be configured BEFORE pci_req_credit is configured
#define DBG_REG_PCI_EXT_BUFFER_SIZE                                                                                        0xc050UL //ACCESS:RW  DataWidth:0x18  Description: debug only:                            These bits indicate the value of the external PCI buffer size in 256 Byte chunks (The reset value is for 128 Mbyte buffer)
#define DBG_REG_NIG_DATA_LIMIT_SIZE                                                                                        0xc054UL //ACCESS:RW  DataWidth:0x16  Description: debug only:                            These bits indicate the max value of 1024 Byte data chunks sent through the NIG (The reset value is for 4M chunks of 1024 data byte each); Relevant only when debug_target=1 (NIG) & full_mode=0 (one-shot)
#define DBG_REG_PCI_VQ_ID                                                                                                  0xc058UL //ACCESS:RW  DataWidth:0x5  Description: debug only:                            This bit is a handle given to the PCI block to refer to this request
#define DBG_REG_CPU_DEBUG_FRAME                                                                                            0xc05cUL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            This bit indicate the frame signal of the debug data that arrives from the CPU
#define DBG_REG_CPU_TIMEOUT                                                                                                0xc060UL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            Timeout operation initiated by the CPU; prior to initiating a timeout event all inputs must be disabled; Timeout signal must stay high until all data was fully sent to nig or pci and the internal buffer is empty
#define DBG_REG_DBG_BLOCK_ON                                                                                               0xc064UL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            This bit enables the operation of the debug block; This bit should be set upon completion of all required configuration for the dbg block and shouldn't be reset during all operational phase of the block;
#define DBG_REG_NUM_OF_QWORDS_SENT0                                                                                        0xc068UL //ACCESS:ST  DataWidth:0x20  Description: debug only:                            These bits represent the total number of qwords sent from the dbg block to output interface (NIG/PCI) 
#define DBG_REG_TDM64_ENABLE                                                                                               0xc06cUL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            This bit indicates tdm working mode as follows:                     (a) 1 -  enables tdm64 mechanism which allows 64 bit of data. In this case the 32 lsb are chosen by the tdm mechanism using slots 0..6 and the 32 msb are taken from the joint HW and are marked as slot number 7;                 (b) 0 - disables the tdm64 mechanism hence allowing 32 bits of data only; the tdm operation mode allows only the 32 lsb of data. In this case the data is chosen by the tdm mechanism using slots 0..7  
#define DBG_REG_IMMEDIATE_ACK                                                                                              0xc070UL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            This bit indicates that an immediate ack should be sent to the CPU upon writing to ~dbg_registers_cpu_debug_data and an interrupt will be sent when a new write can be issued (after the data was actually taken); If 0 then the ack will be delayed until a new write can be issued by the CPU (after the data was actually taken)
#define DBG_REG_NO_GRANT_ON_FULL                                                                                           0xc074UL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            This bit indicate whether grant will be issued by the dbg block towards the storms in case the internal buffer is almost full as follows:                                   (a) 1 -  no grants will be made to the storms when the internal buffer is almost full. When the buffer will be partialy freed (enough for a complete data chunk) then grant is resumed;  (b) 0 - grant is supplied every time the matching storms's slot is chosen disregarding the volume status of the internal buffer. 
#define DBG_REG_FULL_BUFFER_THR                                                                                            0xc078UL //ACCESS:RW  DataWidth:0x7  Description: debug only:                            These bits indicate the value of the internal buffer almost full threshold used for deciding when ~dbg_registers_dbg_buffer_full output should go high/low; holds the number of 128 bit free lines in the internal buffer under which the full would go high; not applicable when ~dbg_registers_debug_target=0 (internal buffer) and ~dbg_registers_full_mode=1 (wrap);
#define DBG_REG_PCI_LOGIC_ADDR                                                                                             0xc07cUL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            This bit indicates logical/physical address in PCI request as follows:                 (a) 1 - logical address;           (b) 0 - physical address;
#define DBG_REG_PATTERN_RECOGNITION_DISABLE                                                                                0xc080UL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            For pattern recognition usage: This bit indicates whether the pattern recognition feature is disabled/enabled as follows:   (a) 1 - disabled;                     (b) 0 - enabled;
#define DBG_REG_PATTERN_RECOGNITION_STORAGE_MODE                                                                           0xc084UL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            For pattern recognition usage: This bit indicates the trigger behavior of the pattern recognition feature as follows:  (a) 1 - stop debug data storgae when the expected pattern is initially recognized;                (b) 0 - start debug data storage when the expected pattern is initially recognized
#define DBG_REG_PATTERN_RECOGNITION_FILTER                                                                                 0xc088UL //ACCESS:RW  DataWidth:0x1  Description: debug only:                            For pattern recognition usage:  This bit indicates whether data is continously stored in the dbg block until/from pattern recognition initial event; or stored only in cycles of a pattern recognition event occurence as follows:             (a) 1 - enable continuously data storage after/before first occurence of pattern recognition;                           (b) 0 - enable data storage only in cycles of a pttern recognition event occurence
#define DBG_REG_DBG_INT_STS                                                                                                0xc08cUL //ACCESS:R  DataWidth:0x2  Description: Interrupt register #0 read		
	#define DBG_DBG_INT_STS_REG_ADDRESS_ERROR                                                                              (0x1<<0)
	#define DBG_DBG_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                         0		
	#define DBG_DBG_INT_STS_REG_CPU_DATA_TAKEN_INTR                                                                        (0x1<<1)
	#define DBG_DBG_INT_STS_REG_CPU_DATA_TAKEN_INTR_SIZE                                                                   1
#define DBG_REG_DBG_INT_STS_CLR                                                                                            0xc090UL //ACCESS:RC  DataWidth:0x2  Description: Interrupt register #0 read clear		
	#define DBG_DBG_INT_STS_CLR_REG_ADDRESS_ERROR                                                                          (0x1<<0)
	#define DBG_DBG_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                     0		
	#define DBG_DBG_INT_STS_CLR_REG_CPU_DATA_TAKEN_INTR                                                                    (0x1<<1)
	#define DBG_DBG_INT_STS_CLR_REG_CPU_DATA_TAKEN_INTR_SIZE                                                               1
#define DBG_REG_DBG_INT_STS_WR                                                                                             0xc094UL //ACCESS:WR  DataWidth:0x2  Description: Interrupt register #0 bit set or clear		
	#define DBG_DBG_INT_STS_WR_REG_ADDRESS_ERROR                                                                           (0x1<<0)
	#define DBG_DBG_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                      0		
	#define DBG_DBG_INT_STS_WR_REG_CPU_DATA_TAKEN_INTR                                                                     (0x1<<1)
	#define DBG_DBG_INT_STS_WR_REG_CPU_DATA_TAKEN_INTR_SIZE                                                                1
#define DBG_REG_DBG_INT_MASK                                                                                               0xc098UL //ACCESS:RW  DataWidth:0x2  Description: Interrupt mask register #0 read/write		
	#define DBG_DBG_INT_MASK_REG_ADDRESS_ERROR                                                                             (0x1<<0)
	#define DBG_DBG_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                        0		
	#define DBG_DBG_INT_MASK_REG_CPU_DATA_TAKEN_INTR                                                                       (0x1<<1)
	#define DBG_DBG_INT_MASK_REG_CPU_DATA_TAKEN_INTR_SIZE                                                                  1
#define DBG_REG_DBG_PRTY_STS                                                                                               0xc09cUL //ACCESS:R  DataWidth:0x1  Description: Parity register #0 read		
	#define DBG_DBG_PRTY_STS_REG_PARITY                                                                                    (0x1<<0)
	#define DBG_DBG_PRTY_STS_REG_PARITY_SIZE                                                                               0
#define DBG_REG_DBG_PRTY_STS_CLR                                                                                           0xc0a0UL //ACCESS:RC  DataWidth:0x1  Description: Parity register #0 read clear		
	#define DBG_DBG_PRTY_STS_CLR_REG_PARITY                                                                                (0x1<<0)
	#define DBG_DBG_PRTY_STS_CLR_REG_PARITY_SIZE                                                                           0
#define DBG_REG_DBG_PRTY_STS_WR                                                                                            0xc0a4UL //ACCESS:WR  DataWidth:0x1  Description: Parity register #0 bit set or clear		
	#define DBG_DBG_PRTY_STS_WR_REG_PARITY                                                                                 (0x1<<0)
	#define DBG_DBG_PRTY_STS_WR_REG_PARITY_SIZE                                                                            0
#define DBG_REG_DBG_PRTY_MASK                                                                                              0xc0a8UL //ACCESS:RW  DataWidth:0x1  Description: Parity mask register #0 read/write		
	#define DBG_DBG_PRTY_MASK_REG_PARITY                                                                                   (0x1<<0)
	#define DBG_DBG_PRTY_MASK_REG_PARITY_SIZE                                                                              0
#define DBG_REG_TRIGGER_ENABLE                                                                                             0xd010UL //ACCESS:RW  DataWidth:0x1  Description: (a) 0 - trigger machine is off (all data will bypass the triggering machine) in this mode trigger_event is never asserted. (b) 1 - trigger machine is on; before AND/OR upon trigger_event assertion data will be recorded according to the configuration of the recording mode before/upon triggering event: rcrd_on_window_pre_trgr_evnt_mode  & rcrd_on_window_post_trgr_evnt_mode
#define DBG_REG_TRIGGER_INTERLEAVED_ENABLE                                                                                 0xd014UL //ACCESS:RW  DataWidth:0x1  Description: (a) 0 - triggering interleaved messages is disbaled.             (b) 1 - triggering interleaved messages is enabled; will be used for triggering on recorded handler messages.                  NOTE: triggering is possible on one level depth of interleaved messages; i.e. if message B is interleaved within message A then it is ok; However if message C is interleaved within message B and message B is interleaved within message A this scenario is NOT supported
#define DBG_REG_TRIGGER_STATE_SLOTS_0                                                                                      0xd018UL //ACCESS:RW  DataWidth:0x8  Description: Valid slots for triggering machine in relevant state. Data from clients which are not in those slots will be dropped (not compared). b0 - slot0; b1 - slot1;. . .;b7 - slot7;         NOTE:  1. NA when framing mode is tdm64 and trigger_state_valid_seli=1; in that case the only client is the JointHW (upper 32 bits of the calendar) and hence the value of trigger_state_slotsi  is disregarded. Each valid cycle will be compared.                    2. all set bits MUST contain the same client 
#define DBG_REG_TRIGGER_STATE_SLOTS_1                                                                                      0xd01cUL //ACCESS:RW  DataWidth:0x8  Description: Valid slots for triggering machine in relevant state. Data from clients which are not in those slots will be dropped (not compared). b0 - slot0; b1 - slot1;. . .;b7 - slot7;         NOTE:  1. NA when framing mode is tdm64 and trigger_state_valid_seli=1; in that case the only client is the JointHW (upper 32 bits of the calendar) and hence the value of trigger_state_slotsi  is disregarded. Each valid cycle will be compared.                    2. all set bits MUST contain the same client 
#define DBG_REG_TRIGGER_STATE_SLOTS_2                                                                                      0xd020UL //ACCESS:RW  DataWidth:0x8  Description: Valid slots for triggering machine in relevant state. Data from clients which are not in those slots will be dropped (not compared). b0 - slot0; b1 - slot1;. . .;b7 - slot7;         NOTE:  1. NA when framing mode is tdm64 and trigger_state_valid_seli=1; in that case the only client is the JointHW (upper 32 bits of the calendar) and hence the value of trigger_state_slotsi  is disregarded. Each valid cycle will be compared.                    2. all set bits MUST contain the same client 
#define DBG_REG_TRIGGER_STATE_VALID_SEL_0                                                                                  0xd024UL //ACCESS:RW  DataWidth:0x1  Description: When working in tdm64 mode there are 2 valid signals as follows:               (1) Valid[3] - validates data[63:32]              (2) Valid[0] - validates data[31:0]          (a) 1 - use valid[3] (compared data is data[63:32] in that case);    (b) 0 - use valid[0] (compared data is data[31:0] in that case).      NOTE:                               1. in each state the triggering machine compares the constraints to single data source only (which means that only data[31:0] / data[63:32] will be compared in each state)               2. if 64 bit framing mode OR tdm32 framing mode then this bit is not relevant; in that case only valid[0] & data[31:0]/data[63:0] are referred.
#define DBG_REG_TRIGGER_STATE_VALID_SEL_1                                                                                  0xd028UL //ACCESS:RW  DataWidth:0x1  Description: When working in tdm64 mode there are 2 valid signals as follows:               (1) Valid[3] - validates data[63:32]              (2) Valid[0] - validates data[31:0]          (a) 1 - use valid[3] (compared data is data[63:32] in that case);    (b) 0 - use valid[0] (compared data is data[31:0] in that case).      NOTE:                               1. in each state the triggering machine compares the constraints to single data source only (which means that only data[31:0] / data[63:32] will be compared in each state)               2. if 64 bit framing mode OR tdm32 framing mode then this bit is not relevant; in that case only valid[0] & data[31:0]/data[63:0] are referred.
#define DBG_REG_TRIGGER_STATE_VALID_SEL_2                                                                                  0xd02cUL //ACCESS:RW  DataWidth:0x1  Description: When working in tdm64 mode there are 2 valid signals as follows:               (1) Valid[3] - validates data[63:32]              (2) Valid[0] - validates data[31:0]          (a) 1 - use valid[3] (compared data is data[63:32] in that case);    (b) 0 - use valid[0] (compared data is data[31:0] in that case).      NOTE:                               1. in each state the triggering machine compares the constraints to single data source only (which means that only data[31:0] / data[63:32] will be compared in each state)               2. if 64 bit framing mode OR tdm32 framing mode then this bit is not relevant; in that case only valid[0] & data[31:0]/data[63:0] are referred.
#define DBG_REG_TRIGGER_STATE_USE_BOTH_SETS_0                                                                              0xd030UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - use both constraint set0 and constraint set1 in relevant state.                                   (b) 0 - use only constraint set0 in relevant state.
#define DBG_REG_TRIGGER_STATE_USE_BOTH_SETS_1                                                                              0xd034UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - use both constraint set0 and constraint set1 in relevant state.                                   (b) 0 - use only constraint set0 in relevant state.
#define DBG_REG_TRIGGER_STATE_USE_BOTH_SETS_2                                                                              0xd038UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - use both constraint set0 and constraint set1 in relevant state.                                   (b) 0 - use only constraint set0 in relevant state.
#define DBG_REG_TRIGGER_STATE_SET_NXT_STATE_0                                                                              0xd03cUL //ACCESS:RW  DataWidth:0x2  Description: Next state in the fsm triggering machine if the referred constraints set in the specified state are met. 
#define DBG_REG_TRIGGER_STATE_SET_NXT_STATE_1                                                                              0xd040UL //ACCESS:RW  DataWidth:0x2  Description: Next state in the fsm triggering machine if the referred constraints set in the specified state are met. 
#define DBG_REG_TRIGGER_STATE_SET_NXT_STATE_2                                                                              0xd044UL //ACCESS:RW  DataWidth:0x2  Description: Next state in the fsm triggering machine if the referred constraints set in the specified state are met. 
#define DBG_REG_TRIGGER_STATE_SET_NXT_STATE_3                                                                              0xd048UL //ACCESS:RW  DataWidth:0x2  Description: Next state in the fsm triggering machine if the referred constraints set in the specified state are met. 
#define DBG_REG_TRIGGER_STATE_SET_NXT_STATE_4                                                                              0xd04cUL //ACCESS:RW  DataWidth:0x2  Description: Next state in the fsm triggering machine if the referred constraints set in the specified state are met. 
#define DBG_REG_TRIGGER_STATE_SET_NXT_STATE_5                                                                              0xd050UL //ACCESS:RW  DataWidth:0x2  Description: Next state in the fsm triggering machine if the referred constraints set in the specified state are met. 
#define DBG_REG_TRIGGER_STATE_SET_COUNT_0                                                                                  0xd054UL //ACCESS:RW  DataWidth:0x10  Description: Number of times that the referred constraints set should be met prior to recognition (moving to next state).           NOTE: value of 0 is NA
#define DBG_REG_TRIGGER_STATE_SET_COUNT_1                                                                                  0xd058UL //ACCESS:RW  DataWidth:0x10  Description: Number of times that the referred constraints set should be met prior to recognition (moving to next state).           NOTE: value of 0 is NA
#define DBG_REG_TRIGGER_STATE_SET_COUNT_2                                                                                  0xd05cUL //ACCESS:RW  DataWidth:0x10  Description: Number of times that the referred constraints set should be met prior to recognition (moving to next state).           NOTE: value of 0 is NA
#define DBG_REG_TRIGGER_STATE_SET_COUNT_3                                                                                  0xd060UL //ACCESS:RW  DataWidth:0x10  Description: Number of times that the referred constraints set should be met prior to recognition (moving to next state).           NOTE: value of 0 is NA
#define DBG_REG_TRIGGER_STATE_SET_COUNT_4                                                                                  0xd064UL //ACCESS:RW  DataWidth:0x10  Description: Number of times that the referred constraints set should be met prior to recognition (moving to next state).           NOTE: value of 0 is NA
#define DBG_REG_TRIGGER_STATE_SET_COUNT_5                                                                                  0xd068UL //ACCESS:RW  DataWidth:0x10  Description: Number of times that the referred constraints set should be met prior to recognition (moving to next state).           NOTE: value of 0 is NA
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_0                                                                             0xd06cUL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_1                                                                             0xd070UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_2                                                                             0xd074UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_3                                                                             0xd078UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_4                                                                             0xd07cUL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_5                                                                             0xd080UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_6                                                                             0xd084UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_7                                                                             0xd088UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_8                                                                             0xd08cUL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_9                                                                             0xd090UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_10                                                                            0xd094UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_11                                                                            0xd098UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_12                                                                            0xd09cUL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_13                                                                            0xd0a0UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_14                                                                            0xd0a4UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_15                                                                            0xd0a8UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_16                                                                            0xd0acUL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_17                                                                            0xd0b0UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_18                                                                            0xd0b4UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_19                                                                            0xd0b8UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_20                                                                            0xd0bcUL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_21                                                                            0xd0c0UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_22                                                                            0xd0c4UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_23                                                                            0xd0c8UL //ACCESS:RW  DataWidth:0x20  Description: The data that need to be compared. The 32 bit vector is determined as follows:                        (a) data[31:0] - if trigger_state_set_cnstr_offseti[0] = 0                         OR                       (b) data[63:32] - if trigger_state_set_cnstr_offseti[0] = 1
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_0                                                                            0xd0ccUL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_1                                                                            0xd0d0UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_2                                                                            0xd0d4UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_3                                                                            0xd0d8UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_4                                                                            0xd0dcUL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_5                                                                            0xd0e0UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_6                                                                            0xd0e4UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_7                                                                            0xd0e8UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_8                                                                            0xd0ecUL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_9                                                                            0xd0f0UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_10                                                                           0xd0f4UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_11                                                                           0xd0f8UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_12                                                                           0xd0fcUL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_13                                                                           0xd100UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_14                                                                           0xd104UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_15                                                                           0xd108UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_16                                                                           0xd10cUL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_17                                                                           0xd110UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_18                                                                           0xd114UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_19                                                                           0xd118UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_20                                                                           0xd11cUL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_21                                                                           0xd120UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_22                                                                           0xd124UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_23                                                                           0xd128UL //ACCESS:RW  DataWidth:0x1  Description: The frame that need to be compared. The 1 bit vector is determined as follows:                    (a) frame[0] - if trigger_state_set_cnstr_offseti[0] = 0                OR                  (b) frame[3] - if trigger_state_set_cnstr_offseti[0] = 1             
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_0                                                                        0xd12cUL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_1                                                                        0xd130UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_2                                                                        0xd134UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_3                                                                        0xd138UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_4                                                                        0xd13cUL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_5                                                                        0xd140UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_6                                                                        0xd144UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_7                                                                        0xd148UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_8                                                                        0xd14cUL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_9                                                                        0xd150UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_10                                                                       0xd154UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_11                                                                       0xd158UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_12                                                                       0xd15cUL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_13                                                                       0xd160UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_14                                                                       0xd164UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_15                                                                       0xd168UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_16                                                                       0xd16cUL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_17                                                                       0xd170UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_18                                                                       0xd174UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_19                                                                       0xd178UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_20                                                                       0xd17cUL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_21                                                                       0xd180UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_22                                                                       0xd184UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_DATA_MASK_23                                                                       0xd188UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_0                                                                       0xd18cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_1                                                                       0xd190UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_2                                                                       0xd194UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_3                                                                       0xd198UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_4                                                                       0xd19cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_5                                                                       0xd1a0UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_6                                                                       0xd1a4UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_7                                                                       0xd1a8UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_8                                                                       0xd1acUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_9                                                                       0xd1b0UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_10                                                                      0xd1b4UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_11                                                                      0xd1b8UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_12                                                                      0xd1bcUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_13                                                                      0xd1c0UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_14                                                                      0xd1c4UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_15                                                                      0xd1c8UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_16                                                                      0xd1ccUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_17                                                                      0xd1d0UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_18                                                                      0xd1d4UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_19                                                                      0xd1d8UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_20                                                                      0xd1dcUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_21                                                                      0xd1e0UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_22                                                                      0xd1e4UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_FRAME_MASK_23                                                                      0xd1e8UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 - the frame is compared; the mask is valid only for the equal operation (trigger_state_set_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_0                                                                            0xd1ecUL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_1                                                                            0xd1f0UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_2                                                                            0xd1f4UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_3                                                                            0xd1f8UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_4                                                                            0xd1fcUL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_5                                                                            0xd200UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_6                                                                            0xd204UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_7                                                                            0xd208UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_8                                                                            0xd20cUL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_9                                                                            0xd210UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_10                                                                           0xd214UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_11                                                                           0xd218UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_12                                                                           0xd21cUL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_13                                                                           0xd220UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_14                                                                           0xd224UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_15                                                                           0xd228UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_16                                                                           0xd22cUL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_17                                                                           0xd230UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_18                                                                           0xd234UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_19                                                                           0xd238UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_20                                                                           0xd23cUL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_21                                                                           0xd240UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_22                                                                           0xd244UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OPRTN_23                                                                           0xd248UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between trigger_state_set_cnstr_datai and the actual data as follows: (a) 000 - equal;     (b) 001 - smaller than (<);     (c) 010 - smaller or equal (<=);     (d) 011 greater or equal (>=);     (e) 100 = greater than (>); 
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_0                                                                            0xd24cUL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_0_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_0                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_0_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_0_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_0_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_0                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_0_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_0_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_1                                                                            0xd250UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_1_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_1                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_1_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_1_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_1_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_1                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_1_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_1_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_2                                                                            0xd254UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_2_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_2                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_2_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_2_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_2_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_2                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_2_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_2_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_3                                                                            0xd258UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_3_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_3                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_3_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_3_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_3_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_3                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_3_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_3_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_4                                                                            0xd25cUL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_4_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_4                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_4_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_4_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_4_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_4                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_4_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_4_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_5                                                                            0xd260UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_5_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_5                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_5_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_5_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_5_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_5                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_5_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_5_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_6                                                                            0xd264UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_6_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_6                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_6_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_6_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_6_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_6                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_6_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_6_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_7                                                                            0xd268UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_7_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_7                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_7_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_7_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_7_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_7                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_7_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_7_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_8                                                                            0xd26cUL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_8_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_8                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_8_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_8_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_8_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_8                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_8_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_8_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_9                                                                            0xd270UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_9_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_9                                  (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_9_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_9_SIZE                             0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_9_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_9                                    (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_9_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_9_SIZE                               5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_10                                                                           0xd274UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_10_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_10                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_10_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_10_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_10_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_10                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_10_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_10_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_11                                                                           0xd278UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_11_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_11                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_11_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_11_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_11_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_11                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_11_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_11_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_12                                                                           0xd27cUL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_12_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_12                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_12_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_12_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_12_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_12                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_12_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_12_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_13                                                                           0xd280UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_13_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_13                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_13_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_13_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_13_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_13                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_13_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_13_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_14                                                                           0xd284UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_14_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_14                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_14_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_14_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_14_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_14                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_14_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_14_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_15                                                                           0xd288UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_15_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_15                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_15_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_15_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_15_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_15                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_15_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_15_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_16                                                                           0xd28cUL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_16_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_16                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_16_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_16_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_16_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_16                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_16_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_16_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_17                                                                           0xd290UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_17_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_17                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_17_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_17_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_17_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_17                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_17_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_17_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_18                                                                           0xd294UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_18_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_18                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_18_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_18_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_18_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_18                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_18_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_18_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_19                                                                           0xd298UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_19_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_19                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_19_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_19_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_19_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_19                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_19_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_19_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_20                                                                           0xd29cUL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_20_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_20                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_20_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_20_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_20_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_20                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_20_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_20_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_21                                                                           0xd2a0UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_21_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_21                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_21_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_21_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_21_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_21                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_21_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_21_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_22                                                                           0xd2a4UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_22_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_22                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_22_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_22_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_22_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_22                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_22_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_22_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_RANGE_23                                                                           0xd2a8UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_23_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_23                                (0x1f<<0)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_23_REG_TRIGGER_STATE_SET_CNSTR_RANGE_WIDTH_23_SIZE                           0		
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_23_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_23                                  (0x1f<<5)
	#define DBG_TRIGGER_STATE_SET_CNSTR_RANGE_23_REG_TRIGGER_STATE_SET_CNSTR_RANGE_LSB_23_SIZE                             5
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_0                                                                           0xd2acUL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_1                                                                           0xd2b0UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_2                                                                           0xd2b4UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_3                                                                           0xd2b8UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_4                                                                           0xd2bcUL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_5                                                                           0xd2c0UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_6                                                                           0xd2c4UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_7                                                                           0xd2c8UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_8                                                                           0xd2ccUL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_9                                                                           0xd2d0UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_10                                                                          0xd2d4UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_11                                                                          0xd2d8UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_12                                                                          0xd2dcUL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_13                                                                          0xd2e0UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_14                                                                          0xd2e4UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_15                                                                          0xd2e8UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_16                                                                          0xd2ecUL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_17                                                                          0xd2f0UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_18                                                                          0xd2f4UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_19                                                                          0xd2f8UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_20                                                                          0xd2fcUL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_21                                                                          0xd300UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_22                                                                          0xd304UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_OFFSET_23                                                                          0xd308UL //ACCESS:RW  DataWidth:0x8  Description: The above value vector (data & frame) should be compared trigger_state_set_cnstr_offseti / 2 cycles after start of message.          
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_0                                                                             0xd30cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_1                                                                             0xd310UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_2                                                                             0xd314UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_3                                                                             0xd318UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_4                                                                             0xd31cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_5                                                                             0xd320UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_6                                                                             0xd324UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_7                                                                             0xd328UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_8                                                                             0xd32cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_9                                                                             0xd330UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_10                                                                            0xd334UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_11                                                                            0xd338UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_12                                                                            0xd33cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_13                                                                            0xd340UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_14                                                                            0xd344UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_15                                                                            0xd348UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_16                                                                            0xd34cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_17                                                                            0xd350UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_18                                                                            0xd354UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_19                                                                            0xd358UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_20                                                                            0xd35cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_21                                                                            0xd360UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_22                                                                            0xd364UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_MUST_23                                                                            0xd368UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector must exist as part of the message.                             (b) 0: the above value vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_0                                                                           0xd36cUL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_1                                                                           0xd370UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_2                                                                           0xd374UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_3                                                                           0xd378UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_4                                                                           0xd37cUL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_5                                                                           0xd380UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_6                                                                           0xd384UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_7                                                                           0xd388UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_8                                                                           0xd38cUL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_9                                                                           0xd390UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_10                                                                          0xd394UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_11                                                                          0xd398UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_12                                                                          0xd39cUL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_13                                                                          0xd3a0UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_14                                                                          0xd3a4UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_15                                                                          0xd3a8UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_16                                                                          0xd3acUL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_17                                                                          0xd3b0UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_18                                                                          0xd3b4UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_19                                                                          0xd3b8UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_20                                                                          0xd3bcUL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_21                                                                          0xd3c0UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_22                                                                          0xd3c4UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_INDRCT_23                                                                          0xd3c8UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the trigger_state_set_cnstr_datai.               (b) 01: indirect: use the recorded value from of fsm triggering machine (trigger_indirect0_recorded_data).          (c) 10: indirect: use the recorded value from of fsm triggering machine (trigger_indirect1_recorded_data).
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_0                                                                           0xd3ccUL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_1                                                                           0xd3d0UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_2                                                                           0xd3d4UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_3                                                                           0xd3d8UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_4                                                                           0xd3dcUL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_5                                                                           0xd3e0UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_6                                                                           0xd3e4UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_7                                                                           0xd3e8UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_8                                                                           0xd3ecUL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_9                                                                           0xd3f0UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_10                                                                          0xd3f4UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_11                                                                          0xd3f8UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_12                                                                          0xd3fcUL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_13                                                                          0xd400UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_14                                                                          0xd404UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_15                                                                          0xd408UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_16                                                                          0xd40cUL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_17                                                                          0xd410UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_18                                                                          0xd414UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_19                                                                          0xd418UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_20                                                                          0xd41cUL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_21                                                                          0xd420UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_22                                                                          0xd424UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_SET_CNSTR_CYCLIC_23                                                                          0xd428UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (trigger_state_set_cnstr_oprtni > 0)                                        (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)                                    
#define DBG_REG_TRIGGER_STATE_MSG_LENGTH_ENABLE_0                                                                          0xd42cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: use trigger_state_msg_lengthi  to determine message boundary.   (b) 0: use trigger_state_valid_seli to determine which frame (frame[0]/frame[3]) signals message boundary (end of message) 
#define DBG_REG_TRIGGER_STATE_MSG_LENGTH_ENABLE_1                                                                          0xd430UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: use trigger_state_msg_lengthi  to determine message boundary.   (b) 0: use trigger_state_valid_seli to determine which frame (frame[0]/frame[3]) signals message boundary (end of message) 
#define DBG_REG_TRIGGER_STATE_MSG_LENGTH_ENABLE_2                                                                          0xd434UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: use trigger_state_msg_lengthi  to determine message boundary.   (b) 0: use trigger_state_valid_seli to determine which frame (frame[0]/frame[3]) signals message boundary (end of message) 
#define DBG_REG_TRIGGER_STATE_MSG_LENGTH_0                                                                                 0xd438UL //ACCESS:RW  DataWidth:0x7  Description: Message length-1  in terms of numbers of cycles.                  NOTE:                                     (a) if for example trigger_state_msg_lengthi=0 then Message length = 1 cycle. (b) if for example trigger_state_msg_lengthi=1 then Message length = 2 cycles. etc.                               (c) Applicable only when trigger_state_msg_length_eni = 1
#define DBG_REG_TRIGGER_STATE_MSG_LENGTH_1                                                                                 0xd43cUL //ACCESS:RW  DataWidth:0x7  Description: Message length-1  in terms of numbers of cycles.                  NOTE:                                     (a) if for example trigger_state_msg_lengthi=0 then Message length = 1 cycle. (b) if for example trigger_state_msg_lengthi=1 then Message length = 2 cycles. etc.                               (c) Applicable only when trigger_state_msg_length_eni = 1
#define DBG_REG_TRIGGER_STATE_MSG_LENGTH_2                                                                                 0xd440UL //ACCESS:RW  DataWidth:0x7  Description: Message length-1  in terms of numbers of cycles.                  NOTE:                                     (a) if for example trigger_state_msg_lengthi=0 then Message length = 1 cycle. (b) if for example trigger_state_msg_lengthi=1 then Message length = 2 cycles. etc.                               (c) Applicable only when trigger_state_msg_length_eni = 1
#define DBG_REG_TRIGGER_INDIRECT0_STATE                                                                                    0xd444UL //ACCESS:RW  DataWidth:0x3  Description: If set then record data in relevant state;       If clear then do not record data in relevant state;          b0: state0; b1: state1; b2: state2;
#define DBG_REG_TRIGGER_INDIRECT0_OFFSET_0                                                                                 0xd448UL //ACCESS:RW  DataWidth:0x8  Description: The offset in relevant state (fsm triggering machine) from beginning of message to the data that should be recorded for indirect value usage.               If set of constraints appear more than once (trigger_state_set_counti >1) then cycle trigger_indirect0_offseti from the last message will be recorded.                                 NOTE: even offsets are for the 32 lsb as uneven offsets are for the 32 msb. For example offset=0 is for cycle 0 for the 32 lsb; offset=1 is for cycle 0 for the 32 msb; offset=2N is for cycle N for the 32 lsb; offset=2N+1 is for cycle N for the 32 msb;
#define DBG_REG_TRIGGER_INDIRECT0_OFFSET_1                                                                                 0xd44cUL //ACCESS:RW  DataWidth:0x8  Description: The offset in relevant state (fsm triggering machine) from beginning of message to the data that should be recorded for indirect value usage.               If set of constraints appear more than once (trigger_state_set_counti >1) then cycle trigger_indirect0_offseti from the last message will be recorded.                                 NOTE: even offsets are for the 32 lsb as uneven offsets are for the 32 msb. For example offset=0 is for cycle 0 for the 32 lsb; offset=1 is for cycle 0 for the 32 msb; offset=2N is for cycle N for the 32 lsb; offset=2N+1 is for cycle N for the 32 msb;
#define DBG_REG_TRIGGER_INDIRECT0_OFFSET_2                                                                                 0xd450UL //ACCESS:RW  DataWidth:0x8  Description: The offset in relevant state (fsm triggering machine) from beginning of message to the data that should be recorded for indirect value usage.               If set of constraints appear more than once (trigger_state_set_counti >1) then cycle trigger_indirect0_offseti from the last message will be recorded.                                 NOTE: even offsets are for the 32 lsb as uneven offsets are for the 32 msb. For example offset=0 is for cycle 0 for the 32 lsb; offset=1 is for cycle 0 for the 32 msb; offset=2N is for cycle N for the 32 lsb; offset=2N+1 is for cycle N for the 32 msb;
#define DBG_REG_TRIGGER_INDIRECT0_SHIFT_0                                                                                  0xd454UL //ACCESS:RW  DataWidth:0x2  Description: Shift vector (byte resolution) for the data trigger_indirect0_recorded_data  The shift is implemented after the recording (after the registering) of the indirect register is implemented.      The comparison with the actual coming data is implemented on the shifted data. 
#define DBG_REG_TRIGGER_INDIRECT0_SHIFT_1                                                                                  0xd458UL //ACCESS:RW  DataWidth:0x2  Description: Shift vector (byte resolution) for the data trigger_indirect0_recorded_data  The shift is implemented after the recording (after the registering) of the indirect register is implemented.      The comparison with the actual coming data is implemented on the shifted data. 
#define DBG_REG_TRIGGER_INDIRECT0_SHIFT_2                                                                                  0xd45cUL //ACCESS:RW  DataWidth:0x2  Description: Shift vector (byte resolution) for the data trigger_indirect0_recorded_data  The shift is implemented after the recording (after the registering) of the indirect register is implemented.      The comparison with the actual coming data is implemented on the shifted data. 
#define DBG_REG_TRIGGER_INDIRECT0_MASK_0                                                                                   0xd460UL //ACCESS:RW  DataWidth:0x4  Description: If set then the relevant byte will be zeroed; if clear then the relevant byte will be registered with its exact data.                   NOTE:                                    (a) Mask is implemented prior to registering the recorded data to trigger_indirect0_recorded_data;                                             (b) The mask is implemented in byte resolution.                     (c) b0: byte0; b1: byte1; b2: byte2; b3: byte2                  (d) useful when trigger_state_set_cnstr_oprtni > 0 (>/</=</=>)
#define DBG_REG_TRIGGER_INDIRECT0_MASK_1                                                                                   0xd464UL //ACCESS:RW  DataWidth:0x4  Description: If set then the relevant byte will be zeroed; if clear then the relevant byte will be registered with its exact data.                   NOTE:                                    (a) Mask is implemented prior to registering the recorded data to trigger_indirect0_recorded_data;                                             (b) The mask is implemented in byte resolution.                     (c) b0: byte0; b1: byte1; b2: byte2; b3: byte2                  (d) useful when trigger_state_set_cnstr_oprtni > 0 (>/</=</=>)
#define DBG_REG_TRIGGER_INDIRECT0_MASK_2                                                                                   0xd468UL //ACCESS:RW  DataWidth:0x4  Description: If set then the relevant byte will be zeroed; if clear then the relevant byte will be registered with its exact data.                   NOTE:                                    (a) Mask is implemented prior to registering the recorded data to trigger_indirect0_recorded_data;                                             (b) The mask is implemented in byte resolution.                     (c) b0: byte0; b1: byte1; b2: byte2; b3: byte2                  (d) useful when trigger_state_set_cnstr_oprtni > 0 (>/</=</=>)
#define DBG_REG_TRIGGER_INDIRECT1_STATE                                                                                    0xd46cUL //ACCESS:RW  DataWidth:0x3  Description: If set then record data in relevant state;       If clear then do not record data in relevant state;          b0: state0; b1: state1; b2: state2;
#define DBG_REG_TRIGGER_INDIRECT1_OFFSET_0                                                                                 0xd470UL //ACCESS:RW  DataWidth:0x8  Description: The offset in relevant state (fsm triggering machine) from beginning of message to the data that should be recorded for indirect value usage.               If set of constraints appear more than once (trigger_state_set_counti >1) then cycle trigger_indirect1_offseti from the last message will be recorded.                                 NOTE: even offsets are for the 32 lsb as uneven offsets are for the 32 msb. For example offset=0 is for cycle 0 for the 32 lsb; offset=1 is for cycle 0 for the 32 msb; offset=2N is for cycle N for the 32 lsb; offset=2N+1 is for cycle N for the 32 msb;
#define DBG_REG_TRIGGER_INDIRECT1_OFFSET_1                                                                                 0xd474UL //ACCESS:RW  DataWidth:0x8  Description: The offset in relevant state (fsm triggering machine) from beginning of message to the data that should be recorded for indirect value usage.               If set of constraints appear more than once (trigger_state_set_counti >1) then cycle trigger_indirect1_offseti from the last message will be recorded.                                 NOTE: even offsets are for the 32 lsb as uneven offsets are for the 32 msb. For example offset=0 is for cycle 0 for the 32 lsb; offset=1 is for cycle 0 for the 32 msb; offset=2N is for cycle N for the 32 lsb; offset=2N+1 is for cycle N for the 32 msb;
#define DBG_REG_TRIGGER_INDIRECT1_OFFSET_2                                                                                 0xd478UL //ACCESS:RW  DataWidth:0x8  Description: The offset in relevant state (fsm triggering machine) from beginning of message to the data that should be recorded for indirect value usage.               If set of constraints appear more than once (trigger_state_set_counti >1) then cycle trigger_indirect1_offseti from the last message will be recorded.                                 NOTE: even offsets are for the 32 lsb as uneven offsets are for the 32 msb. For example offset=0 is for cycle 0 for the 32 lsb; offset=1 is for cycle 0 for the 32 msb; offset=2N is for cycle N for the 32 lsb; offset=2N+1 is for cycle N for the 32 msb;
#define DBG_REG_TRIGGER_INDIRECT1_SHIFT_0                                                                                  0xd47cUL //ACCESS:RW  DataWidth:0x2  Description: Shift vector (byte resolution) for the data trigger_indirect1_recorded_data  The shift is implemented after the recording (after the registering) of the indirect register is implemented.      The comparison with the actual coming data is implemented on the shifted data. 
#define DBG_REG_TRIGGER_INDIRECT1_SHIFT_1                                                                                  0xd480UL //ACCESS:RW  DataWidth:0x2  Description: Shift vector (byte resolution) for the data trigger_indirect1_recorded_data  The shift is implemented after the recording (after the registering) of the indirect register is implemented.      The comparison with the actual coming data is implemented on the shifted data. 
#define DBG_REG_TRIGGER_INDIRECT1_SHIFT_2                                                                                  0xd484UL //ACCESS:RW  DataWidth:0x2  Description: Shift vector (byte resolution) for the data trigger_indirect1_recorded_data  The shift is implemented after the recording (after the registering) of the indirect register is implemented.      The comparison with the actual coming data is implemented on the shifted data. 
#define DBG_REG_TRIGGER_INDIRECT1_MASK_0                                                                                   0xd488UL //ACCESS:RW  DataWidth:0x4  Description: If set then the relevant byte will be zeroed; if clear then the relevant byte will be registered with its exact data.                   NOTE:                                    (a) Mask is implemented prior to registering the recorded data to trigger_indirect1_recorded_data;                                             (b) The mask is implemented in byte resolution.                     (c) b0: byte0; b1: byte1; b2: byte2; b3: byte2                  (d) useful when trigger_state_set_cnstr_oprtni > 0 (>/</=</=>)
#define DBG_REG_TRIGGER_INDIRECT1_MASK_1                                                                                   0xd48cUL //ACCESS:RW  DataWidth:0x4  Description: If set then the relevant byte will be zeroed; if clear then the relevant byte will be registered with its exact data.                   NOTE:                                    (a) Mask is implemented prior to registering the recorded data to trigger_indirect1_recorded_data;                                             (b) The mask is implemented in byte resolution.                     (c) b0: byte0; b1: byte1; b2: byte2; b3: byte2                  (d) useful when trigger_state_set_cnstr_oprtni > 0 (>/</=</=>)
#define DBG_REG_TRIGGER_INDIRECT1_MASK_2                                                                                   0xd490UL //ACCESS:RW  DataWidth:0x4  Description: If set then the relevant byte will be zeroed; if clear then the relevant byte will be registered with its exact data.                   NOTE:                                    (a) Mask is implemented prior to registering the recorded data to trigger_indirect1_recorded_data;                                             (b) The mask is implemented in byte resolution.                     (c) b0: byte0; b1: byte1; b2: byte2; b3: byte2                  (d) useful when trigger_state_set_cnstr_oprtni > 0 (>/</=</=>)
#define DBG_REG_FILTER_ENABLE                                                                                              0xd494UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00 - Filter off; in that case all data should be transmitted to the internal buffer without any filtering implemented (data should bypass filtering machine).                            (b) 01 - Filter on prior (in time domain) to trigger_event (asserted by the triggering machine block) only; When off (after trigger event) - data should be transmitted to the internal buffer without any filtering. in this mode trigger_enable must be set.                         (c) 10 - Filter on upon trigger_event (asserted by the triggering machine) only. When off (before trigger event) - data should be transmitted to the internal buffer without any filtering.  in this mode trigger_enable must be set.                    (d) 11 - Filter on - constant filtering; in this case the triggering event (asserted by the triggering machine) is irrelevant.             
#define DBG_REG_FILTER_SLOTS                                                                                               0xd498UL //ACCESS:RW  DataWidth:0x8  Description: Valid slots for filtering machine. Data from clients which are not in those slots will be dropped (not compared).    b0 - slot0; b1 - slot1;. . .;b7 - slot7;              NOTE:                                 (1) NA when framing mode is tdm64 and filter_valid_sel=1; in that case the only client is the JointHW (upper 32 bits of the calendar) and hence the value of filter_slots is disregarded. Each valid cycle will be compared.                             (2) all set bits MUST contain the same client
#define DBG_REG_FILTER_VALID_SEL                                                                                           0xd49cUL //ACCESS:RW  DataWidth:0x1  Description: When working in tdm64 mode there are 2 valid signals as follows:                                 (1) Valid[3] - validates data[63:32]                           (2) Valid[0] - validates data[31:0]                               Description:                            (a) 1 - use valid[3] (compared data is data[63:32] in that case)                                   (b) 0 - use valid[0] (compared data is data[31:0] in that case).                                            NOTE:                                   (1) The filtering machine compares the constraints to single data source only (which means that only data[31:0] / data[63:32] will be compared in each state)                            (2) if 64 bit framing mode OR tdm32 framing mode then this bit is not relevant; in that case only valid[0] & data[31:0]/data[63:0] are referred.
#define DBG_REG_FILTER_CNSTR_DATA_0                                                                                        0xd4a0UL //ACCESS:RW  DataWidth:0x20  Description: The value that need to be compared.                            (a) data[31:0] - if filter_cnstr_offseti[0] = 0;      OR                                        (b) data[63:32] - if filter_cnstr_offseti[0] = 1
#define DBG_REG_FILTER_CNSTR_DATA_1                                                                                        0xd4a4UL //ACCESS:RW  DataWidth:0x20  Description: The value that need to be compared.                            (a) data[31:0] - if filter_cnstr_offseti[0] = 0;      OR                                        (b) data[63:32] - if filter_cnstr_offseti[0] = 1
#define DBG_REG_FILTER_CNSTR_DATA_2                                                                                        0xd4a8UL //ACCESS:RW  DataWidth:0x20  Description: The value that need to be compared.                            (a) data[31:0] - if filter_cnstr_offseti[0] = 0;      OR                                        (b) data[63:32] - if filter_cnstr_offseti[0] = 1
#define DBG_REG_FILTER_CNSTR_DATA_3                                                                                        0xd4acUL //ACCESS:RW  DataWidth:0x20  Description: The value that need to be compared.                            (a) data[31:0] - if filter_cnstr_offseti[0] = 0;      OR                                        (b) data[63:32] - if filter_cnstr_offseti[0] = 1
#define DBG_REG_FILTER_CNSTR_FRAME_0                                                                                       0xd4b0UL //ACCESS:RW  DataWidth:0x1  Description: The value that need to be compared.                            (a) frame[0] - if filter_cnstr_offseti[0] = 0;          OR                                       (b) frame[3] - if filter_cnstr_offseti[0] = 1
#define DBG_REG_FILTER_CNSTR_FRAME_1                                                                                       0xd4b4UL //ACCESS:RW  DataWidth:0x1  Description: The value that need to be compared.                            (a) frame[0] - if filter_cnstr_offseti[0] = 0;          OR                                       (b) frame[3] - if filter_cnstr_offseti[0] = 1
#define DBG_REG_FILTER_CNSTR_FRAME_2                                                                                       0xd4b8UL //ACCESS:RW  DataWidth:0x1  Description: The value that need to be compared.                            (a) frame[0] - if filter_cnstr_offseti[0] = 0;          OR                                       (b) frame[3] - if filter_cnstr_offseti[0] = 1
#define DBG_REG_FILTER_CNSTR_FRAME_3                                                                                       0xd4bcUL //ACCESS:RW  DataWidth:0x1  Description: The value that need to be compared.                            (a) frame[0] - if filter_cnstr_offseti[0] = 0;          OR                                       (b) frame[3] - if filter_cnstr_offseti[0] = 1
#define DBG_REG_FILTER_CNSTR_DATA_MASK_0                                                                                   0xd4c0UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (filter_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_FILTER_CNSTR_DATA_MASK_1                                                                                   0xd4c4UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (filter_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_FILTER_CNSTR_DATA_MASK_2                                                                                   0xd4c8UL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (filter_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_FILTER_CNSTR_DATA_MASK_3                                                                                   0xd4ccUL //ACCESS:RW  DataWidth:0x20  Description: If specific bit is 1 then the matched bit in the above data vector is masked (not compared); the mask is valid only for the equal operation (filter_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_FILTER_CNSTR_FRAME_MASK_0                                                                                  0xd4d0UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 -  the frame is compared;  NOTE:                                The mask is valid only for the equal operation (trigger_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_FILTER_CNSTR_FRAME_MASK_1                                                                                  0xd4d4UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 -  the frame is compared;  NOTE:                                The mask is valid only for the equal operation (trigger_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_FILTER_CNSTR_FRAME_MASK_2                                                                                  0xd4d8UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 -  the frame is compared;  NOTE:                                The mask is valid only for the equal operation (trigger_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_FILTER_CNSTR_FRAME_MASK_3                                                                                  0xd4dcUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1 - the frame is masked (not compared);                            (b) 0 -  the frame is compared;  NOTE:                                The mask is valid only for the equal operation (trigger_cnstr_oprtni=000); i.e. not valid for </<=/>=/>.
#define DBG_REG_FILTER_CNSTR_OFFSET_0                                                                                      0xd4e0UL //ACCESS:RW  DataWidth:0x3  Description: The above value vector (data & frame) should be compared filter_cnstr_offseti / 2  cycles after start of message (0..3 cycles --> valid values: 0..7; The filtering is implemented according to the data on the first 4 cycles only)                   NOTE:                                   (a) even though the comparison is for the first 4 cycles only; the messages length is up to 128 cycles.                 
#define DBG_REG_FILTER_CNSTR_OFFSET_1                                                                                      0xd4e4UL //ACCESS:RW  DataWidth:0x3  Description: The above value vector (data & frame) should be compared filter_cnstr_offseti / 2  cycles after start of message (0..3 cycles --> valid values: 0..7; The filtering is implemented according to the data on the first 4 cycles only)                   NOTE:                                   (a) even though the comparison is for the first 4 cycles only; the messages length is up to 128 cycles.                 
#define DBG_REG_FILTER_CNSTR_OFFSET_2                                                                                      0xd4e8UL //ACCESS:RW  DataWidth:0x3  Description: The above value vector (data & frame) should be compared filter_cnstr_offseti / 2  cycles after start of message (0..3 cycles --> valid values: 0..7; The filtering is implemented according to the data on the first 4 cycles only)                   NOTE:                                   (a) even though the comparison is for the first 4 cycles only; the messages length is up to 128 cycles.                 
#define DBG_REG_FILTER_CNSTR_OFFSET_3                                                                                      0xd4ecUL //ACCESS:RW  DataWidth:0x3  Description: The above value vector (data & frame) should be compared filter_cnstr_offseti / 2  cycles after start of message (0..3 cycles --> valid values: 0..7; The filtering is implemented according to the data on the first 4 cycles only)                   NOTE:                                   (a) even though the comparison is for the first 4 cycles only; the messages length is up to 128 cycles.                 
#define DBG_REG_FILTER_CNSTR_OPRTN_0                                                                                       0xd4f0UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between fliter_cnstr_datai and the actual data as follows: (a) 000 - equal; (b) 001 - smaller than (<); (c)010 - smaller or equal (<=); (d) 011 greater or equal (>=); (e) 100 = greater than (>); 
#define DBG_REG_FILTER_CNSTR_OPRTN_1                                                                                       0xd4f4UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between fliter_cnstr_datai and the actual data as follows: (a) 000 - equal; (b) 001 - smaller than (<); (c)010 - smaller or equal (<=); (d) 011 greater or equal (>=); (e) 100 = greater than (>); 
#define DBG_REG_FILTER_CNSTR_OPRTN_2                                                                                       0xd4f8UL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between fliter_cnstr_datai and the actual data as follows: (a) 000 - equal; (b) 001 - smaller than (<); (c)010 - smaller or equal (<=); (d) 011 greater or equal (>=); (e) 100 = greater than (>); 
#define DBG_REG_FILTER_CNSTR_OPRTN_3                                                                                       0xd4fcUL //ACCESS:RW  DataWidth:0x3  Description: The comparison operation that should be implemented between fliter_cnstr_datai and the actual data as follows: (a) 000 - equal; (b) 001 - smaller than (<); (c)010 - smaller or equal (<=); (d) 011 greater or equal (>=); (e) 100 = greater than (>); 
#define DBG_REG_FILTER_CNSTR_RANGE_0                                                                                       0xd500UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_FILTER_CNSTR_RANGE_0_REG_FILTER_CNSTR_RANGE_WIDTH_0                                                        (0x1f<<0)
	#define DBG_FILTER_CNSTR_RANGE_0_REG_FILTER_CNSTR_RANGE_WIDTH_0_SIZE                                                   0		
	#define DBG_FILTER_CNSTR_RANGE_0_REG_FILTER_CNSTR_RANGE_LSB_0                                                          (0x1f<<5)
	#define DBG_FILTER_CNSTR_RANGE_0_REG_FILTER_CNSTR_RANGE_LSB_0_SIZE                                                     5
#define DBG_REG_FILTER_CNSTR_RANGE_1                                                                                       0xd504UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_FILTER_CNSTR_RANGE_1_REG_FILTER_CNSTR_RANGE_WIDTH_1                                                        (0x1f<<0)
	#define DBG_FILTER_CNSTR_RANGE_1_REG_FILTER_CNSTR_RANGE_WIDTH_1_SIZE                                                   0		
	#define DBG_FILTER_CNSTR_RANGE_1_REG_FILTER_CNSTR_RANGE_LSB_1                                                          (0x1f<<5)
	#define DBG_FILTER_CNSTR_RANGE_1_REG_FILTER_CNSTR_RANGE_LSB_1_SIZE                                                     5
#define DBG_REG_FILTER_CNSTR_RANGE_2                                                                                       0xd508UL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_FILTER_CNSTR_RANGE_2_REG_FILTER_CNSTR_RANGE_WIDTH_2                                                        (0x1f<<0)
	#define DBG_FILTER_CNSTR_RANGE_2_REG_FILTER_CNSTR_RANGE_WIDTH_2_SIZE                                                   0		
	#define DBG_FILTER_CNSTR_RANGE_2_REG_FILTER_CNSTR_RANGE_LSB_2                                                          (0x1f<<5)
	#define DBG_FILTER_CNSTR_RANGE_2_REG_FILTER_CNSTR_RANGE_LSB_2_SIZE                                                     5
#define DBG_REG_FILTER_CNSTR_RANGE_3                                                                                       0xd50cUL //ACCESS:RW  DataWidth:0xa  Multi Field Register		
	#define DBG_FILTER_CNSTR_RANGE_3_REG_FILTER_CNSTR_RANGE_WIDTH_3                                                        (0x1f<<0)
	#define DBG_FILTER_CNSTR_RANGE_3_REG_FILTER_CNSTR_RANGE_WIDTH_3_SIZE                                                   0		
	#define DBG_FILTER_CNSTR_RANGE_3_REG_FILTER_CNSTR_RANGE_LSB_3                                                          (0x1f<<5)
	#define DBG_FILTER_CNSTR_RANGE_3_REG_FILTER_CNSTR_RANGE_LSB_3_SIZE                                                     5
#define DBG_REG_FILTER_CNSTR_MUST_0                                                                                        0xd510UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector & frame must exist as part of the message.                               (b) 0: the above data vector & vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_FILTER_CNSTR_MUST_1                                                                                        0xd514UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector & frame must exist as part of the message.                               (b) 0: the above data vector & vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_FILTER_CNSTR_MUST_2                                                                                        0xd518UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector & frame must exist as part of the message.                               (b) 0: the above data vector & vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_FILTER_CNSTR_MUST_3                                                                                        0xd51cUL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: the above data vector & frame must exist as part of the message.                               (b) 0: the above data vector & vector is not mandatory for the message; However at least one of those (low) constraints must exist as part of the message.
#define DBG_REG_FILTER_CNSTR_INDIRECT_0                                                                                    0xd520UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the filter_cnstr_datai.                     (b) 01: indirect: use the recorded value 0 from of fsm triggering machine (trigger_indirect0_recorded_data).                                          (c) 10: indirect: use the recorded value 1 from of fsm triggering machine (trigger_indirect1_recorded_data).                                          NOTE: if  filter_enable=11 OR filter_enable=01 then filter_cnstr_indirecti MUST be all 0 (need to filter prior to triggering machine event and hence cannot use the recorded data from state 0 in triggering machine) 
#define DBG_REG_FILTER_CNSTR_INDIRECT_1                                                                                    0xd524UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the filter_cnstr_datai.                     (b) 01: indirect: use the recorded value 0 from of fsm triggering machine (trigger_indirect0_recorded_data).                                          (c) 10: indirect: use the recorded value 1 from of fsm triggering machine (trigger_indirect1_recorded_data).                                          NOTE: if  filter_enable=11 OR filter_enable=01 then filter_cnstr_indirecti MUST be all 0 (need to filter prior to triggering machine event and hence cannot use the recorded data from state 0 in triggering machine) 
#define DBG_REG_FILTER_CNSTR_INDIRECT_2                                                                                    0xd528UL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the filter_cnstr_datai.                     (b) 01: indirect: use the recorded value 0 from of fsm triggering machine (trigger_indirect0_recorded_data).                                          (c) 10: indirect: use the recorded value 1 from of fsm triggering machine (trigger_indirect1_recorded_data).                                          NOTE: if  filter_enable=11 OR filter_enable=01 then filter_cnstr_indirecti MUST be all 0 (need to filter prior to triggering machine event and hence cannot use the recorded data from state 0 in triggering machine) 
#define DBG_REG_FILTER_CNSTR_INDIRECT_3                                                                                    0xd52cUL //ACCESS:RW  DataWidth:0x2  Description: (a) 00: direct: use the value which was configured in the filter_cnstr_datai.                     (b) 01: indirect: use the recorded value 0 from of fsm triggering machine (trigger_indirect0_recorded_data).                                          (c) 10: indirect: use the recorded value 1 from of fsm triggering machine (trigger_indirect1_recorded_data).                                          NOTE: if  filter_enable=11 OR filter_enable=01 then filter_cnstr_indirecti MUST be all 0 (need to filter prior to triggering machine event and hence cannot use the recorded data from state 0 in triggering machine) 
#define DBG_REG_FILTER_CNSTR_CYCLIC_0                                                                                      0xd530UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (filter_cnstr_oprtni > 0)             (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)     
#define DBG_REG_FILTER_CNSTR_CYCLIC_1                                                                                      0xd534UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (filter_cnstr_oprtni > 0)             (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)     
#define DBG_REG_FILTER_CNSTR_CYCLIC_2                                                                                      0xd538UL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (filter_cnstr_oprtni > 0)             (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)     
#define DBG_REG_FILTER_CNSTR_CYCLIC_3                                                                                      0xd53cUL //ACCESS:RW  DataWidth:0x1  Description: refers the comparison which is implemented in case the operation is NOT equal (filter_cnstr_oprtni > 0)             (a) 0 - regular comparsion (not cyclic): a>b if a-b >0                (b) 1 - cyclic comparison: a>b if a-b<2^31-1 (half the range of 32 bit)     
#define DBG_REG_FILTER_MSG_LENGTH_ENABLE                                                                                   0xd540UL //ACCESS:RW  DataWidth:0x1  Description: (a) 1: use filter_msg_length  to determine message boundary. (b) 0: use filter_valid_sel           to determine which frame (frame[0]/frame[3]) signals message boundary (end of message) 
#define DBG_REG_FILTER_MSG_LENGTH                                                                                          0xd544UL //ACCESS:RW  DataWidth:0x7  Description: Message length-1  in terms of numbers of cycles.                  NOTE:                                     (a) if for example filter_msg_length=0 then Message length = 1 cycle.        (b) if for example filter_msg_lengthi=1 then Message length = 2 cycles. etc.   (c) Applicable only when filter_msg_length_en = 1
#define DBG_REG_RCRD_ON_WINDOW_PRE_TRGR_EVNT_MODE                                                                          0xd548UL //ACCESS:RW  DataWidth:0x2  Description: Recording mode prior to trigger event:                                    (a) 00 - record from time=0;     (b) 01 - record rcrd_on_window_pre_num_chunks chunks (16 lines chunks within the internal buffer) to internal buffer prior to triggering event;                                    (c) 10 - Don't record prior to triggering event (drop data).     NOTE: applicable only if trigger_enable=1
#define DBG_REG_RCRD_ON_WINDOW_POST_TRGR_EVNT_MODE                                                                         0xd54cUL //ACCESS:RW  DataWidth:0x1  Description: Recording mode upon trigger event:                                   (a) 0- enable recording data upon triggering event; in that case record for rcrd_on_window_post_num_cycles valid cycles upon the event;                                   (b) 1 - disable recording data upon triggering event.             NOTE:                                  applicable only if trigger_enable=1
#define DBG_REG_RCRD_ON_WINDOW_PRE_NUM_CHUNKS                                                                              0xd550UL //ACCESS:RW  DataWidth:0x3  Description: Number of chunks (chunk = 16 lines of 128 bit each within the internal buffer) that should be recorded to the internal buffer prior to triggering event.         NOTE:                                  (1) applicable only when rcrd_on_window_pre_trgr_evnt_mode=01;                              (2) valid values are 1..7;          (3) the data that will be stored in the internal buffer is the most recent data prior to the triggering event.                      (4) rcrd_on_window_pre_num_chunks represents the maximum number of chunks that will be written to the internal buffer; if from since time=0 until triggering event the amount of driven data is smaller then the amount of the above value the amount of data stored in the internal buffer will be smaller then the above value.
#define DBG_REG_RCRD_ON_WINDOW_POST_NUM_CYCLES                                                                             0xd554UL //ACCESS:RW  DataWidth:0x20  Description: Number of valid cycles that should be recorded upon triggering event.                      NOTE:                                   (1) applicable only when rcrd_on_window_post_trgr_evnt_mode=0;                              (2) value of 0xffffffff (maximum value) result in recording of unlimited amount of cycles (infinite amount of cycles).
#define DBG_REG_PCI_FUNC_NUM                                                                                               0xd558UL //ACCESS:RW  DataWidth:0x3  Description: pci function number; for pci request interface
#define DBG_REG_DBG_NM_MBIST1_CNTRL_CMD                                                                                    0xd55cUL //ACCESS:RW  DataWidth:0x5  Description: NA
#define DBG_REG_NM_CLK_MBIST1_CNTRL_DBG_STATUS_0                                                                           0xd560UL //ACCESS:R  DataWidth:0x20  Description: NA
#define DBG_REG_NM_CLK_MBIST1_CNTRL_DBG_STATUS_1                                                                           0xd564UL //ACCESS:R  DataWidth:0x20  Description: NA
#define DBG_REG_NM_CLK_CP_MBIST1_CNTRL_DBG_STATUS_0                                                                        0xd568UL //ACCESS:R  DataWidth:0x20  Description: NA
#define DBG_REG_INTERNAL_BUFFER_LSB_TM                                                                                     0xd56cUL //ACCESS:RW  DataWidth:0x8  Description: tm port for the internal buffer lsb memory instance
#define DBG_REG_INTERNAL_BUFFER_MSB_TM                                                                                     0xd570UL //ACCESS:RW  DataWidth:0x8  Description: tm port for the internal buffer msb memory instance
#define DBG_REG_ECO_RESERVED                                                                                               0xd574UL //ACCESS:RW  DataWidth:0x8  Description: eco reserved register
#define DBG_REG_CPU_MBIST_MEMCTRL_0_CNTRL_CMD                                                                              0xd578UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_1_CNTRL_CMD                                                                              0xd57cUL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_2_CNTRL_CMD                                                                              0xd580UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_3_CNTRL_CMD                                                                              0xd584UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_4_CNTRL_CMD                                                                              0xd588UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_5_CNTRL_CMD                                                                              0xd58cUL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_6_CNTRL_CMD                                                                              0xd590UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_7_CNTRL_CMD                                                                              0xd594UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_8_CNTRL_CMD                                                                              0xd598UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_0_STATUS_0                                                                               0xd59cUL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_1_STATUS_0                                                                               0xd5a0UL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_2_STATUS_0                                                                               0xd5a4UL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_3_STATUS_0                                                                               0xd5a8UL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_4_STATUS_0                                                                               0xd5acUL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_5_STATUS_0                                                                               0xd5b0UL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_6_STATUS_0                                                                               0xd5b4UL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_7_STATUS_0                                                                               0xd5b8UL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_8_STATUS_0                                                                               0xd5bcUL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_9_CNTRL_CMD                                                                              0xd5c0UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_9_STATUS_0                                                                               0xd5c4UL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_10_CNTRL_CMD                                                                             0xd5c8UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_11_CNTRL_CMD                                                                             0xd5ccUL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0];
#define DBG_REG_CPU_MBIST_MEMCTRL_10_STATUS_0                                                                              0xd5d0UL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CPU_MBIST_MEMCTRL_11_STATUS_0                                                                              0xd5d4UL //ACCESS:R  DataWidth:0x19  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DBG_REG_CALENDAR_OUT_DATA_LOW                                                                                      0xc100UL //ACCESS:R  DataWidth:0x20  Description: debug only:                            These bits indicate the value of the lower 32 bits of the data output of the calendar
#define DBG_REG_CALENDAR_OUT_DATA_LOW_SIZE                                                                                 1
#define DBG_REG_CPU_DEBUG_DATA                                                                                             0xc104UL //ACCESS:RW  DataWidth:0x20  Description: debug only:                            These bits indicate debug data that arrives from the CPU client; if ~dbg_registers_immediate_ack=1 then ack is returned upon the following cycle of write command. In this case ~dbg_registers_cpu_data_taken_intr interrupt anounce that the data slot was taken; If ~dbg_registers_immediate_ack=0 then ack is returned only after the data slot was taken. in this case if the CPU is not configured in the slots then an ack signal will never be returned by the calendar.
#define DBG_REG_CPU_DEBUG_DATA_SIZE                                                                                        1
#define DBG_REG_FULL_ON_EXT_BUFFER                                                                                         0xc108UL //ACCESS:R  DataWidth:0x1  Description: debug only:                            This bit indicates that the external buffer was filled; Relevant only when ~dbg_registers_full_mode=0 (one shot)
#define DBG_REG_FULL_ON_EXT_BUFFER_SIZE                                                                                    1
#define DBG_REG_FULL_ON_INT_BUFFER                                                                                         0xc10cUL //ACCESS:R  DataWidth:0x1  Description: debug only:                            This bit indicates that the internal buffer was filled
#define DBG_REG_FULL_ON_INT_BUFFER_SIZE                                                                                    1
#define DBG_REG_INTR_BUFFER_RD_PTR                                                                                         0xc110UL //ACCESS:R  DataWidth:0x7  Description: debug only:                            These bits indicate the value of the read pointer for the internal buffer; The read pointer describes the next address to be read from the internal buffer
#define DBG_REG_INTR_BUFFER_RD_PTR_SIZE                                                                                    1
#define DBG_REG_INTR_BUFFER_WR_PTR                                                                                         0xc114UL //ACCESS:R  DataWidth:0x7  Description: debug only:                            These bits indicate the value of the write pointer for the internal buffer; The write pointer describes the last address that was written to the internal buffer. An exception exists after reset when #dbg_registers_intr_buffer_wr_ptr is 0 until first data is written
#define DBG_REG_INTR_BUFFER_WR_PTR_SIZE                                                                                    1
#define DBG_REG_OVL_ON_EXT_BUFFER                                                                                          0xc118UL //ACCESS:R  DataWidth:0x1  Description: debug only:                            This bit indicates that the external buffer was overflowed (newest data was thrown); Relevant only for                   (a) ~dbg_registers_debug_target=2 (PCI) & ~dbg_registers_full_mode=0 (one shot); or   (b) ~dbg_registers_debug_target=1 (NIG) & ~dbg_registers_full_mode=0 (one shot)
#define DBG_REG_OVL_ON_EXT_BUFFER_SIZE                                                                                     1
#define DBG_REG_OVL_ON_INT_BUFFER                                                                                          0xc11cUL //ACCESS:R  DataWidth:0x1  Description: debug only:                            This bit indicates that the internal buffer was overflowed (newest data was thrown); Not relevant if ~dbg_registers_debug_target=0 (internal buffer) & ~dbg_registers_full_mode=1 (wrap);
#define DBG_REG_OVL_ON_INT_BUFFER_SIZE                                                                                     1
#define DBG_REG_PCI_REQ_CREDIT                                                                                             0xc120UL //ACCESS:RW  DataWidth:0x2  Description: debug only:                            These bits indicate the credit  for PCI request type 4 interface; MUST be configured AFTER pci_ext_buffer_strt_addr_lsb/msb are configured
#define DBG_REG_PCI_REQ_CREDIT_SIZE                                                                                        1
#define DBG_REG_WRAP_ON_EXT_BUFFER                                                                                         0xc124UL //ACCESS:R  DataWidth:0x1  Description: debug only:                            This bit indicates wheter  indicates that external buffer was wrapped (oldest data was thrown); Relevant only when ~dbg_registers_debug_target=2 (PCI) & ~dbg_registers_full_mode=1 (wrap);
#define DBG_REG_WRAP_ON_EXT_BUFFER_SIZE                                                                                    1
#define DBG_REG_WRAP_ON_INT_BUFFER                                                                                         0xc128UL //ACCESS:R  DataWidth:0x1  Description: debug only:                            This bit indicates wheter the internal buffer was wrapped (oldest data was thrown) Relevant only when ~dbg_registers_debug_target=0 (internal buffer)
#define DBG_REG_WRAP_ON_INT_BUFFER_SIZE                                                                                    1
#define DBG_REG_EXT_BUFFER_RD_PTR                                                                                          0xc130UL //ACCESS:WB_R  DataWidth:0x40  Description: debug only:                            These bits indicate the value of the read pointer for the external pci buffer; relevant only when ~dbg_registers_debug_target=2 (PCI); The read pointer describes the next address to be read from the external buffer; WB Read Only (write request will not be acknowledged); 
#define DBG_REG_EXT_BUFFER_RD_PTR_SIZE                                                                                     2
#define DBG_REG_EXT_BUFFER_WR_PTR                                                                                          0xc140UL //ACCESS:WB_R  DataWidth:0x40  Description: debug only:                            These bits indicate the value of the write pointer for the external pci buffer when ~dbg_registers_debug_target=2 (PCI). It describes the next address to write to the external buffer; 1024 Byte Chunks counter when ~dbg_registers_debug_target=1 (NIG) and ~dbg_registers_full_mode=0 (one-shot); WB Read Only (write request will not be acknowledged); 
#define DBG_REG_EXT_BUFFER_WR_PTR_SIZE                                                                                     2
#define DBG_REG_CALENDAR_OUT_DATA                                                                                          0xc160UL //ACCESS:WB_R  DataWidth:0x47  Description: debug only:                            These bits indicate the value of the data frame and valid output of the calendar; The concatenation is done as follows: bits 63:0 - data; bits 66:64 - frame; bits 70:68 - valid. The reference for the valid/frame is according to the ~dbg_registers_framing_mode as follows:                            (a) tdm32 mode - bit 68 for valid bit 64 for frame for data bits 31:0;                                   (b) tdm64 mode - bit 68 for valid bit 64 for frame for data bits 31:0; bit 69 for valid; bit 65 for frame for data bits 63:32;       (c) 64 bit mode - bit 68 for valid bit 64 for frame for data bits 63:0;                                    (d) 24 bit mode - bit 68 for valid bit 64 for frame for data bits 7:0; bit 69 for valid bit 65 for frame for data bits 15:8; bit 70 for valid bit 66 for frame for data bits 23:16;                          WB Read Only (write request will not be acknowledged);
#define DBG_REG_CALENDAR_OUT_DATA_SIZE                                                                                     3
#define DBG_REG_EXPECTED_PATTERN                                                                                           0xc180UL //ACCESS:WB  DataWidth:0x46  Description: debug only:                            For pattern recognition usage:  These bits represent the pattern to be compared with the vector {slot_num[2:0]; frame[2:0]; data[63:0]}; This vector represent the debug data it's slot number and it's frame signals that are going to stored in the internal buffer;
#define DBG_REG_EXPECTED_PATTERN_SIZE                                                                                      3
#define DBG_REG_EXPECTED_PATTERN_BIT_MASK                                                                                  0xc1a0UL //ACCESS:WB  DataWidth:0x46  Description: debug only:                            For pattern recognition usage: These bits represent a mask bit vector that refers to the ~dbg_registers_expected_pattern vector as follows:                  (a) 1 - bit is masked. This bit won't be compared with the ~dbg_registers_expected_pattern referred bit;                          (b) 0 - bit is enabled. This bit will be compared with the ~dbg_registers_expected_pattern reffered bit;
#define DBG_REG_EXPECTED_PATTERN_BIT_MASK_SIZE                                                                             3
#define DBG_REG_INTR_BUFFER                                                                                                0xc800UL //ACCESS:WB  DataWidth:0x80  Description: debug only:                            Internal buffer of 2KByte buffer
#define DBG_REG_INTR_BUFFER_SIZE                                                                                           512
#define DBG_REG_INT_BUFFER_WRAP_COUNTER                                                                                    0xd000UL //ACCESS:R  DataWidth:0x20  Description: Number of wraps on internal buffer;                                NOTE: valid only when debug_target=0 (internal buffer) and full_mode=1 (wrap)    
#define DBG_REG_INT_BUFFER_WRAP_COUNTER_SIZE                                                                               1
#define DBG_REG_TRIGGER_EVENT                                                                                              0xd004UL //ACCESS:R  DataWidth:0x1  Description: Configured messages sequencing was identified.  
#define DBG_REG_TRIGGER_EVENT_SIZE                                                                                         1
#define DBG_REG_TRIGGER_INDIRECT0_RECORDED_DATA                                                                            0xd008UL //ACCESS:R  DataWidth:0x20  Description: The data that was recorded trigger_indirect0_offset cycles after start of message (during triggering machine operation in state trigger_indirect0_state); NOTE: CID recording for filtering purpose within the sem must use this register (and NOT trigger_indirect1_recorded_data register)
#define DBG_REG_TRIGGER_INDIRECT0_RECORDED_DATA_SIZE                                                                       1
#define DBG_REG_TRIGGER_INDIRECT1_RECORDED_DATA                                                                            0xd00cUL //ACCESS:R  DataWidth:0x20  Description: The data that was recorded trigger_indirect1_offset cycles after start of message (during triggering machine operation in state trigger_indirect0_state);
#define DBG_REG_TRIGGER_INDIRECT1_RECORDED_DATA_SIZE                                                                       1
#define DBG_REG_DBG_UNUSED_EMPTY_0                                                                                         0xc0acUL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DBG_REG_DBG_UNUSED_EMPTY_0_SIZE                                                                                    21
#define DBG_REG_DBG_UNUSED_EMPTY_1                                                                                         0xc12cUL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DBG_REG_DBG_UNUSED_EMPTY_1_SIZE                                                                                    1
#define DBG_REG_DBG_UNUSED_EMPTY_2                                                                                         0xc150UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DBG_REG_DBG_UNUSED_EMPTY_2_SIZE                                                                                    4
#define DBG_REG_DBG_UNUSED_EMPTY_3                                                                                         0xc1c0UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DBG_REG_DBG_UNUSED_EMPTY_3_SIZE                                                                                    400
#define DBG_REG_DBG_UNUSED_EMPTY_4                                                                                         0xd5d8UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DBG_REG_DBG_UNUSED_EMPTY_4_SIZE                                                                                    2698
#define DMAE_REG_INIT                                                                                                      0x102000UL //ACCESS:RW  DataWidth:0x1  Description: Debug only. Initialises specific states and statuses. To initialise the state - write 1 into register; to enable working after that - write 0.
#define DMAE_REG_PCI_IFEN                                                                                                  0x102004UL //ACCESS:RW  DataWidth:0x1  Description: DMAE PCI Interface (Request;Read;Write) enable. If 0 - the acknowledge input is disregarded; valid is deasserted; full is asserted; all other signals are treated as usual; if 1 - normal activity.
#define DMAE_REG_GRC_IFEN                                                                                                  0x102008UL //ACCESS:RW  DataWidth:0x1  Description: DMAE GRC Interface (Target;Master) enable. If 0 - the acknowledge input is disregarded; valid is deasserted; all other signals are treated as usual; if 1 - normal activity.
#define DMAE_REG_RLXD_ORDR                                                                                                 0x10200cUL //ACCESS:RW  DataWidth:0x1  Description: Relaxed ordering. 0-strict PCI ordering is used;1-PCI-X relaxed ordering is enabled.
#define DMAE_REG_NO_SNOOP                                                                                                  0x102010UL //ACCESS:RW  DataWidth:0x1  Description: 0-PCI type cache snoop protection is required;1-system isn't required to cause processor cache snoop for coherency.
#define DMAE_REG_CRC16I_INIT                                                                                               0x102014UL //ACCESS:RW  DataWidth:0x1  Description: If 0 - the CRC-16 initial value is all zeroes; if 1 - the CRC-16 initial value is all ones.
#define DMAE_REG_CRC16_BSWAP                                                                                               0x102018UL //ACCESS:RW  DataWidth:0x1  Description: If 0 - the CRC-16 final calculation result isn't byte swapped; if 1 - the CRC-16 final calculation result is byte swapped (byte [7:0] goes to location [31:24];etc).
#define DMAE_REG_CRC16C_INIT                                                                                               0x10201cUL //ACCESS:RW  DataWidth:0x1  Description: If 0 - the CRC-16c initial value is all zeroes; if 1 - the CRC-16c initial value is all ones.
#define DMAE_REG_CRC16T10_INIT                                                                                             0x102020UL //ACCESS:RW  DataWidth:0x1  Description: If 0 - the CRC-16 T10 initial value is all zeroes; if 1 - the CRC-16 T10 initial value is all ones.
#define DMAE_REG_CRC32I_INIT                                                                                               0x102024UL //ACCESS:RW  DataWidth:0x1  Description: If 0 - the CRC-32 initial value is all zeroes; if 1 - the CRC-32 initial value is all ones.
#define DMAE_REG_CRC32I_BSWAP                                                                                              0x102028UL //ACCESS:RW  DataWidth:0x1  Description: If 0 - the CRC-32 final calculation result isn't byte swapped; if 1 - the CRC-32 final calculation result is byte swapped (byte [7:0] goes to location [31:24];etc).
#define DMAE_REG_CRC32C_INIT                                                                                               0x10202cUL //ACCESS:RW  DataWidth:0x1  Description: If 0 - the CRC-32c initial value is all zeroes; if 1 - the CRC-32c initial value is all ones.
#define DMAE_REG_CRC32C_BSWAP                                                                                              0x102030UL //ACCESS:RW  DataWidth:0x1  Description: If 0 - the CRC-32c final calculation result isn't byte swapped; if 1 - the CRC-32c final calculation result is byte swapped (byte [7:0] goes to location [31:24];etc).
#define DMAE_REG_CHKSUM0_FIX                                                                                               0x102034UL //ACCESS:RW  DataWidth:0x1  Description: If 0 - the final checksum equal 0 won't be changed;if 1 - the final checksum equal 0 will be fixed to all ones.
#define DMAE_REG_CMD_TM                                                                                                    0x102038UL //ACCESS:RW  DataWidth:0x5  Description: TM bits of Command memory.
#define DMAE_REG_DBG_SELECT                                                                                                0x10203cUL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from DMAE to the DBG block) - for selecting a line to output to the DBG block.
#define DMAE_REG_DBG_BYTE_ENABLE                                                                                           0x102040UL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from DMAE to the DBG block) - for enabling bytes in the selected line (after the select; before the shift).
#define DMAE_REG_DBG_SHIFT                                                                                                 0x102044UL //ACCESS:RW  DataWidth:0x3  Description: Debug only. For dbgmux usage (debug data that goes from DMAE to the DBG block) - for circular right shifting of the selected line (after the enabling).
#define DMAE_REG_DMAE_INT_STS                                                                                              0x102048UL //ACCESS:R  DataWidth:0x2  Description: Interrupt register #0 read		
	#define DMAE_DMAE_INT_STS_REG_ADDRESS_ERROR                                                                            (0x1<<0)
	#define DMAE_DMAE_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                       0		
	#define DMAE_DMAE_INT_STS_REG_PCI_RD_BUF_ERR                                                                           (0x1<<1)
	#define DMAE_DMAE_INT_STS_REG_PCI_RD_BUF_ERR_SIZE                                                                      1
#define DMAE_REG_DMAE_INT_STS_CLR                                                                                          0x10204cUL //ACCESS:RC  DataWidth:0x2  Description: Interrupt register #0 read clear		
	#define DMAE_DMAE_INT_STS_CLR_REG_ADDRESS_ERROR                                                                        (0x1<<0)
	#define DMAE_DMAE_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                   0		
	#define DMAE_DMAE_INT_STS_CLR_REG_PCI_RD_BUF_ERR                                                                       (0x1<<1)
	#define DMAE_DMAE_INT_STS_CLR_REG_PCI_RD_BUF_ERR_SIZE                                                                  1
#define DMAE_REG_DMAE_INT_STS_WR                                                                                           0x102050UL //ACCESS:WR  DataWidth:0x2  Description: Interrupt register #0 bit set or clear		
	#define DMAE_DMAE_INT_STS_WR_REG_ADDRESS_ERROR                                                                         (0x1<<0)
	#define DMAE_DMAE_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                    0		
	#define DMAE_DMAE_INT_STS_WR_REG_PCI_RD_BUF_ERR                                                                        (0x1<<1)
	#define DMAE_DMAE_INT_STS_WR_REG_PCI_RD_BUF_ERR_SIZE                                                                   1
#define DMAE_REG_DMAE_INT_MASK                                                                                             0x102054UL //ACCESS:RW  DataWidth:0x2  Description: Interrupt mask register #0 read/write		
	#define DMAE_DMAE_INT_MASK_REG_ADDRESS_ERROR                                                                           (0x1<<0)
	#define DMAE_DMAE_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                      0		
	#define DMAE_DMAE_INT_MASK_REG_PCI_RD_BUF_ERR                                                                          (0x1<<1)
	#define DMAE_DMAE_INT_MASK_REG_PCI_RD_BUF_ERR_SIZE                                                                     1
#define DMAE_REG_DMAE_PRTY_STS                                                                                             0x102058UL //ACCESS:R  DataWidth:0x4  Description: Parity register #0 read		
	#define DMAE_DMAE_PRTY_STS_REG_PARITY                                                                                  (0x1<<0)
	#define DMAE_DMAE_PRTY_STS_REG_PARITY_SIZE                                                                             0		
	#define DMAE_DMAE_PRTY_STS_REG_PCI_BUF_LOW_PRTY_ERR                                                                    (0x1<<1)
	#define DMAE_DMAE_PRTY_STS_REG_PCI_BUF_LOW_PRTY_ERR_SIZE                                                               1		
	#define DMAE_DMAE_PRTY_STS_REG_PCI_BUF_HIGH_PRTY_ERR                                                                   (0x1<<2)
	#define DMAE_DMAE_PRTY_STS_REG_PCI_BUF_HIGH_PRTY_ERR_SIZE                                                              2		
	#define DMAE_DMAE_PRTY_STS_REG_CMD_MEM_PRTY_ERR                                                                        (0x1<<3)
	#define DMAE_DMAE_PRTY_STS_REG_CMD_MEM_PRTY_ERR_SIZE                                                                   3
#define DMAE_REG_DMAE_PRTY_STS_CLR                                                                                         0x10205cUL //ACCESS:RC  DataWidth:0x4  Description: Parity register #0 read clear		
	#define DMAE_DMAE_PRTY_STS_CLR_REG_PARITY                                                                              (0x1<<0)
	#define DMAE_DMAE_PRTY_STS_CLR_REG_PARITY_SIZE                                                                         0		
	#define DMAE_DMAE_PRTY_STS_CLR_REG_PCI_BUF_LOW_PRTY_ERR                                                                (0x1<<1)
	#define DMAE_DMAE_PRTY_STS_CLR_REG_PCI_BUF_LOW_PRTY_ERR_SIZE                                                           1		
	#define DMAE_DMAE_PRTY_STS_CLR_REG_PCI_BUF_HIGH_PRTY_ERR                                                               (0x1<<2)
	#define DMAE_DMAE_PRTY_STS_CLR_REG_PCI_BUF_HIGH_PRTY_ERR_SIZE                                                          2		
	#define DMAE_DMAE_PRTY_STS_CLR_REG_CMD_MEM_PRTY_ERR                                                                    (0x1<<3)
	#define DMAE_DMAE_PRTY_STS_CLR_REG_CMD_MEM_PRTY_ERR_SIZE                                                               3
#define DMAE_REG_DMAE_PRTY_STS_WR                                                                                          0x102060UL //ACCESS:WR  DataWidth:0x4  Description: Parity register #0 bit set or clear		
	#define DMAE_DMAE_PRTY_STS_WR_REG_PARITY                                                                               (0x1<<0)
	#define DMAE_DMAE_PRTY_STS_WR_REG_PARITY_SIZE                                                                          0		
	#define DMAE_DMAE_PRTY_STS_WR_REG_PCI_BUF_LOW_PRTY_ERR                                                                 (0x1<<1)
	#define DMAE_DMAE_PRTY_STS_WR_REG_PCI_BUF_LOW_PRTY_ERR_SIZE                                                            1		
	#define DMAE_DMAE_PRTY_STS_WR_REG_PCI_BUF_HIGH_PRTY_ERR                                                                (0x1<<2)
	#define DMAE_DMAE_PRTY_STS_WR_REG_PCI_BUF_HIGH_PRTY_ERR_SIZE                                                           2		
	#define DMAE_DMAE_PRTY_STS_WR_REG_CMD_MEM_PRTY_ERR                                                                     (0x1<<3)
	#define DMAE_DMAE_PRTY_STS_WR_REG_CMD_MEM_PRTY_ERR_SIZE                                                                3
#define DMAE_REG_DMAE_PRTY_MASK                                                                                            0x102064UL //ACCESS:RW  DataWidth:0x4  Description: Parity mask register #0 read/write		
	#define DMAE_DMAE_PRTY_MASK_REG_PARITY                                                                                 (0x1<<0)
	#define DMAE_DMAE_PRTY_MASK_REG_PARITY_SIZE                                                                            0		
	#define DMAE_DMAE_PRTY_MASK_REG_PCI_BUF_LOW_PRTY_ERR                                                                   (0x1<<1)
	#define DMAE_DMAE_PRTY_MASK_REG_PCI_BUF_LOW_PRTY_ERR_SIZE                                                              1		
	#define DMAE_DMAE_PRTY_MASK_REG_PCI_BUF_HIGH_PRTY_ERR                                                                  (0x1<<2)
	#define DMAE_DMAE_PRTY_MASK_REG_PCI_BUF_HIGH_PRTY_ERR_SIZE                                                             2		
	#define DMAE_DMAE_PRTY_MASK_REG_CMD_MEM_PRTY_ERR                                                                       (0x1<<3)
	#define DMAE_DMAE_PRTY_MASK_REG_CMD_MEM_PRTY_ERR_SIZE                                                                  3
#define DMAE_REG_ECO_RESERVED                                                                                              0x102068UL //ACCESS:RW  DataWidth:0x8  Description: chicken bits
#define DMAE_REG_RD_ATC_FLAGS                                                                                              0x10206cUL //ACCESS:RW  DataWidth:0x3  Description: Read request ATC Flags[1:0]: 00 - Do nothing; 01 - Search only; 10 - Search & Cache; 11 - Search & Release; ATC Flags[2]:0 - Low Priority;  - High Priority
#define DMAE_REG_WR_ATC_FLAGS                                                                                              0x102070UL //ACCESS:RW  DataWidth:0x3  Description: Write request ATC Flags[1:0]: 00 - Do nothing; 01 - Search only; 10 - Search & Cache; 11 - Search & Release; ATC Flags[2]:0 - Low Priority;  - High Priority
#define DMAE_REG_PCI_ERR_DISCARD_EN                                                                                        0x102074UL //ACCESS:RW  DataWidth:0x1  Description: When set discards 1- or 2-Dword PCI transaction read in case there is PCI error.
#define DMAE_REG_PCI_ERR_DISCARD_ADDR                                                                                      0x102078UL //ACCESS:RW  DataWidth:0x14  Description: GRC address in case 1- or 2-Dword PCI transaction is discardd due to PCI error and dmae.pci_err_discard set.
#define DMAE_REG_BACKWARD_COMP_EN                                                                                          0x10207cUL //ACCESS:RW  DataWidth:0x1  Description: When set the DMAE will process the commands as in E1.5. 1.The function that is used is always SRC-PCI; 2.VF_Valid = 0; 3.VFID=0; 4.Completion function=0; 5.Error handling=0
#define DMAE_REG_DMAE_CPT_MBIST1_CNTRL_CMD                                                                                 0x1020c8UL //ACCESS:RW  DataWidth:0x5  Description: N/A
#define DMAE_REG_CPT_CLK_MBIST1_CNTRL_DMAE_STATUS_0                                                                        0x1020ccUL //ACCESS:R  DataWidth:0x20  Description: N/A
#define DMAE_REG_CPT_CLK_MBIST1_CNTRL_DMAE_STATUS_1                                                                        0x1020d0UL //ACCESS:R  DataWidth:0x20  Description: N/A
#define DMAE_REG_CPT_CLK_PCI_MBIST1_CNTRL_DMAE_STATUS_0                                                                    0x1020d4UL //ACCESS:R  DataWidth:0x20  Description: N/A
#define DMAE_REG_CPT_CLK_PCI_MBIST1_CNTRL_DMAE_STATUS_1                                                                    0x1020d8UL //ACCESS:R  DataWidth:0x20  Description: N/A
#define DMAE_REG_CPT_CLK_PCI_MBIST1_CNTRL_DMAE_STATUS_2                                                                    0x1020dcUL //ACCESS:R  DataWidth:0x20  Description: N/A
#define DMAE_REG_CPT_CLK_CAM_CID_CAM_MBIST1_CNTRL_DMAE_STATUS_0                                                            0x1020e0UL //ACCESS:R  DataWidth:0x20  Description: N/A
#define DMAE_REG_CPT_CLK_CAM_STRING_CAM_MBIST1_CNTRL_DMAE_STATUS_0                                                         0x1020e4UL //ACCESS:R  DataWidth:0x20  Description: N/A
#define DMAE_REG_CPU_MBIST_MEMCTRL_0_CNTRL_CMD                                                                             0x1020e8UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0]
#define DMAE_REG_CPU_MBIST_MEMCTRL_1_CNTRL_CMD                                                                             0x1020ecUL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0]
#define DMAE_REG_CPU_MBIST_MEMCTRL_2_CNTRL_CMD                                                                             0x1020f0UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0]
#define DMAE_REG_CPU_MBIST_MEMCTRL_3_CNTRL_CMD                                                                             0x1020f4UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0]
#define DMAE_REG_CPU_MBIST_MEMCTRL_4_CNTRL_CMD                                                                             0x1020f8UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0]
#define DMAE_REG_CPU_MBIST_MEMCTRL_5_CNTRL_CMD                                                                             0x1020fcUL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0]
#define DMAE_REG_CPU_MBIST_MEMCTRL_6_CNTRL_CMD                                                                             0x102100UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0]
#define DMAE_REG_CPU_MBIST_MEMCTRL_7_CNTRL_CMD                                                                             0x102104UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0]
#define DMAE_REG_CPU_MBIST_MEMCTRL_8_CNTRL_CMD                                                                             0x102108UL //ACCESS:RW  DataWidth:0x5  Description: Bit 0 - bist_override; Bit 1 - mbist_en; Bit 2 - mbist_async_reset; Bits 4:3 - bist_setup[1:0]
#define DMAE_REG_CPU_MBIST_MEMCTRL_0_STATUS_0                                                                              0x10210cUL //ACCESS:R  DataWidth:0x20  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DMAE_REG_CPU_MBIST_MEMCTRL_1_STATUS_0                                                                              0x102110UL //ACCESS:R  DataWidth:0x20  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DMAE_REG_CPU_MBIST_MEMCTRL_2_STATUS_0                                                                              0x102114UL //ACCESS:R  DataWidth:0x20  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DMAE_REG_CPU_MBIST_MEMCTRL_3_STATUS_0                                                                              0x102118UL //ACCESS:R  DataWidth:0x20  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DMAE_REG_CPU_MBIST_MEMCTRL_4_STATUS_0                                                                              0x10211cUL //ACCESS:R  DataWidth:0x20  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DMAE_REG_CPU_MBIST_MEMCTRL_5_STATUS_0                                                                              0x102120UL //ACCESS:R  DataWidth:0x20  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DMAE_REG_CPU_MBIST_MEMCTRL_6_STATUS_0                                                                              0x102124UL //ACCESS:R  DataWidth:0x20  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DMAE_REG_CPU_MBIST_MEMCTRL_7_STATUS_0                                                                              0x102128UL //ACCESS:R  DataWidth:0x20  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DMAE_REG_CPU_MBIST_MEMCTRL_8_STATUS_0                                                                              0x10212cUL //ACCESS:R  DataWidth:0x20  Description: Bit 0 - mbist_done; Bit 1 -  mbist_go (global go bit); Bits NUM_OF_MEM+1:2 -  mbist_go0 (per mem go bit); Bits NUM_OF_SPARE+NUM_OF_MEM+1:NUM_OF_MEM+2 - spare bits
#define DMAE_REG_GO_C0                                                                                                     0x102080UL //ACCESS:RW  DataWidth:0x1  Description: Command 0 go.
#define DMAE_REG_GO_C0_SIZE                                                                                                1
#define DMAE_REG_GO_C1                                                                                                     0x102084UL //ACCESS:RW  DataWidth:0x1  Description: Command 1 go.
#define DMAE_REG_GO_C1_SIZE                                                                                                1
#define DMAE_REG_GO_C10                                                                                                    0x102088UL //ACCESS:RW  DataWidth:0x1  Description: Command 10 go.
#define DMAE_REG_GO_C10_SIZE                                                                                               1
#define DMAE_REG_GO_C11                                                                                                    0x10208cUL //ACCESS:RW  DataWidth:0x1  Description: Command 11 go.
#define DMAE_REG_GO_C11_SIZE                                                                                               1
#define DMAE_REG_GO_C12                                                                                                    0x102090UL //ACCESS:RW  DataWidth:0x1  Description: Command 12 go.
#define DMAE_REG_GO_C12_SIZE                                                                                               1
#define DMAE_REG_GO_C13                                                                                                    0x102094UL //ACCESS:RW  DataWidth:0x1  Description: Command 13 go.
#define DMAE_REG_GO_C13_SIZE                                                                                               1
#define DMAE_REG_GO_C14                                                                                                    0x102098UL //ACCESS:RW  DataWidth:0x1  Description: Command 14 go.
#define DMAE_REG_GO_C14_SIZE                                                                                               1
#define DMAE_REG_GO_C15                                                                                                    0x10209cUL //ACCESS:RW  DataWidth:0x1  Description: Command 15 go.
#define DMAE_REG_GO_C15_SIZE                                                                                               1
#define DMAE_REG_GO_C2                                                                                                     0x1020a0UL //ACCESS:RW  DataWidth:0x1  Description: Command 2 go.
#define DMAE_REG_GO_C2_SIZE                                                                                                1
#define DMAE_REG_GO_C3                                                                                                     0x1020a4UL //ACCESS:RW  DataWidth:0x1  Description: Command 3 go.
#define DMAE_REG_GO_C3_SIZE                                                                                                1
#define DMAE_REG_GO_C4                                                                                                     0x1020a8UL //ACCESS:RW  DataWidth:0x1  Description: Command 4 go.
#define DMAE_REG_GO_C4_SIZE                                                                                                1
#define DMAE_REG_GO_C5                                                                                                     0x1020acUL //ACCESS:RW  DataWidth:0x1  Description: Command 5 go.
#define DMAE_REG_GO_C5_SIZE                                                                                                1
#define DMAE_REG_GO_C6                                                                                                     0x1020b0UL //ACCESS:RW  DataWidth:0x1  Description: Command 6 go.
#define DMAE_REG_GO_C6_SIZE                                                                                                1
#define DMAE_REG_GO_C7                                                                                                     0x1020b4UL //ACCESS:RW  DataWidth:0x1  Description: Command 7 go.
#define DMAE_REG_GO_C7_SIZE                                                                                                1
#define DMAE_REG_GO_C8                                                                                                     0x1020b8UL //ACCESS:RW  DataWidth:0x1  Description: Command 8 go.
#define DMAE_REG_GO_C8_SIZE                                                                                                1
#define DMAE_REG_GO_C9                                                                                                     0x1020bcUL //ACCESS:RW  DataWidth:0x1  Description: Command 9 go.
#define DMAE_REG_GO_C9_SIZE                                                                                                1
#define DMAE_REG_PXP_REQ_INIT_CRD                                                                                          0x1020c0UL //ACCESS:RW  DataWidth:0x4  Description: DMAE- PCI Request Interface initial credit. Write writes the initial value to the credit counter; related to the address. Read returns the current value of the counter.
#define DMAE_REG_PXP_REQ_INIT_CRD_SIZE                                                                                     1
#define DMAE_REG_CMD_MEM                                                                                                   0x102400UL //ACCESS:RW  DataWidth:0x20  Description: Commands memory. The address to command X; row Y is to calculated as 14*X+Y.
#define DMAE_REG_CMD_MEM_SIZE                                                                                              224
#define DMAE_REG_DMAE_UNUSED_EMPTY_0                                                                                       0x1020c4UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DMAE_REG_DMAE_UNUSED_EMPTY_0_SIZE                                                                                  1
#define DMAE_REG_DMAE_UNUSED_EMPTY_1                                                                                       0x102130UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DMAE_REG_DMAE_UNUSED_EMPTY_1_SIZE                                                                                  180
#define DMAE_REG_DMAE_UNUSED_EMPTY_2                                                                                       0x102800UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DMAE_REG_DMAE_UNUSED_EMPTY_2_SIZE                                                                                  512
#define DORQ_REG_INIT                                                                                                      0x170000UL //ACCESS:RW  DataWidth:0x1  Description: Debug only. Initialises specific states and statuses. To initialise the state - write 1 into register; to enable working after that - write 0.
#define DORQ_REG_IF_EN                                                                                                     0x170004UL //ACCESS:RW  DataWidth:0x4  Multi Field Register		
	#define DORQ_IF_EN_REG_RQ_IFEN                                                                                         (0x1<<0)
	#define DORQ_IF_EN_REG_RQ_IFEN_SIZE                                                                                    0		
	#define DORQ_IF_EN_REG_CF_IFEN                                                                                         (0x1<<1)
	#define DORQ_IF_EN_REG_CF_IFEN_SIZE                                                                                    1		
	#define DORQ_IF_EN_REG_RSP_IFEN                                                                                        (0x1<<2)
	#define DORQ_IF_EN_REG_RSP_IFEN_SIZE                                                                                   2		
	#define DORQ_IF_EN_REG_DPM_IFEN                                                                                        (0x1<<3)
	#define DORQ_IF_EN_REG_DPM_IFEN_SIZE                                                                                   3
#define DORQ_REG_MODE_ACT                                                                                                  0x170008UL //ACCESS:RW  DataWidth:0x2  Multi Field Register		
	#define DORQ_MODE_ACT_REG_NORM_MODE_ACT                                                                                (0x1<<0)
	#define DORQ_MODE_ACT_REG_NORM_MODE_ACT_SIZE                                                                           0		
	#define DORQ_MODE_ACT_REG_DPM_MODE_ACT                                                                                 (0x1<<1)
	#define DORQ_MODE_ACT_REG_DPM_MODE_ACT_SIZE                                                                            1
#define DORQ_REG_NORM_ADDR_MASK                                                                                            0x17000cUL //ACCESS:RW  DataWidth:0x20  Description: The normal mode address mask. Filters a certain amount of MSBits of the address to distinguish the normal mode.
#define DORQ_REG_DPM_ADDR_MASK                                                                                             0x170010UL //ACCESS:RW  DataWidth:0x20  Description: The DPM mode address mask. Filters a certain amount of MSBits of the address to distinguish the DPM mode.
#define DORQ_REG_NORM_ADDR_BASE                                                                                            0x170014UL //ACCESS:RW  DataWidth:0x20  Description: The normal mode base address.
#define DORQ_REG_DPM_ADDR_BASE                                                                                             0x170018UL //ACCESS:RW  DataWidth:0x20  Description: The DPM mode base address.
#define DORQ_REG_NORM_CID_MASK                                                                                             0x17001cUL //ACCESS:RW  DataWidth:0x17  Description: The normal mode CID extraction mask.
#define DORQ_REG_DPM_CID_MASK                                                                                              0x170020UL //ACCESS:RW  DataWidth:0x17  Description: The DPM mode CID extraction mask.
#define DORQ_REG_NORM_CID_BASE                                                                                             0x170024UL //ACCESS:RW  DataWidth:0x17  Description: The normal mode CID base.
#define DORQ_REG_DPM_CID_BASE                                                                                              0x170028UL //ACCESS:RW  DataWidth:0x17  Description: The DPM mode CID base.
#define DORQ_REG_NORM_CID_OFST                                                                                             0x17002cUL //ACCESS:RW  DataWidth:0x5  Description: The normal mode CID extraction offset.
#define DORQ_REG_DPM_CID_OFST                                                                                              0x170030UL //ACCESS:RW  DataWidth:0x5  Description: The DPM mode CID extraction offset.
#define DORQ_REG_QM_AEMPTY_EN                                                                                              0x170034UL //ACCESS:RW  DataWidth:0x1  Description: If 0 - QM almost empty is disregarded; if 1 - QM almost empty is taken into consideration.
#define DORQ_REG_REGN                                                                                                      0x170038UL //ACCESS:RW  DataWidth:0x18  Multi Field Register		
	#define DORQ_REGN_REG_NORM_REGN_TX                                                                                     (0xff<<0)
	#define DORQ_REGN_REG_NORM_REGN_TX_SIZE                                                                                0		
	#define DORQ_REGN_REG_REGN_RX                                                                                          (0xff<<8)
	#define DORQ_REGN_REG_REGN_RX_SIZE                                                                                     8		
	#define DORQ_REGN_REG_SHRT_REGN_TX                                                                                     (0xff<<16)
	#define DORQ_REGN_REG_SHRT_REGN_TX_SIZE                                                                                16
#define DORQ_REG_OUTST_REQ                                                                                                 0x17003cUL //ACCESS:RW  DataWidth:0x4  Description: The number of simultaneous outstanding requests to Context Fetch Interface.
#define DORQ_REG_DPM_WR_TYPE_LOC                                                                                           0x170040UL //ACCESS:RW  DataWidth:0x5  Description: DPM write type location. Selects one of bits of address to differentiate between DPM data and DPM trigger types.
#define DORQ_REG_DPM_CID_ADDR                                                                                              0x170044UL //ACCESS:RW  DataWidth:0x8  Description: The address to write the DPM CID to STORM.
#define DORQ_REG_RSP_INIT_CRD                                                                                              0x170048UL //ACCESS:RW  DataWidth:0x4  Description: The initial credit at the Doorbell Response Interface. The write writes the same initial credit to the rspa_crd_cnt and rspb_crd_cnt. The read reads this written value.
#define DORQ_REG_NORM_CMHEAD_TX                                                                                            0x17004cUL //ACCESS:RW  DataWidth:0x1c  Description: TCM Header when only TCP context is loaded.
#define DORQ_REG_CMHEAD_RX                                                                                                 0x170050UL //ACCESS:RW  DataWidth:0x1c  Description: UCM Header.
#define DORQ_REG_SHRT_CMHEAD                                                                                               0x170054UL //ACCESS:RW  DataWidth:0x1c  Description: TCM Header when both ULP and TCP context is loaded.
#define DORQ_REG_ERR_CMHEAD                                                                                                0x170058UL //ACCESS:RW  DataWidth:0x1c  Description: The value sent to CM header in the case of CFC load error.
#define DORQ_REG_ERR_EVENT_ID                                                                                              0x17005cUL //ACCESS:RW  DataWidth:0x8  Description: Event ID sent to TCM/UCM.
#define DORQ_REG_SHRT_ACT_CNT                                                                                              0x170070UL //ACCESS:RW  DataWidth:0x4  Description: Initial activity counter value on the load request; when the shortcut is done.
#define DORQ_REG_M_SP_RAM_TM                                                                                               0x170074UL //ACCESS:RW  DataWidth:0x5  Description: TM bits of DORQ memory.
#define DORQ_REG_DQ_FIFO_FULL_TH                                                                                           0x170078UL //ACCESS:RW  DataWidth:0xc  Description: The threshold of the DQ FIFO to send the full interrupt.
#define DORQ_REG_DQ_FIFO_AFULL_TH                                                                                          0x17007cUL //ACCESS:RW  DataWidth:0xc  Description: The threshold of the DQ FIFO to send the almost full interrupt.
#define DORQ_REG_DQ_FREEZE                                                                                                 0x170080UL //ACCESS:RW  DataWidth:0x1  Description: When set; the DQ will serve the doorbells; already existing in the queue and will block the Response interface.
#define DORQ_REG_AUTO_FREEZE_EN                                                                                            0x170084UL //ACCESS:RW  DataWidth:0x1  Description: When set; the DQ will automatically stop sending CFC load requests when a doorbell discard interrupt is generated. The freeze mode will remain until the auto_freeze_rel register is set.
#define DORQ_REG_AUTO_DISCARD_EN                                                                                           0x170088UL //ACCESS:RW  DataWidth:0x1  Description: If this register is equal to 1 then the DQ will enter auto discard mode when a doorbell discard interrupt is generated. In this mode all incoming doorbells will be dropped even if the FIFO is not full anymore. 
#define DORQ_REG_DB_ADDR0                                                                                                  0x17008cUL //ACCESS:RW  DataWidth:0x20  Description: Doorbell address for RBC doorbells (function 0).
#define DORQ_REG_DB_ADDR1                                                                                                  0x170090UL //ACCESS:RW  DataWidth:0x20  Description: Doorbell address for RBC doorbells (function 1).
#define DORQ_REG_DBG_SELECT                                                                                                0x170094UL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from DORQ to the DBG block) - for selecting a line to output to the DBG block.
#define DORQ_REG_DBG_BYTE_ENABLE                                                                                           0x170098UL //ACCESS:RW  DataWidth:0x8  Description: Debug only. For dbgmux usage (debug data that goes from DORQ to the DBG block) - for enabling bytes in the selected line (after the select; before the shift).
#define DORQ_REG_DBG_SHIFT                                                                                                 0x17009cUL //ACCESS:RW  DataWidth:0x3  Description: Debug only. For dbgmux usage (debug data that goes from DORQ to the DBG block) - for circular right shifting of the selected line (after the enabling).
#define DORQ_REG_DQ_FILL_LVLL                                                                                              0x1700a0UL //ACCESS:R  DataWidth:0xd  Description: Current value of the  DQ FIFO fill level according to leading pointer. The range is 0 - 256 FIFO rows; where each row stands for the doorbell.
#define DORQ_REG_DQ_FILL_LVLF                                                                                              0x1700a4UL //ACCESS:R  DataWidth:0xd  Description: Current value of the  DQ FIFO fill level according to following pointer. The range is 0 - 256 FIFO rows; where each row stands for the doorbell.
#define DORQ_REG_OUTST_REQ_CNT                                                                                             0x1700a8UL //ACCESS:R  DataWidth:0x4  Description: Current value of outstanding requests counter credit.
#define DORQ_REG_RSPA_CRD_CNT                                                                                              0x1700acUL //ACCESS:R  DataWidth:0x4  Description: Current value of response A counter credit. Initial credit is configured through write to ~dorq_registers_rsp_init_crd.rsp_init_crd register.
#define DORQ_REG_RSPB_CRD_CNT                                                                                              0x1700b0UL //ACCESS:R  DataWidth:0x4  Description: Current value of response B counter credit.  Initial credit is configured through write to ~dorq_registers_rsp_init_crd.rsp_init_crd register.
#define DORQ_REG_DQ_FIFO_RDL_PTR                                                                                           0x1700b4UL //ACCESS:R  DataWidth:0xc  Description: DQ FIFO read leading pointer.
#define DORQ_REG_DQ_FIFO_RDF_PTR                                                                                           0x1700b8UL //ACCESS:R  DataWidth:0xc  Description: DQ FIFO read following pointer.
#define DORQ_REG_DQ_FIFO_WR_PTR                                                                                            0x1700bcUL //ACCESS:R  DataWidth:0xc  Description: DQ FIFO write pointer.
#define DORQ_REG_DQ_FULL_ST                                                                                                0x1700c0UL //ACCESS:R  DataWidth:0x1  Description: DQ FIFO full status. Is set; when FIFO filling level is more or equal to full threshold; reset on full clear.
#define DORQ_REG_DB_CNTR                                                                                                   0x1700c4UL //ACCESS:ST  DataWidth:0x20  Description: Counts the total number of received doorbells.
#define DORQ_REG_DB_MIS_CNTR                                                                                               0x1700c8UL //ACCESS:ST  DataWidth:0x8  Description: Counts the total number of discarded doorbells in PF mode due to mode or range mismatch
#define DORQ_REG_CFC_ERR_CNTR                                                                                              0x1700ccUL //ACCESS:ST  DataWidth:0x8  Description: Counts the number of CFC load errors.
#define DORQ_REG_DPM_FULL_CNTR                                                                                             0x1700d0UL //ACCESS:ST  DataWidth:0x8  Description: Counts the number DPM tried to wite to STORM when it was full.
#define DORQ_REG_DB_DIS_CNTR0                                                                                              0x1700d4UL //ACCESS:ST  DataWidth:0x10  Description: Doorbell disable counter (function 0).
#define DORQ_REG_DB_DIS_CNTR1                                                                                              0x1700d8UL //ACCESS:ST  DataWidth:0x10  Description: Doorbell disable counter (function 1).
#define DORQ_REG_TYPE_VAL_ERR_ADDR                                                                                         0x1700dcUL //ACCESS:RC  DataWidth:0x20  Description: Keeps the address of the first doorbell; caused the type validation error.
#define DORQ_REG_PRIV_MIN_ADDR0                                                                                            0x1700e0UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 0.
#define DORQ_REG_PRIV_MIN_ADDR1                                                                                            0x1700e4UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 1.
#define DORQ_REG_PRIV_MAX_ADDR0                                                                                            0x1700e8UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 0.
#define DORQ_REG_PRIV_MAX_ADDR1                                                                                            0x1700ecUL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 1.
#define DORQ_REG_TYPE_MIN_ADDR00                                                                                           0x1700f0UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 0 conection type 0.
#define DORQ_REG_TYPE_MIN_ADDR01                                                                                           0x1700f4UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 0 conection type 1.
#define DORQ_REG_TYPE_MIN_ADDR02                                                                                           0x1700f8UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 0 conection type 2.
#define DORQ_REG_TYPE_MIN_ADDR03                                                                                           0x1700fcUL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 0 conection type 3.
#define DORQ_REG_TYPE_MIN_ADDR04                                                                                           0x170100UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 0 conection type 4.
#define DORQ_REG_TYPE_MIN_ADDR05                                                                                           0x170104UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 0 conection type 5.
#define DORQ_REG_TYPE_MIN_ADDR06                                                                                           0x170108UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 0 conection type 6.
#define DORQ_REG_TYPE_MIN_ADDR07                                                                                           0x17010cUL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 0 conection type 7.
#define DORQ_REG_TYPE_MIN_ADDR10                                                                                           0x170110UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 1 conection type 0.
#define DORQ_REG_TYPE_MIN_ADDR11                                                                                           0x170114UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 1 conection type 1.
#define DORQ_REG_TYPE_MIN_ADDR12                                                                                           0x170118UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 1 conection type 2.
#define DORQ_REG_TYPE_MIN_ADDR13                                                                                           0x17011cUL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 1 conection type 3.
#define DORQ_REG_TYPE_MIN_ADDR14                                                                                           0x170120UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 1 conection type 4.
#define DORQ_REG_TYPE_MIN_ADDR15                                                                                           0x170124UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 1 conection type 5.
#define DORQ_REG_TYPE_MIN_ADDR16                                                                                           0x170128UL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 1 conection type 6.
#define DORQ_REG_TYPE_MIN_ADDR17                                                                                           0x17012cUL //ACCESS:RW  DataWidth:0x20  Description: The minimum level for the type address validation function 1 conection type 7.
#define DORQ_REG_TYPE_MAX_ADDR00                                                                                           0x170130UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 0 connection type 0.
#define DORQ_REG_TYPE_MAX_ADDR01                                                                                           0x170134UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 0 connection type 1.
#define DORQ_REG_TYPE_MAX_ADDR02                                                                                           0x170138UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 0 connection type 2.
#define DORQ_REG_TYPE_MAX_ADDR03                                                                                           0x17013cUL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 0 connection type 3.
#define DORQ_REG_TYPE_MAX_ADDR04                                                                                           0x170140UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 0 connection type 4.
#define DORQ_REG_TYPE_MAX_ADDR05                                                                                           0x170144UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 0 connection type 5.
#define DORQ_REG_TYPE_MAX_ADDR06                                                                                           0x170148UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 0 connection type 6.
#define DORQ_REG_TYPE_MAX_ADDR07                                                                                           0x17014cUL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 0 connection type 7.
#define DORQ_REG_TYPE_MAX_ADDR10                                                                                           0x170150UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 1 connection type 0.
#define DORQ_REG_TYPE_MAX_ADDR11                                                                                           0x170154UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 1 connection type 1.
#define DORQ_REG_TYPE_MAX_ADDR12                                                                                           0x170158UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 1 connection type 2.
#define DORQ_REG_TYPE_MAX_ADDR13                                                                                           0x17015cUL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 1 connection type 3.
#define DORQ_REG_TYPE_MAX_ADDR14                                                                                           0x170160UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 1 connection type 4.
#define DORQ_REG_TYPE_MAX_ADDR15                                                                                           0x170164UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 1 connection type 5.
#define DORQ_REG_TYPE_MAX_ADDR16                                                                                           0x170168UL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 1 connection type 6.
#define DORQ_REG_TYPE_MAX_ADDR17                                                                                           0x17016cUL //ACCESS:RW  DataWidth:0x20  Description: The maximum level for the type address validation function 1 connection type 7.
#define DORQ_REG_TYPE_VAL_ERR_CNTR                                                                                         0x170170UL //ACCESS:ST  DataWidth:0x8  Description: The number of doorbells which failed the PF type validation.
#define DORQ_REG_DORQ_INT_STS                                                                                              0x170174UL //ACCESS:R  DataWidth:0x6  Description: Interrupt register #0 read		
	#define DORQ_DORQ_INT_STS_REG_ADDRESS_ERROR                                                                            (0x1<<0)
	#define DORQ_DORQ_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                       0		
	#define DORQ_DORQ_INT_STS_REG_DB_DISCARD                                                                               (0x1<<1)
	#define DORQ_DORQ_INT_STS_REG_DB_DISCARD_SIZE                                                                          1		
	#define DORQ_DORQ_INT_STS_REG_TYPE_VAL_ERR                                                                             (0x1<<2)
	#define DORQ_DORQ_INT_STS_REG_TYPE_VAL_ERR_SIZE                                                                        2		
	#define DORQ_DORQ_INT_STS_REG_DB_COLLISION                                                                             (0x1<<3)
	#define DORQ_DORQ_INT_STS_REG_DB_COLLISION_SIZE                                                                        3		
	#define DORQ_DORQ_INT_STS_REG_DQ_AFULL                                                                                 (0x1<<4)
	#define DORQ_DORQ_INT_STS_REG_DQ_AFULL_SIZE                                                                            4		
	#define DORQ_DORQ_INT_STS_REG_VF_TYPE_VAL_ERR                                                                          (0x1<<5)
	#define DORQ_DORQ_INT_STS_REG_VF_TYPE_VAL_ERR_SIZE                                                                     5
#define DORQ_REG_DORQ_INT_STS_CLR                                                                                          0x170178UL //ACCESS:RC  DataWidth:0x6  Description: Interrupt register #0 read clear		
	#define DORQ_DORQ_INT_STS_CLR_REG_ADDRESS_ERROR                                                                        (0x1<<0)
	#define DORQ_DORQ_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                   0		
	#define DORQ_DORQ_INT_STS_CLR_REG_DB_DISCARD                                                                           (0x1<<1)
	#define DORQ_DORQ_INT_STS_CLR_REG_DB_DISCARD_SIZE                                                                      1		
	#define DORQ_DORQ_INT_STS_CLR_REG_TYPE_VAL_ERR                                                                         (0x1<<2)
	#define DORQ_DORQ_INT_STS_CLR_REG_TYPE_VAL_ERR_SIZE                                                                    2		
	#define DORQ_DORQ_INT_STS_CLR_REG_DB_COLLISION                                                                         (0x1<<3)
	#define DORQ_DORQ_INT_STS_CLR_REG_DB_COLLISION_SIZE                                                                    3		
	#define DORQ_DORQ_INT_STS_CLR_REG_DQ_AFULL                                                                             (0x1<<4)
	#define DORQ_DORQ_INT_STS_CLR_REG_DQ_AFULL_SIZE                                                                        4		
	#define DORQ_DORQ_INT_STS_CLR_REG_VF_TYPE_VAL_ERR                                                                      (0x1<<5)
	#define DORQ_DORQ_INT_STS_CLR_REG_VF_TYPE_VAL_ERR_SIZE                                                                 5
#define DORQ_REG_DORQ_INT_STS_WR                                                                                           0x17017cUL //ACCESS:WR  DataWidth:0x6  Description: Interrupt register #0 bit set or clear		
	#define DORQ_DORQ_INT_STS_WR_REG_ADDRESS_ERROR                                                                         (0x1<<0)
	#define DORQ_DORQ_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                    0		
	#define DORQ_DORQ_INT_STS_WR_REG_DB_DISCARD                                                                            (0x1<<1)
	#define DORQ_DORQ_INT_STS_WR_REG_DB_DISCARD_SIZE                                                                       1		
	#define DORQ_DORQ_INT_STS_WR_REG_TYPE_VAL_ERR                                                                          (0x1<<2)
	#define DORQ_DORQ_INT_STS_WR_REG_TYPE_VAL_ERR_SIZE                                                                     2		
	#define DORQ_DORQ_INT_STS_WR_REG_DB_COLLISION                                                                          (0x1<<3)
	#define DORQ_DORQ_INT_STS_WR_REG_DB_COLLISION_SIZE                                                                     3		
	#define DORQ_DORQ_INT_STS_WR_REG_DQ_AFULL                                                                              (0x1<<4)
	#define DORQ_DORQ_INT_STS_WR_REG_DQ_AFULL_SIZE                                                                         4		
	#define DORQ_DORQ_INT_STS_WR_REG_VF_TYPE_VAL_ERR                                                                       (0x1<<5)
	#define DORQ_DORQ_INT_STS_WR_REG_VF_TYPE_VAL_ERR_SIZE                                                                  5
#define DORQ_REG_DORQ_INT_MASK                                                                                             0x170180UL //ACCESS:RW  DataWidth:0x6  Description: Interrupt mask register #0 read/write		
	#define DORQ_DORQ_INT_MASK_REG_ADDRESS_ERROR                                                                           (0x1<<0)
	#define DORQ_DORQ_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                      0		
	#define DORQ_DORQ_INT_MASK_REG_DB_DISCARD                                                                              (0x1<<1)
	#define DORQ_DORQ_INT_MASK_REG_DB_DISCARD_SIZE                                                                         1		
	#define DORQ_DORQ_INT_MASK_REG_TYPE_VAL_ERR                                                                            (0x1<<2)
	#define DORQ_DORQ_INT_MASK_REG_TYPE_VAL_ERR_SIZE                                                                       2		
	#define DORQ_DORQ_INT_MASK_REG_DB_COLLISION                                                                            (0x1<<3)
	#define DORQ_DORQ_INT_MASK_REG_DB_COLLISION_SIZE                                                                       3		
	#define DORQ_DORQ_INT_MASK_REG_DQ_AFULL                                                                                (0x1<<4)
	#define DORQ_DORQ_INT_MASK_REG_DQ_AFULL_SIZE                                                                           4		
	#define DORQ_DORQ_INT_MASK_REG_VF_TYPE_VAL_ERR                                                                         (0x1<<5)
	#define DORQ_DORQ_INT_MASK_REG_VF_TYPE_VAL_ERR_SIZE                                                                    5
#define DORQ_REG_DORQ_PRTY_STS                                                                                             0x170184UL //ACCESS:R  DataWidth:0x2  Description: Parity register #0 read		
	#define DORQ_DORQ_PRTY_STS_REG_PARITY                                                                                  (0x1<<0)
	#define DORQ_DORQ_PRTY_STS_REG_PARITY_SIZE                                                                             0		
	#define DORQ_DORQ_PRTY_STS_REG_DORQ_PRTY                                                                               (0x1<<1)
	#define DORQ_DORQ_PRTY_STS_REG_DORQ_PRTY_SIZE                                                                          1
#define DORQ_REG_DORQ_PRTY_STS_CLR                                                                                         0x170188UL //ACCESS:RC  DataWidth:0x2  Description: Parity register #0 read clear		
	#define DORQ_DORQ_PRTY_STS_CLR_REG_PARITY                                                                              (0x1<<0)
	#define DORQ_DORQ_PRTY_STS_CLR_REG_PARITY_SIZE                                                                         0		
	#define DORQ_DORQ_PRTY_STS_CLR_REG_DORQ_PRTY                                                                           (0x1<<1)
	#define DORQ_DORQ_PRTY_STS_CLR_REG_DORQ_PRTY_SIZE                                                                      1
#define DORQ_REG_DORQ_PRTY_STS_WR                                                                                          0x17018cUL //ACCESS:WR  DataWidth:0x2  Description: Parity register #0 bit set or clear		
	#define DORQ_DORQ_PRTY_STS_WR_REG_PARITY                                                                               (0x1<<0)
	#define DORQ_DORQ_PRTY_STS_WR_REG_PARITY_SIZE                                                                          0		
	#define DORQ_DORQ_PRTY_STS_WR_REG_DORQ_PRTY                                                                            (0x1<<1)
	#define DORQ_DORQ_PRTY_STS_WR_REG_DORQ_PRTY_SIZE                                                                       1
#define DORQ_REG_DORQ_PRTY_MASK                                                                                            0x170190UL //ACCESS:RW  DataWidth:0x2  Description: Parity mask register #0 read/write		
	#define DORQ_DORQ_PRTY_MASK_REG_PARITY                                                                                 (0x1<<0)
	#define DORQ_DORQ_PRTY_MASK_REG_PARITY_SIZE                                                                            0		
	#define DORQ_DORQ_PRTY_MASK_REG_DORQ_PRTY                                                                              (0x1<<1)
	#define DORQ_DORQ_PRTY_MASK_REG_DORQ_PRTY_SIZE                                                                         1
#define DORQ_REG_ECO_RESERVED                                                                                              0x170194UL //ACCESS:RW  DataWidth:0x8  Description: chicken bits
#define DORQ_REG_DB_RSP_CNTR                                                                                               0x1701acUL //ACCESS:R  DataWidth:0x20  Description: Counts the number of doorbells sent to XCM or UCM on the response interface.
#define DORQ_REG_DB_FID0                                                                                                   0x1701b0UL //ACCESS:RW  DataWidth:0xa  Description: FID for RBC doorbells (function 0).
#define DORQ_REG_DB_FID1                                                                                                   0x1701b4UL //ACCESS:RW  DataWidth:0xa  Description: FID for RBC doorbells (function 1).
#define DORQ_REG_CANCEL_CMHEAD                                                                                             0x1701c4UL //ACCESS:RW  DataWidth:0x1c  Description: The value sent to CM header in the case of CFC load cancellation.
#define DORQ_REG_CFC_CANCEL_CNTR                                                                                           0x1701ccUL //ACCESS:ST  DataWidth:0x8  Description: Counts the number of CFC load cancellations.
#define DORQ_REG_VF_DB_MIS_CNTR                                                                                            0x1701d4UL //ACCESS:ST  DataWidth:0x8  Description: Counts the total number of discarded doorbells in VF mode due to range mismatch
#define DORQ_REG_VF_TYPE_VAL_ERR_FID                                                                                       0x1701d8UL //ACCESS:RC  DataWidth:0xa  Description: Keeps the FID of the first doorbell that caused a VF type validation error.
#define DORQ_REG_VF_TYPE_VAL_ERR_MCID                                                                                      0x1701dcUL //ACCESS:RC  DataWidth:0x11  Description: Keeps the MCID of the first doorbell that caused a VF type validation error.
#define DORQ_REG_VF_TYPE_VAL_ERR_CNTR                                                                                      0x1701e0UL //ACCESS:ST  DataWidth:0x8  Description: The number of doorbells which failed the VF type validation.
#define DORQ_REG_VF_INDEX_FIX_EN                                                                                           0x1701e8UL //ACCESS:RW  DataWidth:0x1  Description: Chicken bit for VF index fix. If high rf_dorq_func[9:4] maps to VF registers.  Otherwise rf_dorq_func[5:0] maps to VF registers.
#define DORQ_REG_VF_TYPE_MASK_0                                                                                            0x170218UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_1                                                                                            0x17021cUL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_2                                                                                            0x170220UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_3                                                                                            0x170224UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_4                                                                                            0x170228UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_5                                                                                            0x17022cUL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_6                                                                                            0x170230UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_7                                                                                            0x170234UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_8                                                                                            0x170238UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_9                                                                                            0x17023cUL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_10                                                                                           0x170240UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_11                                                                                           0x170244UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_12                                                                                           0x170248UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_13                                                                                           0x17024cUL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_14                                                                                           0x170250UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_MASK_15                                                                                           0x170254UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation mask value
#define DORQ_REG_VF_TYPE_VALUE_0                                                                                           0x170258UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_1                                                                                           0x17025cUL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_2                                                                                           0x170260UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_3                                                                                           0x170264UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_4                                                                                           0x170268UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_5                                                                                           0x17026cUL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_6                                                                                           0x170270UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_7                                                                                           0x170274UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_8                                                                                           0x170278UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_9                                                                                           0x17027cUL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_10                                                                                          0x170280UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_11                                                                                          0x170284UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_12                                                                                          0x170288UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_13                                                                                          0x17028cUL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_14                                                                                          0x170290UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_VALUE_15                                                                                          0x170294UL //ACCESS:RW  DataWidth:0xa  Description: VF type validation comp value
#define DORQ_REG_VF_TYPE_MIN_MCID_0                                                                                        0x170298UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_1                                                                                        0x17029cUL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_2                                                                                        0x1702a0UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_3                                                                                        0x1702a4UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_4                                                                                        0x1702a8UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_5                                                                                        0x1702acUL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_6                                                                                        0x1702b0UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_7                                                                                        0x1702b4UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_8                                                                                        0x1702b8UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_9                                                                                        0x1702bcUL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_10                                                                                       0x1702c0UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_11                                                                                       0x1702c4UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_12                                                                                       0x1702c8UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_13                                                                                       0x1702ccUL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_14                                                                                       0x1702d0UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MIN_MCID_15                                                                                       0x1702d4UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Max MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_0                                                                                        0x1702d8UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_1                                                                                        0x1702dcUL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_2                                                                                        0x1702e0UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_3                                                                                        0x1702e4UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_4                                                                                        0x1702e8UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_5                                                                                        0x1702ecUL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_6                                                                                        0x1702f0UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_7                                                                                        0x1702f4UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_8                                                                                        0x1702f8UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_9                                                                                        0x1702fcUL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_10                                                                                       0x170300UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_11                                                                                       0x170304UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_12                                                                                       0x170308UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_13                                                                                       0x17030cUL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_14                                                                                       0x170310UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_VF_TYPE_MAX_MCID_15                                                                                       0x170314UL //ACCESS:RW  DataWidth:0x11  Description: VF type validation Min MCID value
#define DORQ_REG_AUTO_FREEZE_ST                                                                                            0x170318UL //ACCESS:R  DataWidth:0x1  Description: When high auto freeze is active and doorbells are not being drained from the FIFO.  Cleared when auto_freeze_rel is written.
#define DORQ_REG_AUTO_DISCARD_ST                                                                                           0x17031cUL //ACCESS:R  DataWidth:0x1  Description: When high auto discard is active and all doorbells are dropped before going into the FIFO.  Cleared when auto_discard_rel is written.
#define DORQ_REG_PF_DISCARD_STAT_POLL                                                                                      0x17032cUL //ACCESS:R  DataWidth:0x8  Description: Allows all the pf_discard_status bits to be read at once.
#define DORQ_REG_VF_DISCARD_STAT_POLL0                                                                                     0x170338UL //ACCESS:R  DataWidth:0x20  Description: Allows the upper 32 bits of the vf_discard_status bits to be read at once.
#define DORQ_REG_VF_DISCARD_STAT_POLL1                                                                                     0x17033cUL //ACCESS:R  DataWidth:0x20  Description: Allows the lower 32 bits of the vf_discard_status bits to be read at once.
#define DORQ_REG_CM_T_FLAG                                                                                                 0x170344UL //ACCESS:RW  DataWidth:0x1  Description: Thread Required bit for error indicating CM messages
#define DORQ_REG_AGG_CMD_0                                                                                                 0x170400UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_1                                                                                                 0x170404UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_2                                                                                                 0x170408UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_3                                                                                                 0x17040cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_4                                                                                                 0x170410UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_5                                                                                                 0x170414UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_6                                                                                                 0x170418UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_7                                                                                                 0x17041cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_8                                                                                                 0x170420UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_9                                                                                                 0x170424UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_10                                                                                                0x170428UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_11                                                                                                0x17042cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_12                                                                                                0x170430UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_13                                                                                                0x170434UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_14                                                                                                0x170438UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_15                                                                                                0x17043cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_16                                                                                                0x170440UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_17                                                                                                0x170444UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_18                                                                                                0x170448UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_19                                                                                                0x17044cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_20                                                                                                0x170450UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_21                                                                                                0x170454UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_22                                                                                                0x170458UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_23                                                                                                0x17045cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_24                                                                                                0x170460UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_25                                                                                                0x170464UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_26                                                                                                0x170468UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_27                                                                                                0x17046cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_28                                                                                                0x170470UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_29                                                                                                0x170474UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_30                                                                                                0x170478UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_31                                                                                                0x17047cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_32                                                                                                0x170480UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_33                                                                                                0x170484UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_34                                                                                                0x170488UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_35                                                                                                0x17048cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_36                                                                                                0x170490UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_37                                                                                                0x170494UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_38                                                                                                0x170498UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_39                                                                                                0x17049cUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_40                                                                                                0x1704a0UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_41                                                                                                0x1704a4UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_42                                                                                                0x1704a8UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_43                                                                                                0x1704acUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_44                                                                                                0x1704b0UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_45                                                                                                0x1704b4UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_46                                                                                                0x1704b8UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_47                                                                                                0x1704bcUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_48                                                                                                0x1704c0UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_49                                                                                                0x1704c4UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_50                                                                                                0x1704c8UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_51                                                                                                0x1704ccUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_52                                                                                                0x1704d0UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_53                                                                                                0x1704d4UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_54                                                                                                0x1704d8UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_55                                                                                                0x1704dcUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_56                                                                                                0x1704e0UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_57                                                                                                0x1704e4UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_58                                                                                                0x1704e8UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_59                                                                                                0x1704ecUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_60                                                                                                0x1704f0UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_61                                                                                                0x1704f4UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_62                                                                                                0x1704f8UL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_AGG_CMD_63                                                                                                0x1704fcUL //ACCESS:RW  DataWidth:0x8  Description: Aggregation cmd per  {vf_valid; conn type; A; R}
#define DORQ_REG_VF_NORM_ADDR_MASK                                                                                         0x170198UL //ACCESS:RW  DataWidth:0x20  SPLIT:8  Description: The normal mode address mask for VF doorbells. Filters a certain amount of MSBits of the address to distinguish the normal mode.
#define DORQ_REG_VF_NORM_ADDR_MASK_SIZE                                                                                    1
#define DORQ_REG_VF_NORM_ADDR_BASE                                                                                         0x17019cUL //ACCESS:RW  DataWidth:0x20  SPLIT:8  Description: The normal mode base address for VF doorbells.
#define DORQ_REG_VF_NORM_ADDR_BASE_SIZE                                                                                    1
#define DORQ_REG_VF_NORM_CID_BASE                                                                                          0x1701a0UL //ACCESS:RW  DataWidth:0x11  SPLIT:8  Description: The per-VNIC normal mode CID base for VF doorbells.
#define DORQ_REG_VF_NORM_CID_BASE_SIZE                                                                                     1
#define DORQ_REG_VF_NORM_CID_WND_SIZE                                                                                      0x1701a4UL //ACCESS:RW  DataWidth:0x5  SPLIT:8  Description: The per-VNIC normal CID window size for VF doorbells.
#define DORQ_REG_VF_NORM_CID_WND_SIZE_SIZE                                                                                 1
#define DORQ_REG_VF_NORM_VF_BASE                                                                                           0x1701a8UL //ACCESS:RW  DataWidth:0x3  SPLIT:8  Description: Starting absolute VFID for each PF
#define DORQ_REG_VF_NORM_VF_BASE_SIZE                                                                                      1
#define DORQ_REG_DPM_MAX_CID_COUNT                                                                                         0x1701b8UL //ACCESS:RW  DataWidth:0x12  SPLIT:8  Description: Maximum number of PF CID values allowed for DPM mode
#define DORQ_REG_DPM_MAX_CID_COUNT_SIZE                                                                                    1
#define DORQ_REG_NORM_MAX_CID_COUNT                                                                                        0x1701bcUL //ACCESS:RW  DataWidth:0x12  SPLIT:8  Description: Maximum number of PF CID values allowed for normal mode
#define DORQ_REG_NORM_MAX_CID_COUNT_SIZE                                                                                   1
#define DORQ_REG_PF_USAGE_CNT                                                                                              0x1701d0UL //ACCESS:R  DataWidth:0xc  SPLIT:8  Description: Per-PF usage count.
#define DORQ_REG_PF_USAGE_CNT_SIZE                                                                                         1
#define DORQ_REG_VF_NORM_MAX_CID_COUNT                                                                                     0x1701e4UL //ACCESS:RW  DataWidth:0x12  SPLIT:8  Description: Maximum number of VF CID values allowed
#define DORQ_REG_VF_NORM_MAX_CID_COUNT_SIZE                                                                                1
#define DORQ_REG_MAX_RVFID_SIZE                                                                                            0x1701ecUL //ACCESS:RW  DataWidth:0x3  SPLIT:8  Description: Bit width of largest relative VFID.
#define DORQ_REG_MAX_RVFID_SIZE_SIZE                                                                                       1
#define DORQ_REG_VF_NORM_CID_OFST                                                                                          0x1701f4UL //ACCESS:RW  DataWidth:0x5  SPLIT:8  Description: The normal mode CID extraction offset for VF doorbells.
#define DORQ_REG_VF_NORM_CID_OFST_SIZE                                                                                     1
#define DORQ_REG_AUTO_DISCARD_REL                                                                                          0x170200UL //ACCESS:W  DataWidth:0x1  Description: Release the discard mode. Write only.
#define DORQ_REG_AUTO_DISCARD_REL_SIZE                                                                                     1
#define DORQ_REG_AUTO_FREEZE_REL                                                                                           0x170204UL //ACCESS:W  DataWidth:0x1  Description: Release the freeze mode set by auto freeze. Write only.
#define DORQ_REG_AUTO_FREEZE_REL_SIZE                                                                                      1
#define DORQ_REG_DB_DATA0                                                                                                  0x170208UL //ACCESS:RW  DataWidth:0x20  Description: Doorbell data for RBC doorbells (function 0).
#define DORQ_REG_DB_DATA0_SIZE                                                                                             1
#define DORQ_REG_DB_DATA1                                                                                                  0x17020cUL //ACCESS:RW  DataWidth:0x20  Description: Doorbell data for RBC doorbells (function 1).
#define DORQ_REG_DB_DATA1_SIZE                                                                                             1
#define DORQ_REG_DQ_FIFO_FULL_CLR                                                                                          0x170210UL //ACCESS:W  DataWidth:0x1  Description: Clears the full interrupt. Functionally write only. The read access is allowed with don't care data.
#define DORQ_REG_DQ_FIFO_FULL_CLR_SIZE                                                                                     1
#define DORQ_REG_DQ_FILL_LVL_MAX                                                                                           0x170214UL //ACCESS:RW  DataWidth:0xd  Description: Sticky value of the maximal DQ FIFO fill level. The range is 0 - 2560 FIFO rows; where each row stands for the doorbell.
#define DORQ_REG_DQ_FILL_LVL_MAX_SIZE                                                                                      1
#define DORQ_REG_VF_USAGE_CNT                                                                                              0x170320UL //ACCESS:R  DataWidth:0x7  SPLIT:64  Description: Per-VF usage count
#define DORQ_REG_VF_USAGE_CNT_SIZE                                                                                         1
#define DORQ_REG_PF_DISCARD_STATUS                                                                                         0x170324UL //ACCESS:R  DataWidth:0x1  SPLIT:8  Description: Per-PF register indicating that a doorbell has been dropped for this PF.  Cleared when corresponding pf_discard_rel register is written.
#define DORQ_REG_PF_DISCARD_STATUS_SIZE                                                                                    1
#define DORQ_REG_PF_DISCARD_REL                                                                                            0x170328UL //ACCESS:W  DataWidth:0x1  SPLIT:8  Description: When this register is written the corresponding pf_discard_status register is cleared.
#define DORQ_REG_PF_DISCARD_REL_SIZE                                                                                       1
#define DORQ_REG_VF_DISCARD_STATUS                                                                                         0x170330UL //ACCESS:R  DataWidth:0x1  SPLIT:64  Description: Per-VF register indicating that a doorbell has been dropped for this VF.  Cleared when corresponding vf_discard_rel register is written.
#define DORQ_REG_VF_DISCARD_STATUS_SIZE                                                                                    1
#define DORQ_REG_VF_DISCARD_REL                                                                                            0x170334UL //ACCESS:W  DataWidth:0x1  SPLIT:64  Description: When this register is written the corresponding vf_discard_status register is cleared.
#define DORQ_REG_VF_DISCARD_REL_SIZE                                                                                       1
#define DORQ_REG_VF_USAGE_CT_LIMIT                                                                                         0x170340UL //ACCESS:RW  DataWidth:0x7  SPLIT:8  Description: Per-PF VF usage count limit
#define DORQ_REG_VF_USAGE_CT_LIMIT_SIZE                                                                                    1
#define DORQ_REG_FIFO_CNTR                                                                                                 0x170348UL //ACCESS:RW  DataWidth:0x20  Description: Counts all doorbells that enter the FIFO.
#define DORQ_REG_FIFO_CNTR_SIZE                                                                                            2
#define DORQ_REG_DQ_FIFO                                                                                                   0x178000UL //ACCESS:R  DataWidth:0x20  Description: Read access to DQ FIFO. The address will be composed of row number; standing for a specific doorbell - 12 Lsbits and 1 Msbit; which will be 1 to read the wait for done and CID  indication and 0 - for all the other indications.
#define DORQ_REG_DQ_FIFO_SIZE                                                                                              5120
#define DORQ_REG_AGG_CMD0                                                                                                  0x170060UL //ACCESS:R  DataWidth:0x8  Description: Aggregation command.
#define DORQ_REG_AGG_CMD0_SIZE                                                                                             1
#define DORQ_REG_AGG_CMD1                                                                                                  0x170064UL //ACCESS:R  DataWidth:0x8  Description: Aggregation command.
#define DORQ_REG_AGG_CMD1_SIZE                                                                                             1
#define DORQ_REG_AGG_CMD2                                                                                                  0x170068UL //ACCESS:R  DataWidth:0x8  Description: Aggregation command.
#define DORQ_REG_AGG_CMD2_SIZE                                                                                             1
#define DORQ_REG_AGG_CMD3                                                                                                  0x17006cUL //ACCESS:R  DataWidth:0x8  Description: Aggregation command.
#define DORQ_REG_AGG_CMD3_SIZE                                                                                             1
#define DORQ_REG_DORQ_UNUSED_EMPTY_0                                                                                       0x1701c0UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DORQ_REG_DORQ_UNUSED_EMPTY_0_SIZE                                                                                  1
#define DORQ_REG_DORQ_UNUSED_EMPTY_1                                                                                       0x1701c8UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DORQ_REG_DORQ_UNUSED_EMPTY_1_SIZE                                                                                  1
#define DORQ_REG_DORQ_UNUSED_EMPTY_2                                                                                       0x1701f0UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DORQ_REG_DORQ_UNUSED_EMPTY_2_SIZE                                                                                  1
#define DORQ_REG_DORQ_UNUSED_EMPTY_3                                                                                       0x1701f8UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DORQ_REG_DORQ_UNUSED_EMPTY_3_SIZE                                                                                  2
#define DORQ_REG_DORQ_UNUSED_EMPTY_4                                                                                       0x170350UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DORQ_REG_DORQ_UNUSED_EMPTY_4_SIZE                                                                                  44
#define DORQ_REG_DORQ_UNUSED_EMPTY_5                                                                                       0x170500UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define DORQ_REG_DORQ_UNUSED_EMPTY_5_SIZE                                                                                  7872
#define HC_REG_CONFIG_0                                                                                                    0x108000UL //ACCESS:RW  DataWidth:0xd  SPLIT:4  Multi Field Register		
	#define HC_CONFIG_0_REG_BLOCK_DISABLE_0                                                                                (0x1<<0)
	#define HC_CONFIG_0_REG_BLOCK_DISABLE_0_SIZE                                                                           0		
	#define HC_CONFIG_0_REG_SINGLE_ISR_EN_0                                                                                (0x1<<1)
	#define HC_CONFIG_0_REG_SINGLE_ISR_EN_0_SIZE                                                                           1		
	#define HC_CONFIG_0_REG_MSI_MSIX_INT_EN_0                                                                              (0x1<<2)
	#define HC_CONFIG_0_REG_MSI_MSIX_INT_EN_0_SIZE                                                                         2		
	#define HC_CONFIG_0_REG_INT_LINE_EN_0                                                                                  (0x1<<3)
	#define HC_CONFIG_0_REG_INT_LINE_EN_0_SIZE                                                                             3		
	#define HC_CONFIG_0_REG_ATTN_BIT_EN_0                                                                                  (0x1<<4)
	#define HC_CONFIG_0_REG_ATTN_BIT_EN_0_SIZE                                                                             4		
	#define HC_CONFIG_0_REG_NOT_DURING_INT_EN_0                                                                            (0x1<<5)
	#define HC_CONFIG_0_REG_NOT_DURING_INT_EN_0_SIZE                                                                       5		
	#define HC_CONFIG_0_REG_COALESCE_NOW_EN_0                                                                              (0x1<<6)
	#define HC_CONFIG_0_REG_COALESCE_NOW_EN_0_SIZE                                                                         6		
	#define HC_CONFIG_0_REG_MSI_ATTN_EN_0                                                                                  (0x1<<7)
	#define HC_CONFIG_0_REG_MSI_ATTN_EN_0_SIZE                                                                             7		
	#define HC_CONFIG_0_REG_MSIX_ATTN_EN_0                                                                                 (0x1<<8)
	#define HC_CONFIG_0_REG_MSIX_ATTN_EN_0_SIZE                                                                            8		
	#define HC_CONFIG_0_REG_MAILBOX_COUNTER_0                                                                              (0x3<<9)
	#define HC_CONFIG_0_REG_MAILBOX_COUNTER_0_SIZE                                                                         9		
	#define HC_CONFIG_0_REG_STATISTIC_COUNTER_EN_0                                                                         (0x1<<11)
	#define HC_CONFIG_0_REG_STATISTIC_COUNTER_EN_0_SIZE                                                                    11		
	#define HC_CONFIG_0_REG_MSI_MSIX_MEMORY_EN_0                                                                           (0x1<<12)
	#define HC_CONFIG_0_REG_MSI_MSIX_MEMORY_EN_0_SIZE                                                                      12
#define HC_REG_CONFIG_1                                                                                                    0x108004UL //ACCESS:RW  DataWidth:0xd  SPLIT:4  Multi Field Register		
	#define HC_CONFIG_1_REG_BLOCK_DISABLE_1                                                                                (0x1<<0)
	#define HC_CONFIG_1_REG_BLOCK_DISABLE_1_SIZE                                                                           0		
	#define HC_CONFIG_1_REG_SINGLE_ISR_EN_1                                                                                (0x1<<1)
	#define HC_CONFIG_1_REG_SINGLE_ISR_EN_1_SIZE                                                                           1		
	#define HC_CONFIG_1_REG_MSI_MSIX_INT_EN_1                                                                              (0x1<<2)
	#define HC_CONFIG_1_REG_MSI_MSIX_INT_EN_1_SIZE                                                                         2		
	#define HC_CONFIG_1_REG_INT_LINE_EN_1                                                                                  (0x1<<3)
	#define HC_CONFIG_1_REG_INT_LINE_EN_1_SIZE                                                                             3		
	#define HC_CONFIG_1_REG_ATTN_BIT_EN_1                                                                                  (0x1<<4)
	#define HC_CONFIG_1_REG_ATTN_BIT_EN_1_SIZE                                                                             4		
	#define HC_CONFIG_1_REG_NOT_DURING_INT_EN_1                                                                            (0x1<<5)
	#define HC_CONFIG_1_REG_NOT_DURING_INT_EN_1_SIZE                                                                       5		
	#define HC_CONFIG_1_REG_COALESCE_NOW_EN_1                                                                              (0x1<<6)
	#define HC_CONFIG_1_REG_COALESCE_NOW_EN_1_SIZE                                                                         6		
	#define HC_CONFIG_1_REG_MSI_ATTN_EN_1                                                                                  (0x1<<7)
	#define HC_CONFIG_1_REG_MSI_ATTN_EN_1_SIZE                                                                             7		
	#define HC_CONFIG_1_REG_MSIX_ATTN_EN_1                                                                                 (0x1<<8)
	#define HC_CONFIG_1_REG_MSIX_ATTN_EN_1_SIZE                                                                            8		
	#define HC_CONFIG_1_REG_MAILBOX_COUNTER_1                                                                              (0x3<<9)
	#define HC_CONFIG_1_REG_MAILBOX_COUNTER_1_SIZE                                                                         9		
	#define HC_CONFIG_1_REG_STATISTIC_COUNTER_EN_1                                                                         (0x1<<11)
	#define HC_CONFIG_1_REG_STATISTIC_COUNTER_EN_1_SIZE                                                                    11		
	#define HC_CONFIG_1_REG_MSI_MSIX_MEMORY_EN_1                                                                           (0x1<<12)
	#define HC_CONFIG_1_REG_MSI_MSIX_MEMORY_EN_1_SIZE                                                                      12
#define HC_REG_VQID_0                                                                                                      0x108008UL //ACCESS:RW  DataWidth:0xa  SPLIT:4  Multi Field Register		
	#define HC_VQID_0_REG_VQID_MSI_MSIX_0                                                                                  (0x1f<<0)
	#define HC_VQID_0_REG_VQID_MSI_MSIX_0_SIZE                                                                             0		
	#define HC_VQID_0_REG_VQID_ATTN_MSG_0                                                                                  (0x1f<<5)
	#define HC_VQID_0_REG_VQID_ATTN_MSG_0_SIZE                                                                             5
#define HC_REG_VQID_1                                                                                                      0x10800cUL //ACCESS:RW  DataWidth:0xa  SPLIT:4  Multi Field Register		
	#define HC_VQID_1_REG_VQID_MSI_MSIX_1                                                                                  (0x1f<<0)
	#define HC_VQID_1_REG_VQID_MSI_MSIX_1_SIZE                                                                             0		
	#define HC_VQID_1_REG_VQID_ATTN_MSG_1                                                                                  (0x1f<<5)
	#define HC_VQID_1_REG_VQID_ATTN_MSG_1_SIZE                                                                             5
#define HC_REG_PCI_CONFIG_0                                                                                                0x108010UL //ACCESS:RW  DataWidth:0x4  SPLIT:4  Multi Field Register		
	#define HC_PCI_CONFIG_0_REG_MSI_RELAX_0                                                                                (0x1<<0)
	#define HC_PCI_CONFIG_0_REG_MSI_RELAX_0_SIZE                                                                           0		
	#define HC_PCI_CONFIG_0_REG_MSI_NO_SNOOP_0                                                                             (0x1<<1)
	#define HC_PCI_CONFIG_0_REG_MSI_NO_SNOOP_0_SIZE                                                                        1		
	#define HC_PCI_CONFIG_0_REG_ATTN_RELAX_0                                                                               (0x1<<2)
	#define HC_PCI_CONFIG_0_REG_ATTN_RELAX_0_SIZE                                                                          2		
	#define HC_PCI_CONFIG_0_REG_ATTN_NO_SNOOP_0                                                                            (0x1<<3)
	#define HC_PCI_CONFIG_0_REG_ATTN_NO_SNOOP_0_SIZE                                                                       3
#define HC_REG_PCI_CONFIG_1                                                                                                0x108014UL //ACCESS:RW  DataWidth:0x4  SPLIT:4  Multi Field Register		
	#define HC_PCI_CONFIG_1_REG_MSI_RELAX_1                                                                                (0x1<<0)
	#define HC_PCI_CONFIG_1_REG_MSI_RELAX_1_SIZE                                                                           0		
	#define HC_PCI_CONFIG_1_REG_MSI_NO_SNOOP_1                                                                             (0x1<<1)
	#define HC_PCI_CONFIG_1_REG_MSI_NO_SNOOP_1_SIZE                                                                        1		
	#define HC_PCI_CONFIG_1_REG_ATTN_RELAX_1                                                                               (0x1<<2)
	#define HC_PCI_CONFIG_1_REG_ATTN_RELAX_1_SIZE                                                                          2		
	#define HC_PCI_CONFIG_1_REG_ATTN_NO_SNOOP_1                                                                            (0x1<<3)
	#define HC_PCI_CONFIG_1_REG_ATTN_NO_SNOOP_1_SIZE                                                                       3
#define HC_REG_ATTN_MSG0_ADDR_L                                                                                            0x108018UL //ACCESS:RW  DataWidth:0x20  SPLIT:4  Description: port 0 lower 32 bits address field for attn messag.
#define HC_REG_ATTN_MSG0_ADDR_H                                                                                            0x10801cUL //ACCESS:RW  DataWidth:0x20  SPLIT:4  Description: port 0 higher 32 bits address field for attn messag.
#define HC_REG_ATTN_MSG1_ADDR_L                                                                                            0x108020UL //ACCESS:RW  DataWidth:0x20  SPLIT:4  Description: port 1 lower 32 bits address field for attn messag.
#define HC_REG_ATTN_MSG1_ADDR_H                                                                                            0x108024UL //ACCESS:RW  DataWidth:0x20  SPLIT:4  Description: port 1 higher 32 bits address field for attn messag.
#define HC_REG_UC_RAM_ADDR_0                                                                                               0x108028UL //ACCESS:RW  DataWidth:0x20  SPLIT:4  Multi Field Register		
	#define HC_UC_RAM_ADDR_0_REG_USTORM_0_ADDR                                                                             (0xffff<<0)
	#define HC_UC_RAM_ADDR_0_REG_USTORM_0_ADDR_SIZE                                                                        0		
	#define HC_UC_RAM_ADDR_0_REG_CSTORM_0_ADDR                                                                             (0xffff<<16)
	#define HC_UC_RAM_ADDR_0_REG_CSTORM_0_ADDR_SIZE                                                                        16
#define HC_REG_XT_RAM_ADDR_0                                                                                               0x10802cUL //ACCESS:RW  DataWidth:0x20  SPLIT:4  Multi Field Register		
	#define HC_XT_RAM_ADDR_0_REG_XSTORM_0_ADDR                                                                             (0xffff<<0)
	#define HC_XT_RAM_ADDR_0_REG_XSTORM_0_ADDR_SIZE                                                                        0		
	#define HC_XT_RAM_ADDR_0_REG_TSTORM_0_ADDR                                                                             (0xffff<<16)
	#define HC_XT_RAM_ADDR_0_REG_TSTORM_0_ADDR_SIZE                                                                        16
#define HC_REG_UC_RAM_ADDR_1                                                                                               0x108030UL //ACCESS:RW  DataWidth:0x20  SPLIT:4  Multi Field Register		
	#define HC_UC_RAM_ADDR_1_REG_USTORM_1_ADDR                                                                             (0xffff<<0)
	#define HC_UC_RAM_ADDR_1_REG_USTORM_1_ADDR_SIZE                                                                        0		
	#define HC_UC_RAM_ADDR_1_REG_CSTORM_1_ADDR                                                                             (0xffff<<16)
	#define HC_UC_RAM_ADDR_1_REG_CSTORM_1_ADDR_SIZE                                                                        16
#define HC_REG_XT_RAM_ADDR_1                                                                                               0x108034UL //ACCESS:RW  DataWidth:0x20  SPLIT:4  Multi Field Register		
	#define HC_XT_RAM_ADDR_1_REG_XSTORM_1_ADDR                                                                             (0xffff<<0)
	#define HC_XT_RAM_ADDR_1_REG_XSTORM_1_ADDR_SIZE                                                                        0		
	#define HC_XT_RAM_ADDR_1_REG_TSTORM_1_ADDR                                                                             (0xffff<<16)
	#define HC_XT_RAM_ADDR_1_REG_TSTORM_1_ADDR_SIZE                                                                        16
#define HC_REG_ATTN_NUM_P0                                                                                                 0x108038UL //ACCESS:RW  DataWidth:0x8  SPLIT:4  Description: status block number for attn bit msg - function 0;
#define HC_REG_ATTN_NUM_P1                                                                                                 0x10803cUL //ACCESS:RW  DataWidth:0x8  SPLIT:4  Description: status block number for attn bit msg - function 1
#define HC_REG_LEADING_EDGE_0                                                                                              0x108040UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: port 0 attn bit condition monitoring; each bit that is set will lock a change fron 0 to 1 in the corresponding attention signals that comes from the AEU
#define HC_REG_TRAILING_EDGE_0                                                                                             0x108044UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: port 0 attn bit condition monitoring; each bit that is set will lock a change fron 1 to 0 in the corresponding attention signals that comes from the AEU
#define HC_REG_LEADING_EDGE_1                                                                                              0x108048UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: port 1 attn bit condition monitoring; each bit that is set will lock a change fron 0 to 1 in the corresponding attention signals that comes from the AEU
#define HC_REG_TRAILING_EDGE_1                                                                                             0x10804cUL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: port 1 attn bit condition monitoring; each bit that is set will lock a change fron 1 to 0 in the corresponding attention signals that comes from the AEU
#define HC_REG_AGG_INT_0                                                                                                   0x108050UL //ACCESS:RW  DataWidth:0xa  SPLIT:4  Multi Field Register		
	#define HC_AGG_INT_0_REG_AGG_INT_COALESCE_NOW_0                                                                        (0x1f<<0)
	#define HC_AGG_INT_0_REG_AGG_INT_COALESCE_NOW_0_SIZE                                                                   0		
	#define HC_AGG_INT_0_REG_AGG_INT_CONSUMER_UPD_0                                                                        (0x1f<<5)
	#define HC_AGG_INT_0_REG_AGG_INT_CONSUMER_UPD_0_SIZE                                                                   5
#define HC_REG_AGG_INT_1                                                                                                   0x108054UL //ACCESS:RW  DataWidth:0xa  SPLIT:4  Multi Field Register		
	#define HC_AGG_INT_1_REG_AGG_INT_COALESCE_NOW_1                                                                        (0x1f<<0)
	#define HC_AGG_INT_1_REG_AGG_INT_COALESCE_NOW_1_SIZE                                                                   0		
	#define HC_AGG_INT_1_REG_AGG_INT_CONSUMER_UPD_1                                                                        (0x1f<<5)
	#define HC_AGG_INT_1_REG_AGG_INT_CONSUMER_UPD_1_SIZE                                                                   5
#define HC_REG_INTERRUPT_A                                                                                                 0x108058UL //ACCESS:R  DataWidth:0x1  SPLIT:4  Description: read the interrupt b line value; 0 = asserted; 1= deasserted
#define HC_REG_INTERRUPT_B                                                                                                 0x10805cUL //ACCESS:R  DataWidth:0x1  SPLIT:4  Description: read the interrupt a line value; 0 = asserted; 1= deasserted
#define HC_REG_STATISTIC_DIVIDER                                                                                           0x108060UL //ACCESS:RW  DataWidth:0x14  SPLIT:4  Description: Define the time statistic counter timer resolution (period rate of HW and SW intack counters update); minimuv value = 2500
#define HC_REG_COUNERTS_MEM_TM                                                                                             0x108064UL //ACCESS:RW  DataWidth:0x4  SPLIT:4  Description: tm bits for statistic counters memory
#define HC_REG_USTORM_ADDR_FOR_COALESCE                                                                                    0x108068UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: UNUSED
#define HC_REG_CSTORM_ADDR_FOR_COALESCE                                                                                    0x10806cUL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: UNUSED
#define HC_REG_XSTORM_ADDR_FOR_COALESCE                                                                                    0x108070UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: UNUSED
#define HC_REG_TSTORM_ADDR_FOR_COALESCE                                                                                    0x108074UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: UNUSED
#define HC_REG_DBG_SELECT                                                                                                  0x108078UL //ACCESS:RW  DataWidth:0x8  SPLIT:4  Description: Debug only: For dbgmux usage (debug data that goes from HC to the DBG block) - for selecting a line to output to the DBG block.
#define HC_REG_DBG_BYTE_ENABLE                                                                                             0x10807cUL //ACCESS:RW  DataWidth:0x8  SPLIT:4  Description: Debug only: For dbgmux usage (debug data that goes from HC to the DBG block) - for enabling bytes in the selected line (after the select before the shift).
#define HC_REG_DBG_SHIFT                                                                                                   0x108080UL //ACCESS:RW  DataWidth:0x3  SPLIT:4  Description: Debug only: For dbgmux usage (debug data that goes from HC to the DBG block) - for circular right shifting of the selected line (after the enabling).
#define HC_REG_HC_INT_STS                                                                                                  0x108084UL //ACCESS:R  DataWidth:0x7  Description: Interrupt register #0 read		
	#define HC_HC_INT_STS_REG_ADDRESS_ERROR                                                                                (0x1<<0)
	#define HC_HC_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                           0		
	#define HC_HC_INT_STS_REG_FIFO_ERROR                                                                                   (0x1<<1)
	#define HC_HC_INT_STS_REG_FIFO_ERROR_SIZE                                                                              1		
	#define HC_HC_INT_STS_REG_MME_IS_BIGGER_THEN_5                                                                         (0x1<<2)
	#define HC_HC_INT_STS_REG_MME_IS_BIGGER_THEN_5_SIZE                                                                    2		
	#define HC_HC_INT_STS_REG_TMP_STORM_ID_NOT_MATCH                                                                       (0x1<<3)
	#define HC_HC_INT_STS_REG_TMP_STORM_ID_NOT_MATCH_SIZE                                                                  3		
	#define HC_HC_INT_STS_REG_MAIN_MEMORY                                                                                  (0x1<<4)
	#define HC_HC_INT_STS_REG_MAIN_MEMORY_SIZE                                                                             4		
	#define HC_HC_INT_STS_REG_STATISTIC_COUNTER_MEMORY                                                                     (0x1<<5)
	#define HC_HC_INT_STS_REG_STATISTIC_COUNTER_MEMORY_SIZE                                                                5		
	#define HC_HC_INT_STS_REG_CONS_OR_PROD_IDX_TOO_BIG                                                                     (0x1<<6)
	#define HC_HC_INT_STS_REG_CONS_OR_PROD_IDX_TOO_BIG_SIZE                                                                6
#define HC_REG_HC_INT_STS_CLR                                                                                              0x108088UL //ACCESS:RC  DataWidth:0x7  Description: Interrupt register #0 read clear		
	#define HC_HC_INT_STS_CLR_REG_ADDRESS_ERROR                                                                            (0x1<<0)
	#define HC_HC_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                       0		
	#define HC_HC_INT_STS_CLR_REG_FIFO_ERROR                                                                               (0x1<<1)
	#define HC_HC_INT_STS_CLR_REG_FIFO_ERROR_SIZE                                                                          1		
	#define HC_HC_INT_STS_CLR_REG_MME_IS_BIGGER_THEN_5                                                                     (0x1<<2)
	#define HC_HC_INT_STS_CLR_REG_MME_IS_BIGGER_THEN_5_SIZE                                                                2		
	#define HC_HC_INT_STS_CLR_REG_TMP_STORM_ID_NOT_MATCH                                                                   (0x1<<3)
	#define HC_HC_INT_STS_CLR_REG_TMP_STORM_ID_NOT_MATCH_SIZE                                                              3		
	#define HC_HC_INT_STS_CLR_REG_MAIN_MEMORY                                                                              (0x1<<4)
	#define HC_HC_INT_STS_CLR_REG_MAIN_MEMORY_SIZE                                                                         4		
	#define HC_HC_INT_STS_CLR_REG_STATISTIC_COUNTER_MEMORY                                                                 (0x1<<5)
	#define HC_HC_INT_STS_CLR_REG_STATISTIC_COUNTER_MEMORY_SIZE                                                            5		
	#define HC_HC_INT_STS_CLR_REG_CONS_OR_PROD_IDX_TOO_BIG                                                                 (0x1<<6)
	#define HC_HC_INT_STS_CLR_REG_CONS_OR_PROD_IDX_TOO_BIG_SIZE                                                            6
#define HC_REG_HC_INT_STS_WR                                                                                               0x10808cUL //ACCESS:WR  DataWidth:0x7  Description: Interrupt register #0 bit set or clear		
	#define HC_HC_INT_STS_WR_REG_ADDRESS_ERROR                                                                             (0x1<<0)
	#define HC_HC_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                        0		
	#define HC_HC_INT_STS_WR_REG_FIFO_ERROR                                                                                (0x1<<1)
	#define HC_HC_INT_STS_WR_REG_FIFO_ERROR_SIZE                                                                           1		
	#define HC_HC_INT_STS_WR_REG_MME_IS_BIGGER_THEN_5                                                                      (0x1<<2)
	#define HC_HC_INT_STS_WR_REG_MME_IS_BIGGER_THEN_5_SIZE                                                                 2		
	#define HC_HC_INT_STS_WR_REG_TMP_STORM_ID_NOT_MATCH                                                                    (0x1<<3)
	#define HC_HC_INT_STS_WR_REG_TMP_STORM_ID_NOT_MATCH_SIZE                                                               3		
	#define HC_HC_INT_STS_WR_REG_MAIN_MEMORY                                                                               (0x1<<4)
	#define HC_HC_INT_STS_WR_REG_MAIN_MEMORY_SIZE                                                                          4		
	#define HC_HC_INT_STS_WR_REG_STATISTIC_COUNTER_MEMORY                                                                  (0x1<<5)
	#define HC_HC_INT_STS_WR_REG_STATISTIC_COUNTER_MEMORY_SIZE                                                             5		
	#define HC_HC_INT_STS_WR_REG_CONS_OR_PROD_IDX_TOO_BIG                                                                  (0x1<<6)
	#define HC_HC_INT_STS_WR_REG_CONS_OR_PROD_IDX_TOO_BIG_SIZE                                                             6
#define HC_REG_HC_INT_MASK                                                                                                 0x108090UL //ACCESS:RW  DataWidth:0x7  Description: Interrupt mask register #0 read/write		
	#define HC_HC_INT_MASK_REG_ADDRESS_ERROR                                                                               (0x1<<0)
	#define HC_HC_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                          0		
	#define HC_HC_INT_MASK_REG_FIFO_ERROR                                                                                  (0x1<<1)
	#define HC_HC_INT_MASK_REG_FIFO_ERROR_SIZE                                                                             1		
	#define HC_HC_INT_MASK_REG_MME_IS_BIGGER_THEN_5                                                                        (0x1<<2)
	#define HC_HC_INT_MASK_REG_MME_IS_BIGGER_THEN_5_SIZE                                                                   2		
	#define HC_HC_INT_MASK_REG_TMP_STORM_ID_NOT_MATCH                                                                      (0x1<<3)
	#define HC_HC_INT_MASK_REG_TMP_STORM_ID_NOT_MATCH_SIZE                                                                 3		
	#define HC_HC_INT_MASK_REG_MAIN_MEMORY                                                                                 (0x1<<4)
	#define HC_HC_INT_MASK_REG_MAIN_MEMORY_SIZE                                                                            4		
	#define HC_HC_INT_MASK_REG_STATISTIC_COUNTER_MEMORY                                                                    (0x1<<5)
	#define HC_HC_INT_MASK_REG_STATISTIC_COUNTER_MEMORY_SIZE                                                               5		
	#define HC_HC_INT_MASK_REG_CONS_OR_PROD_IDX_TOO_BIG                                                                    (0x1<<6)
	#define HC_HC_INT_MASK_REG_CONS_OR_PROD_IDX_TOO_BIG_SIZE                                                               6
#define HC_REG_HC_PRTY_STS                                                                                                 0x108094UL //ACCESS:R  DataWidth:0x3  Description: Parity register #0 read		
	#define HC_HC_PRTY_STS_REG_PARITY                                                                                      (0x1<<0)
	#define HC_HC_PRTY_STS_REG_PARITY_SIZE                                                                                 0		
	#define HC_HC_PRTY_STS_REG_MAIN_MEMORY                                                                                 (0x1<<1)
	#define HC_HC_PRTY_STS_REG_MAIN_MEMORY_SIZE                                                                            1		
	#define HC_HC_PRTY_STS_REG_COUNTERS_MEMORY                                                                             (0x1<<2)
	#define HC_HC_PRTY_STS_REG_COUNTERS_MEMORY_SIZE                                                                        2
#define HC_REG_HC_PRTY_STS_CLR                                                                                             0x108098UL //ACCESS:RC  DataWidth:0x3  Description: Parity register #0 read clear		
	#define HC_HC_PRTY_STS_CLR_REG_PARITY                                                                                  (0x1<<0)
	#define HC_HC_PRTY_STS_CLR_REG_PARITY_SIZE                                                                             0		
	#define HC_HC_PRTY_STS_CLR_REG_MAIN_MEMORY                                                                             (0x1<<1)
	#define HC_HC_PRTY_STS_CLR_REG_MAIN_MEMORY_SIZE                                                                        1		
	#define HC_HC_PRTY_STS_CLR_REG_COUNTERS_MEMORY                                                                         (0x1<<2)
	#define HC_HC_PRTY_STS_CLR_REG_COUNTERS_MEMORY_SIZE                                                                    2
#define HC_REG_HC_PRTY_STS_WR                                                                                              0x10809cUL //ACCESS:WR  DataWidth:0x3  Description: Parity register #0 bit set or clear		
	#define HC_HC_PRTY_STS_WR_REG_PARITY                                                                                   (0x1<<0)
	#define HC_HC_PRTY_STS_WR_REG_PARITY_SIZE                                                                              0		
	#define HC_HC_PRTY_STS_WR_REG_MAIN_MEMORY                                                                              (0x1<<1)
	#define HC_HC_PRTY_STS_WR_REG_MAIN_MEMORY_SIZE                                                                         1		
	#define HC_HC_PRTY_STS_WR_REG_COUNTERS_MEMORY                                                                          (0x1<<2)
	#define HC_HC_PRTY_STS_WR_REG_COUNTERS_MEMORY_SIZE                                                                     2
#define HC_REG_HC_PRTY_MASK                                                                                                0x1080a0UL //ACCESS:RW  DataWidth:0x3  Description: Parity mask register #0 read/write		
	#define HC_HC_PRTY_MASK_REG_PARITY                                                                                     (0x1<<0)
	#define HC_HC_PRTY_MASK_REG_PARITY_SIZE                                                                                0		
	#define HC_HC_PRTY_MASK_REG_MAIN_MEMORY                                                                                (0x1<<1)
	#define HC_HC_PRTY_MASK_REG_MAIN_MEMORY_SIZE                                                                           1		
	#define HC_HC_PRTY_MASK_REG_COUNTERS_MEMORY                                                                            (0x1<<2)
	#define HC_HC_PRTY_MASK_REG_COUNTERS_MEMORY_SIZE                                                                       2
#define HC_REG_FUNC_NUM_P0                                                                                                 0x1080acUL //ACCESS:RW  DataWidth:0x3  SPLIT:4  Description: function number for MSI MSIX & Attn message
#define HC_REG_FUNC_NUM_P1                                                                                                 0x1080b0UL //ACCESS:RW  DataWidth:0x3  SPLIT:4  Description: function number for MSI MSIX & Attn message
#define HC_REG_AEU_MSI_ATTN_P0                                                                                             0x1080b4UL //ACCESS:R  DataWidth:0x4  Description: read hc_misc_aeu_msi_msix_attn_p0 of all the cores. [0] HC_0; [1] HC_1; [2] HC_2; [3] HC_3
#define HC_REG_AEU_MSI_ATTN_P0_SIZE                                                                                        1
#define HC_REG_AEU_MSI_ATTN_P1                                                                                             0x1080b8UL //ACCESS:R  DataWidth:0x4  Description: read hc_misc_aeu_msi_msix_attn_p1 of all the cores. [0] HC_0; [1] HC_1; [2] HC_2; [3] HC_4
#define HC_REG_AEU_MSI_ATTN_P1_SIZE                                                                                        1
#define HC_REG_PXP_REQUESTER_CREDIT                                                                                        0x1080bcUL //ACCESS:RW  DataWidth:0x2  Description: the credit for the PXP requester interface. This register is common for all the HC cores. Only 0ne and two are valid values.
#define HC_REG_PXP_REQUESTER_CREDIT_SIZE                                                                                   1
#define HC_REG_ATTN_IDX                                                                                                    0x108100UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: attn bits status index for attn bit msg; addr 0 - function 0; addr 1 - functin 1
#define HC_REG_ATTN_IDX_SIZE                                                                                               2
#define HC_REG_INT_MASK                                                                                                    0x108108UL //ACCESS:RW  DataWidth:0x11  SPLIT:4  Description: status block interrupt mask; one in each bit means unmask; zerow in each bit means mask; bit 0 - default SB; bit 1 - SB_0; bit 2 - SB_1 to bit 16- SB_15; addr 0 - port 0; addr 1 - port 1
#define HC_REG_INT_MASK_SIZE                                                                                               2
#define HC_REG_PBA_BIT                                                                                                     0x108110UL //ACCESS:RW  DataWidth:0x11  SPLIT:4  Description: PBA 17 bits adress 0 - port0; address 1 - port 1; bit0 = default SB; bit1 = SB_0; bit2 = SB_1 . . . bit16 = SB_15; Each bit in the vector is updated according with scan procedure for MSI/MSI-X message build and posting according to the following rules: If the pending is set AND For the relevant port MSI-X is enabled AND Block is not disabled (per port indication) AND No full indication from the PCI command transmission interface logic AND (relevant MSI-X function mask bit is set OR relevant MSI-X vector mask bit is set) Then the analogous PBA bit is set; The bit is cleared upon posting an MSI-X message for the analogous pending bit.
#define HC_REG_PBA_BIT_SIZE                                                                                                2
#define HC_REG_ATTN_BIT                                                                                                    0x108120UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: attention bit and attention acknowledge bits status for port 0 and 1 according to the following address map: addr 0 - attn_bit_0; addr 1 - attn_ack_bit_0; addr 2 - attn_bit_1; addr 3 - attn_ack_bit_1;
#define HC_REG_ATTN_BIT_SIZE                                                                                               4
#define HC_REG_DEC_CEILING                                                                                                 0x108130UL //ACCESS:W  DataWidth:0x1  SPLIT:4  Description: This command register infuence the MSI configuration state machine. This register is write only and has 4 addresses as follow: 0 = dec port 0; 1 = ceiling port 0; 2 = dec port 1; 3 = ceiling port 1;
#define HC_REG_DEC_CEILING_SIZE                                                                                            4
#define HC_REG_PBA_COMMAND                                                                                                 0x108140UL //ACCESS:W  DataWidth:0x1  SPLIT:4  Description: This register is write only and has 4 addresses as follow: 0 = clear all PBA bits port 0; 1 = clear all pending interrupts request port0; 2 = clear all PBA bits port 1; 3 = clear all pending interrupts request port1;there is no meaning for the data in this register
#define HC_REG_PBA_COMMAND_SIZE                                                                                            4
#define HC_REG_COMMAND_REG                                                                                                 0x108180UL //ACCESS:RW  DataWidth:0x1b  SPLIT:4  Description: This command register has 16 addresses. Write to these registers active command according to the address. For port 0 the address mapped as follow: 0-interrupt acknowledge ; 1-producer update ; 2-attntion bits update; 3-attntion bits set; 4-attntion bits clear; 5-coalesce now; 6-single_isr_multi_dpc with mask; 7-single isr without mask; For port 1 the address mapped as follow: 8-interrupt acknowledge ; 9-producer update ; 10-attntion bits update; 11-attntion bits set; 12-attntion bits clear; 13-coalesce now; 14-single_isr_multi_dpc with mask; 15-single isr without mask; Read from addresses 0-5 and 8-13 is ignored; Write to addresses 6-7 and 14-15 is ignored; the data bits are mapped as follow: tmp_dis_enable_cmd = data[26:25]; tmp_upd_index_cmd = data[24]; tmp_cmd_storm_index = data[23:21] // according to storm table; tmp_cmd_status_id = data[20:16] // according to status block idx table; tmp_index_val = data[15:0]; tmp_function = according to MSB address. if address match interrupt acknowledge {If (tmp_upd_index_cmd == 1) Update consumer index of (tmp_cmd_storm_index; tmp_cmd_status_id) for function(tmp_function) to be tmp_index_val; Check relevant comparator output; If (comparator output is clr (i.e. Prod==Cons) AND tmp_cmd_storm_index &lt; 4 (STORM update) ) set a request for the following command toward the tmp_cmd_storm_index: aggregate_int (according to tmp_function value will be taken from ~agg_int_consumer_upd_0 or agg_int_consumer_upd_1); address (according to tmp_cmd_status_id and tmp_function ~ustorm_0_addr; ~cstorm_0_addr; ~xstorm_0_addr; ~tstorm_0_addr; ~ustorm_1_addr; ~cstorm_1_addr; ~xstorm_1_addr; ~tstorm_1_addr); STORM index (according to tmp_cmd_storm_index); data = consumer index;  If (tmp_dis_enable_cmd == 0) Set bit for SB (tmp_cmd_status_id) for function(tmp_function) Else if (tmp_dis_enable_cmd == 1) Clr bit for SB(tmp_cmd_status_id) for function (tmp_function)} else if address matches producer update { If (tmp_upd_index_cmd == 1) Update producer index of (tmp_cmd_storm_index; tmp_cmd_status_id) for function(tmp_function) to be tmp_index_val; If (tmp_dis_enable_cmd == 0) Set mask bit for SB(tmp_cmd_status_id) for function(tmp_function) Else if (tmp_dis_enable_cmd == 1) Clr mask bit for SB(tmp_cmd_status_id) for function(tmp_function)} else if command address matches attn bit upd register {Attn_bit_ack_reg(tmp_function) = data[15:0]} else if command address matches attn bit set register {attn_bit_ack_reg(tmp_function) |= data[15:0]} else if command address matches attn bit clr register {attn_bit_ack_reg(tmp_function) &= data[31:0]} else if command address matches coalesce now { set a request for the following command toward the tmp_cmd_storm_index: aggregate_int (according to tmp_function value will be taken from ~agg_int_coalesce_now_0 or agg_int_coalesce_now_1); address (according to ~ustorm_addr_for_coalesce; ~cstorm_addr_for_coalesce; ~xstorm_addr_for_coalesce; ~tstorm_addr_for_coalesce); STORM index 4 commands are sent (a command per STORM); data = 0; byte enable = all set} else if command address matches single_isr_multi_dpc with mask register { according to tmp_function ret_value = interrupt vector after mask[16:0]; mask tmp_function interrupt register according to rev_value (every one in ret_value masks relevant interrupt)} else if command address matches single_isr_multi_dpc without mask register {according to tmp_function ret_value = interrupt vector after mask[16:0]}.
#define HC_REG_COMMAND_REG_SIZE                                                                                            16
#define HC_REG_P0_PROD_CONS                                                                                                0x108200UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: all producer and consumer of port 0 according to the following addresses; U_prod: 0-15; C_prod: 16-31; U_cons: 32-47; C_cons:48-63; Defoult_prod: U/C/X/T/Attn-64/65/66/67/68; Defoult_cons: U/C/X/T/Attn-69/70/71/72/73
#define HC_REG_P0_PROD_CONS_SIZE                                                                                           74
#define HC_REG_P1_PROD_CONS                                                                                                0x108400UL //ACCESS:RW  DataWidth:0x10  SPLIT:4  Description: all producer and consumer of port 1according to the following addresses;  U_prod: 0-15; C_prod: 16-31; U_cons: 32-47; C_cons:48-63; Defoult_prod: U/C/X/T/Attn-64/65/66/67/68; Defoult_cons: U/C/X/T/Attn-69/70/71/72/73
#define HC_REG_P1_PROD_CONS_SIZE                                                                                           74
#define HC_REG_MAIN_MEMORY                                                                                                 0x108800UL //ACCESS:WB  DataWidth:0x40  SPLIT:4  Description: The MSI and MSIX memory; each address has 64 bits of data; the address map is as follows; Port 0: addr 0-33 - MSIX_vector (acording to the following distribution: 0 - default SB MSIX addr; 1 - default SB msix data and mask (mask[32];data[31:0]); 2 - SB_0 MSIX addr; 3 - SB_0 msix data and mask (mask[32];data[31:0]); 4 - SB_1 MSIX addr; 5 - SB_1 msix data and mask (mask[32];data[31:0]);... 32 - SB_16 MSIX addr; 33 - SB_16 msix data and mask (mask[32];data[31:0])); addr 34 - MSI_msg_ctrl; addr 35 - MSI_addr_low; addr 36 - MSI_addr_high ; addr 37 - [63:32] - MSI_mask_bit [31:0] - MSI_data. Port 1: addr 38-71 - MSIX_vector (acording to the following distribution: 38 - default SB MSIX addr; 39 - default SB msix data and mask (mask[32];data[31:0]); 40 - SB_0 MSIX addr; 41 - SB_0 msix data and mask (mask[32];data[31:0]); 42 - SB_1 MSIX addr; 43 - SB_1 msix data and mask (mask[32];data[31:0]);... 70 - SB_16 MSIX addr; 71 - SB_16 msix data and mask (mask[32];data[31:0])); addr 72 - MSI_msg_ctrl; addr 73 - MSI_addr_low; addr 74 - MSI_addr_high ; addr 75 - [63:32] - MSI_mask_bit [31:0] - MSI_data.
#define HC_REG_MAIN_MEMORY_SIZE                                                                                            152
#define HC_REG_STATISTIC_COUNTERS                                                                                          0x109000UL //ACCESS:RW  DataWidth:0x18  SPLIT:4  Description: all counters acording to the following address: LSB: 0=read; 1= read_clear; 0-71 = HW counters (the inside order is the same as the interrupt table in the spec); 72-219 = SW counters 1 (stops after first consumer upd) the inside order  is: 72-103 - U_non_default_p0; 104-135 C_non_defaul_p0;136-145 U/C/X/T/Attn_default_p0; 146-177 U_non_default_p1; 178-209 C_non_defaul_p1;210-219 U/C/X/T/Attn_default_p1 ; 220-367 = SW counters 2 (stops when prod=cons) the inside order is: 220-251 - U_non_default_p0; 252-283 C_non_defaul_p0;284-293 U/C/X/T/Attn_default_p0; 294-325 U_non_default_p1; 326-357 C_non_defaul_p1;358-367 U/C/X/T/Attn_default_p1 ; 368-515 = mailbox counters; (the inside order of the mailbox counter is 368-431 U and C non_default_p0; 432-441 U/C//X/T/Attn_default_p0; 442-505 U and C non_default_p1; 506-515 U/C//X/T/Attn_default_p1)
#define HC_REG_STATISTIC_COUNTERS_SIZE                                                                                     516
#define HC_REG_HC_UNUSED_EMPTY_0                                                                                           0x1080a4UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define HC_REG_HC_UNUSED_EMPTY_0_SIZE                                                                                      2
#define HC_REG_HC_UNUSED_EMPTY_1                                                                                           0x1080c0UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define HC_REG_HC_UNUSED_EMPTY_1_SIZE                                                                                      16
#define HC_REG_HC_UNUSED_EMPTY_2                                                                                           0x108118UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define HC_REG_HC_UNUSED_EMPTY_2_SIZE                                                                                      2
#define HC_REG_HC_UNUSED_EMPTY_3                                                                                           0x108150UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define HC_REG_HC_UNUSED_EMPTY_3_SIZE                                                                                      12
#define HC_REG_HC_UNUSED_EMPTY_4                                                                                           0x1081c0UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define HC_REG_HC_UNUSED_EMPTY_4_SIZE                                                                                      16
#define HC_REG_HC_UNUSED_EMPTY_5                                                                                           0x108600UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define HC_REG_HC_UNUSED_EMPTY_5_SIZE                                                                                      128
#define HC_REG_HC_UNUSED_EMPTY_6                                                                                           0x108c00UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define HC_REG_HC_UNUSED_EMPTY_6_SIZE                                                                                      256
#define HC_REG_HC_UNUSED_EMPTY_7                                                                                           0x10a000UL //ACCESS:R  DataWidth:0x20  Unused empty space
#define HC_REG_HC_UNUSED_EMPTY_7_SIZE                                                                                      2048
#define IGU_REG_BLOCK_CONFIGURATION                                                                                        0x130000UL //ACCESS:RW  DataWidth:0x5  Multi Field Register		
	#define IGU_BLOCK_CONFIGURATION_REG_BLOCK_ENABLE                                                                       (0x1<<0)
	#define IGU_BLOCK_CONFIGURATION_REG_BLOCK_ENABLE_SIZE                                                                  0		
	#define IGU_BLOCK_CONFIGURATION_REG_BACKWARD_COMP_EN                                                                   (0x1<<1)
	#define IGU_BLOCK_CONFIGURATION_REG_BACKWARD_COMP_EN_SIZE                                                              1		
	#define IGU_BLOCK_CONFIGURATION_REG_BUS_DWORD_SELECT                                                                   (0x1<<2)
	#define IGU_BLOCK_CONFIGURATION_REG_BUS_DWORD_SELECT_SIZE                                                              2		
	#define IGU_BLOCK_CONFIGURATION_REG_PORT4MODE_EN                                                                       (0x1<<3)
	#define IGU_BLOCK_CONFIGURATION_REG_PORT4MODE_EN_SIZE                                                                  3		
	#define IGU_BLOCK_CONFIGURATION_REG_TIMER_MASK_EN                                                                      (0x1<<4)
	#define IGU_BLOCK_CONFIGURATION_REG_TIMER_MASK_EN_SIZE                                                                 4
#define IGU_REG_MESSAGE_FIELDS                                                                                             0x130004UL //ACCESS:RW  DataWidth:0x1a  Multi Field Register		
	#define IGU_MESSAGE_FIELDS_REG_MSI_MSIX_VQID                                                                           (0x1f<<0)
	#define IGU_MESSAGE_FIELDS_REG_MSI_MSIX_VQID_SIZE                                                                      0		
	#define IGU_MESSAGE_FIELDS_REG_MSI_MSIX_ATC                                                                            (0x7<<5)
	#define IGU_MESSAGE_FIELDS_REG_MSI_MSIX_ATC_SIZE                                                                       5		
	#define IGU_MESSAGE_FIELDS_REG_MSI_MSIX_RO                                                                             (0x1<<8)
	#define IGU_MESSAGE_FIELDS_REG_MSI_MSIX_RO_SIZE                                                                        8		
	#define IGU_MESSAGE_FIELDS_REG_MSI_MSIX_NS                                                                             (0x1<<9)
	#define IGU_MESSAGE_FIELDS_REG_MSI_MSIX_NS_SIZE                                                                        9		
	#define IGU_MESSAGE_FIELDS_REG_MSIX_WRITE_DONE_TYPE                                                                    (0x1<<10)
	#define IGU_MESSAGE_FIELDS_REG_MSIX_WRITE_DONE_TYPE_SIZE                                                               10		
	#define IGU_MESSAGE_FIELDS_REG_MESSAGE_FIELDS_RESEVED                                                                  (0xf<<11)
	#define IGU_MESSAGE_FIELDS_REG_MESSAGE_FIELDS_RESEVED_SIZE                                                             11		
	#define IGU_MESSAGE_FIELDS_REG_ATTN_VQID                                                                               (0x1f<<15)
	#define IGU_MESSAGE_FIELDS_REG_ATTN_VQID_SIZE                                                                          15		
	#define IGU_MESSAGE_FIELDS_REG_ATTN_ATC                                                                                (0x7<<20)
	#define IGU_MESSAGE_FIELDS_REG_ATTN_ATC_SIZE                                                                           20		
	#define IGU_MESSAGE_FIELDS_REG_ATTN_RO                                                                                 (0x1<<23)
	#define IGU_MESSAGE_FIELDS_REG_ATTN_RO_SIZE                                                                            23		
	#define IGU_MESSAGE_FIELDS_REG_ATTN_NS                                                                                 (0x1<<24)
	#define IGU_MESSAGE_FIELDS_REG_ATTN_NS_SIZE                                                                            24		
	#define IGU_MESSAGE_FIELDS_REG_ATTN_WRITE_DONE_TYPE                                                                    (0x1<<25)
	#define IGU_MESSAGE_FIELDS_REG_ATTN_WRITE_DONE_TYPE_SIZE                                                               25
#define IGU_REG_FUNC_WITH_MORE_16_SB_0                                                                                     0x130008UL //ACCESS:RW  DataWidth:0x9  Description: The first function numbers that has more then 16 SBs. [6:0] - function number (if VF - [6] = 0; [5:0] = VFID if PF - [6] = 1; [5:3] = 0; [2:0] = PFID); . [7] reserved. [8]  - valid bit. In backward compatible mode - not used. The reset value match 2ports mode operation. in 4ports mode it should be reconfigured.
#define IGU_REG_FUNC_WITH_MORE_16_SB_1                                                                                     0x13000cUL //ACCESS:RW  DataWidth:0x9  Description: The second function numbers that has more then 16 SBs. [6:0] - function number (if VF - [6] = 0; [5:0] = VFID if PF - [6] = 1; [5:3] = 0; [2:0] = PFID); . [7] reserved. [8]  - valid bit. In backward compatible mode - not used. The reset value match 2ports mode operation. in 4ports mode it should be reconfigured.
#define IGU_REG_FUNC_WITH_MORE_16_SB_2                                                                                     0x130010UL //ACCESS:RW  DataWidth:0x9  Description: The third function numbers that has more then 16 SBs. [6:0] - function number (if VF - [6] = 0; [5:0] = VFID if PF - [6] = 1; [5:3] = 0; [2:0] = PFID); . [7] reserved. [8]  - valid bit. In backward compatible mode - not used. The reset value match 2ports mode operation. in 4ports mode it should be reconfigured.
#define IGU_REG_FUNC_WITH_MORE_16_SB_3                                                                                     0x130014UL //ACCESS:RW  DataWidth:0x9  Description: The forth function numbers that has more then 16 SBs. [6:0] - function number (if VF - [6] = 0; [5:0] = VFID if PF - [6] = 1; [5:3] = 0; [2:0] = PFID); . [7] reserved. [8]  - valid bit. In backward compatible mode - not used. The reset value match 2ports mode operation. in 4ports mode it should be reconfigured.
#define IGU_REG_FUNC_WITH_MORE_16_SB_4                                                                                     0x130018UL //ACCESS:RW  DataWidth:0x9  Description: The fifth function numbers that has more then 16 SBs. [6:0] - function number (if VF - [6] = 0; [5:0] = VFID if PF - [6] = 1; [5:3] = 0; [2:0] = PFID); . [7] reserved. [8]  - valid bit. In backward compatible mode - not used. The reset value match 2ports mode operation. in 4ports mode it should be reconfigured.
#define IGU_REG_FUNC_WITH_MORE_16_SB_5                                                                                     0x13001cUL //ACCESS:RW  DataWidth:0x9  Description: The sixth function numbers that has more then 16 SBs. [6:0] - function number (if VF - [6] = 0; [5:0] = VFID if PF - [6] = 1; [5:3] = 0; [2:0] = PFID); . [7] reserved. [8]  - valid bit. In backward compatible mode - not used. The reset value match 2ports mode operation. in 4ports mode it should be reconfigured.
#define IGU_REG_FUNC_WITH_MORE_16_SB_6                                                                                     0x130020UL //ACCESS:RW  DataWidth:0x9  Description: The seventh function numbers that has more then 16 SBs. [6:0] - function number (if VF - [6] = 0; [5:0] = VFID if PF - [6] = 1; [5:3] = 0; [2:0] = PFID); . [7] reserved. [8]  - valid bit. In backward compatible mode - not used. The reset value match 2ports mode operation. in 4ports mode it should be reconfigured.
#define IGU_REG_FUNC_WITH_MORE_16_SB_7                                                                                     0x130024UL //ACCESS:RW  DataWidth:0x9  Description: The eight function numbers that has more then 16 SBs. [6:0] - function number (if VF - [6] = 0; [5:0] = VFID if PF - [6] = 1; [5:3] = 0; [2:0] = PFID); . [7] reserved. [8]  - valid bit. In backward compatible mode - not used. The reset value match 2ports mode operation. in 4ports mode it should be reconfigured.
#define IGU_REG_PXP_REQUESTER_INITIAL_CREDIT                                                                               0x130028UL //ACCESS:RW  DataWidth:0x2  Description: PXP req credit. The max number of outstanding messages to the PXP request. The value can be one or two only.
#define IGU_REG_ATTN_MSG_PENDING                                                                                           0x13002cUL //ACCESS:R  DataWidth:0x8  Description: Debug: messages that wait to be sent; but didnt were sent yet. One bit for each PFID.
#define IGU_REG_ATTN_WRITE_DONE_PENDING                                                                                    0x130030UL //ACCESS:R  DataWidth:0x4  Description: Debug: [3] - attention write done message is pending (0-no pending; 1-pending). [2:0] = PFID. Pending means attention message was sent; but write done didnt receive.
#define IGU_REG_COMMAND_DEBUG                                                                                              0x130034UL //ACCESS:RW  DataWidth:0x1  Description: Debug only: 0 - FIFO collects eight first error messages; 1 - FIFO collects eight last incoming command.
#define IGU_REG_STATISTIC_EN                                                                                               0x130038UL //ACCESS:RW  DataWidth:0x1  Description: enabling to collect data in the statistic_num_message_sent memory.
#define IGU_REG_TIMER_MASKING_VALUE                                                                                        0x13003cUL //ACCESS:RW  DataWidth:0x20  Description: Number of cycles the timer mask masking the IGU interrupt when a timer mask command arrives. Value must be bigger than 100.
#define IGU_REG_TIMER_MASK_ACTIVE                                                                                          0x130040UL //ACCESS:R  DataWidth:0x1  Description: when set the timer mask is active and the IGU does not send interrupts. When clear the timer mask is inactive.
#define IGU_REG_ERROR_HANDLING_FILTER                                                                                      0x130044UL //ACCESS:RW  DataWidth:0x9  Multi Field Register		
	#define IGU_ERROR_HANDLING_FILTER_REG_ERROR_HANDLING_FILTER_FID                                                        (0x7f<<0)
	#define IGU_ERROR_HANDLING_FILTER_REG_ERROR_HANDLING_FILTER_FID_SIZE                                                   0		
	#define IGU_ERROR_HANDLING_FILTER_REG_ERROR_HANDLING_RESERVED                                                          (0x1<<7)
	#define IGU_ERROR_HANDLING_FILTER_REG_ERROR_HANDLING_RESERVED_SIZE                                                     7		
	#define IGU_ERROR_HANDLING_FILTER_REG_ERROR_HANDLING_FILTER_EN                                                         (0x1<<8)
	#define IGU_ERROR_HANDLING_FILTER_REG_ERROR_HANDLING_FILTER_EN_SIZE                                                    8
#define IGU_REG_MAPPING_FSM                                                                                                0x130048UL //ACCESS:R  DataWidth:0x4  Description: Debug: mapping_fsm
#define IGU_REG_SB_CTRL_FSM                                                                                                0x13004cUL //ACCESS:R  DataWidth:0x4  Description: Debug: sb_ctrl_fsm
#define IGU_REG_INT_HANDLE_FSM                                                                                             0x130050UL //ACCESS:R  DataWidth:0x4  Description: Debug: int_handle_fsm
#define IGU_REG_ATTN_FSM                                                                                                   0x130054UL //ACCESS:R  DataWidth:0x4  Description: Debug: attn_fsm
#define IGU_REG_PBA_FSM                                                                                                    0x130058UL //ACCESS:R  DataWidth:0x4  Description: Debug: pba_fsm
#define IGU_REG_MSIX_MSG_BUILDER_FSM                                                                                       0x13005cUL //ACCESS:R  DataWidth:0x5  Description: Debug: msix_msg_builder_fsm
#define IGU_REG_MSIX_MEM_FSM                                                                                               0x130060UL //ACCESS:R  DataWidth:0x3  Description: Debug: msix_mem_fsm
#define IGU_REG_CTRL_FSM                                                                                                   0x130064UL //ACCESS:R  DataWidth:0x5  Description: Debug: ctrl_fsm
#define IGU_REG_PXP_ARB_FSM                                                                                                0x130068UL //ACCESS:R  DataWidth:0x3  Description: Debug: pxp_arb_fsm
#define IGU_REG_DBG_SELECT                                                                                                 0x13006cUL //ACCESS:RW  DataWidth:0x8  Description: Debug only: For dbgmux usage (debug data that goes from HC to the DBG block) - for selecting a line to output to the DBG block.
#define IGU_REG_DBG_BYTE_ENABLE                                                                                            0x130070UL //ACCESS:RW  DataWidth:0x8  Description: Debug only: For dbgmux usage (debug data that goes from HC to the DBG block) - for enabling bytes in the selected line (after the select before the shift).
#define IGU_REG_DBG_SHIFT                                                                                                  0x130074UL //ACCESS:RW  DataWidth:0x3  Description: Debug only: For dbgmux usage (debug data that goes from HC to the DBG block) - for circular right shifting of the selected line (after the enabling).
#define IGU_REG_TM                                                                                                         0x130078UL //ACCESS:RW  DataWidth:0x18  Multi Field Register		
	#define IGU_TM_REG_CAM_TM                                                                                              (0x3fff<<0)
	#define IGU_TM_REG_CAM_TM_SIZE                                                                                         0		
	#define IGU_TM_REG_SB_MEM_TM                                                                                           (0x1f<<14)
	#define IGU_TM_REG_SB_MEM_TM_SIZE                                                                                      14		
	#define IGU_TM_REG_MSIX_MEM_TM                                                                                         (0x1f<<19)
	#define IGU_TM_REG_MSIX_MEM_TM_SIZE                                                                                    19
#define IGU_REG_CAM_BIST_BDG_DATA                                                                                          0x13007cUL //ACCESS:RW  DataWidth:0x8  Description: Debug: for CAM bist uses
#define IGU_REG_CAM_BIST_STATUS                                                                                            0x130080UL //ACCESS:R  DataWidth:0x20  Description: Debug: for CAM bist uses
#define IGU_REG_CAM_BIST_EN                                                                                                0x130084UL //ACCESS:RW  DataWidth:0x1  Description: Debug: for CAM bist uses
#define IGU_REG_ECO_RESERVED                                                                                               0x130088UL //ACCESS:RW  DataWidth:0x8  Description: reserved for ECO if needed
#define IGU_REG_IGU_INT_STS                                                                                                0x13008cUL //ACCESS:R  DataWidth:0xb  Description: Interrupt register #0 read		
	#define IGU_IGU_INT_STS_REG_ADDRESS_ERROR                                                                              (0x1<<0)
	#define IGU_IGU_INT_STS_REG_ADDRESS_ERROR_SIZE                                                                         0		
	#define IGU_IGU_INT_STS_REG_CTRL_FIFO_ERROR_ERR                                                                        (0x1<<1)
	#define IGU_IGU_INT_STS_REG_CTRL_FIFO_ERROR_ERR_SIZE                                                                   1		
	#define IGU_IGU_INT_STS_REG_PXP_REQ_LENGTH_TOO_BIG                                                                     (0x1<<2)
	#define IGU_IGU_INT_STS_REG_PXP_REQ_LENGTH_TOO_BIG_SIZE                                                                2		
	#define IGU_IGU_INT_STS_REG_HOST_TRIES2ACCESS_PROD_UPD                                                                 (0x1<<3)
	#define IGU_IGU_INT_STS_REG_HOST_TRIES2ACCESS_PROD_UPD_SIZE                                                            3		
	#define IGU_IGU_INT_STS_REG_VF_TRIES2ACC_ATTN_CMD                                                                      (0x1<<4)
	#define IGU_IGU_INT_STS_REG_VF_TRIES2ACC_ATTN_CMD_SIZE                                                                 4		
	#define IGU_IGU_INT_STS_REG_MME_BIGGER_THEN_5                                                                          (0x1<<5)
	#define IGU_IGU_INT_STS_REG_MME_BIGGER_THEN_5_SIZE                                                                     5		
	#define IGU_IGU_INT_STS_REG_SB_INDEX_IS_NOT_VALID                                                                      (0x1<<6)
	#define IGU_IGU_INT_STS_REG_SB_INDEX_IS_NOT_VALID_SIZE                                                                 6		
	#define IGU_IGU_INT_STS_REG_DURIN_INT_READ_WITH_SIMD_DIS                                                               (0x1<<7)
	#define IGU_IGU_INT_STS_REG_DURIN_INT_READ_WITH_SIMD_DIS_SIZE                                                          7		
	#define IGU_IGU_INT_STS_REG_CMD_FID_NOT_MATCH                                                                          (0x1<<8)
	#define IGU_IGU_INT_STS_REG_CMD_FID_NOT_MATCH_SIZE                                                                     8		
	#define IGU_IGU_INT_STS_REG_SEGMENT_ACCESS_INVALID                                                                     (0x1<<9)
	#define IGU_IGU_INT_STS_REG_SEGMENT_ACCESS_INVALID_SIZE                                                                9		
	#define IGU_IGU_INT_STS_REG_ATTN_PROD_ACC                                                                              (0x1<<10)
	#define IGU_IGU_INT_STS_REG_ATTN_PROD_ACC_SIZE                                                                         10
#define IGU_REG_IGU_INT_STS_CLR                                                                                            0x130090UL //ACCESS:RC  DataWidth:0xb  Description: Interrupt register #0 read clear		
	#define IGU_IGU_INT_STS_CLR_REG_ADDRESS_ERROR                                                                          (0x1<<0)
	#define IGU_IGU_INT_STS_CLR_REG_ADDRESS_ERROR_SIZE                                                                     0		
	#define IGU_IGU_INT_STS_CLR_REG_CTRL_FIFO_ERROR_ERR                                                                    (0x1<<1)
	#define IGU_IGU_INT_STS_CLR_REG_CTRL_FIFO_ERROR_ERR_SIZE                                                               1		
	#define IGU_IGU_INT_STS_CLR_REG_PXP_REQ_LENGTH_TOO_BIG                                                                 (0x1<<2)
	#define IGU_IGU_INT_STS_CLR_REG_PXP_REQ_LENGTH_TOO_BIG_SIZE                                                            2		
	#define IGU_IGU_INT_STS_CLR_REG_HOST_TRIES2ACCESS_PROD_UPD                                                             (0x1<<3)
	#define IGU_IGU_INT_STS_CLR_REG_HOST_TRIES2ACCESS_PROD_UPD_SIZE                                                        3		
	#define IGU_IGU_INT_STS_CLR_REG_VF_TRIES2ACC_ATTN_CMD                                                                  (0x1<<4)
	#define IGU_IGU_INT_STS_CLR_REG_VF_TRIES2ACC_ATTN_CMD_SIZE                                                             4		
	#define IGU_IGU_INT_STS_CLR_REG_MME_BIGGER_THEN_5                                                                      (0x1<<5)
	#define IGU_IGU_INT_STS_CLR_REG_MME_BIGGER_THEN_5_SIZE                                                                 5		
	#define IGU_IGU_INT_STS_CLR_REG_SB_INDEX_IS_NOT_VALID                                                                  (0x1<<6)
	#define IGU_IGU_INT_STS_CLR_REG_SB_INDEX_IS_NOT_VALID_SIZE                                                             6		
	#define IGU_IGU_INT_STS_CLR_REG_DURIN_INT_READ_WITH_SIMD_DIS                                                           (0x1<<7)
	#define IGU_IGU_INT_STS_CLR_REG_DURIN_INT_READ_WITH_SIMD_DIS_SIZE                                                      7		
	#define IGU_IGU_INT_STS_CLR_REG_CMD_FID_NOT_MATCH                                                                      (0x1<<8)
	#define IGU_IGU_INT_STS_CLR_REG_CMD_FID_NOT_MATCH_SIZE                                                                 8		
	#define IGU_IGU_INT_STS_CLR_REG_SEGMENT_ACCESS_INVALID                                                                 (0x1<<9)
	#define IGU_IGU_INT_STS_CLR_REG_SEGMENT_ACCESS_INVALID_SIZE                                                            9		
	#define IGU_IGU_INT_STS_CLR_REG_ATTN_PROD_ACC                                                                          (0x1<<10)
	#define IGU_IGU_INT_STS_CLR_REG_ATTN_PROD_ACC_SIZE                                                                     10
#define IGU_REG_IGU_INT_STS_WR                                                                                             0x130094UL //ACCESS:WR  DataWidth:0xb  Description: Interrupt register #0 bit set or clear		
	#define IGU_IGU_INT_STS_WR_REG_ADDRESS_ERROR                                                                           (0x1<<0)
	#define IGU_IGU_INT_STS_WR_REG_ADDRESS_ERROR_SIZE                                                                      0		
	#define IGU_IGU_INT_STS_WR_REG_CTRL_FIFO_ERROR_ERR                                                                     (0x1<<1)
	#define IGU_IGU_INT_STS_WR_REG_CTRL_FIFO_ERROR_ERR_SIZE                                                                1		
	#define IGU_IGU_INT_STS_WR_REG_PXP_REQ_LENGTH_TOO_BIG                                                                  (0x1<<2)
	#define IGU_IGU_INT_STS_WR_REG_PXP_REQ_LENGTH_TOO_BIG_SIZE                                                             2		
	#define IGU_IGU_INT_STS_WR_REG_HOST_TRIES2ACCESS_PROD_UPD                                                              (0x1<<3)
	#define IGU_IGU_INT_STS_WR_REG_HOST_TRIES2ACCESS_PROD_UPD_SIZE                                                         3		
	#define IGU_IGU_INT_STS_WR_REG_VF_TRIES2ACC_ATTN_CMD                                                                   (0x1<<4)
	#define IGU_IGU_INT_STS_WR_REG_VF_TRIES2ACC_ATTN_CMD_SIZE                                                              4		
	#define IGU_IGU_INT_STS_WR_REG_MME_BIGGER_THEN_5                                                                       (0x1<<5)
	#define IGU_IGU_INT_STS_WR_REG_MME_BIGGER_THEN_5_SIZE                                                                  5		
	#define IGU_IGU_INT_STS_WR_REG_SB_INDEX_IS_NOT_VALID                                                                   (0x1<<6)
	#define IGU_IGU_INT_STS_WR_REG_SB_INDEX_IS_NOT_VALID_SIZE                                                              6		
	#define IGU_IGU_INT_STS_WR_REG_DURIN_INT_READ_WITH_SIMD_DIS                                                            (0x1<<7)
	#define IGU_IGU_INT_STS_WR_REG_DURIN_INT_READ_WITH_SIMD_DIS_SIZE                                                       7		
	#define IGU_IGU_INT_STS_WR_REG_CMD_FID_NOT_MATCH                                                                       (0x1<<8)
	#define IGU_IGU_INT_STS_WR_REG_CMD_FID_NOT_MATCH_SIZE                                                                  8		
	#define IGU_IGU_INT_STS_WR_REG_SEGMENT_ACCESS_INVALID                                                                  (0x1<<9)
	#define IGU_IGU_INT_STS_WR_REG_SEGMENT_ACCESS_INVALID_SIZE                                                             9		
	#define IGU_IGU_INT_STS_WR_REG_ATTN_PROD_ACC                                                                           (0x1<<10)
	#define IGU_IGU_INT_STS_WR_REG_ATTN_PROD_ACC_SIZE                                                                      10
#define IGU_REG_IGU_INT_MASK                                                                                               0x130098UL //ACCESS:RW  DataWidth:0xb  Description: Interrupt mask register #0 read/write		
	#define IGU_IGU_INT_MASK_REG_ADDRESS_ERROR                                                                             (0x1<<0)
	#define IGU_IGU_INT_MASK_REG_ADDRESS_ERROR_SIZE                                                                        0		
	#define IGU_IGU_INT_MASK_REG_CTRL_FIFO_ERROR_ERR                                                                       (0x1<<1)
	#define IGU_IGU_INT_MASK_REG_CTRL_FIFO_ERROR_ERR_SIZE                                                                  1		
	#define IGU_IGU_INT_MASK_REG_PXP_REQ_LENGTH_TOO_BIG                                                                    (0x1<<2)
	#define IGU_IGU_INT_MASK_REG_PXP_REQ_LENGTH_TOO_BIG_SIZE                                                               2		
	#define IGU_IGU_INT_MASK_REG_HOST_TRIES2ACCESS_PROD_UPD                                                                (0x1<<3)
	#define IGU_IGU_INT_MASK_REG_HOST_TRIES2ACCESS_PROD_UPD_SIZE                                                           3		
	#define IGU_IGU_INT_MASK_REG_VF_TRIES2ACC_ATTN_CMD                                                                     (0x1<<4)
	#define IGU_IGU_INT_MASK_REG_VF_TRIES2ACC_ATTN_CMD_SIZE                                                                4		
	#define IGU_IGU_INT_MASK_REG_MME_BIGGER_THEN_5                                                                         (0x1<<5)
	#define IGU_IGU_INT_MASK_REG_MME_BIGGER_THEN_5_SIZE                                                                    5		
	#define IGU_IGU_INT_MASK_REG_SB_INDEX_IS_NOT_VALID                                                                     (0x1<<6)
	#define IGU_IGU_INT_MASK_REG_SB_INDEX_IS_NOT_VALID_SIZE                                                                6		
	#define IGU_IGU_INT_MASK_REG_DURIN_INT_READ_WITH_SIMD_DIS                                                              (0x1<<7)
	#define IGU_IGU_INT_MASK_REG_DURIN_INT_READ_WITH_SIMD_DIS_SIZE                                                         7		
	#define IGU_IGU_INT_MASK_REG_CMD_FID_NOT_MATCH                                                                         (0x1<<8)
	#define IGU_IGU_INT_MASK_REG_CMD_FID_NOT_MATCH_SIZE                                                                    8		
	#define IGU_IGU_INT_MASK_REG_SEGMENT_ACCESS_INVALID                                                                    (0x1<<9)
	#define IGU_IGU_INT_MASK_REG_SEGMENT_ACCESS_INVALID_SIZE                                                               9		
	#define IGU_IGU_INT_MASK_REG_ATTN_PROD_ACC                                                                             (0x1<<10)
	#define IGU_IGU_INT_MASK_REG_ATTN_PROD_ACC_SIZE                                                                        10
#define IGU_REG_IGU_PRTY_STS                                                                                               0x13009cUL //ACCESS:R  DataWidth:0xb  Description: Parity register #0 read		
	#define IGU_IGU_PRTY_STS_REG_PARITY                                                                                    (0x1<<0)
	#define IGU_IGU_PRTY_STS_REG_PARITY_SIZE                                                                               0		
	#define IGU_IGU_PRTY_STS_REG_CTRL_FIFO_ERROR_PARITY                                                                    (0x1<<1)
	#define IGU_IGU_PRTY_STS_REG_CTRL_FIFO_ERROR_PARITY_SIZE                                                               1		
	#define IGU_IGU_PRTY_STS_REG_CAM_PARITY                                                                                (0x1<<2)
	#define IGU_IGU_PRTY_STS_REG_CAM_PARITY_SIZE                                                                           2		
	#define IGU_IGU_PRTY_STS_REG_SB_PARITY                                                                                 (0x1<<3)
	#define IGU_IGU_PRTY_STS_REG_SB_PARITY_SIZE                                                                            3		
	#define IGU_IGU_PRTY_STS_REG_SB_BEFORE_INT_LOW_PARITY                                                                  (0x1<<4)
	#define IGU_IGU_PRTY_STS_REG_SB_BEFORE_INT_LOW_PARITY_SIZE                                                             4		
	#define IGU_IGU_PRTY_STS_REG_MASK_LOW_PARITY                                                                           (0x1<<5)
	#define IGU_IGU_PRTY_STS_REG_MASK_LOW_PARITY_SIZE                                                                      5		
	#define IGU_IGU_PRTY_STS_REG_PBA_LOW_PARITY                                                                            (0x1<<6)
	#define IGU_IGU_PRTY_STS_REG_PBA_LOW_PARITY_SIZE                                                                       6		
	#define IGU_IGU_PRTY_STS_REG_MSIX_PARITY                                                                               (0x1<<7)
	#define IGU_IGU_PRTY_STS_REG_MSIX_PARITY_SIZE                                                                          7		
	#define IGU_IGU_PRTY_STS_REG_MSI_PARITY                                                                                (0x1<<8)
	#define IGU_IGU_PRTY_STS_REG_MSI_PARITY_SIZE                                                                           8		
	#define IGU_IGU_PRTY_STS_REG_ATTN_ADDR_PARITY                                                                          (0x1<<9)
	#define IGU_IGU_PRTY_STS_REG_ATTN_ADDR_PARITY_SIZE                                                                     9		
	#define IGU_IGU_PRTY_STS_REG_STATISTIC_PARITY                                                                          (0x1<<10)
	#define IGU_IGU_PRTY_STS_REG_STATISTIC_PARITY_SIZE                                                                     10
#define IGU_REG_IGU_PRTY_STS_CLR                                                                                           0x1300a0UL //ACCESS:RC  DataWidth:0xb  Description: Parity register #0 read clear		
	#define IGU_IGU_PRTY_STS_CLR_REG_PARITY                                                                                (0x1<<0)
	#define IGU_IGU_PRTY_STS_CLR_REG_PARITY_SIZE                                                                           0		
	#define IGU_IGU_PRTY_STS_CLR_REG_CTRL_FIFO_ERROR_PARITY                                                                (0x1<<1)
	#define IGU_IGU_PRTY_STS_CLR_REG_CTRL_FIFO_ERROR_PARITY_SIZE                                                           1		
	#define IGU_IGU_PRTY_STS_CLR_REG_CAM_PARITY                                                                            (0x1<<2)
	#define IGU_IGU_PRTY_STS_CLR_REG_CAM_PARITY_SIZE                                                                       2		
	#define IGU_IGU_PRTY_STS_CLR_REG_SB_PARITY                                                                             (0x1<<3)
	#define IGU_IGU_PRTY_STS_CLR_REG_SB_PARITY_SIZE                                                                        3		
	#define IGU_IGU_PRTY_STS_CLR_REG_SB_BEFORE_INT_LOW_PARITY                                                              (0x1<<4)
	#define IGU_IGU_PRTY_STS_CLR_REG_SB_BEFORE_INT_LOW_PARITY_SIZE                                                         4		
	#define IGU_IGU_PRTY_STS_CLR_REG_MASK_LOW_PARITY                                                                       (0x1<<5)
	#define IGU_IGU_PRTY_STS_CLR_REG_MASK_LOW_PARITY_SIZE                                                                  5		
	#define IGU_IGU_PRTY_STS_CLR_REG_PBA_LOW_PARITY                                                                        (0x1<<6)
	#define IGU_IGU_PRTY_STS_CLR_REG_PBA_LOW_PARITY_SIZE                                                                   6		
	#define IGU_IGU_PRTY_STS_CLR_REG_MSIX_PARITY                                                                           (0x1<<7)
	#define IGU_IGU_PRTY_STS_CLR_REG_MSIX_PARITY_SIZE                                                                      7		
	#define IGU_IGU_PRTY_STS_CLR_REG_MSI_PARITY                                                                            (0x1<<8)
	#define IGU_IGU_PRTY_STS_CLR_REG_MSI_PARITY_SIZE                                                                       8		
	#define IGU_IGU_PRTY_STS_CLR_REG_ATTN_ADDR_PARITY                                                                      (0x1<<9)
	#define IGU_IGU_PRTY_STS_CLR_REG_ATTN_ADDR_PARITY_SIZE                                                                 9		
	#define IGU_IGU_PRTY_STS_CLR_REG_STATISTIC_PARITY                                                                      (0x1<<10)
	#define IGU_IGU_PRTY_STS_CLR_REG_STATISTIC_PARITY_SIZE                                                                 10
#define IGU_REG_IGU_PRTY_STS_WR                                                                                            0x1300a4UL //ACCESS:WR  DataWidth:0xb  Description: Parity register #0 bit set or clear		
	#define IGU_IGU_PRTY_STS_WR_REG_PARITY                                                                                 (0x1<<0)
	#define IGU_IGU_PRTY_STS_WR_REG_PARITY_SIZE                                                                            0		
	#define IGU_IGU_PRTY_STS_WR_REG_CTRL_FIFO_ERROR_PARITY                                                                 (0x1<<1)
	#define IGU_IGU_PRTY_STS_WR_REG_CTRL_FIFO_ERROR_PARITY_SIZE                                                            1		
	#define IGU_IGU_PRTY_STS_WR_REG_CAM_PARITY                                                                             (0x1<<2)
	#define IGU_IGU_PRTY_STS_WR_REG_CAM_PARITY_SIZE                                                                        2		
	#define IGU_IGU_PRTY_STS_WR_REG_SB_PARITY                                                                              (0x1<<3)
	#define IGU_IGU_PRTY_STS_WR_REG_SB_PARITY_SIZE                                                                         3		
	#define IGU_IGU_PRTY_STS_WR_REG_SB_BEFORE_INT_LOW_PARITY                                                               (0x1<<4)
	#define IGU_IGU_PRTY_STS_WR_REG_SB_BEFORE_INT_LOW_PARITY_SIZE                                                          4		
	#define IGU_IGU_PRTY_STS_WR_REG_MASK_LOW_PARITY                                                                        (0x1<<5)
	#define IGU_IGU_PRTY_STS_WR_REG_MASK_LOW_PARITY_SIZE                                                                   5		
	#define IGU_IGU_PRTY_STS_WR_REG_PBA_LOW_PARITY                                                                         (0x1<<6)
	#define IGU_IGU_PRTY_STS_WR_REG_PBA_LOW_PARITY_SIZE                                                                    6		
	#define IGU_IGU_PRTY_STS_WR_REG_MSIX_PARITY                                                                            (0x1<<7)
	#define IGU_IGU_PRTY_STS_WR_REG_MSIX_PARITY_SIZE                                                                       7		
	#define IGU_IGU_PRTY_STS_WR_REG_MSI_PARITY                                                                             (0x1<<8)
	#define IGU_IGU_PRTY_STS_WR_REG_MSI_PARITY_SIZE                                                                        8		
	#define IGU_IGU_PRTY_STS_WR_REG_ATTN_ADDR_PARITY                                                                       (0x1<<9)
	#define IGU_IGU_PRTY_STS_WR_REG_ATTN_ADDR_PARITY_SIZE                                                                  9		
	#define IGU_IGU_PRTY_STS_WR_REG_STATISTIC_PARITY                                                                       (0x1<<10)
	#define IGU_IGU_PRTY_STS_WR_REG_STATISTIC_PARITY_SIZE                                                                  10
#define IGU_REG_IGU_PRTY_MASK                                                                                              0x1300a8UL //ACCESS:RW  DataWidth:0xb  Description: Parity mask register #0 read/write		
	#define IGU_IGU_PRTY_MASK_REG_PARITY                                                                                   (0x1<<0)
	#define IGU_IGU_PRTY_MASK_REG_PARITY_SIZE                                                                              0		
	#define IGU_IGU_PRTY_MASK_REG_CTRL_FIFO_ERROR_PARITY                                                                   (0x1<<1)
	#define IGU_IGU_PRTY_MASK_REG_CTRL_FIFO_ERROR_PARITY_SIZE                                                              1		
	#define IGU_IGU_PRTY_MASK_REG_CAM_PARITY                                                                               (0x1<<2)
	#define IGU_IGU_PRTY_MASK_REG_CAM_PARITY_SIZE                                                                          2		
	#define IGU_IGU_PRTY_MASK_REG_SB_PARITY                                                                                (0x1<<3)
	#define IGU_IGU_PRTY_MASK_REG_SB_PARITY_SIZE                                                                           3		
	#define IGU_IGU_PRTY_MASK_REG_SB_BEFORE_INT_LOW_PARITY                                                                 (0x1<<4)
	#define IGU_IGU_PRTY_MASK_REG_SB_BEFORE_INT_LOW_PARITY_SIZE                                                            4		
	#define IGU_IGU_PRTY_MASK_REG_MASK_LOW_PARITY                                                                          (0x1<<5)
	#define IGU_IGU_PRTY_MASK_REG_MASK_LOW_PARITY_SIZE                                                                     5		
	#define IGU_IGU_PRTY_MASK_REG_PBA_LOW_PARITY                                                                           (0x1<<6)
	#define IGU_IGU_PRTY_MASK_REG_PBA_LOW_PARITY_SIZE                                                                      6		
	#define IGU_IGU_PRTY_MASK_REG_MSIX_PARITY                                                                              (0x1<<7)
	#define IGU_IGU_PRTY_MASK_REG_MSIX_PARITY_SIZE                                                                         7		
	#define IGU_IGU_PRTY_MASK_REG_MSI_PARITY                                                                               (0x1<<8)
	#define IGU_IGU_PRTY_MASK_REG_MSI_PARITY_SIZE                                                                          8		
	#define IGU_IGU_PRTY_MASK_REG_ATTN_ADDR_PARITY                                                                         (0x1<<9)
	#define IGU_IGU_PRTY_MASK_REG_ATTN_ADDR_PARITY_SIZE                                                                    9		
	#define IGU_IGU_PRTY_MASK_REG_STATISTIC_PARITY                                                                         (0x1<<10)
	#define IGU_IGU_PRTY_MASK_REG_STATISTIC_PARITY_SIZE                                                                    10
#define IGU_REG_INTERRUPT_STATUS                                                                                           0x130100UL //ACCESS:R  DataWidth:0x4  Description: Debug: Interrupt status (active high). PF0 to PF3
#define IGU_REG_INTERRUPT_STATUS_SIZE                                                                                      1
#define IGU_REG_TRAILING_EDGE_LATCH                                                                                        0x130104UL //ACCESS:RW  DataWidth:0x10  SPLIT:8  Description: Attention signals trailing edge. attn bit condition monitoring; each bit that is set will lock a change from 1 to 0 in the corresponding attention signals that comes from the AEU
#define IGU_REG_TRAILING_EDGE_LATCH_SIZE                                                                                   1
#define IGU_REG_ATTENTION_ACK_BITS                                                                                         0x130108UL //ACCESS:RW  DataWidth:0x10  SPLIT:8  Description: 16 bit register with the attention ACK values.These are the same bits as in the attention message.
#define IGU_REG_ATTENTION_ACK_BITS_SIZE                                                                                    1
#define IGU_REG_ATTENTION_BIT_STATUS_INDEX                                                                                 0x13010cUL //ACCESS:RW  DataWidth:0x10  SPLIT:8  Description: Value of attention bit status index (posted toward the driver as attention bit status index). This are the same value as in the attention message.
#define IGU_REG_ATTENTION_BIT_STATUS_INDEX_SIZE                                                                            1
#define IGU_REG_ATTENTION_BITS                                                                                             0x130110UL //ACCESS:RW  DataWidth:0x10  SPLIT:8  Description: 16 bit register with the latched attention values. These are the same bits as in the attention message.
#define IGU_REG_ATTENTION_BITS_SIZE                                                                                        1
#define IGU_REG_ATTENTION_SIGNAL_P0_STATUS                                                                                 0x130114UL //ACCESS:R  DataWidth:0x10  Description: attention signal status. Reflects the current value of the attention signals from the MISC-AEU port0
#define IGU_REG_ATTENTION_SIGNAL_P0_STATUS_SIZE                                                                            1
#define IGU_REG_ATTENTION_SIGNAL_P1_STATUS                                                                                 0x130118UL //ACCESS:R  DataWidth:0x10  Description: attention signal status. Reflects the current value of the attention signals from the MISC-AEU port1
#define IGU_REG_ATTENTION_SIGNAL_P1_STATUS_SIZE                                                                            1
#define IGU_REG_ATTN_MSG_ADDR_H                                                                                            0x13011cUL //ACCESS:RW  DataWidth:0x20  SPLIT:8  Description: For attention message: Attention bit destination address 32 MSB
#define IGU_REG_ATTN_MSG_ADDR_H_SIZE                                                                                       1
#define IGU_REG_ATTN_MSG_ADDR_L                                                                                            0x130120UL //ACCESS:RW  DataWidth:0x20  SPLIT:8  Description: For attention message: Attention bit destination address 32 LSB. Two Lsbit must be zero.
#define IGU_REG_ATTN_MSG_ADDR_L_SIZE                                                                                       1
#define IGU_REG_COMMAND_REG_32LSB_DATA                                                                                     0x130124UL //ACCESS:RW  DataWidth:0x20  SPLIT:8  Description: If block is disabled this register will return zero. If the last command sent to the command_reg_ctrl the 32LSB read value will be written here. If address is PBA: 32 LSB of PBA register (one in each bit means PBA message wasnt sent due to mask). If address = SIMD with mask 64b/32LSB: 32 LSB of the during interrupt register (one in each bit means the appropriate SB is asserted. Every bit that is set will be masked in the mask bit register). If address = SIMD with mask 32MSB: this register will return zero. If address = SIMD without mask 64b: 32 LSB of the during interrupt register (one in each bit means the appropriate SB is asserted). If the command sent to the command_reg_ctrl is write command the data in this register will be used as follows: If address = interrupt acknowledge register: d31 - d27- Reserved; d26:d25 - enable/disable interrupt for status block (0=Disable interrupt for status block; 1=Enable interrupt for status block; 2 or 3 - NOP); d24 - update/nop status index (0 = NOP; 1 - update); d23:d21 - segment access for PF only  - 0 - regular; 1 - default; 2 - ATTN; 3-7 - reserved. For VF must be zero; d20 - Reserved; d19:d0 - status block consumer index. If address = producer update: d31 - Cleanup bit command (0 - Nop; 1 - cleanup); d30 - cleanup set/clr - 0-clear 1 - set; d29:d28 - Cleanup type (0-ustorm 0; 1-ustorm1; 2-cstorm0; 3-cstorm1); d27- Reserved; d26:d25 - enable/disable interrupt for status block (0=Disable interrupt for status block; 1=Enable interrupt for status block; 2 or 3 - NOP); d24 - update/nop status index (0 = NOP; 1 - update); d23:d21 - segment access for PF only  - 0 - regular; 1 - default; 2 - ATTN; 3-7 - reserved. For VF must be zero; d20 - Reserved; d19:d0 - status block producer index. If address = attention update: d31:d16 - reserved; d15:d0 - new attention ack register value. If address = attention set: d31:d16 - reserved; Attention ack new value = attention ack old value | d15:d0. If address = attention clear: d31:d16 - reserved; Attention ack new value = attention ack old value & d15:d0.
#define IGU_REG_COMMAND_REG_32LSB_DATA_SIZE                                                                                1
#define IGU_REG_COMMAND_REG_32MSB_DATA                                                                                     0x130128UL //ACCESS:WB_R  DataWidth:0x20  SPLIT:8  Description: Read only register. If block is disable this register will return zero. If the last command sent to the command_reg_ctrl the 32MSB read value will be written here. If address is PBA: 32 MSB of PBA register (one in each bit means PBA message wasnt sent due to mask). If address = SIMD with mask 64b/32MSB: 32 MSB of the during interrupt register (one in each bit means the appropriate SB is asserted. Every bit that is set will be masked in the mask bit register). If address = SIMD with mask 32LSB: this register will return zero. If address = SIMD without mask 64b: 32 MSB of the during interrupt register (one in each bit means the appropriate SB is asserted).
#define IGU_REG_COMMAND_REG_32MSB_DATA_SIZE                                                                                1
#define IGU_REG_COMMAND_REG_CTRL                                                                                           0x13012cUL //ACCESS:W  DataWidth:0x15  SPLIT:8  Description: [11:0] - PXP BAR address; [18:12] - FID (if VF - [18] = 0; [17:12] = VF number; if PF - [18] = 1; [17:15] = 0; [14:12] = PFID); [19] - reserved; [20] command type - 0-read; 1-wr. When writing to this register the command will be executed. On write command the 32 LSB command should be written first (to the command_reg_32lsb_data register) and only then this register. PXP BAR address field: 0x000 - 0x1FF - reserved; 0x200 - PBA ; 0x201 - 0x3FF  - reserved; 0x400 - 0x487 - interrupt ack register; 0x488-0x4FF - reserved; 0x500 - 0x587 - producer update; 0x588-0x59F - reserved; 0x5A0 - Attention bits update register; 0x5A1 - Attention bits set register; 0x5A2 - Attention bits clear register; 0x5A3 -  SIMD with mask 64b; 0x5A4 -  SIMD with mask 32 LSB; 0x5A5 -  SIMD with mask 32 MSB; 0x5A6 -  SIMD without mask 64b; 0x5A7 - 0x5FF - reserved. The following addresses are write only: interrupt ack register; producer update; Attention bits update register; Attention bits set register; Attention bits clear register. The following addresses are read only: PBA; SIMD with mask 64b; SIMD with mask 32 LSB; SIMD with mask 32 MSB; SIMD without mask 64b. The read data is copied to command_reg_32lsb_data and command_reg_32msb_data registers. On read from reserved addresses the read data will be 0.
#define IGU_REG_COMMAND_REG_CTRL_SIZE                                                                                      1
#define IGU_REG_ERROR_HANDLING_DATA_VALID                                                                                  0x130130UL //ACCESS:R  DataWidth:0x1  Description: data availble for error memory. If this bit is clear do not red from error_handling_memory.
#define IGU_REG_ERROR_HANDLING_DATA_VALID_SIZE                                                                             1
#define IGU_REG_LEADING_EDGE_LATCH                                                                                         0x130134UL //ACCESS:RW  DataWidth:0x10  SPLIT:8  Description: Attention signals leading edge. attn bit condition monitoring; each bit that is set will lock a change from 0 to 1 in the corresponding attention signals that comes from the AEU
#define IGU_REG_LEADING_EDGE_LATCH_SIZE                                                                                    1
#define IGU_REG_PBA_STATUS_LSB                                                                                             0x130138UL //ACCESS:RW  DataWidth:0x20  SPLIT:72  Description: 32 lsb of PBA register. 0 - PBA clear 1 - PBA set - the appropriate MSIX message was not set due to mask bit (function or vector). The bits order is according to the vector number of each SB in that function. For PF bit 0 is the default SB. bits 31:16 are valid only for functions that appears in func_with_more_16_sb_0..7 registers.
#define IGU_REG_PBA_STATUS_LSB_SIZE                                                                                        1
#define IGU_REG_PBA_STATUS_MSB                                                                                             0x13013cUL //ACCESS:RW  DataWidth:0x20  SPLIT:72  Description: 32 msb of PBA register. 0 - PBA clear 1 - PBA set - the appropriate MSIX message was not set due to mask bit (function or vector). The bits order is according to the vector number of each SB in that function. For PF bit 0 is the default SB.This register is valid only for functions that appears in func_with_more_16_sb_0..7 registers
#define IGU_REG_PBA_STATUS_MSB_SIZE                                                                                        1
#define IGU_REG_PCI_PF_MSI_EN                                                                                              0x130140UL //ACCESS:RW  DataWidth:0x1  SPLIT:8  Description: PF MSI enable status. shadow of PCI config register
#define IGU_REG_PCI_PF_MSI_EN_SIZE                                                                                         1
#define IGU_REG_PCI_PF_MSIX_EN                                                                                             0x130144UL //ACCESS:RW  DataWidth:0x1  SPLIT:8  Description: PF MSIX enable status. shadow of PCI config register
#define IGU_REG_PCI_PF_MSIX_EN_SIZE                                                                                        1
#define IGU_REG_PCI_PF_MSIX_FUNC_MASK                                                                                      0x130148UL //ACCESS:RW  DataWidth:0x1  SPLIT:8  Description: PF MSIX function mask status. shadow of PCI config register. 0 - unmasked; 1 - masked
#define IGU_REG_PCI_PF_MSIX_FUNC_MASK_SIZE                                                                                 1
#define IGU_REG_PCI_VF_MSIX_EN                                                                                             0x13014cUL //ACCESS:RW  DataWidth:0x1  SPLIT:64  Description: VF MSIX enable status. shadow of PCI config register
#define IGU_REG_PCI_VF_MSIX_EN_SIZE                                                                                        1
#define IGU_REG_PCI_VF_MSIX_FUNC_MASK                                                                                      0x130150UL //ACCESS:RW  DataWidth:0x1  SPLIT:64  Description: VF MSIX function mask status  shadow of PCI config register. 0 - unmasked; 1 - masked
#define IGU_REG_PCI_VF_MSIX_FUNC_MASK_SIZE                                                                                 1
#define IGU_REG_PF_CONFIGURATION                                                                                           0x130154UL //ACCESS:RW  DataWidth:0x6  SPLIT:8  Description: d0 - function enable; d1 - MSI/MSIX enable; d2 - INT enable; d3 - attention enabe; d4 - single ISR mode enable; d5 simd all ones mode - If clear (reset value):If the result of SB_before_mask & ~mask is 0xFFFF_FFFF then the read result will be 0x7FFF_FFFF and the mask will be also 0x7FFF_FFFF. Therefore the interrupt is not de-asserted (the MSB SB is asserted and unmasked). And on the next read from SIMD with mask the result will be 0x8000_0000 and only now the interrupt will be de-asserted. If set: If the result of SB_before_mask & ~mask is 0xFFFF_FFFF then the read result will be 0x7FFF_FFFF but the mask will be 0xFFFF_FFFF. Therefore the interrupt is de-asserted. And on the next read from SIMD with mask the result will be 0x0.
#define IGU_REG_PF_CONFIGURATION_SIZE                                                                                      1
#define IGU_REG_RESET_MEMORIES                                                                                             0x130158UL //ACCESS:RW  DataWidth:0x6  Description: Write one for each bit will reset the appropriate memory. When the memory reset finished the appropriate bit will be clear. Bit 0 - mapping memory; Bit 1 - SB memory; Bit 2 - SB interrupt and mask register; Bit 3 - MSIX memory; Bit 4 - PBA memory; Bit 5 - statistics; 
#define IGU_REG_RESET_MEMORIES_SIZE                                                                                        1
#define IGU_REG_SB_INT_BEFORE_MASK_LSB                                                                                     0x13015cUL //ACCESS:RW  DataWidth:0x20  SPLIT:72  Description: 32 lsb of SB interrupt before mask. 0 - prod equal cons. 1 - prod not equal cons or last command for this SB was prod update. The bits order is according to the vector number of each SB in that function. For PF bit 0 is the default SB. bits 31:16 are valid only for functions that appears in func_with_more_16_sb_0..7 registers.
#define IGU_REG_SB_INT_BEFORE_MASK_LSB_SIZE                                                                                1
#define IGU_REG_SB_INT_BEFORE_MASK_MSB                                                                                     0x130160UL //ACCESS:RW  DataWidth:0x20  SPLIT:72  Description: 32 msb of SB interrupt before mask. 0 - prod equal cons. 1 - prod not equal cons or last command for this SB was prod update. The bits order is according to the vector number of each SB in that function. For PF bit 0 is the default SB. This register is valid only for functions that appears in func_with_more_16_sb_0..7 registers
#define IGU_REG_SB_INT_BEFORE_MASK_MSB_SIZE                                                         