/******************************************************************************
* The information contained in this file is confidential and proprietary to
* QLogic Corporation. No part of this file may be reproduced or
* distributed, in any form or by any means for any purpose, without the
* express written permission of QLogic Corporation.
*
*              Copyright (c) 2015 QLogic Corporation
*                        All rights reserved
*******************************************************************************/
#ifndef _QFLE3_MGMT_H_
#define _QFLE3_MGMT_H_

#include <vmkapi.h>
#include "qfle3_mgmt_api.h"

#define qfle3_DIAG_ERROR 0x10000000
typedef struct {
   VMK_ReturnStatus (*fn_ptr) (qfle3_adapter *adapter);
} qfle3_selftest_fntbl_t;
qfle3_selftest_fntbl_t *qfle3_get_selftest(qfle3_selftest_cmd_t selftest_cmd);

extern vmk_MgmtHandle vmkmgmt_api_handler;
int qfle3_read_pci_cfg(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_write_pci_cfg(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_read_reg(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_write_reg(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_get_trc_buff_info(qfle3_adapter * adapter,
                              qfle3_mgmt_data_t * data);
int qfle3_get_trc_buff(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_get_minidump_size(qfle3_adapter * adapter,
                              qfle3_mgmt_data_t * data);
int qfle3_get_minidump(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_get_dcbx_size(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_get_dcbx(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_get_modparam_info(qfle3_adapter * adapter,
                              qfle3_mgmt_data_t * data);
int qfle3_get_modparam(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_lb_test(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_diag_test(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_wol_get(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_wol_set(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_pause_get(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_pause_set(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_coalesce_get(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_coalesce_set(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_offload_get(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_offload_set(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_physical_id(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_restart_autoneg(qfle3_adapter * adapter,
                            qfle3_mgmt_data_t * data);
int qfle3_ring_get(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);
int qfle3_ring_set(qfle3_adapter * adapter, qfle3_mgmt_data_t * data);

void qfle3_kvcleanup(vmk_uint64 cookie);
VMK_ReturnStatus qfle3_init_uplink_mgmt(qfle3_adapter * adapter,
                                          vmk_Uplink uplink);

//u32 qfle3_diag_idle_chk_size(qfle3_adapter * adapter,
//                               qfle3_diag_data_t * data);
//u32 qfle3_diag_idle_chk(qfle3_adapter * adapter, qfle3_diag_data_t * data);
//u32 qfle3_diag_idle_chk_result_size(qfle3_adapter * adapter,
//                                      qfle3_diag_data_t * data);
//u32 qfle3_diag_idle_chk_result(qfle3_adapter * adapter,
//                                 qfle3_diag_data_t * data);
//u32 qfle3_diag_set_app_version(qfle3_adapter * adapter,
//                                 qfle3_diag_data_t * data);
//u32 qfle3_diag_grc_dump_size(qfle3_adapter * adapter,
//                               qfle3_diag_data_t * data);
//u32 qfle3_diag_grc_dump(qfle3_adapter * adapter, qfle3_diag_data_t * data);
//u32 qfle3_diag_fw_func_ver(qfle3_adapter * adapter,
//                             qfle3_diag_data_t * data);
//u32 qfle3_diag_bus_reset(qfle3_adapter * adapter,
//                           qfle3_diag_data_t * data);
//u32 qfle3_diag_set_pci_output(qfle3_adapter * adapter,
//                                qfle3_diag_data_t * data);
//u32 qfle3_diag_set_nw_output(qfle3_adapter * adapter,
//                               qfle3_diag_data_t * data);
//u32 qfle3_diag_enable_block(qfle3_adapter * adapter,
//                              qfle3_diag_data_t * data);
//u32 qfle3_diag_enable_storm(qfle3_adapter * adapter,
//                              qfle3_diag_data_t * data);
//u32 qfle3_diag_enable_timestamp(qfle3_adapter * adapter,
//                                  qfle3_diag_data_t * data);
//u32 qfle3_diag_add_eid_range_sem_filter(qfle3_adapter * adapter,
//                                          qfle3_diag_data_t * data);
//u32 qfle3_diag_add_eid_mask_sem_filter(qfle3_adapter * adapter,
//                                         qfle3_diag_data_t * data);
//u32 qfle3_diag_add_cid_sem_filter(qfle3_adapter * adapter,
//                                    qfle3_diag_data_t * data);
//u32 qfle3_diag_enable_filter(qfle3_adapter * adapter,
//                               qfle3_diag_data_t * data);
//u32 qfle3_diag_enable_trigger(qfle3_adapter * adapter,
//                                qfle3_diag_data_t * data);
//u32 qfle3_diag_add_trigger_state(qfle3_adapter * adapter,
//                                   qfle3_diag_data_t * data);
//u32 qfle3_diag_add_constraint(qfle3_adapter * adapter,
//                                qfle3_diag_data_t * data);
//u32 qfle3_diag_start(qfle3_adapter * adapter, qfle3_diag_data_t * data);
//u32 qfle3_diag_stop(qfle3_adapter * adapter, qfle3_diag_data_t * data);

VMK_ReturnStatus qfle3_uplink_stats_get(vmk_AddrCookie driverData, vmk_UplinkStats * stats);
VMK_ReturnStatus qfle3_pauseparamsget(vmk_AddrCookie driverData,vmk_UplinkPauseParams *params);
VMK_ReturnStatus qfle3_pauseparamsset(vmk_AddrCookie driverData, vmk_UplinkPauseParams params);
VMK_ReturnStatus qfle3_getwolstate(vmk_AddrCookie driverData,vmk_UplinkWolState *params);
VMK_ReturnStatus qfle3_setwolstate(vmk_AddrCookie driverData, vmk_UplinkWolState *params);
VMK_ReturnStatus qfle3_getcoalesceparam(vmk_AddrCookie driverData, vmk_UplinkCoalesceParams *params);
VMK_ReturnStatus qfle3_setcoalesceparam(vmk_AddrCookie driverData, vmk_UplinkCoalesceParams *params);
VMK_ReturnStatus qfle3_ringparamsget(vmk_AddrCookie driverData, vmk_UplinkRingParams *params);


#endif
