/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta;

import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.mail2.core.EmailConstants;
import org.apache.commons.mail2.core.EmailException;
import org.apache.commons.mail2.core.EmailUtils;
import org.apache.commons.mail2.jakarta.AbstractEmailTest;
import org.apache.commons.mail2.jakarta.EmailAttachment;
import org.apache.commons.mail2.jakarta.HtmlEmail;
import org.apache.commons.mail2.jakarta.mocks.MockHtmlEmailConcrete;
import org.apache.commons.mail2.jakarta.settings.EmailConfiguration;
import org.apache.commons.mail2.jakarta.util.MimeMessageParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class HtmlEmailTest
extends AbstractEmailTest {
    private MockHtmlEmailConcrete email;

    private void assertCorrectContentType(String picture, String contentType) throws Exception {
        HtmlEmail htmlEmail = this.createDefaultHtmlEmail();
        String cid = htmlEmail.embed(new File("./src/test/resources/images/" + picture), "Apache Logo");
        String htmlMsg = "<html><img src=\"cid:" + cid + "\"><html>";
        htmlEmail.setHtmlMsg(htmlMsg);
        htmlEmail.buildMimeMessage();
        MimeMessage mm = htmlEmail.getMimeMessage();
        mm.saveChanges();
        MimeMessageParser mmp = new MimeMessageParser(mm);
        mmp.parse();
        List attachments = mmp.getAttachmentList();
        Assertions.assertEquals((int)1, (int)attachments.size(), (String)"Attachment size");
        DataSource ds = (DataSource)attachments.get(0);
        Assertions.assertEquals((Object)contentType, (Object)ds.getContentType(), (String)"Content type");
    }

    private HtmlEmail createDefaultHtmlEmail() throws EmailException {
        HtmlEmail htmlEmail = new HtmlEmail();
        htmlEmail.setHostName(this.strTestMailServer);
        htmlEmail.setSmtpPort(this.getMailServerPort());
        htmlEmail.setFrom("a@b.com");
        htmlEmail.addTo("c@d.com");
        return htmlEmail;
    }

    @BeforeEach
    public void setUpHtmlEmailTest() {
        this.email = new MockHtmlEmailConcrete();
    }

    @Test
    public void testAddZipUrl() throws Exception {
        String htmlMsg = "Please click on the following link: <br><br><a href=\"http://paradisedelivery.homeip.net/delivery/?file=3DTZC268X93337.zip\">http://paradisedelivery.homeip.net/delivery/?file=3DTZC268X93337.zip</a><br><br>Customer satisfaction is very important for us.";
        this.getMailServer();
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setCharset(EmailConstants.ISO_8859_1);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "A dot (\".\") is appended to some ULRs of a HTML mail.";
        this.email.setSubject("A dot (\".\") is appended to some ULRs of a HTML mail.");
        this.email.setHtmlMsg("Please click on the following link: <br><br><a href=\"http://paradisedelivery.homeip.net/delivery/?file=3DTZC268X93337.zip\">http://paradisedelivery.homeip.net/delivery/?file=3DTZC268X93337.zip</a><br><br>Customer satisfaction is very important for us.");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "A dot (\".\") is appended to some ULRs of a HTML mail.", this.email.getHtml(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        Assertions.assertTrue((boolean)this.email.getHtml().contains("3DTZC268X93337.zip"));
        Assertions.assertFalse((boolean)this.email.getHtml().contains("3DTZC268X93337..zip"));
    }

    @Test
    public void testCallingBuildMimeMessageBeforeSent() throws Exception {
        String htmlMsg = "<b>Hello World</b>";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setCharset(EmailConstants.ISO_8859_1);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "testCallingBuildMimeMessageBeforeSent";
        this.email.setSubject("testCallingBuildMimeMessageBeforeSent");
        this.email.setHtmlMsg("<b>Hello World</b>");
        this.email.buildMimeMessage();
        Assertions.assertThrows(IllegalStateException.class, () -> ((MockHtmlEmailConcrete)this.email).send());
    }

    @Test
    public void testEmbedDataSource() throws Exception {
        File tmpFile = File.createTempFile("testEmbedDataSource", "txt");
        tmpFile.deleteOnExit();
        FileDataSource dataSource = new FileDataSource(tmpFile);
        Assertions.assertThrows(EmailException.class, () -> this.email.embed((DataSource)dataSource, ""));
        String cid = this.email.embed((DataSource)dataSource, "testname");
        String sameCid = this.email.embed((DataSource)dataSource, "testname");
        Assertions.assertEquals((Object)cid, (Object)sameCid, (String)"didn't get same CID for embedding same datasource twice");
        File anotherFile = File.createTempFile("testEmbedDataSource2", "txt");
        anotherFile.deleteOnExit();
        FileDataSource anotherDS = new FileDataSource(anotherFile);
        Assertions.assertThrows(EmailException.class, () -> this.email.embed((DataSource)anotherDS, "testname"));
    }

    @Test
    public void testEmbedFile() throws Exception {
        File file = File.createTempFile("testEmbedFile", "txt");
        file.deleteOnExit();
        String strEmbed = this.email.embed(file);
        Assertions.assertNotNull((Object)strEmbed);
        Assertions.assertEquals((int)10, (int)strEmbed.length(), (String)"generated CID has wrong length");
        String testCid = this.email.embed(file);
        Assertions.assertEquals((Object)strEmbed, (Object)testCid, (String)"didn't get same CID after embedding same file twice");
        File otherFile = File.createTempFile("testEmbedFile2", "txt");
        otherFile.deleteOnExit();
        String newCid = this.email.embed(otherFile);
        Assertions.assertNotEquals((Object)strEmbed, (Object)newCid, (String)"didn't get unique CID from embedding new file");
    }

    @Test
    public void testEmbedFileWithCID() throws Exception {
        File file = File.createTempFile("testEmbedFile", "txt");
        file.deleteOnExit();
        String testCid = "Test CID";
        String encodedCid = EmailUtils.encodeUrl((String)"Test CID");
        String strEmbed = this.email.embed(file, "Test CID");
        Assertions.assertNotNull((Object)strEmbed);
        Assertions.assertEquals((Object)encodedCid, (Object)strEmbed, (String)"didn't get same CID when embedding with a specified CID");
        String returnedCid = this.email.embed(file);
        Assertions.assertEquals((Object)encodedCid, (Object)returnedCid, (String)"didn't get same CID after embedding same file twice");
    }

    @Test
    public void testEmbedUrl() throws Exception {
        String strEmbed = this.email.embed(new URL(this.strTestURL), "Test name");
        Assertions.assertNotNull((Object)strEmbed);
        Assertions.assertEquals((int)10, (int)strEmbed.length());
        String testCid = this.email.embed(new URL(this.strTestURL), "Test name");
        Assertions.assertEquals((Object)strEmbed, (Object)testCid);
        String newCid = this.email.embed(new URL(this.strTestURL), "Test name 2");
        Assertions.assertNotEquals((Object)strEmbed, (Object)newCid);
        Assertions.assertThrows(EmailException.class, () -> this.email.embed(this.createInvalidURL(), "Bad URL"));
        Assertions.assertThrows(EmailException.class, () -> this.email.embed(new URL("http://www.google.com"), "Test name"));
    }

    @Test
    public void testEmbedUrlAndFile() throws Exception {
        File tmpFile = File.createTempFile("testfile", "txt");
        tmpFile.deleteOnExit();
        String fileCid = this.email.embed(tmpFile);
        URL fileUrl = tmpFile.toURI().toURL();
        String urlCid = this.email.embed(fileUrl, "urlName");
        Assertions.assertNotEquals((Object)fileCid, (Object)urlCid, (String)"file and URL cids should be different even for same resource");
    }

    @Test
    public void testGetSetHtmlMsg() throws EmailException {
        for (String validChar : this.testCharsValid) {
            this.email.setHtmlMsg(validChar);
            Assertions.assertEquals((Object)validChar, (Object)this.email.getHtml());
        }
        for (String invalidChar : this.testCharsNotValid) {
            Assertions.assertThrows(EmailException.class, () -> this.email.setHtmlMsg(invalidChar));
        }
    }

    @Test
    public void testGetSetMsg() throws EmailException {
        for (String validChar : this.testCharsValid) {
            this.email.setMsg(validChar);
            Assertions.assertEquals((Object)validChar, (Object)this.email.getText());
            Assertions.assertTrue((boolean)this.email.getHtml().contains(validChar));
        }
        for (String invalidChar : this.testCharsNotValid) {
            Assertions.assertThrows(EmailException.class, () -> this.email.setMsg(invalidChar));
        }
    }

    @Test
    public void testGetSetTextMsg() throws EmailException {
        for (String validChar : this.testCharsValid) {
            this.email.setTextMsg(validChar);
            Assertions.assertEquals((Object)validChar, (Object)this.email.getText());
        }
        for (String invalidChar : this.testCharsNotValid) {
            Assertions.assertThrows(EmailException.class, () -> this.email.setTextMsg(invalidChar));
        }
    }

    @Test
    public void testHtmlMailMimeLayout() throws Exception {
        this.assertCorrectContentType("contentTypeTest.gif", "image/gif");
        this.assertCorrectContentType("contentTypeTest.jpg", "image/jpeg");
        this.assertCorrectContentType("contentTypeTest.png", "image/png");
    }

    @Test
    public void testSend() throws EmailException, IOException {
        EmailAttachment attachment = new EmailAttachment();
        File testFile = File.createTempFile("commons-email-testfile", ".txt");
        testFile.deleteOnExit();
        this.getMailServer();
        String strSubject = "Test HTML Send #1 Subject (w charset)";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        attachment.setName("Test Attachment");
        attachment.setDescription("Test Attachment Desc");
        attachment.setPath(testFile.getAbsolutePath());
        this.email.attach(attachment);
        this.email.setCharset(EmailConstants.ISO_8859_1);
        this.email.setSubject(strSubject);
        URL url = new URL(EmailConfiguration.TEST_URL);
        String cid = this.email.embed(url, "Apache Logo");
        String strHtmlMsg = "<html>The Apache logo - <img src=\"cid:" + cid + "\"><html>";
        this.email.setHtmlMsg(strHtmlMsg);
        this.email.setTextMsg("Your email client does not support HTML emails");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getText(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtml(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        this.validateSend(this.fakeMailServer, strSubject, attachment.getName(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        this.getMailServer();
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        strSubject = "Test HTML Send #1 Subject (wo charset)";
        this.email.setSubject(strSubject);
        this.email.setTextMsg("Test message");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getText(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }

    @Test
    public void testSend2() throws Exception {
        this.getMailServer();
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "Test HTML Send #2 Subject (wo charset)";
        this.email.setSubject(strSubject);
        this.email.setMsg("Test txt msg");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getText(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtml(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        this.getMailServer();
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setFrom(this.strTestMailFrom);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        strSubject = "Test HTML Send #2 Subject (w charset)";
        this.email.setCharset(EmailConstants.ISO_8859_1);
        this.email.setSubject(strSubject);
        this.email.setMsg("Test txt msg");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getText(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtml(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
    }

    @Test
    @Disabled
    public void testSendWithDefaultCharset() throws Exception {
        System.setProperty("mail.mime.charset", "iso-8859-15");
        this.getMailServer();
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "Test HTML Send Subject (w default charset)";
        this.email.setSubject("Test HTML Send Subject (w default charset)");
        this.email.setMsg("Test txt msg \u00e4");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "Test HTML Send Subject (w default charset)", "charset=iso-8859-15", this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        System.clearProperty("mail.mime.charset");
    }

    @Test
    public void testSendWithPlainTextButNoHtmlContent() throws EmailException, IOException {
        this.getMailServer();
        String strSubject = "testSendWithPlainTextButNoHtmlContent";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        this.email.setCharset(EmailConstants.ISO_8859_1);
        this.email.setSubject("testSendWithPlainTextButNoHtmlContent");
        this.email.setMsg("This is a plain text content : <b><&npsb;></html></b>");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "testSendWithPlainTextButNoHtmlContent", this.email.getText(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }
}

