/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.function.IOIntSupplier;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IOIntSupplierTest {
    private AtomicInteger atomicInt;

    IOIntSupplierTest() {
    }

    private int getThrowsIO(IOIntSupplier supplier) throws IOException {
        return supplier.getAsInt();
    }

    private int getThrowsNone(IOIntSupplier supplier) {
        return supplier.asIntSupplier().getAsInt();
    }

    @BeforeEach
    public void initEach() {
        this.atomicInt = new AtomicInteger();
    }

    @Test
    void testAsSupplier() {
        Assertions.assertThrows(UncheckedIOException.class, () -> TestConstants.THROWING_IO_INT_SUPPLIER.asIntSupplier().getAsInt());
        Assertions.assertEquals((int)1, (int)this.getThrowsNone(() -> TestUtils.compareAndSetThrowsIO(this.atomicInt, 1)));
        Assertions.assertEquals((int)1, (int)this.atomicInt.get());
        Assertions.assertNotEquals((Object)TestConstants.THROWING_IO_INT_SUPPLIER.asIntSupplier(), (Object)TestConstants.THROWING_IO_INT_SUPPLIER.asIntSupplier());
    }

    @Test
    void testGet() throws IOException {
        Assertions.assertThrows(IOException.class, () -> TestConstants.THROWING_IO_INT_SUPPLIER.getAsInt());
        Assertions.assertThrows(IOException.class, () -> {
            throw new IOException();
        });
        Assertions.assertEquals((int)1, (int)this.getThrowsIO(() -> TestUtils.compareAndSetThrowsIO(this.atomicInt, 1)));
        Assertions.assertEquals((int)1, (int)this.atomicInt.get());
    }
}

