/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public abstract class QueueAbstractPacket
extends PacketImpl {
    protected SimpleString queueName;
    protected SimpleString address;

    public SimpleString getQueueName() {
        return this.queueName;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public final List<SimpleString> convertQueueNames(int clientVersion, List<SimpleString> queueNames) {
        if (clientVersion < 129) {
            int names = queueNames.size();
            if (names == 0) {
                return Collections.emptyList();
            }
            SimpleString prefix = QueueAbstractPacket.jmsPrefixOf(this.address);
            if (prefix != null) {
                ArrayList<SimpleString> prefixedQueueNames = new ArrayList<SimpleString>(names);
                for (int i = 0; i < names; ++i) {
                    SimpleString oldQueueName = queueNames.get(i);
                    if (oldQueueName.startsWith(prefix)) {
                        prefixedQueueNames.add(oldQueueName);
                        continue;
                    }
                    SimpleString prefixedQueueName = prefix.concat(oldQueueName);
                    prefixedQueueNames.add(prefixedQueueName);
                }
                return prefixedQueueNames;
            }
            return queueNames;
        }
        return queueNames;
    }

    private static SimpleString jmsPrefixOf(SimpleString address) {
        if (address.startsWith(OLD_QUEUE_PREFIX)) {
            return OLD_QUEUE_PREFIX;
        }
        if (address.startsWith(OLD_TOPIC_PREFIX)) {
            return OLD_TOPIC_PREFIX;
        }
        return null;
    }

    public QueueAbstractPacket(byte type) {
        super(type);
    }

    public static SimpleString getOldPrefixedAddress(SimpleString address, RoutingType routingType) {
        if (routingType == RoutingType.MULTICAST && !address.startsWith(OLD_TOPIC_PREFIX)) {
            return OLD_TOPIC_PREFIX.concat(address);
        }
        if (routingType == RoutingType.ANYCAST && !address.startsWith(OLD_QUEUE_PREFIX)) {
            return OLD_QUEUE_PREFIX.concat(address);
        }
        return address;
    }
}

