/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.coder;

import com.siemens.ct.exi.core.CodingMode;
import com.siemens.ct.exi.core.EXIBodyEncoder;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.EXIStreamEncoder;
import com.siemens.ct.exi.core.coder.EXIHeaderEncoder;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.io.channel.BitEncoderChannel;
import java.io.IOException;
import java.io.OutputStream;

public class EXIStreamEncoderImpl
implements EXIStreamEncoder {
    protected final EXIHeaderEncoder exiHeader;
    protected final EXIBodyEncoder exiBody;
    protected final EXIFactory exiFactory;

    public EXIStreamEncoderImpl(EXIFactory exiFactory) throws EXIException {
        this.exiFactory = exiFactory;
        this.exiHeader = new EXIHeaderEncoder();
        this.exiBody = exiFactory.createEXIBodyEncoder();
    }

    @Override
    public EXIBodyEncoder encodeHeader(OutputStream os) throws EXIException, IOException {
        BitEncoderChannel headerChannel = new BitEncoderChannel(os);
        this.exiHeader.write(headerChannel, this.exiFactory);
        if (this.exiFactory.getCodingMode() == CodingMode.BIT_PACKED) {
            this.exiBody.setOutputChannel(headerChannel);
        } else {
            this.exiBody.setOutputStream(os);
        }
        return this.exiBody;
    }
}

