/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derby.tools.sysinfo;
import org.apache.derbyTesting.functionTests.tests.compatibility.ClientCompatibilityRunControl;
import org.apache.derbyTesting.functionTests.tests.compatibility.VersionedNetworkServerTestSetup;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class VersionCombinationConfigurator {
    private static final String EMB_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private final String name;
    private final boolean limitToTrunk;
    private final boolean newestFixpackOnly;
    private List<DerbyVersion> toInclude = Collections.emptyList();
    private List<DerbyVersion> toExclude = Collections.emptyList();

    public static VersionCombinationConfigurator getInstanceDevMATS() {
        return new VersionCombinationConfigurator("default/MATS configuration", true, true);
    }

    public static VersionCombinationConfigurator getInstanceDevFull() {
        return new VersionCombinationConfigurator("full development configuration", true, false);
    }

    public static VersionCombinationConfigurator getInstanceOld() {
        return new VersionCombinationConfigurator("historical configuration", false, true);
    }

    public static VersionCombinationConfigurator getInstanceOldFull() {
        return new VersionCombinationConfigurator("full historical configuration", false, false);
    }

    private VersionCombinationConfigurator(String string, boolean bl, boolean bl2) {
        this.name = string;
        this.limitToTrunk = bl;
        this.newestFixpackOnly = bl2;
    }

    public String getName() {
        return this.name;
    }

    public int addTests(BaseTestSuite baseTestSuite) {
        int n = 0;
        List<DerbyDistribution> list = this.filterVersions();
        DerbyDistribution derbyDistribution = list.get(0);
        String string = derbyDistribution.getTestingClasspath();
        for (DerbyDistribution derbyDistribution2 : list) {
            DerbyVersion derbyVersion = derbyDistribution2.getVersion();
            if (this.skipServerVersion(derbyVersion)) continue;
            BaseTestSuite baseTestSuite2 = new BaseTestSuite("Client runs against server " + derbyVersion.toString());
            for (DerbyDistribution derbyDistribution3 : list) {
                if (this.limitToTrunk && !derbyDistribution2.equals(derbyDistribution) && !derbyDistribution3.equals(derbyDistribution)) continue;
                baseTestSuite2.addTest((Test)new ClientCompatibilityRunControl(derbyDistribution3, string, derbyVersion));
                ++n;
            }
            Object object = new VersionedNetworkServerTestSetup((Test)baseTestSuite2, derbyDistribution2, string);
            baseTestSuite.addTest((Test)object);
        }
        return n;
    }

    public void setIncludes(List<DerbyVersion> list) {
        if (list != null) {
            this.toInclude = list;
        }
    }

    public void setExcludes(List<DerbyVersion> list) {
        if (list != null) {
            this.toExclude = list;
        }
    }

    private boolean skipServerVersion(DerbyVersion derbyVersion) {
        if (!JDBC.vmSupportsJNDI() && derbyVersion.lessThan(DerbyVersion._10_10)) {
            VersionCombinationConfigurator.println("Server version " + derbyVersion + " was skipped because it requires JNDI to run.");
            return true;
        }
        return false;
    }

    private List<DerbyDistribution> filterVersions() {
        DerbyDistribution[] derbyDistributionArray = TestConfiguration.getReleaseRepository().getDistributions();
        List<DerbyDistribution> list = new ArrayList<DerbyDistribution>();
        Object object = derbyDistributionArray;
        int n = ((DerbyDistribution[])object).length;
        for (int i = 0; i < n; ++i) {
            DerbyDistribution derbyDistribution = object[i];
            DerbyVersion derbyVersion = derbyDistribution.getVersion();
            if (!this.toInclude.isEmpty() && !this.toInclude.contains(derbyVersion)) {
                VersionCombinationConfigurator.println(derbyVersion.toString() + " not in include list");
                continue;
            }
            if (!this.toExclude.isEmpty() && this.toExclude.contains(derbyVersion)) {
                VersionCombinationConfigurator.println(derbyVersion.toString() + " in exclude list");
                continue;
            }
            list.add(derbyDistribution);
        }
        if (list.isEmpty()) {
            VersionCombinationConfigurator.alarm("No old releases found for current configuration/environment");
        }
        if (!list.contains(object = this.getRunningDistribution())) {
            list.add((DerbyDistribution)object);
        }
        list = this.sortAndFilterVersions(list);
        VersionCombinationConfigurator.println("--- " + list.size() + " distributions qualified");
        for (DerbyDistribution derbyDistribution : list) {
            VersionCombinationConfigurator.println(derbyDistribution.getVersion().toString());
        }
        return list;
    }

    private DerbyDistribution getRunningDistribution() {
        File file;
        try {
            file = this.getJarDirectoryOf(Class.forName(EMB_DRIVER));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("missing Derby class: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        File file2 = this.getJarDirectoryOf(this.getClass());
        DerbyVersion derbyVersion = DerbyVersion.parseVersionString(sysinfo.getVersionString());
        DerbyDistribution derbyDistribution = DerbyDistribution.newInstance(derbyVersion, file, file2);
        if (derbyDistribution == null) {
            throw new IllegalStateException("failed to get running distribution (programming error?)");
        }
        return derbyDistribution;
    }

    private File getJarDirectoryOf(Class clazz) {
        File file = new File(VersionCombinationConfigurator.getClassURI(clazz));
        if (file.isDirectory()) {
            throw new IllegalStateException("only running off jars is supported, currently running off directory " + file);
        }
        return file.getParentFile();
    }

    private List<DerbyDistribution> sortAndFilterVersions(List<DerbyDistribution> list) {
        Collections.sort(list);
        Collections.reverse(list);
        DerbyDistribution derbyDistribution = null;
        if (this.newestFixpackOnly) {
            ArrayList<DerbyDistribution> arrayList = new ArrayList<DerbyDistribution>();
            for (DerbyDistribution derbyDistribution2 : list) {
                DerbyVersion derbyVersion = derbyDistribution2.getVersion();
                if (derbyDistribution == null || derbyDistribution.getVersion().greaterMinorThan(derbyVersion)) {
                    arrayList.add(derbyDistribution2);
                } else {
                    VersionCombinationConfigurator.println("ignored " + derbyVersion.toString() + ", not the newest fixpack version for " + derbyVersion.getMajor() + "." + derbyVersion.getMinor());
                }
                derbyDistribution = derbyDistribution2;
            }
            list = arrayList;
        }
        return list;
    }

    static URI getClassURI(Class clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            try {
                return codeSource.getLocation().toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                BaseTestCase.alarm("bad URI: " + uRISyntaxException.getMessage());
            }
        }
        return null;
    }

    private static void println(String string) {
        BaseTestCase.println(string);
    }

    private static void alarm(String string) {
        BaseTestCase.alarm(string);
    }
}

