/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobUpdatableStreamTest
extends BaseJDBCTestCase {
    public BlobUpdatableStreamTest(String string) {
        super(string);
    }

    public void testUpdatableBlob() throws Exception {
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into testblob values (?)");
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(0x100000L), 0x100000);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from testblob");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        InputStream inputStream = blob.getBinaryStream();
        long l = inputStream.skip(20L);
        blob.truncate(l);
        int n = inputStream.read();
        BlobUpdatableStreamTest.assertEquals((String)"stream update failed", (int)-1, (int)n);
        byte[] byArray = new byte[1024];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(i % 255);
        }
        blob.setBytes(blob.length() + 1L, byArray);
        byte[] byArray2 = new byte[1024];
        int n2 = 1024;
        while (n2 != 0) {
            long l2 = inputStream.read(byArray2, 1024 - n2, n2);
            if (l2 < 0L) {
                BlobUpdatableStreamTest.fail((String)"couldn't retrieve updated value");
            }
            n2 = (int)((long)n2 - l2);
        }
        for (int i = 0; i < byArray.length; ++i) {
            BlobUpdatableStreamTest.assertEquals((String)"value retrieved is not same as updated value", (byte)byArray[i], (byte)byArray2[i]);
        }
        blob = null;
        resultSet.close();
        statement.close();
        this.commit();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(BlobUpdatableStreamTest.class);
    }

    public void setUp() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table testblob (data blob)");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("drop table testblob");
        statement.close();
        this.commit();
        super.tearDown();
    }
}

