/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.connectionJdbc20;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class maxfieldsize {
    static final int START_SECOND_HALF = 5;
    static final int NUM_EXECUTIONS = 10;
    static final String c1_value = "C1XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c2_value = "C2XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c3_value = "C3XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c4_value = "C4XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c5_value = "C5XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c6_value = "C6XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    private static boolean isDerbyNet = false;

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"table tab1", "table tab2"};
        System.out.println("Test MaxFieldSize  starting");
        isDerbyNet = TestUtil.isNetFramework();
        try {
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            Statement statement = connection.createStatement();
            statement.execute("create table tab1(c1 char(100) for bit data,c2 varchar(100) for bit data,c3 long varchar for bit data,c4 char(100),c5 varchar(100),c6 long varchar)");
            maxfieldsize.load_data(connection);
            for (int i = 0; i < 10; ++i) {
                if (i == 5) {
                    statement.setMaxFieldSize(24);
                }
                System.out.println("Iteration #: " + i);
                System.out.println("Max Field Size = " + statement.getMaxFieldSize());
                ResultSet resultSet = statement.executeQuery("select * from tab1");
                while (resultSet.next()) {
                    block14: for (int j = 1; j < 7; ++j) {
                        System.out.println("Column #: " + j);
                        switch (i % 5) {
                            case 0: {
                                connectionJdbc20.get_using_object(resultSet, j);
                                continue block14;
                            }
                            case 1: {
                                if (isDerbyNet) {
                                    System.out.println("beetle 5350 - JCC returns incorrect result for maxfieldsize()");
                                }
                                connectionJdbc20.get_using_string(resultSet, j);
                                continue block14;
                            }
                            case 2: {
                                connectionJdbc20.get_using_ascii_stream(resultSet, j);
                                continue block14;
                            }
                            case 3: {
                                if (j < 4) {
                                    connectionJdbc20.get_using_binary_stream(resultSet, j);
                                    continue block14;
                                }
                                System.out.println("SKIPPING");
                                continue block14;
                            }
                            case 4: {
                                if (j < 4) {
                                    connectionJdbc20.get_using_bytes(resultSet, j);
                                    continue block14;
                                }
                                System.out.println("SKIPPING");
                            }
                        }
                    }
                }
                resultSet.close();
            }
            try {
                statement.setMaxFieldSize(-200);
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage() != null && sQLException.getMessage().indexOf("Invalid maxFieldSize value") >= 0 || sQLException.getSQLState() != null && sQLException.getSQLState().equals("XJ066")) {
                    System.out.println("Expected Exception - Invalid maxFieldsize");
                }
                System.out.println("Unexpected FAILURE at " + sQLException);
            }
            statement.setMaxFieldSize(0);
            System.out.println("Doing external sort");
            maxfieldsize.testSort(connection, statement);
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            maxfieldsize.dumpSQLExceptions(sQLException);
            sQLException.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception: " + throwable);
            throwable.printStackTrace();
        }
        System.out.println("Test maxfieldsize  finished");
    }

    private static void load_data(Connection connection) throws Exception {
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = connection.prepareStatement("insert into tab1 values(?,?,?,?,?,?)");
            preparedStatement.setBytes(1, c1_value.getBytes("US-ASCII"));
            preparedStatement.setBytes(2, c2_value.getBytes("US-ASCII"));
            preparedStatement.setBytes(3, c3_value.getBytes("US-ASCII"));
            preparedStatement.setString(4, c4_value);
            preparedStatement.setString(5, c5_value);
            preparedStatement.setString(6, c6_value);
            preparedStatement.execute();
        }
    }

    private static void testSort(Connection connection, Statement statement) throws SQLException, UnsupportedEncodingException {
        statement.execute("create table tab2(c0 int, c1 char(100) for bit data,c2 varchar(100) for bit data,c3 long varchar for bit data,c4 char(100),c5 varchar(100),c6 long varchar)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into tab2 values (?, ?, ?, ?, ?, ?, ?)");
        for (int i = 0; i < 5000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setBytes(2, c1_value.getBytes("US-ASCII"));
            preparedStatement.setBytes(3, c2_value.getBytes("US-ASCII"));
            preparedStatement.setBytes(4, c3_value.getBytes("US-ASCII"));
            preparedStatement.setString(5, c4_value);
            preparedStatement.setString(6, c5_value);
            preparedStatement.setString(7, c6_value);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        maxfieldsize.doSort(statement);
        statement.setMaxFieldSize(24);
        maxfieldsize.doSort(statement);
    }

    private static void doSort(Statement statement) throws SQLException {
        System.out.println("Max Field Size = " + statement.getMaxFieldSize());
        try {
            ResultSet resultSet = statement.executeQuery("select * from tab2 order by c0 desc");
            for (int i = 0; i < 5000; ++i) {
                resultSet.next();
                if (i >= 5 && i < 4995) continue;
                System.out.println("Iteration #: " + i);
                System.out.println("Column #1: " + resultSet.getInt(1));
                System.out.println("Column #2:");
                connectionJdbc20.get_using_binary_stream(resultSet, 2);
                System.out.println("Column #3:");
                connectionJdbc20.get_using_binary_stream(resultSet, 3);
                System.out.println("Column #4:");
                connectionJdbc20.get_using_binary_stream(resultSet, 4);
                System.out.println("Column #5:");
                connectionJdbc20.get_using_ascii_stream(resultSet, 5);
                System.out.println("Column #6:");
                connectionJdbc20.get_using_ascii_stream(resultSet, 6);
                System.out.println("Column #7:");
                connectionJdbc20.get_using_ascii_stream(resultSet, 7);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception: " + throwable);
            throwable.printStackTrace();
        }
    }

    private static void dumpSQLExceptions(SQLException sQLException) {
        System.out.println("FAIL -- unexpected exception");
        while (sQLException != null) {
            System.out.println("SQLSTATE(" + sQLException.getSQLState() + "): " + sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    private static void dumpExpectedSQLExceptions(SQLException sQLException) {
        System.out.println("PASS -- expected exception");
        while (sQLException != null) {
            System.out.println("SQLSTATE(" + sQLException.getSQLState() + "): " + sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    private static void cleanUp(Connection connection) throws SQLException {
    }
}

