/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AlterColumnTest
extends BaseJDBCTestCase {
    public AlterColumnTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(AlterColumnTest.class);
    }

    public void testAlterDefault() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table t(i int default 0)");
        PreparedStatement preparedStatement = this.prepareStatement("delete from t");
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into t values default");
        PreparedStatement preparedStatement3 = this.prepareStatement("select * from t order by i");
        preparedStatement2.executeUpdate();
        JDBC.assertFullResultSet(preparedStatement3.executeQuery(), new String[][]{{"0"}});
        statement.execute("alter table t alter COLUMN i DEFAULT 1");
        AlterColumnTest.tryAndExpect(preparedStatement, preparedStatement2, preparedStatement3, "1");
        statement.execute("alter table t alter COLUMN i WITH DEFAULT 2");
        AlterColumnTest.tryAndExpect(preparedStatement, preparedStatement2, preparedStatement3, "2");
        statement.execute("alter table t alter COLUMN i SET DEFAULT 3");
        AlterColumnTest.tryAndExpect(preparedStatement, preparedStatement2, preparedStatement3, "3");
        statement.execute("alter table t alter i DEFAULT 4");
        AlterColumnTest.tryAndExpect(preparedStatement, preparedStatement2, preparedStatement3, "4");
        statement.execute("alter table t alter i WITH DEFAULT 5");
        AlterColumnTest.tryAndExpect(preparedStatement, preparedStatement2, preparedStatement3, "5");
        statement.execute("alter table t alter i SET DEFAULT 6");
        AlterColumnTest.tryAndExpect(preparedStatement, preparedStatement2, preparedStatement3, "6");
        statement.execute("alter table t alter i SET DEFAULT null");
        AlterColumnTest.tryAndExpect(preparedStatement, preparedStatement2, preparedStatement3, null);
        statement.execute("alter table t alter i SET DEFAULT 1");
        AlterColumnTest.tryAndExpect(preparedStatement, preparedStatement2, preparedStatement3, "1");
        statement.execute("alter table t alter i DROP DEFAULT");
        AlterColumnTest.tryAndExpect(preparedStatement, preparedStatement2, preparedStatement3, null);
        statement.close();
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
    }

    private static void tryAndExpect(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3, String string) throws SQLException {
        preparedStatement.executeUpdate();
        preparedStatement2.executeUpdate();
        JDBC.assertSingleValueResultSet(preparedStatement3.executeQuery(), string);
    }
}

