/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.BigDecimalHandler;

public class outparams {
    private static boolean HAVE_BIG_DECIMAL = BigDecimalHandler.representation == 2;
    private static boolean HAVE_DRIVER_CLASS;
    private static String CLASS_NAME;
    static String[] outputMethods;
    private static final String[] outputProcParam;
    static String[] returnMethods;
    static String[] returnMethodType;
    static int[] paramJDBCType;
    static final int[] types;
    static final String[] typeNames;

    public static void main(String[] stringArray) throws Throwable {
        ij.getPropertyArg((String[])stringArray);
        Connection connection = ij.startJBMS();
        outparams.runTests(connection);
    }

    public static void runTests(Connection connection) throws Throwable {
        connection.setAutoCommit(false);
        outparams.testMisc(connection);
        outparams.testNull(connection);
        outparams.testUpdate(connection);
        outparams.testEachOutputType(connection);
        outparams.testReturnTypes(connection);
        outparams.testOtherOutputType(connection);
        outparams.testManyOut(connection);
        if (HAVE_DRIVER_CLASS) {
            outparams.test5116(connection);
        }
    }

    private static void testMisc(Connection connection) throws Throwable {
        System.out.println("==============================================");
        System.out.println("TESTING BOUNDARY CONDITIONS");
        System.out.println("==============================================\n");
        Statement statement = connection.createStatement();
        statement.execute("CREATE PROCEDURE takesString(OUT P1 VARCHAR(40), IN P2 INT) EXTERNAL NAME '" + CLASS_NAME + "takesString' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
        CallableStatement callableStatement = connection.prepareCall("call takesString(?,?)");
        boolean bl = false;
        try {
            callableStatement.registerOutParameter(2, 4);
        }
        catch (SQLException sQLException) {
            bl = true;
            System.out.println("Expected exception " + sQLException);
        }
        if (!bl) {
            System.out.println("registerOutParameter on non-output didn't fail");
        }
        bl = false;
        try {
            callableStatement.registerOutParameter(9, 4);
        }
        catch (SQLException sQLException) {
            bl = true;
            System.out.println("Expected exception " + sQLException);
        }
        if (!bl) {
            System.out.println("registerOutParameter on bad value didn't fail");
        }
        bl = false;
        try {
            callableStatement.registerOutParameter(0, 4);
        }
        catch (SQLException sQLException) {
            bl = true;
            System.out.println("Expected exception " + sQLException);
        }
        if (!bl) {
            System.out.println("registerOutParameter on bad value didn't fail");
        }
        try {
            callableStatement.setDouble(1, 1.0);
            System.out.println("FAIL setDouble() on takesString() accepted");
        }
        catch (SQLException sQLException) {
            System.out.println("Expected exception " + sQLException);
        }
        try {
            callableStatement.setString(1, "hello");
            System.out.println("FAIL setString() on takesString() accepted");
        }
        catch (SQLException sQLException) {
            System.out.println("Expected exception " + sQLException);
        }
        callableStatement.registerOutParameter(1, 1);
        callableStatement.setInt(2, 4);
        try {
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            System.out.println("cs.execute() got unexpected exception: " + sQLException);
        }
        callableStatement.clearParameters();
        callableStatement.setInt(2, 4);
        try {
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            System.out.println("cs.execute() got unexpected exception: " + sQLException);
        }
        callableStatement.close();
        statement.execute("DROP PROCEDURE takesString");
        statement.execute("CREATE FUNCTION returnsString(P2 INT) RETURNS VARCHAR(40) EXTERNAL NAME '" + CLASS_NAME + "returnsString' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
        callableStatement = connection.prepareCall("? = call returnsString(?)");
        try {
            callableStatement.setString(1, new String("test"));
            System.out.println("ERROR: setString() on return output parameter succeeded");
        }
        catch (SQLException sQLException) {
            System.out.println("Expected exception on setString() on a return output param: " + sQLException);
        }
        callableStatement.close();
        statement.execute("DROP FUNCTION returnsString");
        statement.execute("CREATE PROCEDURE returnsNothing() EXTERNAL NAME '" + CLASS_NAME + "returnsNothing' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
        try {
            callableStatement = connection.prepareCall("? = call returnsNothing()");
            System.out.println("ERROR: no exception on prepare of '? = call returnsNothing()");
        }
        catch (SQLException sQLException) {
            System.out.println("Expected exception on prepare of '? = call returnsNothing()': " + sQLException);
        }
        statement.execute("DROP PROCEDURE returnsNothing");
    }

    private static void testNull(Connection connection) throws Throwable {
        System.out.println("==============================================");
        System.out.println("TESTING NULLS");
        System.out.println("==============================================\n");
        System.out.println("Test for bug 4317, passing null value for a parameter");
        Statement statement = connection.createStatement();
        statement.execute("CREATE PROCEDURE testNullBug4317(IN P1 VARCHAR(10)) EXTERNAL NAME '" + CLASS_NAME + "testNullBug4317' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
        CallableStatement callableStatement = connection.prepareCall("call testNullBug4317(?)");
        try {
            callableStatement.setString(1, null);
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            System.out.println("cs0.execute() got unexpected exception: " + sQLException);
        }
        try {
            callableStatement.setNull(1, 12);
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            System.out.println("cs0.execute() got unexpected exception: " + sQLException);
        }
        callableStatement.close();
        statement.execute("DROP PROCEDURE testNullBug4317");
    }

    private static void testUpdate(Connection connection) throws Throwable {
        System.out.println("==============================================");
        System.out.println("TESTING UPDATE COUNT");
        System.out.println("==============================================\n");
        Statement statement = connection.createStatement();
        statement.execute("CREATE FUNCTION returnsIntegerP(P1 INT) RETURNS INTEGER EXTERNAL NAME '" + CLASS_NAME + "returnsIntegerP' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
        CallableStatement callableStatement = connection.prepareCall("? = call returnsIntegerP(0)");
        callableStatement.registerOutParameter(1, 4);
        try {
            int n = callableStatement.executeUpdate();
            System.out.println("executeUpdate on ? = call returnsIntegerP returned " + n);
            System.out.println("getString(1) returned " + callableStatement.getString(1));
        }
        catch (SQLException sQLException) {
            System.out.println("cs.execute() got unexpected exception: " + sQLException);
        }
        callableStatement.close();
        statement.execute("DROP FUNCTION returnsIntegerP");
        statement.close();
    }

    private static void testEachOutputType(Connection connection) throws Throwable {
        System.out.println("==============================================");
        System.out.println("TESTING NORMAL OUTPUT PARAMETERS");
        System.out.println("==============================================\n");
        CallableStatement callableStatement = null;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    System.out.println("...starting doing setXXX for each type xxx");
                    break;
                }
                case 1: {
                    System.out.println("...now doing setObject on each type xxx");
                    break;
                }
                case 2: {
                    System.out.println("...not doing any setXXX, just OUT parameters, not IN/OUT");
                }
            }
            for (int j = 0; j < outputMethods.length; ++j) {
                String string;
                String string2 = outputMethods[j];
                if (string2 == null) continue;
                System.out.println("\n------------------------------------");
                Statement statement = connection.createStatement();
                if (string2.indexOf("Nothing") == -1) {
                    statement.execute("CREATE PROCEDURE " + string2 + "(INOUT P1 " + outputProcParam[j] + ", IN P2 INT) EXTERNAL NAME '" + CLASS_NAME + string2 + "' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
                    string = j % 2 == 0 ? "{call " + string2 + "(?,?)}" : "call " + string2 + "(?,?)";
                } else {
                    statement.execute("CREATE PROCEDURE " + string2 + "() EXTERNAL NAME '" + CLASS_NAME + string2 + "' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
                    string = "{call " + string2 + "()}";
                }
                System.out.println(string);
                try {
                    callableStatement = connection.prepareCall(string);
                }
                catch (SQLException sQLException) {
                    System.out.println("ERROR: unexpected exception " + sQLException);
                    throw sQLException;
                }
                for (int k = 0; k < types.length; ++k) {
                    int n;
                    block25: {
                        callableStatement.clearParameters();
                        System.out.println();
                        try {
                            System.out.println("\n\tcs.registerOutParameter(1, " + typeNames[k] + ")");
                            callableStatement.registerOutParameter(1, types[k]);
                        }
                        catch (SQLException sQLException) {
                            System.out.println("\tException " + sQLException);
                            continue;
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        try {
                            if (i == 0) {
                                outparams.callSetMethod(callableStatement, 1, types[k], stringBuffer);
                            } else if (i == 1) {
                                outparams.callSetObject(callableStatement, 1, types[k], stringBuffer);
                            } else {
                                k = types.length - 1;
                                stringBuffer.append("...no setXXX(1) at all");
                            }
                        }
                        catch (SQLException sQLException) {
                            System.out.println("\t" + stringBuffer.toString());
                            System.out.println("\tException " + sQLException);
                            continue;
                        }
                        System.out.println("\t" + stringBuffer.toString());
                        callableStatement.setInt(2, types[k]);
                        try {
                            System.out.println("\tcs.execute()");
                            n = callableStatement.execute();
                            if (n == 0) break block25;
                            System.out.println("testEachOutputType HAS RESULT SET cs.execute() returned true");
                        }
                        catch (SQLException sQLException) {
                            System.out.println("\tException " + sQLException);
                            continue;
                        }
                    }
                    for (n = 0; n < types.length; ++n) {
                        StringBuffer stringBuffer = new StringBuffer();
                        try {
                            outparams.callGetMethod(callableStatement, 1, types[n], paramJDBCType[j], stringBuffer);
                        }
                        catch (SQLException sQLException) {
                            stringBuffer.append(sQLException);
                        }
                        System.out.println("\t\t\t" + stringBuffer.toString());
                    }
                }
                callableStatement.close();
                statement.execute("DROP PROCEDURE " + string2);
                statement.close();
            }
        }
        System.out.println("------------------------------------\n");
    }

    private static void testOtherOutputType(Connection connection) throws Throwable {
        System.out.println("==============================================");
        System.out.println("TESTING OUTPUT PARAMETERS WITH register(OTHER)");
        System.out.println("==============================================\n");
        CallableStatement callableStatement = null;
        for (int i = 0; i < outputMethods.length; ++i) {
            String string;
            String string2 = outputMethods[i];
            if (string2 == null) continue;
            System.out.println("\n------------------------------------");
            Statement statement = connection.createStatement();
            if (string2.indexOf("Nothing") == -1) {
                statement.execute("CREATE PROCEDURE " + string2 + "(INOUT P1 " + outputProcParam[i] + ", IN P2 INT) EXTERNAL NAME '" + CLASS_NAME + string2 + "' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
                string = i % 2 == 0 ? "{call " + string2 + "(?,?)}" : "call " + string2 + "(?,?)";
            } else {
                statement.execute("CREATE PROCEDURE " + string2 + "() EXTERNAL NAME '" + CLASS_NAME + string2 + "' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
                string = "{call " + string2 + "()}";
            }
            System.out.println(string);
            try {
                callableStatement = connection.prepareCall(string);
            }
            catch (SQLException sQLException) {
                System.out.println("ERROR: unexpected exception " + sQLException);
                throw sQLException;
            }
            for (int j = 0; j < types.length; ++j) {
                callableStatement.clearParameters();
                System.out.println();
                try {
                    System.out.println("\n\tcs.registerOutParameter(1, Types.OTHER)");
                    callableStatement.registerOutParameter(1, 1111);
                }
                catch (SQLException sQLException) {
                    System.out.println("\tException " + sQLException);
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    outparams.callSetMethod(callableStatement, 1, types[j], stringBuffer);
                }
                catch (SQLException sQLException) {
                    System.out.println("\t" + stringBuffer.toString());
                    System.out.println("\tException " + sQLException);
                    continue;
                }
                System.out.println("\t" + stringBuffer.toString());
                callableStatement.setInt(2, types[j]);
                try {
                    System.out.println("\tcs.execute()");
                    callableStatement.execute();
                }
                catch (SQLException sQLException) {
                    System.out.println("\tException " + sQLException);
                    continue;
                }
                for (int k = 0; k < types.length; ++k) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    try {
                        outparams.callGetMethod(callableStatement, 1, types[k], 1111, stringBuffer2);
                    }
                    catch (SQLException sQLException) {
                        stringBuffer2.append(sQLException);
                    }
                    System.out.println("\t\t\t" + stringBuffer2.toString());
                }
            }
            callableStatement.close();
            statement.execute("DROP PROCEDURE " + string2);
            statement.close();
        }
        System.out.println("------------------------------------\n");
    }

    private static void testReturnTypes(Connection connection) throws Throwable {
        System.out.println("==============================================\n");
        System.out.println("TESTING RETURN OUTPUT PARAMETERS");
        System.out.println("==============================================\n");
        CallableStatement callableStatement = null;
        for (int i = 0; i < returnMethods.length; ++i) {
            String string;
            String string2;
            String string3 = returnMethods[i];
            if (string3 == null) continue;
            Statement statement = connection.createStatement();
            if (string3.indexOf("Nothing") != -1) {
                statement.execute("CREATE PROCEDURE " + string3 + "() EXTERNAL NAME '" + CLASS_NAME + string3 + "' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
                string2 = "DROP PROCEDURE " + string3;
                string = "{call " + returnMethods[i] + "()}";
            } else {
                statement.execute("CREATE FUNCTION " + string3 + "(P1 INT) RETURNS " + returnMethodType[i] + " EXTERNAL NAME '" + CLASS_NAME + string3 + "' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
                string2 = "DROP FUNCTION " + string3;
                string = "{? = call " + returnMethods[i] + "(?)}";
            }
            System.out.println("\n------------------------------------");
            System.out.println(string);
            try {
                callableStatement = connection.prepareCall(string);
            }
            catch (SQLException sQLException) {
                System.out.println("ERROR: unexpected exception " + sQLException);
                throw sQLException;
            }
            for (int j = 0; j < types.length; ++j) {
                int n;
                block15: {
                    callableStatement.clearParameters();
                    System.out.println();
                    try {
                        System.out.println("\n\tcs.registerOutParameter(1, " + typeNames[j] + ")");
                        callableStatement.registerOutParameter(1, types[j]);
                    }
                    catch (SQLException sQLException) {
                        System.out.println("\tException " + sQLException);
                        continue;
                    }
                    try {
                        callableStatement.setInt(2, types[j]);
                    }
                    catch (SQLException sQLException) {
                        System.out.println("\tUnexpected exception on cs.setInt(2, " + types[j] + "): " + sQLException);
                        continue;
                    }
                    try {
                        System.out.println("\tcs.execute()");
                        n = callableStatement.execute();
                        if (n == 0) break block15;
                        System.out.println("testReturnTypes HAS RESULT SET cs.execute() returned true");
                    }
                    catch (SQLException sQLException) {
                        System.out.println("\tException " + sQLException);
                        continue;
                    }
                }
                for (n = 0; n < types.length; ++n) {
                    StringBuffer stringBuffer = new StringBuffer();
                    try {
                        outparams.callGetMethod(callableStatement, 1, types[n], paramJDBCType[i], stringBuffer);
                    }
                    catch (SQLException sQLException) {
                        stringBuffer.append(sQLException);
                    }
                    System.out.println("\t\t\t" + stringBuffer.toString());
                }
            }
            callableStatement.close();
            statement.execute(string2);
            statement.close();
        }
        System.out.println("------------------------------------\n");
    }

    private static void callSetObject(CallableStatement callableStatement, int n, int n2, StringBuffer stringBuffer) throws Throwable {
        switch (n2) {
            case -7: 
            case 16: {
                stringBuffer.append("setObject(" + n + ", true)");
                callableStatement.setObject(n, (Object)true);
                break;
            }
            case -6: {
                stringBuffer.append("setObject(" + n + ", 6)");
                callableStatement.setObject(n, (Object)6);
                break;
            }
            case 5: {
                stringBuffer.append("setObject(" + n + ", 66)");
                callableStatement.setObject(n, (Object)66);
                break;
            }
            case 4: {
                stringBuffer.append("setObject(" + n + ", 666)");
                callableStatement.setObject(n, (Object)666);
                break;
            }
            case -5: {
                stringBuffer.append("setObject(" + n + ", 666)");
                callableStatement.setObject(n, (Object)666L);
                break;
            }
            case 6: 
            case 7: {
                stringBuffer.append("setObject(" + n + ", 666)");
                callableStatement.setObject(n, (Object)Float.valueOf(666.0f));
                break;
            }
            case 8: {
                stringBuffer.append("setObject(" + n + ", 666)");
                callableStatement.setObject(n, (Object)666.0);
                break;
            }
            case 2: 
            case 3: {
                stringBuffer.append("setObject(" + n + ", 666.666)");
                BigDecimalHandler.setObjectString(callableStatement, n, "666.666");
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                stringBuffer.append("setObject(" + n + ", \"Set via setString()\")");
                callableStatement.setObject(n, (Object)"Set via setString()");
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                stringBuffer.append("setObject(" + n + ", byte[])");
                byte[] byArray = new byte[16];
                byArray[0] = -1;
                callableStatement.setObject(n, (Object)byArray);
                break;
            }
            case 91: {
                stringBuffer.append("setObject(" + n + ", Date.valueOf(1999-09-09))");
                callableStatement.setObject(n, (Object)Date.valueOf("1999-09-09"));
                break;
            }
            case 92: {
                stringBuffer.append("setObject(" + n + ", Time.valueOf(09:09:09))");
                callableStatement.setObject(n, (Object)Time.valueOf("09:09:09"));
                break;
            }
            case 93: {
                stringBuffer.append("setObject(" + n + ", Timestamp.valueOf(1999-09-09 09:09:09.999))");
                callableStatement.setObject(n, (Object)Timestamp.valueOf("1999-09-09 09:09:09.999"));
                break;
            }
            case 1111: {
                stringBuffer.append("setObject(" + n + ", new BigInteger(666))");
                callableStatement.setObject(n, (Object)new BigInteger("666"));
                break;
            }
            default: {
                throw new Throwable("TEST ERROR: unexpected type " + n2);
            }
        }
    }

    private static void callSetMethod(CallableStatement callableStatement, int n, int n2, StringBuffer stringBuffer) throws Throwable {
        switch (n2) {
            case -7: 
            case 16: {
                stringBuffer.append("setBoolean(" + n + ", true)");
                callableStatement.setBoolean(n, true);
                break;
            }
            case -6: {
                stringBuffer.append("setByte(" + n + ", 6)");
                callableStatement.setByte(n, (byte)6);
                break;
            }
            case 5: {
                stringBuffer.append("setShort(" + n + ", 66)");
                callableStatement.setShort(n, (short)66);
                break;
            }
            case 4: {
                stringBuffer.append("setInt(" + n + ", 666)");
                callableStatement.setInt(n, 666);
                break;
            }
            case -5: {
                stringBuffer.append("setLong(" + n + ", 666)");
                callableStatement.setLong(n, 666L);
                break;
            }
            case 6: 
            case 7: {
                stringBuffer.append("setFLoat(" + n + ", 666)");
                callableStatement.setFloat(n, 666.0f);
                break;
            }
            case 8: {
                stringBuffer.append("setDouble(" + n + ", 666)");
                callableStatement.setDouble(n, 666.0);
                break;
            }
            case 2: 
            case 3: {
                stringBuffer.append("setBigDecimal(" + n + ", 666.666)");
                BigDecimalHandler.setBigDecimalString(callableStatement, n, "666.666");
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                stringBuffer.append("setString(" + n + ", \"Set via setString()\")");
                callableStatement.setString(n, "Set via setString()");
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                stringBuffer.append("setBytes(" + n + ", byte[])");
                byte[] byArray = new byte[16];
                byArray[0] = -1;
                callableStatement.setBytes(n, byArray);
                break;
            }
            case 91: {
                stringBuffer.append("setDate(" + n + ", Date.valueOf(1999-09-09))");
                callableStatement.setDate(n, Date.valueOf("1999-09-09"));
                break;
            }
            case 92: {
                stringBuffer.append("setTime(" + n + ", Time.valueOf(09:09:09))");
                callableStatement.setTime(n, Time.valueOf("09:09:09"));
                break;
            }
            case 93: {
                stringBuffer.append("setTimestamp(" + n + ", Timestamp.valueOf(1999-09-09 09:09:09.999))");
                callableStatement.setTimestamp(n, Timestamp.valueOf("1999-09-09 09:09:09.999"));
                break;
            }
            case 1111: {
                stringBuffer.append("setObject(" + n + ", new BigInteger(666))");
                callableStatement.setObject(n, (Object)new BigInteger("666"));
                break;
            }
            default: {
                throw new Throwable("TEST ERROR: unexpected type " + n2);
            }
        }
    }

    private static void callGetMethod(CallableStatement callableStatement, int n, int n2, int n3, StringBuffer stringBuffer) throws Throwable {
        switch (n2) {
            case -7: 
            case 16: {
                stringBuffer.append("getBoolean(" + n + ") = ");
                stringBuffer.append(callableStatement.getBoolean(n));
                break;
            }
            case -6: {
                stringBuffer.append("getByte(" + n + ") = ");
                stringBuffer.append(Byte.toString(callableStatement.getByte(n)));
                break;
            }
            case 5: {
                stringBuffer.append("getShort(" + n + ") = ");
                stringBuffer.append(Short.toString(callableStatement.getShort(n)));
                break;
            }
            case 4: {
                stringBuffer.append("getInt(" + n + ") = ");
                stringBuffer.append(Integer.toString(callableStatement.getInt(n)));
                break;
            }
            case -5: {
                stringBuffer.append("getLong(" + n + ") = ");
                stringBuffer.append(Long.toString(callableStatement.getLong(n)));
                break;
            }
            case 6: 
            case 7: {
                stringBuffer.append("getFloat(" + n + ") = ");
                stringBuffer.append(Float.toString(callableStatement.getFloat(n)));
                break;
            }
            case 8: {
                stringBuffer.append("getDouble(" + n + ") = ");
                stringBuffer.append(Double.toString(callableStatement.getDouble(n)));
                break;
            }
            case 2: 
            case 3: {
                stringBuffer.append("getBigDecimal(" + n + ") = ");
                stringBuffer.append(BigDecimalHandler.getBigDecimalString(callableStatement, n, n3));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                stringBuffer.append("getString(" + n + ") = ");
                String string = callableStatement.getString(n);
                if (string.startsWith("[B@")) {
                    string = "byte[] reference";
                }
                stringBuffer.append(string);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                stringBuffer.append("getBytes(" + n + ") = ");
                outparams.byteArrayToString(callableStatement.getBytes(n), stringBuffer);
                break;
            }
            case 91: {
                stringBuffer.append("getDate(" + n + ") = ");
                Date date = callableStatement.getDate(n);
                stringBuffer.append(date == null ? "null" : date.toString());
                break;
            }
            case 92: {
                stringBuffer.append("getTime(" + n + ") = ");
                Time time = callableStatement.getTime(n);
                stringBuffer.append(time == null ? "null" : time.toString());
                break;
            }
            case 93: {
                stringBuffer.append("getTimestamp(" + n + ") = ");
                Timestamp timestamp = callableStatement.getTimestamp(n);
                stringBuffer.append(timestamp == null ? "null" : timestamp.toString());
                break;
            }
            case 1111: {
                stringBuffer.append("getObject(" + n + ") = ");
                Object object = callableStatement.getObject(n);
                if (object == null) {
                    stringBuffer.append("null");
                    break;
                }
                if (object instanceof byte[]) {
                    outparams.byteArrayToString((byte[])object, stringBuffer);
                    break;
                }
                stringBuffer.append(object.toString());
                break;
            }
            default: {
                throw new Throwable("TEST ERROR: unexpected type " + n2);
            }
        }
    }

    private static void byteArrayToString(byte[] byArray, StringBuffer stringBuffer) {
        if (byArray == null) {
            stringBuffer.append("null");
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(byArray[i]);
            }
        }
    }

    private static String getStringOfType(int n) throws Throwable {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return "I am a string";
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 1111: {
                return "3";
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return "3.33";
            }
            case 91: {
                return "1933-03-03";
            }
            case 92: {
                return "03:03:03";
            }
            case 93: {
                return "1933-03-03 03:03:03.333";
            }
            case -4: 
            case -3: 
            case -2: {
                return "00680065006c006c006f";
            }
            case -7: 
            case 16: {
                return "true";
            }
        }
        throw new Throwable("bad type " + n);
    }

    public static void testNull(Boolean bl, Boolean bl2, Integer[] integerArray) throws Throwable {
        if (bl.booleanValue() && integerArray[0] != null) {
            throw new Throwable("testNull() got a non-null param when it should have been null");
        }
        integerArray[0] = bl2 != false ? null : Integer.valueOf(66);
    }

    public static void testNullBug4317(String string) throws Throwable {
    }

    public static void takesNothing() {
    }

    public static void takesBytePrimitive(byte[] byArray, int n) {
        byArray[0] = (byte)(byArray[0] + byArray[0]);
    }

    public static void takesByte(Byte[] byteArray, int n) {
        byteArray[0] = (byte)(byteArray[0] == null ? 33 : byteArray[0] * 2);
    }

    public static void takesShortPrimitive(short[] sArray, int n) {
        sArray[0] = (short)(sArray[0] + sArray[0]);
    }

    public static void takesShort(Short[] shortArray, int n) {
        shortArray[0] = (byte)(shortArray[0] == null ? 33 : shortArray[0] * 2);
    }

    public static void takesIntegerPrimitive(int[] nArray, int n) {
        nArray[0] = nArray[0] + nArray[0];
    }

    public static void takesInteger(Integer[] integerArray, int n) {
        integerArray[0] = integerArray[0] == null ? 33 : integerArray[0] * 2;
    }

    public static void takesLongPrimitive(long[] lArray, int n) {
        lArray[0] = lArray[0] + lArray[0];
    }

    public static void takesLong(Long[] longArray, int n) {
        longArray[0] = longArray[0] == null ? 33L : longArray[0] * 2L;
    }

    public static void takesDoublePrimitive(double[] dArray, int n) {
        dArray[0] = dArray[0] + dArray[0];
    }

    public static void takesDouble(Double[] doubleArray, int n) {
        doubleArray[0] = doubleArray[0] == null ? 33.0 : doubleArray[0] * 2.0;
    }

    public static void takesFloatPrimitive(float[] fArray, int n) {
        fArray[0] = fArray[0] + fArray[0];
    }

    public static void takesFloat(Float[] floatArray, int n) {
        floatArray[0] = Float.valueOf(floatArray[0] == null ? 33.0f : floatArray[0].floatValue() * 2.0f);
    }

    public static void takesBooleanPrimitive(boolean[] blArray, int n) {
        blArray[0] = true;
    }

    public static void takesBoolean(Boolean[] booleanArray, int n) {
        booleanArray[0] = true;
    }

    public static void takesByteArray(byte[][] byArray, int n) {
        byte[] byArray2 = new byte[16];
        byArray2[0] = -1;
        byArray[0] = byArray2;
    }

    public static void takesDate(Date[] dateArray, int n) {
        dateArray[0] = Date.valueOf("1966-06-06");
    }

    public static void takesTime(Time[] timeArray, int n) {
        timeArray[0] = Time.valueOf("06:06:06");
    }

    public static void takesTimestamp(Timestamp[] timestampArray, int n) {
        timestampArray[0] = Timestamp.valueOf("1966-06-06 06:06:06.666");
    }

    public static void takesString(String[] stringArray, int n) throws Throwable {
        stringArray[0] = outparams.getStringOfType(n);
    }

    public static void takesBigInteger(BigInteger[] bigIntegerArray, int n) {
        bigIntegerArray[0] = bigIntegerArray[0] == null ? new BigInteger("33") : bigIntegerArray[0].add(bigIntegerArray[0]);
    }

    public static void returnsNothing() {
    }

    public static byte returnsByteP(int n) {
        return 66;
    }

    public static Byte returnsByte(int n) {
        return (byte)66;
    }

    public static short returnsShortP(int n) {
        return 666;
    }

    public static Short returnsShort(int n) {
        return (short)666;
    }

    public static int returnsIntegerP(int n) {
        return 666;
    }

    public static Integer returnsInteger(int n) {
        return 666;
    }

    public static long returnsLongP(int n) {
        return 666L;
    }

    public static Long returnsLong(int n) {
        return 666L;
    }

    public static float returnsFloatP(int n) {
        return 666.0f;
    }

    public static Float returnsFloat(int n) {
        return Float.valueOf(666.0f);
    }

    public static double returnsDoubleP(int n) {
        return 666.0;
    }

    public static Double returnsDouble(int n) {
        return 666.0;
    }

    public static byte[] returnsByteArray(int n) {
        byte[] byArray = new byte[16];
        byArray[0] = -1;
        return byArray;
    }

    public static String returnsString(int n) throws Throwable {
        return outparams.getStringOfType(n);
    }

    public static Date returnsDate(int n) {
        return Date.valueOf("1966-06-06");
    }

    public static Time returnsTime(int n) {
        return Time.valueOf("06:06:06");
    }

    public static Timestamp returnsTimestamp(int n) {
        return Timestamp.valueOf("1966-06-06 06:06:06.666");
    }

    public static BigInteger returnsBigInteger(int n) {
        return new BigInteger("666");
    }

    private static void testManyOut(Connection connection) throws SQLException {
        System.out.println("start testManyOut");
        Statement statement = connection.createStatement();
        statement.execute("CREATE PROCEDURE OP_OUT (OUT I1 INT, OUT I2 INT, OUT I3 INT, OUT I4 INT, OUT I5 INT, OUT V1 VARCHAR(40), OUT V2 VARCHAR(40), OUT V3 VARCHAR(40), OUT V4 VARCHAR(40), OUT V5 VARCHAR(40)) EXTERNAL NAME '" + CLASS_NAME + "output' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
        statement.execute("CREATE PROCEDURE OP_INOUT (INOUT I1 INT, INOUT I2 INT, INOUT I3 INT, INOUT I4 INT, INOUT I5 INT, INOUT V1 VARCHAR(40), INOUT V2 VARCHAR(40), INOUT V3 VARCHAR(40), INOUT V4 VARCHAR(40), INOUT V5 VARCHAR(40)) EXTERNAL NAME '" + CLASS_NAME + "output' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
        CallableStatement callableStatement = connection.prepareCall("CALL OP_OUT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        CallableStatement callableStatement2 = connection.prepareCall("CALL OP_INOUT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        System.out.println("Ten OUT parameters");
        outparams.executeOutput(callableStatement);
        outparams.executeOutput(callableStatement);
        callableStatement.close();
        System.out.println("Ten INOUT parameters");
        outparams.setupInput(callableStatement2);
        outparams.executeOutput(callableStatement2);
        outparams.setupInput(callableStatement2);
        outparams.executeOutput(callableStatement2);
        callableStatement2.close();
        statement.execute("DROP PROCEDURE OP_OUT");
        statement.execute("DROP PROCEDURE OP_INOUT");
        statement.close();
        System.out.println("end testManyOut");
    }

    private static void setupInput(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setInt(1, 0);
        preparedStatement.setInt(2, 0);
        preparedStatement.setInt(3, 99);
        preparedStatement.setInt(4, 103);
        preparedStatement.setInt(5, 1456);
        preparedStatement.setNull(6, 1);
        preparedStatement.setString(7, null);
        preparedStatement.setString(8, "hello");
        preparedStatement.setString(9, "goodbye");
        preparedStatement.setString(10, "welcome");
    }

    private static void executeOutput(CallableStatement callableStatement) throws SQLException {
        int n;
        for (n = 1; n <= 5; ++n) {
            callableStatement.registerOutParameter(n, 4);
        }
        for (n = 6; n <= 10; ++n) {
            callableStatement.registerOutParameter(n, 12);
        }
        callableStatement.execute();
        for (n = 1; n <= 5; ++n) {
            System.out.println("  " + n + " = " + callableStatement.getInt(n) + " was null " + callableStatement.wasNull());
        }
        for (n = 6; n <= 10; ++n) {
            System.out.println("  " + n + " = " + callableStatement.getString(n) + " was null " + callableStatement.wasNull());
        }
    }

    public static void output(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        System.out.println("  a1 = " + nArray[0]);
        System.out.println("  a2 = " + nArray2[0]);
        System.out.println("  a3 = " + nArray3[0]);
        System.out.println("  a4 = " + nArray4[0]);
        System.out.println("  a5 = " + nArray5[0]);
        System.out.println("  s1 = " + stringArray[0]);
        System.out.println("  s2 = " + stringArray2[0]);
        System.out.println("  s3 = " + stringArray3[0]);
        System.out.println("  s4 = " + stringArray4[0]);
        System.out.println("  s5 = " + stringArray5[0]);
        nArray[0] = 0;
        nArray2[0] = 0;
        nArray3[0] = 77;
        nArray4[0] = 4;
        nArray5[0] = 2003;
        stringArray[0] = null;
        stringArray2[0] = null;
        stringArray3[0] = "cloudscape";
        stringArray4[0] = "jbms";
        stringArray5[0] = "IBM CS";
    }

    private static void test5116(Connection connection) throws Throwable {
        System.out.println("==============================================");
        System.out.println("TESTING FIX OF 5116 -- VAR BIT VARYING INPUT");
        System.out.println("==============================================\n");
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE ACTIVITY_INSTANCE_T (AIID                               char(16) for bit data              NOT NULL ,KIND                               INTEGER                            NOT NULL ,PIID                               char(16) for bit data              NOT NULL ,PTID                               char(16) for bit data              NOT NULL ,ATID                               char(16) for bit data              NOT NULL ,RUN_MODE                           INTEGER                            NOT NULL ,FINISHED                           TIMESTAMP                                   ,ACTIVATED                          TIMESTAMP                                   ,STARTED                            TIMESTAMP                                   ,LAST_MODIFIED                      TIMESTAMP                                   ,LAST_STATE_CHANGE                  TIMESTAMP                                   ,STATE                              INTEGER                            NOT NULL ,TRANS_COND_VALUES                  VARCHAR(66) FOR BIT DATA           NOT NULL ,NUM_CONN_ACT_EVA                   INTEGER                            NOT NULL ,NUMBER_OF_ITERATIONS               INTEGER                            NOT NULL ,NUMBER_OF_RETRIES                  INTEGER                            NOT NULL ,HAS_CUSTOM_ATTRIBUTES              SMALLINT                           NOT NULL ,NON_BLOCK_PTID                     char(16) for bit data              NOT NULL ,NON_BLOCK_PIID                     char(16) for bit data              NOT NULL ,EXPIRES                            TIMESTAMP                                   ,TASK_ID                            VARCHAR(254)                                ,UNHANDLED_EXCEPTION                BLOB(3993600)                       ,SUB_PROCESS_PIID                   char(16) for bit data                                    ,OWNER                              VARCHAR(32)                                 ,USER_INPUT                         VARCHAR(130) FOR BIT DATA                   ,DESCRIPTION                        VARCHAR(254)                                ,VERSION_ID                         SMALLINT                           NOT NULL ,PRIMARY KEY ( AIID ) )");
        statement.execute("CREATE PROCEDURE doInsertion(IN P1 VARCHAR(2) FOR BIT DATA) EXTERNAL NAME '" + CLASS_NAME + "doInsertion' MODIFIES SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA");
        CallableStatement callableStatement = connection.prepareCall("call doInsertion (?)");
        callableStatement.setNull(1, -3);
        callableStatement.execute();
        byte[] byArray = new byte[]{1, 2};
        callableStatement.setBytes(1, byArray);
        callableStatement.execute();
        callableStatement.close();
        statement.executeUpdate("DROP PROCEDURE doInsertion");
        statement.close();
    }

    public static void doInsertion(byte[] byArray) throws Throwable {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.executeUpdate("delete from ACTIVITY_INSTANCE_T");
        String string = "INSERT INTO ACTIVITY_INSTANCE_T VALUES( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        byte[] byArray2 = new byte[2];
        byArray2[0] = 1;
        byte[] byArray3 = new byte[]{0};
        preparedStatement.setBytes(1, byArray2);
        preparedStatement.setInt(2, 0);
        preparedStatement.setBytes(3, byArray2);
        preparedStatement.setBytes(4, byArray2);
        preparedStatement.setBytes(5, byArray2);
        preparedStatement.setInt(6, 0);
        preparedStatement.setNull(7, 93);
        preparedStatement.setNull(8, 93);
        preparedStatement.setNull(9, 93);
        preparedStatement.setNull(10, 93);
        preparedStatement.setNull(11, 93);
        preparedStatement.setInt(12, 0);
        preparedStatement.setBytes(13, byArray2);
        preparedStatement.setInt(14, 0);
        preparedStatement.setInt(15, 0);
        preparedStatement.setInt(16, 0);
        preparedStatement.setBoolean(17, false);
        preparedStatement.setBytes(18, byArray2);
        preparedStatement.setBytes(19, byArray2);
        preparedStatement.setNull(20, 93);
        preparedStatement.setNull(21, 12);
        preparedStatement.setNull(22, 2004);
        preparedStatement.setNull(23, -3);
        preparedStatement.setNull(24, 12);
        if (byArray == null) {
            preparedStatement.setNull(25, -3);
        } else {
            preparedStatement.setBytes(25, byArray);
        }
        preparedStatement.setNull(26, 12);
        preparedStatement.setShort(27, (short)0);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("SELECT version_id, user_input FROM activity_instance_t");
        ResultSet resultSet = preparedStatement.executeQuery();
        System.out.println("Executed query");
        while (resultSet.next()) {
            System.out.println("i= " + resultSet.getInt(1));
            byte[] byArray4 = resultSet.getBytes(2);
            if (byArray4 == null || resultSet.wasNull()) {
                if (byArray4 == null) {
                    System.out.println("UserInput = null");
                }
                if (!resultSet.wasNull()) continue;
                System.out.println("resultSet wasNull");
                continue;
            }
            System.out.println("UserInput length  = " + byArray4.length + " bytes");
            for (int i = 0; i < byArray4.length; ++i) {
                System.out.println(i + ") = " + byArray4[i]);
            }
        }
        System.out.println("Close result set.");
        resultSet.close();
        preparedStatement.close();
        statement.close();
        connection.close();
    }

    static {
        CLASS_NAME = HAVE_BIG_DECIMAL ? "org.apache.derbyTesting.functionTests.tests.lang.outparams30." : "org.apache.derbyTesting.functionTests.tests.lang.outparams.";
        try {
            Class.forName("java.sql.Driver");
            HAVE_DRIVER_CLASS = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            HAVE_DRIVER_CLASS = false;
        }
        outputMethods = HAVE_BIG_DECIMAL ? new String[]{"takesNothing", null, null, "takesShortPrimitive", null, "takesIntegerPrimitive", null, "takesLongPrimitive", null, "takesFloatPrimitive", null, "takesDoublePrimitive", null, "takesBigDecimal", "takesByteArray", "takesString", "takesDate", "takesTimestamp", "takesTime", null} : new String[]{"takesNothing", null, null, "takesShortPrimitive", null, "takesIntegerPrimitive", null, "takesLongPrimitive", null, "takesFloatPrimitive", null, "takesDoublePrimitive", null, null, "takesByteArray", "takesString", "takesDate", "takesTimestamp", "takesTime", null};
        outputProcParam = new String[]{null, null, null, "SMALLINT", null, "INT", null, "BIGINT", null, "REAL", null, "DOUBLE", null, "DECIMAL(10,4)", "VARCHAR(40) FOR BIT DATA", "VARCHAR(40)", "DATE", "TIMESTAMP", "TIME", null};
        returnMethods = HAVE_BIG_DECIMAL ? new String[]{"returnsNothing", null, null, "returnsShortP", null, "returnsIntegerP", null, "returnsLongP", null, "returnsFloatP", null, "returnsDoubleP", null, "returnsBigDecimal", "returnsByteArray", "returnsString", "returnsDate", "returnsTimestamp", "returnsTime", null} : new String[]{"returnsNothing", null, null, "returnsShortP", null, "returnsIntegerP", null, "returnsLongP", null, "returnsFloatP", null, "returnsDoubleP", null, null, "returnsByteArray", "returnsString", "returnsDate", "returnsTimestamp", "returnsTime", null};
        returnMethodType = new String[]{null, null, null, "SMALLINT", null, "INT", null, "BIGINT", null, "REAL", null, "DOUBLE", null, "DECIMAL(10,2)", "VARCHAR(40) FOR BIT DATA", "VARCHAR(40)", "DATE", "TIMESTAMP", "TIME", null};
        paramJDBCType = new int[]{0, 0, 0, 5, 0, 4, 0, -5, 0, 7, 0, 8, 0, 2, -3, 12, 91, 93, 92, 0};
        types = new int[]{-7, 16, -6, 5, 4, -5, 6, 7, 8, 2, 3, 1, 12, -1, 91, 92, 93, -2, -3, -4, 1111};
        typeNames = new String[]{"BIT", "BOOLEAN", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "FLOAT", "REAL", "DOUBLE", "NUMERIC", "DECIMAL", "CHAR", "VARCHAR", "LONGVARCHAR", "DATE", "TIME", "TIMESTAMP", "BINARY", "VARBINARY", "LONGVARBINARY", "OTHER"};
    }
}

