/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby94Test
extends BaseJDBCTestCase {
    public Derby94Test(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = TestConfiguration.embeddedSuite(Derby94Test.class);
        object = DatabasePropertyTestSetup.singleProperty(object, "derby.locks.escalationThreshold", "102");
        object = new CleanDatabaseTestSetup((Test)object);
        return object;
    }

    public void testDerby94() throws SQLException {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("select type, lockcount, mode, tablename, lockname, state from syscs_diag.lock_table order by tablename, type desc, mode, lockcount, lockname");
        Statement statement = this.createStatement();
        statement.execute("create table t1(c1 int, c2 int not null primary key)");
        statement.execute("create table t2(c1 int)");
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into t1 values (?, ?)");
        for (int i = 0; i < 160; ++i) {
            preparedStatement2.setInt(1, i);
            preparedStatement2.setInt(2, 200 + i);
            preparedStatement2.execute();
        }
        statement.execute("insert into t2 values 0, 1, 2, 3, 4, 5, 6, 7, 8, 9");
        this.commit();
        Statement statement2 = this.createStatement(1003, 1008);
        ResultSet resultSet = statement2.executeQuery("select * from t1 for update of c1");
        Derby94Test.assertTrue((boolean)resultSet.next());
        Derby94Test.assertEquals((int)0, (int)resultSet.getInt("c1"));
        Derby94Test.assertEquals((int)200, (int)resultSet.getInt("c2"));
        resultSet.updateInt("c1", 999);
        resultSet.updateRow();
        Derby94Test.assertTrue((boolean)resultSet.next());
        Derby94Test.assertEquals((int)1, (int)resultSet.getInt("c1"));
        Derby94Test.assertEquals((int)201, (int)resultSet.getInt("c2"));
        Statement statement3 = this.createStatement(1003, 1008);
        ResultSet resultSet2 = statement3.executeQuery("select * from t2 for update of c1");
        Derby94Test.assertTrue((boolean)resultSet2.next());
        Derby94Test.assertEquals((int)0, (int)resultSet2.getInt("c1"));
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"TABLE", "2", "IX", "T1", "Tablelock", "GRANT"}, {"ROW", "1", "U", "T1", "(1,8)", "GRANT"}, {"ROW", "1", "X", "T1", "(1,7)", "GRANT"}, {"TABLE", "1", "IX", "T2", "Tablelock", "GRANT"}, {"ROW", "1", "U", "T2", "(1,7)", "GRANT"}});
        Derby94Test.assertUpdateCount(statement, 160, "insert into t2 select c1 from t1");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"TABLE", "3", "IX", "T1", "Tablelock", "GRANT"}, {"ROW", "1", "U", "T1", "(1,8)", "GRANT"}, {"ROW", "1", "X", "T1", "(1,7)", "GRANT"}, {"TABLE", "4", "IX", "T2", "Tablelock", "GRANT"}, {"TABLE", "1", "X", "T2", "Tablelock", "GRANT"}});
        Derby94Test.assertUpdateCount(statement, 160, "update t1 set c1 = c1 + 999");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"TABLE", "8", "IX", "T1", "Tablelock", "GRANT"}, {"TABLE", "1", "X", "T1", "Tablelock", "GRANT"}, {"TABLE", "4", "IX", "T2", "Tablelock", "GRANT"}, {"TABLE", "1", "X", "T2", "Tablelock", "GRANT"}});
        resultSet.close();
        resultSet2.close();
        this.commit();
        JDBC.assertEmpty(preparedStatement.executeQuery());
    }
}

