/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiThreadedIterations;
import org.apache.derbyTesting.unitTests.store.T_RowSource;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_StreamFile
extends T_MultiThreadedIterations {
    private static final String testService = "streamFileTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_007 = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    static RawStoreFactory factory;
    static LockFactory lf;
    static long commonContainer;
    static boolean testRollback;
    static final String TEST_ROLLBACK_OFF = "derby.RawStore.RollbackTestOff";
    private static ContextService contextService;
    private T_Util t_util;

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        contextService = T_StreamFile.getContextService();
    }

    @Override
    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    @Override
    protected void setupTest() throws T_Fail {
        String string = PropertyUtil.getSystemProperty((String)TEST_ROLLBACK_OFF);
        boolean bl = testRollback = Boolean.valueOf(string) == false;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            factory = (RawStoreFactory)T_StreamFile.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
            if (factory == null) {
                throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
            }
            lf = factory.getLockFactory();
            if (lf == null) {
                throw T_Fail.testFailMsg("LockFactory.MODULE not found");
            }
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        this.t_util = new T_Util(factory, lf, contextService);
        commonContainer = this.commonContainer();
    }

    @Override
    protected void joinSetupTest() throws T_Fail {
        T_Fail.T_ASSERT(factory != null, "raw store factory not setup ");
        T_Fail.T_ASSERT(contextService != null, "Context service not setup ");
        T_Fail.T_ASSERT(commonContainer != -1L, "common container not setup ");
        this.t_util = new T_Util(factory, lf, contextService);
    }

    @Override
    protected T_MultiThreadedIterations newTestObject() {
        return new T_StreamFile();
    }

    @Override
    protected void runTestSet() throws T_Fail {
        ContextManager contextManager = contextService.newContextManager();
        contextService.setCurrentContextManager(contextManager);
        try {
            this.SF001(1, 13, 2, false);
            this.SF001(1, 1, 2, false);
            this.SF001(1000, 1, 2, false);
            this.SF001(1000, 2, 2, false);
            this.SF001(500, 9, 2, false);
            this.SF001(500, 13, 2, false);
            this.SF001(1000, 2, 2, true);
        }
        catch (StandardException standardException) {
            contextManager.cleanupOnError((Throwable)standardException, false);
            throw T_Fail.exceptionFail(standardException);
        }
        finally {
            contextService.resetCurrentContextManager(contextManager);
        }
    }

    private long commonContainer() throws T_Fail {
        long l;
        ContextManager contextManager = contextService.newContextManager();
        contextService.setCurrentContextManager(contextManager);
        try {
            Transaction transaction = this.t_util.t_startTransaction();
            l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        catch (StandardException standardException) {
            contextManager.cleanupOnError((Throwable)standardException, false);
            throw T_Fail.exceptionFail(standardException);
        }
        finally {
            contextService.resetCurrentContextManager(contextManager);
        }
        return l;
    }

    protected void SF001(int n, int n2, int n3, boolean bl) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        int n4 = -1;
        Properties properties = new Properties();
        properties.put("derby.storage.streamFileBufferSize", "16384");
        T_RowSource t_RowSource = null;
        t_RowSource = bl ? new T_RowSource(n, n2, n3, bl, transaction) : new T_RowSource(n, n2, n3, bl, null);
        long l = System.currentTimeMillis();
        long l2 = transaction.addAndLoadStreamContainer((long)n4, properties, (RowSource)t_RowSource);
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l;
        this.REPORT("SF001 - write: " + l4 + "ms");
        StreamContainerHandle streamContainerHandle = transaction.openStreamContainer((long)n4, l2, false);
        DataValueDescriptor[] dataValueDescriptorArray = null;
        dataValueDescriptorArray = t_RowSource.getTemplate();
        DataValueDescriptor[] dataValueDescriptorArray2 = null;
        dataValueDescriptorArray2 = t_RowSource.getTemplate();
        n4 = -1;
        int n5 = 0;
        l = System.currentTimeMillis();
        while (streamContainerHandle.fetchNext(dataValueDescriptorArray2)) {
            ++n5;
            if (dataValueDescriptorArray2.toString().equals(dataValueDescriptorArray.toString())) continue;
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + dataValueDescriptorArray.toString() + ": - got :" + dataValueDescriptorArray2.toString());
        }
        l3 = System.currentTimeMillis();
        l4 = l3 - l;
        if (n5 != n) {
            throw T_Fail.testFailMsg("incorrect number of row fetched.  Expecting " + n + " rows, got " + n5 + ", rows instead.");
        }
        this.REPORT("SF001 - fetch: " + l4 + "ms");
        streamContainerHandle.close();
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("SF001, rowCount = " + n + ", columnCount = " + n2 + ", clumn type: " + n3);
    }

    protected void SF002(int n) throws StandardException, T_Fail {
        T_RowSource t_RowSource = new T_RowSource(500000, 13, 2, false, null);
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(16384);
        FormatIdOutputStream formatIdOutputStream = new FormatIdOutputStream((OutputStream)dynamicByteArrayOutputStream);
        long l = System.currentTimeMillis();
        System.out.println("starting rowSource test, time: " + l);
        FormatableBitSet formatableBitSet = t_RowSource.getValidColumns();
        int n2 = 0;
        if (formatableBitSet != null) {
            for (int i = formatableBitSet.size() - 1; i >= 0; --i) {
                if (!formatableBitSet.get(i)) continue;
                n2 = i + 1;
                break;
            }
        }
        DataValueDescriptor[] dataValueDescriptorArray = t_RowSource.getNextRowFromRowSource();
        while (dataValueDescriptorArray != null) {
            int n3 = -1;
            for (int i = 0; i < n2; ++i) {
                if (!formatableBitSet.get(i)) continue;
                DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[++n3];
                if (n != 1) continue;
                try {
                    DataValueDescriptor dataValueDescriptor2 = dataValueDescriptor;
                    if (dataValueDescriptor2.isNull()) continue;
                    dataValueDescriptor2.writeExternal((ObjectOutput)formatIdOutputStream);
                    dynamicByteArrayOutputStream.reset();
                    continue;
                }
                catch (IOException iOException) {
                    throw T_Fail.exceptionFail(iOException);
                }
            }
            dataValueDescriptorArray = t_RowSource.getNextRowFromRowSource();
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (n != 1) {
            System.out.println("ended rowSource test, time: " + l2 + ", time spent = " + l3);
        } else {
            System.out.println("------ writeExternal called....\n ended rowSource test, time: " + l2 + ", time spent = " + l3);
        }
        this.PASS("SF002");
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
    }

    static {
        commonContainer = -1L;
    }
}

