/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.GetRootDseOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;

public abstract class BaseInterceptor
implements Interceptor {
    private String name;
    protected DirectoryService directoryService;
    protected SchemaManager schemaManager;
    protected DnFactory dnFactory;
    protected static final Set<AttributeType> PWD_POLICY_STATE_ATTRIBUTE_TYPES = new HashSet<AttributeType>();
    private final Interceptor finalInterceptor = new Interceptor(){
        private PartitionNexus nexus;

        @Override
        public String getName() {
            return "FINAL";
        }

        @Override
        public void init(DirectoryService directoryService) {
            this.nexus = directoryService.getPartitionNexus();
        }

        @Override
        public void destroy() {
        }

        @Override
        public void add(AddOperationContext addContext) throws LdapException {
            this.nexus.add(addContext);
        }

        @Override
        public void bind(BindOperationContext bindContext) throws LdapException {
        }

        @Override
        public boolean compare(CompareOperationContext compareContext) throws LdapException {
            return this.nexus.compare(compareContext);
        }

        @Override
        public void delete(DeleteOperationContext deleteContext) throws LdapException {
            this.nexus.delete(deleteContext);
        }

        @Override
        public Entry getRootDse(GetRootDseOperationContext getRootDseContext) throws LdapException {
            return this.nexus.getRootDse(getRootDseContext);
        }

        @Override
        public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
            return this.nexus.hasEntry(hasEntryContext);
        }

        @Override
        public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
            return this.nexus.lookup(lookupContext);
        }

        @Override
        public void modify(ModifyOperationContext modifyContext) throws LdapException {
            this.nexus.modify(modifyContext);
        }

        @Override
        public void move(MoveOperationContext moveContext) throws LdapException {
            this.nexus.move(moveContext);
        }

        @Override
        public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
            this.nexus.moveAndRename(moveAndRenameContext);
        }

        @Override
        public void rename(RenameOperationContext renameContext) throws LdapException {
            this.nexus.rename(renameContext);
        }

        @Override
        public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
            return this.nexus.search(searchContext);
        }

        @Override
        public void unbind(UnbindOperationContext unbindContext) throws LdapException {
            this.nexus.unbind(unbindContext);
        }
    };

    @Override
    public String getName() {
        return this.name;
    }

    public static LdapPrincipal getPrincipal(OperationContext opContext) {
        return opContext.getSession().getEffectivePrincipal();
    }

    protected BaseInterceptor() {
        this.name = this.getClass().getSimpleName();
    }

    protected BaseInterceptor(String name) {
        this.name = name;
    }

    protected BaseInterceptor(InterceptorEnum interceptor) {
        this.name = interceptor.getName();
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        this.directoryService = directoryService;
        this.schemaManager = directoryService.getSchemaManager();
        this.dnFactory = directoryService.getDnFactory();
        this.finalInterceptor.init(directoryService);
    }

    @Override
    public void destroy() {
    }

    protected Interceptor getNextInterceptor(OperationContext operationContext) {
        String currentInterceptor = operationContext.getNextInterceptor();
        if (currentInterceptor.equals("FINAL")) {
            return this.finalInterceptor;
        }
        return this.directoryService.getInterceptor(currentInterceptor);
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
    }

    protected final void next(AddOperationContext addContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(addContext);
        interceptor.add(addContext);
    }

    @Override
    public void bind(BindOperationContext bindContext) throws LdapException {
    }

    protected final void next(BindOperationContext bindContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(bindContext);
        interceptor.bind(bindContext);
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        return false;
    }

    protected final boolean next(CompareOperationContext compareContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(compareContext);
        return interceptor.compare(compareContext);
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
    }

    protected final void next(DeleteOperationContext deleteContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(deleteContext);
        interceptor.delete(deleteContext);
    }

    @Override
    public Entry getRootDse(GetRootDseOperationContext getRootDseContext) throws LdapException {
        return null;
    }

    protected final Entry next(GetRootDseOperationContext getRootDseContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(getRootDseContext);
        return interceptor.getRootDse(getRootDseContext);
    }

    @Override
    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        return false;
    }

    protected final boolean next(HasEntryOperationContext hasEntryContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(hasEntryContext);
        return interceptor.hasEntry(hasEntryContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        return this.next(lookupContext);
    }

    protected final Entry next(LookupOperationContext lookupContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(lookupContext);
        return interceptor.lookup(lookupContext);
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
    }

    protected final void next(ModifyOperationContext modifyContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(modifyContext);
        interceptor.modify(modifyContext);
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
    }

    protected final void next(MoveOperationContext moveContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(moveContext);
        interceptor.move(moveContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
    }

    protected final void next(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(moveAndRenameContext);
        interceptor.moveAndRename(moveAndRenameContext);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
    }

    protected final void next(RenameOperationContext renameContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(renameContext);
        interceptor.rename(renameContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        return null;
    }

    protected final EntryFilteringCursor next(SearchOperationContext searchContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(searchContext);
        return interceptor.search(searchContext);
    }

    @Override
    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
    }

    protected final void next(UnbindOperationContext unbindContext) throws LdapException {
        Interceptor interceptor = this.getNextInterceptor(unbindContext);
        interceptor.unbind(unbindContext);
    }
}

