/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.File;
import java.util.ArrayList;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportSchemasFromXmlWizardPage
extends AbstractWizardPage {
    private Text fromDirectoryText;
    private Button fromDirectoryButton;
    private CheckboxTableViewer schemaFilesTableViewer;
    private Button schemaFilesTableSelectAllButton;
    private Button schemaFilesTableDeselectAllButton;

    protected ImportSchemasFromXmlWizardPage() {
        super("ImportSchemasFromXmlWizardPage");
        this.setTitle(Messages.getString("ImportSchemasFromXmlWizardPage.ImportSchemasFromXML"));
        this.setDescription(Messages.getString("ImportSchemasFromXmlWizardPage.SelectXMLSchemaToImport"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/schemas_import_wizard.png"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group fromDirectoryGroup = new Group(composite, 0);
        fromDirectoryGroup.setText(Messages.getString("ImportSchemasFromXmlWizardPage.FromDirectory"));
        fromDirectoryGroup.setLayout((Layout)new GridLayout(3, false));
        fromDirectoryGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label fromDirectoryLabel = new Label((Composite)fromDirectoryGroup, 0);
        fromDirectoryLabel.setText(Messages.getString("ImportSchemasFromXmlWizardPage.FromDirectoryColon"));
        this.fromDirectoryText = new Text((Composite)fromDirectoryGroup, 2048);
        this.fromDirectoryText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fromDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportSchemasFromXmlWizardPage.this.dialogChanged();
            }
        });
        this.fromDirectoryButton = new Button((Composite)fromDirectoryGroup, 8);
        this.fromDirectoryButton.setText(Messages.getString("ImportSchemasFromXmlWizardPage.Browse"));
        this.fromDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSchemasFromXmlWizardPage.this.chooseFromDirectory();
            }
        });
        Group schemaFilesGroup = new Group(composite, 0);
        schemaFilesGroup.setText(Messages.getString("ImportSchemasFromXmlWizardPage.SchemaFiles"));
        schemaFilesGroup.setLayout((Layout)new GridLayout(2, false));
        schemaFilesGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.schemaFilesTableViewer = new CheckboxTableViewer(new Table((Composite)schemaFilesGroup, 67616));
        GridData schemasTableViewerGridData = new GridData(4, 0, true, false, 1, 2);
        schemasTableViewerGridData.heightHint = 125;
        this.schemaFilesTableViewer.getTable().setLayoutData((Object)schemasTableViewerGridData);
        this.schemaFilesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.schemaFilesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof File) {
                    return ((File)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof File) {
                    return Activator.getDefault().getImage("resources/icons/schema.gif");
                }
                return super.getImage(element);
            }
        });
        this.schemaFilesTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportSchemasFromXmlWizardPage.this.dialogChanged();
            }
        });
        this.schemaFilesTableSelectAllButton = new Button((Composite)schemaFilesGroup, 8);
        this.schemaFilesTableSelectAllButton.setText(Messages.getString("ImportSchemasFromXmlWizardPage.SelectAll"));
        this.schemaFilesTableSelectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.schemaFilesTableSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSchemasFromXmlWizardPage.this.schemaFilesTableViewer.setAllChecked(true);
                ImportSchemasFromXmlWizardPage.this.dialogChanged();
            }
        });
        this.schemaFilesTableDeselectAllButton = new Button((Composite)schemaFilesGroup, 8);
        this.schemaFilesTableDeselectAllButton.setText(Messages.getString("ImportSchemasFromXmlWizardPage.DeselectAll"));
        this.schemaFilesTableDeselectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.schemaFilesTableDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSchemasFromXmlWizardPage.this.schemaFilesTableViewer.setAllChecked(false);
                ImportSchemasFromXmlWizardPage.this.dialogChanged();
            }
        });
        this.initFields();
        this.dialogChanged();
        this.setControl((Control)composite);
    }

    private void initFields() {
        this.displayErrorMessage(null);
        this.setPageComplete(false);
    }

    private void chooseFromDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setText(Messages.getString("ImportSchemasFromXmlWizardPage.ChooseFolder"));
        dialog.setMessage(Messages.getString("ImportSchemasFromXmlWizardPage.SelectFolderToImportFrom"));
        if ("".equals(this.fromDirectoryText.getText())) {
            dialog.setFilterPath(Activator.getDefault().getPreferenceStore().getString(PluginConstants.FILE_DIALOG_IMPORT_SCHEMAS_XML));
        } else {
            dialog.setFilterPath(this.fromDirectoryText.getText());
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.fromDirectoryText.setText(selectedDirectory);
            this.fillInSchemaFilesTable(selectedDirectory);
        }
    }

    private void fillInSchemaFilesTable(String path) {
        ArrayList<File> schemaFiles = new ArrayList<File>();
        File selectedDirectory = new File(path);
        if (selectedDirectory.exists()) {
            File[] fileArray = selectedDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                if (fileName.endsWith(".xml")) {
                    schemaFiles.add(file);
                }
                ++n2;
            }
        }
        this.schemaFilesTableViewer.setInput(schemaFiles);
    }

    private void dialogChanged() {
        if (Activator.getDefault().getSchemaHandler() == null) {
            this.displayErrorMessage(Messages.getString("ImportSchemasFromXmlWizardPage.ErrorNoSchemaProjectOpen"));
            return;
        }
        String directory = this.fromDirectoryText.getText();
        if (directory == null || directory.equals("")) {
            this.displayErrorMessage(Messages.getString("ImportSchemasFromXmlWizardPage.ErrorNoDirectorySelected"));
            return;
        }
        File directoryFile = new File(directory);
        if (!directoryFile.exists()) {
            this.displayErrorMessage(Messages.getString("ImportSchemasFromXmlWizardPage.ErrorSelectedDirectoryNotExists"));
            return;
        }
        if (!directoryFile.isDirectory()) {
            this.displayErrorMessage(Messages.getString("ImportSchemasFromXmlWizardPage.ErrorSelectedDirectoryNotDirectory"));
            return;
        }
        if (!directoryFile.canRead()) {
            this.displayErrorMessage(Messages.getString("ImportSchemasFromXmlWizardPage.ErrorSelectedDirectoryNotReadable"));
            return;
        }
        if (this.schemaFilesTableViewer.getCheckedElements().length == 0) {
            this.displayErrorMessage(Messages.getString("ImportSchemasFromXmlWizardPage.ErrorNoSchemaSelected"));
            return;
        }
        this.displayErrorMessage(null);
    }

    public File[] getSelectedSchemaFiles() {
        Object[] selectedSchemaFile = this.schemaFilesTableViewer.getCheckedElements();
        ArrayList<File> schemaFiles = new ArrayList<File>();
        Object[] objectArray = selectedSchemaFile;
        int n = selectedSchemaFile.length;
        int n2 = 0;
        while (n2 < n) {
            Object schemaFile = objectArray[n2];
            schemaFiles.add((File)schemaFile);
            ++n2;
        }
        return schemaFiles.toArray(new File[0]);
    }

    public void saveDialogSettings() {
        Activator.getDefault().getPreferenceStore().putValue(PluginConstants.FILE_DIALOG_IMPORT_SCHEMAS_XML, this.fromDirectoryText.getText());
    }
}

