/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.jobs;

import org.apache.directory.studio.common.core.jobs.StudioJob;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StudioConnectionJob
extends StudioJob<StudioConnectionRunnableWithProgress> {
    public StudioConnectionJob(StudioConnectionRunnableWithProgress ... runnables) {
        super((StudioRunnableWithProgress[])runnables);
    }

    protected IStatus run(IProgressMonitor ipm) {
        StudioConnectionRunnableWithProgress runnable;
        StudioProgressMonitor monitor = new StudioProgressMonitor(ipm);
        StudioConnectionRunnableWithProgress[] studioConnectionRunnableWithProgressArray = (StudioConnectionRunnableWithProgress[])this.runnables;
        int n = studioConnectionRunnableWithProgressArray.length;
        int n2 = 0;
        while (n2 < n) {
            runnable = studioConnectionRunnableWithProgressArray[n2];
            Connection[] connections = runnable.getConnections();
            if (connections != null) {
                Connection[] connectionArray = connections;
                int n3 = connections.length;
                int n4 = 0;
                while (n4 < n3) {
                    Connection connection = connectionArray[n4];
                    if (connection != null && !connection.getConnectionWrapper().isConnected()) {
                        monitor.setTaskName(Messages.bind((String)Messages.jobs__open_connections_task, (Object[])new String[]{connection.getName()}));
                        monitor.worked(1);
                        connection.getConnectionWrapper().connect(monitor);
                        if (connection.getConnectionWrapper().isConnected()) {
                            connection.getConnectionWrapper().bind(monitor);
                        }
                        if (connection.getConnectionWrapper().isConnected()) {
                            for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                                listener.connectionOpened(connection, monitor);
                            }
                            ConnectionEventRegistry.fireConnectionOpened(connection, (Object)this);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (!monitor.errorsReported()) {
            try {
                studioConnectionRunnableWithProgressArray = (StudioConnectionRunnableWithProgress[])this.runnables;
                n = studioConnectionRunnableWithProgressArray.length;
                n2 = 0;
                while (n2 < n) {
                    runnable = studioConnectionRunnableWithProgressArray[n2];
                    if (runnable instanceof StudioConnectionBulkRunnableWithProgress) {
                        StudioConnectionBulkRunnableWithProgress bulkRunnable = (StudioConnectionBulkRunnableWithProgress)runnable;
                        this.suspendEventFiringInCurrentThread();
                        try {
                            bulkRunnable.run(monitor);
                        }
                        finally {
                            this.resumeEventFiringInCurrentThread();
                        }
                        bulkRunnable.runNotification(monitor);
                    } else {
                        runnable.run(monitor);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                monitor.reportError(e);
            }
        }
        monitor.done();
        ipm.done();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.errorsReported()) {
            return monitor.getErrorStatus(((StudioConnectionRunnableWithProgress[])this.runnables)[0].getErrorMessage());
        }
        return Status.OK_STATUS;
    }

    protected void suspendEventFiringInCurrentThread() {
        ConnectionEventRegistry.suspendEventFiringInCurrentThread();
    }

    protected void resumeEventFiringInCurrentThread() {
        ConnectionEventRegistry.resumeEventFiringInCurrentThread();
    }

    public boolean shouldSchedule() {
        StudioConnectionRunnableWithProgress[] studioConnectionRunnableWithProgressArray = (StudioConnectionRunnableWithProgress[])this.runnables;
        int n = studioConnectionRunnableWithProgressArray.length;
        int n2 = 0;
        while (n2 < n) {
            StudioConnectionRunnableWithProgress runnable = studioConnectionRunnableWithProgressArray[n2];
            Object[] myLockedObjects = runnable.getLockedObjects();
            String[] myLockedObjectsIdentifiers = this.getLockIdentifiers(myLockedObjects);
            Job[] jobs = StudioConnectionJob.getJobManager().find(null);
            int i = 0;
            while (i < jobs.length) {
                Job job = jobs[i];
                if (job instanceof StudioConnectionJob) {
                    StudioConnectionJob otherJob = (StudioConnectionJob)job;
                    StudioConnectionRunnableWithProgress[] studioConnectionRunnableWithProgressArray2 = (StudioConnectionRunnableWithProgress[])otherJob.runnables;
                    int n3 = studioConnectionRunnableWithProgressArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        StudioConnectionRunnableWithProgress otherRunnable = studioConnectionRunnableWithProgressArray2[n4];
                        if (runnable.getClass() == otherRunnable.getClass() && runnable != otherRunnable) {
                            Object[] otherLockedObjects = otherRunnable.getLockedObjects();
                            String[] otherLockedObjectIdentifiers = this.getLockIdentifiers(otherLockedObjects);
                            int j = 0;
                            while (j < otherLockedObjectIdentifiers.length) {
                                String other = otherLockedObjectIdentifiers[j];
                                int k = 0;
                                while (k < myLockedObjectsIdentifiers.length) {
                                    String my = myLockedObjectsIdentifiers[k];
                                    if (other.startsWith(my) || my.startsWith(other)) {
                                        return false;
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                        }
                        ++n4;
                    }
                }
                ++i;
            }
            ++n2;
        }
        return super.shouldSchedule();
    }

    protected String[] getLockIdentifiers(Object[] objects) {
        String[] identifiers = new String[objects.length];
        int i = 0;
        while (i < identifiers.length) {
            Object o = objects[i];
            identifiers[i] = o instanceof Connection ? this.getLockIdentifier((Connection)o) : this.getLockIdentifier(objects[i]);
            ++i;
        }
        return identifiers;
    }

    private String getLockIdentifier(Connection connection) {
        return String.valueOf(connection.getHost()) + ':' + connection.getPort();
    }

    private String getLockIdentifier(Object object) {
        String s = object != null ? object.toString() : "null";
        s = String.valueOf('-') + s;
        return s;
    }
}

