import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { NumberInput } from "@patternfly/react-core/dist/js/components/NumberInput";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { ToggleGroup, ToggleGroupItem } from "@patternfly/react-core/dist/js/components/ToggleGroup";
import { PencilAltIcon } from "@patternfly/react-icons/dist/js/icons/pencil-alt-icon";
import { UndoAltIcon } from "@patternfly/react-icons/dist/js/icons/undo-alt-icon";
import * as React from "react";
import { useCallback, useEffect, useMemo, useState } from "react";
import { useDmnEditor } from "../DmnEditorContext";
import { addOrGetDrd } from "../mutations/addOrGetDrd";
import { useInViewSelect } from "../responsiveness/useInViewSelect";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { ColorPicker } from "./ColorPicker";
import { PropertiesPanelHeader } from "./PropertiesPanelHeader";
import "./FontOptions.css";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useSettings } from "../settings/DmnEditorSettingsContext";
const WEBSAFE_FONTS_LIST = [
    "Arial",
    "Verdana",
    "Tahoma",
    "Trebuchet MS",
    "Times New Roman",
    "Georgia",
    "Garamond",
    "Courier New",
    "Brush Script MT",
];
const DEFAULT_FONT_COLOR = { "@_blue": 0, "@_green": 0, "@_red": 0 };
const DEFAULT_FONT_SIZE = 16;
const MAX_FONT_SIZE = 72;
const MIN_FONT_SIZE = 0;
var FontStyleToggleOptions;
(function (FontStyleToggleOptions) {
    FontStyleToggleOptions["BOLD"] = "bold";
    FontStyleToggleOptions["ITALIC"] = "italic";
    FontStyleToggleOptions["UNDERLINE"] = "underline";
    FontStyleToggleOptions["STRIKE_THROUGH"] = "strike-through";
    FontStyleToggleOptions["FONT_COLOR"] = "font-color";
})(FontStyleToggleOptions || (FontStyleToggleOptions = {}));
export function FontOptions({ startExpanded, nodeIds }) {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const shapeStyles = useDmnEditorStore((s) => nodeIds.map((nodeId) => { var _a; return (_a = s.computed(s).indexedDrd().dmnShapesByHref.get(nodeId)) === null || _a === void 0 ? void 0 : _a["di:Style"]; }));
    const fontFamily = useMemo(() => { var _a; return (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontFamily"]; }, [shapeStyles]);
    const isFontBold = useMemo(() => { var _a, _b; return (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontBold"]) !== null && _b !== void 0 ? _b : false; }, [shapeStyles]);
    const isFontItalic = useMemo(() => { var _a, _b; return (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontItalic"]) !== null && _b !== void 0 ? _b : false; }, [shapeStyles]);
    const isFontUnderline = useMemo(() => { var _a; return (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontUnderline"]; }, [shapeStyles]);
    const isFontStrikeThrough = useMemo(() => { var _a, _b; return (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontStrikeThrough"]) !== null && _b !== void 0 ? _b : false; }, [shapeStyles]);
    const fontSize = useMemo(() => { var _a, _b; return (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontSize"]) !== null && _b !== void 0 ? _b : DEFAULT_FONT_SIZE; }, [shapeStyles]);
    const fontColor = useMemo(() => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const b = ((_c = (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["dmndi:FontColor"]) === null || _b === void 0 ? void 0 : _b["@_blue"]) !== null && _c !== void 0 ? _c : DEFAULT_FONT_COLOR["@_blue"]).toString(16);
        const g = ((_f = (_e = (_d = shapeStyles[0]) === null || _d === void 0 ? void 0 : _d["dmndi:FontColor"]) === null || _e === void 0 ? void 0 : _e["@_green"]) !== null && _f !== void 0 ? _f : DEFAULT_FONT_COLOR["@_green"]).toString(16);
        const r = ((_j = (_h = (_g = shapeStyles[0]) === null || _g === void 0 ? void 0 : _g["dmndi:FontColor"]) === null || _h === void 0 ? void 0 : _h["@_red"]) !== null && _j !== void 0 ? _j : DEFAULT_FONT_COLOR["@_red"]).toString(16);
        return `#${r.length === 1 ? "0" + r : r}${g.length === 1 ? "0" + g : g}${b.length === 1 ? "0" + b : b}`;
    }, [shapeStyles]);
    const [isStyleSectionExpanded, setStyleSectionExpanded] = useState(startExpanded);
    const setShapeStyles = useCallback((callback) => {
        dmnEditorStoreApi.setState((s) => {
            var _a;
            const { diagramElements } = addOrGetDrd({
                definitions: s.dmn.model.definitions,
                drdIndex: s.computed(s).getDrdIndex(),
            });
            const shapes = nodeIds.map((nodeId) => {
                const shape = s.computed(s).indexedDrd().dmnShapesByHref.get(nodeId);
                if (!shape) {
                    throw new Error(`DMN Shape for '${nodeId}' does not exist.`);
                }
                return diagramElements[shape.index];
            });
            for (const shape of shapes) {
                (_a = shape["di:Style"]) !== null && _a !== void 0 ? _a : (shape["di:Style"] = { "@_id": generateUuid(), __$$element: "dmndi:DMNStyle" });
            }
            callback(shapes, s);
        });
    }, [dmnEditorStoreApi, nodeIds]);
    const { dmnEditorRootElementRef } = useDmnEditor();
    const toggleRef = React.useRef(null);
    const inViewTimezoneSelect = useInViewSelect(dmnEditorRootElementRef, toggleRef);
    const [isFontFamilySelectOpen, setFontFamilySelectOpen] = useState(false);
    const onSelectFont = useCallback((e, value, isPlaceholder) => {
        if (isPlaceholder) {
            setShapeStyles((shapes) => {
                shapes.forEach((shape, i, shapes) => {
                    var _a;
                    var _b;
                    (_a = (_b = shape["di:Style"])["@_fontFamily"]) !== null && _a !== void 0 ? _a : (_b["@_fontFamily"] = undefined);
                });
            });
        }
        else {
            setShapeStyles((shapes) => {
                shapes.forEach((shape, i, shapes) => {
                    shape["di:Style"]["@_fontFamily"] = value;
                });
            });
        }
    }, [setShapeStyles]);
    const validateFontSize = useCallback((value) => {
        if (value === undefined) {
            return DEFAULT_FONT_SIZE;
        }
        if (value >= MAX_FONT_SIZE) {
            return MAX_FONT_SIZE;
        }
        if (value <= MIN_FONT_SIZE) {
            return MIN_FONT_SIZE;
        }
        return value;
    }, []);
    const onMinus = useCallback(() => {
        setShapeStyles((shapes) => {
            shapes.forEach((shape) => {
                var _a, _b;
                shape["di:Style"]["@_fontSize"] = validateFontSize(((_b = (_a = shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontSize"]) !== null && _b !== void 0 ? _b : DEFAULT_FONT_SIZE) - 1);
            });
        });
    }, [setShapeStyles, validateFontSize]);
    const onChange = useCallback((event) => {
        setShapeStyles((shapes) => {
            shapes.forEach((shape) => {
                shape["di:Style"]["@_fontSize"] = +event.target.value;
            });
        });
    }, [setShapeStyles]);
    const onPlus = useCallback(() => {
        setShapeStyles((shapes) => {
            shapes.forEach((shape) => {
                var _a, _b;
                shape["di:Style"]["@_fontSize"] = validateFontSize(((_b = (_a = shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontSize"]) !== null && _b !== void 0 ? _b : DEFAULT_FONT_SIZE) + 1);
            });
        });
    }, [setShapeStyles, validateFontSize]);
    const onChangeBold = useCallback(() => {
        setShapeStyles((shapes) => {
            shapes.forEach((shape) => {
                var _a, _b;
                shape["di:Style"]["@_fontBold"] = (_b = !((_a = shape === null || shape === void 0 ? void 0 : shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontBold"])) !== null && _b !== void 0 ? _b : true;
            });
        });
    }, [setShapeStyles]);
    const onChangeItalic = useCallback(() => {
        setShapeStyles((shapes) => {
            shapes.forEach((shape) => {
                var _a, _b;
                shape["di:Style"]["@_fontItalic"] = (_b = !((_a = shape === null || shape === void 0 ? void 0 : shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontItalic"])) !== null && _b !== void 0 ? _b : true;
            });
        });
    }, [setShapeStyles]);
    const onChangeUnderline = useCallback(() => {
        setShapeStyles((shapes) => {
            shapes.forEach((shape) => {
                var _a, _b;
                shape["di:Style"]["@_fontUnderline"] = (_b = !((_a = shape === null || shape === void 0 ? void 0 : shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontUnderline"])) !== null && _b !== void 0 ? _b : true;
            });
        });
    }, [setShapeStyles]);
    const onChangeStrikeThrough = useCallback(() => {
        setShapeStyles((shapes) => {
            shapes.forEach((shape) => {
                var _a, _b;
                shape["di:Style"]["@_fontStrikeThrough"] = (_b = !((_a = shape === null || shape === void 0 ? void 0 : shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontStrikeThrough"])) !== null && _b !== void 0 ? _b : true;
            });
        });
    }, [setShapeStyles]);
    const colorPickerRef = React.useRef(null);
    const [temporaryFontColor, setTemporaryFontColor] = useState();
    const onChangeColor = useCallback((newColor) => {
        setTemporaryFontColor(newColor.replace("#", ""));
        setShapeStyles((shapes, state) => {
            state.diagram.isEditingStyle = true;
        });
    }, [setShapeStyles]);
    useEffect(() => {
        const timeout = setTimeout(() => {
            if (!temporaryFontColor) {
                return;
            }
            setTemporaryFontColor(undefined);
            setShapeStyles((shapes, state) => {
                shapes.forEach((shape) => {
                    var _a;
                    var _b;
                    state.diagram.isEditingStyle = false;
                    (_a = (_b = shape["di:Style"])["dmndi:FontColor"]) !== null && _a !== void 0 ? _a : (_b["dmndi:FontColor"] = { ...DEFAULT_FONT_COLOR });
                    shape["di:Style"]["dmndi:FontColor"]["@_red"] = parseInt(temporaryFontColor.slice(0, 2), 16);
                    shape["di:Style"]["dmndi:FontColor"]["@_green"] = parseInt(temporaryFontColor.slice(2, 4), 16);
                    shape["di:Style"]["dmndi:FontColor"]["@_blue"] = parseInt(temporaryFontColor.slice(4, 6), 16);
                });
            });
        }, 0);
        return () => {
            clearTimeout(timeout);
        };
    }, [setShapeStyles, temporaryFontColor]);
    const onReset = useCallback(() => {
        setShapeStyles((shapes, state) => {
            state.diagram.isEditingStyle = false;
            shapes.forEach((shape) => {
                shape["di:Style"]["@_fontBold"] = undefined;
                shape["di:Style"]["@_fontItalic"] = undefined;
                shape["di:Style"]["@_fontUnderline"] = undefined;
                shape["di:Style"]["@_fontStrikeThrough"] = undefined;
                shape["di:Style"]["@_fontSize"] = undefined;
                shape["di:Style"]["@_fontFamily"] = undefined;
                shape["di:Style"]["dmndi:FontColor"] = { ...DEFAULT_FONT_COLOR };
            });
        });
    }, [setShapeStyles]);
    return (_jsxs(_Fragment, { children: [_jsx(PropertiesPanelHeader, { icon: _jsx(PencilAltIcon, { width: 16, height: 36, style: { marginLeft: "12px" } }), expands: true, fixed: false, isSectionExpanded: isStyleSectionExpanded, toogleSectionExpanded: () => setStyleSectionExpanded((prev) => !prev), title: "Font", action: _jsx(Button, { variant: ButtonVariant.plain, isDisabled: settings.isReadOnly, onClick: () => onReset(), style: { paddingBottom: 0, paddingTop: 0 }, title: "Reset font", children: _jsx(UndoAltIcon, {}) }) }), isStyleSectionExpanded && (_jsx(FormSection, { style: { paddingLeft: "20px", marginTop: "0px" }, children: _jsxs("div", { style: { display: "flex", flexDirection: "column" }, children: [_jsxs("div", { className: "kie-dmn-editor--font-options-toggle-group", children: [_jsx(NumberInput, { "aria-label": "Font size", className: "kie-dmn-editor--font-options-toggle-group-item-number-input", value: fontSize, isDisabled: settings.isReadOnly, widthChars: 2, onMinus: onMinus, onChange: onChange, onPlus: onPlus, inputName: "Font size", inputAriaLabel: "Font size", minusBtnAriaLabel: "minus", plusBtnAriaLabel: "plus" }), _jsxs(ToggleGroup, { areAllGroupsDisabled: false, "aria-label": "Default with multiple selectable", children: [_jsx(ToggleGroupItem, { "aria-label": "Toggle font bold", className: "kie-dmn-editor--font-options-toggle-group-item", text: _jsx("div", { children: _jsx("b", { children: "B" }) }), isDisabled: settings.isReadOnly, buttonId: FontStyleToggleOptions.BOLD, isSelected: isFontBold, onChange: onChangeBold }, FontStyleToggleOptions.BOLD), _jsx(ToggleGroupItem, { "aria-label": "Toggle font italic", className: "kie-dmn-editor--font-options-toggle-group-item-italic", text: _jsx("div", { children: _jsx("i", { style: { fontFamily: "serif" }, children: "I" }) }), isDisabled: settings.isReadOnly, buttonId: FontStyleToggleOptions.ITALIC, isSelected: isFontItalic, onChange: onChangeItalic }, FontStyleToggleOptions.ITALIC), _jsx(ToggleGroupItem, { className: "kie-dmn-editor--font-options-toggle-group-item", text: _jsx("div", { children: _jsx("u", { children: "U" }) }), isDisabled: settings.isReadOnly, "aria-label": "Toggle font underline", buttonId: FontStyleToggleOptions.UNDERLINE, isSelected: isFontUnderline, onChange: onChangeUnderline }, FontStyleToggleOptions.UNDERLINE), _jsx(ToggleGroupItem, { className: "kie-dmn-editor--font-options-toggle-group-item", text: _jsx("div", { children: _jsx("p", { style: { textDecoration: "line-through" }, children: "S" }) }), isDisabled: settings.isReadOnly, "aria-label": "Toggle font strike through", buttonId: FontStyleToggleOptions.STRIKE_THROUGH, isSelected: isFontStrikeThrough, onChange: onChangeStrikeThrough }, FontStyleToggleOptions.STRIKE_THROUGH), _jsx(ToggleGroupItem, { className: "kie-dmn-editor--font-options-toggle-group-item-color-picker", "aria-label": "Font color", buttonId: FontStyleToggleOptions.FONT_COLOR, onClick: () => { var _a; return (_a = colorPickerRef.current) === null || _a === void 0 ? void 0 : _a.click(); }, text: _jsx(ColorPicker, { name: "font", icon: _jsx("p", { children: "A" }), colorPickerRef: colorPickerRef, color: fontColor, onChange: onChangeColor, isDisabled: settings.isReadOnly }), isDisabled: settings.isReadOnly }, FontStyleToggleOptions.FONT_COLOR)] })] }), _jsx("br", {}), _jsx("div", { "data-testid": "kie-tools--dmn-editor--properties-panel-node-font-style", children: _jsx(Select, { toggleRef: toggleRef, variant: SelectVariant.single, "aria-label": "Select font style", isOpen: isFontFamilySelectOpen, onSelect: onSelectFont, onToggle: () => setFontFamilySelectOpen((prev) => !prev), selections: fontFamily !== null && fontFamily !== void 0 ? fontFamily : "", isDisabled: settings.isReadOnly, maxHeight: inViewTimezoneSelect.maxHeight, direction: inViewTimezoneSelect.direction, children: WEBSAFE_FONTS_LIST.map((fontName, index) => (_jsx(SelectOption, { value: fontName, style: { fontFamily: fontName } }, index))) }) })] }) }))] }));
}
//# sourceMappingURL=FontOptions.js.map