import JSONata from "jsonata";
import * as XMLJS from "xml-js";
import { JSON2UI_TRANSFORMATION as json2ui } from "./jsonata/JSON2UI";
import { anomalyDetectionModelFactory } from "./jsonata/json2ui/AnomalyDetectionModel";
import { associationModelFactory } from "./jsonata/json2ui/AssociationModel";
import { baselineModelFactory } from "./jsonata/json2ui/BaselineModel";
import { bayesianNetworkModelFactory } from "./jsonata/json2ui/BayesianNetworkModel";
import { clusteringModelFactory } from "./jsonata/json2ui/ClusteringModel";
import { gaussianProcessModelFactory } from "./jsonata/json2ui/GaussianProcessModel";
import { generalRegressionModelFactory } from "./jsonata/json2ui/GeneralRegressionModel";
import { miningModelFactory } from "./jsonata/json2ui/MiningModel";
import { naiveBayesModelFactory } from "./jsonata/json2ui/NaiveBayesModel";
import { nearestNeighborModelFactory } from "./jsonata/json2ui/NearestNeighborModel";
import { neuralNetworkFactory } from "./jsonata/json2ui/NeuralNetwork";
import { regressionModelFactory } from "./jsonata/json2ui/RegressionModel";
import { ruleSetModelFactory } from "./jsonata/json2ui/RuleSetModel";
import { scorecardFactory } from "./jsonata/json2ui/Scorecard";
import { sequenceModelFactory } from "./jsonata/json2ui/SequenceModel";
import { supportVectorMachineModelFactory } from "./jsonata/json2ui/SupportVectorMachineModel";
import { textModelFactory } from "./jsonata/json2ui/TextModel";
import { timeSeriesModelFactory } from "./jsonata/json2ui/TimeSeriesModel";
import { treeModelFactory } from "./jsonata/json2ui/TreeModel";
import { UI2JSON_TRANSFORMATION as ui2json } from "./jsonata/UI2JSON";
import { CompoundPredicate, False, SimplePredicate, True } from "./model/pmml4_4";
export function XML2PMML(xml) {
    const doc = XMLJS.xml2js(xml);
    const expression = JSONata(json2ui);
    expression.registerFunction("merge", merge);
    expression.registerFunction("singletonArray", singletonArray);
    expression.registerFunction("anomalyDetectionModelFactory", anomalyDetectionModelFactory);
    expression.registerFunction("associationModelFactory", associationModelFactory);
    expression.registerFunction("baselineModelFactory", baselineModelFactory);
    expression.registerFunction("bayesianNetworkModelFactory", bayesianNetworkModelFactory);
    expression.registerFunction("clusteringModelFactory", clusteringModelFactory);
    expression.registerFunction("gaussianProcessModelFactory", gaussianProcessModelFactory);
    expression.registerFunction("generalRegressionModelFactory", generalRegressionModelFactory);
    expression.registerFunction("miningModelFactory", miningModelFactory);
    expression.registerFunction("naiveBayesModelFactory", naiveBayesModelFactory);
    expression.registerFunction("nearestNeighborModelFactory", nearestNeighborModelFactory);
    expression.registerFunction("neuralNetworkFactory", neuralNetworkFactory);
    expression.registerFunction("regressionModelFactory", regressionModelFactory);
    expression.registerFunction("ruleSetModelFactory", ruleSetModelFactory);
    expression.registerFunction("scorecardFactory", scorecardFactory);
    expression.registerFunction("sequenceModelFactory", sequenceModelFactory);
    expression.registerFunction("supportVectorMachineModelFactory", supportVectorMachineModelFactory);
    expression.registerFunction("textModelFactory", textModelFactory);
    expression.registerFunction("timeSeriesModelFactory", timeSeriesModelFactory);
    expression.registerFunction("treeModelFactory", treeModelFactory);
    expression.registerFunction("json2uiSimplePredicateFactory", json2uiSimplePredicateFactory);
    expression.registerFunction("json2uiCompoundPredicateFactory", json2uiCompoundPredicateFactory);
    expression.registerFunction("json2uiTruePredicateFactory", json2uiTruePredicateFactory);
    expression.registerFunction("json2uiFalsePredicateFactory", json2uiFalsePredicateFactory);
    const pmml = expression.evaluate(doc);
    return pmml;
}
function merge(arg) {
    if (typeof arg === undefined) {
        return undefined;
    }
    const result = clone(arg[0]);
    arg.forEach((obj) => {
        for (const prop in obj) {
            result[prop] = obj[prop];
        }
    });
    return result;
}
function clone(obj) {
    if (obj === null || typeof obj !== "object") {
        return obj;
    }
    const temp = new obj.constructor(obj);
    for (const key in obj) {
        temp[key] = clone(obj[key]);
    }
    return temp;
}
function singletonArray(value) {
    if (value === undefined || value === null) {
        return [];
    }
    if (Array.isArray(value)) {
        return value;
    }
    return [value];
}
function json2uiSimplePredicateFactory() {
    return new SimplePredicate({ field: "", operator: "equal" });
}
function json2uiCompoundPredicateFactory() {
    return new CompoundPredicate({ booleanOperator: "and" });
}
function json2uiTruePredicateFactory() {
    return new True({});
}
function json2uiFalsePredicateFactory() {
    return new False({});
}
export function PMML2XML(pmml) {
    const expression = JSONata(ui2json);
    expression.registerFunction("singletonArray", singletonArray);
    const json = expression.evaluate(pmml);
    const xml = XMLJS.js2xml(json, { spaces: 2 });
    return xml;
}
//# sourceMappingURL=Marshaller.js.map