import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useContext, useMemo, useRef } from "react";
const TestScenarioEditorContext = React.createContext({});
export function useTestScenarioEditor() {
    return useContext(TestScenarioEditorContext);
}
export function TestScenarioEditorContextProvider(props) {
    const testScenarioEditorModelBeforeEditingRef = useRef(props.model);
    const testScenarioEditorRootElementRef = useRef(null);
    const value = useMemo(() => ({
        issueTrackerHref: props.issueTrackerHref,
        testScenarioEditorModelBeforeEditingRef,
        testScenarioEditorRootElementRef,
        onRequestToJumpToPath: props.onRequestToJumpToPath,
        onRequestToResolvePath: props.onRequestToResolvePath,
        openFileNormalizedPosixPathRelativeToTheWorkspaceRoot: props.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot,
    }), [
        props.issueTrackerHref,
        props.onRequestToJumpToPath,
        props.onRequestToResolvePath,
        props.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot,
    ]);
    return _jsx(TestScenarioEditorContext.Provider, { value: value, children: props.children });
}
//# sourceMappingURL=TestScenarioEditorContext.js.map