import { handleProcessAbort, handleProcessMultipleAction, handleProcessSkip, handleProcessRetry, getProcessInstances, getChildProcessInstances, } from "@kie-tools/runtime-tools-process-gateway-api/dist/gatewayApi";
export class GraphQLProcessListQueries {
    constructor(client, options) {
        this.client = client;
        this.options = options;
    }
    getProcessInstances(offset, limit, filters, sortBy) {
        return getProcessInstances(offset, limit, filters, sortBy, this.client).then((processInstances) => {
            return processInstances.map((process) => {
                var _a, _b, _c, _d, _e, _f;
                return ({
                    ...process,
                    endpoint: (_c = (_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.transformEndpointBaseUrl) === null || _b === void 0 ? void 0 : _b.call(_a, process.endpoint)) !== null && _c !== void 0 ? _c : process.endpoint,
                    serviceUrl: (_f = (_e = (_d = this.options) === null || _d === void 0 ? void 0 : _d.transformEndpointBaseUrl) === null || _e === void 0 ? void 0 : _e.call(_d, process.serviceUrl)) !== null && _f !== void 0 ? _f : process.serviceUrl,
                });
            });
        });
    }
    getChildProcessInstances(rootProcessInstanceId) {
        return getChildProcessInstances(rootProcessInstanceId, this.client);
    }
    async handleProcessSkip(processInstance) {
        return handleProcessSkip(processInstance, this.client);
    }
    async handleProcessAbort(processInstance) {
        return handleProcessAbort(processInstance, this.client);
    }
    async handleProcessRetry(processInstance) {
        return handleProcessRetry(processInstance, this.client);
    }
    async handleProcessMultipleAction(processInstances, operationType) {
        return handleProcessMultipleAction(processInstances, operationType, this.client);
    }
}
//# sourceMappingURL=ProcessListQueries.js.map