export type XmlParserTs<T extends object> = {
    parse: (args: {
        type: "xml";
        xml: string | Buffer;
    } | {
        type: "domdoc";
        domdoc: Document;
        instanceNs: Map<string, string>;
    }) => {
        json: T;
        instanceNs: Map<string, string>;
    };
    build: (args: {
        json: T;
        instanceNs: Map<string, string>;
    }) => string;
};
export type XmlParserTsRootElementBaseType = Partial<{
    [k: `@_xmlns:${string}`]: string;
}> & {
    "@_xmlns"?: string;
};
export type XmlDocument = {
    "?xml"?: {
        "@_encoding"?: string;
        "@_version"?: string;
    };
};
export type MetaTypeProp = {
    type: string;
    isArray: boolean;
    fromType: string;
    xsdType: string;
};
export type MetaType = Record<string, MetaTypeProp>;
export type Meta = Record<string, MetaType>;
export type Root = {
    element: string;
    type: string;
};
export type Subs = Record<string, Record<string, string>>;
export type Elements = Record<string, string>;
export declare const domParser: {
    getDomDocument: (xml: string | Buffer) => Document;
};
export declare function getInstanceNs(domdoc: Document): Map<string, string>;
export declare function getInstanceNsFromJson(rootElement: XmlParserTsRootElementBaseType): Map<string, string>;
export declare function getParser<T extends object>(args: {
    meta: Meta;
    subs: Subs;
    elements: Elements;
    ns: Map<string, string>;
    root: Root;
}): XmlParserTs<T>;
export declare function parse(args: {
    node: Node;
    nodeMetaType: MetaType | undefined;
    ns: Map<string, string>;
    instanceNs: Map<string, string>;
    meta: Meta;
    elements: Elements;
    subs: Subs;
}): any;
export declare function resolveElement(name: string, parentMetaType: MetaType | undefined, { ns, instanceNs, subs, }: {
    ns: Map<string, string>;
    instanceNs: Map<string, string>;
    subs: Subs;
}): {
    nsedName: string;
    subsedName: string;
};
export declare function build(args: {
    json: any;
    ns: Map<string, string>;
    instanceNs: Map<string, string>;
    elements: Elements;
    meta: Meta;
    metaType: MetaType | undefined;
    indent: string;
}): string;
export type NamespacedProperty<P extends string, K> = K extends string ? K extends `@_${string}` | `${string}:${string}` | "__$$text" | "__$$element" ? K : `${P}:${K}` : never;
export type Namespaced<P extends string, T> = {
    [K in keyof T as NamespacedProperty<P, K>]: NonNullable<T[K]> extends Array<infer R> ? Array<Namespaced<P, R>> : T[K];
};
export declare function mergeMetas(base: Meta, extensionMetasByPrefix: [string, Meta][]): void;
//# sourceMappingURL=index.d.ts.map