import { jsx as _jsx } from "react/jsx-runtime";
import { ChannelType, DEFAULT_WORKSPACE_ROOT_ABSOLUTE_POSIX_PATH, } from "@kie-tools-core/editor/dist/api";
import { DmnEditorInterface, DmnEditorRootWrapper } from "./DmnEditorFactory";
export class NewDmnEditorFactory {
    createEditor(envelopeContext, initArgs) {
        return Promise.resolve(new NewDmnEditorInterface(envelopeContext, initArgs));
    }
}
export class NewDmnEditorInterface extends DmnEditorInterface {
    openBoxedExpressionEditor(nodeId) {
        this.self.openBoxedExpressionEditor(nodeId);
    }
    showDmnEvaluationResults(evaluationResultsByNodeId) {
        this.self.showDmnEvaluationResults(evaluationResultsByNodeId);
    }
    af_componentRoot() {
        var _a;
        return (_jsx(DmnEditorRootWrapper, { exposing: (dmnEditorRoot) => (this.self = dmnEditorRoot), envelopeContext: this.envelopeContext, workspaceRootAbsolutePosixPath: (_a = this.initArgs.workspaceRootAbsolutePosixPath) !== null && _a !== void 0 ? _a : DEFAULT_WORKSPACE_ROOT_ABSOLUTE_POSIX_PATH, isEvaluationHighlightsSupported: this.initArgs.channel === ChannelType.ONLINE || this.initArgs.channel === ChannelType.ONLINE_MULTI_FILE, isReadOnly: this.initArgs.isReadOnly, onOpenedBoxedExpressionEditorNodeChange: (newOpenedNodeId) => {
                var _a;
                (_a = this.envelopeContext) === null || _a === void 0 ? void 0 : _a.shared.newDmnEditor_openedBoxedExpressionEditorNodeId.set(newOpenedNodeId);
            } }));
    }
}
//# sourceMappingURL=NewDmnEditorFactory.js.map