/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.polaris.service.auth.KeyProvider;
import org.apache.polaris.service.auth.PemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRSAKeyProvider
implements KeyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalRSAKeyProvider.class);
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public LocalRSAKeyProvider(@Nonnull KeyPair keyPair) {
        this(keyPair.getPublic(), keyPair.getPrivate());
    }

    public LocalRSAKeyProvider(@Nonnull PublicKey publicKey, @Nonnull PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public static LocalRSAKeyProvider fromFiles(@Nonnull Path publicKeyFile, @Nonnull Path privateKeyFile) {
        return new LocalRSAKeyProvider(LocalRSAKeyProvider.readPublicKeyFile(publicKeyFile), LocalRSAKeyProvider.readPrivateKeyFile(privateKeyFile));
    }

    private static PrivateKey readPrivateKeyFile(Path privateKeyFileLocation) {
        try {
            return PemUtils.readPrivateKeyFromFile(privateKeyFileLocation, "RSA");
        }
        catch (IOException e) {
            LOGGER.error("Unable to read private key from file {}", (Object)privateKeyFileLocation, (Object)e);
            throw new RuntimeException("Unable to read private key from file " + String.valueOf(privateKeyFileLocation), e);
        }
    }

    private static PublicKey readPublicKeyFile(Path publicKeyFileLocation) {
        try {
            return PemUtils.readPublicKeyFromFile(publicKeyFileLocation, "RSA");
        }
        catch (IOException e) {
            LOGGER.error("Unable to read public key from file {}", (Object)publicKeyFileLocation, (Object)e);
            throw new RuntimeException("Unable to read public key from file " + String.valueOf(publicKeyFileLocation), e);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

