/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.builders;

import io.quarkus.oidc.OidcTenantConfigBuilder;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class AuthenticationConfigBuilder {
    private final OidcTenantConfigBuilder builder;
    private final Map<String, String> extraParams = new HashMap<String, String>();
    private final List<String> forwardParams = new ArrayList<String>();
    private final List<String> scopes = new ArrayList<String>();
    private Optional<OidcTenantConfig.Authentication.ResponseMode> responseMode;
    private Optional<String> redirectPath;
    private boolean restorePathAfterRedirect;
    private boolean removeRedirectParameters;
    private Optional<String> errorPath;
    private Optional<String> sessionExpiredPath;
    private boolean verifyAccessToken;
    private Optional<Boolean> forceRedirectHttpsScheme;
    private Optional<String> scopeSeparator;
    private boolean nonceRequired;
    private Optional<Boolean> addOpenidScope;
    private boolean cookieForceSecure;
    private Optional<String> cookieSuffix;
    private String cookiePath;
    private Optional<String> cookiePathHeader;
    private Optional<String> cookieDomain;
    private OidcTenantConfig.Authentication.CookieSameSite cookieSameSite;
    private boolean allowMultipleCodeFlows;
    private boolean failOnMissingStateParam;
    private boolean failOnUnresolvedKid;
    private Optional<Boolean> userInfoRequired;
    private Duration sessionAgeExtension;
    private Duration stateCookieAge;
    private boolean javaScriptAutoRedirect;
    private Optional<Boolean> idTokenRequired;
    private Optional<Duration> internalIdTokenLifespan;
    private Optional<Boolean> pkceRequired;
    private Optional<String> pkceSecret;
    private Optional<String> stateSecret;

    public AuthenticationConfigBuilder() {
        this(new OidcTenantConfigBuilder());
    }

    public AuthenticationConfigBuilder(OidcTenantConfigBuilder builder) {
        this.builder = Objects.requireNonNull(builder);
        OidcTenantConfig.Authentication authentication = builder.getAuthentication();
        this.extraParams.putAll(authentication.extraParams());
        if (authentication.forwardParams().isPresent()) {
            this.forwardParams.addAll((Collection<String>)authentication.forwardParams().get());
        }
        if (authentication.scopes().isPresent()) {
            this.scopes.addAll((Collection<String>)authentication.scopes().get());
        }
        this.responseMode = authentication.responseMode();
        this.redirectPath = authentication.redirectPath();
        this.restorePathAfterRedirect = authentication.restorePathAfterRedirect();
        this.removeRedirectParameters = authentication.removeRedirectParameters();
        this.errorPath = authentication.errorPath();
        this.sessionExpiredPath = authentication.sessionExpiredPath();
        this.verifyAccessToken = authentication.verifyAccessToken();
        this.forceRedirectHttpsScheme = authentication.forceRedirectHttpsScheme();
        this.scopeSeparator = authentication.scopeSeparator();
        this.nonceRequired = authentication.nonceRequired();
        this.addOpenidScope = authentication.addOpenidScope();
        this.cookieForceSecure = authentication.cookieForceSecure();
        this.cookieSuffix = authentication.cookieSuffix();
        this.cookiePath = authentication.cookiePath();
        this.cookiePathHeader = authentication.cookiePathHeader();
        this.cookieDomain = authentication.cookieDomain();
        this.cookieSameSite = authentication.cookieSameSite();
        this.allowMultipleCodeFlows = authentication.allowMultipleCodeFlows();
        this.failOnMissingStateParam = authentication.failOnMissingStateParam();
        this.failOnUnresolvedKid = authentication.failOnUnresolvedKid();
        this.userInfoRequired = authentication.userInfoRequired();
        this.sessionAgeExtension = authentication.sessionAgeExtension();
        this.stateCookieAge = authentication.stateCookieAge();
        this.javaScriptAutoRedirect = authentication.javaScriptAutoRedirect();
        this.idTokenRequired = authentication.idTokenRequired();
        this.internalIdTokenLifespan = authentication.internalIdTokenLifespan();
        this.pkceRequired = authentication.pkceRequired();
        this.pkceSecret = authentication.pkceSecret();
        this.stateSecret = authentication.stateSecret();
    }

    public AuthenticationConfigBuilder responseMode(OidcTenantConfig.Authentication.ResponseMode responseMode) {
        this.responseMode = Optional.ofNullable(responseMode);
        return this;
    }

    public AuthenticationConfigBuilder redirectPath(String redirectPath) {
        this.redirectPath = Optional.ofNullable(redirectPath);
        return this;
    }

    public AuthenticationConfigBuilder restorePathAfterRedirect() {
        return this.restorePathAfterRedirect(true);
    }

    public AuthenticationConfigBuilder restorePathAfterRedirect(boolean restorePathAfterRedirect) {
        this.restorePathAfterRedirect = restorePathAfterRedirect;
        return this;
    }

    public AuthenticationConfigBuilder removeRedirectParameters() {
        return this.removeRedirectParameters(true);
    }

    public AuthenticationConfigBuilder removeRedirectParameters(boolean removeRedirectParameters) {
        this.removeRedirectParameters = removeRedirectParameters;
        return this;
    }

    public AuthenticationConfigBuilder errorPath(String errorPath) {
        this.errorPath = Optional.ofNullable(errorPath);
        return this;
    }

    public AuthenticationConfigBuilder sessionExpiredPath(String sessionExpiredPath) {
        this.sessionExpiredPath = Optional.ofNullable(sessionExpiredPath);
        return this;
    }

    public AuthenticationConfigBuilder verifyAccessToken() {
        return this.verifyAccessToken(true);
    }

    public AuthenticationConfigBuilder verifyAccessToken(boolean verifyAccessToken) {
        this.verifyAccessToken = verifyAccessToken;
        return this;
    }

    public AuthenticationConfigBuilder forceRedirectHttpsScheme() {
        return this.forceRedirectHttpsScheme(true);
    }

    public AuthenticationConfigBuilder forceRedirectHttpsScheme(boolean forceRedirectHttpsScheme) {
        this.forceRedirectHttpsScheme = Optional.of(forceRedirectHttpsScheme);
        return this;
    }

    public AuthenticationConfigBuilder scopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes.addAll(scopes);
        }
        return this;
    }

    public AuthenticationConfigBuilder scopes(String ... scopes) {
        if (scopes != null) {
            this.scopes.addAll(Arrays.asList(scopes));
        }
        return this;
    }

    public AuthenticationConfigBuilder scopeSeparator(String separator) {
        this.scopeSeparator = Optional.ofNullable(separator);
        return this;
    }

    public AuthenticationConfigBuilder nonceRequired() {
        return this.nonceRequired(true);
    }

    public AuthenticationConfigBuilder nonceRequired(boolean nonceRequired) {
        this.nonceRequired = nonceRequired;
        return this;
    }

    public AuthenticationConfigBuilder addOpenidScope() {
        return this.addOpenidScope(true);
    }

    public AuthenticationConfigBuilder addOpenidScope(boolean addOpenidScope) {
        this.addOpenidScope = Optional.of(addOpenidScope);
        return this;
    }

    public AuthenticationConfigBuilder forwardParams(List<String> forwardParams) {
        if (forwardParams != null) {
            this.forwardParams.addAll(forwardParams);
        }
        return this;
    }

    public AuthenticationConfigBuilder forwardParams(String ... forwardParams) {
        if (forwardParams != null) {
            this.forwardParams.addAll(Arrays.asList(forwardParams));
        }
        return this;
    }

    public AuthenticationConfigBuilder cookieForceSecure() {
        return this.cookieForceSecure(true);
    }

    public AuthenticationConfigBuilder cookieForceSecure(boolean cookieForceSecure) {
        this.cookieForceSecure = cookieForceSecure;
        return this;
    }

    public AuthenticationConfigBuilder cookieSuffix(String cookieSuffix) {
        this.cookieSuffix = Optional.ofNullable(cookieSuffix);
        return this;
    }

    public AuthenticationConfigBuilder cookiePath(String cookiePath) {
        this.cookiePath = Objects.requireNonNull(cookiePath);
        return this;
    }

    public AuthenticationConfigBuilder cookiePathHeader(String cookiePathHeader) {
        this.cookiePathHeader = Optional.ofNullable(cookiePathHeader);
        return this;
    }

    public AuthenticationConfigBuilder cookieDomain(String cookieDomain) {
        this.cookieDomain = Optional.ofNullable(cookieDomain);
        return this;
    }

    public AuthenticationConfigBuilder cookieSameSite(OidcTenantConfig.Authentication.CookieSameSite cookieSameSite) {
        this.cookieSameSite = Objects.requireNonNull(cookieSameSite);
        return this;
    }

    public AuthenticationConfigBuilder allowMultipleCodeFlows() {
        return this.allowMultipleCodeFlows(true);
    }

    public AuthenticationConfigBuilder allowMultipleCodeFlows(boolean allowMultipleCodeFlows) {
        this.allowMultipleCodeFlows = allowMultipleCodeFlows;
        return this;
    }

    public AuthenticationConfigBuilder failOnMissingStateParam() {
        return this.failOnMissingStateParam(true);
    }

    public AuthenticationConfigBuilder failOnMissingStateParam(boolean failOnMissingStateParam) {
        this.failOnMissingStateParam = failOnMissingStateParam;
        return this;
    }

    public AuthenticationConfigBuilder failOnUnresolvedKid() {
        return this.failOnUnresolvedKid(true);
    }

    public AuthenticationConfigBuilder failOnUnresolvedKid(boolean failOnUnresolvedKid) {
        this.failOnUnresolvedKid = failOnUnresolvedKid;
        return this;
    }

    public AuthenticationConfigBuilder userInfoRequired() {
        return this.userInfoRequired(true);
    }

    public AuthenticationConfigBuilder userInfoRequired(boolean userInfoRequired) {
        this.userInfoRequired = Optional.of(userInfoRequired);
        return this;
    }

    public AuthenticationConfigBuilder sessionAgeExtension(Duration sessionAgeExtension) {
        this.sessionAgeExtension = Objects.requireNonNull(sessionAgeExtension);
        return this;
    }

    public AuthenticationConfigBuilder stateCookieAge(Duration stateCookieAge) {
        this.stateCookieAge = Objects.requireNonNull(stateCookieAge);
        return this;
    }

    public AuthenticationConfigBuilder javaScriptAutoRedirect() {
        return this.javaScriptAutoRedirect(true);
    }

    public AuthenticationConfigBuilder javaScriptAutoRedirect(boolean javaScriptAutoRedirect) {
        this.javaScriptAutoRedirect = javaScriptAutoRedirect;
        return this;
    }

    public AuthenticationConfigBuilder idTokenRequired() {
        return this.idTokenRequired(true);
    }

    public AuthenticationConfigBuilder idTokenRequired(boolean idTokenRequired) {
        this.idTokenRequired = Optional.of(idTokenRequired);
        return this;
    }

    public AuthenticationConfigBuilder internalIdTokenLifespan(Duration internalIdTokenLifespan) {
        this.internalIdTokenLifespan = Optional.ofNullable(internalIdTokenLifespan);
        return this;
    }

    public AuthenticationConfigBuilder extraParams(Map<String, String> extraParams) {
        if (extraParams != null) {
            this.extraParams.putAll(extraParams);
        }
        return this;
    }

    public AuthenticationConfigBuilder extraParam(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.extraParams.put(key, value);
        return this;
    }

    public AuthenticationConfigBuilder pkceRequired() {
        return this.pkceRequired(true);
    }

    public AuthenticationConfigBuilder pkceRequired(boolean pkceRequired) {
        this.pkceRequired = Optional.of(pkceRequired);
        return this;
    }

    public AuthenticationConfigBuilder stateSecret(String stateSecret) {
        this.stateSecret = Optional.ofNullable(stateSecret);
        return this;
    }

    public OidcTenantConfigBuilder end() {
        return this.builder.authentication(this.build());
    }

    public OidcTenantConfig.Authentication build() {
        Optional<List<String>> optionalScopes = this.scopes.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(this.scopes));
        Optional<List<String>> optionalForwardParams = this.forwardParams.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(this.forwardParams));
        return new AuthenticationImpl(this.responseMode, this.redirectPath, this.restorePathAfterRedirect, this.removeRedirectParameters, this.errorPath, this.sessionExpiredPath, this.verifyAccessToken, this.forceRedirectHttpsScheme, optionalScopes, this.scopeSeparator, this.nonceRequired, this.addOpenidScope, Map.copyOf(this.extraParams), optionalForwardParams, this.cookieForceSecure, this.cookieSuffix, this.cookiePath, this.cookiePathHeader, this.cookieDomain, this.cookieSameSite, this.allowMultipleCodeFlows, this.failOnMissingStateParam, this.failOnUnresolvedKid, this.userInfoRequired, this.sessionAgeExtension, this.stateCookieAge, this.javaScriptAutoRedirect, this.idTokenRequired, this.internalIdTokenLifespan, this.pkceRequired, this.pkceSecret, this.stateSecret);
    }

    private record AuthenticationImpl(Optional<OidcTenantConfig.Authentication.ResponseMode> responseMode, Optional<String> redirectPath, boolean restorePathAfterRedirect, boolean removeRedirectParameters, Optional<String> errorPath, Optional<String> sessionExpiredPath, boolean verifyAccessToken, Optional<Boolean> forceRedirectHttpsScheme, Optional<List<String>> scopes, Optional<String> scopeSeparator, boolean nonceRequired, Optional<Boolean> addOpenidScope, Map<String, String> extraParams, Optional<List<String>> forwardParams, boolean cookieForceSecure, Optional<String> cookieSuffix, String cookiePath, Optional<String> cookiePathHeader, Optional<String> cookieDomain, OidcTenantConfig.Authentication.CookieSameSite cookieSameSite, boolean allowMultipleCodeFlows, boolean failOnMissingStateParam, boolean failOnUnresolvedKid, Optional<Boolean> userInfoRequired, Duration sessionAgeExtension, Duration stateCookieAge, boolean javaScriptAutoRedirect, Optional<Boolean> idTokenRequired, Optional<Duration> internalIdTokenLifespan, Optional<Boolean> pkceRequired, Optional<String> pkceSecret, Optional<String> stateSecret) implements OidcTenantConfig.Authentication
    {
    }
}

