/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.relational.table.argument;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.type.Type;

public class TableArgument
implements Argument {
    private final List<Optional<String>> fieldNames;
    private final List<Type> fieldTypes;
    private final List<String> partitionBy;
    private final List<String> orderBy;
    private final boolean rowSemantics;

    public TableArgument(List<Optional<String>> fieldNames, List<Type> fieldTypes, List<String> partitionBy, List<String> orderBy, boolean rowSemantic) {
        this.fieldNames = Objects.requireNonNull(fieldNames, "fieldNames is null");
        this.fieldTypes = Objects.requireNonNull(fieldTypes, "fieldTypes is null");
        if (fieldNames.size() != fieldTypes.size()) {
            throw new IllegalArgumentException("fieldNames and fieldTypes must have the same size");
        }
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.rowSemantics = rowSemantic;
    }

    public List<Optional<String>> getFieldNames() {
        return this.fieldNames;
    }

    public List<Type> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<String> getPartitionBy() {
        return this.partitionBy;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public boolean isRowSemantics() {
        return this.rowSemantics;
    }

    public int size() {
        return this.fieldTypes.size();
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        byte[] bytes;
        buffer.putInt(Argument.ArgumentType.TABLE_ARGUMENT.ordinal());
        buffer.putInt(this.fieldNames.size());
        for (Optional<String> fieldName : this.fieldNames) {
            if (fieldName.isPresent()) {
                buffer.put((byte)1);
                bytes = fieldName.get().getBytes();
                buffer.putInt(bytes.length);
                buffer.put(bytes);
                continue;
            }
            buffer.put((byte)0);
        }
        for (Type fieldType : this.fieldTypes) {
            buffer.put(fieldType.getType());
        }
        buffer.putInt(this.partitionBy.size());
        for (String partition : this.partitionBy) {
            bytes = partition.getBytes();
            buffer.putInt(bytes.length);
            buffer.put(bytes);
        }
        buffer.putInt(this.orderBy.size());
        for (String order : this.orderBy) {
            bytes = order.getBytes();
            buffer.putInt(bytes.length);
            buffer.put(bytes);
        }
        buffer.put((byte)(this.rowSemantics ? 1 : 0));
    }

    @Override
    public void serialize(DataOutputStream buffer) throws IOException {
        byte[] bytes;
        buffer.writeInt(Argument.ArgumentType.TABLE_ARGUMENT.ordinal());
        buffer.writeInt(this.fieldNames.size());
        for (Optional<String> fieldName : this.fieldNames) {
            if (fieldName.isPresent()) {
                buffer.writeByte(1);
                bytes = fieldName.get().getBytes();
                buffer.writeInt(bytes.length);
                buffer.write(bytes);
                continue;
            }
            buffer.writeByte(0);
        }
        for (Type fieldType : this.fieldTypes) {
            buffer.writeByte(fieldType.getType());
        }
        buffer.writeInt(this.partitionBy.size());
        for (String partition : this.partitionBy) {
            bytes = partition.getBytes();
            buffer.writeInt(bytes.length);
            buffer.write(bytes);
        }
        buffer.writeInt(this.orderBy.size());
        for (String order : this.orderBy) {
            bytes = order.getBytes();
            buffer.writeInt(bytes.length);
            buffer.write(bytes);
        }
        buffer.writeByte((byte)(this.rowSemantics ? 1 : 0));
    }

    public static TableArgument deserialize(ByteBuffer buffer) {
        int size = buffer.getInt();
        ArrayList<Optional<String>> fieldNames = new ArrayList<Optional<String>>(size);
        for (int i = 0; i < size; ++i) {
            if (buffer.get() == 1) {
                byte[] bytes = new byte[buffer.getInt()];
                buffer.get(bytes);
                fieldNames.add(Optional.of(new String(bytes)));
                continue;
            }
            fieldNames.add(Optional.empty());
        }
        ArrayList<Type> fieldTypes = new ArrayList<Type>(size);
        for (int i = 0; i < size; ++i) {
            fieldTypes.add(Type.valueOf(buffer.get()));
        }
        size = buffer.getInt();
        ArrayList<String> partitionBy = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            byte[] bytes = new byte[buffer.getInt()];
            buffer.get(bytes);
            partitionBy.add(new String(bytes));
        }
        size = buffer.getInt();
        ArrayList<String> orderBy = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            byte[] bytes = new byte[buffer.getInt()];
            buffer.get(bytes);
            orderBy.add(new String(bytes));
        }
        boolean rowSemantics = buffer.get() == 1;
        return new TableArgument(fieldNames, fieldTypes, partitionBy, orderBy, rowSemantics);
    }
}

