/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class PreviousFillWithGroupOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PreviousFillWithGroupOperator.class);
    private final OperatorContext operatorContext;
    private final IFill[] fillArray;
    private final Operator child;
    private final int outputColumnCount;
    private final int helperColumnIndex;
    private final Comparator<SortKey> groupKeyComparator;
    private final TsBlockBuilder resultBuilder;
    private SortKey lastRow = null;

    public PreviousFillWithGroupOperator(OperatorContext operatorContext, IFill[] fillArray, Operator child, int helperColumnIndex, Comparator<SortKey> groupKeyComparator, List<TSDataType> dataTypes) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((fillArray != null && fillArray.length > 0 ? 1 : 0) != 0, (Object)"fillArray should not be null or empty");
        this.fillArray = fillArray;
        this.child = Objects.requireNonNull(child, "child operator is null");
        this.outputColumnCount = fillArray.length;
        Preconditions.checkArgument((helperColumnIndex >= 0 ? 1 : 0) != 0, (Object)"helperColumnIndex for PreviousFillWithGroupOperator should never be negative");
        this.helperColumnIndex = helperColumnIndex;
        this.groupKeyComparator = groupKeyComparator;
        this.resultBuilder = new TsBlockBuilder(dataTypes);
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock block = this.child.nextWithTimer();
        if (block == null) {
            return null;
        }
        Preconditions.checkArgument((this.outputColumnCount == block.getValueColumnCount() ? 1 : 0) != 0, (Object)"outputColumnCount is not equal to value column count of child operator's TsBlock");
        if (this.lastRow != null && this.groupKeyComparator.compare(this.lastRow, new SortKey(block, 0)) != 0) {
            this.resetFill();
        }
        this.lastRow = new SortKey(block, block.getPositionCount() - 1);
        if (this.lastRow.rowIndex == 0 || this.groupKeyComparator.compare(new SortKey(block, 0), this.lastRow) == 0) {
            Column[] valueColumns = new Column[this.outputColumnCount];
            for (int i = 0; i < this.outputColumnCount; ++i) {
                valueColumns[i] = this.fillArray[i].fill(block.getColumn(this.helperColumnIndex), block.getColumn(i));
            }
            return TsBlock.wrapBlocksWithoutCopy((int)block.getPositionCount(), (Column)block.getTimeColumn(), (Column[])valueColumns);
        }
        this.resultBuilder.reset();
        SortKey currentGroupKey = new SortKey(block, 0);
        for (int i = 1; i <= this.lastRow.rowIndex; ++i) {
            SortKey nextGroupKey = new SortKey(block, i);
            if (this.groupKeyComparator.compare(currentGroupKey, nextGroupKey) == 0) continue;
            this.buildResultForCurrentGroup(block, currentGroupKey.rowIndex, i - 1);
            this.resetFill();
            currentGroupKey = nextGroupKey;
        }
        this.buildResultForCurrentGroup(block, currentGroupKey.rowIndex, this.lastRow.rowIndex);
        return this.resultBuilder.build(block.getTimeColumn());
    }

    private void resetFill() {
        for (IFill fill : this.fillArray) {
            fill.reset();
        }
    }

    private void buildResultForCurrentGroup(TsBlock block, int startIndex, int endIndex) {
        int length = endIndex - startIndex + 1;
        this.resultBuilder.declarePositions(length);
        Column helperColumn = block.getColumn(this.helperColumnIndex).getRegion(startIndex, length);
        for (int i = 0; i < this.outputColumnCount; ++i) {
            Column column = this.fillArray[i].fill(helperColumn, block.getColumn(i).getRegion(startIndex, length));
            ColumnBuilder builder = this.resultBuilder.getColumnBuilder(i);
            for (int rowIndex = 0; rowIndex < length; ++rowIndex) {
                if (column.isNull(rowIndex)) {
                    builder.appendNull();
                    continue;
                }
                builder.write(column, rowIndex);
            }
        }
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 2L * this.child.calculateMaxPeekMemory() + this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext() + this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
        this.lastRow = null;
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

