/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.mdn.fields.Field;

public class OriginalMessageId
implements Field {
    private static final String FIELD_NAME = "Original-Message-ID";
    private final String originalMessageId;

    public OriginalMessageId(String originalMessageId) {
        Preconditions.checkNotNull(originalMessageId);
        Preconditions.checkArgument(!originalMessageId.contains("\n"));
        String trimmedMessageId = originalMessageId.trim();
        Preconditions.checkArgument(!trimmedMessageId.isEmpty());
        this.originalMessageId = trimmedMessageId;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    @Override
    public String formattedValue() {
        return "Original-Message-ID: " + this.originalMessageId;
    }

    public final boolean equals(Object o) {
        if (o instanceof OriginalMessageId) {
            OriginalMessageId that = (OriginalMessageId)o;
            return Objects.equals(this.originalMessageId, that.originalMessageId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.originalMessageId);
    }

    public String toString() {
        return this.formattedValue();
    }
}

