/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput1;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.rdfxml.xmlinput1.JenaHandler;
import org.apache.jena.rdfxml.xmlinput1.RDFXMLReader;
import org.apache.jena.rdfxml.xmlinput1.SAX2RDF;
import org.apache.jena.shared.JenaException;
import org.xml.sax.SAXParseException;

public class SAX2Model
extends SAX2RDF {
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private final JenaHandler handler;
    private boolean closed = false;

    public static SAX2Model create(String base, Model m) throws SAXParseException {
        return new SAX2Model(base, m, "");
    }

    public static SAX2Model create(String base, Model m, String lang) throws SAXParseException {
        return new SAX2Model(base, m, lang);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXParseException {
        super.startPrefixMapping(prefix, uri);
    }

    protected SAX2Model(String base, Model m, String lang) throws SAXParseException {
        super(base, lang);
        this.handler = this.initHandler(m);
    }

    private JenaHandler initHandler(Model m) {
        if (m == null) {
            return null;
        }
        JenaHandler rslt = new JenaHandler(m, this.errorHandler);
        rslt.useWith(this.getHandlers());
        return rslt;
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        if (this.handler != null) {
            this.handler.setErrorHandler(errHandler);
        }
        return old;
    }

    public Object setProperty(String str, Object value) throws JenaException {
        Object obj = value;
        if (str.startsWith("http:") && str.startsWith("http://jena.hpl.hp.com/arp/properties/")) {
            str = str.substring(RDFXMLReader.arpPropertiesURLLength);
        }
        return this.setArpProperty(str, obj);
    }

    private Object setArpProperty(String str, Object v) {
        return RDFXMLReader.processArpOptions(this.getOptions(), str, v, this.errorHandler);
    }
}

