/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.http.auth.AuthHeader;
import org.apache.jena.http.auth.AuthHttp;

public class AuthChallenge {
    public final AuthScheme authScheme;
    public final AuthHeader authHeader;
    public final String realm;
    public final String nonce;
    public final String opaque;
    public final String qop;
    public final Map<String, String> authParams;

    public static AuthChallenge parse(String authHeaderStr) {
        AuthHeader auth;
        try {
            auth = AuthHeader.parseChallenge(authHeaderStr);
            if (auth == null) {
                return null;
            }
            if (auth.getAuthScheme() == null) {
                return null;
            }
        }
        catch (Throwable ex) {
            return null;
        }
        try {
            AuthScheme authScheme = auth.getAuthScheme();
            switch (authScheme) {
                case DIGEST: {
                    AuthChallenge.nonNull(auth, AuthHttp.strNonce);
                    AuthChallenge.nonNull(auth, AuthHttp.strRealm);
                    break;
                }
                case BASIC: {
                    AuthChallenge.nonNull(auth, AuthHttp.strRealm);
                    break;
                }
                case BEARER: {
                    break;
                }
                case UNKNOWN: {
                    break;
                }
            }
            return new AuthChallenge(authScheme, auth, AuthChallenge.get(auth, AuthHttp.strRealm), AuthChallenge.get(auth, AuthHttp.strNonce), AuthChallenge.get(auth, AuthHttp.strOpaque), AuthChallenge.get(auth, AuthHttp.strQop), auth.getAuthParams());
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private AuthChallenge(AuthScheme authScheme, AuthHeader authHeader, String realm, String nonce, String opaque, String qop, Map<String, String> authParams) {
        Objects.requireNonNull(authScheme);
        Objects.requireNonNull(authHeader);
        this.authScheme = authScheme;
        this.authHeader = authHeader;
        this.realm = realm;
        this.nonce = nonce;
        this.opaque = opaque;
        this.qop = qop;
        this.authParams = authParams;
    }

    public String getRealm() {
        if (this.authParams == null) {
            return null;
        }
        return this.authParams.get(AuthHttp.strRealm);
    }

    public String getToken() {
        if (!Objects.equals((Object)this.authHeader.getAuthScheme(), (Object)AuthScheme.BEARER)) {
            return null;
        }
        return this.authHeader.getBearerToken();
    }

    private static String get(AuthHeader auth, String s) {
        Map<String, String> map = auth.getAuthParams();
        if (map == null) {
            return null;
        }
        return map.get(s);
    }

    private static String nonNull(AuthHeader auth, String s) {
        Map<String, String> map = auth.getAuthParams();
        if (map == null) {
            throw new NullPointerException("No auth params");
        }
        return Objects.requireNonNull(map.get(s), "Field=" + String.valueOf(auth));
    }
}

