/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.Map;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.util.TextUtil;

public class Image
implements Plugin {
    public static final String PARAM_SRC = "src";
    public static final String PARAM_ALIGN = "align";
    public static final String PARAM_HEIGHT = "height";
    public static final String PARAM_WIDTH = "width";
    public static final String PARAM_ALT = "alt";
    public static final String PARAM_CAPTION = "caption";
    public static final String PARAM_LINK = "link";
    public static final String PARAM_TARGET = "target";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_BORDER = "border";
    public static final String PARAM_TITLE = "title";

    private static String getCleanParameter(Map<String, String> params, String paramId) {
        return TextUtil.replaceEntities((String)params.get(paramId));
    }

    public String execute(Context context, Map<String, String> params) throws PluginException {
        Engine engine = context.getEngine();
        Object src = Image.getCleanParameter(params, PARAM_SRC);
        String align = Image.getCleanParameter(params, PARAM_ALIGN);
        String ht = Image.getCleanParameter(params, PARAM_HEIGHT);
        String wt = Image.getCleanParameter(params, PARAM_WIDTH);
        String alt = Image.getCleanParameter(params, PARAM_ALT);
        String caption = Image.getCleanParameter(params, PARAM_CAPTION);
        String link = Image.getCleanParameter(params, PARAM_LINK);
        String target = Image.getCleanParameter(params, PARAM_TARGET);
        String style = Image.getCleanParameter(params, PARAM_STYLE);
        String cssclass = Image.getCleanParameter(params, PARAM_CLASS);
        String border = Image.getCleanParameter(params, PARAM_BORDER);
        String title = Image.getCleanParameter(params, PARAM_TITLE);
        if (src == null) {
            throw new PluginException("Parameter 'src' is required for Image plugin");
        }
        if (target != null && !this.validTargetValue(target)) {
            target = null;
        }
        try {
            AttachmentManager mgr = (AttachmentManager)engine.getManager(AttachmentManager.class);
            Attachment att = mgr.getAttachmentInfo(context, (String)src);
            if (att != null) {
                src = context.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), att.getName());
            }
        }
        catch (ProviderException e) {
            throw new PluginException("Attachment info failed: " + e.getMessage());
        }
        StringBuilder result = new StringBuilder();
        result.append("<table border=\"0\" class=\"imageplugin\"");
        if (title != null) {
            result.append(" title=\"").append(title).append("\"");
        }
        if (align != null) {
            if (align.equals("center")) {
                result.append(" style=\"margin-left: auto; margin-right: auto; text-align:center; vertical-align:middle;\"");
            } else {
                result.append(" style=\"float:").append(align).append(";\"");
            }
        }
        result.append(">\n");
        if (caption != null) {
            result.append("<caption>").append(caption).append("</caption>\n");
        }
        result.append("<tr><td");
        if (cssclass != null) {
            result.append(" class=\"").append(cssclass).append("\"");
        }
        if (style != null) {
            result.append(" style=\"").append(style);
            if (result.charAt(result.length() - 1) != ';') {
                result.append(";");
            }
            result.append("\"");
        }
        result.append(">");
        if (link != null) {
            result.append("<a href=\"").append(link).append("\"");
            if (target != null) {
                result.append(" target=\"").append(target).append("\"");
            }
            result.append(">");
        }
        if (!context.getBooleanWikiProperty("jspwiki.translatorReader.allowHTML", false) && (((String)src).startsWith("data:") || ((String)src).startsWith("javascript:"))) {
            src = "http://invalid_url" + (String)src;
        }
        result.append("<img src=\"").append((String)src).append("\"");
        if (ht != null) {
            result.append(" height=\"").append(ht).append("\"");
        }
        if (wt != null) {
            result.append(" width=\"").append(wt).append("\"");
        }
        if (alt != null) {
            result.append(" alt=\"").append(alt).append("\"");
        }
        if (border != null) {
            result.append(" border=\"").append(border).append("\"");
        }
        result.append(" />");
        if (link != null) {
            result.append("</a>");
        }
        result.append("</td></tr>\n");
        result.append("</table>\n");
        return result.toString();
    }

    private boolean validTargetValue(String s) {
        if (s.equals("_blank") || s.equals("_self") || s.equals("_parent") || s.equals("_top")) {
            return true;
        }
        if (!s.isEmpty()) {
            char c = s.charAt(0);
            return Character.isLowerCase(c) || Character.isUpperCase(c);
        }
        return false;
    }
}

