/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.ConfigBuilder;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.microservice.LogConfig;
import org.apache.juneau.microservice.Microservice;
import org.apache.juneau.microservice.MicroserviceListener;
import org.apache.juneau.microservice.console.ConsoleCommand;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.utils.Args;
import org.apache.juneau.utils.ManifestFile;

public class MicroserviceBuilder {
    Args args;
    ManifestFile manifest;
    Logger logger;
    LogConfig logConfig;
    Config config;
    String configName;
    ConfigStore configStore;
    ConfigBuilder configBuilder = Config.create();
    Boolean consoleEnabled;
    List<ConsoleCommand> consoleCommands = new ArrayList<ConsoleCommand>();
    VarResolverBuilder varResolverBuilder = VarResolver.create().defaultVars().vars(new Class[]{ConfigVar.class});
    Scanner consoleReader;
    PrintWriter consoleWriter;
    MicroserviceListener listener;
    File workingDir = System.getProperty("juneau.workingDir") == null ? null : new File(System.getProperty("juneau.workingDir"));

    protected MicroserviceBuilder() {
    }

    protected MicroserviceBuilder(MicroserviceBuilder copyFrom) {
        this.args = copyFrom.args;
        this.manifest = copyFrom.manifest;
        this.logger = copyFrom.logger;
        this.configName = copyFrom.configName;
        this.logConfig = copyFrom.logConfig == null ? null : copyFrom.logConfig.copy();
        this.consoleEnabled = copyFrom.consoleEnabled;
        this.configBuilder = copyFrom.configBuilder;
        this.varResolverBuilder = copyFrom.varResolverBuilder;
        this.consoleReader = copyFrom.consoleReader;
        this.consoleWriter = copyFrom.consoleWriter;
        this.workingDir = copyFrom.workingDir;
    }

    public MicroserviceBuilder copy() {
        return new MicroserviceBuilder(this);
    }

    public Microservice build() throws Exception {
        return new Microservice(this);
    }

    public MicroserviceBuilder args(Args args) {
        this.args = args;
        return this;
    }

    public MicroserviceBuilder args(String ... args) {
        this.args = new Args(args);
        return this;
    }

    public MicroserviceBuilder manifest(Object value) throws IOException {
        if (value == null) {
            this.manifest = null;
        } else if (value instanceof ManifestFile) {
            this.manifest = (ManifestFile)value;
        } else if (value instanceof Manifest) {
            this.manifest = new ManifestFile((Manifest)value);
        } else if (value instanceof Reader) {
            this.manifest = new ManifestFile((Reader)value);
        } else if (value instanceof InputStream) {
            this.manifest = new ManifestFile((InputStream)value);
        } else if (value instanceof File) {
            this.manifest = new ManifestFile((File)value);
        } else if (value instanceof String) {
            this.manifest = new ManifestFile(this.resolveFile((String)value));
        } else if (value instanceof Class) {
            this.manifest = new ManifestFile((Class)value);
        } else {
            throw new RuntimeException("Invalid type passed to MicroserviceBuilder.manifest(Object).  Type=[" + value.getClass().getName() + "]");
        }
        return this;
    }

    public MicroserviceBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public MicroserviceBuilder logConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
        return this;
    }

    public MicroserviceBuilder config(Config config) {
        this.config = config;
        return this;
    }

    public MicroserviceBuilder configName(String configName) {
        this.configName = configName;
        return this;
    }

    public MicroserviceBuilder configStore(ConfigStore configStore) {
        this.configStore = configStore;
        return this;
    }

    public MicroserviceBuilder consoleEnabled(boolean consoleEnabled) {
        this.consoleEnabled = consoleEnabled;
        return this;
    }

    public MicroserviceBuilder consoleCommands(Class<? extends ConsoleCommand> ... consoleCommands) throws ExecutableException {
        try {
            for (Class<? extends ConsoleCommand> cc : consoleCommands) {
                this.consoleCommands.add(cc.newInstance());
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExecutableException((Throwable)e);
        }
        return this;
    }

    public MicroserviceBuilder consoleCommands(ConsoleCommand ... consoleCommands) {
        this.consoleCommands.addAll(Arrays.asList(consoleCommands));
        return this;
    }

    public MicroserviceBuilder console(Scanner consoleReader, PrintWriter consoleWriter) {
        this.consoleReader = consoleReader;
        this.consoleWriter = consoleWriter;
        return this;
    }

    public MicroserviceBuilder vars(Class<? extends Var> ... vars) {
        this.varResolverBuilder.vars((Class[])vars);
        return this;
    }

    public MicroserviceBuilder varContext(String name, Object object) {
        this.varResolverBuilder.contextObject(name, object);
        return this;
    }

    public MicroserviceBuilder workingDir(File workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public MicroserviceBuilder workingDir(String workingDir) {
        this.workingDir = new File(workingDir);
        return this;
    }

    public MicroserviceBuilder listener(MicroserviceListener listener) {
        this.listener = listener;
        return this;
    }

    protected File resolveFile(String path) {
        if (Paths.get(path, new String[0]).isAbsolute()) {
            return new File(path);
        }
        if (this.workingDir != null) {
            return new File(this.workingDir, path);
        }
        return new File(path);
    }
}

