/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.common.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public class SystemUtils {
    static final List<Supplier<String>> SHUTDOWN_MESSAGES = new CopyOnWriteArrayList<Supplier<String>>();

    public static void shutdownMessage(Supplier<String> message) {
        SHUTDOWN_MESSAGES.add(message);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (Boolean.getBoolean("SystemUtils.verbose")) {
                    SHUTDOWN_MESSAGES.forEach(x -> System.out.println((String)x.get()));
                }
            }
        });
    }
}

