/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.Credential;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.auth.User;
import org.ldaptive.control.RequestControl;

public class AuthenticationRequest {
    private User user;
    private Credential credential;
    private String[] retAttrs = ReturnAttributes.NONE.value();
    private RequestControl[] controls;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(String id, Credential c) {
        this.setUser(id);
        this.setCredential(c);
    }

    public AuthenticationRequest(User u, Credential c) {
        this.setUserEx(u);
        this.setCredential(c);
    }

    public AuthenticationRequest(String id, Credential c, String ... attrs) {
        this.setUser(id);
        this.setCredential(c);
        this.setReturnAttributes(attrs);
    }

    public AuthenticationRequest(User u, Credential c, String ... attrs) {
        this.setUserEx(u);
        this.setCredential(c);
        this.setReturnAttributes(attrs);
    }

    public String getUser() {
        return this.user != null ? this.user.getIdentifier() : null;
    }

    public User getUserEx() {
        return this.user;
    }

    public void setUser(String id) {
        this.user = new User(id);
    }

    public void setUserEx(User u) {
        this.user = u;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential c) {
        this.credential = c;
    }

    public String[] getReturnAttributes() {
        return this.retAttrs;
    }

    public void setReturnAttributes(String ... attrs) {
        this.retAttrs = ReturnAttributes.parse(attrs);
    }

    public RequestControl[] getControls() {
        return this.controls;
    }

    public void setControls(RequestControl ... c) {
        this.controls = c;
    }

    public static AuthenticationRequest newAuthenticationRequest(AuthenticationRequest request) {
        AuthenticationRequest r = new AuthenticationRequest();
        r.setUser(request.getUser());
        r.setCredential(request.getCredential());
        r.setReturnAttributes(request.getReturnAttributes());
        r.setControls(request.getControls());
        return r;
    }

    public String toString() {
        return String.format("[%s@%d::user=%s, retAttrs=%s, controls=%s]", this.getClass().getName(), this.hashCode(), this.user, Arrays.toString(this.retAttrs), Arrays.toString(this.controls));
    }
}

