/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.util.lang.AbstractAttributeMap;

public final class RequestHeaderValuesMap
extends AbstractAttributeMap<String[]> {
    private final HttpServletRequest httpServletRequest;
    private final Map<String, String[]> attributeValueCache = new HashMap<String, String[]>();

    RequestHeaderValuesMap(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    @Override
    protected String[] getAttribute(String key) {
        String[] attributes = this.attributeValueCache.get(key);
        if (attributes == null) {
            ArrayList<String> attributesList = Collections.list(this.httpServletRequest.getHeaders(key));
            attributes = attributesList.toArray(new String[attributesList.size()]);
            this.attributeValueCache.put(key, attributes);
        }
        return attributes;
    }

    @Override
    protected void setAttribute(String key, String[] value) {
        throw new UnsupportedOperationException("Cannot set HttpServletRequest HeaderValues");
    }

    @Override
    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("Cannot remove HttpServletRequest HeaderValues");
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        return this.httpServletRequest.getHeaderNames();
    }
}

