/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle.clientwindow;

import javax.faces.context.FacesContext;
import javax.faces.lifecycle.ClientWindow;
import javax.faces.lifecycle.ClientWindowFactory;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.lifecycle.clientwindow.CODIClientSideWindow;
import org.apache.myfaces.lifecycle.clientwindow.ClientConfig;
import org.apache.myfaces.lifecycle.clientwindow.UrlClientWindow;
import org.apache.myfaces.lifecycle.clientwindow.UrlRedirectClientWindow;
import org.apache.myfaces.lifecycle.clientwindow.WindowContextConfig;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.token.TokenGenerator;

public class ClientWindowFactoryImpl
extends ClientWindowFactory {
    public static final String INIT_PARAM_DEFAULT_WINDOW_MODE = "org.apache.myfaces.DEFAULT_WINDOW_MODE";
    public static final String WINDOW_MODE_NONE = "none";
    public static final String WINDOW_MODE_URL = "url";
    public static final String WINDOW_MODE_URL_REDIRECT = "url-redirect";
    public static final String WINDOW_MODE_CLIENT = "client";
    private String windowMode;
    private TokenGenerator windowTokenGenerator = new TokenGenerator();
    private ClientConfig clientConfig = new ClientConfig();
    private WindowContextConfig windowContextConfig = new WindowContextConfig();

    public ClientWindow getClientWindow(FacesContext facesContext) {
        if (WINDOW_MODE_NONE.equals(this.getWindowMode(facesContext))) {
            return null;
        }
        if (WINDOW_MODE_URL.equals(this.getWindowMode(facesContext))) {
            return new UrlClientWindow(this.windowTokenGenerator);
        }
        if (WINDOW_MODE_URL_REDIRECT.equals(this.getWindowMode(facesContext))) {
            return new UrlRedirectClientWindow(this.windowTokenGenerator);
        }
        if (WINDOW_MODE_CLIENT.equals(this.getWindowMode(facesContext))) {
            return new CODIClientSideWindow(this.windowTokenGenerator, this.windowContextConfig, this.clientConfig);
        }
        return null;
    }

    private String getWindowMode(FacesContext context) {
        if (this.windowMode == null) {
            if (FacesConfigurator.isEnableDefaultWindowMode(context)) {
                String defaultWindowMode = WebConfigParamUtils.getStringInitParameter(context.getExternalContext(), INIT_PARAM_DEFAULT_WINDOW_MODE, WINDOW_MODE_URL);
                this.windowMode = WebConfigParamUtils.getStringInitParameter(context.getExternalContext(), "javax.faces.CLIENT_WINDOW_MODE", defaultWindowMode);
            } else {
                this.windowMode = WebConfigParamUtils.getStringInitParameter(context.getExternalContext(), "javax.faces.CLIENT_WINDOW_MODE", WINDOW_MODE_NONE);
            }
        }
        return this.windowMode;
    }
}

