/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentPropertyDescriptor;

public class ImplementationHandler
extends TagHandler {
    private static final Logger log = Logger.getLogger(ImplementationHandler.class.getName());
    public static final String NAME = "implementation";

    public ImplementationHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (!((AbstractFaceletContext)ctx).isBuildingCompositeComponentMetadata()) {
            this.nextHandler.apply(ctx, parent);
        } else {
            UIComponent compositeBaseParent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
            CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)compositeBaseParent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
            if (beanInfo == null) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
                }
                return;
            }
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            HashMap<String, CompositeComponentPropertyDescriptor> facetPropertyDescriptorMap = (HashMap<String, CompositeComponentPropertyDescriptor>)beanDescriptor.getValue("javax.faces.component.FACETS_KEY");
            if (facetPropertyDescriptorMap == null) {
                facetPropertyDescriptorMap = new HashMap<String, CompositeComponentPropertyDescriptor>(5);
                beanDescriptor.setValue("javax.faces.component.FACETS_KEY", facetPropertyDescriptorMap);
            }
            if (!facetPropertyDescriptorMap.containsKey("javax.faces.component.COMPOSITE_FACET_NAME")) {
                try {
                    facetPropertyDescriptorMap.put("javax.faces.component.COMPOSITE_FACET_NAME", new CompositeComponentPropertyDescriptor("javax.faces.component.COMPOSITE_FACET_NAME"));
                }
                catch (IntrospectionException e) {
                    if (log.isLoggable(Level.SEVERE)) {
                        log.log(Level.SEVERE, "Cannot create PropertyDescriptor for facet ", e);
                    }
                    throw new TagException(this.tag, (Throwable)e);
                }
            }
            this.nextHandler.apply(ctx, parent);
        }
    }

    public Location getLocation() {
        return this.tag.getLocation();
    }
}

