/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.analysis.Configuration;
import org.netbeans.modules.analysis.ConfigurationsManager;
import org.netbeans.modules.analysis.RunAnalysisPanel;
import org.netbeans.modules.analysis.SPIAccessor;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.analysis.ui.Bundle;
import org.netbeans.modules.analysis.ui.ConfigurationsComboModel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class AdjustConfigurationPanel
extends JPanel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(AdjustConfigurationPanel.class.getName());
    private static final String LBL_NEW = "New...";
    private static final String LBL_DUPLICATE = "Duplicate...";
    private static final String LBL_RENAME = "Rename...";
    private static final String LBL_DELETE = "Delete";
    private final Iterable<? extends Analyzer.AnalyzerFactory> analyzers;
    private Analyzer.CustomizerContext<Object, JComponent> currentContext;
    private final Map<Analyzer.AnalyzerFactory, Analyzer.CustomizerProvider> customizers = new IdentityHashMap<Analyzer.AnalyzerFactory, Analyzer.CustomizerProvider>();
    private final Map<Analyzer.AnalyzerFactory, String> errors = new IdentityHashMap<Analyzer.AnalyzerFactory, String>();
    private final Map<Analyzer.CustomizerProvider, Object> customizerData = new IdentityHashMap<Analyzer.CustomizerProvider, Object>();
    private Preferences currentPreferences;
    private ModifiedPreferences currentPreferencesOverlay;
    private final String preselected;
    private final ErrorListener errorListener;
    private JComponent currentPanel;
    private JComboBox analyzerCombo;
    private JPanel analyzerPanel;
    private JComboBox configurationCombo;
    private JLabel configurationLabel;
    private JLabel jLabel2;

    public AdjustConfigurationPanel(Iterable<? extends Analyzer.AnalyzerFactory> analyzers, Analyzer.AnalyzerFactory preselectedAnalyzer, String preselected, Configuration configurationToSelect, ErrorListener errorListener) {
        this.preselected = preselected;
        this.initComponents();
        if (preselected == null) {
            final ConfigurationsComboModel model = new ConfigurationsComboModel(true);
            this.configurationCombo.setModel(model);
            this.configurationCombo.setRenderer(new RunAnalysisPanel.ConfigurationRenderer(false));
            this.configurationCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AdjustConfigurationPanel.this.configurationCombo.getSelectedItem() instanceof ActionListener) {
                        ((ActionListener)AdjustConfigurationPanel.this.configurationCombo.getSelectedItem()).actionPerformed(e);
                    } else if (AdjustConfigurationPanel.this.configurationCombo.getSelectedItem() instanceof String) {
                        assert (model.currentActiveItem != null);
                        model.currentActiveItem.confirm(new EventObject(AdjustConfigurationPanel.this.configurationCombo.getEditor().getEditorComponent()));
                    } else {
                        AdjustConfigurationPanel.this.updateConfiguration();
                    }
                }
            });
        } else {
            this.configurationLabel.setVisible(false);
            this.configurationCombo.setVisible(false);
        }
        this.analyzers = analyzers;
        DefaultComboBoxModel<Analyzer.AnalyzerFactory> analyzerModel = new DefaultComboBoxModel<Analyzer.AnalyzerFactory>();
        for (Analyzer.AnalyzerFactory analyzerFactory : analyzers) {
            Analyzer.CustomizerProvider cp = analyzerFactory.getCustomizerProvider();
            if (cp == null) continue;
            this.customizers.put(analyzerFactory, cp);
            analyzerModel.addElement(analyzerFactory);
        }
        this.analyzerCombo.setModel(analyzerModel);
        if (preselectedAnalyzer != null) {
            this.analyzerCombo.setSelectedItem(preselectedAnalyzer);
        }
        this.analyzerCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdjustConfigurationPanel.this.updateAnalyzer();
            }
        });
        this.analyzerCombo.setRenderer(new AnalyzerRenderer());
        this.updateConfiguration();
        if (configurationToSelect != null) {
            this.configurationCombo.setSelectedItem(configurationToSelect);
        }
        this.errorListener = errorListener;
    }

    private void updateConfiguration() {
        if (this.currentPreferencesOverlay != null && this.currentPreferences != null) {
            this.currentPreferencesOverlay.store(this.currentPreferences);
        }
        if (this.preselected == null) {
            this.currentPreferences = ((Configuration)this.configurationCombo.getSelectedItem()).getPreferences();
        } else {
            this.currentPreferences = ConfigurationsManager.getDefault().getTemporaryConfiguration().getPreferences();
            try {
                for (String c : this.currentPreferences.childrenNames()) {
                    this.currentPreferences.node(c).removeNode();
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        this.currentPreferencesOverlay = new ModifiedPreferences(null, "", this.currentPreferences);
        this.updateAnalyzer();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Window w;
        if (evt.getSource() == this.currentPanel && "contentLoaded".equals(evt.getPropertyName()) && (w = SwingUtilities.getWindowAncestor(this)) != null) {
            w.pack();
        }
    }

    private void updateAnalyzer() {
        JComponent c;
        if (this.currentPanel != null) {
            this.currentPanel.removePropertyChangeListener(this);
        }
        this.analyzerPanel.removeAll();
        final Analyzer.AnalyzerFactory selected = (Analyzer.AnalyzerFactory)this.analyzerCombo.getSelectedItem();
        Analyzer.CustomizerProvider customizer = this.customizers.get(selected);
        if (customizer == null) {
            return;
        }
        if (!this.customizerData.containsKey(customizer)) {
            this.customizerData.put(customizer, customizer.initialize());
        }
        Object data = this.customizerData.get(customizer);
        Preferences settings = this.currentPreferencesOverlay.node(SPIAccessor.ACCESSOR.getAnalyzerId(selected));
        this.currentContext = new Analyzer.CustomizerContext<Object, Object>(settings, this.preselected, null, data, new ErrorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setError(String error) {
                Map map = AdjustConfigurationPanel.this.errors;
                synchronized (map) {
                    if (error != null) {
                        AdjustConfigurationPanel.this.errors.put(selected, error);
                    } else {
                        AdjustConfigurationPanel.this.errors.remove(selected);
                    }
                }
                AdjustConfigurationPanel.this.updateErrors();
            }
        });
        this.currentContext.setSelectedId(this.preselected);
        this.currentPanel = c = customizer.createComponent(this.currentContext);
        this.currentPanel.addPropertyChangeListener(this);
        this.analyzerPanel.add((Component)c, "Center");
        this.analyzerPanel.revalidate();
        this.analyzerPanel.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateErrors() {
        String currentAnalyzerError;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AdjustConfigurationPanel.this.updateErrors();
                }
            });
        }
        Map<Analyzer.AnalyzerFactory, String> map = this.errors;
        synchronized (map) {
            currentAnalyzerError = this.errors.get(this.analyzerCombo.getSelectedItem());
            if (currentAnalyzerError == null) {
                for (Map.Entry<Analyzer.AnalyzerFactory, String> e : this.errors.entrySet()) {
                    if (e.getValue() == null) continue;
                    currentAnalyzerError = Bundle.ERR_AnalyzerError(SPIAccessor.ACCESSOR.getAnalyzerDisplayName(e.getKey()), e.getValue());
                }
            }
        }
        this.errorListener.setError(currentAnalyzerError);
        this.analyzerCombo.repaint();
    }

    public String getIdToRun() {
        return SPIAccessor.ACCESSOR.getSelectedId(this.currentContext);
    }

    public void save() {
        this.currentPreferencesOverlay.store(this.currentPreferences);
    }

    public Configuration getSelectedConfiguration() {
        return (Configuration)this.configurationCombo.getSelectedItem();
    }

    private void initComponents() {
        this.configurationLabel = new JLabel();
        this.configurationCombo = new JComboBox();
        this.jLabel2 = new JLabel();
        this.analyzerCombo = new JComboBox();
        this.analyzerPanel = new JPanel();
        this.configurationLabel.setText(NbBundle.getMessage(AdjustConfigurationPanel.class, "AdjustConfigurationPanel.configurationLabel.text"));
        this.jLabel2.setText(NbBundle.getMessage(AdjustConfigurationPanel.class, "AdjustConfigurationPanel.jLabel2.text"));
        this.analyzerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.analyzerPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.configurationLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configurationCombo, 0, 220, Short.MAX_VALUE).addComponent(this.analyzerCombo, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurationLabel).addComponent(this.configurationCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.analyzerCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.analyzerPanel, -1, 180, Short.MAX_VALUE).addContainerGap()));
    }

    private class AnalyzerRenderer
    extends DefaultListCellRenderer {
        private AnalyzerRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean isErroneous;
            Analyzer.AnalyzerFactory a = (Analyzer.AnalyzerFactory)value;
            String text = SPIAccessor.ACCESSOR.getAnalyzerDisplayName(a);
            Map map = AdjustConfigurationPanel.this.errors;
            synchronized (map) {
                isErroneous = AdjustConfigurationPanel.this.errors.containsKey(a);
            }
            if (isErroneous) {
                try {
                    text = "<html><font color='ref'>" + XMLUtil.toElementContent(text);
                }
                catch (CharConversionException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    }

    public static interface ErrorListener {
        public void setError(String var1);
    }

    private static class ModifiedPreferences
    extends AbstractPreferences {
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private final Map<String, ModifiedPreferences> subNodes = new HashMap<String, ModifiedPreferences>();

        public ModifiedPreferences(ModifiedPreferences parent, String name) {
            super(parent, name);
        }

        public ModifiedPreferences(ModifiedPreferences parent, String name, Preferences node) {
            this(parent, name);
            try {
                for (String key : node.keys()) {
                    this.put(key, node.get(key, null));
                }
                for (String child : node.childrenNames()) {
                    this.subNodes.put(child, new ModifiedPreferences(this, node.name(), node.node(child)));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace(ex);
            }
        }

        public void store(Preferences target) {
            try {
                for (String key : this.keys()) {
                    target.put(key, this.get(key, null));
                }
                for (String child : this.childrenNames()) {
                    ((ModifiedPreferences)this.node(child)).store(target.node(child));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace(ex);
            }
        }

        @Override
        protected void putSpi(String key, String value) {
            this.properties.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return (String)this.properties.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.properties.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            ((ModifiedPreferences)this.parent()).subNodes.put(this.name(), new ModifiedPreferences(this, this.name()));
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.properties.keySet().size()];
            return this.properties.keySet().toArray(array);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            return this.subNodes.keySet().toArray(new String[0]);
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            ModifiedPreferences result = this.subNodes.get(name);
            if (result == null) {
                result = new ModifiedPreferences(this, name);
                this.subNodes.put(name, result);
            }
            return result;
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        boolean isEmpty() {
            return this.properties.isEmpty();
        }
    }
}

