/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetFaultParameterFaultExtendedParameters is the corresponding interface of BACnetFaultParameterFaultExtendedParameters
type BACnetFaultParameterFaultExtendedParameters interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetParameters returns Parameters (property field)
	GetParameters() []BACnetFaultParameterFaultExtendedParametersEntry
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetFaultParameterFaultExtendedParameters is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetFaultParameterFaultExtendedParameters()
	// CreateBuilder creates a BACnetFaultParameterFaultExtendedParametersBuilder
	CreateBACnetFaultParameterFaultExtendedParametersBuilder() BACnetFaultParameterFaultExtendedParametersBuilder
}

// _BACnetFaultParameterFaultExtendedParameters is the data-structure of this message
type _BACnetFaultParameterFaultExtendedParameters struct {
	OpeningTag BACnetOpeningTag
	Parameters []BACnetFaultParameterFaultExtendedParametersEntry
	ClosingTag BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetFaultParameterFaultExtendedParameters = (*_BACnetFaultParameterFaultExtendedParameters)(nil)

// NewBACnetFaultParameterFaultExtendedParameters factory function for _BACnetFaultParameterFaultExtendedParameters
func NewBACnetFaultParameterFaultExtendedParameters(openingTag BACnetOpeningTag, parameters []BACnetFaultParameterFaultExtendedParametersEntry, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetFaultParameterFaultExtendedParameters {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetFaultParameterFaultExtendedParameters must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetFaultParameterFaultExtendedParameters must not be nil")
	}
	return &_BACnetFaultParameterFaultExtendedParameters{OpeningTag: openingTag, Parameters: parameters, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetFaultParameterFaultExtendedParametersBuilder is a builder for BACnetFaultParameterFaultExtendedParameters
type BACnetFaultParameterFaultExtendedParametersBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, parameters []BACnetFaultParameterFaultExtendedParametersEntry, closingTag BACnetClosingTag) BACnetFaultParameterFaultExtendedParametersBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetFaultParameterFaultExtendedParametersBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetFaultParameterFaultExtendedParametersBuilder
	// WithParameters adds Parameters (property field)
	WithParameters(...BACnetFaultParameterFaultExtendedParametersEntry) BACnetFaultParameterFaultExtendedParametersBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetFaultParameterFaultExtendedParametersBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetFaultParameterFaultExtendedParametersBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetFaultParameterFaultExtendedParametersBuilder
	// Build builds the BACnetFaultParameterFaultExtendedParameters or returns an error if something is wrong
	Build() (BACnetFaultParameterFaultExtendedParameters, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetFaultParameterFaultExtendedParameters
}

// NewBACnetFaultParameterFaultExtendedParametersBuilder() creates a BACnetFaultParameterFaultExtendedParametersBuilder
func NewBACnetFaultParameterFaultExtendedParametersBuilder() BACnetFaultParameterFaultExtendedParametersBuilder {
	return &_BACnetFaultParameterFaultExtendedParametersBuilder{_BACnetFaultParameterFaultExtendedParameters: new(_BACnetFaultParameterFaultExtendedParameters)}
}

type _BACnetFaultParameterFaultExtendedParametersBuilder struct {
	*_BACnetFaultParameterFaultExtendedParameters

	collectedErr []error
}

var _ (BACnetFaultParameterFaultExtendedParametersBuilder) = (*_BACnetFaultParameterFaultExtendedParametersBuilder)(nil)

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, parameters []BACnetFaultParameterFaultExtendedParametersEntry, closingTag BACnetClosingTag) BACnetFaultParameterFaultExtendedParametersBuilder {
	return b.WithOpeningTag(openingTag).WithParameters(parameters...).WithClosingTag(closingTag)
}

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetFaultParameterFaultExtendedParametersBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetFaultParameterFaultExtendedParametersBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) WithParameters(parameters ...BACnetFaultParameterFaultExtendedParametersEntry) BACnetFaultParameterFaultExtendedParametersBuilder {
	b.Parameters = parameters
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetFaultParameterFaultExtendedParametersBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetFaultParameterFaultExtendedParametersBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) WithArgTagNumber(tagNumber uint8) BACnetFaultParameterFaultExtendedParametersBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) Build() (BACnetFaultParameterFaultExtendedParameters, error) {
	if b.OpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'closingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetFaultParameterFaultExtendedParameters.deepCopy(), nil
}

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) MustBuild() BACnetFaultParameterFaultExtendedParameters {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetFaultParameterFaultExtendedParametersBuilder) DeepCopy() any {
	_copy := b.CreateBACnetFaultParameterFaultExtendedParametersBuilder().(*_BACnetFaultParameterFaultExtendedParametersBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetFaultParameterFaultExtendedParametersBuilder creates a BACnetFaultParameterFaultExtendedParametersBuilder
func (b *_BACnetFaultParameterFaultExtendedParameters) CreateBACnetFaultParameterFaultExtendedParametersBuilder() BACnetFaultParameterFaultExtendedParametersBuilder {
	if b == nil {
		return NewBACnetFaultParameterFaultExtendedParametersBuilder()
	}
	return &_BACnetFaultParameterFaultExtendedParametersBuilder{_BACnetFaultParameterFaultExtendedParameters: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetFaultParameterFaultExtendedParameters) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetFaultParameterFaultExtendedParameters) GetParameters() []BACnetFaultParameterFaultExtendedParametersEntry {
	return m.Parameters
}

func (m *_BACnetFaultParameterFaultExtendedParameters) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetFaultParameterFaultExtendedParameters(structType any) BACnetFaultParameterFaultExtendedParameters {
	if casted, ok := structType.(BACnetFaultParameterFaultExtendedParameters); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetFaultParameterFaultExtendedParameters); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetFaultParameterFaultExtendedParameters) GetTypeName() string {
	return "BACnetFaultParameterFaultExtendedParameters"
}

func (m *_BACnetFaultParameterFaultExtendedParameters) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.Parameters) > 0 {
		for _, element := range m.Parameters {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetFaultParameterFaultExtendedParameters) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetFaultParameterFaultExtendedParametersParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetFaultParameterFaultExtendedParameters, error) {
	return BACnetFaultParameterFaultExtendedParametersParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetFaultParameterFaultExtendedParametersParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetFaultParameterFaultExtendedParameters, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetFaultParameterFaultExtendedParameters, error) {
		return BACnetFaultParameterFaultExtendedParametersParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetFaultParameterFaultExtendedParametersParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetFaultParameterFaultExtendedParameters, error) {
	v, err := (&_BACnetFaultParameterFaultExtendedParameters{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetFaultParameterFaultExtendedParameters) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetFaultParameterFaultExtendedParameters BACnetFaultParameterFaultExtendedParameters, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetFaultParameterFaultExtendedParameters"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetFaultParameterFaultExtendedParameters")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	parameters, err := ReadTerminatedArrayField[BACnetFaultParameterFaultExtendedParametersEntry](ctx, "parameters", ReadComplex[BACnetFaultParameterFaultExtendedParametersEntry](BACnetFaultParameterFaultExtendedParametersEntryParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'parameters' field"))
	}
	m.Parameters = parameters

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetFaultParameterFaultExtendedParameters"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetFaultParameterFaultExtendedParameters")
	}

	return m, nil
}

func (m *_BACnetFaultParameterFaultExtendedParameters) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetFaultParameterFaultExtendedParameters) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetFaultParameterFaultExtendedParameters"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetFaultParameterFaultExtendedParameters")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "parameters", m.GetParameters(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'parameters' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetFaultParameterFaultExtendedParameters"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetFaultParameterFaultExtendedParameters")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetFaultParameterFaultExtendedParameters) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetFaultParameterFaultExtendedParameters) IsBACnetFaultParameterFaultExtendedParameters() {
}

func (m *_BACnetFaultParameterFaultExtendedParameters) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetFaultParameterFaultExtendedParameters) deepCopy() *_BACnetFaultParameterFaultExtendedParameters {
	if m == nil {
		return nil
	}
	_BACnetFaultParameterFaultExtendedParametersCopy := &_BACnetFaultParameterFaultExtendedParameters{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopySlice[BACnetFaultParameterFaultExtendedParametersEntry, BACnetFaultParameterFaultExtendedParametersEntry](m.Parameters),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetFaultParameterFaultExtendedParametersCopy
}

func (m *_BACnetFaultParameterFaultExtendedParameters) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
