/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class MissingNamespaceRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.ClassID, (node, tokenQuery, problems) -> this.checkClassNode((IClassNode)node, tokenQuery, problems));
        result.put(ASTNodeID.InterfaceID, (node, tokenQuery, problems) -> this.checkInterfaceNode((IInterfaceNode)node, tokenQuery, problems));
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        result.put(ASTNodeID.VariableID, (node, tokenQuery, problems) -> this.checkVariableNode((IVariableNode)node, tokenQuery, problems));
        return result;
    }

    private void checkClassNode(IClassNode classNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IScopedNode scopedNode = classNode.getContainingScope();
        IASNode possiblePackage = scopedNode.getParent();
        if (!(possiblePackage instanceof IPackageNode)) {
            return;
        }
        if (this.hasNamespace((IDefinitionNode)classNode)) {
            return;
        }
        problems.add(new MissingNamespaceOnClassLinterProblem(classNode));
    }

    private void checkInterfaceNode(IInterfaceNode interfaceNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IScopedNode scopedNode = interfaceNode.getContainingScope();
        IASNode possiblePackage = scopedNode.getParent();
        if (!(possiblePackage instanceof IPackageNode)) {
            return;
        }
        if (this.hasNamespace((IDefinitionNode)interfaceNode)) {
            return;
        }
        problems.add(new MissingNamespaceOnInterfaceLinterProblem(interfaceNode));
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IScopedNode scopedNode = functionNode.getContainingScope();
        IASNode possiblePackageOrClass = scopedNode.getParent();
        if (possiblePackageOrClass instanceof IPackageNode) {
            if (this.hasNamespace((IDefinitionNode)functionNode) || functionNode.getParent() instanceof IFunctionObjectNode) {
                return;
            }
            problems.add(new MissingNamespaceOnPackageFunctionLinterProblem(functionNode));
            return;
        }
        if (possiblePackageOrClass instanceof IClassNode) {
            if (this.hasNamespace((IDefinitionNode)functionNode) || functionNode.getParent() instanceof IFunctionObjectNode) {
                return;
            }
            problems.add(new MissingNamespaceOnMethodLinterProblem(functionNode));
            return;
        }
    }

    private void checkVariableNode(IVariableNode variableNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IScopedNode scopedNode = variableNode.getContainingScope();
        IASNode possiblePackageOrClass = scopedNode.getParent();
        if (possiblePackageOrClass instanceof IPackageNode) {
            if (this.hasNamespace((IDefinitionNode)variableNode)) {
                return;
            }
            problems.add(new MissingNamespaceOnPackageVariableLinterProblem(variableNode));
            return;
        }
        if (possiblePackageOrClass instanceof IClassNode) {
            if (this.hasNamespace((IDefinitionNode)variableNode)) {
                return;
            }
            problems.add(new MissingNamespaceOnFieldLinterProblem(variableNode));
            return;
        }
    }

    private boolean hasNamespace(IDefinitionNode node) {
        if (node instanceof BaseDefinitionNode) {
            IdentifierNode identifierNode;
            BaseDefinitionNode baseDefNode = (BaseDefinitionNode)node;
            INamespaceDecorationNode nsNode = baseDefNode.getNamespaceNode();
            if (nsNode == null) {
                return false;
            }
            return !(nsNode instanceof IdentifierNode) || !(identifierNode = (IdentifierNode)((Object)nsNode)).isImplicit();
        }
        String ns = node.getNamespace();
        return ns != null;
    }

    public static class MissingNamespaceOnClassLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing namespace on class '${className}'";
        public String className;

        public MissingNamespaceOnClassLinterProblem(IClassNode node) {
            super((ISourceLocation)node);
            this.className = node.getName();
        }
    }

    public static class MissingNamespaceOnInterfaceLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing namespace on interface '${interfaceName}'";
        public String interfaceName;

        public MissingNamespaceOnInterfaceLinterProblem(IInterfaceNode node) {
            super((ISourceLocation)node);
            this.interfaceName = node.getName();
        }
    }

    public static class MissingNamespaceOnPackageFunctionLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing namespace on package function '${functionName}'";
        public String functionName;

        public MissingNamespaceOnPackageFunctionLinterProblem(IFunctionNode node) {
            super((ISourceLocation)node);
            this.functionName = node.getQualifiedName();
        }
    }

    public static class MissingNamespaceOnMethodLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing namespace on method '${functionName}'";
        public String functionName;

        public MissingNamespaceOnMethodLinterProblem(IFunctionNode node) {
            super((ISourceLocation)node);
            this.functionName = node.getName();
        }
    }

    public static class MissingNamespaceOnPackageVariableLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing namespace on package variable '${variableName}'";
        public String variableName;

        public MissingNamespaceOnPackageVariableLinterProblem(IVariableNode node) {
            super((ISourceLocation)node);
            this.variableName = node.getQualifiedName();
        }
    }

    public static class MissingNamespaceOnFieldLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing namespace on field '${variableName}'";
        public String variableName;

        public MissingNamespaceOnFieldLinterProblem(IVariableNode node) {
            super((ISourceLocation)node);
            this.variableName = node.getName();
        }
    }
}

