/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

public class ScriptText {
    private final String m_text;
    private int[] m_lineMap;

    public ScriptText(String string) {
        this.m_text = string;
    }

    public String getLine(int n) {
        this.determineLines();
        int n2 = n - 1;
        if (n2 < 0) {
            // empty if block
        }
        int n3 = this.m_lineMap[2 * n2];
        int n4 = this.m_lineMap[2 * n2 + 1];
        String string = this.m_text.substring(n3, n4);
        return string;
    }

    public int getLineCount() {
        this.determineLines();
        return this.m_lineMap.length / 2;
    }

    private synchronized void determineLines() {
        if (this.m_lineMap != null) {
            return;
        }
        int n = ScriptText.lineCountFor(this.m_text) + 1;
        this.m_lineMap = new int[2 * n + 1];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.m_text.length();
        char c = '\u0000';
        while (n2 < n6) {
            if ((c = this.m_text.charAt(n2++)) == '\n' || c == '\r') {
                this.m_lineMap[2 * n3] = n4;
                this.m_lineMap[2 * n3 + 1] = n5;
                ++n3;
                if (c != '\r' || n2 >= n6 || this.m_text.charAt(n2) == '\n') {
                    // empty if block
                }
                n4 = ++n2;
                n5 = n2;
                continue;
            }
            ++n5;
        }
        if (n4 != n5) {
            this.m_lineMap[2 * n3] = n4;
            this.m_lineMap[2 * n3 + 1] = n5;
        }
    }

    public static int lineCountFor(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        char c = '\u0000';
        while (n < n3) {
            if ((c = string.charAt(n++)) != '\n' && c != '\r') continue;
            ++n2;
            if (c != '\r' || n >= n3 || string.charAt(n) != '\n') continue;
            ++n;
        }
        return n2;
    }
}

