/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.royale.compiler.common.IFileSpecificationGetter;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.OffsetCue;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.projects.IASProject;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.utils.FilenameNormalization;

public class IncludeHandler {
    private final IFileSpecificationGetter fileSpecGetter;
    private Tree currentNode;
    private int absoluteOffset;
    private final ImmutableList.Builder<OffsetCue> offsetCueListBuilder;
    private long timeStamp;
    private IASProject project;
    private ICompilationUnit compilationUnit;
    private boolean hasMXMLUnits = false;

    public IncludeHandler(IFileSpecificationGetter fileSpecGetter) {
        this.fileSpecGetter = fileSpecGetter;
        this.currentNode = null;
        this.absoluteOffset = 0;
        this.offsetCueListBuilder = new ImmutableList.Builder();
        this.timeStamp = 0L;
    }

    public static IncludeHandler create(IFileSpecificationGetter fileSpecGetter, int startAbsoluteOffset) {
        IncludeHandler handler = new IncludeHandler(fileSpecGetter);
        handler.absoluteOffset = startAbsoluteOffset;
        return handler;
    }

    public static IncludeHandler creatDefaultIncludeHandler() {
        return new IncludeHandler(null);
    }

    public static IncludeHandler createForASTBuilding(IFileSpecificationGetter fileSpecGetter, String sourcePath, int localOffset, int absoluteOffset) {
        IncludeHandler handler = new IncludeHandler(fileSpecGetter);
        handler.enterFile(sourcePath);
        handler.currentNode.tokenEnd = localOffset;
        handler.absoluteOffset = absoluteOffset;
        return handler;
    }

    private final IFileSpecification getFileSpec(String path) {
        IFileSpecification results = null;
        if (this.fileSpecGetter != null) {
            results = this.fileSpecGetter.getFileSpecification(path);
        }
        if (results == null) {
            results = new FileSpecification(path);
        }
        return results;
    }

    protected IFileSpecification getFileSpecificationForInclude(String includer, String includeString) {
        String sourceFileFromSourcePath;
        if (Strings.isNullOrEmpty((String)includer) || Strings.isNullOrEmpty((String)includeString)) {
            return null;
        }
        if (new File(includeString).isAbsolute()) {
            return this.getFileSpec(FilenameNormalization.normalize(includeString));
        }
        String includingFolder = FilenameNormalization.normalize(FilenameUtils.getFullPath((String)includer));
        File includedFileInDefaultFolder = new File(includingFolder, includeString);
        if (includedFileInDefaultFolder.isFile()) {
            return this.getFileSpec(FilenameNormalization.normalizeFileToPath(includedFileInDefaultFolder));
        }
        if (this.project != null && (sourceFileFromSourcePath = this.project.getSourceFileFromSourcePath(includeString)) != null && new File(sourceFileFromSourcePath).isFile()) {
            return this.getFileSpec(sourceFileFromSourcePath);
        }
        return this.getFileSpec(FilenameNormalization.normalizeFileToPath(includedFileInDefaultFolder));
    }

    public ImmutableSet<String> getIncludedFiles() {
        if (this.currentNode == null) {
            return ImmutableSet.of();
        }
        Tree root = Tree.getRoot(this.currentNode);
        ArrayList<String> result = new ArrayList<String>();
        Tree.dfs(root, result);
        result.remove(result.size() - 1);
        return ImmutableSet.copyOf(result);
    }

    public void clear() {
        this.currentNode = null;
    }

    protected String getIncludeStackTop() {
        if (this.currentNode == null) {
            return null;
        }
        return this.currentNode.filename;
    }

    public void enterFile(String filename) {
        assert (filename != null) : "Filename can't be null.";
        this.currentNode = this.currentNode == null ? new Tree(filename, null) : this.currentNode.addChild(filename);
        IFileSpecification filespec = this.getFileSpec(filename);
        long newTimeStamp = filespec.getLastModified();
        this.timeStamp = Math.max(this.timeStamp, newTimeStamp);
        this.addOffsetCue();
    }

    public void propagateLastModified(IncludeHandler childIncludeHandler) {
        this.timeStamp = Math.max(this.timeStamp, childIncludeHandler.getLastModified());
    }

    public long getLastModified() {
        return this.timeStamp;
    }

    private void addOffsetCue() {
        int adjustment = this.absoluteOffset - this.currentNode.tokenEnd;
        OffsetCue cue = new OffsetCue(this.currentNode.filename, this.absoluteOffset, adjustment);
        this.offsetCueListBuilder.add((Object)cue);
    }

    public void leaveFile() {
        this.currentNode = this.currentNode.parent;
        if (this.currentNode != null) {
            this.addOffsetCue();
        }
    }

    public void leaveFile(int endOffset) {
        int advance = endOffset - this.currentNode.tokenEnd;
        if (advance > 0) {
            this.absoluteOffset += advance;
        }
        this.leaveFile();
    }

    protected boolean isCyclicInclude(String filename) {
        assert (filename != null) : "Filename can't be null.";
        Tree cursor = this.currentNode;
        while (cursor != null) {
            if (cursor.filename.equals(filename)) {
                return true;
            }
            cursor = cursor.parent;
        }
        return false;
    }

    protected Tree getIncludeTree() {
        return Tree.getRoot(this.currentNode);
    }

    protected void onNextToken(ASToken token) {
        assert (token != null) : "ASToken can't be null.";
        if (this.currentNode != null) {
            assert (this.hasMXMLUnits || token.getEnd() >= this.currentNode.tokenEnd) : String.format("Token [%s] (line:%d, col:%d) end at '%d', but last token end at '%d': %s", token.getText(), token.getLine(), token.getColumn(), token.getEnd(), this.currentNode.tokenEnd, this.currentNode.filename);
            int advance = token.getEnd() - this.currentNode.tokenEnd;
            this.absoluteOffset += advance;
            this.currentNode.tokenEnd = token.getEnd();
            int delta = token.getStart() - this.currentNode.tokenEnd;
            int tokenAbsoluteStart = delta + this.absoluteOffset;
            int tokenLength = token.getEnd() - token.getStart();
            if (tokenLength < 0) {
                tokenLength = 0;
            }
            token.setStart(tokenAbsoluteStart);
            token.setEnd(tokenAbsoluteStart + tokenLength);
        }
    }

    public void onNextMXMLUnitData(IMXMLUnitData unitData) {
        assert (unitData != null) : "IMXMLUnitData can't be null.";
        this.hasMXMLUnits = true;
        if (this.currentNode != null) {
            int contentEnd = unitData.getContentEnd();
            int advance = contentEnd - this.currentNode.tokenEnd;
            this.absoluteOffset += advance;
            this.currentNode.tokenEnd = contentEnd;
        }
    }

    protected int getAbsoluteOffset() {
        return this.absoluteOffset;
    }

    public ImmutableList<OffsetCue> getOffsetCueList() {
        return this.offsetCueListBuilder.build();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Tree walker = this.currentNode;
        while (walker != null) {
            result.append("    ").append(walker).append("\n");
            walker = walker.parent;
        }
        return result.toString();
    }

    public final void setProjectAndCompilationUnit(IASProject project, ICompilationUnit compilationUnit) {
        this.project = project;
        this.compilationUnit = compilationUnit;
    }

    public void handleFileNotFound(IFileSpecification fileSpec) {
        if (this.project != null && this.compilationUnit != null) {
            ((CompilerProject)((Object)this.project)).addUnfoundReferencedSourceFileDependency(fileSpec.getPath(), this.compilationUnit);
        }
    }

    protected static final class Tree {
        protected final List<Tree> children = new ArrayList<Tree>();
        protected final String filename;
        private final Tree parent;
        private int tokenEnd;

        private Tree(String filename, Tree parent) {
            this.filename = filename;
            this.parent = parent;
            this.tokenEnd = 0;
        }

        private Tree addChild(String filename) {
            Tree child = new Tree(filename, this);
            this.children.add(child);
            return child;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("end", this.tokenEnd).add("file", (Object)new File(this.filename).getName()).add("children", this.children.size()).toString();
        }

        private static void dfs(Tree tree, Collection<String> result) {
            for (Tree child : tree.children) {
                Tree.dfs(child, result);
            }
            result.add(tree.filename);
        }

        private static Tree getRoot(Tree tree) {
            if (tree == null) {
                return null;
            }
            Tree result = tree;
            while (result.parent != null) {
                result = result.parent;
            }
            return result;
        }
    }
}

