/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.projects;

import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.projects.ISourceFileHandler;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.units.ResourceBundleCompilationUnit;
import org.apache.royale.compiler.units.ICompilationUnit;

public class ResourceBundleSourceFileHandler
implements ISourceFileHandler {
    public static final String EXTENSION = "properties";
    public static final ResourceBundleSourceFileHandler INSTANCE = new ResourceBundleSourceFileHandler();

    private ResourceBundleSourceFileHandler() {
    }

    @Override
    public String[] getExtensions() {
        return new String[]{EXTENSION};
    }

    @Override
    public ICompilationUnit createCompilationUnit(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, int order, String qname, String locale) {
        assert (this.needCompilationUnit(project, path, qname, locale));
        return new ResourceBundleCompilationUnit(project, path, basePriority, qname, locale);
    }

    @Override
    public boolean needCompilationUnit(CompilerProject project, String path, String qname, String locale) {
        if (project instanceof RoyaleProject) {
            return ((RoyaleProject)project).getLocales().size() > 0;
        }
        return false;
    }

    @Override
    public boolean canCreateInvisibleCompilationUnit() {
        return false;
    }
}

