/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.tabulator;

import java.awt.Color;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.PrintElementIndex;
import net.sf.jasperreports.engine.export.tabulator.BaseElementCell;
import net.sf.jasperreports.engine.export.tabulator.Cell;
import net.sf.jasperreports.engine.export.tabulator.TablePosition;
import net.sf.jasperreports.engine.export.tabulator.Tabulator;

public class TableCell {
    private final Tabulator tabulator;
    private final TablePosition position;
    private final Cell cell;
    private final JRPrintElement element;
    private int colSpan;
    private int rowSpan;
    private CellType cellType;
    private Color backcolor;
    private JRLineBox box;

    public TableCell(Tabulator tabulator, TablePosition position, Cell cell, JRPrintElement element, CellType cellType, int colSpan, int rowSpan, Color backcolor, JRLineBox box) {
        this.tabulator = tabulator;
        this.position = position;
        this.cell = cell;
        this.element = element;
        this.cellType = cellType;
        this.colSpan = colSpan;
        this.rowSpan = rowSpan;
        this.backcolor = backcolor;
        this.box = box;
    }

    public Tabulator getTabulator() {
        return this.tabulator;
    }

    public Cell getCell() {
        return this.cell;
    }

    public TablePosition getPosition() {
        return this.position;
    }

    public JRPrintElement getElement() {
        return this.element;
    }

    public CellType getCellType() {
        return this.cellType;
    }

    public void setCellType(CellType cellType) {
        this.cellType = cellType;
    }

    public int getColumnSpan() {
        return this.colSpan;
    }

    public void setColumnSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public JRLineBox getBox() {
        return this.box;
    }

    public void setBox(JRLineBox box) {
        this.box = box;
    }

    public Color getBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color backcolor) {
        this.backcolor = backcolor;
    }

    public String getElementAddress() {
        BaseElementCell elementCell = (BaseElementCell)this.cell;
        return PrintElementIndex.asAddress(elementCell.getParentIndex(), elementCell.getElementIndex());
    }

    public static enum CellType {
        COLUMN_HEADER,
        ROW_HEADER;

    }
}

