/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.lib.CLALibCBind;
import org.apache.sysds.runtime.data.Block;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LibMatrixAppend {
    public static MatrixBlock append(MatrixBlock a, MatrixBlock[] that, MatrixBlock result, boolean cbind) {
        int rlen = a.rlen;
        int clen = a.clen;
        long nonZeros = a.nonZeros;
        LibMatrixAppend.checkDimensionsForAppend(that, cbind, rlen, clen);
        for (int k = 0; k < that.length; ++k) {
            if (!(that[k] instanceof CompressedMatrixBlock)) continue;
            if (that.length == 1 && cbind) {
                return CLALibCBind.cbind(a, that[0], 1);
            }
            that[k] = CompressedMatrixBlock.getUncompressed(that[k], "Append N");
        }
        int m = cbind ? rlen : LibMatrixAppend.combinedRows(that, rlen);
        int n = cbind ? LibMatrixAppend.combinedCols(that, clen) : clen;
        long nnz = LibMatrixAppend.calculateCombinedNNz(that, nonZeros);
        boolean shallowCopy = nonZeros == nnz;
        boolean sp = MatrixBlock.evalSparseFormatInMemory(m, n, nnz);
        if (result == null) {
            result = new MatrixBlock(m, n, sp, nnz);
        } else {
            result.reset(m, n, sp, nnz);
        }
        if (!result.sparse && nnz != 0L) {
            LibMatrixAppend.appendDense(a, that, result, cbind, rlen, m, n);
        } else if (nnz != 0L) {
            LibMatrixAppend.appendSparse(a, that, result, cbind, rlen, clen, nnz, shallowCopy);
        }
        result.nonZeros = nnz;
        return result;
    }

    private static void appendSparse(MatrixBlock a, MatrixBlock[] that, MatrixBlock result, boolean cbind, int rlen, int clen, long nnz, boolean shallowCopy) {
        int off;
        result.allocateSparseRowsBlock();
        if (cbind && nnz > (long)rlen && !shallowCopy && result.getSparseBlock() instanceof SparseBlockMCSR) {
            SparseBlock sblock = result.getSparseBlock();
            for (int i = 0; i < result.rlen; ++i) {
                sblock.allocate(i, LibMatrixAppend.computeNNzRow(that, i, a));
            }
        }
        result.appendToSparse(a, 0, 0, !shallowCopy);
        if (cbind) {
            off = clen;
            for (int i = 0; i < that.length; ++i) {
                result.appendToSparse(that[i], 0, off);
                off += that[i].clen;
            }
        } else {
            off = rlen;
            for (int i = 0; i < that.length; ++i) {
                result.appendToSparse(that[i], off, 0);
                off += that[i].rlen;
            }
        }
    }

    private static void appendDense(MatrixBlock a, MatrixBlock[] that, MatrixBlock result, boolean cbind, int rlen, int m, int n) {
        if (cbind) {
            DenseBlock resd = result.allocateBlock().getDenseBlock();
            MatrixBlock[] in = (MatrixBlock[])ArrayUtils.addAll((Object[])new MatrixBlock[]{a}, (Object[])that);
            for (int i = 0; i < m; ++i) {
                int off = 0;
                for (int k = 0; k < in.length; ++k) {
                    if (!in[k].isEmptyBlock(false)) {
                        Block src;
                        if (in[k].sparse) {
                            src = in[k].sparseBlock;
                            if (!((SparseBlock)src).isEmpty(i)) {
                                int srcpos = ((SparseBlock)src).pos(i);
                                int srclen = ((SparseBlock)src).size(i);
                                int[] srcix = ((SparseBlock)src).indexes(i);
                                double[] srcval = ((SparseBlock)src).values(i);
                                double[] resval = resd.values(i);
                                int resix = resd.pos(i, off);
                                for (int j = srcpos; j < srcpos + srclen; ++j) {
                                    resval[resix + srcix[j]] = srcval[j];
                                }
                            }
                        } else {
                            src = in[k].getDenseBlock();
                            double[] srcval = ((DenseBlock)src).values(i);
                            double[] resval = resd.values(i);
                            System.arraycopy(srcval, ((DenseBlock)src).pos(i), resval, resd.pos(i, off), in[k].clen);
                        }
                    }
                    off += in[k].clen;
                }
            }
        } else {
            result.copy(0, rlen - 1, 0, n - 1, a, false);
            int off = rlen;
            for (int i = 0; i < that.length; ++i) {
                result.copy(off, off + that[i].rlen - 1, 0, n - 1, that[i], false);
                off += that[i].rlen;
            }
        }
    }

    public static void checkDimensionsForAppend(MatrixBlock[] in, boolean cbind, int rlen, int clen) {
        if (cbind) {
            for (int i = 0; i < in.length; ++i) {
                if (in[i].rlen == rlen) continue;
                throw new DMLRuntimeException("Invalid nRow dimension for append cbind: was " + in[i].rlen + " should be: " + rlen);
            }
        } else {
            for (int i = 0; i < in.length; ++i) {
                if (in[i].clen == clen) continue;
                throw new DMLRuntimeException("Invalid nCol dimension for append rbind: was " + in[i].clen + " should be: " + clen);
            }
        }
    }

    private static int combinedRows(MatrixBlock[] that, int rlen) {
        int r = rlen;
        for (MatrixBlock b : that) {
            r += b.rlen;
        }
        return r;
    }

    private static int combinedCols(MatrixBlock[] that, int clen) {
        int c = clen;
        for (MatrixBlock b : that) {
            c += b.clen;
        }
        return c;
    }

    private static long calculateCombinedNNz(MatrixBlock[] that, long nonZeros) {
        long nnz = nonZeros;
        for (MatrixBlock b : that) {
            nnz += b.nonZeros;
        }
        return nnz;
    }

    private static int computeNNzRow(MatrixBlock[] that, int row, MatrixBlock a) {
        int lnnz = (int)a.recomputeNonZeros(row, row, 0, a.clen - 1);
        for (MatrixBlock b : that) {
            lnnz = (int)((long)lnnz + b.recomputeNonZeros(row, row, 0, b.clen - 1));
        }
        return lnnz;
    }
}

