/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.codegen.CodegenUtils;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.FormatIdentifyer;
import org.apache.sysds.runtime.iogen.SampleProperties;
import org.apache.sysds.runtime.iogen.codegen.FrameCodeGen;
import org.apache.sysds.runtime.iogen.codegen.MatrixCodeGen;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class GenerateReader {
    protected static final Log LOG = LogFactory.getLog((String)GenerateReader.class.getName());
    protected CustomProperties properties;
    protected FormatIdentifyer formatIdentifyer;

    public GenerateReader(SampleProperties sampleProperties) throws Exception {
        this.formatIdentifyer = sampleProperties.getDataType().isMatrix() ? new FormatIdentifyer(sampleProperties.getSampleRaw(), sampleProperties.getSampleMatrix()) : new FormatIdentifyer(sampleProperties.getSampleRaw(), sampleProperties.getSampleFrame());
        this.properties = this.formatIdentifyer.getFormatProperties();
        if (this.properties == null) {
            throw new Exception("The file format couldn't recognize!!");
        }
        if (sampleProperties.getDataType().isFrame()) {
            this.properties.setSchema(sampleProperties.getSampleFrame().getSchema());
        }
    }

    public String getRandomClassName() {
        Random r = new Random();
        int low = 0;
        int high = 100000000;
        int result = r.nextInt(high - low) + low;
        return "GIOReader_" + result;
    }

    public CustomProperties getProperties() {
        return this.properties;
    }

    public static class GenerateReaderFrame
    extends GenerateReader {
        private FrameReader frameReader;

        public GenerateReaderFrame(SampleProperties sampleProperties) throws Exception {
            super(sampleProperties);
        }

        public GenerateReaderFrame(String sampleRaw, FrameBlock sampleFrame, boolean parallel) throws Exception {
            super(new SampleProperties(sampleRaw, sampleFrame));
            this.properties.setParallel(parallel);
        }

        public FrameReader getReader() throws Exception {
            String className = this.getRandomClassName();
            FrameCodeGen src = new FrameCodeGen(this.properties, className);
            Class[] cArg = new Class[]{CustomProperties.class};
            String srcJava = src.generateCodeJava(this.formatIdentifyer);
            this.frameReader = (FrameReader)CodegenUtils.compileClass(className, srcJava).getDeclaredConstructor(cArg).newInstance(this.properties);
            return this.frameReader;
        }
    }

    public static class GenerateReaderMatrix
    extends GenerateReader {
        private MatrixReader matrixReader;

        public GenerateReaderMatrix(SampleProperties sampleProperties) throws Exception {
            super(sampleProperties);
        }

        public GenerateReaderMatrix(String sampleRaw, MatrixBlock sampleMatrix, boolean parallel) throws Exception {
            super(new SampleProperties(sampleRaw, sampleMatrix));
            this.properties.setParallel(parallel);
        }

        public MatrixReader getReader() throws Exception {
            String className = this.getRandomClassName();
            MatrixCodeGen src = new MatrixCodeGen(this.properties, className);
            Class[] cArg = new Class[]{CustomProperties.class};
            String srcJava = src.generateCodeJava(this.formatIdentifyer);
            this.matrixReader = (MatrixReader)CodegenUtils.compileClass(className, srcJava).getDeclaredConstructor(cArg).newInstance(this.properties);
            return this.matrixReader;
        }
    }
}

