/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.LikeDocument;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Like
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Like> _DESERIALIZER = JsonpDeserializer.lazy(Like::buildLikeDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Like(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private Like(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Like of(Function<Builder, ObjectBuilder<Like>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDocument() {
        return this._kind == Kind.Document;
    }

    public LikeDocument document() {
        return (LikeDocument)TaggedUnionUtils.get(this, Kind.Document);
    }

    public boolean isText() {
        return this._kind == Kind.Text;
    }

    public String text() {
        return (String)TaggedUnionUtils.get(this, Kind.Text);
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Text: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    private static JsonpDeserializer<Like> buildLikeDeserializer() {
        return new UnionDeserializer.Builder(Like::new, false).addMember((Object)Kind.Document, LikeDocument._DESERIALIZER).addMember((Object)Kind.Text, JsonpDeserializer.stringDeserializer()).build();
    }

    public static enum Kind {
        Document,
        Text;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Like> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Like> document(LikeDocument v) {
            this._kind = Kind.Document;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Like> document(Function<LikeDocument.Builder, ObjectBuilder<LikeDocument>> fn) {
            return this.document(fn.apply(new LikeDocument.Builder()).build());
        }

        public ObjectBuilder<Like> text(String v) {
            this._kind = Kind.Text;
            this._value = v;
            return this;
        }

        @Override
        public Like build() {
            this._checkSingleUse();
            return new Like(this);
        }
    }
}

