/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree.table;

import java.util.Iterator;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.table.ITreeDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.table.NodeModel;
import org.apache.wicket.model.IModel;

public abstract class TreeDataProvider<T>
implements ITreeDataProvider<T> {
    private static final long serialVersionUID = 1L;
    private final ITreeProvider<T> provider;
    private transient Branch<T> currentBranch;
    private transient Branch<T> previousBranch;
    private int size = -1;

    protected TreeDataProvider(ITreeProvider<T> provider) {
        this.provider = provider;
    }

    public long size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator<T> iterator = this.iterator(0L, Integer.MAX_VALUE);
            while (iterator.hasNext()) {
                iterator.next();
                ++this.size;
            }
        }
        return this.size;
    }

    public Iterator<? extends T> iterator(long first, long count) {
        this.currentBranch = new Branch<T>(null, this.provider.getRoots());
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                while (TreeDataProvider.this.currentBranch != null) {
                    if (TreeDataProvider.this.currentBranch.hasNext()) {
                        return true;
                    }
                    TreeDataProvider.this.currentBranch = TreeDataProvider.this.currentBranch.parent;
                }
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                Object next = TreeDataProvider.this.currentBranch.next();
                TreeDataProvider.this.previousBranch = TreeDataProvider.this.currentBranch;
                if (TreeDataProvider.this.iterateChildren(next)) {
                    TreeDataProvider.this.currentBranch = new Branch(TreeDataProvider.this.previousBranch, TreeDataProvider.this.provider.getChildren(next));
                }
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        int i = 0;
        while ((long)i < first) {
            iterator.next();
            ++i;
        }
        return iterator;
    }

    protected abstract boolean iterateChildren(T var1);

    @Override
    public NodeModel<T> model(T object) {
        return this.previousBranch.wrapModel(this.provider.model(object));
    }

    public void detach() {
        this.currentBranch = null;
        this.previousBranch = null;
        this.size = -1;
    }

    private static class Branch<T>
    implements Iterator<T> {
        private Branch<T> parent;
        private Iterator<? extends T> children;

        Branch(Branch<T> parent, Iterator<? extends T> children) {
            this.parent = parent;
            this.children = children;
        }

        NodeModel<T> wrapModel(IModel<T> model) {
            boolean[] branches = new boolean[this.getDepth()];
            Branch<T> branch = this;
            for (int c = branches.length - 1; c >= 0; --c) {
                branches[c] = branch.hasNext();
                branch = branch.parent;
            }
            return new NodeModel<T>(model, branches);
        }

        int getDepth() {
            if (this.parent == null) {
                return 1;
            }
            return this.parent.getDepth() + 1;
        }

        @Override
        public boolean hasNext() {
            return this.children.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            return this.children.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

